/// Files: arch/x86/kvm/svm/nested.c arch/x86/kvm/svm.c arch/x86/include/asm/svm.h
/// Fix: c7dfa4009965a9b2d7b329ee970eb8da0d32f0bc
/// Fixes: 89c8a4984fc98e625517bfe5083342d77ee35811

virtual detect

@nested@
expression E;
@@

#define VIRTUAL_VMLOAD_VMSAVE_ENABLE_MASK E

@fix_INTERCEPT_VMLOAD exists@
identifier c;
@@

recalc_intercepts(...)
{
	...
(
*	vmcb_set_intercept(c, INTERCEPT_VMLOAD);
|
*	c->intercept |= (1ULL << INTERCEPT_VMLOAD);
)
	...
}

@fix_INTERCEPT_VMSAVE exists@
identifier c;
@@

recalc_intercepts(...)
{
	...
(
*	vmcb_set_intercept(..., INTERCEPT_VMSAVE);
|
*	c->intercept |= (1ULL << INTERCEPT_VMSAVE);
)
	...
}

@err depends on nested && (!fix_INTERCEPT_VMLOAD || !fix_INTERCEPT_VMSAVE) exists@
position p;
@@

recalc_intercepts@p(...)
{
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-3656')
