/// Files: fs/xfs/xfs_inode.c
/// Fix: 01ea173e103edd5ec41acec65b9261b87e123fc2
/// Fixes: v2.6.12-rc2

virtual detect

@err@
identifier ip, inode, mode, pip, cr;
type T;
position p;
@@

\(xfs_ialloc\|xfs_init_new_inode\)(...)
{
	...
(
*	ip->i_d.di_mode =@p (T)mode;
|
*	inode->i_mode =@p mode;
)
	...
(
*	ip->i_d.di_uid = current_fsuid(cr);
|
*	ip->i_d.di_uid = xfs_kuid_to_uid(current_fsuid());
|
*	ip->i_d.di_uid = current_fsuid();
|
*	inode->i_uid = current_fsuid();
)
	...
*	XFS_INHERIT_GID(pip, ...)
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-4037')
