/// Files: net/tipc/crypto.c
/// Fix: fa40d9734a57bcbfa79a280189799f76c88f7bb0
/// Fixes: 1ef6f7c9390ff5308c940ff8d0a53533a4673ad9

virtual detect

@err_tipc_crypto_key_rcv_data_size@
identifier skey, size;
position p;
@@

tipc_crypto_key_rcv(...)
{
	... when != size < sizeof(struct tipc_aead_key) + TIPC_AEAD_KEYLEN_MIN
	memcpy@p(skey->key, ..., skey->keylen);
	...
}

@err_tipc_crypto_key_rcv_key_size@
identifier skey, size, keylen;
position p;
@@

tipc_crypto_key_rcv(...)
{
	... when != size != keylen + sizeof(struct tipc_aead_key) || keylen > TIPC_AEAD_KEY_SIZE_MAX
	memcpy@p(skey->key, ..., skey->keylen);
	...
}

@script:python depends on detect@
p << err_tipc_crypto_key_rcv_data_size.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-43267')

@script:python depends on detect@
p << err_tipc_crypto_key_rcv_key_size.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-43267')
