/// Files: drivers/virt/acrn/hsm.c
/// Fix: ecd1735f14d6ac868ae5d8b7a2bf193fa11f388b
/// Fixes: 9c5137aedd112f78a968bdd2325de2ea06df46c0
/// Version: 1.1.0

virtual detect

@err_acrn_ioctl_create_vm exists@
identifier vm_param;
position p;
@@

acrn_dev_ioctl(...)
{
	...
	vm_param = memdup_user(...);
	...
*	if ((vm_param->reserved0 | vm_param->reserved1) != 0)
*		return -EINVAL;@p
	...
}

@err_acrn_ioctl_set_vcpu_regs_1 exists@
identifier cpu_regs, i;
position p;
@@

acrn_dev_ioctl(...)
{
	...
	cpu_regs = memdup_user(...);
	...
	for (i = 0; i < ARRAY_SIZE(cpu_regs->reserved); i++)
*		if (cpu_regs->reserved[i])
* 			return -EINVAL;@p
	...
}

@err_acrn_ioctl_set_vcpu_regs_2 exists@
identifier cpu_regs, i;
position p;
@@

acrn_dev_ioctl(...)
{
	...
	cpu_regs = memdup_user(...);
	...
	for (i = 0; i < ARRAY_SIZE(cpu_regs->vcpu_regs.reserved_32); i++)
*		if (cpu_regs->vcpu_regs.reserved_32[i])
* 			return -EINVAL;@p
	...
}

@err_acrn_ioctl_set_vcpu_regs_3 exists@
identifier cpu_regs, i;
position p;
@@

acrn_dev_ioctl(...)
{
	...
	cpu_regs = memdup_user(...);
	...
	for (i = 0; i < ARRAY_SIZE(cpu_regs->vcpu_regs.reserved_64); i++)
*		if (cpu_regs->vcpu_regs.reserved_64[i])
* 			return -EINVAL;@p
	...
}

@err_acrn_ioctl_set_vcpu_regs_4 exists@
identifier cpu_regs, i;
position p;
@@

acrn_dev_ioctl(...)
{
	...
	cpu_regs = memdup_user(...);
	...
	for (i = 0; i < ARRAY_SIZE(cpu_regs->vcpu_regs.gdt.reserved); i++)
*		if (cpu_regs->vcpu_regs.gdt.reserved[i] | cpu_regs->vcpu_regs.idt.reserved[i])
* 			return -EINVAL;@p
	...
}

@script:python depends on detect@
p << err_acrn_ioctl_create_vm.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-1651')

@script:python depends on detect@
p << err_acrn_ioctl_set_vcpu_regs_1.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-1651')

@script:python depends on detect@
p << err_acrn_ioctl_set_vcpu_regs_2.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-1651')

@script:python depends on detect@
p << err_acrn_ioctl_set_vcpu_regs_3.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-1651')

@script:python depends on detect@
p << err_acrn_ioctl_set_vcpu_regs_4.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-1651')
