/// Files: fs/nfs/dir.c
/// Fix: ac795161c93699d600db16c1a8cc23a65a1eceaf
/// Fixes: 0dd2b474d0b69d58859399b1df7fdc699ea005d4

virtual detect

@fix exists@
identifier dir, dentry, no_open, res, inode, lookup_flags;
@@

nfs_atomic_open(struct inode *dir, struct dentry *dentry, ...)
{
	...
no_open:
	res = nfs_lookup(dir, dentry, ...);
	...
	if (!res) {
		inode = d_inode(dentry);
		//...
		//(lookup_flags & LOOKUP_DIRECTORY) && inode && !S_ISDIR(inode->i_mode)
		...
		res = ERR_PTR(-ENOTDIR);
		...
	} else if (!IS_ERR(res)) {
		inode = d_inode(res);
		//...
		//(lookup_flags & LOOKUP_DIRECTORY) && inode && !S_ISDIR(inode->i_mode)
		...
		res = ERR_PTR(-ENOTDIR);
		...
	}
	...
}

@err depends on !fix@
identifier dir, dentry, no_open;
position p;
@@

nfs_atomic_open(struct inode *dir, struct dentry *dentry, ...)
{
	...
no_open:
*	res = nfs_lookup@p(dir, dentry, ...);
	...
}


@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-24448')
