/// Files: net/netfilter/nf_tables_api.c include/net/netfilter/nf_tables.h
/// Fix: 7e6bc1f6cabcd30aba0b11219d8e01b952eacbb6
/// Fixes: 7d7402642eaf385aef0772eff5a35e34fc4995d7

virtual detect

@nft_set_elem_varlen@
identifier buf, val, priv;
symbol key;
typedef u32;
@@

struct nft_set_elem {
*	union {
*		u32	buf[NFT_DATA_VALUE_MAXLEN / sizeof(u32)];
*		struct nft_data val;
*	} key;
	...
        void	*priv;
};

@err_nft_setelem_parse_data depends on nft_set_elem_varlen@
identifier set, desc;
position p;
@@

nft_setelem_parse_data(...,
		       struct nft_set *set,
		       struct nft_data_desc *desc,
		       ...)
{
	...
*	if (desc->type !=@p NFT_DATA_VERDICT && desc->len != set->dlen) {
*		nft_data_release(..., desc->type);
*		return ...;
	}
	...
}

@err_nft_add_set_elem depends on nft_set_elem_varlen@
identifier set, desc, err_parse_data;
position p;
@@

nft_add_set_elem(...,
		 struct nft_set *set,
		 ...)
{
	...
*	if (set->dtype !=@p NFT_DATA_VERDICT && desc.len != set->dlen)
*		goto err_parse_data;
	...
}


@script:python depends on detect@
p << err_nft_setelem_parse_data.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-34918')

@script:python depends on detect@
p << err_nft_add_set_elem.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-34918')
