/// Files: net/wireless/scan.c net/wireless/core.h include/net/cfg80211.h
/// Fix: 0b7808818cb9df6680f98996b8e9a439fa7bcc2f
/// Fixes: a3584f56de1c808d4383a275b4a74467b19e5645
/// Version: 1.0.7

virtual detect

@cfg80211_internal_bss@
symbol transmitted_bss, pub;
@@

struct cfg80211_internal_bss {
	...
	struct cfg80211_bss *transmitted_bss;
	...
	struct cfg80211_bss pub;
};

@cfg80211_bss@
symbol transmitted_bss;
@@

struct cfg80211_bss {
	...
	struct cfg80211_bss *transmitted_bss;
	...
};

@err_bss_ref_get depends on cfg80211_internal_bss || cfg80211_bss@
identifier bss, pub;
position p;
@@

bss_ref_get(...)
{
	...
*	if (\(bss->transmitted_bss\|bss->pub.transmitted_bss\)) {
*		bss = container_of(\(bss->transmitted_bss\|bss->pub.transmitted_bss\),
*				   struct cfg80211_internal_bss,
*				   pub);
*		bss->refcount++;@p
*	}
	...
}

@err_cfg80211_bss_update depends on cfg80211_internal_bss || cfg80211_bss@
identifier new;
position p;
@@

cfg80211_bss_update(...)
{
	...
*	new->refcount =@p 1;
	... when != new->pub.transmitted_bss = NULL;
	    when != new->transmitted_bss = NULL;
}

@err_cfg80211_inform_single_bss_data depends on cfg80211_internal_bss || cfg80211_bss@
identifier rdev, res;
position p;
@@

cfg80211_inform_single_bss_data(...)
{
	...
*	if (__cfg80211_unlink_bss(rdev, res))
*		rdev->bss_generation++;@p
	...
}

@script:python depends on detect@
p << err_bss_ref_get.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-42720')

@script:python depends on detect@
p << err_cfg80211_bss_update.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-42720')

@script:python depends on detect@
p << err_cfg80211_inform_single_bss_data.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-42720')
