/// Files: fs/overlayfs/copy_up.c fs/overlayfs/super.c
/// Fix: 4f11ada10d0ad3fd53e2bd67806351de63a4f9c3
/// Fixes: 459c7c565ac36ba09ffbf24231147f408fde4203

virtual detect

@userns_mount@
symbol ovl_fs_type;
@@

struct file_system_type ovl_fs_type = {
	...,
*	.fs_flags = FS_USERNS_MOUNT,
	...
};

@err depends on userns_mount@
identifier ctx, dentry, flags;
position p;
@@

ovl_copy_up_one(..., struct dentry *dentry, int flags)
{
	...
*	vfs_getattr(..., &ctx.stat, STATX_BASIC_STATS, AT_STATX_SYNC_AS_STAT)
	... when != if (!kuid_has_mapping(current_user_ns(), ctx.stat.uid) || !kgid_has_mapping(current_user_ns(), ctx.stat.gid)) return -EOVERFLOW;
*	ovl_need_meta_copy_up@p(dentry, ctx.stat.mode, flags)
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2023-0386')
