/// Files: net/sctp/bind_addr.c
/// Fix: 458e279f861d3f61796894cd158b780765a1569f
/// Fixes: v2.6.12-rc2

virtual detect

@fix@
symbol out;
identifier error, dest;
@@

sctp_bind_addr_copy(...)
{
	...
	if (list_empty(&dest->address_list))
		error = -ENETUNREACH;
out:
	if (error)
		sctp_bind_addr_clean(dest);
	...
}


@err depends on !fix@
symbol out;
identifier error, dest;
position p;
@@

sctp_bind_addr_copy(...)
{
	...
out:
*	if (error@p)
*		sctp_bind_addr_clean(dest);
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2023-1074')
