/// Files: net/netfilter/ipset/ip_set_hash_netportnet.c
/// Fix: 050d91c03b28ca479df13dfb02bcd2c60dd6a878
/// Fixes: 886503f34d63e681662057448819edb5b1057a97

virtual detect

@cmp1@
identifier tb, e;
@@

hash_netportnet4_uadt(..., struct nlattr *tb[], ...)
{
	...
	if (tb[IPSET_ATTR_CIDR]) {
		e.cidr[0] = nla_get_u8(tb[IPSET_ATTR_CIDR]);
*		if (e.cidr[0] > HOST_MASK)
			return -IPSET_ERR_INVALID_CIDR;
	}
	...
}

@cmp2@
identifier tb, e;
@@

hash_netportnet4_uadt(..., struct nlattr *tb[], ...)
{
	...
 	if (tb[IPSET_ATTR_CIDR2]) {
 		e.cidr[1] = nla_get_u8(tb[IPSET_ATTR_CIDR2]);
*		if (e.cidr[1] > HOST_MASK)
 			return -IPSET_ERR_INVALID_CIDR;
 	}
	...
}

@cmp3@
identifier tb, e;
@@

hash_netportnet6_uadt(..., struct nlattr *tb[], ...)
{
	...
 	if (tb[IPSET_ATTR_CIDR]) {
 		e.cidr[0] = nla_get_u8(tb[IPSET_ATTR_CIDR]);
*		if (e.cidr[0] > HOST_MASK)
 			return -IPSET_ERR_INVALID_CIDR;
 	}
	...
}

@cmp4@
identifier tb, e;
@@

hash_netportnet6_uadt(..., struct nlattr *tb[], ...)
{
	...
 	if (tb[IPSET_ATTR_CIDR2]) {
 		e.cidr[1] = nla_get_u8(tb[IPSET_ATTR_CIDR2]);
*		if (e.cidr[1] > HOST_MASK)
 			return -IPSET_ERR_INVALID_CIDR;
 	}
	...
}

@fix@
@@

#define IP_SET_HASH_WITH_NET0

@err depends on (cmp1 || cmp2 || cmp3 || cmp4) && !fix@
position p;
@@

#define IPSET_NET_COUNT 2@p

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2023-42753')
