# ruff: noqa: N802, N999, PYI021
from typing import Any

from . import enums

class ConnectionState:
    value__: enums.ConnectionState

class IDataReader:
    @property
    def IsClosed(self) -> bool: ...
    @property
    def FieldCount(self) -> int: ...
    def Close(self) -> None: ...
    def ReadOuterXml(self) -> str: ...
    def GetName(self, idx: int) -> str: ...
    def GetFieldType(self, idx: int) -> ReaderType: ...
    def __getitem__(self, idx: int) -> Any: ...
    def Read(self) -> bool: ...

class XmlReader(IDataReader): ...

class ReaderType:
    """Actually just called Type, but prefix for clarity."""

    def ToString(self) -> str: ...

class AdomdDataReader(IDataReader):
    @property
    def FieldCount(self) -> int: ...

class AdomdCommand:
    def __init__(self, query: str, conn: AdomdConnection) -> None: ...
    def ExecuteXmlReader(self) -> XmlReader: ...
    def ExecuteReader(self) -> AdomdDataReader: ...
    def ExecuteNonQuery(self) -> int: ...

class AdomdConnection:
    @property
    def State(self) -> ConnectionState: ...
    @property
    def ConnectionString(self) -> str: ...
    def __init__(self, conn_str: str) -> None: ...
    def Open(self) -> None: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def Clone(self) -> AdomdConnection: ...

class AdomdErrorResponseException(BaseException):
    Message: str

class AdomdTransaction: ...

class AdomdUnknownResponseException(BaseException):
    Message: str
