import json
import math
import random
from collections import defaultdict
from os import path

from Chessnut import Game

ERROR = "ERROR"
DONE = "DONE"
INACTIVE = "INACTIVE"
ACTIVE = "ACTIVE"
WHITE = "white"

OPENINGS = [
    "rnbqk1nr/ppppppbp/6p1/8/3P4/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqk1nr/ppp1bpp1/4p3/3p3p/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqk1nr/pppp1ppp/2n5/4N3/4P3/8/PPPPBbPP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/1ppp1ppp/p1n5/8/4p3/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp1N1/2B1P3/8/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "r1bqk1nr/pppp1ppp/2n5/8/1bBpP3/5N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1bqk1nr/pppp1ppp/2n5/2b5/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/5np1/2pP4/8/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 2 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rn1qk1nr/pbppbppp/1p2p3/8/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/pppp2pp/4pn2/6B1/3Pp3/2N5/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/4p3/3p4/6n1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/pppnpp1p/3p1np1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/4P3/2NP1N2/PPP2PPP/R1BQKB1R w KQkq - 2 5",
    "r2qkbnr/pp1npppp/3p4/2p5/4P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP4/4PN2/PP3PPP/RNBQKB1R w KQ - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w - - 6 5",
    "rn1qkbnr/pp1bpppp/2p5/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/1p1p1ppp/p1n1p3/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppppbppp/5n2/3Np3/2P5/4P3/PP1P1PPP/R1BQKBNR w KQkq - 1 5",
    "rnb1kbnr/pp2pppp/2p5/q7/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/n7/2p3B1/3PP3/5N2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n2n2/2p1p3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pp1ppp1p/6p1/1Bp5/3nPP2/2N5/PPPP2PP/R1BQK1NR w KQkq - 2 5",
    "rnb1k2r/ppppqppp/4pn2/8/1bPP4/5N2/PP1BPPPP/RN1QKB1R w KQkq - 5 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/8/2N5/PPP1PPPP/R1BQKBNR w KQkq - 3 5",
    "rnbqkb1r/ppp2ppp/3p1n2/8/3QP3/5N2/PPP2PPP/RNB1KB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/2P1PN2/PP1PBPPP/RNBQK2R w KQ - 3 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/pB1ppp1p/1pp3p1/8/3PP3/8/PPP2PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/1P4P1/PBPPPPBP/RN1QK1NR w KQkq - 3 5",
    "rnbqkb1r/ppp1pppp/5n2/8/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/1pp1pppp/8/p2p4/3PnP2/4P3/PPPN2PP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkb1r/ppp1ppp1/5n2/3p3p/8/6P1/PPPPPPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/4p3/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp2pp1p/3p2p1/8/2Pp4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/4N3/5N2/PPPP1PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/3P1B2/2N1P3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 3 5",
    "rnbqkb1r/1ppp1ppp/4pn2/8/1p6/P4N2/1BPPPPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/4Pp2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp3pp/3p4/5p2/3NpP2/4P3/PPPP2PP/RNBQKB1R w KQkq - 0 5",
    "rnb1kbnr/ppp2ppp/5q2/3p4/4p3/1PP5/P2PPPPP/RNBQKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQ - 3 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/8/7P/PPP1PPP1/RNBQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/1p1npppp/2pp4/p7/8/5PPN/PPPPP1BP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 2 5",
    "r1bqkbnr/pppp1ppp/8/1B6/3pP3/8/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/p1p2ppp/1p2pn2/3p4/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/4p3/3n4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/3p1n2/1Bp5/4P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 4 5",
    "rnbqkbnr/pp3ppp/8/3pp2P/8/8/PPPP1PP1/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp3pp/3p1n2/4pp2/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2ppP3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/5np1/2pP4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/pp3ppp/8/2pp4/3P4/8/PPPN1PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/2BpP3/5N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/8/1P2P3/PBPPNPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk1nr/ppp1ppbp/6p1/3p4/4P3/3P1N2/PPP1BPPP/RNBQK2R w KQkq - 0 5",
    "rnbqkbn1/ppppppp1/8/8/8/5NP1/PPPPPPB1/RNBQK2r w Qq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/8/4PN2/PPPPBPPP/RNBQ1RK1 w kq - 2 5",
    "rnbqkbnr/pp1p1ppp/4p3/8/2p5/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppbppp/4pn2/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQ - 1 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/8/5N1P/PPPP1PP1/RNBQKB1R w KQkq - 1 5",
    "r1bqk1nr/ppp2ppp/2np4/1Bb1p3/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQ - 3 5",
    "rnbqkb1r/ppp1pppp/1n1p4/4P3/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2P5/2NP1N2/PP2PPPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppppb1pp/4pn2/5p2/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 4 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/8/1P4PB/P1PPPP1P/RNBQK1NR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/4PN2/PPP1BPPP/RNBQK2R w KQ - 5 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/pp2ppp1/2p5/3pPb1p/3P3P/8/PPP2PP1/RNBQKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQ - 4 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "rnbqkbnr/pp3pp1/3p3p/2p1p3/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3P4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppppppbp/6p1/3nP3/8/1P6/PBPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P1P2/8/PPP3PP/RNBQKBNR w KQkq - 1 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "r1bqkb1r/1ppp1ppp/p1n2n2/4p3/B3P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppp2ppp/3p1n2/2b1p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQ - 3 5",
    "rnb1kb1r/ppp2ppp/3qpn2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/p2ppppp/2p5/1p1nP3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/ppp2pp1/3bp3/3p3p/3P4/2P3B1/PP2PPPP/RN1QKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2P5/3P1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/1Bp5/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 2 5",
    "rnbqkb1r/pp2pppp/3p1n2/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/2P5/8/PP1QPPPP/RNB1KBNR w KQkq - 3 5",
    "rnbqk2r/ppp1ppbp/5np1/3p2B1/3P4/2P5/PP1NPPPP/R2QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/8/3P2P1/PP2PP1P/RNBQKBNR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQ - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/2PP2b1/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppnnppp/3pp3/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnq1kb1r/ppp1pppp/5n2/3p1b2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "rnbqk1nr/ppp2pbp/3pp1p1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/p1ppppbp/1p3np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/6pn/2p5/3PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkbnr/pp4pp/8/2pppp2/8/4PPK1/PPPP2PP/RNBQ1BNR w kq - 0 5",
    "rnbqkb1r/p2ppppp/5n2/2p5/8/5NP1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 3 5",
    "rnbqkb1r/ppp2ppp/3p4/8/4n3/5N2/PPPP1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp2p1p/3p1pp1/8/8/1P3N2/P1PPPPPP/RN1QKB1R w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/4pn2/1p6/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppppb1pp/4pn2/5p2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "rnbqk2r/ppp1ppbp/3p1np1/6B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pb1ppppp/1p3n2/2pP4/4P3/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 2 5",
    "rn1qkbnr/ppp2ppp/8/3pp3/8/5BP1/PPPPPP1P/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/1pp2ppp/p1p5/4p3/4P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/2PP4/2N5/PP2PPPP/R2QKBNR w KQkq - 4 5",
    "rnbqkbnr/1p2pppp/p2p4/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqk1nr/ppp1ppbp/2np2p1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p1b2/8/1P1P1N2/PBP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P4/5NB1/PPP1PPPP/RN1QKB1R w KQkq - 4 5",
    "rnbqk2r/ppp1bppp/3ppn2/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4PP2/2NP4/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/4pn2/3p2B1/1bPP4/5N2/PP2PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pbp1pppp/1p1p1n2/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/2P1p3/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 0 5",
    "r2qkbnr/pb1ppppp/1pn5/2p5/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3PP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/ppp2ppp/2n1pn2/3p4/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 4 5",
    "r1bqkb1r/pp1npppp/2p2n2/3p2B1/3P4/2N2P2/PPP1P1PP/R2QKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/P3PN2/1PP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/1P4P1/PBPPPPBP/RN1QK1NR w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/3P1N2/PPPN1PPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2n2n2/8/8/2N5/PPPP1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/pppp2pp/4pn2/5p2/1bPP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 2 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/3P4/2P3P1/PP2PPBP/RNBQK1NR w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/2P5/1P2P3/PB1P1PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/2p2n2/3p4/5P2/4PN2/PPPPB1PP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/8/5NP1/PPPPPPBP/RNBQ1K1R w kq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/4PN2/PPP1BPPP/RNBQK2R w KQkq - 2 5",
    "r3kbnr/pppqpppp/2n5/3p1b2/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "rnbqkb1r/ppp2p1p/5pp1/3p4/3P4/4P3/PPP2PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp1pppp/8/8/4P3/2n5/PP1P1PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r2qkbnr/1bpppppp/ppn5/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 1 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/3ppn2/2p5/2B1P3/2PP4/PP3PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P1B2/5N2/PPPQPPPP/RN2KB1R w KQkq - 2 5",
    "r1bqk2r/ppppbppp/2n2n2/4p3/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 6 5",
    "r1bqkbnr/ppp3pp/2n2p2/3pp3/3P4/1P3N2/PBP1PPPP/RN1QKB1R w KQkq - 0 5",
    "r1b1kbnr/ppqnpppp/2pp4/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "r1bqkbnr/pppp1ppp/6n1/3Pp3/4P3/5N2/PPP2PPP/RNBQKB1R w KQkq - 3 5",
    "r1bqkb1r/pppnppp1/5n1p/3p2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqk2r/ppppppbp/6p1/7n/3P4/2N5/PPP1PPP1/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3pp1/4p2p/2ppP3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/p4ppp/2p1p3/1p1p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkbnr/pp2ppp1/2p5/3P4/3P3p/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1n1ppp/2pp4/4p3/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pppppppp/8/2PnP3/8/8/PP1P1PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/1P6/P4N2/1BPPPPPP/RN1QKB1R w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppppp1bp/5np1/5p2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 4 5",
    "rnbqkbnr/pp3ppp/4p3/2p5/2PpN3/5N2/PP1PPPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/8/4PNP1/PPPP1PBP/RNBQK2R w KQkq - 2 5",
    "r1bqkbnr/pppp1ppp/8/8/3np3/1P6/PBPPPPPP/RN1QKB1R w KQkq - 0 5",
    "r1b1k1nr/ppppqppp/2n5/4p3/1b6/1P1P4/PBPNPPPP/R2QKBNR w KQkq - 3 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2P5/1P3N2/PB1PPPPP/RN1QKB1R w KQ - 3 5",
    "rnbqkbnr/pp3ppp/3p4/4p3/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3PP3/3B4/PPP1NPPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/p2ppp1p/5np1/1ppP4/2P5/6P1/PP2PP1P/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/5n2/8/3PP3/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkbnr/p4ppp/1pp1p3/3p4/8/4P1P1/PPPPNPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/pppp1ppp/2n5/1B2p3/4n3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 4 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/4p3/4P3/5N2/PPPP2PP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/ppp2ppp/3b4/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp1pp1p/6p1/3n4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "r1b1kbnr/ppqnpppp/2pp4/8/2PPP3/5N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/1ppb1ppp/4p3/p2pP3/8/P4N2/1PPP1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/2pp4/3P1P2/8/PPP3PP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/3p1np1/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 0 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/3N4/6P1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/3QP3/2N5/PPP2PPP/R1B1KBNR w KQkq - 1 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/3P1B2/2N1P3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/2pp4/8/2N3P1/PPPP1P1P/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/pb1p1ppp/1p2p3/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 0 5",
    "rnbqk2r/ppppb1pp/4pn2/5p2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 4 5",
    "rnbqkb1r/ppp1pppp/1n6/3pP3/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq d6 0 5",
    "rn1qk1nr/ppp1ppbp/3p2p1/8/3PP1b1/3B1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p4/2PP4/5N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp1p2p/3p1np1/5p2/3P1B2/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/3p4/4n3/8/6P1/PPP1PPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqkbnr/ppppppp1/8/8/3P4/8/PPP1PPBP/RNBQK1NR w KQq - 1 5",
    "rnbqkbnr/pp3ppp/8/2pp4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 2 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/4P3/2B5/5Q2/PPPP1PPP/RNB1K1NR w KQ - 1 5",
    "r1bqkbnr/pp1npppp/3p4/8/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1n1ppp/2pp4/3Np3/3PP3/8/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/5P2/4PN2/PPPPB1PP/RNBQK2R w KQkq - 2 5",
    "rnbqkbnr/pp3ppp/4p3/2PpP3/8/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/pppn1ppp/4p3/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rn1qkb1r/pbp1pppp/1p3n2/3p4/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 1 5",
    "rn1qkbnr/ppp1ppp1/8/3p4/3P3p/4P2b/PPP1BPPP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/3p4/4P3/4n3/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp2pppp/2p5/8/8/5N2/PPPPBPPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pppn1ppp/4p3/3pP3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp1pppp/5n2/8/3P4/2N2p2/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/5p2/2pp4/3P4/4P3/PPP2PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/3p1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5p2/8/8/8/PPPP1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp2pppp/2p5/8/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rn1qkbnr/ppp2ppp/4p1b1/3p4/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 1 5",
    "rn1qkbnr/pb1p1ppp/1p2p3/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "r1bqkbnr/ppp3pp/2n5/3ppp2/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/5P2/8/8/2p5/PPPP1PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pppnpp1p/3p1np1/8/8/5PPN/PPPPP1BP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/3P4/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqk2r/p1ppppbp/1p3np1/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/8/2pp4/3PnB2/4P3/PPP2PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pp1npppp/2pp1n2/6B1/3PP3/5N2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp1pp1p/3p2p1/3nP3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3pp3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pp1n1ppp/2p5/3pp3/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n5/2ppp3/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqk2r/ppppppbp/6p1/7n/4P3/1P3N2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/5n2/3pN3/3Pp3/5P2/PPP1P1PP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/8/3P1NP1/PPPNPP1P/R1BQKB1R w KQkq - 1 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2p5/5P2/4PN2/PPPPB1PP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2p2n2/8/4P3/8/PPPP1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w - - 4 5",
    "rnbqkb1r/ppp1pppp/8/8/2B5/2n5/PPPP1PPP/R1BQK1NR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/5P2/1P3N2/PBPPP1PP/RN1QKB1R w KQkq - 3 5",
    "rn1qkbnr/ppp2ppp/4p3/3p3b/4P3/1P3P2/PBPP2PP/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/5n2/8/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3PP3/P1N5/1PP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/pppp1ppp/4pn2/8/3P4/bP6/PBPNPPPP/R2QKBNR w KQkq - 3 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "r1b1kbnr/ppqnpppp/2pp4/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 3 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqk2r/pppp1pbp/5pp1/8/8/1P2P3/P1PP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/ppppb1pp/4pn2/5p2/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 3 5",
    "r1bqkbnr/pp2pppp/2np4/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/1P6/PBP2PPP/RN1QKBNR w KQkq - 1 5",
    "r1bqk1nr/ppp2ppp/2np4/2b1p3/2B1P3/2P2N2/PP1P1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/3PP3/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p4/8/6P1/PPPPPPBP/RNBQK1NR w KQkq - 2 5",
    "r1bqkbnr/ppp2ppp/2np4/8/3p4/1P3N2/PBP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/8/3pn3/3P4/6P1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/4p3/3P4/3p4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p3p2/8/8/1P3N2/P1PPPPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/3QP3/5N2/PPP2PPP/RNB1KB1R w KQkq - 1 5",
    "rnbqkbnr/pp4pp/2p1p3/3p1p2/3PP3/2NB4/PPP2PPP/R1BQK1NR w KQkq - 0 5",
    "rnbqkb1r/pppp1p1p/5np1/8/3Q4/4PN2/PPP2PPP/RNB1KB1R w KQkq - 1 5",
    "rnbqkbnr/pp3ppp/4p3/3p4/6P1/8/PP1PPPBP/RNBQK1NR w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/2P3b1/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "r2qkbnr/pp1bpppp/2n5/1Bpp4/5P2/4PN2/PPPP2PP/RNBQK2R w KQkq - 3 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/2BP1N2/PPP1PPPP/RN1QKB1R w KQ - 6 5",
    "r1bqk2r/pppp1ppp/2n2n2/2b1p3/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 6 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3PP3/2NB4/PPP2PPP/R1BQK1NR w KQkq - 0 5",
    "rnbqk1nr/ppp1ppbp/6p1/8/4p2P/2NP4/PPP2PP1/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n5/4p3/4N3/5N2/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2PP4/2N3P1/PP2PP1P/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/4P3/3P1N2/PPPN1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/3p4/2pPp3/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n1pn2/3p4/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 3 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pppnpp1p/3p1np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rn1qkbnr/pbp2ppp/1p2p3/3p4/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/8/5N1P/PPPP1PP1/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/4p3/2ppP3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "r2qkb1r/ppp1pppp/2np1n2/8/2B1PPb1/5N2/PPPP2PP/RNBQK2R w KQkq - 3 5",
    "rnbqkb1r/pppn1ppp/4p3/3p2B1/3PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 4 5",
    "rnbqk1nr/ppp2p1p/3b4/6p1/8/5N2/PPPPP1PP/RNBQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P1B2/5N2/PPP1PPPP/RNQ1KB1R w KQ - 4 5",
    "rnbq1rk1/ppppppbp/5np1/8/5P2/4PN2/PPPPB1PP/RNBQK2R w KQ - 4 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P4/4PN2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rn1qkbnr/ppp2ppp/3p4/4p2b/3P4/7P/PPPNPPP1/RNBQKB1R w KQkq - 1 5",
    "rnbq1k1r/ppppppbp/5np1/8/8/3P1NP1/PPPNPP1P/R1BQKB1R w KQ - 1 5",
    "r1bqkb1r/pp1npppp/2p2n2/3p4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/1P6/P3P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3p4/4P3/5N2/PPPP1PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n5/2pnP3/8/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pppnpp1p/3p1np1/8/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pppn1ppp/4p3/3pP3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/5n2/2p5/3Np3/3P2P1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/1pp2ppp/p3pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/6b1/2NP2P1/PPP1PPBP/R1BQK1NR w KQkq - 2 5",
    "rnbqk2r/pp1pppbp/5np1/2p4P/4P3/2N5/PPPP1PP1/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp1n1ppp/2pp4/4p3/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1pppp1/2n2n1p/2p5/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/5n2/4p3/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk2r/pppp1ppp/2n2n2/2b1p3/2B1P3/2P2N2/PP1P1PPP/RNBQK2R w KQkq - 1 5",
    "r1bqkbnr/ppp2ppp/2n5/4p3/4P3/5N2/PPPP2PP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/3P1NP1/PPPNPP1P/R1BQKB1R w KQ - 1 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/8/6P1/PP1PPPBP/RNBQK1NR w KQkq - 0 5",
    "r3kbnr/ppp1pppp/2n5/3q1b2/8/5N2/PPPPBPPP/RNBQK2R w KQkq - 4 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/1P3N2/PBP1PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk1nr/pp1pbppp/8/4p3/8/1N6/PPP1PPPP/RNBQKB1R w KQkq - 2 5",
    "rnbqk2r/ppppp1bp/5np1/5p2/3P4/1P3N2/PBP1PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/4p3/2P5/PPNPPPPP/RNBQKB1R w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/4pn2/1p6/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/2B1P3/3P1Q2/PPP2PPP/RNB1K1NR w KQkq - 1 5",
    "rn1qkbnr/ppp1pppp/3p2b1/8/3P1BP1/5P2/PPP1P2P/RN1QKBNR w KQkq - 1 5",
    "r1bqkb1r/pp1npppp/2p2n2/3p2B1/3P4/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppppppb1/5np1/6Np/3P3P/8/PPP1PPP1/RNBQKB1R w KQkq - 2 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/3p4/2N1PN2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp2pp1/7p/3p4/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnb1kb1r/pp1ppppp/1q6/2p5/3PnB2/4P3/PPP2PPP/RN1QKBNR w KQkq - 3 5",
    "rnbqkbnr/pp2pppp/8/3pP3/3p4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/p1ppppbp/1p3np1/8/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 0 5",
    "rnbqk1nr/ppp1ppbp/3p4/8/4P1p1/3N4/PPPP1PPP/RNBQKB1R w KQkq - 2 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/PP2P3/1BPP1PPP/RN1QKBNR w KQ - 1 5",
    "rnbqkb1r/ppp1pp1p/3p1n2/4N3/6p1/1P6/PBPPPPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/2pP1B2/2N5/PP2PPPP/R2QKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1p1p1p/2n1p1p1/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp1pp1p/6p1/3n4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/1PPP4/PB2PPPP/RN1QKBNR w KQkq - 1 5",
    "rnbqkbnr/pp3ppp/4p3/2p5/4p3/3P1N2/PPP1BPPP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/5P2/4PN2/PPPPB1PP/RNBQK2R w KQkq - 2 5",
    "rn1qkb1r/pp1bpppp/3p1n2/2pP4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/6B1/3Pp3/2N5/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/ppp1pppp/1n1p4/4P3/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkbnr/pp3pp1/4p2p/2ppP3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/2P5/2N5/PP1P1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "r1bqkbnr/pp1n1ppp/2pp4/4p3/4P3/2NP1N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/5np1/2pp4/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/7Q/5N2/PPP1PPPP/RNB1KB1R w KQkq - 0 5",
    "rnb1kb1r/pppp1pp1/4pq1p/8/3PP3/8/PPP2PPP/RN1QKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/4PN2/PPP1BPPP/RNBQK2R w KQ - 3 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/5n2/2pp4/2P5/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnb1kb1r/pp2pppp/5n2/2pq4/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "rnbqk1nr/ppp1bppp/8/3p4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2p5/4P3/3P1NP1/PPP2P1P/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/2P5/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/3ppppp/p7/1p6/3pP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppppppbp/5n2/5p2/8/4PN2/PPPP2PP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/ppppppbp/6p1/8/3P4/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "r1bqk1nr/pppp1ppp/2n5/2b5/2BpP3/5N2/PPP2PPP/RNBQK2R w KQkq - 4 5",
    "r1bqkbnr/pp1p1p1p/2n1p1p1/2p5/4P3/3P2P1/PPPN1P1P/R1BQKBNR w KQkq - 0 5",
    "r2qkb1r/ppp1pppp/2n2n2/3p1bB1/3P4/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 5 5",
    "rnbqk2r/ppppppb1/5np1/7p/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/2ppP3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rn1qkb1r/ppp1pppp/5n2/3p1b2/3P4/2N2P2/PPP1P2P/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/pp4pp/4p3/2ppPp2/3P4/2P5/PP3PPP/RNBQKBNR w KQkq f6 0 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/8/5N1P/PPPP1PP1/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3p4/3BP3/PPP1NPPP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/ppp2p2/3pp1pp/3P4/2P5/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/4p3/3P4/3p4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3b1n2/3pp3/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 4 5",
    "rnb1kbnr/pp3ppp/1q2p3/2ppP3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/2pP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3PP3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3p1p/2p1p3/3p2p1/3P4/4PN2/PPP1BPPP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/ppp1pppp/5n2/3p4/8/1P3P2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/pp2pppp/2p5/8/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkbnr/ppp2ppp/8/4pb2/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rn2kb1r/ppp1pppp/5n2/3q4/3P2b1/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/pp2ppp1/2p4p/3pPb2/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1PP3P1/PB1PPP1P/RN1QKBNR w KQ - 1 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/4PP2/3P4/PPP1B1PP/RNBQK1NR w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/5n2/3P4/3p4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "r3kbnr/ppp1pppp/2n5/3q4/3P2b1/5N2/PPP2PPP/RNBQKB1R w KQkq - 2 5",
    "rnbqk2r/pppp1pp1/4pn1p/6B1/1b1PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/4P3/2PP4/PPQ2PPP/RNB1KBNR w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/5Pb1/3PPN2/PPP3PP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk1nr/ppp1bppp/4p3/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP1B2/4P3/PP3PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqk1nr/pp1pppbp/6p1/8/2P5/8/PP2PPPP/RNBQKBNR w KQkq - 2 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P3P/4P3/PPP1BPP1/RNBQK1NR w KQ - 1 5",
    "rn1qkb1r/ppp1pppp/8/3p1b2/3Pn3/4PN2/PPPN1PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbn1/pppp1pp1/4p3/8/7r/6P1/PPPPPPBP/RNBQK2R w KQq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2ppP3/5P2/3P4/PPP3PP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/3ppn2/8/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 4 5",
    "r1bqkbnr/pp1np1pp/2ppp3/8/3P4/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/5n2/2pp4/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1ppp1p/2n2n2/1Bp3N1/4P3/8/PPPP1PPP/RNBQK2R w KQkq - 1 5",
    "r1bqkbnr/pp2pp1p/2p3p1/2p5/4P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/8/3pP3/4n3/5N2/PPP2PPP/RNBQKB1R w KQkq d6 0 5",
    "rnbqkb1r/pppn1ppp/4p3/3pP3/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqk1nr/ppp2ppp/2p5/2b1p3/4P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P3P/4PN2/PPP2PP1/RNBQKB1R w KQ - 1 5",
    "rn1qkbnr/2pppp1p/bp4p1/p7/4P3/P2P1N2/1PP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/5n2/2pp4/4P3/5P2/PPP3PP/RNBQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/3N4/6P1/PPP1PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/pp3ppp/2pbp3/8/3P4/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkbnr/ppp2pp1/4p2p/3p1b2/8/1P1P4/PBPNPPPP/R2QKBNR w KQkq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2pP4/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/pppn1ppp/4p3/3pP3/3P4/8/PPPN1PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp3ppp/2n1p3/2ppP3/5P2/5N2/PPPP2PP/RNBQKB1R w KQkq - 2 5",
    "rn1qkbnr/pp1b1ppp/4p3/2ppP3/5P2/3P4/PPP3PP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp1p1ppp/5n2/2pp4/2P5/6P1/PP2PP1P/RNBQKBNR w KQkq - 0 5",
    "rnbqkbnr/p2pp1pp/8/1p1P1p2/P1p1P3/8/1PP2PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp3ppp/3p4/2b1p3/8/4PN2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/1p1p1ppp/p3pn2/2p5/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 4 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqk2r/pppp1ppp/2n2n2/2b1p3/2B1P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 6 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3p1B2/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp1pp2/3p3p/8/3P2p1/5NB1/PPP1PPPP/RN1QKB1R w KQkq - 0 5",
    "r1bqk2r/pppp1ppp/2n2n2/1Bb1p3/4P3/3P1N2/PPP2PPP/RNBQK2R w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/6b1/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "r1bqkbnr/pppp1ppp/6n1/3Pp3/4P3/5P2/PPP3PP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/pppp1ppp/1n2p3/4P3/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rn1qk1nr/pbpp1ppp/1p2p3/8/1b1PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/ppp2ppp/4p3/8/8/2N5/PPPPQPPP/R1B1KBNR w KQkq - 2 5",
    "r1bqkbnr/pp2pppp/2n5/2p5/3pP3/5N2/PPPPNPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/3P1B2/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 2 5",
    "rnbqkbnr/p4ppp/1pppp3/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/2p5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQ - 3 5",
    "rnb1kbnr/pppp1ppp/8/7q/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3pP3/5N2/PPPN1PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n1p3/8/Q1p5/5NP1/PP1PPP1P/RNB1KB1R w KQkq - 2 5",
    "rnbqk2r/pppp1pbp/5pp1/8/2P5/1P6/P2PPPPP/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/3ppn2/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 4 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P1B2/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 2 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/2Pp4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1ppppp/2n5/8/4P3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/ppp2ppp/3p4/4n3/8/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 3 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/5P2/4PN2/PPPPB1PP/RNBQK2R w KQkq - 4 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1P4P1/PBPPPPBP/RN1QK1NR w KQ - 3 5",
    "rnbqk1nr/pp1pbpp1/4p3/2p4p/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/4PP2/3P4/PPPN2PP/R1BQKBNR w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1PN2N2/PBPPPPPP/R2QKB1R w KQ - 5 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/8/5N1P/PPPP1PP1/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/2ppppbp/p5p1/1P6/8/2N2N2/PP1PPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3PP3/5N2/PPPN1PPP/R1BQKB1R w KQkq - 4 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp3pp/3p4/5p2/3Pp3/1P2P3/PBP2PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3p4/3PP3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2B1P3/P1N5/1PPP1PPP/R1BQK1NR w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/3P4/1P2PN2/P1P2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P1B2/2P1P3/PP3PPP/RN1QKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/3P4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/3pP3/5N2/PPP2PPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/ppp1pppp/5n2/8/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/pp2pppp/8/8/4p3/4Q3/PPP2PPP/RNB1KBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/3p1n2/8/8/5N2/PPP1PPPP/RNBQKB1R w KQkq - 2 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3p1B2/2N1P3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkbnr/1pp2ppp/p3p3/8/2pP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 0 5",
    "rnb1kb1r/pp2pppp/2p2n2/3q4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp1p1ppp/2p5/2bNp3/2P5/5N2/PP1PPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3p4/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3PP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/4P3/2PP4/PP1N1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/1P2PN2/P1P2PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/pp2ppp1/2p4p/3pPb2/3P3P/8/PPP2PP1/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/5np1/2pp4/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/1p2pppp/p1p2n2/3p4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnb1kbnr/pp2pppp/8/3q4/2pP4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/1P2P2P/PBPP1PP1/RN1QKBNR w KQkq - 1 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2P5/2NP1N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnb1kbnr/pp3ppp/4p3/2pq4/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2p1p/5pp1/3p4/2PP4/8/PP2PPPP/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/p2ppp1p/5np1/1ppP4/2P5/P7/1P2PPPP/RNBQKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w - - 5 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/p3pppp/p1p5/3p4/4P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/8/2pn4/8/2N2N2/PP1PPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/1ppppppp/1n6/p3P3/P1P5/8/1P1P1PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2np1n2/1Bp5/4P3/2P2N2/PP1P1PPP/RNBQK2R w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/2pP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/2p1p3/8/2PPp3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/4p3/3p4/3pP3/5N2/PPPN1PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P1B2/5N2/PPPNPPPP/R2QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/pp2pp1p/3p2p1/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/3Pp3/4BP2/PPP3PP/RN1QKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/3P4/4PN2/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/pp1p1ppp/4p3/8/4P3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppppb1pp/4pn2/5p2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 3 5",
    "r1bqkbnr/pp1n1ppp/2p1p3/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3p4/2PPP3/5N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/3ppn2/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "r1bqk1nr/pppp1ppp/2n5/8/1bP5/8/PP2PPPP/RNBQKBNR w KQkq - 3 5",
    "rnbqkb1r/ppp2p1p/5pp1/3p4/3P4/2N5/PPP1PPPP/R2QKBNR w KQkq - 0 5",
    "rnb1kbnr/ppp1pppp/8/8/4P3/3q4/PP1PNPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/3p1np1/2pP4/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 2 5",
    "rnb1kbnr/pp2pppp/2p5/8/4P3/5N2/PPP2PPP/RNBqKB1R w KQkq - 0 5",
    "r2qkb1r/pppnpppp/3p1n2/8/3P1Bb1/8/PPPNPPPP/RN1QKB1R w KQkq - 4 5",
    "rnbq1k1r/ppppppbp/5np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w - - 4 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/3P4/5NB1/PPP1PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbq1rk1/ppppbppp/4pn2/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQ - 3 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2P1P3/2NP4/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/8/5N2/PPP1PPPP/RNBQKB1R w KQkq - 3 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/3P1N2/PPP1BPPP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2N5/PPP1BPPP/R1BQK1NR w KQkq - 2 5",
    "rnb1kb1r/ppp1pppp/3q1n2/8/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "rnb1kbnr/pp2pp1p/6p1/2pq4/8/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pppp1pbp/2n3p1/4p3/4P3/P2P1N2/1PP2PPP/RNBQKB1R w KQkq - 2 5",
    "rnbqkb1r/pp2pppp/3p1n2/8/3PP3/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk1nr/pp1p2pp/4p3/2pP1p2/1bP5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp3ppp/4p3/2ppP3/1b1P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/4PN2/PPP1BPPP/RNBQK2R w KQ - 4 5",
    "rnbqkbnr/ppp3pp/4p3/3p1p2/3P1B2/5N2/PPP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3PP3/3B4/PPPN1PPP/R1BQK1NR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/2pp4/8/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppppppb1/5npp/8/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/p2p1ppp/2p1p3/2p5/4P3/2N5/PPPP1PPP/R1BQK1NR w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/2Pp4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbq1b1r/pp1pkppp/4pn2/2p5/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQ - 4 5",
    "rn1qkb1r/pbpppp1p/1p3np1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppppbppp/4p3/3nP1B1/3P4/8/PPP2PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqk1nr/ppppppb1/7p/8/3P2p1/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2np4/8/Q7/2N5/PPP1PPPP/R1B1KBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/2p1p3/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/2BpP3/5N2/PPP2PPP/RNBQK2R w KQkq - 4 5",
    "rnbqk2r/pppp1ppp/8/2b1p3/2B1n3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/pp2pp1p/3p1np1/2pP4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/ppp2pp1/4p3/3p1b1p/5P2/3P1NP1/PPP1P2P/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P1B2/5N2/PPPQPPPP/RN2KB1R w KQkq - 0 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p4/2P3b1/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/3PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 4 5",
    "r1bqkb1r/p1pnpppp/1p1p1n2/8/3P1B2/5N1P/PPP1PPP1/RN1QKB1R w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 0 5",
    "r2qkb1r/pppnpppp/3p1n2/8/2PP2b1/8/PP1NPPPP/RNBQKB1R w KQkq - 3 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/pppppp1p/5npP/8/3P4/8/PPP1PPP1/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/1Bp5/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 2 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 3 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P1P2/8/PPP3PP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/3ppppp/p4n2/1PpP4/8/8/PP2PPPP/RNBQKBNR w KQkq - 0 5",
    "r1bqk1nr/pppp1ppp/2n5/2bN4/3pP3/8/PPP2PPP/R1BQKBNR w KQkq - 2 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/4P3/4Q3/PPP2PPP/RNB1KBNR w KQkq - 3 5",
    "rnbqk1nr/ppp2ppp/4p3/3p4/3P4/P1P5/2P1PPPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 2 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2P5/3P1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppppp3/5npp/5p2/3P1B1P/4P3/PPP2PP1/RN1QKBNR w KQkq - 0 5",
    "rnbqkbnr/1ppp1pp1/4p3/7p/p1B1P3/P1N5/1PPP1PPP/R1BQK1NR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2P5/1P2PN2/P2P1PPP/RNBQKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/3PPB2/2N5/PPP2PPP/R2QKBNR w KQ - 1 5",
    "rnbqk2r/pp1pppbp/5np1/2pP4/2P5/5N2/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/pppp1pbp/5pp1/8/2PP4/8/PP2PPPP/RN1QKBNR w KQkq - 1 5",
    "r1bqk1nr/pppp1pbp/2n3p1/4p3/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/ppp2ppp/2n5/4p3/3pP3/3P1N2/PPPN1PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/6B1/3pP3/5N2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk1nr/pp1ppp1p/6p1/2P5/2P5/2b5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/3P4/1P2PN2/P1P2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/pp1npppp/2p5/4p3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/2Pp4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/3N4/6P1/PPP1PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/1P4P1/PBPPPPBP/RN1QK1NR w KQkq - 2 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/8/2pn4/8/P2P4/1P2PPPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/2Pp4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppbppp/5n2/8/8/5NP1/PPPPPP1P/RNBQKB1R w KQ - 1 5",
    "r1bqk1nr/ppp1bppp/2np4/4p3/4P3/2N2NP1/PPPP1P1P/R1BQKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/2P5/PPQNPPPP/R1B1KBNR w KQ - 4 5",
    "r1bqkb1r/ppp1pp1p/2np1np1/6B1/3P4/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/1pp2ppp/p3pn2/3p4/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "r2qkbnr/pbpnpppp/1p1p4/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqk1nr/1ppp1ppp/p1n5/1Bb1p3/4P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQ - 4 5",
    "r1bqkb1r/pp1npppp/2p2n2/3p4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/1ppp1p1p/8/p3p3/6p1/1N4P1/PPPPPP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pppp1ppp/1bn5/4p3/1PB1P3/5N2/P1PP1PPP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppppppbp/6p1/7n/8/1P6/PBPPPPP1/RN1QKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2PP4/P4N2/1P2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "rnbqk1nr/pp3ppp/2p1p3/3p4/1b1PP3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 2 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 3 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQ - 3 5",
    "rnbqk1nr/ppp2pbp/3pp1p1/8/8/5NPP/PPPPPPB1/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppp1p1p/2n2np1/4p3/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3PP3/3B4/PPP1QPPP/RNB1K1NR w KQkq - 0 5",
    "r1bqk2r/pppp1ppp/2n2n2/2b1p3/2B1P3/2NP4/PPP2PPP/R1BQK1NR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P1B2/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "rnb1kbnr/ppp1pppp/8/8/8/2N5/PPPPqPPP/R1B1KBNR w KQkq - 0 5",
    "rnbqk2r/pppp1pbp/5pp1/8/3P4/4P3/PPP2PPP/RN1QKBNR w KQkq - 1 5",
    "rnb1kbnr/1pqppppp/p7/8/2P5/8/PP2PPPP/RNBQKBNR w KQkq - 2 5",
    "r1bqkb1r/1ppnpppp/p4n2/3p2B1/3P4/2N2P2/PPP1P1PP/R2QKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/pppp1ppp/8/2n1P3/8/3B4/PPP2PPP/RNBQK1NR w KQkq - 2 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp4pp/2p1p3/3p1p2/8/3P1NP1/PPPNPP1P/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1npppp/2p5/3p2P1/8/4P3/PPPP1PBP/RNBQK1NR w KQkq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/3PP3/2NB4/PPP2PPP/R1BQK1NR w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3PP3/3B4/PPPN1PPP/R1BQK1NR w KQkq - 2 5",
    "rn1qkbnr/pp2pppp/2p3b1/3pP3/3P2P1/8/PPP2P1P/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/p2p1ppp/1p2pn2/2p5/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/pp1pbppp/4pn2/2p5/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/4P3/2N3P1/PPPPNP1P/R1BQKB1R w KQkq - 1 5",
    "1nbqkbnr/1ppppppp/8/8/8/1P3N2/1BPPPPPP/rN1QKB1R w Kk - 0 5",
    "r1bqk1nr/1ppp1ppp/p1nb4/1B2p3/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 1 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/4p3/3p4/3PP3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkb1r/ppp1pppp/3p1nb1/8/3P1B2/2N2P2/PPP1P1PP/R2QKBNR w KQkq - 1 5",
    "rnbqk1nr/pp2bppp/4p3/2pp4/3PP3/3B4/PPPN1PPP/R1BQK1NR w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 1 5",
    "rnbqkb1r/pp1p1ppp/2p2n2/8/2P1p3/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/2PQ4/4P3/PP3PPP/RNB1KBNR w KQkq - 1 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/3p1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/1p2pppp/p1n5/2pp4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/2pp4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/2pP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/6B1/4P3/2NP4/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/5P2/1P2P3/PBPP2PP/RN1QKBNR w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/8/2pn4/8/2N3P1/PP1PPP1P/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp1p1ppp/4p3/6B1/1b1pP3/5N2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/3P4/5N2/PPPBPPPP/RN1QKB1R w KQkq - 4 5",
    "rnbqkb1r/pp2pp1p/2pp1np1/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "r2qkbnr/ppp2ppp/2npb3/4p3/2P5/1PN5/PB1PPPPP/R2QKBNR w KQkq - 2 5",
    "rnbqk1nr/ppp2pbp/3pp1p1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/4P3/4Q3/PPP2PPP/RNB1KBNR w KQkq - 0 5",
    "rnbqkb1r/p2p1ppp/1p2pn2/2p5/2P5/3PP3/PP1N1PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/1p1p1ppp/p1n1p3/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbq1rk1/pppp1ppp/5n2/1Bb1p3/4P3/5N2/PPPPQPPP/RNB1K2R w KQ - 6 5",
    "r1bqk2r/pppp1ppp/2n2n2/2b1p3/4P3/2N2N2/PPPPBPPP/R1BQK2R w KQkq - 6 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/Q7/2N5/PPP1PPPP/R1B1KBNR w KQkq - 3 5",
    "rnbqkbnr/pp2pppp/8/8/2Pp4/5N2/PP1P1PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/ppppnpp1/7p/3Pp1B1/4P3/8/PPP2PPP/RN1QKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQ - 3 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/8/5N2/PPP1PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/ppp2pbp/6p1/3pp3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1b1kbnr/ppqnpppp/2pp4/8/2PP1B2/4P3/PP3PPP/RN1QKBNR w KQkq - 1 5",
    "rn1qkb1r/pppbpppp/3p1n2/8/3PP3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/ppp2ppp/4p3/8/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqkbnr/pp3ppp/2p5/4p3/8/6P1/PPP1PPBP/RNBQK1NR w KQkq - 0 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p1b2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/ppp1pp1p/5np1/3P4/3P2b1/2N5/PP2PPPP/R1BQKBNR w KQkq - 1 5",
    "rn1qkbnr/pp2pppp/2p5/3p4/8/5bP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r2qkbnr/ppp2ppp/2n1p3/3p1b2/3P4/2P1PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/2NP1N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkbnr/pp2pppp/8/2p5/4P3/2p2NP1/PPPP1P1P/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/pppp2pp/4pn2/5p2/1bPP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 2 5",
    "rnbqkb1r/pp3ppp/3ppn2/2pP4/2P5/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/1p1ppppp/p4n2/8/Q7/2N5/PPP1PPPP/R1B1KBNR w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/2PP1B2/5N2/PP2PPPP/RN1QKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/3PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 1 5",
    "rn1qkb1r/pbpppp1p/1p3np1/8/2P1P3/2NP4/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/ppp1ppp1/2np4/8/7N/6P1/PPPPPPBP/RNBQK2R w KQkq - 1 5",
    "r1bqkb1r/pppnppp1/5n1p/3p2B1/3P4/2N2P2/PPP1P1PP/R2QKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/7Q/2N5/PPP1PPPP/R1B1KBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkbnr/1p1ppppp/p7/nBp5/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/2pP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp2pp1p/6p1/3p4/3PP3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/3P4/4P3/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n5/4p3/4P3/5N2/PPPP2PP/RNBQKB1R w KQkq - 1 5",
    "r1bqk2r/pppp1ppp/2n2n2/1Bb1p3/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 6 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/3P1NP1/PPPNPP1P/R1BQKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQ - 1 5",
    "rnbqkbnr/pp3pp1/2pp4/4p2p/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkb1r/pppp2pp/2n2n2/1B2pp2/8/1P2P3/PBPP1PPP/RN1QK1NR w KQkq - 2 5",
    "rnbqk2r/p1ppbppp/1p2pn2/8/2P5/1P2PN2/P2P1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3b1n2/3pN3/8/6P1/PPPPPPBP/RNBQK2R w KQkq - 1 5",
    "r1b1k1nr/pppp1ppp/2n5/1Bb1N3/4P2q/8/PPPP1PPP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/4pn2/3p4/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/4P3/2N2NP1/PPPP1P1P/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1nppp1/2pp3p/8/2P5/1PN2N2/P2PPPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkb1r/pbppnppp/1p2p3/8/2P1P3/2N2P2/PP1P2PP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/pp1pbppp/4pn2/2p5/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3pP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/1P2PN2/P1P2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pppn1ppp/3ppn2/8/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQ - 3 5",
    "rnbqkbnr/pppp1p1p/8/8/8/4p3/PPPPPPPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2p1p/3p1np1/4p3/2B1P3/5Q2/PPPP1PPP/RNB1K1NR w KQkq - 2 5",
    "rnbqk2r/ppp1nppp/3b4/8/8/5N2/PPPPP1PP/RNBQKB1R w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 2 5",
    "rn1qkb1r/pp1bpppp/3p1n2/1Bp5/4P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 4 5",
    "r1bqkbnr/p1pppp1p/2p5/8/6p1/6P1/PPPPPP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/3QP3/2N5/PPP2PPP/R1B1KBNR w KQkq - 0 5",
    "rnbqkb1r/p2p1ppp/4pn2/1pp5/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 2 5",
    "rn1qkbnr/pbpppp2/1p4p1/7p/3PP2P/2N5/PPP2PP1/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/2p1p3/8/P4N2/1PPP1PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/1p1p1ppp/p1n1p3/2p5/4P3/1P3N2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/5B2/2PP1N2/PP2PPPP/RN1QKB1R w KQ - 5 5",
    "rnbqk2r/pppp2pp/4pn2/5p2/1bPP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/2PP1B2/4P3/PP3PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/8/3pn3/8/N3P3/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2B1PP2/5N2/PPPP2PP/RNBQK2R w KQkq - 3 5",
    "rn1qkbnr/pp3ppp/2ppb3/4p3/8/1P1P2P1/PBP1PP1P/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP2P/2N5/PPP2PP1/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/2p5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/p1p1pppp/5n2/1p6/2pP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/2p3b1/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/3pP3/5N2/PPPN1PPP/R1BQKB1R w KQkq - 2 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 2 5",
    "r1bqkb1r/pp1ppp1p/2n2np1/2p5/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/3p1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "r1bqk2r/ppppbppp/2n2n2/4p3/2B1P3/2P2N2/PP1P1PPP/RNBQK2R w KQkq - 1 5",
    "rn1qkbnr/pp3ppp/2p1p3/3pPb2/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/1PP3b1/4P3/PB1P1PPP/RN1QKBNR w KQkq - 1 5",
    "rn1qkb1r/pppb1ppp/3ppn2/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 3 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/8/2N5/PPPQPPPP/R1B1KBNR w KQkq - 3 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQ - 4 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/8/2N5/PPP1PPPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/1pp2ppp/p1np4/4p3/B3P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/ppp2ppp/8/4p3/8/4pP2/PPPPNKPP/RNBQ1B1R w kq - 0 5",
    "r1b1kbnr/pp1ppppp/1qn5/6B1/7Q/8/PPP1PPPP/RN2KBNR w KQkq - 3 5",
    "rnbqkb1r/1pp2ppp/p3pn2/3p4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk2r/ppppppbp/2n2np1/8/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/2PP2b1/4PN2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/pp1p1ppp/2n5/4p3/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/4p3/3P1N2/PPPN1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/4PN2/PPP1BPPP/RNBQK2R w KQkq - 4 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/Q4B2/8/PPP1PPPP/RN2KBNR w KQkq - 3 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/6B1/8/2PP1N2/PP2PPPP/RN1QKB1R w KQ - 5 5",
    "rnbqkb1r/p2p1ppp/1p2pn2/2pP4/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/Q7/2N5/PPP1PPPP/R1B1KBNR w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p1B1/3PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/3QP3/5N2/PPP2PPP/RNB1KB1R w KQkq - 0 5",
    "rnbqkbnr/1p3ppp/p2pp3/2p5/4P3/5N2/PPPPBPPP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 2 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/3p1np1/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 0 5",
    "r1bqk1nr/ppp1bppp/2np4/4p3/2BPP3/5N2/PPP2PPP/RNBQK2R w KQkq - 4 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2PP4/5N2/PP1NPPPP/R1BQKB1R w KQkq - 4 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/2P1p3/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/ppp2ppp/4p3/8/1b1Pp3/2N5/PPP1NPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1np1pp/2p2p2/3p4/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/8/5N2/PPP1PPPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 4 5",
    "r1bqk1nr/pppnppbp/3p2p1/8/3P4/P3PN2/1PP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/5n2/4p3/4P3/5P2/PPP3PP/RNBQKBNR w KQkq - 0 5",
    "rnbqkbnr/1pp2pp1/p6p/P2pp2P/8/8/1PPPPPP1/RNBQKBNR w KQkq - 0 5",
    "r2qkbnr/pp1bpppp/2np4/2p5/2P5/3P1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqk1nr/pppnppbp/3p2p1/8/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2P5/4PN2/PP1P1PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/3Pp3/2N5/PPP1NPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/2P2P2/4PN2/PP1P2PP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/2pP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/1p2pppp/p7/2ppP3/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/2p5/3p3b/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/2BPP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/1n1p4/4P3/P2P4/8/1PP2PPP/RNBQKBNR w KQkq - 0 5",
    "r2qkbnr/p1pbpppp/p2p4/8/4P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbq1rk1/pppp1ppp/4pn2/8/1bPP4/2N5/PP1BPPPP/R2QKBNR w KQ - 4 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/2P5/1P2P3/PB1P1PPP/RN1QKBNR w KQkq - 2 5",
    "rnbqkb1r/pppp1ppp/1n2p3/4P3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 3 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqk1nr/ppp1bppp/2np4/4p3/2B1P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 2 5",
    "rn1qkbnr/ppp2pp1/4p2p/3p1b2/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n5/2ppp3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/2pP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/p2p1ppp/bpp1p3/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/8/3P2P1/PPPNPPBP/R1BQK1NR w KQkq - 2 5",
    "rnbqk1nr/pppp2pp/8/4pp2/2PP4/6P1/PP1bPP1P/RN1QKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n5/4p3/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/5NP1/PPPNPP1P/R1BQKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp2pp1/8/3p3p/3Pp3/4PP2/PPP2KPP/RNBQ1BNR w kq - 0 5",
    "r1bqk1nr/pppp2pp/2n5/1Bb1pp2/4P3/2P2N2/PP1P1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/pppp1p1p/8/8/3P1ppP/5N2/PPP1P1P1/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/P2P4/4PN2/1PP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/pp2bppp/3p4/2p1p3/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 2 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 2 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp1pp1p/2n2np1/3p4/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/3pP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1bqk1nr/ppp1ppbp/2np2p1/8/8/4P1PP/PPPPNP2/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp1p1p1p/4pnp1/2pP4/2P5/4P3/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/3P4/P3PN2/1PP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 2 5",
    "rnb1k1nr/pp1pppbp/6p1/q1P5/4P3/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/ppp3pp/2n2p2/3pp3/8/1P1BP3/PBPP1PPP/RN1QK1NR w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/2p5/5b2/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "r2qkbnr/ppp2ppp/2n1p3/3pPb2/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qk1nr/pbpp1ppp/1p2p3/8/1bP5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/ppp1nppp/2n5/3pp3/2P5/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2Pp2B1/8/4P3/PPP2PPP/RN1QKBNR w KQkq - 0 5",
    "rn2kbnr/ppp1pppp/8/3q1b2/4N3/5Q2/PPPP1PPP/R1B1KBNR w KQkq - 3 5",
    "rnbqkb1r/pppn1ppp/4p3/3pP3/2P5/2N5/PP1P1PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp2pp1p/2np2p1/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/p3pppp/2p2n2/1B6/8/8/PPPP1PPP/RNBQK1NR w KQkq - 0 5",
    "r2qkbnr/pppb1ppp/2np4/1B2p3/3PP3/5N2/PPP2PPP/RNBQK2R w KQkq - 4 5",
    "rnbqkb1r/1p1p1ppp/p3pn2/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqk1nr/pp1pppb1/6p1/2p4p/4PP1P/5N2/PPPP2P1/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2np1n2/4p3/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "r1bqk1nr/pppnppbp/3p2p1/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 2 5",
    "r1b1kb1r/ppqppppp/2n2n2/1Bp5/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 6 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rn1qkbnr/pbpp1p1p/1p2p1p1/8/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2P5/4PN2/PPQP1PPP/RNB1KB1R w KQkq - 3 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqk1nr/pp3ppp/2pb4/3pp3/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/ppp1p1pp/3p4/3nPp2/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/3pPP2/5N2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "r2qkbnr/pppb1ppp/2npp3/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqk2r/p1pp1ppp/1p2pn2/8/1bPP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/p4ppp/1pp1p3/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3Np3/3P2P1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pppnppbp/3p2p1/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pppnpppp/3p4/8/3Pn3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/p1p2ppp/1p2pn2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/8/3PP2P/PPP1NPP1/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 3 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/4p3/1BN5/PPPP1PPP/R1BQK1NR w KQkq - 2 5",
    "r1bqkbnr/pp1ppppp/8/8/3nP3/8/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1b1r/ppp1kppp/4pn2/3p4/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQ - 1 5",
    "rnbqkb1r/pp2pppp/2p2n2/4p3/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/3P2P1/PPPNPPBP/R1BQK1NR w KQ - 3 5",
    "rnbqk1nr/pp1pppbp/6p1/8/2Pp4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/5P2/2N2NP1/PPPPP2P/R1BQKB1R w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rn1qk1nr/pppbppbp/3p2p1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqkbn1/ppp1ppp1/8/3p4/7r/4P3/PPPP1PBP/RNBQK1NR w KQq - 0 5",
    "rnbqkb1r/pp1ppppp/8/2p1P3/8/2n2N2/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/1pp2ppp/4pn2/p2p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnb1kbnr/pp3ppp/4p3/2pq4/3P4/8/PPPN1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp1p1pp/8/3p1PP1/4n3/8/PPPP1P1P/RNBQKBNR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQ - 1 5",
    "rnbqk1nr/ppp1ppb1/3p2p1/7p/3PP2P/2N5/PPP2PP1/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pppnpppp/3p4/8/3Pn3/5N2/PPP1BPPP/RNBQK2R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/1P2P3/PBP2PPP/RN1QKBNR w KQ - 1 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/3ppn2/2p4Q/4PP2/7N/PPPP2PP/RNB1KB1R w KQkq - 2 5",
    "rnbqkb1r/p1p2ppp/1p2pn2/3p4/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/3p1n2/1Bp5/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 4 5",
    "rnbqkb1r/ppp3pp/5n2/3ppp2/8/3PP2P/PPP1NPP1/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/ppp2pbp/4p1p1/3p3P/4P3/5N2/PPPP1PP1/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/8/2pp4/3Pn3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppppp1bp/5np1/5p2/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 2 5",
    "r1bqkbnr/pp1npp1p/2pp2p1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppppp2p/2n2np1/5p2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQ - 1 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2np1n2/4p3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqk1nr/p1p1ppbp/1p1p2p1/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PP3/5N1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "r2qkb1r/ppp1pppp/2n2n2/3p4/6b1/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/5np1/3P4/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp3pp/3ppn2/5p2/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2pp1np1/8/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2P1P3/2N2N2/PP1P1PPP/R1BQKB1R w KQ - 1 5",
    "rnbqkb1r/ppp2ppp/5n2/4p3/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 3 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/2P3P1/PP2PPBP/RNBQK1NR w KQkq - 3 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/4PP1P/2N5/PPPP2P1/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/2BpP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/2pp4/8/4p3/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/ppppppb1/5npp/8/3P1B2/5N2/PPP1PPPP/RN1QKB1R w KQkq - 2 5",
    "r2qkbnr/pppn1ppp/4p3/3p4/5Pb1/4PN2/PPPPB1PP/RNBQK2R w KQkq - 0 5",
    "rnq1kbnr/pp2pppp/2p5/3p1b2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "r1bqk1nr/pppp1ppp/8/1Bb1p3/3nP3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 6 5",
    "rnbqk2r/ppppb1pp/4pn2/5p2/8/1P2P1P1/PBPP1P1P/RN1QKBNR w KQkq - 1 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p4/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/pp1p1ppp/2p2n2/2b1p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/3p1n2/4p3/2B1P3/2P2N2/PP1P1PPP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "r1bqk1nr/ppppbppp/2n5/8/4Q3/N7/PPP1PPPP/R1B1KBNR w KQkq - 3 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1b1kbnr/pp2pppp/2n5/2pq4/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/3P4/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/3p1n2/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQ - 1 5",
    "2bqkbnr/1ppppppp/2n5/8/r7/1P6/PBPPPPPP/R2QKBNR w KQk - 0 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PP3/2P4P/PP3PP1/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/8/2pp4/3Pn3/5N2/PPP1PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/2pp4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pppnppbp/3p2p1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pppnppbp/3p2p1/8/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/2p2n2/3pp3/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/2P5/2N2NP1/PP1PPP1P/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 3 5",
    "rnbq1rk1/ppppppbp/5np1/8/5P2/1P3N2/PBPPP1PP/RN1QKB1R w KQ - 3 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQ - 1 5",
    "rnbq1rk1/ppppbppp/4pn2/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w - - 4 5",
    "rnbq1rk1/ppppppbp/5np1/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQ - 5 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p1b2/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/2p5/3p1P2/2N2N2/PPPPPKPP/R1BQ1B1R w kq - 0 5",
    "rnbqkbnr/3p1ppp/p3p3/1ppP4/2P5/1P6/P3PPPP/RNBQKBNR w KQkq - 0 5",
    "r2qkbnr/pp2pppp/2n5/2pp1b2/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 1 5",
    "r1bqk1nr/ppp2ppp/2nb4/3pp3/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3P4/1P3N2/PBP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp1p2p/3p1np1/5p2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/pp2pppp/3p1n2/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp3pp/8/3p1p2/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/2PP4/6P1/PP2PP1P/RNBQKBNR w KQkq - 1 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2P5/1PN2N2/P2PPPPP/R1BQKB1R w KQkq - 1 5",
    "rnbqk2r/ppppbppp/5n2/1N6/3Q4/8/PPP1PPPP/R1B1KBNR w KQkq - 3 5",
    "r2qkbnr/pppb1ppp/2np4/4p3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqk1nr/ppppppb1/7p/6pP/3PP3/8/PPP2PP1/RNBQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3p4/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "rnb1kbnr/pp2pppp/2pq4/8/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/2N1PN2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp2p1p/5pp1/3p4/8/1P2P3/P1PP1PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1bnr/ppppp1kp/6p1/5p2/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQ - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqk1nr/pppp1ppp/2n5/2b5/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/ppp2pbp/3p2p1/4p3/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 2 5",
    "rnbqkbnr/ppp2ppp/8/8/2pp4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp1p2p/3p1np1/5p2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqkb1r/pp2nppp/4p3/2ppP3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/2ppnppp/pp2p3/8/8/P2P3P/1PPNPPP1/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2npp3/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "rnbqkbnr/p3pppp/2p5/1p6/2pP4/5N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/3p1n2/8/3QP3/5N2/PPP2PPP/RNB1KB1R w KQkq - 1 5",
    "rnbqkb1r/ppp1p2p/3p1np1/5p2/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pppn1ppp/3ppn2/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/2NP2P1/PPP2P1P/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/1P3N2/PBP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/8/8/3pnP2/8/PPPPPKPP/RNBQ1BNR w kq - 2 5",
    "rnbqkbnr/ppp1pp2/3p3p/6pP/4P1P1/8/PPPP1P2/RNBQKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppbppp/4pn2/8/1P6/P4N2/1BPPPPPP/RN1QKB1R w KQ - 3 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 3 5",
    "rn1qkb1r/pb1ppppp/5n2/1pp5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/2pp4/4p3/1N2P3/PPPP1PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQ - 3 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 3 5",
    "r1bqkb1r/ppp2ppp/2np1n2/1B2p3/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pp1p1ppp/8/2pPp3/3nP3/2P5/PP3PPP/RNBQKBNR w KQkq e6 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/5P2/5NP1/PPPPP1BP/RNBQK2R w KQkq - 3 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4p3/3n4/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/1PP5/5N2/PB1PPPPP/RN1QKB1R w KQ - 3 5",
    "rn1qkb1r/ppp1pppp/8/3n4/3P2b1/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppppp1bp/5np1/5p2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PP3/4BP2/PPP3PP/RN1QKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp1ppb1/7p/3p2p1/3P4/6B1/PPP1PPPP/RN1QKBNR w KQkq - 2 5",
    "rnbqkbnr/1pp1pp2/p2p2pp/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/p1p2ppp/4pn2/1p1p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/pp1ppppp/2n5/8/2P5/4p1P1/PP3P1P/RNBQKBNR w KQkq - 0 5",
    "rnb1kbnr/ppp2p1p/3p1qp1/4p3/2B5/4PQ2/PPPP1PPP/RNB1K1NR w KQkq - 2 5",
    "rnbqkbnr/pp3ppp/4p3/2p5/3pP3/3P4/PPP1NPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/8/3np3/8/2N3P1/PP1PPP1P/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/3p1n2/8/3pP3/2P5/PP1N1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2pp1/4pn1p/3p2B1/3P4/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/p3pppp/2pp1n2/1p6/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2pp1/4pn2/3p3p/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n5/2ppp3/8/3PP2P/PPP1NPP1/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pppp1ppp/8/2n1P3/3Q4/8/PPP2PPP/RNB1KBNR w KQkq - 2 5",
    "rnbqk2r/ppppb1pp/4pn2/5p2/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 3 5",
    "rnbqkb1r/pp1ppppp/8/3nP3/3p4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 0 5",
    "r1bqkbnr/pp2pp1p/2n5/2pp2N1/4P3/2P5/PP1P1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/pp1pbppp/4pn2/2p5/5P2/1P2P3/PBPP2PP/RN1QKBNR w KQkq - 1 5",
    "r1b1kbnr/ppp2ppp/2n1p3/3q4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp1p2p/3p1np1/5p2/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/4pppp/p2p4/1PpP4/8/8/PP2PPPP/RNBQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp3ppp/2pb4/3pp3/8/3P2PP/PPP1PPB1/RNBQK1NR w KQkq - 1 5",
    "r1bqkbnr/pppn1pp1/3pp2p/8/3PP3/5NP1/PPP2P1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/5n2/4p3/8/5N2/PPP1PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P1B2/2P1P3/PP3PPP/RN1QKBNR w KQkq - 1 5",
    "rnb1kb1r/pp2pppp/5n2/2pq4/8/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 2 5",
    "r1bqkbnr/p2ppp1p/2p3p1/2p5/4P3/2N5/PPPP1PPP/R1BQK1NR w KQkq - 0 5",
    "rn1qkb1r/ppp2ppp/4bn2/8/3P4/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "r2qkbnr/p2ppppp/npp5/8/4P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/2p5/3pN2b/8/6P1/PPPPPPBP/RNBQK2R w KQkq - 4 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/2PP4/5N2/PP2PPPP/RN1QKB1R w KQkq - 3 5",
    "rnbqkb1r/pp1p1pp1/4pn1p/2p3B1/3P4/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkbnr/pppn1pp1/3pp2p/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p4/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp3pp/3p4/5p2/4p3/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkbnr/1p2pppp/p1p5/8/3Pp3/2P5/PP1N1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "rnbqkbnr/4pppp/pppp4/1P6/8/6P1/P1PPPPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2BPP3/5N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1b1kbnr/pp1p1ppp/1qn1p3/2p5/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 4 5",
    "rnbqkbnr/pp2pppp/3p4/8/3P4/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkbnr/1p3ppp/p3p3/2pp4/3PP3/2NB4/PPP2PPP/R1BQK1NR w KQkq - 0 5",
    "rn1qkbnr/pp2p1pp/2p2p2/3p4/2PP2b1/1P3N2/P3PPPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 4 5",
    "rnbqkbnr/pp3pp1/4p2p/2pp4/3PP3/2NB4/PPP2PPP/R1BQK1NR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQ - 4 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/P2P1B2/4P3/1PP2PPP/RN1QKBNR w KQkq - 1 5",
    "r1bqkbnr/pp3ppp/2n5/2ppp3/8/1P2P3/PBPPBPPP/RN1QK1NR w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/2P3P1/PP2PPBP/RNBQK1NR w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/8/1B6/PPPP1PPP/RNBQK1NR w KQkq - 2 5",
    "r1bqkbnr/pp3ppp/2n5/2ppN3/3P4/4P3/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2P5/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/3PP3/PPPNNPPP/R1BQKB1R w KQ - 3 5",
    "rnbqkb1r/ppp1pppp/3p4/4P3/8/2P5/P1PP1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp1p1bp/6p1/3p1pB1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp2p1p/3p1np1/4p3/8/1P1P3P/PBP1PPP1/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/pppppp1p/5np1/8/8/1PP3P1/P2PPPBP/bNBQK1NR w Kkq - 1 5",
    "rnbq1rk1/ppppbppp/4pn2/8/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQ - 1 5",
    "rnq1kb1r/ppp1pppp/5n2/3p4/3P2b1/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 2 5",
    "r1bqkb1r/ppp2ppp/2n1pn2/3p4/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/ppp2pp1/8/3pp3/7p/P3P2P/1PPPNPP1/RNBQKB1R w KQkq - 0 5",
    "rnb1kbnr/pp1p1ppp/1q2p3/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/pp2pp1p/3p2p1/8/3PP3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkbnr/pbpp2pp/1p2p3/5p2/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/1bpppppp/1p6/8/p7/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqkbnr/pp3ppp/4p3/3p4/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/8/8/1n1PP3/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2p2n2/3p2p1/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp4pp/2pp1p2/4p3/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r2qkbnr/pp1bpppp/2np4/1Bp5/4P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 4 5",
    "r1bqkbnr/p2ppppp/2p5/8/8/8/PPP1PPPP/RNBQKB1R w KQkq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "r1bqkb1r/pp1p1ppp/2n2n2/2p1p3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/8/5NP1/PP1PPP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqk1nr/pp1p1pbp/4p1p1/2p5/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 0 5",
    "rn1qkb1r/p1pppppp/1p3n2/8/3P1B2/4Pb2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkbnr/pppnpp2/3p2pp/8/2BPP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/3P4/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "r1bqk2r/pppp1ppp/2n2n2/2b1p3/2B1P3/3P1N2/PPP2PPP/RNBQK2R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2n1pn2/3p4/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/2P5/8/PP1QPPPP/RNB1KBNR w KQkq - 3 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/3P4/P1N2N2/1PP1PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk1nr/ppppppbp/6p1/4P3/2P5/2N5/PP1P1PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp2pppp/2n5/3pP3/3p4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2ppP3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkbnr/pp3ppp/4p3/3p4/2BPP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp2p1pp/5n2/2pp1P2/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqkb1r/1ppp1ppp/4pn2/8/p7/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/1pp1nppp/p2pp3/8/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp1pppp/1n6/3pP3/P2P4/8/1PP2PPP/RNBQKBNR w KQkq d6 0 5",
    "rnbqkb1r/ppp2ppp/3p1n2/8/3pP3/6P1/PPP2PBP/RNBQK1NR w KQkq - 0 5",
    "rnbqkb1r/1p2pppp/2pp1n2/p7/P1BPP3/8/1PP2PPP/RNBQK1NR w KQkq - 0 5",
    "rn1qkbnr/pb1p1ppp/1p2p3/2p5/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/2p5/3pP3/3P4/3b4/PPP2PPP/RNBQK1NR w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/p2p1ppp/1p2pn2/2p5/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/pppp1npp/4pp2/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk1nr/1pp1ppbp/p2p2p1/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/2pp4/2PNp3/4P3/PP1P1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/8/3P2PP/PPPNPP2/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P3P/2N2N2/PPP1PPP1/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/pp2pppp/2np4/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/ppp1ppbp/2np2p1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 2 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQ - 1 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/2PNp3/3P4/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp1pp1p/6p1/3n4/3P4/5P2/PP2P1PP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/2p5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/3P2PP/PPP1PPB1/RNBQK1NR w KQ - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/8/PPPPPPPP/RNBQKBNR w KQ - 6 5",
    "rnbqkbnr/3p1ppp/p3p3/1pp5/4P3/2N2NP1/PPPP1P1P/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp3ppp/2npp3/2p1P2Q/5P2/8/PPPP2PP/RNB1KBNR w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2pp1np1/8/8/3PP3/PPPNNPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk1nr/1pppppb1/p5p1/7p/3PP2P/5N2/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/3p1n2/4p3/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 2 5",
    "rnbqkb1r/ppp3pp/5n2/3ppp2/8/6PN/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/2PP2b1/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 4 5",
    "rnbqkb1r/ppp2ppp/3p4/3n4/3P4/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/3PP2P/PPP1NPP1/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2p1pp/2p2p1n/3p4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "r2qkbnr/ppp2ppp/2n1b3/3pp3/8/4P1P1/PPPPNPBP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/pp1pppb1/6p1/2p4p/4P2P/2N2N2/PPPP1PP1/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/5N2/PPPN1PPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqkbnr/pp2pppp/3p4/8/4P3/2p2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 3 5",
    "r1bqkbnr/1ppnppp1/p2p3p/8/3PPP2/2P5/PP4PP/RNBQKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQ - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 1 5",
    "r1bqkbnr/pppp1ppp/2n5/3P4/2P5/5p2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/4P3/2P2N1P/PP1P1PP1/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/3p4/2P5/4n3/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppp1ppp/2n2n2/1N6/3Q4/8/PPP1PPPP/R1B1KBNR w KQkq - 3 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/3P4/1P2PN2/P1P2PPP/RNBQKB1R w KQkq - 0 5",
    "r2qkbnr/pbpnpppp/1p1p4/8/6P1/1P2P3/PBPP1P1P/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 2 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/3PP3/3B4/PPP1QPPP/RNB1K1NR w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/4p3/2pnP3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "r2qkb1r/ppp1pppp/2n2n2/3p4/3P2b1/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "r1bqkb1r/pppnnppp/3pp3/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/4P3/1P3N2/PBPP1PPP/RN1QKB1R w KQ - 1 5",
    "rnbqkbnr/pp3ppp/2p5/4p3/3PP3/8/PPP3PP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n5/2pp4/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/ppp1pppp/5n2/5bB1/3Pp3/2N5/PPP2PPP/R2QKBNR w KQkq - 4 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/5P2/1P2P3/PBPP2PP/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/2p2np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqk2r/ppppnpbp/6p1/4p3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PPB2/2N5/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "rn1qkbnr/pp2p1pp/2p1bp2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 1 5",
    "r1bqkbnr/pp2pp1p/2n3p1/2pp4/8/4P1P1/PPPPNPBP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2PP4/2N2P2/PP2P1PP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/p1pp2pp/1p2pn2/5p2/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/8/4P1PP/PPPPNP2/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/p3pppp/1p1p4/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/pppppp1p/5bp1/8/8/1P3N2/P1PPPPPP/RN1QKB1R w KQkq - 0 5",
    "rnb1kb1r/pp1ppppp/8/q1p5/3PnB2/5P2/PPP1P1PP/RN1QKBNR w KQkq - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2PP1B2/4P3/PP3PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/3P4/2P1PN2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/4P3/2PP1N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqk2r/pppp1ppp/2n2n2/4p3/1bP1P3/2N2N2/PP1P1PPP/R1BQKB1R w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/4PN2/PPPN1PPP/R1BQKB1R w KQkq - 1 5",
    "r1bqk2r/ppppnppp/2n5/2b1p3/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 6 5",
    "rnbqkb1r/1p2pppp/p1p2n2/3p4/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/2N3P1/PPPPNP1P/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbk1bnr/ppp2ppp/8/4p3/2P5/8/PP2PPPP/RNB1KBNR w KQ - 0 5",
    "rnbqkb1r/ppp1pppp/8/3np3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/2PpP3/8/8/PPP2PPP/RNBQKBNR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P1B2/5N2/PPPNPPPP/R2QKB1R w KQ - 4 5",
    "rnbqkbnr/ppp1pp2/3p3p/6p1/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkbnr/pp4pp/3p4/2pPpp2/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/1ppnppp1/p2p3p/6B1/3P4/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3p1p/4p1p1/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/ppp2ppp/2np4/1B6/3pP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/pbpppp1p/1p3np1/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3P4/4P3/5N2/PP1P1PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/p1pppppp/5n2/1B6/4b3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 2 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/pppp1pp1/2n5/7p/3Q4/6P1/PPP1PPBP/RNB1K1NR w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2pp1np1/8/2PP4/2N2P2/PP2P1PP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3pp1/2p1p3/3p3p/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2ppP3/8/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqk1nr/pp1p1ppp/2nb4/1Bp1p3/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 2 5",
    "r1bqk1nr/ppp2ppp/2np4/2b1p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1p1ppp/2n1p3/8/2Pp4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkbnr/pb2pppp/1ppp4/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk1nr/pp1ppp1p/6p1/2pP4/2P5/2b5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 4 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 2 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/3Pp3/4P3/PPPN1PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/3ppn2/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "r1bqkbnr/pp1ppppp/2n5/2p5/4P3/2P2N2/P2P1PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp1p1ppp/4p3/2pnP3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbq1rk1/pppp1ppp/4pn2/8/1bPP4/2N2P2/PP2P1PP/R1BQKBNR w KQ - 1 5",
    "rn1qkb1r/pbpppppp/1p6/7n/3P1B2/5N2/PPPNPPPP/R2QKB1R w KQkq - 4 5",
    "r1b1kbnr/pp2pppp/2n5/2pq4/3P4/4P3/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 3 5",
    "r1bqkb1r/pppp1pp1/2n2n2/4p2p/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/3p4/4p3/3p4/1P2P3/PBP2PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqk2r/ppppppb1/5np1/7p/3P3P/4P3/PPP1BPP1/RNBQK1NR w KQkq - 0 5",
    "r2qkbnr/pbpnpppp/1p1p4/8/8/P3P2P/1PPPNPP1/RNBQKB1R w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP1B2/2N5/PP2PPPP/R2QKBNR w KQ - 4 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/2N3P1/PPP1PPBP/R1BQK1NR w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/4P3/1PN5/PBPP1PPP/R2QKBNR w KQkq - 0 5",
    "rnbqk1nr/1pp1ppbp/p2p2p1/8/P2PP3/2N5/1PP2PPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rn1qkbnr/pp3ppp/2p1p3/3pPb2/8/1P3N2/P1PP1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/4P3/2PP4/PP1N1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/1p1ppppp/p4n2/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/2p5/3pP3/6N1/PPPP1PPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "1rbqkbnr/pp2pppp/8/3p4/3Q4/8/PPP1PPPP/RN2KBNR w KQk - 0 5",
    "r1bqkb1r/pppnpppp/5n2/6B1/3Pp3/2N5/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/4pn2/4p3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp2pp1p/2np2p1/2p5/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/1P3N2/PBP1PPPP/RN1QKB1R w KQ - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/4PP2/1P6/PBPP2PP/RN1QKBNR w KQkq - 1 5",
    "r1bqkbnr/ppp1pppp/2n5/3pP3/5P2/3P4/PPP3PP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/p2p1ppp/1p2pn2/2p5/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1b1kbnr/p1ppqppp/1pn5/4p3/8/1P1P1N2/PBP1PPPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 2 5",
    "rnbqkbnr/pp2pppp/3p4/2pP4/2P1P3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n5/2ppp3/8/2PP3P/PP1NPPP1/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp1pppp/1n1p4/4P3/P7/5N2/1PPP1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/3Pp3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/2B1PP2/2N5/PPPP2PP/R1BQK1NR w KQkq - 2 5",
    "rnbqk2r/ppppbppp/5n2/3Np3/2P5/6P1/PP1PPP1P/R1BQKBNR w KQkq - 1 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk1nr/ppp1ppb1/3p3p/6p1/3P4/6B1/PPP1PPPP/RN1QKBNR w KQkq - 2 5",
    "rnbqkb1r/ppp1pp1p/6p1/3p3Q/3P1B2/4P3/PPP2PPP/RN2KBNR w KQkq - 0 5",
    "rnb1kb1r/ppp1pppp/8/3q4/8/8/PP1PPPPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/pbp1pppp/1p1p1n2/8/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/8/3pn3/8/1P6/PBPPPPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "r1b1kbnr/pp1p1ppp/1qn1p3/2p5/3P1B2/4P3/PPP2PPP/RNQ1KBNR w KQkq - 3 5",
    "rn1qkbnr/pp2pppp/8/3p4/6b1/8/PP1PPPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2PP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/1PP3b1/4PN2/P2P1PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P4/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/ppp2pbp/3pp1p1/8/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2nppn2/8/3PP3/2NB4/PPP2PPP/R1BQK1NR w KQkq - 2 5",
    "rnb1kb1r/pp1p1ppp/1q2pn2/2pP2B1/8/2N5/PPP1PPPP/R2QKBNR w KQkq - 2 5",
    "rnbqkbnr/ppp1ppp1/8/3p4/8/5NPp/PPPPPP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2P5/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 1 5",
    "r1bqkbnr/pp1nppp1/2pp3p/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "1rb1kbnr/pp1ppppp/1q6/8/3Q4/8/PPP1PPPP/RN2KBNR w KQk - 1 5",
    "rnbqk1nr/pppp1pbp/6p1/8/4p3/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqk2r/pppp1ppp/2n2n2/4p3/1bP5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 3 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/p3pppp/2pp1n2/1p6/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/1n1p4/4P3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk1nr/ppp2pbp/3p2p1/4p3/3P4/1P3N2/PBP1PPPP/RN1QKB1R w KQkq - 1 5",
    "rnb1kbnr/pp2pppp/3p4/2q5/8/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1n1ppp/2pp4/4p3/2PP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 1 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p1b2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqk1nr/pp1p1ppp/2n1p3/2b5/8/4PN2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnb1kbnr/ppp2ppp/8/4p3/4P3/5N2/PPP2PPP/RNBqKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/4P3/2N5/PP1P1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbq1rk1/pppp1ppp/4pn2/8/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQ - 4 5",
    "rnbqkb1r/pppp1ppp/8/3n4/8/8/PPP1PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/5P2/5NP1/PPPPP1BP/RNBQK2R w KQkq - 2 5",
    "rnbq1rk1/ppppppbp/5np1/8/2P2P2/2N2N2/PP1PP1PP/R1BQKB1R w KQ - 3 5",
    "r1bqkbnr/pp1n1ppp/2pp4/4p3/3PP3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/2PPP3/5N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp2pp1p/3p2p1/8/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "r1b1kbnr/pp1ppppp/1qn5/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp1pppp/5n2/8/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 4 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/3PPP2/8/PPPN2PP/R1BQKBNR w KQkq - 1 5",
    "r1bqk1nr/pppp1pbp/2n3p1/4p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 2 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/8/4P1PP/PPPPNP2/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/pp2ppbp/6p1/2pp4/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/pbp2ppp/1p1pp3/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp1p1pp/2np1n2/5p2/8/3P1NP1/PPPNPP1P/R1BQKB1R w KQkq - 1 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/4pn2/1p6/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/1p1p1ppp/p1n1p3/2p5/P3P3/2N2N2/1PPP1PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/6B1/2pP4/2N5/PP2PPPP/R2QKBNR w KQkq - 0 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/2Pp4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/8/2PP3P/PP1NPPP1/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 3 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P4/2P2NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P4/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp1n1ppp/2pp4/4p3/3PP3/3B4/PPP1NPPP/RNBQK2R w KQkq - 0 5",
    "1nbqkbnr/1ppp1ppp/4p3/8/r7/5N2/PBPPPPPP/RN1QKB1R w KQk - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2PP4/6P1/PP1NPP1P/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/1p1ppppp/p4n2/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 4 5",
    "rnbqk1nr/pp3ppp/2p1p3/3p4/1b6/3P1NP1/PPPNPP1P/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/2P5/2N2NP1/PP1PPP1P/R1BQKB1R w KQkq - 1 5",
    "r1bqkb1r/pp1ppp1p/2n2np1/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkbnr/1p3ppp/p3p3/2pp4/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p2n2/3pp3/8/2NP2P1/PPP1PPBP/R1BQK1NR w KQkq - 0 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rn1qkb1r/1pp1pppp/p4n2/3p1b2/3P1B2/2N1P3/PPP2PPP/R2QKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/3p1n2/4p3/8/1P2P2P/PBPP1PP1/RN1QKBNR w KQkq - 1 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/2PP1B2/5N2/PP2PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/p1p2ppp/1p2pn2/3p4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pppp3p/4pppn/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 2 5",
    "rn1qkbnr/p1p1pppp/1p6/3p4/8/3P1PP1/PPP2P1P/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP1B2/2N5/PP2PPPP/R2QKBNR w KQkq - 4 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/8/2NPP3/PPP1NPPP/R1BQKB1R w KQkq - 3 5",
    "r1bqkbnr/pp1nppp1/2pp3p/8/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppnpp1p/3p1np1/8/3P4/4PN1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "1rbqkbnr/p2ppppp/1p6/8/3Q4/8/PPP1PPPP/RN2KBNR w KQk - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/3P1NP1/PPP1PPBP/RNBQK2R w KQ - 3 5",
    "r1bqk1nr/pppp1pp1/2n5/2b1p2p/2P5/4P1PP/PP1P1P2/RNBQKBNR w KQkq - 1 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/pbpppppp/1p6/3nP3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp1pp1p/6p1/3n4/8/2N2N2/PP1PPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp1ppp1p/6p1/2p1P3/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/2P3b1/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 3 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/8/2PP3P/PP1NPPP1/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/8/3PP3/PPPNNPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/2pp1ppp/p1n5/1p2p3/B3P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2np4/8/4P3/4Q3/PPP2PPP/RNB1KBNR w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/8/3PPN2/PPP1BPPP/RNBQK2R w KQkq - 4 5",
    "rnbq1rk1/ppppbppp/4pn2/8/3PP3/2N5/PPP2PPP/R1BQKBNR w KQ - 1 5",
    "rn1qkbnr/1b1ppppp/p7/1pp5/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkbnr/3ppppp/pp6/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "1rbqkbnr/1ppnpppp/p2p4/8/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQk - 2 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/3P4/5NB1/PPP1PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/pp2pppp/5n2/2p5/2Pp4/2N2NP1/PP1PPP1P/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/4Pp2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "rn1qkbnr/pb1p1ppp/1p2p3/2p5/4P3/1P3N2/PBPP1PPP/RN1QKB1R w KQkq - 2 5",
    "r1bqkbnr/pp1nppp1/2pp3p/8/3PP3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/pppp1pbp/2n3p1/4p3/8/1P1P1N2/PBP1PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/1pp2ppp/p3pn2/3p4/3P1B2/2N1P3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/5n2/8/5P2/3B4/PPP3PP/RNBQK1NR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQ - 5 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/8/6P1/PP1PPPBP/RNBQK1NR w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbq1bnr/2pppk1p/pp4p1/7Q/4P3/8/PPPP1PPP/RNB1K1NR w KQ - 0 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/2P5/8/PP2PPPP/RNBQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P1B2/5N1P/PPP1PPP1/RN1QKB1R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/ppp2ppp/2n1p3/3p4/1b1PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/1ppnppp1/p2p3p/8/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/ppp2pp1/4pn1p/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/1p1p1ppp/p1n5/2p1p3/P3P3/2P2N2/1P1P1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/ppp1ppbp/6p1/8/3Pp3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp2ppp/3b4/3p4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 2 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p1b2/2P5/3P1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "rnb1kb1r/ppppqppp/8/4N3/4n3/8/PPPPQPPP/RNB1KB1R w KQkq - 2 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqkbnr/pp3p1p/3p2p1/2p1p3/2P1P3/3P1N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/4P3/3P1N2/PPPN1PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/8/1P2P2P/PBPP1PP1/RN1QKBNR w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/4P3/2N2NP1/PPPP1P1P/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/1ppnppp1/p2p3p/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbk1bnr/ppp2ppp/8/4p3/4P3/8/PPP2PPP/RNB1KBNR w KQ - 0 5",
    "rnb1kb1r/ppp1pppp/3q1n2/8/8/5N2/PPPPBPPP/RNBQK2R w KQkq - 4 5",
    "rn1qkb1r/pb1ppppp/1p3n2/2p5/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/2B1P3/2P2N2/PP1P1PPP/RNBQK2R w KQkq - 3 5",
    "rnb1k1nr/ppp1ppbp/6p1/3q3P/8/8/PPPP1PP1/RNBQKBNR w KQkq - 0 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/2P5/2N2NP1/PP1PPP1P/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pppp2pp/5n2/5p2/3Pp3/4P3/PPPN1PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkb1r/ppp2ppp/4pn2/3p1b2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/5n2/3P4/8/8/PP1P1PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/4P3/8/PPPN1PPP/R1BQKBNR w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/2P2N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp1pppp/5n2/8/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp2p2/3pp1pp/8/3PP3/4B3/PPPQ1PPP/RN2KBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2p5/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 2 5",
    "rnbqk2r/pppp1ppp/4pn2/8/3P4/5Nb1/PPP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/3p1np1/2pP4/8/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n5/4p3/Q3p3/2P2N2/PP1P1PPP/RNB1KB1R w KQkq - 0 5",
    "rnbqkbnr/ppp3pp/3p4/5pN1/3Pp3/6P1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pppp1pp1/8/8/3pP2p/6P1/PPP2PBP/RNBQK1NR w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/5n2/4p3/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/3b1n2/3pp3/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqk1nr/ppp2ppp/2n1p3/3p4/1b1PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/ppp1pppp/8/3pP3/8/2P5/PPP2PPP/R1BQKBNR w KQkq d6 0 5",
    "r1bqkb1r/ppp2ppp/2n1pn2/3p4/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2ppp1/5n1p/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/ppp3pp/2np4/4pp2/8/1P1P1N2/PBP1PPPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/pppp1pp1/2n2n1p/4p3/2B1P3/3P1N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppppbppp/5n2/8/8/5N2/PPPQPPPP/RNB1KB1R w KQkq - 3 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 3 5",
    "r1bqkb1r/pppn1ppp/3p1n2/4p3/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 3 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/3PB3/8/PPP2PPP/RNBQK1NR w KQkq - 1 5",
    "rn1qkb1r/p1pp1ppp/bp2pn2/8/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnb1kbnr/pp2pppp/1qp5/8/3Pp3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3PP3/2N5/PPP2PPP/R1BQKBNR w KQ - 1 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/2N5/PP1BPPPP/R2QKBNR w KQkq - 2 5",
    "rnbqkbnr/pp2pppp/8/2p5/8/N1Pp4/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/1ppp1ppp/p1n5/2b1p3/B3P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rn1qkbnr/pp1b1ppp/4p3/2ppP3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/pp1p1ppp/4pn2/2p5/1bPP4/2N2P2/PP2P1PP/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/pppp1ppp/2n5/8/1b1PPp2/2N5/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "r1bqkb1r/pppp1p1p/2n2np1/4p3/4P3/2N2N1P/PPPP1PP1/R1BQKB1R w KQkq - 0 5",
    "rnbqk1nr/ppp1ppbp/3p2p1/8/3P4/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 1 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/P2P4/4PN2/1PP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp2ppp/4p3/8/8/2N2N2/PP1PPPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n1p3/8/3pP3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/8/3P1NP1/PPPNPP1P/R1BQKB1R w KQkq - 1 5",
    "rnbqkbnr/pppp1p1p/8/8/2B1Ppp1/5N2/PPPP2PP/RNBQK2R w KQkq - 0 5",
    "r1b1kbnr/pp2pppp/2n5/2pq4/8/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/3p1n2/2p5/4P3/2P2N1P/PP1P1PP1/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp1p1p1p/4pnp1/2p5/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnb1kbnr/pp2pppp/2p5/q3P3/8/8/PPP2PPP/RNBQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "r1bqkbnr/pppn1ppp/3p4/8/2BpP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkbnr/ppp1pppp/6b1/8/8/6N1/PPPP1PPP/R1BQKBNR w KQkq - 3 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/3P1B2/2P1P3/PP3PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqkb1r/pp1p1ppp/4pn2/4P3/3p4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "r1b1kb1r/ppppqppp/2n2n2/4p2Q/2B5/2N1P3/PPPP1PPP/R1B1K1NR w KQkq - 6 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk1nr/pp3ppp/4p3/2pp4/1bPP1B2/2N5/PP2PPPP/R2QKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/2P1P3/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnb1kbnr/1pqp1ppp/p3p3/2p5/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 2 5",
    "rnbqk2r/pp1p1ppp/4pn2/2p5/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/2pp1n2/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/4pn2/6N1/4p3/2N5/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/3P4/3BPN2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 2 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/2P1PN2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "r2qkbnr/ppp2ppp/2n1p3/3pPb2/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3p1p/2pp2p1/8/3P4/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "rnb1kbnr/1p2pppp/p7/2pq4/8/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2P5/8/2N1P3/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/4pn2/3p4/1b1P1B2/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 2 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 2 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqk1nr/pppp1pbp/2n3p1/4p3/2P1P3/2NP4/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp1p1ppp/2n5/2pp4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp1ppb1/3p2p1/7p/3PP2P/2P5/PP3PP1/RNBQKBNR w KQkq - 0 5",
    "rnb1kbnr/pp2pppp/8/3q4/8/8/PP1P1PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkb1r/pbp1pppp/1p1p1n2/8/3P1B2/5N2/PPPNPPPP/R2QKB1R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n1p3/2pp4/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp2pppp/2p5/8/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "r2qkbnr/pppn1ppp/3pp3/1B6/3PP1Q1/8/PPP2PPP/RNB1K1NR w KQkq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2BPP3/2N5/PPP2PPP/R1BQK1NR w KQkq - 2 5",
    "rnbqkb1r/pp1npppp/2p5/3pP3/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 1 5",
    "r1bqkb1r/ppp1pppp/2n5/3n4/8/6P1/PP1PPPBP/RNBQK1NR w KQkq - 0 5",
    "rnb1kb1r/pp1ppppp/5n2/2pP2B1/8/2N5/PqP1PPPP/R2QKBNR w KQkq - 0 5",
    "rnbqk1nr/ppp2pbp/6p1/3pp3/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/4P3/2N3P1/PPPPQP1P/R1B1KBNR w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/4pn2/3p4/1bPP4/2N2P2/PP2P1PP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1bB1/3P4/2N1P3/PPP2PPP/R2QKBNR w KQkq - 1 5",
    "r1bqkbnr/ppp2p1p/2n3p1/3pp3/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1n1ppp/2pp4/4p3/3PP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/1pp1ppbp/p2p2p1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnb1kbnr/ppq1pppp/2p5/8/4p3/3P1N2/PPP1QPPP/RNB1KB1R w KQkq - 0 5",
    "r1bqkbnr/pppp1p1p/2n3p1/8/4P3/4Q3/PPP2PPP/RNB1KBNR w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/8/3PP1P1/PPPN1P1P/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/2B5/4PN2/PP1P1PPP/RNBQK2R w KQkq - 1 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 2 5",
    "rnbqkb1r/pp2pppp/5n2/3P4/8/8/PP1PPPPP/R1BQKBNR w KQkq - 1 5",
    "rnbq1rk1/pppp1ppp/4pn2/8/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQ - 3 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 0 5",
    "r1bqkbnr/pp1ppppp/8/2p5/4PP2/5N2/PPPPn1PP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/1p2pppp/p1p2n2/3p4/2PP1B2/5N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/pp3ppp/3pp3/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/5np1/2pp4/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/3N4/6P1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/3PP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "rnb1kb1r/pp2pppp/1q3n2/2pp4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "r1bqkbnr/pp3ppp/2np4/2p1p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/3p4/2pPp3/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/ppp2ppp/4b3/3p4/4p3/2N1P1P1/PPPP1PBP/R1BQK1NR w KQkq - 2 5",
    "rnbqkbnr/pppppp2/8/7p/3PP3/2N3pP/PPP2PP1/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p1b2/2PP1B2/4P3/PP3PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/2P5/2N5/PP1P1PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2p2n2/4p3/4P3/2N5/PPPP1PPP/R1BQK1NR w KQkq - 0 5",
    "r1bqk1nr/1ppp1ppp/p1n5/2b1p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3pP3/8/3P1N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnb1kb1r/pp2pppp/1qp2n2/3p4/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/3p1ppp/p3p3/1pp5/4P3/5NP1/PPPP1PBP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/4P3/4Q3/PPP2PPP/RNB1KBNR w KQkq - 3 5",
    "rnb1kbnr/1pqp1ppp/p3p3/2pP4/4P3/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2p2n2/4p3/4P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/ppp1pppp/5n2/5b2/2BPp3/2N5/PPP2PPP/R1BQK1NR w KQkq - 2 5",
    "r1bqkbnr/ppp3pp/2n1pp2/3pP3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppppppb1/5np1/7p/3P1B1P/4P3/PPP2PP1/RN1QKBNR w KQkq - 0 5",
    "r1bqk1nr/ppp2ppp/2nb4/1B1pp3/8/1P2P3/PBPP1PPP/RN1QK1NR w KQkq - 4 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/2PP1B2/2N5/PP2PPPP/R2QKBNR w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/3PP3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqk2r/ppppnppp/2n5/2b1p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 3 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/6b1/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 1 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/7Q/2N5/PPP1PPPP/R1B1KBNR w KQkq - 3 5",
    "rnbqkb1r/p1p1pppp/3p1n2/p7/3P4/8/PPPQPPPP/RN2KBNR w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/8/4P3/1PN2N2/P1PP1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/2PPp3/6P1/PP2PPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp1pppp/5n2/8/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 3 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/8/2N5/PPPQPPPP/R1B1KBNR w KQkq - 3 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/8/5NPP/PPPPPPB1/RNBQK2R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/4N3/3P4/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/pp2pppp/2np4/8/4P3/4Q3/PPP2PPP/RNB1KBNR w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p4/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/ppp2ppp/2n5/4p3/3pP3/3P4/PPP1NPPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/p3pppp/2p5/3pP3/1p1P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 1 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk2r/p1pp1ppp/1p2pn2/8/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp1pppp/5n2/3p4/3P4/2P2P2/PP4PP/RNBQKBNR w KQkq - 1 5",
    "r1b1kbnr/pppp1ppp/2n2q2/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/pppp2pp/2n5/4p3/4p3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 2 5",
    "rn1qkbnr/pp3ppp/2p1p3/3pP3/3P2b1/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/3p1n2/4p3/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 2 5",
    "rnbqk1nr/ppp3pp/3bp3/3p1p2/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/ppp2ppp/4pn2/6N1/4p3/3P4/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/3P4/2P1PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/pppb1ppp/4p3/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/pp1pppbp/2p2np1/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk2r/ppp1bppp/4pn2/3P4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 1 5",
    "rnb1k1nr/ppqpppbp/6p1/2P5/4P3/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/3p4/4P3/4nB2/8/PPP1PPPP/RN1QKBNR w KQkq - 0 5",
    "r1b1kbnr/ppp2ppp/2n5/3qp3/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/7Q/5N2/PPP1PPPP/RNB1KB1R w KQkq - 0 5",
    "r1bqk1nr/pppnbppp/3p4/4p3/3PP3/5N1P/PPP2PP1/RNBQKB1R w KQkq - 1 5",
    "rnb1kbnr/pp2pppp/2p5/q7/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkbnr/pp1p1ppp/8/4p3/4P3/2p2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/3P4/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3p1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/5P2/1P3N2/PBPPP1PP/RN1QKB1R w KQkq - 3 5",
    "rnq1kb1r/ppp1pppp/5n2/3p1b2/3P4/1QP2N2/PP2PPPP/RNB1KB1R w KQkq - 3 5",
    "rn1qkb1r/ppp1pppp/5n2/3p4/3P4/5NP1/PPP1PPbP/RNBQK2R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkbnr/pp1n1ppp/2p5/3pp3/8/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2n5/2ppp3/8/4P1N1/PPPPBPPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pppp1ppp/2n2n2/8/2P5/8/PP2PPPP/RNBQKBNR w KQkq - 3 5",
    "rnbqk1nr/ppp2pbp/3pp1p1/8/3P4/4PN2/PPP1BPPP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/pp4pp/2p1p3/3p1p2/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/2PPP3/5N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/4P3/2NP1N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnb1kbnr/pp2pppp/8/3q4/3p1P2/8/PPP3PP/RNBQKBNR w KQkq - 0 5",
    "rnbqk1nr/2ppppbp/p5p1/1p6/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/3PP3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/2P5/8/PP2PPPP/RNBQKBNR w KQkq - 3 5",
    "rnbqkbnr/pp3ppp/4p3/2p5/2pP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 1 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/3p1P2/3BP3/PPP3PP/RNBQK1NR w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/4P3/1P1P4/PBP2PPP/RN1QKBNR w KQ - 1 5",
    "rnbqkbnr/1p1p1ppp/p3p3/8/2Pp4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2np4/2p1p3/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 2 5",
    "r1bqkbnr/pp2pp1p/2np2p1/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1p1ppp/4p3/2pnP3/8/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1ppppp/2n5/8/4P3/2PB4/PP3PPP/RNBQK1NR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQ - 1 5",
    "r1bqk1nr/pppp1ppp/2n5/4p3/1bB1P3/5N2/P1PP1PPP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p4/8/3P2PP/PPP1PPB1/RNBQK1NR w KQkq - 1 5",
    "rnbqk2r/pppp1ppp/5n2/8/1bPPp3/6P1/PP2PPBP/RNBQK1NR w KQkq - 1 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p4/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1r/pp1p1ppp/5n2/2pp4/8/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/3p4/2pp4/2P1P3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/2p5/3p4/4P3/3P1b1P/PPP2PP1/RNBQKB1R w KQkq - 0 5",
    "rnb1kbnr/pp2pppp/2p5/q7/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/1pp1ppp1/p1np3p/8/3PP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/5NP1/PPPP1PBP/RNBQK2R w KQkq - 3 5",
    "rnbqk1nr/pp1pppb1/6pp/2p5/2PPP2P/8/PP3PP1/RNBQKBNR w KQkq - 0 5",
    "r2qkb1r/ppp1pppp/2n2n2/3p4/6b1/2PP1N2/PP1NPPPP/R1BQKB1R w KQkq - 1 5",
    "rn1qk1nr/pbpp1ppp/1p2p3/8/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 3 5",
    "rnbqkb1r/pppppp1p/5n2/8/3P4/4PQ2/PPP2PPP/RNB1KB1R w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pppp1ppp/4p3/3P4/8/5P2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppbppp/4pn2/6B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQ - 4 5",
    "rnbqkbn1/ppppppp1/8/8/6r1/5N2/PPPPPPBP/RNBQK2R w KQq - 2 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/3PB3/8/PPP2PPP/RNBQK1NR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4p3/3n4/2B5/2N5/PPPP1PPP/R1BQK1NR w KQkq - 0 5",
    "rnbqkbnr/ppp2ppp/4p3/8/8/2N2P2/PPPP2PP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/1pp1ppp1/p4n1p/3p4/3P1B2/2N1P3/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnb1kbnr/1pqp1ppp/p3p3/2p5/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 2 5",
    "r1bqkbnr/pp1npppp/2p5/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/1p2pppp/p1p5/8/P2pP3/2N2N2/1PPP1PPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkbnr/pp3ppp/2p1p3/3p1b2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pppn1ppp/4p3/8/3Pp3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/p2p1ppp/1p2pn2/2p5/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp1pppp/8/4p3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnb1kbnr/pp2pppp/8/3q4/3p4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnb1kb1r/pp1ppppp/5n2/2q5/8/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 0 5",
    "r2qkb1r/pppnpppp/5n2/1B1P4/6b1/5N2/PPPP1PPP/RNBQK2R w KQkq - 5 5",
    "rnbqk1nr/pp1p1pbp/4p1p1/2p5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "r1bqkb1r/pp1pnppp/2n1p3/1Bp5/4P3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 2 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp1pppp/2n5/3p4/3PnB2/5N2/PPPNPPPP/R2QKB1R w KQkq - 4 5",
    "rnbqkb1r/1p2pppp/p1p2n2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/p3pppp/2p5/3p4/1p1PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/pppn1pp1/3pp2p/8/2BNP3/8/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3pP3/2PB4/PP3PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqk2r/pp1p1ppp/4pn2/2b5/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "r2qkb1r/ppp1pppp/2n2n2/3p1b2/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 1 5",
    "rnbqk1nr/pp2bppp/4p3/2pp4/3P4/1P2PN2/P1P2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/2PP2P1/5N2/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "rnbqk2r/pp1p1ppp/4pn2/2p5/1bPP4/5N2/PP1BPPPP/RN1QKB1R w KQkq - 0 5",
    "rnb1kb1r/pp2pppp/1q3n2/2pp4/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/ppp3pp/8/3p1p2/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/5n2/8/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 3 5",
    "r1b1k1nr/pppp1ppp/2n2q2/2b1p3/2B1P1Q1/2N5/PPPP1PPP/R1B1K1NR w KQkq - 6 5",
    "r1b1kbnr/ppqppppp/2n5/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/2P5/4PN2/PPQP1PPP/RNB1KB1R w KQkq - 0 5",
    "r1bqkbnr/pp1ppppp/2n5/8/4P3/2Pp1N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/4PN2/PPPN1PPP/R1BQKB1R w KQkq - 2 5",
    "rnbqkbnr/1p3ppp/p2p4/2pPp3/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/p2ppp1p/1p4p1/8/3P1P2/8/PPP3PP/RNBQKBNR w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2np4/8/2BpP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/ppp1ppb1/3p2pp/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 4 5",
    "rnbqkbnr/pp3ppp/4p3/2p5/3pP3/6P1/PPPPNP1P/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P1B2/2N1P3/PPP2PPP/R2QKBNR w KQkq - 1 5",
    "r2qkbnr/ppp2ppp/2n1p3/3p1b2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P1B2/4PN2/PPP2PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkbnr/pp2pppp/3p4/8/8/2N5/PPPP1PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/1pppbppp/p1n5/4p3/B3P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/pp1ppppp/5n2/8/5B2/2p2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkbnr/pp2pppp/8/2p1P3/2pP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "r1b1kb1r/ppp1pppp/2n2n2/3q4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 3 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/8/5PP1/PPPPPN1P/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/ppp3pp/8/3p1p2/8/3P4/PPP1NPPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2n1pn2/3p4/3PP3/5N2/PPPN1PPP/R1BQKB1R w KQkq - 4 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P4/3BPN2/PPP2PPP/RNBQK2R w KQ - 3 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2P2P2/2N2N2/PP1PP1PP/R1BQKB1R w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3p4/3PP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/p3pppp/2p5/3P4/1p6/2NP4/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/8/3P1NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/pp1p1ppp/5n2/2pp4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/ppp3pp/3p4/8/2N1p3/8/PPPP1PPP/RNBQKB1R w KQkq - 0 5",
    "r1b1kbnr/ppp2ppp/2n5/3qp3/3P4/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/p3pppp/2p5/3p4/2pPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 4 5",
    "r1bqkb1r/1ppnpppp/p4n2/1B1P4/2P5/8/PP1P1PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqkbnr/pp4pp/2p1pp2/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n1p3/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkb1r/pppp1ppp/2n2n2/1B6/4p3/1P2P3/PBPP1PPP/RN1QK1NR w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/4pn2/3p4/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 4 5",
    "rnbqkb1r/pp2pp1p/5np1/2pp4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p4/2PP4/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "rn1qkbnr/pp3ppp/2p1p3/3pPb2/3P4/8/PPPN1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/ppppppbp/6p1/8/8/PP6/R1PPPPPP/1N1QKBNR w Kkq - 2 5",
    "r1bqkbnr/pp2pppp/2n5/2ppP3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 2 5",
    "r1bqk1nr/pppp1pbp/2n3p1/4p3/4P3/2N3P1/PPPP1PBP/R1BQK1NR w KQkq - 2 5",
    "rnbqkbnr/pp3ppp/2p1p3/8/2pP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqk1nr/ppppbppp/2n5/8/8/2N1Q3/PPP1PPPP/R1B1KBNR w KQkq - 3 5",
    "rnbqkb1r/pp3ppp/4pn2/2pp2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp1ppp1p/2n3p1/8/3pP3/2N5/PPP1NPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqk2r/pppp1ppp/2nb1n2/1B2p3/8/1P2P3/PBPP1PPP/RN1QK1NR w KQkq - 3 5",
    "rnb1kb1r/pp2pppp/2p2n2/3q4/3P4/3B4/PPP2PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/4p3/2p5/4pP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/1p2pppp/p1p2n2/3p4/2PP4/1Q3N2/PP2PPPP/RNB1KB1R w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/2P5/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 2 5",
    "rnbq1rk1/ppppbppp/4pn2/8/2P5/5NP1/PP1PPPBP/RNBQK2R w KQ - 4 5",
    "r1bqkbnr/pp2pppp/3p4/2n5/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/4pn2/3p4/1bPP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 3 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P1B2/5N2/PPPNPPPP/R2QKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/4p3/2p1P3/3p4/5N2/PPPPBPPP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/pp1pppbp/6p1/2p5/2PPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "r1bqkbnr/pp1ppppp/2n5/8/2P1P3/3p4/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "r1bqkb1r/pppp1p1p/2n2np1/4p3/2P5/1P2P3/PB1P1PPP/RN1QKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/4P3/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3P4/1P2PN2/P1P2PPP/RNBQKB1R w KQkq - 1 5",
    "rnb1kbnr/pppp1pp1/4p3/8/3P3q/8/PPP1PPBP/RNBQK1NR w KQkq - 0 5",
    "r1bqkbnr/pp1npppp/3p4/1B6/3pP3/5N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/1ppp1ppp/4pn2/8/P7/2N5/PBPPPPPP/R2QKBNR w KQkq - 2 5",
    "rn1qkbnr/pp2pppp/2pp4/8/3PP3/3B1b2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnb1kbnr/ppq1p1pp/2pp4/5p2/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp1nppp/2np4/4P3/5B2/5N2/PPP1PPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/8/3P2PP/PPP1PPB1/RNBQK1NR w KQkq - 0 5",
    "r1bqk2r/ppppbppp/2n2n2/4p3/2B1P3/3P1N2/PPP2PPP/RNBQK2R w KQkq - 1 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/3PP3/3B1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/4p3/3n4/8/2N5/PPPPBPPP/R1BQK1NR w KQkq - 0 5",
    "r1bqkbnr/pppp1ppp/6n1/3Pp3/2P1P3/8/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rnbqk1nr/ppppppbp/6p1/4P3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3P4/4PN2/PPP1BPPP/RNBQK2R w KQkq - 2 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/3PP3/3B4/PPP1QPPP/RNB1K1NR w KQkq - 2 5",
    "rn1qkb1r/pb1ppppp/1p3n2/2p5/8/2P2P2/PPNPP1PP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/1pppbpp1/4p3/p6p/2P5/1PN2N2/P2PPPPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/1pp1pp1p/p2p1np1/8/3PP3/2PB4/PP3PPP/RNBQK1NR w KQkq - 2 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/8/8/PPPPNPPP/R1BQKBNR w KQkq - 2 5",
    "rnbqk1nr/pp1pppbp/6p1/8/3pP3/2N5/PPP1NPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp1ppp1p/2p3p1/3nP3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqkbnr/ppp3pp/5p2/3p4/3Pp3/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1bB1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 4 5",
    "rnbqkb1r/pp1p1ppp/4pn2/6B1/3pP3/2N5/PPP2PPP/R2QKBNR w KQkq - 0 5",
    "rnbqkbnr/pp3p1p/2p3p1/3pp3/4P3/3P2P1/PPPN1P1P/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/p1p1ppbp/3p2p1/1p6/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/pp1pbppp/4pn2/2p5/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 4 5",
    "r1bqkbnr/pppp3p/2n2p2/4P1p1/5B2/5N2/PPP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppbppp/4pn2/8/8/PP1P4/1BP1PPPP/RN1QKBNR w KQ - 1 5",
    "r1bqkb1r/pp1p1ppp/n3pn2/2P5/2P5/4B3/PP2PPPP/RN1QKBNR w KQkq - 1 5",
    "rnbq1rk1/ppppppbp/5np1/8/8/1P1P4/PBPNPPPP/R2QKBNR w KQ - 3 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/4P3/2N2NP1/PPPP1P1P/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/2pP4/1Q3N2/PP2PPPP/RNB1KB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/4pn2/8/2pP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqkbnr/pp4pp/3p4/2pPpp2/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rnb1kb1r/pppq1ppp/3p1n2/4p2Q/2B1P3/2P5/PP1P1PPP/RNB1K1NR w KQkq - 1 5",
    "rnbqkb1r/1pp1pppp/p4n2/8/2N5/5N2/PP1PPPPP/R1BQKB1R w KQkq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/4P3/2PP1N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/1bp1pppp/pp1p4/3P4/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/3PPP2/2N5/PPP3PP/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/8/3p1b2/3P1B2/8/PPP2PPP/RN1QKBNR w KQkq - 2 5",
    "rnbqk1nr/p1ppppb1/1p4pp/8/3PP2P/2N5/PPP2PP1/R1BQKBNR w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/2pp2p1/8/2P1P3/2NP4/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2ppp1/2p2n1p/3p4/3P3P/6R1/PPP1PPP1/RNBQKBN1 w Qkq - 1 5",
    "rn1qkbnr/pp2pppp/2p1b3/8/2pP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/pp1bpppp/3p1n2/2p5/2B1P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 4 5",
    "r1bqk2r/pppp1ppp/2n1pn2/8/1bPP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/ppp1pppp/2n5/3pP3/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq d6 0 5",
    "r1bqkb1r/ppp1pp1p/2n2np1/3p4/8/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "r1bqkb1r/ppp2ppp/2np1n2/4p3/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/4P3/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/6P1/PP2PPBP/RNBQK1NR w KQkq - 2 5",
    "r1bqkb1r/ppp1pp1p/2np1np1/8/4P3/3P2PN/PPP2P1P/RNBQKB1R w KQkq - 1 5",
    "r2qkbnr/pp2pppp/2n5/2ppPb2/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 1 5",
    "rn1qkbnr/pp2pppp/2bp4/2p5/2B1P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 4 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/3P2PP/PPP1PPB1/RNBQK1NR w KQkq - 1 5",
    "rnbqkbnr/pp3ppp/3p4/2pP4/8/8/PPP2PPP/RNBQKBNR w KQkq - 0 5",
    "rn1qkbnr/1bpp1ppp/pp2p3/3P4/2P5/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rn1qkbnr/pb1p1ppp/1p2p3/2p5/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 2 5",
    "rn1qkb1r/pbpp1ppp/1p2pn2/8/3PP3/2NB4/PPP2PPP/R1BQK1NR w KQkq - 2 5",
    "rnbqkb1r/1ppp1ppp/5n2/p7/4p3/1N4P1/PPPPPP1P/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/6P1/PPP2PBP/RNBQK1NR w KQkq - 1 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 1 5",
    "rn2kbnr/pp2pppp/1qp5/3p1b2/3P1B2/4P3/PPP2PPP/RNQ1KBNR w KQkq - 3 5",
    "rnb1kbnr/ppp2ppp/4p3/7q/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "r1bqkbnr/pp2pppp/2n5/2p5/3p4/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 0 5",
    "rn1qkbnr/pbpp2pp/1p2p3/5p2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2P5/5NP1/PP1PPPBP/RNBQK2R w KQkq - 0 5",
    "rn1qkb1r/pb1ppppp/1p3n2/2p5/2P5/1P3N2/PB1PPPPP/RN1QKB1R w KQkq - 0 5",
    "r2qkbnr/ppp2ppp/2np4/4P3/5Bb1/5N2/PPP1PPPP/RN1QKB1R w KQkq - 4 5",
    "rnbqk1nr/1pp1ppbp/p2p2p1/7P/2B1P3/8/PPPP1PP1/RNBQK1NR w KQkq - 2 5",
    "rn1qkbnr/1bpppppp/8/p7/Pp1P4/4PN2/1PP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/pppp1pbp/4pnp1/8/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqk1nr/pppp1pbp/6p1/8/3p4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 0 5",
    "rnbqkb1r/ppp1pppp/5n2/8/8/2N3P1/PPPP1P1P/R1BQKBNR w KQkq - 1 5",
    "r2qkbnr/pppn1ppp/8/3pp3/6b1/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PPB2/2N5/PPP2PPP/R2QKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/4P3/3P1N2/PPP1BPPP/RNBQK2R w KQkq - 2 5",
    "r1bqk1nr/ppp2ppp/2np4/2b1p3/2P1P3/2NP4/PP3PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/3PP3/2PB4/PP3PPP/RNBQK1NR w KQkq - 3 5",
    "rnbqkb1r/pppppn1p/5pp1/8/2PPP3/4B3/PP3PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/6P1/8/PP1PPPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/6B1/3PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "rnbqkb1r/pp2pp1p/2p2np1/3p4/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1ppp1p/2n2np1/2p5/8/1P3NP1/PBPPPP1P/RN1QKB1R w KQkq - 0 5",
    "rn2kbnr/pp2pppp/8/2pq4/6b1/2P2N2/PP1P1PPP/RNBQKB1R w KQkq - 2 5",
    "rnb1kbnr/1pqppppp/p7/8/3pP3/N4N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/Q7/2N5/PPP1PPPP/R1B1KBNR w KQkq - 3 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 4 5",
    "rnbqkb1r/pppn1ppp/4p3/3pP3/5P2/2N5/PPPP2PP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/4pn2/6B1/2pP4/5N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp1pp2/5npp/3p4/3P3B/4P3/PPP2PPP/RN1QKBNR w KQkq - 2 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/2PP1N2/PP3PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkbnr/1bp1pppp/pp1p4/3P4/2P1P3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp2p1pp/2pp1n2/5p2/3PP3/3B4/PPPN1PPP/R1BQK1NR w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3P4/4pP2/3P4/PPP3PP/RNBQKBNR w KQkq - 1 5",
    "rnbqk2r/ppppppbp/6p1/3nP3/8/5NP1/PPPP1P1P/RNBQKB1R w KQkq - 1 5",
    "rnbqkbnr/pp2pppp/8/2p5/3pP3/5N2/PPPPNPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk1nr/pp2ppbp/3p2p1/2pP4/2P1P3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/1pp1pp1p/p2p1np1/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "rnbq1rk1/ppppppbp/5np1/6B1/3P4/2P2N2/PP2PPPP/RN1QKB1R w KQ - 5 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/2Pp4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2np4/8/2PP1p2/5N2/PP2P1PP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/ppp2ppp/2np1n2/4p3/8/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "r1bqkbnr/pp1ppppp/8/8/3n4/6P1/PPP1PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/7Q/2N5/PPP1PPPP/R1B1KBNR w KQkq - 0 5",
    "r1b1kbnr/pppp1ppp/2n2q2/8/3Np3/1P6/PBPPPPPP/RN1QKB1R w KQkq - 2 5",
    "rnbqkb1Q/pp1ppp1p/5np1/8/8/5N2/PPP1PPPP/RNB1KB1R w KQq - 1 5",
    "rn1qkb1r/ppp1pppp/5n2/5bN1/4p3/2N5/PPPP1PPP/R1BQKB1R w KQkq - 4 5",
    "rnbqkb1r/p1pp1ppp/4pn2/8/1p2P3/4N3/PPPP1PPP/R1BQKBNR w KQkq - 2 5",
    "rnbqk2r/ppppp1bp/5np1/5p2/2PP4/2N3P1/PP2PP1P/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp3pp/4pn2/3p1p2/2PP4/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/2PPp3/8/PP1NPPPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/5np1/8/3P1P2/3BP3/PPP3PP/RNBQK1NR w KQ - 1 5",
    "r1bqkbnr/pp1ppp2/2n3p1/2p4p/2B1P2P/5N2/PPPP1PP1/RNBQK2R w KQkq - 2 5",
    "r1bqkbnr/pppp1p1p/8/4n1p1/4P3/2N5/PPP2PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp3ppp/2p1pn2/3p4/2PP4/4PN2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/5n2/4p3/4P3/8/PPPN1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkb1r/pp1p1p1p/5pp1/2p5/8/1P3N2/P1PPPPPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/pp1npppp/2p2n2/3p4/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 2 5",
    "r1bqkbnr/pp2pppp/2n5/3p4/3P4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/1ppp1ppp/4pn2/8/pP6/P7/1BPPPPPP/RN1QKBNR w KQkq - 1 5",
    "rn1qkbnr/1b1ppppp/p7/1pp5/4PP2/2N2N2/PPPP2PP/R1BQKB1R w KQkq - 2 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/3Pp3/4P3/PPPN1PPP/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pppppp1p/1n4p1/4P3/2P5/8/PP1P1PPP/RNBQKBNR w KQkq - 1 5",
    "r1bqkbnr/ppp2ppp/2n5/4p3/3P4/5N2/PPP1P1PP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/8/3pp3/2PN4/8/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "rnbq1b1r/ppp1kppp/3ppn2/8/3P1B2/4P2P/PPP2PP1/RN1QKBNR w KQ - 1 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/2B1P3/3P1N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqk1nr/ppp2pbp/3p2p1/4p3/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 0 5",
    "r1bqk1nr/ppp1ppbp/2np2p1/8/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/3pp3/8/3pP3/2P2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pppp2pp/5n2/5p2/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/PP6/R3P3/2PP1PPP/1NBQKBNR w Kkq - 1 5",
    "rnbqkb1r/ppp2ppp/4p3/3n4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/2PP4/2N1P3/PP3PPP/R1BQKBNR w KQkq - 2 5",
    "r1b1kbnr/ppppqppp/8/4n3/8/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/3bpn2/3p2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 4 5",
    "r1bqk1nr/ppp2ppp/2np4/2b1p3/2P1P3/3PB3/PP3PPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2npp3/2p5/4P3/3P1N2/PPPN1PPP/R1BQKB1R w KQkq - 2 5",
    "rnbqk1nr/pp2ppbp/2p3p1/3p4/4P3/5NP1/PPPP1PBP/RNBQK2R w KQkq - 0 5",
    "rnb1k2r/ppppqppp/4pn2/8/1bPP4/5N2/PP1BPPPP/RN1QKB1R w KQkq - 4 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/5P2/1P2PN2/P1PP2PP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/ppppnppp/5n2/3Pp3/2P5/2N5/PP2PPPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/5np1/3p4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 3 5",
    "r1bqkb1r/ppp2ppp/2n2n2/3pp3/8/1P4P1/PBPPPPBP/RN1QK1NR w KQkq - 2 5",
    "rnbqkb1r/pp2pp1p/3p1np1/2p5/4P3/2P2N2/PP1PBPPP/RNBQK2R w KQkq - 0 5",
    "r1bqk2r/ppppnppp/2n5/2b1p3/2P5/2N3P1/PP1PPPBP/R1BQK1NR w KQkq - 5 5",
    "rnbqkb1r/ppp2ppp/5n2/3P4/8/8/PP1P1PPP/RNBQKBNR w KQkq - 1 5",
    "r1bqkb1r/pppp1ppp/2n5/4P3/6n1/2N2N2/PPP1PPPP/R1BQKB1R w KQkq - 3 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/3P2b1/4PN2/PPP1BPPP/RNBQK2R w KQkq - 4 5",
    "rnbqkb1r/pp1p1ppp/2p2n2/8/2PPp3/6P1/PP2PPBP/RNBQK1NR w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/4pn2/3p4/1bPP4/2N5/PPQ1PPPP/R1B1KBNR w KQkq - 0 5",
    "rn1qkbnr/pp2pppp/2p5/3p3b/8/1P3N1P/PBPPPPP1/RN1QKB1R w KQkq - 0 5",
    "rnbqkbnr/pp3ppp/2p5/3p4/3P4/5N2/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2pp1/4pn1p/3p4/2PP4/5NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/2B1P3/3P1N2/PPP2PPP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/ppp2ppp/2np1n2/1B2p3/8/1P2P3/PBPP1PPP/RN1QK1NR w KQkq - 0 5",
    "r1bqk2r/ppppppbp/2n2np1/8/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2np1n2/2p5/2P5/3P2P1/PP2PPBP/RNBQK1NR w KQkq - 3 5",
    "rnbqkbnr/p1p2ppp/4p3/3p4/2pPP3/2N5/PP3PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/3ppn2/8/4P3/2NB1N2/PPPP1PPP/R1BQK2R w KQkq - 2 5",
    "r1bqkb1r/pp2pppp/2n2n2/2pp4/3P4/5NP1/PPP1PPBP/RNBQK2R w KQkq - 2 5",
    "r1bqkb1r/pp1ppppp/2n2n2/8/2PQ4/2N5/PP2PPPP/R1B1KBNR w KQkq - 1 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/4pP2/2N5/PPPPN1PP/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/pp1npppp/2p5/8/3Pp3/2N2P2/PPP3PP/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/pp1ppp1p/5np1/8/3Q4/2N2N2/PPP1PPPP/R1B1KB1R w KQkq - 0 5",
    "r1bqkbnr/ppp1nppp/3p4/3Pp3/2P1P3/8/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/3P1P2/4PN2/PPP3PP/RNBQKB1R w KQkq - 1 5",
    "r1bqkb1r/1ppp1ppp/p1n2n2/4p3/2B1P3/3P1N2/PPP2PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/pp2pp2/2p3p1/3p3p/8/5NP1/PPPPPPBP/RNBQ1RK1 w kq - 0 5",
    "rnbqkbnr/pp1ppp1p/6p1/8/8/2N2N2/PP2PPPP/R1BQKB1R w KQkq - 0 5",
    "rnbqk1nr/ppp1bppp/3p4/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/6b1/1P2PN2/PBPP1PPP/RN1QKB1R w KQkq - 1 5",
    "rnbqkb1r/p1pp1pp1/1p2pn1p/8/3P3B/5N2/PPP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppp1bppp/4pn2/3p4/3P4/4PN2/PPP1BPPP/RNBQK2R w KQkq - 2 5",
    "rnbqkb1r/pppp1p2/4pn1p/6p1/3P3B/5N2/PPP1PPPP/RN1QKB1R w KQkq - 0 5",
    "rnbqk2r/ppppnpbp/4p1p1/8/3PP3/2N1B3/PPP2PPP/R2QKBNR w KQkq - 2 5",
    "r1bqkb1r/pp1p1ppp/2n1pn2/2p5/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 4 5",
    "rnbqkbnr/pp4pp/2p1p3/3p1p2/2P5/2N1PN2/PP1P1PPP/R1BQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pp1p/3p1np1/2p5/2B1P3/2N2N2/PPPP1PPP/R1BQK2R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/2p2n2/8/4NP2/8/PPPP2PP/R1BQKBNR w KQkq - 1 5",
    "r1bqkb1r/pppp1ppp/2n5/4p3/2B1n3/5N2/PPPP1PPP/RNBQ1RK1 w kq - 0 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/4P3/2NP2P1/PPP2P1P/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/ppp3pp/2n2p2/3pp3/3P4/2P2NP1/PP2PP1P/RNBQKB1R w KQkq - 0 5",
    "rnbq1rk1/ppppppbp/6pn/8/3P4/2P1P3/PP3PPP/RN1QKBNR w KQ - 1 5",
    "rnb1kbnr/1pqppppp/p7/8/3NP3/8/PPP2PPP/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/ppp2ppp/4p3/3pP3/2P1n3/2N5/PP1P1PPP/R1BQKBNR w KQkq - 1 5",
    "rnbqk2r/ppp1ppbp/3p1np1/8/7P/3P1NP1/PPP1PP2/RNBQKB1R w KQkq - 0 5",
    "rnbqkb1r/pp2pppp/5n2/3p2B1/3p4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "rnbqkb1r/pppp2pp/4pn2/8/3PN3/8/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "rnb1kbnr/ppp2ppp/8/3q4/3p4/2P5/PP3PPP/RNBQKBNR w KQkq - 0 5",
    "rnbqkb1r/p1pp1pp1/1p2pn1p/6B1/3PP3/5N2/PPP2PPP/RN1QKB1R w KQkq - 0 5",
    "rnbqkb1r/p1p2ppp/1p2pn2/3p4/2P5/1P2PN2/P2P1PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkb1r/pp2pppp/2n2n2/1B6/8/8/PPPP1PPP/RNBQK1NR w KQkq - 0 5",
    "rnbqk2r/pppppp1p/5bp1/8/3P4/2P5/PP2PPPP/RN1QKBNR w KQkq - 0 5",
    "r1bqkb1r/ppp1pppp/2n2n2/4p3/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 2 5",
    "r1bqk2r/pppp1ppp/2n2n2/2b1p3/2P1P3/2N3P1/PP1P1P1P/R1BQKBNR w KQkq - 1 5",
    "rnbqkb1r/ppp2ppp/5n2/3p4/8/1B6/PPPP1PPP/RNBQK1NR w KQkq - 2 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/2P5/1PN5/PB1PPPPP/R2QKBNR w KQkq - 2 5",
    "rnbqkb1r/pp1p1ppp/4p3/2pnP3/8/2N2N2/PPPP1PPP/R1BQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp1npppp/2p5/3pP3/3P4/2N5/PPP2PPP/R1BQKBNR w KQkq - 1 5",
    "r1bqkb1r/pppnpp1p/3p1np1/8/8/1P4P1/PBPPPPBP/RN1QK1NR w KQkq - 0 5",
    "rnbqk2r/ppppbppp/5n2/8/3pP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p4/6b1/3PPNP1/PPP2P1P/RNBQKB1R w KQkq - 1 5",
    "rnbqkb1r/pp1p1ppp/4pn2/8/7Q/2N5/PPP1PPPP/R1B1KBNR w KQkq - 0 5",
    "rnbqkbnr/ppp3pp/8/3p1p2/3P4/8/PPPN1PPP/R1BQKBNR w KQkq - 0 5",
    "rnbqkbnr/1pp2pp1/3pp3/p6p/3PP3/2N2N2/PPP2PPP/R1BQKB1R w KQkq - 0 5",
    "r1bqkbnr/ppp2ppp/2n5/3p4/8/5N2/PPPPBPPP/RNBQK2R w KQkq - 2 5",
    "rn1qkbnr/1bpp1ppp/p3p3/1p6/4P3/3P2P1/PPP2PBP/RNBQK1NR w KQkq - 0 5",
    "rn1qkbnr/1b1ppppp/1p6/p1p5/8/PP4P1/1BPPPP1P/RN1QKBNR w KQkq - 1 5",
    "rn1qkb1r/pp2pppp/2p2n2/3p1b2/2PP1B2/2N5/PP2PPPP/R2QKBNR w KQkq - 2 5",
    "rnbqk2r/pp1pppbp/5np1/2p5/3P4/2P1PN2/PP3PPP/RNBQKB1R w KQkq - 2 5",
    "rn1qk1nr/pbppppbp/1p4p1/8/3PP3/2N5/PPP1NPPP/R1BQKB1R w KQkq - 2 5",
    "r1bqkbnr/1p1p1ppp/p1n1p3/2p5/P3P3/2N3P1/1PPP1P1P/R1BQKBNR w KQkq - 1 5",
    "r1bqkbnr/pp2pppp/2n5/2p5/3p4/PP2P3/1BPP1PPP/RN1QKBNR w KQkq - 1 5",
    "rnbqkbnr/pp1p1ppp/8/8/3Pp3/5N2/PP2PPPP/RNBQKB1R w KQkq - 0 5",
    "r1bqk1nr/pp1pppbp/2n3p1/2p5/4P3/6P1/PPPPNPBP/RNBQK2R w KQkq - 2 5",
    "rnbqkbnr/ppp2ppp/8/3p4/3P4/4P3/PPPNP1PP/RNBQKB1R w KQkq - 0 5",
    "rnbqkbnr/1p2pppp/p2p4/8/3QP3/5N2/PPP2PPP/RNB1KB1R w KQkq - 0 5",
    "r1bqkbnr/pp1ppppp/2n5/8/4P3/2p2N2/PP3PPP/RNBQKB1R w KQkq - 0 5",
    "r1bqkbnr/pp3ppp/2p5/2p1p3/4P3/5N2/PPPP1PPP/RNBQK2R w KQkq - 0 5",
    "rnbqkbnr/pp4pp/2p1p3/3p1p2/3P1B2/2P2N2/PP2PPPP/RN1QKB1R w KQkq - 0 5",
    "r1bqkb1r/pppn1ppp/4pn2/3p2B1/3P4/2N2N2/PPP1PPPP/R2QKB1R w KQkq - 0 5",
    "rnbqk2r/ppp2ppp/4pn2/3p2B1/1b1PP3/2N5/PPP2PPP/R2QKBNR w KQkq - 4 5",
]

MOVES = [
    "d2d4 g7g6 g1f3 f8g7 c1h6 g7h6 e2e3 h6g7",
    "g1f3 d7d5 g2g3 e7e6 f1g2 f8e7 d2d4 h7h5",
    "e2e4 e7e5 g1f3 b8c6 f1e2 f8c5 f3e5 c5f2",
    "e2e3 e7e5 b2b3 b8c6 c1b2 a7a6 g1f3 e5e4",
    "d2d4 d7d5 g1f3 c7c6 g2g3 g8f6 f1g2 g7g6",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 f3g5 d7d5",
    "e2e4 e7e5 g1f3 b8c6 d2d4 e5d4 f1c4 f8b4",
    "e2e4 b8c6 g1f3 e7e5 d2d4 e5d4 f3d4 f8c5",
    "g1f3 g8f6 d2d4 c7c5 d4d5 g7g6 b1c3 f8g7",
    "g2g3 d7d5 f1g2 c7c6 g1f3 g8f6 e1g1 c8f5",
    "b1c3 b7b6 e2e4 c8b7 f2f4 e7e6 g1f3 f8e7",
    "d2d4 f7f5 b1c3 g8f6 c1g5 e7e6 e2e4 f5e4",
    "b2b3 g8f6 c1b2 e7e6 e2e3 d7d5 g2g4 f6g4",
    "d2d4 g8f6 g1f3 d7d6 b1c3 b8d7 e2e4 g7g6",
    "e2e4 b7b6 b1c3 c8b7 d2d3 g7g6 g1f3 f8g7",
    "e2e4 c7c5 g1f3 d7d6 f1b5 c8d7 b5d7 b8d7",
    "g2g3 d7d5 f1g2 e7e6 g1f3 g8f6 e1g1 f8e7",
    "d2d4 d7d5 c2c4 e7e6 b1c3 g8f6 c4d5 e6d5",
    "g1f3 g8f6 e2e3 g7g6 d2d4 f8g7 c2c4 e8g8",
    "g2g3 g7g6 f1g2 g8f6 g1f3 f8g7 e1g1 e8g8",
    "e2e4 c7c6 d2d4 d7d5 b1c3 d5e4 c3e4 c8d7",
    "e2e4 c7c5 b1c3 e7e6 f2f4 b8c6 g1f3 a7a6",
    "c2c4 e7e5 b1c3 f8b4 c3d5 b4e7 e2e3 g8f6",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5a5 d2d4 c7c6",
    "d2d4 d7d5 c2c4 e7e6 b1c3 c7c5 g1f3 b8c6",
    "e2e4 b8a6 g1f3 g7g5 d2d4 f8g7 c1g5 c7c5",
    "g2g3 g8f6 f1g2 c7c5 g1f3 b8c6 e1g1 e7e5",
    "e2e4 c7c5 b1c3 b8c6 f2f4 g7g6 f1b5 c6d4",
    "d2d4 e7e6 c2c4 g8f6 g1f3 f8b4 c1d2 d8e7",
    "d2d3 d7d5 g1f3 g8f6 g2g3 g7g6 f1g2 f8g7",
    "d2d4 e7e5 b1c3 e5d4 d1d4 b8c6 d4d1 g8f6",
    "e2e4 e7e5 g1f3 d7d6 d2d4 e5d4 d1d4 g8f6",
    "c2c3 g8f6 g1f3 g7g6 e2e3 f8g7 f1e2 e8g8",
    "e2e4 c7c5 g1f3 b8c6 d2d4 c5d4 f3d4 g8f6",
    "e2e4 b7b6 d2d4 c8b7 f1a6 g7g6 a6b7 c7c6",
    "d2d4 e7e6 g1f3 d7d5 g2g3 f8e7 f1g2 g8f6",
    "e2e4 c7c6 b1c3 d7d5 d2d4 d5e4 c3e4 g8f6",
    "g1f3 d7d5 g2g3 c7c6 f1g2 g8f6 c2c4 c8f5",
    "g2g3 d7d5 f1g2 e7e6 b2b3 g8f6 c1b2 f8e7",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d8 d2d4 g8f6",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 f3d4 a7a6",
    "d2d4 g8f6 e2e3 a7a5 f2f4 f6e4 b1d2 d7d5",
    "c2c4 c7c6 b1c3 d7d5 e2e3 g8f6 g1f3 e7e6",
    "g2g3 d7d5 f1g2 c8h3 g2h3 g8f6 h3g2 h7h5",
    "d2d4 g8f6 c2c4 d7d6 b1c3 e7e5 d4e5 d6e5",
    "d2d4 d7d5 c2c3 c7c5 g1f3 c5d4 c3d4 g8f6",
    "e2e4 b7b6 g1f3 a7a6 b1c3 c8b7 d2d4 e7e6",
    "e2e4 g7g6 d2d4 d7d6 c2c3 h7h6 g1f3 e7e6",
    "c2c4 c7c5 b1c3 d7d6 g1f3 g7g6 d2d4 c5d4",
    "e2e4 c7c6 g1f3 d7d5 b1c3 d5e4 c3e4 g8f6",
    "d2d4 d7d5 b1c3 g8f6 c1f4 c7c6 e2e3 g7g6",
    "e2e4 c7c5 b1c3 g7g6 g2g3 f8g7 f1g2 b8c6",
    "b2b4 e7e6 c1b2 g8f6 a2a3 a7a5 g1f3 a5b4",
    "e2e4 e7e5 b1c3 g8f6 f2f4 d7d5 g1f3 e5f4",
    "e2e3 d7d6 f2f4 e7e5 g1f3 e5e4 f3d4 f7f5",
    "g1f3 e7e5 b2b3 e5e4 f3g1 d8f6 c2c3 d7d5",
    "d2d4 g8f6 g1f3 g7g6 g2g3 f8g7 f1g2 e8g8",
    "d2d4 c7c5 h2h3 c5d4 d1d4 b8c6 d4d1 g7g6",
    "g2g3 g7g6 f1g2 f8g7 g1f3 d7d5 e1g1 c7c6",
    "g2g3 a7a5 f1g2 c7c6 g1h3 d7d6 f2f3 b8d7",
    "d2d4 g8f6 g1f3 d7d5 b1c3 e7e6 c1g5 f8e7",
    "e2e4 e7e5 g1f3 b8c6 f1b5 c6d4 f3d4 e5d4",
    "c2c4 e7e6 g1f3 d7d5 e2e3 g8f6 b1c3 b7b6",
    "c2c4 e7e6 b1c3 d7d5 d2d4 g8f6 c4d5 f6d5",
    "f2f4 g8f6 g1f3 e7e6 e2e3 d7d5 d2d4 c7c5",
    "e2e4 c7c5 g1f3 d7d6 b1c3 g8f6 f1b5 b8d7",
    "h2h4 d7d5 h4h5 c7c6 e2e4 e7e5 e4d5 c6d5",
    "c2c4 e7e5 b1c3 d7d6 g2g3 f7f5 f1g2 g8f6",
    "e2e4 e7e6 d2d4 d7d5 b1c3 g8f6 e4d5 e6d5",
    "e2e4 e7e6 d2d4 d7d5 e4e5 c7c5 c2c3 b8c6",
    "d2d4 g8f6 b1c3 c7c5 d4d5 g7g6 e2e4 f8g7",
    "e2e4 e7e6 d2d4 d7d5 b1d2 c7c5 e4d5 e6d5",
    "e2e4 e7e5 g1f3 b8c6 d2d4 e5d4 f1c4 g8f6",
    "b2b3 g8f6 c1b2 b7b6 e2e3 c8b7 g1e2 e7e6",
    "e2e4 d7d6 g1f3 g7g6 d2d3 f8g7 f1e2 d6d5",
    "g2g3 h7h5 f1g2 h5h4 g1f3 h4g3 h2g3 h8h1",
    "g1f3 b7b6 e2e3 c8b7 f1e2 g7g6 e1g1 f8g7",
    "d2d4 c7c6 d4d5 c6d5 g1f3 e7e6 c2c4 d5c4",
    "b2b3 g8f6 c1b2 e7e6 g1f3 f8e7 e2e3 e8g8",
    "e2e4 c7c6 g1f3 d7d5 e4d5 c6d5 h2h3 b8c6",
    "e2e4 b8c6 g1f3 e7e5 f1b5 f8c5 e1g1 d7d6",
    "g1f3 g8f6 c2c4 g7g6 g2g3 f8g7 f1g2 e8g8",
    "e2e4 g8f6 e4e5 f6d5 c2c4 d5b6 d2d4 d7d6",
    "c2c4 b7b6 g1f3 c8b7 b1c3 e7e6 d2d3 g8f6",
    "g1f3 d7d5 d2d4 g8f6 c2c4 e7e6 g2g3 c7c6",
    "d2d4 e7e6 c2c4 f7f5 g1f3 g8f6 g2g3 f8e7",
    "e2e4 e7e6 d2d4 d7d5 b1c3 f8e7 g1f3 g8f6",
    "g2g3 d7d5 f1g2 c7c6 b2b3 c8h3 g2h3 g8f6",
    "d2d4 g7g6 e2e3 f8g7 g1f3 g8f6 f1e2 e8g8",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 f3d4 g8f6",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c8f5 h2h4 h7h5",
    "g1f3 g8f6 b2b3 b7b6 c1b2 c8b7 e2e3 e7e6",
    "d2d4 g8f6 c2c3 g7g6 g1f3 f8g7 c1f4 e8g8",
    "d2d4 d7d5 g1f3 g8f6 e2e3 e7e6 f1d3 f8e7",
    "e2e4 c7c5 g1f3 d7d6 b1c3 e7e5 f1c4 h7h6",
    "d2d4 b7b6 e2e3 c8b7 f2f4 a7a6 g1f3 e7e6",
    "d2d4 d7d5 c2c4 g8f6 g1f3 g7g6 c4d5 f8g7",
    "b2b3 g8f6 c1b2 g7g6 e2e4 f8g7 e4e5 f6d5",
    "e2e3 e7e5 f2f4 e5f4 e3f4 d7d5 d2d4 g8f6",
    "e2e4 e7e6 b1c3 d7d5 e4d5 e6d5 d2d4 c7c6",
    "d2d4 d7d5 g1f3 g8f6 c1f4 e7e6 e2e3 f8d6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 a7a6 b5a4 g8f6",
    "g2g3 e7e5 f1g2 g8f6 c2c4 f8c5 b1c3 d7d6",
    "g1f3 g8f6 g2g3 g7g6 b2b3 f8g7 c1b2 e8g8",
    "g2g3 d7d5 f1g2 d8d6 g1f3 g8f6 e1g1 e7e6",
    "e2e4 g8f6 e4e5 f6d5 d2d4 b7b5 g1f3 c7c6",
    "d2d4 d7d5 c2c3 e7e6 c1f4 f8d6 f4g3 h7h5",
    "c2c4 e7e6 d2d3 g8f6 b1d2 d7d5 g1f3 f8e7",
    "e2e4 c7c5 g1f3 b8c6 f1b5 g7g6 e1g1 f8g7",
    "e2e4 c7c5 g1f3 d7d6 d2d4 c5d4 f3d4 g8f6",
    "d2d4 c7c5 c2c4 c5d4 d1d4 b8c6 d4d2 g8f6",
    "d2d4 g8f6 c2c3 g7g6 c1g5 f8g7 b1d2 d7d5",
    "d2d3 c7c6 c2c4 d7d5 c4d5 c6d5 g2g3 g8f6",
    "b2b3 g8f6 c1b2 g7g6 g1f3 f8g7 e2e3 e8g8",
    "d2d4 d7d5 g1f3 g8f6 e2e3 c8g4 c2c4 c7c6",
    "g1f3 d7d6 g2g3 b8d7 d2d4 e7e6 f1g2 g8e7",
    "d2d4 d7d5 g1f3 g8f6 g2g3 c8f5 f1g2 d8c8",
    "g2g3 g7g6 f1g2 f8g7 g1f3 d7d6 e1g1 e7e6",
    "g2g3 g8f6 f1g2 g7g6 g1f3 f8g7 e1g1 b7b6",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 f3d4 b8c6",
    "b2b3 d7d5 c1b2 e7e6 a2a3 f7f5 e2e3 g8f6",
    "e2e4 g7g6 d2d4 f8g7 b1c3 c7c5 c1h6 g8h6",
    "f2f3 e7e5 e1f2 d7d5 f2g3 f7f5 e2e3 c7c5",
    "d2d4 g8f6 g1f3 c7c5 g2g3 b7b6 d4c5 b6c5",
    "g1f3 g8f6 b2b3 g7g6 c1b2 f8g7 e2e3 d7d6",
    "d2d4 d7d5 c2c4 e7e6 e2e3 g8f6 g1f3 f8e7",
    "e2e4 e7e5 g1f3 g8f6 f3e5 d7d6 e5f3 f6e4",
    "d2d4 g8f6 c1f4 g7g6 e2e3 d7d6 g1f3 f8g7",
    "g1f3 g8f6 b2b3 d7d6 c1b2 g7g6 b2f6 e7f6",
    "d2d4 g8f6 g1f3 e7e6 g2g3 b7b5 f1g2 c8b7",
    "d2d4 e7e6 g1f3 f7f5 g2g3 g8f6 f1g2 f8e7",
    "d2d4 g8f6 g1f3 g7g6 b1c3 f8g7 c1g5 d7d6",
    "g1f3 d7d5 d2d4 g8f6 c2c4 e7e6 c4d5 e6d5",
    "e2e4 c7c5 c2c3 b7b6 d2d4 c8b7 d4d5 g8f6",
    "e2e4 d7d6 b1c3 b8d7 g2g3 e7e5 f1g2 g8f6",
    "g2g3 d7d5 f1g2 c8g4 g1f3 g4f3 g2f3 e7e5",
    "e2e4 e7e5 g1f3 b8c6 f1b5 a7a6 b5c6 d7c6",
    "d2d4 d7d5 c2c4 e7e6 b1c3 g8f6 c1g5 f8e7",
    "e2e4 c7c5 b1c3 a7a6 g1f3 d7d6 d2d4 c5d4",
    "g2g3 g7g6 f1g2 f8g7 g1f3 d7d6 e1g1 b8c6",
    "b2b3 c7c6 c1b2 d7d5 g1f3 c8f5 d2d3 e7e6",
    "d2d4 d7d5 g1f3 e7e6 c1f4 g8f6 f4g3 f8d6",
    "c2c4 e7e6 b1c3 d7d6 e2e4 g8f6 d2d4 f8e7",
    "e2e4 c7c5 b1c3 b8c6 d2d3 g7g6 f2f4 f8g7",
    "g1f3 d7d5 d2d4 g8f6 c2c4 e7e6 c1g5 f8b4",
    "d2d4 c7c5 g1f3 c5d4 f3d4 g8f6 c2c4 g7g6",
    "g1f3 g8f6 g2g3 b7b6 f1g2 c8b7 e1g1 d7d6",
    "b2b3 e7e5 c2c4 b8c6 c1b2 g8f6 g1f3 e5e4",
    "b2b3 c7c5 c1b2 b8c6 g1f3 b7b6 e2e3 c8b7",
    "d2d4 b7b6 e2e4 c8b7 f1d3 e7e6 g1f3 g8f6",
    "e2e4 e7e6 d2d4 d7d5 b1c3 b8c6 g1f3 g8f6",
    "d2d4 g8f6 b1c3 d7d5 c1g5 b8d7 f2f3 c7c6",
    "g1f3 g7g6 d2d4 f8g7 e2e3 d7d6 a2a3 g8f6",
    "b2b3 d7d5 c1b2 g8f6 g2g3 c7c5 f1g2 b8c6",
    "e2e4 g7g6 d2d3 f8g7 b1d2 c7c5 g1f3 b8c6",
    "e2e4 d7d5 e4d5 g8f6 b1c3 c7c6 d5c6 b8c6",
    "d2d4 f7f5 c2c4 g8f6 g2g3 e7e6 f1g2 f8b4",
    "g2g3 g7g6 f1g2 f8g7 d2d4 e7e6 c2c3 g8e7",
    "g2g3 d7d5 g1f3 e7e5 f1g2 b8c6 d2d3 g8f6",
    "b2b3 d7d5 c1b2 g8f6 c2c4 b8c6 e2e3 e7e5",
    "f2f4 d7d5 g1f3 g8f6 e2e3 c7c6 f1e2 b8d7",
    "g2g3 d7d5 f1g2 c7c6 g1f3 g8f6 e1f1 g7g6",
    "e2e3 g8f6 d2d4 d7d5 g1f3 g7g6 f1e2 f8g7",
    "g2g3 d7d5 f1g2 b8c6 g1f3 c8f5 d2d3 d8d7",
    "d2d4 d7d5 c1g5 g8f6 g5f6 e7f6 e2e3 g7g6",
    "d2d4 g8f6 c2c4 d7d6 b1c3 g7g6 g1f3 f8g7",
    "e2e4 e7e5 g1f3 b8c6 d2d4 e5d4 f3d4 g8f6",
    "c2c4 g8f6 b1c3 d7d5 c4d5 f6d5 e2e4 d5c3",
    "e2e4 c7c5 g1f3 b8c6 d2d4 c5d4 f3d4 g7g6",
    "g1f3 b7b6 g2g3 c8b7 f1g2 a7a6 c2c4 b8c6",
    "g1f3 d7d5 b2b3 c7c5 c1b2 b8c6 e2e3 g8f6",
    "e2e4 c7c5 c2c3 d7d6 f1c4 g8f6 d2d3 e7e6",
    "d2d4 c7c5 e2e3 c5d4 e3d4 g7g6 c2c3 f8g7",
    "g1f3 g8f6 d2d4 e7e6 c1f4 d7d5 d1d2 f8d6",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 b1c3 f8e7",
    "b2b3 d7d5 c1b2 b8c6 g1f3 f7f6 d2d4 e7e5",
    "d2d4 c7c6 g1f3 d7d6 g2g3 b8d7 f1g2 d8c7",
    "e2e4 b8c6 d2d4 e7e5 d4d5 c6e7 g1f3 e7g6",
    "d2d4 d7d5 b1c3 g8f6 c1g5 b8d7 g1f3 h7h6",
    "g2g3 c7c5 f1g2 g7g6 g1f3 f8g7 e1g1 b8c6",
    "b1c3 g7g6 d2d4 f8g7 h2h4 g8f6 h4h5 f6h5",
    "e2e4 e7e6 d2d4 d7d5 b1c3 h7h6 e4e5 c7c5",
    "g2g3 d7d5 f1g2 e7e6 g1f3 c7c6 e1g1 b7b5",
    "d2d4 d7d5 c2c4 c7c6 b1c3 h7h5 c4d5 h5h4",
    "e2e4 c7c6 g1f3 d7d6 b1c3 b8d7 d2d4 e7e5",
    "e2e4 g8f6 e4e5 f6d5 c2c4 d5b6 c4c5 b6d5",
    "g1f3 g8f6 b2b4 d7d6 a2a3 g7g6 c1b2 f8g7",
    "d2d4 g8f6 g1f3 e7e6 g2g3 b7b6 f1g2 c8b7",
    "e2e3 g8f6 d2d4 e7e6 g1f3 b7b6 f1d3 c8b7",
    "g1f3 f7f5 d2d4 g8f6 g2g3 g7g6 f1g2 f8g7",
    "c2c4 e7e6 g2g3 d7d5 f1g2 g8f6 g1f3 f8e7",
    "c2c4 e7e6 b1c3 d7d5 g1f3 d5d4 c3e4 c7c5",
    "e2e3 c7c5 g1f3 b8c6 g2g3 g7g6 f1g2 f8g7",
    "g1f3 b8c6 b2b3 e7e5 c1b2 e5e4 f3d4 c6d4",
    "b2b3 e7e5 c1b2 b8c6 d2d3 f8b4 b1d2 d8e7",
    "d2d4 g8f6 c2c4 e7e6 g1f3 d7d5 b1c3 c7c5",
    "b2b3 g7g6 c1b2 g8f6 c2c4 f8g7 g1f3 e8g8",
    "e2e4 c7c5 g1f3 d7d6 d2d4 c5d4 f3d4 e7e5",
    "e2e4 b7b6 d2d4 c8b7 f1d3 a7a6 g1e2 e7e6",
    "d2d4 g8f6 c2c4 g7g6 g2g3 c7c5 d4d5 b7b5",
    "d2d4 d7d5 c2c4 g8f6 c4d5 f6d5 e2e4 d5f6",
    "g2g3 b7b6 f1g2 c7c6 e2e3 d7d5 g1e2 e7e6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 g8f6 e1g1 f6e4",
    "c2c4 c7c5 g2g3 g7g6 f1g2 f8g7 g1f3 b8c6",
    "e2e3 g8f6 d2d4 d7d5 f1d3 g7g6 g1f3 f8g7",
    "f2f4 e7e5 f4e5 d7d6 g1f3 d6e5 e2e4 g8f6",
    "e2e4 c7c6 g1f3 d7d5 e4d5 c6d5 d2d4 g8f6",
    "e2e4 e7e6 d2d4 d7d5 e4d5 e6d5 g1f3 f8d6",
    "d2d4 g8f6 g1f3 g7g6 c2c4 d7d5 c4d5 f6d5",
    "e2e4 d7d6 g1f3 c7c6 d2d4 d8c7 c2c4 b8d7",
    "e2e4 e7e6 g1f3 d7d5 e4e5 c8d7 a2a3 a7a5",
    "e2e3 e7e5 f2f4 e5f4 e3f4 d7d5 d2d4 c7c5",
    "g1f3 c7c5 e2e3 b8c6 d2d4 c5d4 e3d4 d7d5",
    "e2e4 c7c5 b1c3 d7d6 g2g3 g8f6 f1g2 g7g6",
    "d2d4 c7c5 g1f3 c5d4 f3d4 b8c6 g2g3 g7g6",
    "e2e4 e7e6 d2d4 c7c5 b1c3 c5d4 d1d4 b8c6",
    "d2d4 d7d5 b1c3 g8f6 c1f4 c8f5 e2e3 e7e6",
    "e2e4 c7c5 b1c3 e7e6 g2g3 d7d5 e4d5 e6d5",
    "e2e4 b7b6 g2g3 c8b7 f1g2 e7e6 b1c3 c7c5",
    "d2d4 e7e6 c2c4 f7f5 g1f3 g8f6 b1c3 f8e7",
    "e2e4 g8f6 e4e5 f6d5 g1f3 d5b6 b1c3 d7d5",
    "e2e4 g7g6 d2d4 f8g7 g1f3 d7d6 f1d3 c8g4",
    "d2d4 g8f6 c2c4 e7e6 g1f3 d7d5 b1d2 b8d7",
    "g1f3 f7f5 d2d4 g8f6 c1f4 d7d6 b1c3 g7g6",
    "g2g3 e7e5 f1g2 d7d6 d2d4 b8c6 d4e5 c6e5",
    "g2g3 h7h5 f1g2 h5h4 g3h4 h8h4 d2d4 h4h8",
    "d2d4 d7d5 c2c4 e7e6 b1c3 c7c5 c4d5 e6d5",
    "e2e4 c7c5 b1c3 b8c6 g2g3 g7g6 f1g2 f8g7",
    "b2b3 c7c6 c1b2 d7d6 g1f3 b8d7 e2e3 g8f6",
    "e2e4 g7g6 b1c3 d7d6 g1f3 h7h6 d2d4 e7e6",
    "e2e4 g7g6 f1c4 f8g7 d1f3 g8f6 e4e5 e8g8",
    "d2d4 d7d6 g1f3 b8d7 g2g3 c7c5 f1g2 c5d4",
    "d2d4 d7d5 g1f3 g8f6 c2c4 c7c6 b1c3 e7e6",
    "e2e4 c7c6 d2d4 d7d6 b1c3 b8d7 c3d5 e7e5",
    "f2f4 d7d5 e2e3 g8f6 g1f3 c7c5 f1e2 b8c6",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c6c5 d4c5 e7e6",
    "e2e4 e7e6 d2d4 d7d5 b1d2 d5e4 d2e4 b8d7",
    "b2b3 d7d5 c1b2 g8f6 g1f3 b7b6 g2g3 c8b7",
    "d2d4 d7d5 e2e3 h7h5 f1e2 h5h4 g1h3 c8h3",
    "d2d4 g8f6 g1f3 b7b6 g2g3 c8b7 f1g2 e7e6",
    "e2e4 e7e5 g1f3 d7d6 d2d4 g8f6 d4e5 f6e4",
    "e2e4 d7d5 e4d5 d8d5 g1f3 d5d8 f1e2 c7c6",
    "e2e4 e7e6 d2d4 d7d5 b1c3 g8f6 e4e5 f6d7",
    "d2d4 d7d5 b1c3 g8f6 e2e4 d5e4 f2f3 e4f3",
    "d2d4 g8f6 c1g5 d7d5 g5f6 g7f6 e2e3 c7c5",
    "g1f3 e7e6 d2d4 g8f6 c1f4 c7c5 c2c3 c5d4",
    "e2e4 d7d5 b1c3 d5e4 c3e4 g8f6 e4f6 e7f6",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d8 d2d4 c7c6",
    "b2b3 g8f6 c1b2 d7d6 a2a3 g7g6 e2e3 f8g7",
    "b2b3 d7d5 e2e3 c8f5 c1b2 e7e6 g2g4 f5g6",
    "g1f3 c7c5 g2g3 b7b6 f1g2 c8b7 e1g1 e7e6",
    "g2g3 g7g6 f1g2 f8g7 g1f3 d7d6 e1g1 g8f6",
    "c2c3 e7e5 d2d3 d7d5 b1d2 b8c6 g1f3 f7f5",
    "e2e4 g8f6 b1c3 d7d5 e4e5 d5d4 e5f6 d4c3",
    "d2d4 g8f6 g1f3 d7d5 e2e3 c7c5 f1d3 b8c6",
    "g2g3 d7d6 f1g2 b8d7 g1h3 g8f6 f2f3 g7g6",
    "d2d4 g8f6 c1g5 d7d5 g1f3 e7e6 e2e3 f8e7",
    "g1f3 g8f6 b2b3 g7g6 c1b2 f8g7 e2e3 b7b6",
    "d2d4 g8f6 c1g5 d7d5 e2e3 f6e4 g5f4 c7c5",
    "e2e4 c7c5 b1c3 b8c6 f2f4 g7g6 g1f3 f8g7",
    "d2d4 c7c6 g1f3 d7d6 c1g5 b8d7 e2e4 g8f6",
    "e2e4 g8f6 e4e5 f6d5 d2d4 d7d6 g1f3 g7g6",
    "g2g3 d7d5 f1g2 e7e6 g1f3 g8f6 e1g1 e6e5",
    "d2d3 d7d5 g1f3 b8d7 g2g3 e7e5 f1g2 c7c6",
    "b2b3 c7c5 a2a3 b8c6 c1b2 d7d5 e2e3 e7e5",
    "b2b3 g7g6 c1b2 g8f6 g1f3 f8g7 e2e4 f6h5",
    "g1f3 e7e5 d2d4 e5e4 f3e5 g8f6 f2f3 d7d5",
    "d2d3 e7e6 b1d2 d7d5 g1f3 c7c6 g2g3 g8f6",
    "e2e3 g7g6 f2f4 f8g7 g1f3 c7c5 f1e2 d7d6",
    "e2e4 e7e5 g1f3 g8f6 f3e5 b8c6 e5c6 d7c6",
    "g2g3 g8f6 g1f3 g7g6 f1g2 f8g7 e1g1 e8g8",
    "e2e4 d7d5 e4d5 g8f6 b1c3 f6d5 f1c4 d5c3",
    "f2f4 e7e6 g1f3 b7b6 b2b3 c8b7 c1b2 g8f6",
    "b2b3 d7d5 c1b2 c8g4 f2f3 g4h5 e2e4 e7e6",
    "d2d4 d7d5 c2c4 g8f6 c4d5 f6d5 b1c3 d5f6",
    "e2e4 e7e6 b1c3 d7d5 e4d5 e6d5 d2d4 g8f6",
    "d2d4 b7b6 e2e4 c8b7 b1c3 e7e6 a2a3 g8f6",
    "b2b3 g8f6 c1b2 e7e6 d2d4 f8e7 b1d2 e7a3",
    "d2d4 d7d5 g1f3 g8f6 c1f4 c7c5 e2e3 b8c6",
    "b2b3 d7d6 c1b2 c7c6 e2e3 b8d7 g1f3 d8c7",
    "e2e4 c7c6 g1f3 d7d5 e4d5 c6d5 d2d4 b8c6",
    "g2g3 c7c5 f1g2 b8c6 g1f3 d7d6 e1g1 g8f6",
    "b2b3 g8f6 c1b2 g7g6 b2f6 e7f6 e2e3 f8g7",
    "c2c4 e7e6 g1f3 f7f5 g2g3 g8f6 f1g2 f8e7",
    "e2e4 c7c5 d2d4 c5d4 g1f3 d7d6 f3d4 b8c6",
    "b2b3 g8f6 c1b2 g7g6 e2e4 d7d6 d2d4 f8g7",
    "e2e4 e7e5 g1f3 b8c6 f1c4 f8c5 c2c3 d7d6",
    "e2e4 c7c5 g1f3 g7g6 b1c3 f8g7 d2d4 c5d4",
    "e2e3 c7c6 g1f3 d7d6 d2d4 b8d7 e3e4 g8f6",
    "g2g3 d7d5 f1g2 c8h3 g2h3 e7e6 h3g2 g8f6",
    "g1f3 b8c6 b2b3 e7e5 c1b2 d7d6 d2d4 e5d4",
    "b2b3 b7b6 c1b2 c8b7 g1f3 a7a6 e2e3 e7e6",
    "g1f3 b8c6 g2g3 e7e5 d2d4 d7d5 f3e5 c6e5",
    "d2d4 d7d5 c2c4 e7e6 b1c3 c7c5 c4d5 c5d4",
    "b2b3 g8f6 c1b2 b7b6 b2f6 e7f6 g1f3 c8b7",
    "e2e4 c7c5 g1f3 g7g6 d2d4 c5d4 d1d4 g8f6",
    "e2e4 e7e6 d2d4 c7c6 b1c3 d7d5 f1d3 f7f5",
    "e2e3 g7g6 d2d4 e7e5 g1f3 e5d4 d1d4 g8f6",
    "g2g4 e7e6 f1g2 d7d5 c2c4 c7c6 c4d5 c6d5",
    "c2c4 g8f6 g1f3 c7c6 b2b3 d7d5 c1b2 c8g4",
    "g1f3 c7c5 g2g3 b8c6 f1g2 g7g6 e1g1 f8g7",
    "f2f4 d7d5 g1f3 c7c5 e2e3 b8c6 f1b5 c8d7",
    "d2d3 g7g6 c1d2 f8g7 g1f3 g8f6 d2c3 e8g8",
    "e2e4 e7e5 b1c3 g8f6 g1f3 b8c6 f1c4 f8c5",
    "e2e4 b7b6 b1c3 c8b7 d2d4 a7a6 f1d3 e7e6",
    "d2d3 g7g6 e2e4 f8g7 b1c3 d7d5 h2h4 d5e4",
    "e2e4 d7d5 b1c3 d5e4 c3e4 b8c6 g1f3 e7e5",
    "c2c4 e7e6 b1c3 d7d5 g2g3 g8f6 d2d4 c7c5",
    "e2e4 d7d6 g1f3 g8f6 d2d3 b8d7 b1d2 e7e5",
    "e2e4 e7e6 d2d4 c7c5 d4d5 d7d6 b1c3 e6e5",
    "d2d4 e7e6 b1c3 d7d5 e2e4 b8c6 g1f3 g8f6",
    "c2c3 g7g6 d2d3 d7d6 b1d2 h7h6 g1f3 f8g7",
    "g2g3 d7d6 f1g2 b8d7 g1f3 g8f6 e1g1 g7g6",
    "e2e4 b7b6 d2d4 c8b7 b1c3 e7e6 g1f3 d7d5",
    "e2e4 d7d5 e4d5 c7c6 g1f3 g8f6 h2h3 c6d5",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c6c5 g1f3 e7e6",
    "g1f3 d7d6 d2d4 g7g6 g2g3 f8g7 f1g2 g8f6",
    "f2f4 b8c6 g1f3 d7d6 e2e4 c8g4 f1c4 g8f6",
    "e2e4 e7e6 d2d4 d7d5 b1c3 g8f6 c1g5 f6d7",
    "f2f4 e7e5 f4e5 d7d6 e5d6 f8d6 g1f3 g7g5",
    "g1f3 g8f6 d2d4 g7g6 c1f4 f8g7 d1c1 e8g8",
    "e2e3 g8f6 f2f4 g7g6 g1f3 f8g7 f1e2 e8g8",
    "g1f3 e7e6 d2d3 d7d5 e2e3 c7c5 d3d4 g8f6",
    "e2e4 d7d6 b1c3 g8f6 d2d4 g7g6 f2f4 f8g7",
    "d2d4 d7d6 g1f3 c8g4 f3d2 e7e5 h2h3 g4h5",
    "d2d3 g7g6 b1d2 f8g7 g1f3 g8f6 g2g3 e8f8",
    "g1f3 c7c6 e2e3 d7d5 d2d4 b8d7 c2c4 g8f6",
    "b2b4 g8f6 c1b2 d7d6 a2a3 g7g6 e2e3 f8g7",
    "e2e4 e7e5 g1f3 g8f6 f3e5 b8c6 e5f3 d7d5",
    "e2e4 c7c5 g1f3 b8c6 c2c3 g8f6 e4e5 f6d5",
    "b2b3 d7d6 c1b2 b8d7 a2a3 g8f6 e2e3 g7g6",
    "g1f3 d7d5 e2e4 g8f6 e4e5 f6d7 d2d4 e7e6",
    "g1f3 e7e5 g2g3 e5e4 f3d4 g8f6 d2d3 c7c5",
    "d2d4 g8f6 c2c4 e7e6 g1f3 d7d5 b1c3 a7a6",
    "d2d3 d7d5 g2g3 g8f6 f1g2 c7c6 b1c3 c8g4",
    "b1c3 g7g6 e2e4 f8g7 h2h4 c7c5 h4h5 g8f6",
    "d2d4 c7c6 b1c3 d7d6 e2e4 b8d7 f2f4 e7e5",
    "b2b3 g8f6 c1b2 c7c5 e2e3 b8c6 g2g4 h7h6",
    "d2d4 g8f6 c2c4 c7c5 g1f3 c5d4 f3d4 e7e5",
    "e2e4 e7e5 g1f3 b8c6 f1c4 f8c5 c2c3 g8f6",
    "f2f4 e7e5 f4e5 d7d6 g1f3 b8c6 e2e4 d6e5",
    "d2d4 g8f6 g1f3 c7c6 g2g3 d7d5 f1g2 c8f5",
    "d2d3 g7g6 b1d2 f8g7 g1f3 g8f6 g2g3 e8g8",
    "g2g3 d7d5 f1g2 c7c6 c2c4 g8f6 c4d5 c6d5",
    "e2e4 d7d5 e4d5 d8d5 g1f3 c8f5 f1e2 b8c6",
    "d2d4 g8f6 c2c4 e7e6 b1c3 d7d5 g1f3 f8e7",
    "g1f3 d7d6 d2d4 g8f6 b2b3 g7g6 c1b2 f8g7",
    "d2d4 c7c5 g1f3 c5d4 f3d4 e7e5 d4b3 f8e7",
    "b2b3 f7f5 c1b2 g8f6 d2d4 g7g6 g1f3 f8g7",
    "g1f3 e7e5 c2c3 e5e4 f3d4 d7d5 d4c2 g8f6",
    "b2b3 b7b5 c1b2 c8b7 e2e3 e7e6 g1f3 g8f6",
    "e2e4 g7g6 f1c4 e7e6 d1f3 f8g7 d2d3 g8e7",
    "d2d4 d7d6 c1f4 c8g4 f2f3 g4h5 g2g4 h5g6",
    "d2d4 g8f6 c1g5 d7d5 e2e3 b8d7 g1f3 c7c6",
    "d2d4 g7g6 g1f3 f8g7 h2h4 h7h5 f3g5 g8f6",
    "g1f3 e7e6 d2d4 c7c5 e2e3 g8f6 b1c3 c5d4",
    "e2e4 e7e6 b1c3 d7d5 e4d5 e6d5 d2d4 h7h6",
    "d2d4 g8f6 g1f3 c7c5 g2g3 c5d4 f1g2 b8c6",
    "d2d4 g8f6 c1g5 c7c5 e2e3 f6e4 g5f4 d8b6",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c6c5 g1f3 c5d4",
    "b2b3 g7g6 c1b2 g8f6 g1f3 f8g7 g2g3 b7b6",
    "e2e4 g7g5 g1f3 g5g4 f3e5 d7d6 e5d3 f8g7",
    "b2b3 g8f6 c1b2 g7g6 a2a3 f8g7 e2e3 e8g8",
    "g1f3 g7g5 b2b3 g5g4 c1b2 g8f6 f3e5 d7d6",
    "d2d4 d7d5 c2c4 c7c6 b1c3 g8f6 c1f4 d5c4",
    "e2e4 c7c5 b1c3 e7e6 f2f4 b8c6 g1f3 g7g6",
    "d2d4 g8f6 c2c4 g7g6 b1c3 d7d5 c4d5 f6d5",
    "d2d4 g8f6 c2c4 g7g6 b1c3 f8g7 e2e4 d7d6",
    "c2c3 d7d5 b2b3 g8f6 c1b2 c7c5 d2d3 b8c6",
    "e2e4 c7c5 g1f3 e7e6 d2d3 d7d5 f1e2 d5e4",
    "g1f3 g8f6 g2g3 d7d5 f1g2 c7c5 e1g1 b8c6",
    "e2e3 c7c5 f2f4 g8f6 g1f3 g7g6 f1e2 f8g7",
    "d2d4 g8f6 b1c3 c7c5 d4d5 d7d6 e2e4 c8d7",
    "d2d4 g8f6 b1c3 e7e6 c1g5 d7d5 e2e4 d5e4",
    "g1f3 g8f6 g2g3 g7g6 f1g2 f8g7 e1g1 d7d5",
    "e2e4 g8f6 e4e5 f6d5 d2d4 d7d6 c2c4 d5b6",
    "e2e4 e7e6 d2d4 d7d5 e4e5 h7h6 c2c3 c7c5",
    "c2c4 g8f6 b1c3 e7e6 e2e4 d7d5 e4d5 e6d5",
    "g2g3 d7d5 f1g2 e7e6 g1f3 c7c6 e1g1 g8f6",
    "e2e4 c7c6 g1f3 d7d6 d2d3 b8d7 b1c3 e7e5",
    "b2b3 g8f6 c1b2 g7g6 e2e3 d7d5 g2g4 c7c5",
    "d2d4 c7c5 g1f3 c5d4 d1d4 g8f6 d4h4 g7g6",
    "d2d4 g8f6 c1g5 e7e6 e2e4 h7h6 g5f6 d8f6",
    "e2e3 g8f6 g1f3 g7g6 d2d4 f8g7 f1e2 e8g8",
    "d2d4 b7b6 g1f3 c8b7 g2g3 a7a6 f1g2 e7e6",
    "d2d4 g8f6 c2c4 e7e6 g1f3 c7c5 d4d5 e6d5",
    "e2e4 c7c5 c2c3 d7d5 e4d5 d8d5 d2d4 g8f6",
    "e2e4 g7g6 d2d4 f8g7 b1c3 d7d6 c1e3 g8f6",
    "d2d4 e7e5 e2e3 e5d4 e3d4 d7d5 f1d3 f8e7",
    "e2e4 c7c5 g1f3 d7d6 d2d3 g7g6 g2g3 f8g7",
    "g1f3 c7c5 b2b3 g7g6 c1b2 g8f6 c2c4 f8g7",
    "e2e4 b7b5 g1f3 a7a6 d2d4 c7c5 f1d3 c5d4",
    "e2e3 g8f6 f2f4 g7g6 g1f3 f8g7 f4f5 g6f5",
    "d2d4 g7g6 c1h6 f8g7 e2e3 g7h6 g1f3 h6g7",
    "e2e4 e7e5 d2d4 e5d4 g1f3 b8c6 f1c4 f8c5",
    "e2e4 e7e6 d2d3 c7c5 b1d2 b8c6 g2g3 g7g6",
    "d2d4 d7d5 c2c3 g8f6 g1f3 b8c6 c1g5 c8f5",
    "g2g3 g7g6 f1g2 f8g7 g1f3 g8f6 e1g1 h7h5",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c6c5 c2c3 b8c6",
    "d2d4 g8f6 g2g4 d7d5 b1c3 c8g4 f2f3 g4f5",
    "e2e4 e7e6 d2d4 d7d5 e4e5 c7c5 c2c3 f7f5",
    "e2e4 e7e6 g1f3 d7d5 e4d5 e6d5 h2h3 b8c6",
    "d2d4 d7d5 e2e3 g8f6 f1d3 c7c5 g1e2 c5d4",
    "g1f3 g7g6 d2d4 d7d6 c2c4 h7h6 d4d5 e7e6",
    "e2e4 e7e6 d2d4 d7d5 b1c3 c7c5 e4d5 c5d4",
    "c2c3 d7d5 d2d3 e7e5 b1d2 g8f6 g1f3 f8d6",
    "e2e4 e7e6 d2d4 d7d5 e4e5 c7c5 c2c3 d8b6",
    "d2d4 d7d5 c2c4 e7e6 g1f3 g8f6 g2g3 d5c4",
    "e2e4 c7c5 d2d4 b8c6 c2c3 c5d4 c3d4 d7d5",
    "e2e3 c7c6 f1e2 d7d5 g1f3 e7e6 d2d4 g7g5",
    "b2b3 d7d5 c1b2 c8g4 g1f3 g4f3 e2f3 g8f6",
    "e2e4 d7d5 e4d5 d8d5 d2d4 d5d8 c2c4 c7c6",
    "e2e4 d7d5 b1c3 d5e4 c3e4 e7e5 d2d4 c8f5",
    "e2e4 d7d5 e4d5 g8f6 d2d4 c8g4 g1f3 d8d5",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c8f5 g1f3 h7h6",
    "b2b3 g8f6 c1b2 g7g6 c2c3 f8g7 g2g3 e8g8",
    "e2e4 c7c5 f1e2 e7e6 d2d3 b8c6 f2f4 g8f6",
    "g1f3 d7d5 d2d4 c7c5 c2c4 g8f6 c4d5 c5d4",
    "e2e4 b8c6 d2d4 d7d5 e4d5 d8d5 g1f3 c8g4",
    "d2d4 g8f6 b1c3 e7e6 c1g5 f8b4 e2e4 h7h6",
    "d2d3 d7d5 c2c3 e7e5 d1c2 g8f6 e2e4 b8c6",
    "f2f4 d7d5 g1f3 g8f6 e2e3 c7c6 d2d3 c8g4",
    "g1f3 b7b6 g2g3 c8b7 f1g2 a7a6 e1g1 e7e6",
    "d2d4 d7d5 b1c3 e7e6 e2e4 d5e4 c3e4 f8e7",
    "d2d4 d7d5 c1f4 g8f6 e2e3 e7e6 c2c4 f8e7",
    "d2d4 c7c5 c2c4 c5d4 d1d4 g7g6 d4d1 f8g7",
    "d2d4 g8f6 e2e3 g7g6 f1e2 f8g7 h2h4 e8g8",
    "d2d4 g8f6 g1f3 d7d5 b1d2 f6e4 e2e3 c8f5",
    "d2d4 g7g6 c2c4 d7d6 b1c3 h7h6 e2e4 f8g7",
    "g1f3 e7e6 g2g3 h7h5 f1g2 h5h4 f3h4 h8h4",
    "e2e4 e7e6 d2d3 d7d5 e4e5 c7c5 f2f4 b8c6",
    "c2c4 d7d6 e2e3 e7e6 g1f3 g8f6 b1c3 f8e7",
    "e2e4 c7c6 d2d4 d7d6 e4e5 b8d7 e5e6 f7e6",
    "d2d4 g8f6 c2c4 e7e6 b1c3 c7c5 d4d5 e6d5",
    "e2e4 c7c5 g1f3 b8c6 f1b5 g7g5 f3g5 g8f6",
    "e2e4 c7c5 g1f3 b8c6 f1b5 g7g6 b5c6 d7c6",
    "e2e4 e7e5 d2d4 g8f6 g1f3 f6e4 d4e5 d7d5",
    "e2e4 e7e6 b1c3 d7d5 g1f3 g8f6 e4e5 f6d7",
    "e2e4 e7e6 d2d4 d7d5 b1c3 d5e4 c3e4 g8f6",
    "e2e4 b8c6 g1f3 e7e5 f1b5 f8c5 b5c6 d7c6",
    "d2d4 g7g6 e2e3 f8g7 g1f3 g8f6 h2h4 e8g8",
    "e2e4 a7a5 g1f3 b7b6 a2a3 c8a6 d2d3 g7g6",
    "d2d4 g8f6 f2f3 c7c5 d4d5 e7e6 e2e4 e6d5",
    "d2d4 g8f6 g1f3 c7c5 g2g3 c5d4 f3d4 b8c6",
    "e2e4 e7e6 d2d4 c7c6 e4e5 d7d5 e5d6 f8d6",
    "b2b3 d7d5 c1b2 c8f5 d2d3 e7e6 b1d2 h7h6",
    "d2d4 g8f6 c2c4 c7c5 d4d5 g7g6 b1c3 f8g7",
    "e2e4 e7e6 d2d4 d7d5 b1d2 g8f6 e4e5 f6d7",
    "e2e4 e7e6 f2f4 d7d5 e4e5 c7c5 g1f3 b8c6",
    "e2e4 e7e6 d2d3 d7d5 e4e5 c7c5 f2f4 c8d7",
    "d2d4 g8f6 c2c4 e7e6 g2g3 c7c5 d4d5 e6d5",
    "d2d4 c7c5 d4d5 b7b5 e2e4 c5c4 a2a4 f7f5",
    "d2d4 c7c5 d4c5 e7e5 g1f3 f8c5 e2e3 d7d6",
    "g1f3 c7c5 g2g3 e7e6 f1g2 a7a6 c2c4 g8f6",
    "c2c3 e7e6 d2d3 d7d5 b1d2 g8f6 g1f3 f8e7",
    "g1f3 c7c5 g2g3 e7e6 f1g2 g8f6 e1g1 d7d5",
    "e2e4 e7e5 g1f3 b8c6 f1c4 f8c5 e1g1 g8f6",
    "d2d4 d7d5 c1f4 c7c5 b1c3 g8f6 g1f3 c5d4",
    "d2d4 d7d6 g1f3 h7h6 c1f4 g7g5 f4g3 g5g4",
    "e2e4 e7e5 g1f3 b8c6 f1b5 g8f6 d2d3 f8c5",
    "b2b3 c7c6 c1b2 d7d5 a2a3 g8f6 e2e3 c8g4",
    "e2e4 e7e5 d2d4 b8c6 d4d5 c6e7 f2f3 e7g6",
    "d2d4 g8f6 e2e4 e7e6 e4e5 f6d5 c2c4 d5b6",
    "e2e4 b7b6 d2d4 c8b7 b1c3 e7e6 f2f4 f8b4",
    "e2e4 e7e6 d1e2 d7d5 e4d5 d8d5 b1c3 d5d8",
    "e2e4 c7c5 b1c3 d7d5 g1f3 d5d4 c3e2 b8c6",
    "g1f3 g8f6 d2d4 e7e6 c1f4 c7c5 b1c3 b8c6",
    "e2e4 e7e6 g1f3 c7c6 b1c3 d7d6 d2d4 b7b6",
    "c2c4 c7c6 g1f3 d7d5 g2g3 g8f6 f1g2 d5c4",
    "d2d4 d7d5 g1f3 e7e6 g2g3 g8f6 f1g2 c7c5",
    "g1f3 g7g6 d2d4 f8g7 c2c3 g8f6 c1f4 e8g8",
    "e2e4 e7e5 b1c3 d8h4 g1f3 h4h5 d2d4 e5d4",
    "e2e4 e7e5 d2d4 g8f6 b1d2 e5d4 g1f3 d7d5",
    "g1f3 d7d5 c2c4 e7e6 g2g3 d5c4 d1a4 b8c6",
    "b2b3 g7g6 c1b2 g8f6 b2f6 e7f6 c2c4 f8g7",
    "e2e4 d7d6 d2d4 e7e6 b1c3 g8f6 c1e3 f8e7",
    "c2c3 b7b6 d2d3 c8b7 b1d2 a7a6 g1f3 e7e6",
    "d2d4 g8f6 b1c3 d7d5 g1f3 c7c6 c1f4 c8f5",
    "d2d4 g8f6 c2c4 e7e6 b1c3 c7c5 g1f3 c5d4",
    "d2d4 c7c5 e2e4 c5d4 c2c3 d4c3 b1c3 b8c6",
    "g2g3 c7c6 f1g2 d7d5 g1f3 g8f6 e1g1 g7g6",
    "d2d4 e7e5 d4e5 d7d6 g1f3 b8c6 b1c3 c6e5",
    "e2e4 c7c5 b1c3 e7e6 f2f4 b8c6 g1f3 g8f6",
    "e2e3 c7c6 f2f4 d7d5 g1f3 g8f6 f1e2 c8f5",
    "b2b3 g8f6 c1b2 g7g6 g2g3 f8g7 f1g2 e8g8",
    "g1f3 c7c5 g2g3 e7e6 f1g2 f8e7 e1g1 h7h5",
    "e2e4 e7e6 d2d3 d7d5 b1d2 c7c5 f2f4 b8c6",
    "g2g3 g8f6 f1g2 c7c6 g1f3 d7d5 e1g1 c8f5",
    "g1f3 g7g6 b2b3 f8g7 b1c3 g8f6 c1b2 e8g8",
    "e2e4 e7e6 g1f3 d7d5 e4d5 e6d5 h2h3 c7c6",
    "g1f3 g7g6 c2c4 f8g7 b1c3 b7b5 c4b5 a7a6",
    "d2d4 g8f6 c2c4 g7g6 b1c3 d7d6 e2e4 f8g7",
    "e2e4 e7e6 d2d4 d7d5 b1d2 f8e7 g1f3 g8f6",
    "d2d4 g8f6 g1f3 e7e6 g2g3 d7d5 f1g2 f8e7",
    "e2e4 e7e6 g1f3 d7d5 e4d5 e6d5 d2d4 g8f6",
    "b2b3 d7d6 c1b2 e7e5 d2d4 e5e4 e2e3 f7f5",
    "e2e3 g8f6 g1f3 d7d5 d2d4 c7c6 f1d3 g7g6",
    "e2e4 c7c6 d2d4 d7d5 f2f3 g7g6 b1c3 f8g7",
    "a2a3 c7c5 b1c3 b8c6 e2e4 g7g6 f1c4 f8g7",
    "b2b3 g8f6 c1b2 c7c5 e2e3 b8c6 a2a3 d7d5",
    "d2d4 c7c6 g1f3 d7d6 e2e3 b8d7 b2b3 g8f6",
    "d2d4 d7d5 c1f4 g8f6 e2e3 e7e6 c2c3 c7c5",
    "e2e4 b7b6 d2d4 c8b7 b1c3 g8f6 d4d5 e7e6",
    "e2e4 e7e6 d2d4 c7c5 b1d2 c5d4 d2f3 b8c6",
    "e2e4 d7d5 e4d5 d8d5 d2d4 d5d8 c2c4 g8f6",
    "g1f3 c7c5 b2b3 g7g6 c1b2 g8f6 e2e3 f8g7",
    "e2e4 c7c5 d2d4 c5d4 d1d4 d7d5 d4e3 d5e4",
    "d2d4 c7c5 g1f3 c5d4 f3d4 d7d6 d4f3 g8f6",
    "d2d4 d7d5 c1f4 g8f6 e2e3 c7c5 b1c3 c5d4",
    "d2d4 d7d5 c2c4 e7e6 g2g3 a7a6 f1g2 d5c4",
    "e2e4 d7d5 e4d5 d8d5 g1f3 g8f6 d2d4 c7c6",
    "d2d4 c7c5 e2e4 c5d4 c2c3 b8c6 g1f3 d7d5",
    "c2c4 e7e5 b1c3 f8b4 c3d5 b4c5 g1f3 c7c6",
    "e2e4 g7g6 d2d4 f8g7 b1c3 c7c6 c1e3 d7d5",
    "e2e4 b7b6 d2d4 c8b7 f1d3 a7a6 g1f3 e7e6",
    "c2c3 e7e6 d2d3 f7f5 b1d2 g8f6 e2e4 d7d5",
    "d2d4 g8f6 g1f3 g7g6 e2e3 d7d6 b2b3 f8g7",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c8f5 h2h4 h7h6",
    "g1f3 g8f6 g2g3 g7g6 b2b3 d7d5 c1b2 c7c5",
    "d2d4 d7d5 g1f3 c7c6 c2c4 g8f6 e2e3 a7a6",
    "d2d4 c7c5 g1f3 c5c4 e2e4 d7d5 e4d5 d8d5",
    "e2e4 c7c5 b1c3 b8c6 g2g3 e7e6 f1g2 g8f6",
    "b2b3 g8f6 c1b2 d7d6 e2e3 g7g6 h2h3 f8g7",
    "d2d3 g7g6 g1f3 f8g7 g2g3 b7b6 f1g2 c8b7",
    "c2c4 d7d6 b1c3 g8f6 d2d3 g7g6 g1f3 f8g7",
    "e2e4 c7c5 c2c3 d7d5 e4d5 d8d5 d2d4 e7e6",
    "d2d4 g8f6 c1g5 g7g6 g5f6 e7f6 c2c4 d7d5",
    "d2d4 g8f6 c2c4 g7g6 a2a3 c7c5 d4d5 b7b5",
    "g1f3 g7g6 g2g3 f8g7 f1g2 g8f6 e1g1 e8g8",
    "d2d4 d7d5 g1f3 g8f6 g2g3 c8f5 f1g2 c7c6",
    "e2e4 b8a6 b1c3 c7c6 f1a6 b7a6 g1f3 d7d5",
    "g1f3 g8f6 c2c4 c7c5 b1c3 d7d5 c4d5 f6d5",
    "e2e4 g8f6 e4e5 f6d5 c2c4 d5b6 a2a4 a7a5",
    "e2e4 c7c5 g1f3 b8c6 f1b5 d7d6 c2c3 g8f6",
    "c2c4 e7e6 b1c3 d7d5 d2d4 g8f6 g1f3 d5c4",
    "d2d4 d7d5 c2c4 e7e6 b1c3 c7c6 e2e4 d5e4",
    "e2e4 e7e6 d2d4 d7d5 b1d2 c7c5 g1f3 c5d4",
    "b2b3 c7c5 c1b2 d7d5 a2a3 b8c6 e2e3 g8f6",
    "d2d4 g8f6 g1f3 e7e6 c1f4 d7d5 b1d2 c7c5",
    "d2d4 e7e6 g1f3 c7c5 g2g3 c5d4 f1g2 g8f6",
    "g1f3 d7d6 b2b3 g8f6 c1b2 g7g6 e2e3 f8g7",
    "e2e4 c7c5 b1c3 d7d6 g1f3 g7g6 d2d4 c5d4",
    "e2e4 e7e6 d2d4 d7d5 c1e3 d5e4 f2f3 g8f6",
    "d2d4 e7e6 b1d2 d7d5 d2f3 f7f5 e2e3 g8f6",
    "d2d4 c7c5 e2e4 c5d4 c2c3 d4c3 b1c3 e7e6",
    "d2d4 e7e6 g1f3 f7f5 c2c4 g8f6 b1c3 f8e7",
    "d2d4 d7d5 c2c4 e7e6 b1c3 c7c6 g1f3 b8d7",
    "e2e4 g7g6 d2d4 f8g7 g1f3 c7c6 c2c4 d7d5",
    "e2e4 e7e5 b1c3 g8f6 g1f3 d7d6 d2d4 b8d7",
    "g1f3 c7c5 g2g3 d7d6 f1g2 e7e6 e1g1 g8f6",
    "d2d4 e7e5 c2c4 e5d4 d1d4 b8c6 d4d1 f8b4",
    "d2d4 d7d5 b1c3 g8f6 c1g5 g7g6 g5f6 e7f6",
    "b1c3 d7d5 e2e4 d5d4 c3e2 d4d3 c2d3 d8d3",
    "d2d4 c7c5 d4d5 d7d6 c2c4 g8f6 b1c3 g7g6",
    "c2c4 g7g6 g1f3 d7d6 g2g3 h7h6 f1g2 f8g7",
    "e2e4 c7c6 g1f3 d7d5 d2d3 d5e4 d3e4 d8d1",
    "d2d4 g8f6 c1f4 d7d6 g1f3 c8g4 f3d2 b8d7",
    "g1f3 g8f6 g2g3 g7g6 f1g2 f8g7 e1g1 e8f8",
    "d2d4 e7e6 g1f3 d7d5 c1f4 f7f5 f4g3 g8f6",
    "d2d4 e7e6 g1f3 g8f6 g2g3 f8e7 f1g2 e8g8",
    "g1f3 d7d5 g2g3 e7e6 f1g2 g8f6 d2d4 f8d6",
    "c2c4 b7b6 b1c3 c8b7 d2d3 e7e6 e2e4 g8f6",
    "d2d4 c7c5 g1f3 c5d4 f3d4 b8c6 d4f3 g8f6",
    "e2e4 g7g6 g1f3 f8g7 d2d3 c7c5 f1e2 b8c6",
    "d2d4 g8f6 b1c3 g7g6 e2e4 d7d6 f1e2 f8g7",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d6 d2d4 g8f6",
    "c2c3 g7g6 d2d3 f8g7 b1d2 e7e6 g1f3 g8e7",
    "e2e4 c7c5 g1f3 g7g6 c2c3 d7d5 e4d5 d8d5",
    "d2d4 g8f6 c2c4 g7g6 e2e3 f8g7 g1f3 d7d6",
    "e2e4 e7e5 d2d3 b8c6 a2a3 g7g6 g1f3 f8g7",
    "d2d4 c7c5 e2e4 c5d4 c2c3 d7d6 c3d4 g8f6",
    "d2d4 e7e6 c2c4 f8b4 b1c3 c7c5 d4d5 f7f5",
    "e2e4 e7e6 d2d4 d7d5 b1c3 f8b4 e4e5 c7c5",
    "d2d4 g8f6 e2e3 g7g6 g1f3 f8g7 f1e2 e8g8",
    "d2d4 e7e6 g1f3 d7d5 c1g5 f7f6 g5f4 f6f5",
    "e2e4 b7b6 d2d4 a7a6 b1d2 c8b7 f1d3 e7e6",
    "e2e4 c7c5 g1f3 e7e6 c2c3 d7d5 e4d5 e6d5",
    "b2b3 g8f6 c1b2 g7g6 e2e3 f8g7 g2g4 h7h6",
    "d2d4 g8f6 c2c4 e7e6 g1f3 d7d5 b1c3 b8d7",
    "e2e4 c7c5 b1c3 b8c6 f1b5 e7e6 b5c6 b7c6",
    "d2d4 g8f6 c2c4 e7e6 g1f3 c7c5 g2g3 c5d4",
    "e2e4 d7d6 g1f3 g8f6 b1c3 g7g6 d2d4 f8g7",
    "c2c3 c7c5 d2d3 e7e6 b1d2 g8f6 g1f3 e8e7",
    "d2d4 b7b6 g1f3 c8b7 g2g3 g8f6 f1g2 g7g6",
    "e2e4 e7e6 g1f3 d7d5 e4d5 e6d5 d2d4 b8c6",
    "d2d4 g8f6 c1g5 e7e6 e2e4 f8e7 e4e5 f6d5",
    "d2d4 h7h6 g1f3 g7g5 e2e3 f8g7 h2h3 g5g4",
    "d2d4 c7c5 b1c3 c5d4 d1d4 b8c6 d4a4 d7d6",
    "e2e4 c7c5 b1c3 d7d6 g1f3 g8f6 e4e5 d6e5",
    "d2d4 d7d6 c2c4 g8f6 g1f3 g7g6 g2g3 f8g7",
    "e2e4 e7e5 d2d4 e5d4 g1f3 b8c6 f1c4 g8f6",
    "e2e4 e7e5 g1f3 f8c5 f1c4 g8f6 e1g1 f6e4",
    "d2d4 c7c5 d4d5 g8f6 b1c3 d7d6 e2e4 g7g6",
    "f2f4 d7d5 g1f3 c8f5 d2d3 e7e6 g2g3 h7h5",
    "g1f3 g8f6 d2d4 g7g6 c1f4 f8g7 d1d2 d7d5",
    "g1f3 c7c6 g2g3 d7d5 f1g2 c8g4 c2c4 e7e6",
    "d2d4 d7d5 c2c4 c7c6 b1c3 g8f6 e2e3 e7e6",
    "e2e4 e7e6 d2d4 d7d5 b1c3 g8f6 c1g5 f8e7",
    "d2d4 d7d6 g1f3 g8f6 c1f4 b8d7 h2h3 b7b6",
    "e2e4 b7b6 g1f3 c8b7 b1c3 a7a6 f1c4 e7e6",
    "d2d4 d7d6 g1f3 g8f6 c2c4 c8g4 f3d2 b8d7",
    "g1f3 g7g6 d2d4 f8g7 c1f4 c7c5 e2e3 g8f6",
    "d2d4 g7g6 h2h4 f8g7 h4h5 g8f6 h5h6 g7f8",
    "g1f3 d7d5 g2g3 c7c6 f1g2 g8f6 e1g1 e7e6",
    "e2e4 c7c5 g1f3 b8c6 f1b5 e7e6 e1g1 g8f6",
    "d2d4 c7c6 g1f3 d7d6 c2c4 b8d7 b1c3 g8f6",
    "e2e3 e7e5 d2d4 e5d4 e3d4 g8f6 f2f4 d7d5",
    "d2d4 g8f6 c2c4 c7c5 d4d5 b7b5 c4b5 a7a6",
    "e2e4 e7e5 b1c3 b8c6 d2d4 e5d4 c3d5 f8c5",
    "e2e4 e7e5 d2d4 e5d4 d1d4 b8c6 d4e3 g8f6",
    "d2d4 e7e6 b1c3 f8b4 a2a3 b4c3 b2c3 d7d5",
    "d2d4 e7e6 b1c3 d7d5 e2e4 b8c6 e4d5 e6d5",
    "b2b3 g8f6 c1b2 g7g6 e2e3 f8g7 g2g4 d7d6",
    "e2e4 e7e5 g1f3 b8c6 d2d4 e5d4 c2c3 d7d5",
    "e2e4 c7c6 d2d4 d7d5 e4d5 c6d5 g1f3 g8f6",
    "c2c4 e7e6 d2d3 d7d5 b1d2 c7c6 g1f3 g8f6",
    "d2d4 f7f5 c1f4 g8f6 e2e3 g7g6 h2h4 h7h6",
    "e2e4 a7a5 b1c3 a5a4 f1c4 h7h5 a2a3 e7e6",
    "g1f3 e7e6 e2e3 b7b6 c2c4 c8b7 b2b3 g8f6",
    "d2d4 g8f6 b1c3 g7g6 c1f4 f8g7 e2e4 e8g8",
    "d2d4 g8f6 g1f3 g7g6 c2c4 c7c5 d4d5 f8g7",
    "d2d4 g8f6 c1g5 g7g6 g5f6 e7f6 c2c4 f8g7",
    "b2b3 e7e5 a2a3 b8c6 c1b2 g7g6 e2e3 f8g7",
    "g1f3 e7e6 d2d3 d7d5 g2g3 g8f6 f1g2 f8e7",
    "d2d4 d7d5 c2c4 c7c6 b1c3 g8f6 e2e3 c8f5",
    "g1f3 b8c6 d2d3 e7e5 b1d2 d7d5 e2e4 d5d4",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 c1g5 b8c6",
    "c2c4 g7g6 b1c3 f8g7 d2d4 c7c5 d4c5 g7c3",
    "d2d4 g7g6 g1f3 d7d6 e2e3 h7h6 b2b3 f8g7",
    "e2e4 c7c6 g1f3 d7d6 d2d4 b8d7 e4e5 d6e5",
    "c2c4 c7c5 b1c3 b8c6 g1f3 g7g6 d2d4 c5d4",
    "d2d4 c7c5 g1f3 c5d4 g2g3 g7g6 f3d4 g8f6",
    "g2g3 d7d6 f1g2 g8f6 b2b3 g7g6 c1b2 f8g7",
    "e2e4 e7e5 g1f3 b8c6 b1c3 g8f6 d2d4 e5d4",
    "c2c4 c7c5 d2d3 g8f6 a2a3 d7d5 c4d5 f6d5",
    "d2d4 e7e6 c2c4 c7c5 g1f3 c5d4 g2g3 g8f6",
    "g1f3 e7e5 f3e5 g8f6 e5f3 f8e7 g2g3 e8g8",
    "e2e4 e7e5 b1c3 b8c6 g1f3 d7d6 g2g3 f8e7",
    "c2c3 g8f6 d2d4 g7g6 d1c2 f8g7 b1d2 e8g8",
    "d2d4 g8f6 c1g5 b8c6 e2e3 d7d6 g1f3 g7g6",
    "d2d4 g8f6 c2c4 a7a6 g1f3 e7e6 g2g3 d7d5",
    "d2d4 b7b6 c1f4 c8b7 e2e3 d7d6 g1f3 b8d7",
    "g1f3 g8f6 g2g3 e7e6 f1g2 d7d5 e1g1 f8e7",
    "e2e4 c7c5 g1f3 e7e6 b1c3 b8c6 d2d4 c5d4",
    "e2e4 b8c6 b1c3 e7e5 g1f3 f8c5 f1b5 a7a6",
    "c2c4 g8f6 g2g3 g7g6 f1g2 f8g7 b1c3 e8g8",
    "b2b3 d7d5 c1b2 g8f6 e2e3 c7c6 g1f3 b8d7",
    "d2d4 c7c5 c2c4 c5d4 e2e3 g8f6 e3d4 g7g6",
    "g1f3 d7d5 d2d4 c7c6 c2c4 g8f6 c4d5 c6d5",
    "g1f3 g7g5 g2g3 g5g4 f3d4 e7e5 d4b3 a7a5",
    "e2e4 e7e5 g1f3 b8c6 f1c4 f8c5 b2b4 c5b6",
    "b2b3 g7g6 c1b2 g8f6 h2h4 f8g7 h4h5 f6h5",
    "d2d4 g8f6 c2c4 e7e6 g1f3 b7b6 a2a3 c8b7",
    "d2d4 d7d6 e2e4 g8f6 f1d3 g7g6 g1f3 f8g7",
    "e2e4 c7c6 d2d4 d7d5 f2f3 e7e6 b1c3 f8b4",
    "g1f3 e7e6 d2d4 d7d5 c2c4 g8f6 b1c3 f8e7",
    "g1f3 g8f6 d2d4 g7g6 c2c4 f8g7 b1c3 e8g8",
    "g2g3 g7g6 f1g2 d7d6 g1f3 f8g7 h2h3 e7e6",
    "f2f4 c7c5 g1f3 b8c6 e2e3 d7d5 d2d4 e7e6",
    "b2b3 e7e5 c1b2 b8c6 a2a3 g8f6 e2e3 g7g6",
    "d2d4 b7b6 e2e4 c8b7 f1d3 g8f6 d1e2 e7e6",
    "e2e4 e7e5 b1c3 b8c6 f1c4 g8f6 d2d3 f8c5",
    "g1f3 g7g6 d2d4 f8g7 c1f4 g8f6 b1c3 d7d5",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5e5 d1e2 e5e2",
    "d2d4 g8f6 c1g5 g7g6 g5f6 e7f6 e2e3 f8g7",
    "d2d4 c7c5 c2c4 c5d4 d1d4 a7a6 d4d1 d8c7",
    "d2d4 g8f6 b1c3 d7d5 c1g5 b8d7 f2f3 a7a6",
    "e2e4 c7c5 b1c3 d7d6 f2f4 g7g6 g1f3 f8g7",
    "e2e4 e7e5 d2d4 g8f6 d4e5 f6e4 f1d3 e4c5",
    "d2d4 d7d6 c2c4 g7g6 b1c3 h7h6 e2e4 e7e6",
    "g1f3 c7c6 d2d3 d7d5 b1d2 e7e6 g2g3 f7f5",
    "e2e3 g8f6 g2g4 d7d5 g4g5 f6d7 f1g2 c7c6",
    "e2e4 b7b6 d2d4 c8b7 b1c3 g7g6 f1d3 f8g7",
    "e2e4 b7b6 d2d4 c8b7 b1d2 e7e6 f1d3 g8f6",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c8f5 g2g4 f5g6",
    "c2c4 d7d6 b1c3 g8f6 g1f3 g7g6 d2d4 f8g7",
    "g1f3 g8f6 c2c4 e7e6 g2g3 c7c5 f1g2 b7b6",
    "g1f3 c7c5 g2g3 e7e6 f1g2 f8e7 d2d4 g8f6",
    "e2e4 c7c5 b1c3 d7d6 g1e2 b8c6 g2g3 g8f6",
    "b2b3 a7a5 c1b2 a5a4 g1f3 a4b3 a2b3 a8a1",
    "e2e4 e7e5 g1f3 b8c6 f1b5 f8d6 e1g1 a7a6",
    "g2g3 g7g6 f1g2 f8g7 g1f3 d7d5 c2c4 g8f6",
    "d2d4 c7c5 c2c4 c5d4 e2e3 b8c6 e3d4 e7e6",
    "e2e4 c7c5 c2c3 e7e6 d2d4 c5d4 c3d4 d7d5",
    "d2d4 d7d6 c1f4 g8f6 b1c3 c8f5 f2f3 f5g6",
    "e2e4 e7e6 d2d4 d7d5 b1d2 f8e7 f1d3 c7c5",
    "d2d4 d7d5 g1f3 e7e6 g2g3 f8d6 f1g2 g8f6",
    "b2b3 d7d5 c1b2 g8f6 e2e3 e7e6 g2g4 f8e7",
    "c2c4 g8f6 g2g3 e7e5 f1g2 c7c6 g1f3 e5e4",
    "d2d4 g8f6 c2c4 c7c5 e2e3 c5d4 d1d4 b8c6",
    "d2d4 g8f6 g1f3 e7e6 c1f4 c7c5 e2e3 c5d4",
    "d2d4 d7d5 c2c4 e7e6 g1f3 c7c5 e2e3 g8f6",
    "g1f3 d7d5 b2b3 c7c5 c1b2 b8c6 e2e3 a7a6",
    "e2e4 e7e6 d2d4 d7d5 e4d5 e6d5 f1d3 c7c5",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 c2c3 b8c6",
    "g1f3 d7d5 d2d4 c7c6 c2c4 g8f6 b1c3 d5c4",
    "d2d3 g8f6 e2e4 g7g6 b1c3 d7d6 c1g5 f8g7",
    "e2e3 c7c5 b2b3 d7d5 c1b2 g8f6 f2f4 b8c6",
    "c2c4 c7c5 b1c3 g8f6 g2g3 d7d5 c4d5 f6d5",
    "g1f3 g8f6 c2c4 g7g6 b1c3 f8g7 d2d4 d7d6",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 c1g5 f8b4",
    "d2d4 d7d5 c2c4 g8f6 b1c3 c7c6 c4d5 c6d5",
    "d2d4 g8f6 g1f3 e7e6 g2g3 d7d5 f1g2 f8d6",
    "d2d4 c7c6 g1f3 d7d6 c1f4 b8d7 f4d2 g8f6",
    "d2d4 g7g6 b1c3 g8f6 e2e4 d7d6 c1e3 c7c6",
    "g1f3 b8c6 d2d4 e7e5 c2c4 e5d4 f3d4 g8f6",
    "b2b3 e7e5 c1b2 b8c6 c2c4 d7d6 b1c3 c8e6",
    "g2g3 g7g6 f1g2 d7d6 g1f3 f8g7 d2d4 e7e6",
    "e2e4 c7c5 d2d4 c5d4 d1d4 b8c6 d4e3 d7d5",
    "c2c4 g8f6 d2d3 e7e6 e2e3 c7c5 b1d2 b7b6",
    "g1f3 c7c5 g2g3 e7e6 f1g2 a7a6 e1g1 b8c6",
    "e2e4 e7e5 g1f3 f8c5 f1b5 g8f6 d1e2 e8g8",
    "e2e4 e7e5 g1f3 b8c6 b1c3 g8f6 f1e2 f8c5",
    "d2d4 e7e5 b1c3 e5d4 d1d4 b8c6 d4a4 g8f6",
    "g1f3 d7d5 e2e3 c7c5 c2c4 d5d4 e3d4 c5d4",
    "e2e4 b8c6 d2d4 e7e5 d4d5 c6e7 c1g5 h7h6",
    "e2e3 g8f6 d2d4 g7g6 c2c4 f8g7 b1c3 e8g8",
    "d2d4 c7c5 g1f3 c5d4 d1d4 b8c6 d4d1 e7e6",
    "g1f3 d7d5 g2g3 g7g6 f1g2 f8g7 e1g1 e7e5",
    "d2d4 c7c6 c1f4 d7d6 e2e3 b8d7 c2c4 d8c7",
    "e2e4 d7d6 d2d4 g8f6 b1c3 c8g4 f2f3 g4d7",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d8 d2d4 e7e6",
    "g2g3 d7d5 f1g2 e7e6 g1f3 c7c5 e1g1 b8c6",
    "g2g3 d7d6 f1g2 e7e5 d2d4 c7c6 d4e5 d6e5",
    "d2d4 d7d5 g2g3 c7c6 f1g2 c8f5 g1f3 e7e6",
    "d2d4 g8f6 c2c4 g7g6 b1c3 d7d5 c4d5 c8g4",
    "g2g3 c7c6 f1g2 d7d5 g1f3 c8g4 e1g1 g4f3",
    "d2d4 b8c6 e2e3 d7d5 g1f3 c8f5 c2c3 e7e6",
    "e2e4 g7g6 b1c3 f8g7 g1f3 c7c5 d2d3 b8c6",
    "e2e4 c7c5 b1c3 d7d5 g1f3 d5d4 g2g3 d4c3",
    "d2d4 f7f5 c2c4 g8f6 e2e3 e7e6 g1f3 f8b4",
    "d2d4 g8f6 g1f3 c7c5 d4d5 d7d6 c2c4 e7e6",
    "d2d4 c7c5 b1c3 c5d4 d1d4 a7a6 d4a4 g8f6",
    "g1f3 d7d5 d2d4 g8f6 c1f4 c7c5 c2c4 b8c6",
    "d2d4 g8f6 b1c3 e7e6 c1g5 d7d5 e2e4 f8e7",
    "c2c4 b7b6 b1c3 c8b7 e2e4 g8f6 d2d3 g7g6",
    "g2g3 h7h5 f1g2 h5h4 g1f3 d7d6 f3h4 b8c6",
    "d2d4 g8f6 b1c3 d7d5 c1g5 b8d7 f2f3 h7h6",
    "d2d4 c7c5 b1c3 c5d4 d1d4 b8c6 d4h4 g7g6",
    "d2d4 d7d5 c2c4 e7e6 c4d5 e6d5 b1c3 g8f6",
    "d2d4 g8f6 c1f4 g7g6 e2e3 f8g7 g1f3 d7d5",
    "e2e4 c7c5 g1f3 b8c6 f1b5 c6a5 e1g1 a7a6",
    "d2d4 g8f6 g1f3 d7d5 c2c4 d5c4 e2e3 e7e6",
    "e2e4 c7c5 c2c3 g7g6 d2d4 c5d4 c3d4 d7d5",
    "d2d4 c7c5 g1f3 c5d4 c2c4 b8c6 f3d4 g8f6",
    "d2d4 b8c6 e2e3 e7e5 c2c3 e5d4 c3d4 d7d5",
    "f2f4 e7e5 f4e5 d7d6 g1f3 d6e5 e2e4 b8c6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 g8f6 e1g1 f8c5",
    "d2d3 g7g6 b1d2 f8g7 g1f3 d7d6 g2g3 g8f6",
    "d2d4 g8f6 c2c4 g7g6 b1c3 f8g7 e2e4 e8g8",
    "g2g3 c7c6 f1g2 d7d6 g1f3 h7h5 e1g1 e7e5",
    "b2b3 e7e5 c1b2 b8c6 e2e3 f7f5 f1b5 g8f6",
    "g1f3 g8f6 e2e3 e7e6 c2c4 f8e7 b2b3 b7b6",
    "g2g3 e7e5 f1g2 d7d5 g1f3 g8f6 f3e5 f8d6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 f8c5 f3e5 d8h4",
    "d2d4 g8f6 c2c4 e7e6 g1f3 d7d5 b1c3 f8b4",
    "e2e4 c7c5 b1c3 b8c6 g1f3 e7e6 g2g3 d7d5",
    "g1f3 h7h6 c2c4 d7d6 b1c3 b8d7 b2b3 c7c6",
    "c2c4 b7b6 b1c3 c8b7 f2f3 e7e6 e2e4 g8e7",
    "d2d4 g8f6 g1f3 e7e6 g2g3 c7c5 f1g2 f8e7",
    "d2d4 g7g6 e2e4 f8g7 b1c3 c7c5 c1e3 c5d4",
    "d2d4 g8f6 g1f3 e7e6 e2e3 d7d5 b2b3 f8e7",
    "d2d4 e7e6 c2c4 d7d6 g1f3 b8d7 g2g3 g8f6",
    "b2b3 g8f6 c1b2 g7g6 e2e3 f8g7 g1f3 e8g8",
    "g1f3 g7g5 f3g5 e7e5 g5f3 e5e4 f3g1 e4e3",
    "e2e4 e7e5 d1h5 d7d6 f1c4 g7g6 h5f3 g8f6",
    "f2f4 e7e5 f4e5 d7d6 e5d6 f8d6 g1f3 g8e7",
    "e2e4 c7c5 b1c3 d7d6 g2g3 g7g6 f1g2 f8g7",
    "b1c3 c7c5 e2e4 d7d6 g1f3 g8f6 f1b5 c8d7",
    "g1f3 g7g5 g2g3 g5g4 f3d4 b8c6 d4c6 b7c6",
    "d2d4 e7e6 b1c3 c7c5 e2e4 c5d4 d1d4 a7a6",
    "d2d4 g8f6 g1f3 e7e6 g2g3 c7c5 f1g2 b7b5",
    "e2e4 c7c6 d2d4 d7d5 e4d5 c6d5 f1d3 g8f6",
    "b1c3 b7b6 e2e4 c8b7 d2d4 g7g6 h2h4 h7h5",
    "e2e4 c7c5 g1f3 d7d6 a2a3 g8f6 e4e5 d6e5",
    "e2e4 c7c5 g1f3 e7e6 b2b3 b8c6 c1b2 a7a6",
    "d2d3 g7g6 c2c3 f8g7 g1f3 g8f6 c1f4 e8g8",
    "d2d4 f7f5 c2c4 g8f6 g1f3 e7e6 g2g3 f8b4",
    "g1f3 c7c5 d2d4 c5d4 e2e3 g8f6 e3d4 g7g6",
    "d2d4 d7d5 c1f4 c8f5 e2e3 g8f6 c2c4 e7e6",
    "b1a3 e7e5 e2e3 d7d5 d2d4 b8c6 d4e5 c6e5",
    "f2f4 c7c5 g1f3 g7g6 e2e4 f8g7 f1c4 b8c6",
    "b2b3 e7e5 c1b2 d7d6 d2d3 c7c6 g2g3 c8e6",
    "e2e4 d7d6 d2d4 g8f6 b1c3 g7g6 h2h4 f8g7",
    "g1f3 g8f6 c2c4 e7e6 e2e3 d7d5 b1c3 d5c4",
    "d2d4 d7d5 g1f3 g8f6 c2c4 d5c4 g2g3 b7b5",
    "g2g3 d7d5 f1g2 c7c6 g1f3 c8f5 e1g1 f5g6",
    "e2e4 e7e6 d2d4 c7c5 b1d2 c5d4 g1f3 b8c6",
    "d2d4 d7d5 c2c3 g8f6 g1f3 c7c6 c1f4 c8f5",
    "c2c4 g8f6 b1c3 c7c5 g2g3 b8c6 f1g2 g7g6",
    "g1f3 g8f6 d2d4 g7g6 c2c3 c7c5 c1f4 c5d4",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 c2c3 f8e7",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c8f5 c2c4 e7e6",
    "b2b4 d7d5 c1b2 c7c6 e2e3 g8f6 c2c4 c8g4",
    "e2e4 e7e6 b1c3 d7d6 d2d4 c8d7 c1e3 g8f6",
    "d2d4 c7c5 b1c3 c5d4 d1d4 b8c6 d4d2 g8f6",
    "d2d3 g8f6 c2c3 g7g6 b1d2 f8g7 g1f3 e8g8",
    "d2d4 c7c5 b1c3 c5d4 d1d4 b8c6 d4d1 g7g6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 a7a6 b5a4 d7d6",
    "c2c4 e7e6 b1c3 d7d5 c4d5 e6d5 d2d4 g8f6",
    "f2f3 e7e5 e1f2 d7d5 e2e3 d5d4 g1e2 d4e3",
    "d2d4 c7c5 c1g5 c5d4 d1d4 b8c6 d4h4 d8b6",
    "d2d4 d7d5 c2c4 e7e6 g1f3 g8f6 e2e3 a7a6",
    "b2b3 b8c6 c1b2 g8f6 a2a3 g7g6 e2e3 f8g7",
    "g1f3 g8f6 e2e3 d7d5 d2d4 c7c6 c2c4 c8g4",
    "e2e4 c7c5 g1f3 g7g6 d2d4 c5d4 f3d4 b8c6",
    "e2e4 c7c5 g1e2 b8c6 d2d4 c5d4 e2d4 e7e5",
    "d2d4 c7c5 c2c3 c5d4 c3d4 d7d5 b1c3 g8f6",
    "e2e4 e7e6 d2d3 d7d5 b1d2 g8f6 g1f3 d5e4",
    "g1f3 g8f6 c2c4 g7g6 d2d4 f8g7 b1c3 d7d5",
    "d2d4 e7e6 e2e3 d7d5 g1f3 g8f6 f1e2 f8e7",
    "d2d4 c7c5 c1f4 c5d4 d1d4 b8c6 d4a4 g8f6",
    "d2d4 e7e6 c2c4 c7c5 g1f3 c5d4 f3d4 b8c6",
    "d2d3 g7g6 c2c3 f8g7 g1f3 g8f6 c1g5 e8g8",
    "d2d4 g8f6 c2c4 c7c5 d4d5 b7b6 b1c3 e7e6",
    "d2d4 c7c5 b1c3 c5d4 d1d4 e7e6 d4a4 a7a6",
    "d2d4 d7d6 b1c3 g8f6 e2e4 e7e5 c1g5 b8d7",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 d1d4 a7a6",
    "e2e4 e7e6 g1f3 c7c5 f1b5 a7a6 b5e2 d7d6",
    "d2d4 g8f6 e2e3 c7c5 f2f4 g7g6 g1f3 f8g7",
    "g1f3 d7d5 d2d4 c7c6 c2c4 e7e6 c4d5 e6d5",
    "e2e4 c7c5 f2f4 d7d6 b1c3 g8f6 g1f3 g7g6",
    "d2d4 d7d6 e2e4 e7e5 g1f3 b8c6 f1c4 f8e7",
    "d2d4 d7d5 c2c4 c7c6 g1f3 g8f6 b1d2 c8f5",
    "g1f3 g8f6 d2d4 e7e6 c2c4 b7b6 b1c3 c8b7",
    "c2c4 c7c6 g2g3 d7d5 f1g2 e7e5 g1f3 e5e4",
    "e2e4 e7e6 d2d4 d7d5 b1c3 f8b4 g1e2 d5e4",
    "b2b3 d7d5 c1b2 c7c6 e2e3 b8d7 g2g4 f7f6",
    "d2d4 c7c5 g1f3 c5d4 f3d4 g8f6 d4f3 g7g6",
    "d2d4 c7c6 c2c4 d7d5 b1c3 g8f6 g1f3 c8f5",
    "g1f3 g7g6 e2e3 f8g7 d2d4 d7d6 a2a3 b8d7",
    "e2e4 d7d6 d2d4 g8f6 f2f3 e7e5 d4e5 d6e5",
    "h2h4 d7d5 h4h5 h7h6 a2a4 e7e5 a4a5 a7a6",
    "g1f3 c7c5 d2d3 b8c6 c2c4 d7d6 b1d2 c8d7",
    "d2d4 d7d6 c2c4 b8d7 g1f3 g7g6 g2g3 f8g7",
    "g1f3 d7d5 e2e3 e7e6 c2c3 g8f6 c3c4 f8e7",
    "e2e4 d7d5 d2d4 d5e4 b1c3 g8f6 g1e2 c7c6",
    "d2d4 d7d5 g1f3 g8f6 g2g3 g7g6 f1g2 f8g7",
    "f2f4 d7d5 g1f3 g8f6 e2e3 g7g6 c2c4 f8g7",
    "d2d4 d7d5 g1f3 g8f6 c2c4 c7c6 e2e3 d5c4",
    "d2d4 c7c6 e2e4 a7a6 f1d3 d7d5 e4e5 c6c5",
    "g2g3 c7c6 f1g2 d7d5 g1f3 c8g4 e1g1 g4h5",
    "d2d4 g7g6 e2e4 d7d6 g1f3 h7h6 f1c4 e7e6",
    "e2e4 g8f6 e4e5 f6d5 d2d4 d5b6 a2a4 d7d6",
    "e2e4 b8a6 g1f3 d7d6 f1b5 c8d7 b5a6 b7a6",
    "d2d4 g8f6 c2c4 e7e6 b1c3 f8b4 c1d2 e8g8",
    "e2e3 e7e6 c2c4 d7d5 b2b3 f7f5 c1b2 g8f6",
    "d2d4 g8f6 e2e4 e7e6 e4e5 f6d5 g1f3 d5b6",
    "c2c4 c7c6 g1f3 d7d5 d2d4 e7e6 b1c3 g8f6",
    "e2e4 b8c6 g1f3 e7e5 f1c4 d7d6 e1g1 f8e7",
    "b2b3 d7d5 c1b2 c8f5 g1f3 e7e6 e2e3 h7h6",
    "g1f3 c7c5 g2g3 b8c6 f1g2 d7d5 e1g1 e7e5",
    "d2d4 d7d5 c2c4 c7c6 g1f3 g8f6 g2g3 d5c4",
    "g2g3 b7b6 f1g2 c8a6 g1f3 c7c6 e1g1 e7e6",
    "g2g3 g7g6 f1g2 f8g7 d2d3 c7c5 b1d2 g8f6",
    "c2c4 e7e5 g2g3 f7f5 d2d4 f8b4 c1d2 b4d2",
    "d2d4 c7c5 g1f3 c5d4 g2g3 b8c6 f1g2 e7e5",
    "d2d4 e7e6 g1f3 g8f6 b1d2 d7d5 g2g3 f8e7",
    "f2f3 d7d5 e1f2 e7e5 e2e3 h7h5 d2d4 e5e4",
    "e2e4 e7e5 g1f3 b8c6 f1b5 f8c5 c2c3 f7f5",
    "f2f4 e7e5 g1f3 e5f4 d2d4 g7g5 h2h4 g5g4",
    "g1f3 d7d5 a2a4 c7c5 e2e3 b8c6 d2d4 g8f6",
    "e2e4 c7c5 g1f3 d7d6 b1c3 e7e5 f1c4 f8e7",
    "e2e4 c7c6 d2d4 d7d5 e4d5 c6d5 f1d3 b8c6",
    "c2c4 c7c5 b1c3 b8c6 e2e3 g7g6 g1f3 f8g7",
    "b2b3 g8f6 c1b2 d7d5 g1f3 c8f5 e2e3 e7e6",
    "b2b3 d7d5 a2a3 b8c6 c1b2 g8f6 e2e3 g7g6",
    "e2e4 e7e6 d2d4 c7c5 f1d3 c5d4 g1f3 b8c6",
    "e2e3 g7g6 g1e2 f8g7 h2h3 d7d6 g2g3 b8c6",
    "e2e3 c7c5 c2c4 e7e6 d2d4 g8f6 d4d5 g7g6",
    "g1f3 c7c5 e2e3 g8f6 d2d4 g7g6 a2a3 f8g7",
    "d2d4 e7e5 e2e3 e5d4 e3d4 d7d5 c2c4 g8f6",
    "e2e4 g7g6 g1f3 f8g7 d2d4 d7d6 b1c3 g8f6",
    "e2e4 g7g6 d2d4 f8g7 g1f3 c7c5 d4c5 d8a5",
    "b2b3 d7d5 c1b2 b8c6 e2e3 f7f6 f1d3 e7e5",
    "e2e4 c7c6 d2d4 d7d5 b1c3 d5e4 c3e4 c8f5",
    "e2e4 b8c6 d2d4 d7d5 e4e5 c8f5 c2c3 e7e6",
    "g1f3 b7b6 c2c4 c8b7 e2e3 e7e6 b1c3 f8b4",
    "b2b3 e7e5 c2c4 g8e7 c1b2 b8c6 g1f3 d7d5",
    "d2d4 g8f6 c1g5 d7d5 e2e3 c7c5 d4c5 e7e6",
    "b1c3 d7d5 e2e4 d5e4 c3e4 d8d5 d1f3 c8f5",
    "c2c4 g8f6 b1c3 e7e6 e2e4 d7d5 e4e5 f6d7",
    "e2e4 c7c5 b1c3 d7d6 f2f4 b8c6 g1f3 g7g6",
    "e2e4 d7d5 e4d5 c7c6 d5c6 g8f6 f1b5 b7c6",
    "d2d4 d7d6 e2e4 e7e5 g1f3 b8c6 f1b5 c8d7",
    "g1f3 c7c5 g2g3 e7e6 f1g2 a7a6 e1g1 g8f6",
    "d2d4 g8f6 c2c4 e7e6 g2g3 d7d5 f1g2 c7c6",
    "e2e4 c7c5 f2f4 g7g6 g1f3 f8g7 h2h4 h7h5",
    "e2e4 g8f6 b1c3 e7e5 f2f4 d7d6 g1f3 b8c6",
    "c2c4 d7d6 g1f3 b8d7 g2g3 g7g6 f1g2 f8g7",
    "e2e4 c7c5 g1f3 b8c6 f1b5 d8c7 e1g1 g8f6",
    "d2d4 e7e6 c2c4 d7d5 g1f3 g8f6 g2g3 f8e7",
    "g1f3 e7e6 g2g3 d7d5 f1g2 f7f5 e1g1 g8f6",
    "e2e3 e7e6 g1f3 b7b6 d2d4 c8b7 f1d3 g7g6",
    "g1f3 g8f6 g2g3 d7d5 f1g2 c8f5 e1g1 c7c6",
    "g1f3 d7d5 c2c4 e7e6 e2e3 g8f6 d1c2 f8e7",
    "c2c4 c7c5 g1f3 b8c6 b1c3 g7g6 e2e3 f8g7",
    "g2g3 d7d5 f1g2 e7e5 d2d3 c7c6 g1f3 f8d6",
    "d2d4 f7f5 g1f3 d7d6 e2e4 g8f6 e4e5 f6d5",
    "e2e4 c7c5 d2d4 c5d4 f2f4 e7e6 g1f3 a7a6",
    "g2g3 d7d6 f1g2 e7e6 g1f3 b8c6 e1g1 c8d7",
    "d2d4 e7e6 c2c4 g8f6 b1c3 f8b4 e2e3 b7b6",
    "g2g3 b7b6 f1g2 c7c6 g1f3 e7e6 e1g1 d7d5",
    "g1f3 e7e5 g2g3 e5e4 f3d4 g8f6 d2d3 d7d5",
    "g1f3 g7g6 d2d4 f8g7 c1f4 d7d6 e2e3 b8d7",
    "e2e4 e7e5 g1f3 b8c6 d2d4 e5d4 c2c3 g8f6",
    "g1f3 d7d6 e2e4 b8d7 d2d4 g8f6 c2c3 f6e4",
    "g1f3 d7d5 g2g3 e7e6 f1g2 g8f6 e1g1 b7b6",
    "d2d4 c7c6 c2c4 d7d6 b1c3 g7g6 e2e4 f8g7",
    "e2e3 d7d5 h2h3 g8f6 g1e2 g7g6 d2d3 f8g7",
    "d2d4 d7d5 g1f3 e7e6 c1f4 g8f6 e2e3 c7c5",
    "e2e4 c7c5 f2f4 b8c6 g1f3 e7e6 b1c3 g8f6",
    "d2d4 d7d5 e2e3 e7e6 f2f4 g8f6 g1f3 f8e7",
    "e2e4 d7d6 d2d4 g8f6 b1c3 e7e5 g1f3 b8d7",
    "e2e4 c7c6 f1c4 d7d5 c4b3 d5e4 b1c3 g8f6",
    "e2e4 c7c5 d2d4 c5d4 g1f3 b8c6 f3d4 c6d4",
    "g1f3 d7d5 d2d4 e7e6 c2c4 g8f6 g2g3 e8e7",
    "e2e4 c7c6 b1c3 d7d6 g1f3 g8f6 e4e5 d6e5",
    "d2d3 g8f6 b1d2 g7g6 g2g3 f8g7 f1g2 e8g8",
    "c2c4 g7g6 b1c3 f8g7 d2d4 c7c5 g1f3 c5d4",
    "d2d4 b7b6 g1f3 c8b7 c2c4 g7g6 b1c3 f8g7",
    "b1c3 g7g6 f2f4 f8g7 g1f3 d7d5 g2g3 g8f6",
    "g2g3 g7g6 f1g2 g8f6 g1f3 c7c5 e1g1 f8g7",
    "g1f3 g7g6 g2g3 f8g7 f1g2 d7d6 e1g1 c8d7",
    "g2g3 h7h5 f1g2 h5h4 e2e3 d7d5 g3h4 h8h4",
    "g1f3 c7c5 e2e4 g8f6 e4e5 f6d5 b1c3 d5c3",
    "g1f3 d7d5 g2g3 g8f6 f1g2 e7e6 e1g1 a7a5",
    "e2e4 e7e6 d2d4 d7d5 b1d2 c7c5 e4d5 d8d5",
    "e2e4 f7f5 e4f5 g8f6 g2g4 d7d5 g4g5 f6e4",
    "b2b3 g8f6 c1b2 g7g6 e2e3 f8g7 g2g4 e8g8",
    "d2d4 d7d6 e2e4 g7g6 b1c3 f8g7 h2h4 h7h5",
    "e2e4 d7d6 g1f3 b8d7 d2d4 g8f6 f1e2 f6e4",
    "b2b3 g8f6 c1b2 g7g6 e2e3 f8g7 d2d4 e8g8",
    "e2e4 c7c5 c2c4 b8c6 b1c3 g7g6 g2g3 f8g7",
    "e2e4 c7c5 d1h5 e7e6 f2f4 d7d6 g1h3 g8f6",
    "d2d4 g8f6 e2e3 e7e6 f2f4 d7d5 g1f3 b7b6",
    "e2e4 c7c5 g1f3 d7d6 f1b5 b8d7 e1g1 g8f6",
    "e2e3 d7d5 g1e2 e7e5 h2h3 f7f5 d2d3 g8f6",
    "g1f3 g7g6 e2e4 f8g7 h2h4 e7e6 h4h5 d7d5",
    "g1f3 c7c5 g2g3 b8c6 f1g2 d7d6 d2d4 g8f6",
    "e2e4 c7c5 g1f3 g8f6 d2d4 f6e4 f1d3 d7d5",
    "g2g3 f7f5 f1g2 g8f6 c2c4 g7g6 b1c3 f8g7",
    "e2e4 c7c6 b1c3 d7d6 d2d4 b8d7 g1f3 g7g6",
    "d2d4 b8c6 g1f3 f7f5 c2c4 g8f6 b1c3 g7g6",
    "b2b3 g8f6 c1b2 g7g6 g1f3 f8g7 g2g3 e8g8",
    "g2g3 g7g6 f1g2 f8g7 g1f3 d7d5 d2d4 g8f6",
    "g1f3 d7d6 g2g3 g8f6 f1g2 e7e5 e1g1 b8c6",
    "g1f3 g7g6 d2d4 f8g7 c1f4 d7d6 e2e3 b7b6",
    "e2e4 g7g6 d2d4 d7d6 g1f3 h7h6 h2h3 e7e6",
    "b2b3 d7d5 c1b2 g8f6 g1f3 b8c6 e2e3 c8g4",
    "e2e4 d7d5 e4d5 g8f6 d2d4 g7g6 c2c4 f8g7",
    "g1f3 d7d6 d2d4 e7e6 b1c3 f7f5 e2e4 g8f6",
    "c2c4 d7d6 b1c3 c7c6 g2g3 g8f6 f1g2 g7g6",
    "c2c4 g8f6 g1f3 g7g6 b1c3 f8g7 e2e4 e8g8",
    "e2e4 d7d6 d2d4 g8f6 b1c3 e7e5 d4e5 d6e5",
    "b2b3 e7e5 c1b2 b8c6 a2a3 g8f6 e2e3 d7d5",
    "e2e4 c7c5 b1c3 d7d6 f2f4 g8f6 g1f3 b8c6",
    "d2d4 e7e6 c2c3 d7d5 g2g3 g8f6 f1g2 f8e7",
    "b1c3 g7g6 f2f4 f8g7 h2h4 g8f6 e2e4 d7d6",
    "e2e4 c7c5 d2d4 c5d4 g1f3 e7e6 f1c4 a7a6",
    "g2g3 c7c6 f1g2 d7d6 g1f3 e7e5 e1g1 e5e4",
    "d2d4 g7g6 c1g5 f8g7 g1f3 h7h6 g5f4 g8f6",
    "f2f4 d7d5 g1f3 c8g4 e2e3 b8d7 f1e2 e7e6",
    "g2g3 d7d5 f1g2 c7c6 g1f3 c8f5 e1g1 d8c8",
    "e2e4 e7e5 g1f3 b8c6 f1b5 f8c5 e1g1 c6d4",
    "b2b3 e7e6 c1b2 f7f5 e2e3 g8f6 g2g3 f8e7",
    "g1f3 g8f6 c2c4 e7e6 g2g3 d7d5 f1g2 b8d7",
    "c2c4 e7e5 g2g3 g8f6 f1g2 f8c5 b1c3 c7c6",
    "e2e4 e7e5 g1f3 d7d6 f1c4 f8e7 c2c3 g8f6",
    "d2d4 d7d6 g1f3 g8f6 g2g3 g7g6 f1g2 f8g7",
    "b1a3 e7e5 d2d4 e5d4 d1d4 b8c6 d4e4 f8e7",
    "d2d4 b7b6 g1f3 c8b7 c2c4 a7a6 b1c3 e7e6",
    "e2e4 c7c5 c2c3 b8c6 d2d4 d7d5 e4d5 d8d5",
    "e2e3 d7d5 g1f3 c7c6 h2h3 g8f6 d2d4 g7g6",
    "e2e4 d7d6 d2d4 g8f6 b1c3 e7e5 g1f3 e5d4",
    "d2d4 g8f6 g1f3 g7g6 c1f4 f8g7 e2e3 e8g8",
    "b2b3 b8c6 c1b2 a7a5 b1c3 a5a4 c3a4 a8a4",
    "e2e4 g7g6 d2d4 d7d6 c2c3 h7h6 h2h3 e7e6",
    "g1f3 g8f6 d2d4 d7d5 c1g5 f6e4 g5c1 c7c5",
    "g1f3 g8f6 g2g3 g7g6 d2d4 f8g7 f1g2 d7d5",
    "g1f3 d7d5 c2c4 e7e6 d2d4 c7c5 c4d5 e6d5",
    "d2d4 g7g6 c2c4 f8g7 b1c3 d7d6 g1f3 b8d7",
    "d2d4 e7e5 e2e3 e5d4 e3d4 g8f6 g1f3 d7d5",
    "e2e4 d7d6 d2d4 b8d7 b1c3 g7g6 f2f4 f8g7",
    "c2c4 e7e5 b1c3 g8f6 g2g3 c7c6 e2e4 d7d5",
    "d2d3 g7g6 g1f3 f8g7 g2g3 c7c5 f1g2 b8c6",
    "c2c4 c7c5 g1f3 g8f6 b1c3 b8c6 g2g3 d7d5",
    "b2b3 e7e6 c1b2 d7d5 e2e3 g8f6 g1f3 f8e7",
    "f2f4 g8f6 g1f3 g7g6 b2b3 f8g7 c1b2 e8g8",
    "c2c4 g7g6 b1c3 f8g7 e2e3 g8f6 d2d4 e8g8",
    "g2g3 g8f6 f1g2 e7e6 g1f3 f8e7 e1g1 e8g8",
    "c2c4 g7g6 g2g3 f8g7 f1g2 g8f6 g1f3 e8g8",
    "e2e3 d7d5 g1f3 c8f5 d2d4 e7e6 f1d3 c7c6",
    "b1c3 d7d5 f2f4 c7c5 g1f3 g8f6 e1f2 d5d4",
    "d2d4 a7a6 c2c4 c7c5 d4d5 b7b5 b2b3 e7e6",
    "b2b3 c7c5 c1b2 d7d5 g1f3 b8c6 g2g3 c8f5",
    "b2b3 e7e5 c1b2 b8c6 e2e3 d7d5 a2a3 f8d6",
    "d2d4 b7b6 g1f3 c8b7 b2b3 a7a6 c1b2 e7e6",
    "g1f3 g8f6 d2d4 d7d5 c2c4 c7c6 g2g3 c8f5",
    "g2g3 f7f5 f1g2 d7d6 g1f3 g8f6 e1g1 g7g6",
    "e2e4 c7c5 b1c3 d7d6 g1f3 g8f6 d2d4 c5d4",
    "c2c4 e7e6 b1c3 d7d5 d2d4 f7f5 c4d5 e6d5",
    "c2c3 f7f5 d2d4 e7e6 g2g3 d7d5 c3c4 g8f6",
    "g1f3 c7c5 c2c4 g7g6 b1c3 f8g7 b2b3 b8c6",
    "b1a3 e7e5 d2d4 e5d4 d1d4 g8f6 a3b5 f8e7",
    "g1f3 d7d6 g2g3 e7e5 f1g2 b8c6 e1g1 c8d7",
    "d2d4 g7g6 e2e4 f8g7 h2h4 h7h6 h4h5 g6g5",
    "e2e3 g7g6 g1f3 f8g7 d2d4 c7c5 h2h3 c5d4",
    "e2e4 d7d5 e4d5 d8d5 g1f3 d5d6 d2d4 c7c6",
    "b1c3 d7d5 e2e3 g8f6 g1f3 g7g6 d2d4 f8g7",
    "b2b3 g7g6 c1b2 g8f6 b2f6 e7f6 e2e3 d7d5",
    "d2d4 g8f6 g1f3 c7c5 c2c3 c5d4 c3d4 g7g6",
    "g1f3 f7f5 b1c3 g7g6 d2d4 e8f7 e2e4 f7g7",
    "g1f3 g8f6 d2d4 b7b6 c1f4 c8b7 e2e3 e7e6",
    "d2d4 e7e5 c2c4 e5d4 g1f3 b8c6 f3d4 f8c5",
    "e2e4 g7g6 d2d4 f8g7 b1c3 d7d6 c1e3 e7e5",
    "e2e4 g7g6 d2d4 d7d6 b1c3 h7h6 f2f4 e7e6",
    "d2d4 g8f6 e2e3 e7e6 f2f4 b7b6 g1f3 c8b7",
    "d2d4 d7d5 c2c4 d5c4 b1c3 e7e5 g1f3 e5d4",
    "g2g3 f7f5 f1g2 d7d6 d2d4 g8f6 g1f3 g7g6",
    "g2g3 d7d5 g1f3 c7c6 f1g2 g7g6 e1g1 f8g7",
    "e2e4 c7c5 c2c3 e7e6 d2d4 d7d5 e4e5 g8e7",
    "d2d3 e7e6 b1d2 g8e7 h2h3 a7a6 a2a3 b7b6",
    "e2e4 e7e6 f2f4 c7c5 b1c3 d7d6 g1f3 b8c6",
    "d2d4 d7d5 g1f3 c7c6 c2c4 d5c4 b1d2 b7b5",
    "e2e4 c7c5 g1f3 d7d6 d2d4 c5d4 d1d4 g8f6",
    "d2d4 f7f5 c2c4 d7d6 g1f3 g8f6 g2g3 g7g6",
    "g1f3 e7e6 d2d4 c7c5 c2c4 c5d4 f3d4 g8f6",
    "d2d4 g8f6 c1f4 e7e6 e2e3 d7d6 g1f3 b8d7",
    "e2e4 g7g6 b1c3 f8g7 d2d3 c7c5 g2g3 b8c6",
    "c2c3 g8f6 d2d4 d7d5 g1f3 e7e6 c1f4 f8d6",
    "d2d4 g8f6 g1f3 g7g6 b2b3 f8g7 c1b2 d7d5",
    "b1c3 d7d5 f2f4 g8f6 e1f2 d5d4 c3b1 f6e4",
    "e2e4 g7g6 h2h4 d7d6 h4h5 g6g5 g2g4 h7h6",
    "b2b4 g8f6 c1b2 e7e6 a2a3 f8e7 g1f3 e8g8",
    "b2b3 d7d5 c1b2 c7c6 e2e3 c8f5 g1f3 g8f6",
    "g1f3 g8f6 g2g3 b7b5 f1g2 c8b7 e1g1 c7c5",
    "d2d4 c7c5 e2e3 c5d4 e3d4 g8f6 f1d3 d7d5",
    "e2e4 g7g6 d2d4 f8g7 b1c3 h7h6 c1e3 d7d6",
    "e2e3 e7e5 g1f3 e5e4 f3d4 c7c5 d4b3 d7d5",
    "b2b3 e7e5 c1b2 d7d5 a2a3 b8c6 e2e3 g8f6",
    "e2e3 g7g6 d2d4 f8g7 f2f4 g8f6 g1f3 e8g8",
    "b2b3 d7d5 c1b2 c7c5 e2e3 g8f6 g1f3 b8c6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 g8f6 e1g1 d7d6",
    "e2e4 c7c5 d2d4 b8c6 d4d5 c6d4 c2c3 e7e5",
    "f2f4 e7e6 g1f3 d7d5 g2g3 g8f6 f1g2 f8e7",
    "e2e4 c7c6 d2d4 d7d5 e4d5 c6d5 c2c4 b8c6",
    "e2e4 e7e6 b1c3 d7d5 g1f3 g8f6 e4d5 f6d5",
    "g1f3 g8f6 c2c4 g7g6 b2b4 f8g7 c1b2 e8g8",
    "e2e4 d7d5 e4d5 g8f6 d2d4 c8g4 g1f3 f6d5",
    "e2e4 g7g6 g1f3 f8g7 d2d4 c7c5 c2c3 c5d4",
    "c2c4 f7f5 g1f3 g8f6 b1c3 g7g6 d2d4 f8g7",
    "e2e4 g7g6 d2d4 d7d6 c1e3 h7h6 f2f3 e7e6",
    "d2d4 d7d5 c1g5 h7h6 g5h4 g7g5 h4g3 f8g7",
    "e2e4 d7d6 g1f3 h7h6 d2d4 a7a6 b1c3 g7g6",
    "d2d4 g8f6 c2c4 e7e6 g2g3 d7d5 g1f3 f8e7",
    "d2d4 g7g6 c2c4 f8g7 e2e4 d7d6 b1c3 g8f6",
    "d2d4 g8f6 g1f3 e7e6 g2g3 d7d5 f1g2 b7b5",
    "d2d4 c7c5 c2c4 c5d4 g2g3 b8c6 e2e3 d4e3",
    "e2e3 e7e5 d1h5 d7d6 f1c4 g7g6 h5f3 d8f6",
    "e2e4 e7e6 b1c3 d7d5 d2d3 d5d4 c3e2 c7c5",
    "c2c4 e7e5 b1c3 g8f6 g2g3 d7d5 c4d5 f6d5",
    "e2e4 d7d6 d2d4 g8f6 b1d2 e7e5 c2c3 e5d4",
    "c2c3 d7d5 d2d4 e7e6 g1f3 g8f6 c1g5 h7h6",
    "d2d4 d7d6 e2e4 c7c6 g1f3 g8f6 b1c3 b7b5",
    "g1f3 g8f6 c2c4 e7e6 g2g3 d7d5 d2d4 h7h5",
    "e2e3 d7d5 g1e2 c7c5 h2h3 b8c6 d2d3 e7e5",
    "e2e4 e7e5 d2d4 g8f6 d4e5 f6e4 d1d4 e4c5",
    "g1f3 e7e6 c2c4 f7f5 e2e3 g8f6 b1c3 f8e7",
    "e2e4 c7c5 c2c3 g8f6 e4e5 f6d5 d2d4 c5d4",
    "b2b3 g8f6 e2e3 g7g6 c1b2 d7d5 g2g4 c7c6",
    "e2e4 c7c5 g1f3 b8c6 c2c3 g7g5 f3g5 d7d5",
    "b2b3 c7c5 c1b2 e7e6 e2e3 g8f6 f2f4 f8e7",
    "e2e4 e7e6 g1f3 d7d5 e4d5 d8d5 d2d4 b8c6",
    "c2c4 f7f5 g1f3 d7d6 g2g3 g8f6 f1g2 g7g6",
    "d2d4 c7c5 d4d5 d7d6 c2c4 b7b5 c4b5 a7a6",
    "g2g3 e7e5 f1g2 d7d5 h2h3 c7c6 d2d3 f8d6",
    "g1f3 d7d6 d2d4 b8d7 g2g3 h7h6 e2e4 e7e6",
    "d2d4 c7c5 g1f3 c5d4 f3d4 g8f6 d4f3 e7e5",
    "c2c3 d7d5 d2d4 e7e6 c1f4 f8d6 e2e3 g8f6",
    "e2e4 c7c5 c2c3 d7d5 e4d5 d8d5 g1f3 g8f6",
    "e2e4 c7c5 b1c3 b8c6 f1b5 g7g6 b5c6 b7c6",
    "e2e4 d7d5 e4d5 g8f6 d2d4 e7e6 d5e6 c8e6",
    "e2e4 b7b6 b1c3 c8a6 f1a6 b8a6 g1f3 c7c6",
    "g2g3 d7d5 f1g2 c7c6 g1f3 c8g4 f3e5 g4h5",
    "e2e4 c7c5 b1c3 g7g6 g1f3 f8g7 d2d4 b8c6",
    "g1f3 d7d5 c2c4 e7e6 d2d4 g8f6 c1g5 f8e7",
    "d2d4 e7e6 g1f3 g8f6 c1g5 c7c5 e2e3 h7h6",
    "e2e4 d7d6 d2d4 b8d7 b1c3 h7h6 g1f3 e7e6",
    "d2d4 g8f6 c2c4 e7e6 g1f3 d7d5 g2g3 b8d7",
    "g2g3 f7f5 f1g2 d7d6 g1f3 e7e5 e1g1 e5e4",
    "e2e4 c7c6 d2d4 a7a6 b1d2 d7d5 c2c3 d5e4",
    "e2e4 g7g6 d2d4 h7h6 b1c3 d7d6 c1e3 f8g7",
    "g2g3 b7b6 f1g2 c7c6 b2b4 d7d6 b4b5 a7a6",
    "d2d4 g7g6 e2e4 f8g7 g1f3 d7d6 f1c4 g8f6",
    "c2c3 e7e6 d2d4 c7c5 c1f4 b8c6 g1f3 d8b6",
    "e2e4 g8f6 e4e5 f6g8 d2d4 d7d6 e5d6 c7d6",
    "e2e4 e7e6 d2d4 a7a6 f1d3 d7d5 b1c3 c7c5",
    "c2c4 c7c6 g1f3 d7d5 b2b3 f7f6 d2d4 c8g4",
    "g2g3 d7d5 f1g2 c8f5 g1f3 e7e6 d2d4 g8f6",
    "d2d4 d7d5 c2c4 e7e6 b1c3 f8e7 g1f3 g8f6",
    "d2d4 h7h6 e2e4 e7e6 f1d3 d7d5 b1c3 c7c5",
    "c2c4 g8f6 g2g3 g7g6 f1g2 f8g7 g1f3 e8g8",
    "d2d4 d7d5 a2a4 e7e6 c1f4 c7c5 e2e3 b8c6",
    "b2b3 d7d5 c1b2 c7c5 e2e3 b8c6 f1e2 e7e5",
    "d2d4 g7g6 g1f3 f8g7 g2g3 c7c5 f1g2 c5d4",
    "g2g3 e7e6 f1g2 d7d5 d2d4 f8e7 c2c3 g8f6",
    "e2e4 c7c6 f1c4 d7d5 e4d5 c6d5 c4b3 g8f6",
    "g1f3 e7e5 f3e5 d7d5 d2d4 c7c5 e2e3 b8c6",
    "g1f3 g8f6 c2c4 b7b6 b2b3 c8b7 c1b2 e7e6",
    "e2e3 g7g6 g1e2 f8g7 d2d3 g8f6 b1d2 e8g8",
    "e2e4 g8f6 e4e5 f6d5 b1c3 d5c3 b2c3 d7d6",
    "d2d4 f7f5 c1g5 g7g6 b1c3 d7d5 g1f3 f8g7",
    "b2b3 e7e5 c1b2 d7d6 d2d3 g8f6 h2h3 g7g6",
    "e2e4 d7d6 b1c3 g8f6 d2d4 b8d7 g1f3 e7e5",
    "e2e4 d7d6 d2d4 g8f6 b1c3 g7g6 f2f3 f8g7",
    "g2g3 g7g6 f1g2 f8g7 b2b3 g7a1 c2c3 g8f6",
    "g1f3 e7e6 c2c4 g8f6 d2d4 f8e7 g2g3 e8g8",
    "d2d4 d7d5 g1f3 g8f6 g2g3 c8g4 f1g2 d8c8",
    "e2e4 d7d5 e4d5 c7c6 d2d4 c6d5 g1f3 b8c6",
    "d2d4 b8c6 c2c4 e7e6 e2e3 g8f6 b1c3 d7d5",
    "e2e3 e7e5 g1e2 d7d5 h2h3 h7h5 a2a3 h5h4",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5d4 f3d4 d8b6",
    "e2e4 c7c5 c2c3 d7d6 d2d4 c5d4 c3d4 g7g6",
    "d2d4 e7e6 c2c4 b7b6 b1c3 c8b7 e2e3 f7f5",
    "g1f3 b7b6 b2b3 c8b7 c1b2 a7a5 g2g3 a5a4",
    "d2d4 c7c5 c2c4 c5d4 g1f3 b8c6 f3d4 g7g6",
    "g2g3 d7d5 f1g2 g8f6 g1f3 g7g6 e1g1 f8g7",
    "e2e4 c7c6 d2d4 d7d5 e4d5 c6d5 c2c4 e7e6",
    "g2g3 d7d6 f1g2 g8f6 d2d4 b8d7 g1f3 e7e5",
    "d2d4 d7d5 c2c4 g8f6 c4d5 f6d5 e2e4 d5b4",
    "d2d4 d7d5 e2e3 c7c6 f2f4 g8f6 g1f3 g7g5",
    "d2d4 b7b6 g1f3 c8b7 c2c3 a7a6 e2e4 e7e6",
    "e2e4 e7e5 g1f3 f7f6 c2c3 d7d6 d2d4 c7c6",
    "e2e4 c7c5 g1f3 d7d6 f1b5 c8d7 b1c3 b8c6",
    "d2d4 c7c5 g1f3 c5d4 f3d4 b8c6 d4c6 b7c6",
    "g1f3 b7b6 g2g3 c8b7 f1g2 g7g6 e1g1 f8g7",
    "g2g3 c7c5 f1g2 b8c6 g1f3 e7e5 e1g1 g8f6",
    "g1f3 d7d5 c2c4 c7c6 c4d5 c6d5 g2g3 g8f6",
    "e2e4 g7g6 b1c3 d7d6 d2d4 e7e6 c1e3 h7h6",
    "e2e4 g7g6 b1c3 f8g7 g1f3 c7c5 f1c4 e7e6",
    "d2d4 b7b6 g1f3 c8b7 c1f4 g8f6 e2e3 b7f3",
    "e2e4 d7d6 d2d4 b8d7 g1f3 h7h6 f1c4 g7g6",
    "g1f3 g8f6 e2e3 d7d5 d2d4 c8f5 h2h3 e7e6",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 d2d3 f8c5",
    "e2e3 g7g6 g1f3 f8g7 d2d4 d7d6 h2h3 g8f6",
    "b2b3 e7e6 c1b2 d7d5 a2a3 b8c6 e2e3 g8f6",
    "d2d4 e7e5 c2c4 e5d4 d1d4 b8c6 d4d2 g8f6",
    "a2a3 e7e6 b1c3 d7d5 d2d4 f7f5 g1f3 g8f6",
    "c2c4 g8f6 b1c3 g7g6 e2e4 f8g7 e4e5 f6g8",
    "e2e4 d7d5 e4e5 c7c5 c2c3 b8c6 d2d4 c5d4",
    "e2e4 e7e6 g1f3 d7d5 e4e5 c7c5 d2d4 b8c6",
    "d2d4 g8f6 c1f4 e7e6 e2e3 b7b6 g1f3 c8b7",
    "e2e4 c7c5 g1f3 e7e6 d2d4 c5c4 f1c4 d7d5",
    "e2e4 f7f5 e4f5 g8f6 d2d4 d7d5 f1d3 c7c5",
    "b2b3 a7a5 c1b2 a5a4 e2e3 g8f6 g1f3 e7e6",
    "b2b3 d7d6 c1b2 a7a6 e2e3 e7e6 g2g4 g8e7",
    "e2e4 g8f6 e4e5 f6d5 d2d4 d5b6 a2a4 d7d5",
    "g2g3 g8f6 f1g2 e7e5 e2e4 d7d6 d2d4 e5d4",
    "e2e4 d7d6 d2d4 c7c6 a2a4 g8f6 f1c4 a7a5",
    "b2b3 c7c5 c1b2 b7b6 g1f3 c8b7 g2g3 e7e6",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c8f5 f1d3 f5d3",
    "e2e4 d7d6 d2d4 g8f6 b1c3 b8d7 f2f4 e7e5",
    "d2d4 g8f6 e2e3 e7e6 f2f4 c7c5 g1f3 b7b6",
    "g1f3 d7d5 c2c4 e7e6 g2g3 c7c5 f1g2 g8f6",
    "g2g3 f7f6 f1g2 g8h6 g1f3 h6f7 e1g1 e7e6",
    "e2e4 d7d6 d2d4 g7g6 b1c3 f8g7 c1e3 a7a6",
    "e2e3 e7e5 g1f3 e5e4 f3d4 d7d5 c2c4 c7c5",
    "d2d3 c7c6 b1d2 d7d5 h2h3 g8f6 g2g3 g7g6",
    "d2d4 c7c6 h2h4 g8f6 b1c3 d7d5 g1f3 c8f5",
    "e2e4 c7c5 g1f3 b8c6 d2d4 c5d4 f3d4 d7d6",
    "d2d4 g7g6 c2c4 f8g7 e2e4 d7d6 b1c3 b8c6",
    "e2e4 e7e6 d2d4 d7d5 e4d5 e6d5 g1f3 g8f6",
    "g2g3 g7g6 f1g2 g8f6 g1f3 f8g7 d2d4 e8g8",
    "g1f3 e7e5 c2c4 e5e4 f3d4 c7c6 d2d3 d7d5",
    "d2d4 g8f6 c2c4 d7d5 c4d5 g7g6 f2f3 f6d5",
    "g1f3 d7d5 c2c4 e7e6 g2g3 g8f6 f1g2 d5c4",
    "g2g3 g8f6 f1g2 g7g6 h2h3 f8g7 d2d3 e8g8",
    "b1a3 g7g6 a3b1 f8g7 b1a3 g8f6 a3b1 e8g8",
    "e2e4 c7c5 g1f3 e7e6 b1c3 a7a6 g2g3 b7b5",
    "d2d4 d7d5 g1f3 g8f6 g2g3 c7c5 f1g2 c5d4",
    "d2d4 g7g6 c2c4 f8g7 b1c3 e7e6 e2e4 g8e7",
    "e2e4 c7c5 d1h5 e7e6 e4e5 d7d6 f2f4 b8c6",
    "e2e3 d7d6 g1e2 c7c6 d2d3 g8f6 b1d2 g7g6",
    "d2d4 g7g6 e2e4 f8g7 h2h4 h7h5 g1f3 a7a6",
    "e2e4 g8f6 b1c3 e7e5 g1f3 d7d6 f1c4 f8e7",
    "g2g3 f7f5 f1g2 e7e5 g1h3 g8f6 e1g1 d7d5",
    "d2d4 c7c6 c2c4 d7d5 b1c3 g8f6 g1f3 c8g4",
    "e2e4 g8f6 e4e5 f6d5 d2d4 d7d6 e5d6 e7d6",
    "e2e3 d7d5 g1e2 g8f6 h2h3 e7e6 d2d3 f8e7",
    "g1f3 g8f6 b2b3 g7g6 c1b2 d7d5 e2e3 f8g7",
    "b2b3 d7d5 g1f3 c7c6 c1b2 f7f6 e2e3 g8h6",
    "g2g3 e7e5 f1g2 b8c6 e2e3 d7d5 g1e2 c8e6",
    "g1f3 d7d5 c2c4 c7c6 g2g3 g8f6 f1g2 g7g6",
    "e2e4 g7g6 g1f3 f8g7 b1c3 c7c5 h2h4 h7h5",
    "e2e4 d7d6 d2d4 g8f6 b1d2 g7g6 g1f3 f8g7",
    "g1f3 g7g6 g2g3 d7d6 f1g2 h7h6 e1g1 f8g7",
    "e2e4 c7c5 d2d4 c5d4 g1f3 d7d6 c2c3 d4c3",
    "g1f3 d7d5 c2c3 c7c6 d2d4 g8f6 c1f4 c8f5",
    "c2c3 d7d6 d2d4 b8d7 e2e4 a7a6 f2f4 h7h6",
    "g1f3 g8f6 c2c4 g7g6 b1c3 f8g7 d2d4 e8g8",
    "g1f3 g8f6 e2e3 d7d5 d2d4 c8f5 c2c4 c7c6",
    "c2c4 e7e5 g1f3 b8c6 b1c3 g8f6 e2e3 d7d5",
    "b2b3 g8f6 c1b2 d7d5 g1f3 c7c6 g2g3 c8f5",
    "g1f3 b8c6 c2c4 e7e5 d2d4 e5e4 d4d5 e4f3",
    "d2d4 g8f6 c1f4 e7e6 e2e3 d7d5 g1f3 f8d6",
    "e2e4 c7c5 g1f3 d7d6 c2c3 g8f6 h2h3 b8c6",
    "e2e4 c7c5 g1f3 d7d6 d2d4 g8f6 d4c5 f6e4",
    "b1a3 e7e5 d2d4 e5d4 d1d4 g8f6 a3b5 b8c6",
    "d2d4 g8f6 g1f3 d7d6 e2e3 b8d7 b2b3 e7e5",
    "b2b3 d7d6 c1b2 b8d7 e2e3 b7b6 g2g4 c8b7",
    "e2e4 g7g6 d2d4 f8g7 c2c4 e7e6 b1c3 g8e7",
    "e2e4 b7b6 d2d4 a7a6 f1d3 c8b7 d1e2 e7e6",
    "e2e4 c7c5 c2c3 e7e6 d2d4 g8f6 e4e5 f6d5",
    "g2g3 d7d5 f1g2 g8f6 d2d4 b8c6 g1f3 c8g4",
    "d2d4 d7d6 g1f3 b8d7 c1f4 e7e6 e2e3 g8e7",
    "b2b3 g8f6 c1b2 g7g6 g1f3 f8g7 e2e4 e8g8",
    "e2e4 c7c6 d2d4 d7d5 f2f3 d5e4 f3e4 e7e5",
    "c2c4 e7e6 b1c3 c7c5 d2d4 b8c6 d4d5 e6d5",
    "e2e4 d7d5 d2d4 d5e4 b1c3 g8f6 c1g5 c8f5",
    "b2b3 g8f6 c1b2 e7e6 e2e3 d7d5 f2f4 f8e7",
    "g2g3 c7c6 f1g2 g8f6 g1f3 g7g6 e1g1 f8g7",
    "g2g3 g7g6 f1g2 f8g7 g1f3 e7e5 e1g1 g8e7",
    "g1f3 g7g6 c2c4 d7d6 b1c3 h7h6 d2d4 f8g7",
    "e2e4 d7d6 d2d4 g8f6 b1c3 g7g6 c1f4 f8g7",
    "g2g3 d7d5 f1g2 c7c6 g1f3 c8e6 e1g1 f7f6",
    "d2d4 d7d5 g1f3 g8f6 c1f4 c7c5 c2c3 b8c6",
    "g2g3 c7c5 f1g2 d7d5 e2e3 b8c6 g1e2 g7g6",
    "c2c4 c7c6 b1c3 d7d5 d2d4 g8f6 f2f3 c8f5",
    "d2d4 f7f5 c1f4 g8f6 e2e3 e7e6 g1f3 b7b6",
    "d2d4 d7d5 g1f3 g8f6 c1f4 c8f5 e2e3 e7e6",
    "g1f3 d7d6 g2g3 e7e5 f1g2 b8d7 e1g1 g8f6",
    "e2e3 g7g6 g1e2 f8g7 h2h3 e7e6 g2g3 g8e7",
    "g1f3 d7d6 d2d4 c7c5 c2c4 c5d4 f3d4 b7b6",
    "b2b3 g8f6 c1b2 g7g6 g1f3 f8g7 b2f6 g7f6",
    "d2d4 g8f6 c1g5 f6e4 g5f4 c7c5 f2f3 d8a5",
    "d2d4 b7b6 c1f4 c8b7 e2e3 g8f6 c2c4 e7e6",
    "d2d4 d7d5 g1f3 g8f6 e2e3 c7c5 c2c3 b8c6",
    "c2c3 e7e5 d2d3 d7d5 g1f3 b8c6 e2e4 g8f6",
    "c2c4 e7e5 b1c3 g8f6 g1f3 b8c6 e2e4 f8b4",
    "g2g3 b8c6 f1g2 g8f6 g1f3 d7d5 e1g1 e7e5",
    "d2d4 g8f6 g1f3 g7g6 b1d2 d7d5 e2e3 f8g7",
    "e2e4 e7e5 b1c3 b8c6 g1f3 f8c5 f1c4 g8e7",
    "e2e3 d7d5 d2d4 c7c6 c2c4 g8f6 b1c3 a7a6",
    "e2e4 c7c5 b1c3 b8c6 g1e2 g7g6 g2g3 f8g7",
    "g1f3 e7e6 c2c4 c7c5 e2e3 g8f6 b1c3 d7d5",
    "d2d4 d7d6 c2c4 e7e5 d4e5 d6e5 d1d8 e8d8",
    "e2e4 g8f6 e4e5 f6d5 d2d4 d7d6 g1f3 d6e5",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c6c5 d4c5 b8c6",
    "d2d4 g8f6 g1f3 g7g6 c1f4 f8g7 b1d2 e8g8",
    "g1f3 g7g6 d2d4 d7d6 c1f4 h7h6 e2e3 g6g5",
    "d2d4 c7c5 d4d5 e7e5 e2e4 d7d6 b1c3 f7f5",
    "d2d4 d7d6 g1f3 b8d7 c1g5 a7a6 c2c3 h7h6",
    "g2g3 e7e6 f1g2 d7d5 g1f3 c7c5 e1g1 g7g6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 d7d6 d2d4 e5d4",
    "e2e3 b7b6 b2b3 c8b7 c1b2 g8f6 g1f3 g7g6",
    "g1f3 d7d5 c2c4 g8f6 c4d5 g7g6 e2e4 f8g7",
    "g1f3 b7b5 e2e4 c8b7 f1b5 b7e4 e1g1 g8f6",
    "d2d3 d7d6 c2c3 c7c6 b1d2 g7g6 g1f3 f8g7",
    "g2g3 e7e5 f1g2 h7h5 d2d4 e5d4 d1d4 b8c6",
    "c2c4 d7d6 b1c3 c7c6 d2d4 g8f6 f2f3 g7g6",
    "g2g3 d7d5 f1g2 c7c6 g1f3 h7h5 e1g1 e7e6",
    "e2e4 e7e6 g1f3 d7d5 e4e5 c7c5 c2c3 b8c6",
    "e2e4 c7c5 g1f3 b8c6 f1b5 e7e5 e1g1 f8d6",
    "c2c4 e7e5 b1c3 b8c6 g2g3 f8c5 f1g2 d7d6",
    "g1f3 g7g6 d2d4 d7d6 c2c4 h7h6 b1c3 e7e6",
    "c2c4 c7c5 b1c3 b8c6 g1f3 e7e6 d2d4 c5d4",
    "g2g3 b7b6 f1g2 c7c6 g1f3 c8b7 e1g1 d7d6",
    "c2c4 g7g6 b1c3 f8g7 d2d4 c7c5 d4d5 g7c3",
    "d2d4 g8f6 g1f3 b7b6 c2c4 c8b7 b1c3 e7e6",
    "c2c3 c7c6 d2d3 d7d6 b1d2 b8d7 g1f3 g8f6",
    "c2c4 c7c5 b1c3 b8c6 g2g3 g7g6 f1g2 f8g7",
    "d2d4 e7e5 g1f3 e5e4 f3d2 d7d5 e2e3 c7c6",
    "g2g3 d7d6 f1g2 e7e6 g1f3 b8d7 e1g1 g8f6",
    "e2e4 c7c5 g1f3 b8c6 b2b4 c6b4 c2c3 b4c6",
    "b1c3 e7e6 d2d4 g8f6 e2e4 c7c5 e4e5 f6d5",
    "d2d4 e7e6 c2c4 g8f6 b1c3 f8b4 f2f3 e8g8",
    "d2d4 g8f6 g1f3 b7b6 c1f4 c8b7 b1d2 f6h5",
    "e2e3 d7d5 d2d4 c7c5 c2c4 b8c6 c4d5 d8d5",
    "g1f3 c7c6 c2c4 d7d6 e2e3 b8d7 b1c3 g8f6",
    "c2c4 e7e5 b1c3 b8c6 g2g3 g8f6 f1g2 h7h5",
    "b2b3 e7e5 c1b2 d7d6 e2e3 c7c5 d2d4 c5d4",
    "e2e3 g7g6 d2d4 f8g7 h2h4 g8f6 f1e2 h7h5",
    "e2e3 b7b6 g1e2 c8b7 h2h3 d7d6 a2a3 b8d7",
    "d2d4 g8f6 c2c4 g7g6 b1c3 f8g7 c1f4 e8g8",
    "g1f3 g8f6 c2c4 e7e6 g2g3 d7d5 f1g2 f8e7",
    "d2d4 g8f6 b1c3 g7g6 g2g3 f8g7 f1g2 d7d6",
    "e2e4 b7b6 b1c3 c8b7 b2b3 a7a6 c1b2 e7e6",
    "e2e4 g7g6 d2d4 f8g7 b1c3 a7a6 a2a4 d7d6",
    "g2g3 d7d5 f1g2 c8f5 g1f3 g8f6 d2d3 e7e6",
    "e2e4 c7c6 g1f3 d7d5 e4e5 c8f5 b2b3 e7e6",
    "d2d3 g7g6 b1d2 d7d6 e2e4 h7h6 c2c3 e7e6",
    "e2e4 c7c5 g1f3 a7a6 b1c3 g8f6 d2d4 c5d4",
    "e2e4 d7d5 b1c3 d5d4 c3e2 c7c5 e2g3 b8c6",
    "d2d4 e7e6 g1f3 c7c5 c2c3 c5d4 c3d4 g8f6",
    "d2d4 c7c5 c1f4 c5d4 f4b8 a8b8 d1d4 d7d5",
    "b1c3 d7d5 d2d4 g8f6 e2e4 d5e4 c1g5 b8d7",
    "b1c3 e7e6 d2d4 g8f6 e2e4 d7d6 e4e5 d6e5",
    "c2c3 d7d6 d2d3 c7c5 b1d2 b8c6 g1f3 g7g6",
    "b2b3 g8f6 g1f3 g7g6 c1b2 f8g7 d2d4 e8g8",
    "b2b3 g8f6 c1b2 g7g6 e2e4 d7d6 f2f4 f8g7",
    "e2e4 g8f6 d2d3 b8c6 f2f4 d7d5 e4e5 f6g8",
    "e2e3 e7e6 d2d4 c7c5 g1f3 g8f6 c2c4 b7b6",
    "b2b3 e7e5 c1b2 d8e7 d2d3 b8c6 g1f3 b7b6",
    "g1f3 e7e6 d2d4 g8f6 b1c3 d7d5 c1g5 b8d7",
    "e2e4 c7c5 d2d4 b8c6 d4d5 c6b8 c2c4 d7d6",
    "h2h3 d7d5 d2d3 e7e5 b1d2 c7c5 c2c3 b8c6",
    "e2e4 g8f6 e4e5 f6d5 g1f3 d5b6 a2a4 d7d6",
    "e2e4 c7c6 b1c3 d7d5 d2d4 d5e4 f2f3 g8f6",
    "b1c3 c7c5 e2e4 b8c6 f2f4 e7e6 f1c4 g8f6",
    "c2c4 e7e5 b1c3 f8b4 c3d5 b4e7 g2g3 g8f6",
    "d2d4 g8f6 c1f4 c7c5 e2e3 e7e6 g1f3 b8c6",
    "d2d4 d7d6 c1g5 h7h6 g5h4 g7g5 h4g3 f8g7",
    "d2d4 g8f6 c1f4 d7d5 e2e3 f6h5 d1h5 g7g6",
    "c2c4 d7d5 c4d5 g8f6 b1c3 f6d5 c3d5 d8d5",
    "d2d3 g8f6 g1f3 b7b6 g2g3 c8b7 f1g2 d7d6",
    "b2b3 e7e5 c1b2 b8c6 g1f3 d7d5 f3e5 c6e5",
    "e2e4 c7c6 c2c4 d7d5 e4d5 c6d5 d2d4 g8f6",
    "d2d4 e7e6 c1f4 c7c5 e2e3 d8b6 d1c1 b8c6",
    "g2g4 d7d5 f1g2 c8g4 c2c4 c7c6 c4d5 c6d5",
    "g2g3 g8f6 f1g2 e7e6 c2c4 d7d5 d2d4 c7c5",
    "g1f3 d7d5 e2e3 g8f6 c2c4 c7c6 b2b4 c8g4",
    "d2d4 g8f6 e2e3 d7d5 g1f3 c7c6 h2h3 c8f5",
    "g2g3 g7g6 f1g2 d7d6 c2c4 f8g7 b1c3 e7e6",
    "b1c3 e7e6 e2e4 g8f6 d2d4 d7d6 f1d3 b8c6",
    "d2d4 g8f6 c1g5 c7c5 d4d5 e7e6 b1c3 d8b6",
    "g2g3 h7h5 f1g2 h5h4 g1f3 h4h3 g2f1 d7d5",
    "b2b3 e7e6 c1b2 d7d5 g1f3 g8f6 c2c4 f8e7",
    "e2e4 h7h6 d2d4 d7d6 b1c3 b8d7 c1e3 c7c6",
    "d2d4 c7c5 c1f4 c5d4 f4b8 a8b8 d1d4 d8b6",
    "g1f3 g7g6 g2g3 f8g7 f1g2 e7e5 e1g1 e5e4",
    "c2c4 e7e5 b1c3 g8f6 g2g3 b8c6 f1g2 f8b4",
    "c2c3 d7d5 d2d3 g8f6 b1d2 e7e6 g1f3 f8e7",
    "e2e4 d7d6 d2d4 c7c6 b1c3 g8f6 c1e3 b7b5",
    "e2e4 g8f6 e4e5 f6d5 d2d4 d5b6 g1f3 d7d6",
    "e2e4 c7c6 b1c3 d7d5 e4d5 c6d5 d2d4 b8c6",
    "b2b3 e7e5 c1b2 d7d6 g1f3 g7g6 d2d4 f8g7",
    "d2d4 d7d6 g1f3 c7c5 d4c5 d8a5 b1c3 a5c5",
    "g2g3 e7e5 f1g2 c7c6 c2c4 d7d6 d2d4 b8d7",
    "g2g3 c7c6 f1g2 d7d5 g1f3 c8f5 e1g1 e7e6",
    "e2e3 c7c5 d2d4 b8c6 d4c5 e7e6 g1f3 f8c5",
    "e2e4 c7c5 b1c3 e7e6 g1f3 a7a6 d2d4 c5d4",
    "d2d3 e7e5 e2e4 d7d5 g1f3 d5e4 d3e4 d8d1",
    "c2c4 e7e6 b1c3 g8f6 e2e4 d7d5 c4d5 e6d5",
    "d2d4 g8f6 c2c4 e7e6 b1c3 f8b4 g1f3 e8g8",
    "d2d4 g8f6 b1c3 e7e6 d4d5 e6d5 c3d5 f6d5",
    "f2f4 d7d5 g1f3 g8f6 g2g3 g7g6 f1g2 f8g7",
    "f2f4 g8f6 g1f3 g7g6 c2c4 f8g7 b1c3 e8g8",
    "e2e4 c7c6 d2d4 d7d6 b1c3 b8d7 f2f3 e7e5",
    "d2d4 b7b6 g1f3 c8b7 c2c4 a7a6 e2e4 e7e6",
    "e2e3 d7d6 g1f3 c7c5 d2d4 c5d4 e3d4 g7g6",
    "d2d4 g8f6 c2c4 e7e6 g1f3 b7b6 g2g3 c8b7",
    "d2d4 c7c5 c2c4 c5d4 g1f3 b8c6 f3d4 d8b6",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d8 g1f3 g8f6",
    "e2e4 b7b6 d2d4 c8b7 b1d2 g7g6 f2f4 f8g7",
    "c2c4 e7e5 b1c3 b8c6 g2g3 g7g6 f1g2 f8g7",
    "e2e3 c7c5 g1e2 g8f6 h2h3 g7g6 g2g3 f8g7",
    "d2d4 g7g6 g1f3 f8g7 e2e4 c7c5 c2c3 d7d5",
    "e2e4 b7b6 d2d4 c8b7 b1c3 d7d6 g1f3 e7e6",
    "g1f3 f7f5 d2d3 d7d6 b1d2 g8f6 g2g3 b8c6",
    "c2c4 g8f6 g1f3 e7e6 g2g3 b7b6 f1g2 c8b7",
    "g1f3 g8f6 g2g3 b7b5 f1g2 c8b7 e1g1 e7e6",
    "e2e4 c7c5 b1c3 e7e6 g1f3 a7a6 a2a4 b8c6",
    "d2d4 e7e6 c2c4 g8f6 b1c3 d7d5 c1g5 d5c4",
    "c2c4 e7e5 b1c3 g8f6 g1f3 b8c6 d2d4 e5d4",
    "h2h3 c7c5 d2d3 g7g6 b1d2 f8g7 c2c3 b8c6",
    "d2d4 e7e6 c1f4 d7d5 e2e3 g8f6 g1f3 f8e7",
    "e2e3 g8f6 d2d4 e7e6 g1f3 b7b6 c2c4 c8b7",
    "g1f3 d7d5 g2g3 g8f6 c2c3 c7c5 d2d4 e7e6",
    "e2e3 g8f6 g1f3 e7e6 h2h3 d7d5 d2d4 c7c5",
    "e2e4 c7c6 d2d4 d7d6 f1d3 b8d7 g1e2 e7e5",
    "g1f3 e7e6 b2b3 a7a5 c1b2 a5a4 b3a4 a8a4",
    "d2d4 g8f6 c2c4 e7e6 b1d2 d7d5 g2g3 c7c5",
    "e2e4 c7c5 g1f3 a7a6 d2d4 c5d4 f3d4 g8f6",
    "d2d4 d7d6 e2e4 g7g6 b1c3 f8g7 c1e3 g8f6",
    "g1f3 e7e6 d2d3 c7c6 b1d2 f8b4 g2g3 d7d5",
    "g1f3 g8f6 c2c4 c7c5 b1c3 g7g6 g2g3 f8g7",
    "g1f3 c7c5 g2g3 b8c6 f1g2 g8f6 e1g1 g7g6",
    "e2e4 e7e6 b1c3 c7c5 f2f4 a7a6 g1f3 d7d5",
    "g2g3 e7e5 f1g2 g8f6 b1c3 d7d5 d2d3 c7c6",
    "g2g3 e7e6 f1g2 g8e7 g1f3 g7g6 e1g1 f8g7",
    "d2d4 g8f6 b1c3 d7d5 c1f4 a7a6 e2e3 c8f5",
    "b2b3 e7e5 c1b2 d7d6 e2e3 f8e7 h2h3 g8f6",
    "d2d4 g7g6 g1f3 f8g7 g2g3 c7c5 f1g2 b8c6",
    "d2d4 c7c6 c2c4 d7d6 g1f3 g7g6 c1f4 f8g7",
    "e2e3 g8f6 d2d4 e7e6 g1f3 b7b6 c2c4 d7d5",
    "e2e4 f7f6 d2d4 e7e6 c2c4 g7g6 b1c3 g8h6",
    "d2d3 b7b6 g1f3 c8b7 g2g3 b7f3 e2f3 d7d5",
    "d2d4 d7d5 c2c4 e7e6 b1c3 g8f6 c1f4 f8e7",
    "d2d3 c7c6 b1c3 d7d6 e2e3 b8d7 g1e2 g8f6",
    "g1f3 h7h6 e2e4 d7d6 d2d4 b8d7 c2c3 c7c6",
    "e2e3 g8f6 g1f3 d7d6 d2d4 b8d7 h2h3 g7g6",
    "d2d4 c7c5 c1f4 c5d4 f4b8 a8b8 d1d4 b7b6",
    "g1f3 g7g6 d2d3 f8g7 g2g3 g8f6 f1g2 e8g8",
    "c2c4 e7e5 g2g3 h7h5 h2h3 f8c5 e2e3 b8c6",
    "f2f4 d7d5 g1f3 g8f6 e2e3 c7c5 d2d4 b8c6",
    "d2d4 b7b6 b1c3 c8b7 e2e4 g8f6 e4e5 f6d5",
    "c2c4 g8f6 b1c3 d7d5 c4d5 f6d5 g1f3 g7g6",
    "d2d4 g7g6 e2e4 g8f6 c2c4 c7c5 e4e5 f6g8",
    "g1f3 c7c6 c2c4 d7d5 e2e3 g8f6 b1c3 c8g4",
    "h2h3 g7g6 d2d3 d7d6 b1d2 h7h6 c2c3 e7e6",
    "e2e4 c7c5 c2c4 b8c6 b1c3 g8f6 g2g3 e7e6",
    "e2e3 c7c5 g1e2 g8f6 d2d3 g7g6 b1d2 f8g7",
    "e2e4 e7e5 g1f3 b8c6 f1b5 a7a6 b5a4 b7b5",
    "e2e4 e7e5 d2d4 e5d4 d1d4 b8c6 d4e3 d7d6",
    "e2e3 e7e5 d2d3 d7d5 f1e2 g8f6 g1f3 b8c6",
    "e2e3 e7e6 b1c3 g8f6 d2d4 f8e7 e3e4 e8g8",
    "e2e4 c7c5 b1c3 a7a6 g1f3 b7b5 d2d4 c8b7",
    "d2d4 c7c5 g1f3 c5d4 f3d4 a7a6 c2c4 b7b6",
    "c2c4 d7d6 b1c3 b8d7 g2g3 a7a6 f1g2 a8b8",
    "d2d4 c7c6 g1f3 d7d6 c1f4 g7g6 f4g3 f8g7",
    "c2c4 c7c5 b1c3 g8f6 g1f3 d7d5 g2g3 d5d4",
    "e2e4 e7e5 b1c3 b8c6 f2f4 e5f4 g1f3 g8f6",
    "e2e4 c7c5 g1f3 e7e6 b2b3 b7b6 c1b2 c8b7",
    "e2e4 h7h6 b1c3 d7d6 d2d4 b8d7 f2f3 c7c6",
    "b2b3 e7e5 c1b2 b8c6 d2d3 g7g6 g1f3 f8g7",
    "d2d4 d7d5 b1c3 g8f6 c1f4 e7e6 e2e3 a7a6",
    "f2f4 d7d5 e2e4 d5e4 d2d3 e4d3 f1d3 g8f6",
    "d2d4 g7g6 c2c4 g8f6 g1f3 f8g7 b1c3 e8g8",
    "g2g3 d7d5 f1g2 g8f6 c2c4 e7e6 c4d5 e6d5",
    "g2g3 d7d5 f1g2 c7c5 g1f3 b8c6 e1g1 g8f6",
    "e2e4 a7a6 f1c4 b7b6 c4f7 e8f7 d1h5 g7g6",
    "d2d4 c7c5 c2c4 c5d4 d1d4 b8c6 d4d1 g7g6",
    "d2d4 g7g6 g1f3 f8g7 c1f4 g8f6 h2h3 d7d6",
    "e2e4 c7c6 c2c4 g7g6 b1c3 f8g7 g2g3 d7d6",
    "e2e4 e7e6 b1c3 b8c6 d2d4 f8b4 g1f3 d7d5",
    "e2e4 d7d6 d2d4 b8d7 b1c3 a7a6 f2f4 h7h6",
    "c2c4 e7e6 b1c3 d7d5 d2d4 h7h6 g1f3 g8f6",
    "e2e4 c7c5 g1f3 a7a6 a2a4 b8c6 c2c3 e7e5",
    "e2e4 g7g6 d2d4 f8g7 b1c3 d7d5 c1e3 d5e4",
    "e2e4 e7e6 d2d4 d7d5 e4d5 e6d5 f1d3 f8d6",
    "g1f3 d7d5 d2d3 c8f5 b1d2 e7e6 c2c4 c7c6",
    "e2e4 e7e5 g1f3 g8f6 f3e5 f6e4 d1e2 d8e7",
    "c2c3 e7e6 d2d3 d7d5 b1d2 c7c5 g1f3 b8c6",
    "g1f3 d7d6 g2g3 c7c6 f1g2 b8d7 e1g1 g8f6",
    "c2c4 c7c5 e2e4 d7d6 g1f3 e7e5 d2d3 g7g6",
    "g1f3 g8f6 d2d3 d7d5 b1d2 c7c5 e2e4 b8c6",
    "b2b3 c7c6 c1b2 d7d5 e2e3 g8f6 h2h3 g7g6",
    "e2e4 b7b6 g1f3 c8b7 b1c3 a7a6 g2g3 e7e6",
    "d2d4 d7d6 c2c4 b8d7 b1c3 a7a6 e2e4 h7h6",
    "e2e4 e7e5 d2d4 d7d6 d4e5 d6e5 d1d8 e8d8",
    "e2e4 d7d5 e4d5 d8d5 g1f3 d5d6 f1e2 g8f6",
    "g1f3 c7c5 g2g3 b7b6 f1g2 c8b7 e1g1 g8f6",
    "e2e4 c7c5 g1f3 d7d6 c2c3 g8f6 f1c4 b8c6",
    "e2e4 g7g6 h2h4 f8g7 h4h5 d7d5 e4d5 d8d5",
    "g1f3 g7g6 c2c4 f8g7 b1c3 e7e6 g2g3 g8e7",
    "d2d4 e7e5 g1f3 e5e4 f3d2 f7f5 e2e3 g8f6",
    "g1f3 g8f6 d2d3 d7d5 b1d2 c7c6 c2c3 g7g6",
    "g2g3 d7d5 f1g2 g8f6 g1f3 c8f5 e1g1 e7e6",
    "d2d4 d7d5 c2c4 e7e6 b1c3 c7c6 e2e3 g8f6",
    "e2e4 c7c6 c2c4 d7d5 c4d5 c6d5 e4d5 g8f6",
    "d2d4 c7c5 d4d5 d7d6 e2e4 g7g6 b1d2 f8g7",
    "c2c3 g8f6 d2d4 d7d6 b1d2 g7g6 g1f3 f8g7",
    "e2e4 d7d5 e4d5 d8d5 g1f3 d5d8 d2d4 g8f6",
    "e2e4 g7g6 d2d4 d7d6 c1e3 h7h6 d1d2 e7e6",
    "e2e4 g7g6 c2c4 f8g7 b1c3 d7d6 g2g3 c7c5",
    "e2e4 c7c6 b1c3 d7d6 g1f3 g7g6 d2d4 f8g7",
    "d2d4 g8f6 c2c4 e7e6 g2g3 d7d5 f1g2 f8e7",
    "d2d4 g8f6 g1f3 e7e6 c1f4 f8d6 f4g3 d6g3",
    "d2d4 g8f6 g1f3 c7c5 d4d5 d7d6 b1c3 g7g6",
    "e2e4 e7e5 g1f3 b8c6 c2c3 d7d5 d1a4 d5e4",
    "d2d4 d7d6 g1f3 e7e5 g2g3 e5e4 f3g5 f7f5",
    "g2g3 h7h5 f1g2 h5h4 e2e4 e7e5 d2d4 e5d4",
    "e2e4 c7c5 d2d4 c5d4 g1f3 e7e5 c2c3 g8f6",
    "c2c3 g8f6 d2d3 d7d5 b1d2 e7e5 g1f3 f8d6",
    "e2e4 e7e6 g1f3 d7d5 b1c3 b8c6 d2d4 f8b4",
    "e2e4 g8f6 e4e5 f6d5 b1c3 d5c3 d2c3 d7d5",
    "c2c3 d7d5 g1f3 b8c6 d2d4 g8f6 c1f4 e7e6",
    "g1f3 g8f6 g2g3 d7d5 f1g2 c7c5 e1g1 h7h6",
    "b2b3 e7e5 c1b2 b8c6 g1f3 d7d6 d2d3 f7f5",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 d2d3 h7h6",
    "d2d4 e7e5 g1f3 e5d4 d1d4 g8f6 d4d2 f8e7",
    "g2g3 c7c5 f1g2 e7e6 c2c4 b8c6 g1f3 g8f6",
    "d2d4 d7d6 c2c4 g8f6 g1f3 b8d7 b1c3 e7e5",
    "e2e4 c7c5 b1c3 e7e6 g2g3 b8c6 f1g2 g8f6",
    "e2e4 e7e6 d2d4 d7d5 f1d3 d5e4 d3e4 g8f6",
    "d2d4 g8f6 c2c4 e7e6 g1f3 b7b6 g2g3 c8a6",
    "e2e4 c7c6 d2d4 d7d5 f2f3 d8b6 b1c3 d5e4",
    "e2e3 g8f6 b1c3 g7g6 d2d4 f8g7 e3e4 e8g8",
    "e2e4 e7e6 d2d4 d7d5 e4d5 e6d5 g1f3 b8c6",
    "d2d4 g8f6 c2c4 e7e6 b1c3 d7d5 c1d2 f8e7",
    "e2e4 c7c5 c2c3 d7d5 d2d3 d5e4 b1a3 e4d3",
    "e2e4 e7e5 g1f3 b8c6 f1b5 a7a6 b5a4 f8c5",
    "d2d4 c7c6 c2c4 d7d6 b1c3 b8d7 e2e4 g8f6",
    "d2d4 e7e6 e2e4 d7d5 e4e5 c7c5 c2c3 c8d7",
    "d2d4 g8f6 c2c4 e7e6 b1c3 f8b4 f2f3 c7c5",
    "e2e4 e7e5 b1c3 b8c6 f2f4 e5f4 d2d4 f8b4",
    "e2e4 e7e5 g1f3 b8c6 b1c3 g8f6 h2h3 g7g6",
    "d2d4 g7g6 g1f3 d7d6 c1h6 f8h6 c2c3 h6g7",
    "a2a4 g8f6 d2d4 e7e6 g1f3 c7c5 e2e3 b8c6",
    "c2c4 d7d5 c4d5 d8d5 b1c3 d5d8 g1f3 e7e6",
    "e2e4 e7e6 b1c3 b8c6 g2g3 d7d5 f1g2 d5d4",
    "g1f3 b7b6 d2d3 c8b7 b1d2 g7g6 g2g3 f8g7",
    "e2e4 e7e5 f2f4 e5f4 g1f3 g7g5 f1c4 g5g4",
    "e2e4 c7c5 g1f3 b8c6 c2c3 d7d5 e4d5 d8d5",
    "e2e4 c7c5 g1f3 d7d6 c2c3 g8f6 h2h3 b8d7",
    "c2c4 g8f6 b1c3 e7e6 d2d4 c7c5 g1f3 g7g6",
    "e2e4 c7c6 d2d4 d7d6 e4e5 d6e5 d4e5 d8a5",
    "g1f3 e7e6 g2g3 c7c5 f1g2 b8c6 e1g1 d7d5",
    "e2e4 d7d6 g1f3 e7e5 d2d4 b8d7 f1c4 e5d4",
    "d2d4 g8f6 c2c4 e7e6 b1c3 f8e7 g1f3 d7d5",
    "e2e4 d7d5 b1c3 d5e4 c3e4 c8f5 e4g3 f5g6",
    "d2d4 d7d5 c1f4 g8f6 e2e3 c7c5 c2c3 b8c6",
    "d2d4 g8f6 b1c3 e7e6 e2e4 c7c5 e4e5 c5d4",
    "e2e3 e7e5 d1h5 b8c6 f1c4 d8e7 b1c3 g8f6",
    "d2d4 c7c5 d4d5 d7d6 b1c3 g7g6 e2e4 f8g7",
    "d2d4 d7d5 c2c4 e7e6 b1c3 f8b4 c1f4 c7c5",
    "e2e4 c7c5 d2d4 d7d6 d4d5 g7g6 c2c4 f8g7",
    "e2e4 c7c5 c2c3 e7e6 d2d4 a7a6 g1f3 d8c7",
    "c2c4 e7e6 b1c3 g8f6 d2d4 f8b4 g1f3 c7c5",
    "d2d4 c7c6 g1f3 d7d6 c1f4 b8d7 e2e3 g8f6",
    "d2d4 c7c5 c2c3 e7e6 g1f3 g8f6 c1f4 d7d5",
    "e2e4 d7d5 g1f3 d5e4 f3g5 g8f6 b1c3 e7e6",
    "d2d4 g8f6 g1f3 e7e6 e2e3 c7c6 f1d3 d7d5",
    "d2d4 c7c6 c2c4 d7d5 c4d5 c6d5 b1c3 b8c6",
    "b2b3 d7d5 a2a3 g8f6 c1b2 g7g6 e2e3 f8g7",
    "e2e4 c7c5 g1f3 b8c6 b1c3 g7g6 d2d4 c5d4",
    "d2d4 d7d5 e2e3 e7e6 g1f3 f8e7 c2c3 g8f6",
    "e2e4 b8c6 d2d4 d7d5 e4e5 c8f5 g1f3 e7e6",
    "e2e4 c7c6 d2d4 d7d6 e4e5 g7g6 e5d6 e7d6",
    "e2e4 c7c5 g1f3 a7a6 c2c3 d7d5 e4d5 d8d5",
    "e2e3 g7g6 b1c3 f8g7 d2d4 c7c5 d4c5 g8f6",
    "d2d4 d7d5 b1c3 g8f6 g1f3 e7e6 c1f4 f8b4",
    "e2e4 e7e6 d2d4 d7d5 e4d5 e6d5 f1d3 b8c6",
    "g1f3 e7e6 d2d3 d7d5 b1d2 g8f6 c2c3 c7c5",
    "e2e4 e7e5 c2c4 b8c6 b1c3 g7g6 d2d3 f8g7",
    "e2e4 c7c5 b1c3 e7e6 d2d4 b8c6 d4d5 e6d5",
    "e2e4 g7g6 d2d4 f8g7 c2c3 d7d6 h2h4 h7h5",
    "e2e4 c7c6 c2c4 d7d5 c4d5 c6d5 e4d5 d8d5",
    "d2d4 g8f6 g1f3 b7b6 c1f4 c8b7 b1d2 d7d6",
    "g1f3 c7c5 c2c4 b8c6 b1c3 e7e6 e2e3 d7d5",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d8 g1f3 c7c6",
    "e2e4 d7d6 d2d4 c8g4 d1g4 b8d7 f1b5 e7e6",
    "d2d4 b7b6 c2c4 c8b7 b1c3 g7g6 e2e4 f8g7",
    "e2e4 d7d6 d2d4 g8f6 b1c3 g7g6 f1c4 f8g7",
    "e2e4 c7c6 g1f3 d7d5 b1c3 g8f6 e4e5 f6d7",
    "g2g3 d7d5 f1g2 g8f6 c2c4 b8c6 c4d5 f6d5",
    "d2d4 g8f6 c1g5 c7c5 d4d5 d8b6 b1c3 b6b2",
    "g1f3 g7g6 d2d3 f8g7 g2g3 e7e5 f1g2 d7d5",
    "e2e4 c7c6 b1c3 d7d5 d1e2 e7e6 g2g3 g8f6",
    "d2d4 g8f6 c2c4 e7e6 b1c3 f8b4 f2f3 d7d5",
    "d2d4 g8f6 c1g5 c7c6 b1c3 d7d5 e2e3 c8f5",
    "b2b3 d7d5 a2a3 e7e5 c1b2 b8c6 e2e3 g7g6",
    "e2e4 c7c6 d2d4 d7d6 f1d3 b8d7 g1f3 e7e5",
    "e2e4 d7d6 g1f3 g7g6 d2d4 f8g7 b1c3 a7a6",
    "e2e4 c7c6 g1f3 d7d5 d2d3 d8c7 d1e2 d5e4",
    "e2e4 e7e5 d2d4 e5d4 d1d4 b8c6 d4e3 g7g6",
    "e2e3 e7e5 d2d3 d7d5 b1d2 b8c6 g2g3 g8f6",
    "g1f3 e7e6 c2c4 d7d5 e2e3 d5c4 f1c4 g8f6",
    "e2e4 c7c6 d2d4 d7d5 e4d5 c6d5 b1c3 b8c6",
    "c2c4 c7c6 b1c3 d7d5 c3d5 c6d5 c4d5 g8f6",
    "c2c4 g8f6 b1c3 e7e6 d2d4 f8b4 g1f3 e8g8",
    "e2e4 c7c5 b1c3 g7g6 g2g3 f8g7 f1g2 d7d6",
    "e2e4 c7c5 f1e2 b8c6 f2f4 c6d4 g1f3 d4e2",
    "d2d4 g8f6 c2c4 c7c6 g1f3 d7d5 c1f4 a7a6",
    "d2d4 c7c5 c2c4 g7g6 g1f3 c5d4 f3d4 f8g7",
    "e2e4 e7e6 b1c3 d7d6 d2d4 c7c5 g1f3 c5d4",
    "c2c3 c7c5 d2d3 d7d5 b1d2 g8f6 g1f3 g7g6",
    "g1f3 g8f6 d2d4 d7d6 c1f4 g7g6 e2e3 f8g7",
    "d2d4 g8f6 g1f3 c7c5 g2g3 c5d4 f3d4 g7g6",
    "e2e4 d7d6 g1f3 c7c6 d2d4 g7g6 f1d3 f8g7",
    "d2d4 d7d5 g1f3 g8f6 c1f4 c7c5 e2e3 d8b6",
    "c2c4 c7c5 b1c3 b8c6 g2g3 e7e5 f1g2 d7d6",
    "d2d4 c7c5 d4d5 e7e6 c2c4 e6e5 b1c3 d7d6",
    "g2g3 d7d5 f1g2 e7e5 e2e3 e5e4 b1c3 c8e6",
    "e2e4 g7g5 d2d4 g5g4 b1c3 h7h5 h2h3 g4g3",
    "d2d4 d7d5 c1f4 c7c6 e2e3 c8f5 c2c4 e7e6",
    "e2e4 d7d5 e4d5 g8f6 c2c4 c7c6 b1c3 c6d5",
    "e2e4 e7e5 b1c3 b8c6 f1b5 g8f6 b5c6 d7c6",
    "c2c4 e7e5 b1c3 b8c6 g2g3 f8c5 f1g2 a7a6",
    "d2d4 c7c6 g1f3 d7d5 g2g3 g8f6 f1g2 c8f5",
    "e2e4 c7c6 g1f3 d7d5 d2d3 g7g6 e4e5 f8g7",
    "d2d4 d7d5 g1f3 c7c6 c1f4 g8f6 e2e3 d8b6",
    "e2e4 c7c5 g1f3 e7e6 g2g3 a7a6 f1g2 b7b5",
    "e2e4 c7c5 d2d4 c5d4 d1d4 b8c6 d4e3 g8f6",
    "e2e4 c7c5 g1f3 e7e6 d2d4 a7a6 d4d5 d8c7",
    "e2e4 b8c6 f1b5 e7e5 g1f3 g8f6 b5c6 d7c6",
    "d2d4 g8f6 b1c3 d7d5 e2e4 d5e4 f1c4 c8f5",
    "e2e4 b8c6 b1c3 e7e6 d2d4 d7d5 e4e5 f7f6",
    "e2e4 g7g6 d2d4 f8g7 b1c3 c7c5 d4d5 d7d6",
    "d2d4 g8f6 c1f4 g7g6 e2e3 f8g7 h2h4 h7h5",
    "e2e3 e7e5 b2b3 d7d5 c1b2 b8c6 f1b5 f8d6",
    "d2d4 g8f6 c2c4 g7g6 b1c3 d7d5 c1f4 f8g7",
    "e2e4 c7c6 d2d4 d7d6 b1c3 g7g6 f2f4 f8g7",
    "e2e4 b8c6 d2d4 e7e6 c2c4 d7d5 c4d5 e6d5",
    "c2c4 e7e5 b1c3 b8c6 g2g3 f8c5 f1g2 g8e7",
    "g1f3 d7d5 d2d3 g8f6 b1d2 c7c6 c2c3 c8g4",
    "d2d4 c7c5 b1c3 c5d4 d1d4 b8c6 d4h4 g8f6",
    "d2d4 g8f6 c1d2 d7d6 d2a5 b7b6 d1d2 b6a5",
    "e2e4 b7b6 g1f3 c8b7 b1c3 a7a6 b2b3 e7e6",
    "g2g3 d7d5 f1g2 e7e5 d2d4 e5e4 c2c4 c7c6",
    "e2e3 c7c6 g1f3 d7d5 b2b3 g8f6 c1b2 g7g6",
    "d2d4 g8f6 c2c4 g7g6 g1f3 d7d5 b1c3 f8g7",
    "e2e4 d7d5 e4d5 d8d5 d2d4 d5d8 f1d3 g8f6",
    "e2e4 g7g6 d2d4 f8g7 g1f3 d7d6 c2c3 g8f6",
    "d2d4 e7e5 b1c3 e5d4 d1d4 b8c6 d4d2 g8f6",
    "g1f3 d7d5 g2g3 c7c6 f1g2 g8f6 h2h3 c8f5",
    "e2e4 c7c6 b1c3 d7d5 d2d3 d5e4 c3e4 g8f6",
    "g1f3 d7d5 c2c4 e7e6 c4d5 e6d5 d2d4 g8f6",
    "e2e4 c7c5 d2d4 c5d4 d1d4 b8c6 d4e3 d7d6",
    "b2b3 e7e6 a2a3 d7d5 c1b2 b8d7 e2e3 g8f6",
    "d2d4 g8f6 c2c4 g7g6 b1c3 d7d5 e2e3 f8g7",
    "e2e4 d7d5 b1c3 d5d4 c3e2 e7e5 d2d3 b8c6",
    "e2e4 c7c6 d2d4 d7d5 b1c3 b7b5 e4e5 b5b4",
    "d2d4 c7c5 g1f3 c5d4 g2g3 g7g6 f1g2 f8g7",
    "g1f3 d7d5 c2c4 c7c6 c4d5 c6d5 d2d4 b8c6",
    "e2e4 c7c6 d2d4 g7g6 b1c3 d7d6 g1f3 f8g7",
    "g1f3 g8f6 d2d4 e7e6 c2c4 b7b6 b1c3 f8b4",
    "c2c3 d7d5 d2d4 g8f6 e2e4 f6e4 f2f3 e4f6",
    "e2e4 e7e5 g1f3 b8c6 d2d4 e5d4 f3d4 d8f6",
    "e2e4 e7e5 b1c3 b8c6 g2g3 f7f5 f1g2 f5e4",
    "c2c3 g7g6 d2d3 f8g7 b1d2 d7d6 g1f3 g8f6",
    "e2e4 c7c6 g1f3 d7d5 e4e5 c8g4 d2d4 e7e6",
    "g2g3 g8f6 f1g2 d7d6 g1f3 e7e5 e1g1 f8e7",
    "g1f3 d7d5 g2g3 e7e6 f1g2 f8d6 e1g1 f7f5",
    "e2e4 d7d5 g1f3 d5e4 f3g5 g8f6 d2d3 e7e6",
    "d2d4 g8f6 e2e3 e7e6 g1f3 c7c5 c2c3 d7d5",
    "e2e4 e7e6 d2d4 d7d5 b1d2 d5e4 d2e4 c8d7",
    "d2d4 c7c6 c1f4 g8f6 e2e3 g7g6 g1f3 f8g7",
    "d2d4 e7e6 c2c4 d7d5 b1c3 g8f6 c4d5 f8e7",
    "e2e4 g7g6 d2d4 f8g7 c2c3 c7c5 d4c5 d8c7",
    "d2d4 g8f6 c1g5 f6e4 g5f4 e7e5 d4e5 d7d6",
    "e2e4 b8c6 d2d4 d7d5 e4d5 d8d5 c2c3 e7e5",
    "d2d4 c7c5 g1f3 c5d4 d1d4 b8c6 d4h4 g7g6",
    "e2e4 e7e5 g1f3 d7d6 d2d4 b8d7 h2h3 f8e7",
    "e2e4 d7d5 e4d5 d8d5 d2d4 d5a5 c2c3 c7c6",
    "e2e4 c7c5 d2d4 c5d4 g1f3 e7e5 c2c3 d4c3",
    "d2d4 d7d5 c2c4 e7e6 b1c3 c7c6 c4d5 e6d5",
    "f2f4 g7g6 g1f3 f8g7 e2e3 c7c5 d2d4 c5d4",
    "f2f4 d7d5 g1f3 c7c6 b2b3 g8f6 c1b2 c8f5",
    "d2d4 g8f6 g1f3 d7d5 c2c3 c8f5 d1b3 d8c8",
    "d2d4 d7d5 g1f3 g8f6 g2g3 c8h3 f1g2 h3g2",
    "g2g3 g7g6 f1g2 f8g7 d2d4 g8f6 g1f3 d7d6",
    "g1f3 d7d5 d2d3 c7c6 b1d2 b8d7 c2c3 e7e5",
    "e2e3 c7c5 g1e2 d7d5 e2g3 b8c6 f1e2 e7e5",
    "e2e4 c7c6 b1c3 d7d5 e4d5 c6d5 g1f3 g8f6",
    "d2d4 e7e5 c2c4 e5d4 d1d4 b8c6 d4d1 g8f6",
    "d2d4 d7d6 e2e3 g7g6 g1f3 f8g7 f1e2 e7e6",
    "e2e3 d7d5 g1f3 e7e6 c2c4 f7f5 d2d4 c7c6",
    "e2e4 d7d6 g1f3 c7c6 d2d4 g7g6 c2c4 f8g7",
    "e2e4 b7b6 g1f3 c8b7 b1c3 g7g6 d2d3 f8g7",
    "e2e4 c7c5 d2d4 c5d4 f2f4 d7d5 e4d5 d8d5",
    "e2e4 g7g6 d2d4 f8g7 b1c3 a7a6 c1e3 b7b5",
    "e2e4 c7c6 d2d4 d7d5 f2f3 g8f6 b1c3 e7e6",
    "d2d4 c7c5 c2c4 c5d4 d1d4 b8c6 d4d1 g8f6",
    "d2d4 d7d5 c2c4 d5c4 g1f3 e7e6 e2e3 c7c5",
    "g1f3 g7g6 g2g3 f8g7 f1g2 c7c6 e1g1 d7d6",
    "g2g3 d7d5 d2d4 e7e6 f1g2 g8f6 c2c4 f8e7",
    "d2d4 g8f6 e2e3 e7e6 f1d3 c7c5 f2f4 c5d4",
    "b2b3 g7g6 c1b2 g8f6 e2e4 f8g7 d2d3 e8g8",
    "d2d4 c7c5 g1f3 e7e6 c2c4 a7a6 g2g3 c5d4",
    "e2e4 c7c5 g1f3 d7d6 b1c3 e7e5 f1c4 b8c6",
    "e2e4 c7c5 b1c3 d7d6 g2g3 b8c6 f1g2 g7g6",
    "e2e4 c7c6 d2d4 g7g6 b1c3 f8g7 g1f3 d7d6",
    "e2e4 e7e6 d2d4 c7c5 d4d5 g8f6 e4e5 f6d5",
    "e2e4 c7c5 d2d4 c5d4 c2c3 d4d3 f1d3 b8c6",
    "d2d4 g8f6 c2c4 g7g6 g1f3 f8g7 g2g3 e8g8",
    "e2e4 e7e5 g1f3 b8c6 f1c4 f8c5 b2b4 c5b4",
    "g2g3 e7e6 f1g2 d7d5 h2h3 b8d7 d2d3 g8f6",
    "g2g3 e7e5 f1g2 g8f6 d2d4 e5e4 c2c4 f8b4",
    "b2b3 g8f6 c1b2 e7e6 e2e3 d7d5 g1f3 f8d6",
    "d2d4 c7c5 g1f3 g8f6 d4d5 e7e6 b1c3 e6d5",
    "e2e4 c7c5 d2d4 d7d6 d4d5 e7e6 c2c4 e6d5",
    "e2e4 c7c6 g1f3 d7d5 d2d3 c8g4 h2h3 g4f3",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5a5 g1f3 c7c6",
    "d2d4 a7a6 e2e4 h7h6 f1d3 d7d6 g1f3 b8c6",
    "e2e4 c7c5 g1f3 g7g6 g2g3 f8g7 f1g2 b8c6",
    "d2d4 g7g6 c2c4 f8g7 h2h4 h7h6 e2e4 c7c5",
    "g1f3 d7d5 d2d3 g8f6 b1d2 c8g4 c2c3 b8c6",
    "c2c4 e7e6 b1c3 b7b6 d2d4 c8b7 g1f3 f8b4",
    "g1f3 g7g5 e2e3 g5g4 d2d4 g4f3 d1f3 g8f6",
    "g2g3 d7d5 f1g2 g8f6 g1f3 b8c6 d2d4 e7e5",
    "e2e4 c7c5 c2c4 e7e6 b1c3 b8c6 g2g3 g8f6",
    "d2d4 b8c6 d4d5 c6e5 g1f3 e5f3 e2f3 e7e6",
    "d2d4 g8f6 g1f3 e7e6 b1c3 f8e7 c1g5 e8g8",
    "g2g3 h7h5 f1g2 h5h4 g3h4 h8h4 g1f3 h4g4",
    "d2d4 d7d5 g1f3 c7c5 g2g3 c5d4 f1g2 g8f6",
    "e2e4 c7c6 d2d4 d7d5 f1d3 d5e4 d3e4 g8f6",
    "e2e4 d7d5 e4d5 g8f6 b1c3 f6d5 f1c4 e7e6",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d8 f2f3 e7e6",
    "d2d4 d7d5 b1c3 g8f6 c1f4 a7a6 e2e3 h7h6",
    "e2e4 c7c5 b1c3 e7e6 g2g3 a7a6 f1g2 d8c7",
    "e2e4 c7c6 d2d4 d7d5 b1c3 d5e4 c3e4 b8d7",
    "e2e4 c7c6 g1f3 d7d5 b1c3 a7a6 a2a4 d5d4",
    "d2d4 d7d5 c2c4 c7c6 b1c3 c8f5 g1f3 e7e6",
    "d2d4 e7e6 b1c3 d7d5 e2e4 d5e4 f2f3 b8d7",
    "d2d4 e7e6 g1f3 c7c5 c2c3 g8f6 c1f4 b7b6",
    "e2e4 g8f6 e4e5 f6g8 d2d4 d7d6 g1f3 d6e5",
    "e2e4 c7c5 c2c3 d7d5 d2d4 c5d4 e4d5 d8d5",
    "d2d4 g8f6 g1f3 c7c5 d4c5 d8a5 b1c3 a5c5",
    "e2e4 d7d5 e4d5 g8f6 g1f3 c8g4 f1b5 b8d7",
    "e2e4 c7c5 f2f4 e7e6 b1c3 g7g6 g1f3 f8g7",
    "e2e4 c7c5 g1f3 b8c6 f1b5 e7e6 e1g1 g8e7",
    "e2e4 c7c5 g1f3 b8c6 c2c3 g8f6 d2d4 c5d4",
    "d2d4 b8c6 g1f3 d7d5 c1f4 g8f6 b1d2 f6e4",
    "d2d4 d7d5 c2c4 c7c6 b1c3 g8f6 g1f3 a7a6",
    "e2e4 c7c6 b1c3 d7d5 d2d4 b7b5 g1f3 b5b4",
    "e2e4 d7d6 g1f3 b8d7 f1c4 h7h6 f3d4 e7e6",
    "e2e4 g7g6 d2d4 f8g7 c2c3 c7c5 f1d3 c5d4",
    "d2d4 g8f6 c2c4 c7c5 b1c3 e7e6 d4c5 f8c5",
    "g2g3 d7d5 f1g2 g8f6 g1f3 b8c6 d2d4 c8f5",
    "d2d4 e7e6 g1f3 d7d5 e2e3 f8e7 b2b3 c7c5",
    "g1f3 d7d5 d2d4 g8f6 c2c4 e7e6 g2g4 f8e7",
    "g1f3 g8f6 c2c4 e7e6 d2d4 f8b4 c1d2 c7c5",
    "d2d4 g8f6 g1f3 d7d5 c1f4 c7c5 c2c3 d8b6",
    "e2e4 e7e6 d2d4 d7d5 e4d5 e6d5 g1f3 f7f5",
    "e2e4 d7d5 e4d5 d8d5 d2d4 d5d8 g1f3 g8f6",
    "e2e4 e7e5 b1c3 b8c6 f1c4 f8c5 d1g4 d8f6",
    "e2e4 c7c5 g1f3 b8c6 d2d4 c5d4 f3d4 d8c7",
    "g1f3 g8f6 c2c4 c7c6 e2e3 d7d5 d1c2 g7g6",
    "e2e4 c7c5 d2d4 c5d4 g1f3 b8c6 c2c3 d4d3",
    "e2e3 g8f6 d2d4 e7e6 g1f3 d7d5 b1d2 f8e7",
    "d2d4 c7c5 d4d5 e7e5 b1c3 d7d6 e2e4 a7a6",
    "e2e3 c7c5 d2d4 c5d4 e3d4 g7g6 f2f4 b7b6",
    "e2e4 e7e5 g1f3 b8c6 f1c4 d7d6 d2d4 e5d4",
    "g1f3 d7d6 d2d4 g7g6 b1c3 f8g7 e2e4 h7h6",
    "d2d4 g8f6 g1f3 e7e6 c2c4 c7c5 e2e3 d7d5",
    "d2d4 e7e6 g1f3 d7d5 b1c3 g8f6 c1g5 f8e7",
    "e2e4 e7e6 b1c3 d7d5 g2g3 d5d4 c3e2 c7c5",
    "d2d4 g8f6 c1f4 g7g6 b1c3 d7d5 e2e3 f8g7",
    "d2d4 d7d5 c2c4 c8f5 g1f3 e7e6 b1c3 b8c6",
    "d2d4 g8f6 g1f3 e7e6 c1f4 b7b6 e2e3 c8b7",
    "e2e4 g8f6 e4e5 f6g8 b1c3 d7d6 e5d6 c7d6",
    "e2e4 e7e5 g1f3 b8c6 f1b5 a7a6 b5a4 f8e7",
    "d2d4 g8f6 c1f4 c7c5 g1f3 c5d4 c2c3 d4c3",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c6c5 c2c4 d5c4",
    "e2e4 d7d5 e4d5 d8d5 d2d4 g8f6 f1d3 b8c6",
    "g2g3 d7d5 f2f3 c7c6 g1h3 g8f6 h3f2 g7g6",
    "e2e4 e7e6 d2d3 d7d5 e4d5 e6d5 g1e2 f7f5",
    "e2e4 e7e6 d2d4 d7d5 b1d2 b8c6 g1f3 g8f6",
    "d2d4 g8f6 g1f3 g7g6 e2e3 f8g7 f1d3 e8g8",
    "f2f4 g7g6 g1f3 f8g7 c2c4 d7d6 b1c3 g8f6",
    "e2e4 g7g6 d2d4 f8g7 c2c3 c7c6 g1f3 d7d5",
    "e2e4 c7c6 b1c3 d7d5 d2d3 b7b5 e4d5 b5b4",
    "d2d3 g8f6 g2g3 e7e6 f1g2 d7d5 g1f3 f8e7",
    "e2e4 c7c5 d2d4 e7e6 d4d5 g8f6 b1c3 e6d5",
    "e2e4 e7e5 g1f3 f7f5 f3e5 d7d6 e5c4 f5e4",
    "g1f3 d7d5 d2d4 e7e5 c2c4 b8c6 c4d5 d8d5",
    "d2d4 c7c6 c2c4 b7b5 b1c3 b5c4 e2e4 d7d5",
    "d2d4 d7d5 c2c3 c7c6 g1f3 g8f6 c1f4 c8f5",
    "e2e4 d7d5 e4d5 g8f6 f1b5 b8d7 c2c4 a7a6",
    "g1f3 f7f6 c2c4 e7e6 b1c3 d7d5 d2d4 c7c6",
    "d2d4 e7e6 b1c3 d7d5 e2e4 d5e4 c3e4 b8c6",
    "b2b3 e7e5 c1b2 b8c6 e2e3 g8f6 f1b5 e5e4",
    "d2d4 d7d5 c2c4 e7e6 g1f3 g8f6 b1c3 f8b4",
    "g1f3 g8f6 g2g3 g7g6 f1g2 d7d5 e1g1 c7c5",
    "e2e4 d7d5 e4d5 g8f6 c2c4 c7c6 d2d4 c6d5",
    "d2d4 g8f6 g1f3 e7e6 b1c3 f8e7 c1g5 d7d5",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c8f5 b1d2 e7e6",
    "b2b3 g7g6 a2a3 f8g7 c1b2 g7b2 a1a2 b2g7",
    "e2e4 c7c6 d2d4 d7d5 e4e5 c6c5 g1f3 b8c6",
    "e2e4 e7e5 b1c3 b8c6 g2g3 g7g6 f1g2 f8g7",
    "d2d4 d7d5 g1f3 e7e6 c2c4 c7c6 b1c3 d5c4",
    "b1c3 e7e5 d2d4 e5d4 d1d4 b8c6 d4e3 f8e7",
    "d2d4 d7d5 g1f3 e7e6 b1c3 g8f6 c1g5 c7c5",
    "e2e3 c7c5 b1c3 g7g6 d2d4 c5d4 e3d4 f8g7",
    "e2e4 c7c5 b1c3 b8c6 g1e2 g7g6 d2d4 c5d4",
    "b2b3 e7e5 c1b2 b8c6 e2e3 g8f6 f1b5 f8d6",
    "e2e4 d7d5 e4d5 c7c6 d2d4 g8f6 f1d3 d8d5",
    "e2e4 c7c5 b1c3 e7e6 f2f4 d7d5 g1f3 d5e4",
    "d2d4 g8f6 c2c4 d7d5 g1f3 c7c6 d1b3 a7a6",
    "g1f3 g8f6 c2c4 e7e6 b2b3 b7b6 c1b2 c8b7",
    "c2c4 g8f6 g2g3 e7e6 f1g2 f8e7 g1f3 e8g8",
    "d2d4 c7c5 d4c5 b8a6 e2e4 a6c5 b1c3 d7d6",
    "g1f3 d7d5 d2d4 e7e6 c2c4 g8f6 b1c3 f8b4",
    "d2d4 g8f6 g1f3 b7b6 c1f4 c8b7 b1d2 e7e6",
    "e2e4 e7e6 g1f3 d7d5 e4e5 d5d4 f1e2 c7c5",
    "e2e4 g7g6 d2d4 f8g7 c2c4 c7c6 b1c3 c6c5",
    "e2e4 c7c5 d2d4 c5d4 c2c3 d4d3 c3c4 b8c6",
    "b2b3 e7e5 c1b2 b8c6 c2c4 g8f6 e2e3 g7g6",
    "e2e4 g7g6 g1f3 f8g7 d2d4 c7c5 d4d5 d7d6",
    "d2d4 g8f6 g1f3 e7e6 e2e3 b7b6 b2b3 c8b7",
    "g2g3 h7h5 f1g2 h5h4 g3h4 e7e6 d2d4 d8h4",
    "e2e4 c7c5 g1f3 d7d6 f1b5 b8d7 d2d4 c5d4",
    "b2b3 a7a5 c1b2 a5a4 b3a4 e7e6 b1c3 g8f6",
    "e2e4 c7c6 g1f3 d7d6 d2d4 c8g4 f1d3 g4f3",
    "d2d4 d7d6 c2c3 c7c6 g1f3 d8c7 c1f4 f7f5",
    "d2d4 e7e5 d4e5 b8c6 g1f3 d7d6 c1f4 g8e7",
    "g2g3 g7g6 f1g2 f8g7 h2h3 c7c6 d2d3 d7d6",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 d2d3 f8e7",
    "d2d4 b7b6 e2e4 c8b7 f1d3 g7g6 g1f3 f8g7",
    "e2e4 d7d5 e4d5 g8f6 b1c3 f6d5 f1e2 e7e6",
    "e2e4 b8c6 d2d4 e7e5 d4d5 c6e7 c2c4 e7g6",
    "d2d4 g8f6 b1c3 g7g6 e2e4 f8g7 e4e5 f6g8",
    "d2d4 g8f6 g1f3 g7g6 e2e3 d7d6 f1e2 f8g7",
    "e2e4 b7b6 d2d4 c8b7 f1d3 g7g6 d1e2 f8g7",
    "b1a3 b7b6 c2c3 c8b7 a3c2 g8f6 f2f3 c7c5",
    "g1f3 a7a5 c2c4 h7h5 b1c3 e7e6 b2b3 f8e7",
    "e2e4 g7g6 d2d4 d7d6 c2c3 a7a6 f1d3 g8f6",
    "e2e4 e7e6 b1c3 d7d5 e4d5 e6d5 c3e2 b8c6",
    "e2e4 g7g6 d2d4 f8g7 b1c3 c7c5 g1e2 c5d4",
    "b1c3 c7c6 d2d4 g8f6 e2e4 g7g6 e4e5 f6d5",
    "g2g3 d7d5 f1g2 e7e5 g1f3 f7f6 d2d4 e5e4",
    "d2d4 d7d5 g1f3 c7c6 b1c3 g8f6 c1g5 c8f5",
    "d2d4 g8f6 b1c3 e7e6 e2e4 c7c5 c1g5 c5d4",
    "e2e4 c7c6 d2d3 d7d5 b1d2 g7g6 g2g3 e7e5",
    "b1c3 d7d6 d2d4 g7g6 e2e4 f8g7 f2f4 b7b5",
    "c2c4 c7c5 g2g3 e7e6 f1g2 g8f6 g1f3 f8e7",
    "d2d4 e7e5 d4e5 b8c6 g1f3 f7f6 c1f4 g7g5",
    "b2b3 g8f6 c1b2 e7e6 a2a3 f8e7 d2d3 e8g8",
    "d2d4 c7c5 d4c5 e7e6 c1e3 g8f6 c2c4 b8a6",
    "b2b3 g8f6 c1b2 g7g6 d2d3 f8g7 b1d2 e8g8",
    "e2e4 c7c5 g1f3 d7d6 b1c3 g8f6 g2g3 b8c6",
    "d2d4 d7d5 c2c4 c7c6 g1f3 g8f6 d1b3 d5c4",
    "d2d4 g8f6 c2c4 e7e6 g2g3 d7d5 f1g2 d5c4",
    "d2d4 c7c5 d4d5 e7e5 c2c4 d7d6 b1c3 f7f5",
    "e2e4 e7e5 d1h5 d7d6 f1c4 d8d7 c2c3 g8f6",
    "g1f3 d7d5 c2c4 d5c4 b1a3 g8f6 a3c4 a7a6",
    "d2d3 b7b6 e2e4 c8b7 g1f3 g7g6 c2c3 f8g7",
    "e2e4 b7b6 d2d4 c8b7 d4d5 a7a6 b1c3 d7d6",
    "e2e4 g7g6 d2d4 f8g7 b1c3 d7d6 f2f4 c7c6",
    "e2e4 c7c6 d2d4 d7d5 e4d5 c6d5 c1f4 c8f5",
    "e2e4 g7g6 b1c3 f8g7 d2d4 b7b6 h2h4 h7h6",
    "e2e4 g7g6 c2c4 f8g7 b1c3 c7c6 d2d3 d7d6",
    "h2h4 d7d5 h1h3 c7c6 h3g3 h7h6 d2d4 g8f6",
    "d2d4 d7d5 c2c4 d5c4 g1f3 c7c6 e2e3 c8e6",
    "e2e4 c7c5 g1f3 d7d6 f1b5 c8d7 b5c4 g8f6",
    "d2d4 g8f6 c2c4 b8c6 g1f3 e7e6 g2g3 f8b4",
    "g1f3 g8f6 e2e4 b8c6 e4e5 f6g8 d2d4 d7d5",
    "b2b3 d7d5 a2a3 b8c6 c1b2 g7g6 e2e3 g8f6",
    "g1f3 b8c6 d2d4 d7d6 c2c4 e7e5 b1c3 g8f6",
    "e2e4 g7g6 d2d4 f8g7 c2c3 c7c5 d4d5 d7d6",
    "d2d4 d7d5 c2c4 e7e6 g2g3 c7c6 f1g2 g8f6",
    "e2e4 d7d6 g1h3 g8f6 d2d3 g7g6 g2g3 b8c6",
    "e2e4 c7c5 c2c3 d7d5 e4e5 b8c6 d2d4 c8f5",
    "e2e4 c7c5 g1f3 d7d6 f1b5 c8d7 b5c4 d7c6",
    "g2g3 d7d6 f1g2 g8f6 h2h3 g7g6 d2d3 f8g7",
    "e2e4 c7c5 d2d4 e7e6 d4d5 e6d5 e4d5 d7d6",
    "d2d4 b7b6 g1f3 c8b7 c2c4 a7a6 d4d5 e7e6",
    "e2e3 e7e6 d2d4 c7c5 f2f4 b7b6 g1f3 c8b7",
    "e2e4 g7g6 g1f3 f8g7 f1c4 c7c5 b1c3 b8c6",
    "e2e4 b7b6 d2d4 c8b7 b1c3 e7e6 f1d3 g8f6",
    "g1f3 e7e5 g2g3 e5e4 f3d4 g8f6 d4b3 a7a5",
    "g2g3 g8f6 f1g2 g7g6 e2e4 d7d6 d2d4 f8g7",
    "g1f3 c7c5 g2g3 b8c6 f1g2 g7g6 c2c4 f8g7",
    "d2d4 d7d5 c1f4 c7c6 e2e3 d8b6 d1c1 c8f5",
    "e2e4 e7e6 g1f3 d7d5 e4d5 d8d5 d2d4 d5h5",
    "b2b3 d7d5 c1b2 c7c5 g1f3 b8c6 g2g3 d5d4",
    "d2d4 g7g6 c2c4 f8g7 b1c3 c7c5 d4d5 d7d6",
    "g1f3 b7b6 d2d4 c8b7 c2c4 e7e6 b1c3 f7f5",
    "c2c4 c7c6 g2g3 d7d5 f1g2 g8f6 g1f3 e7e6",
    "g1f3 g8f6 c2c4 b7b6 b2b3 c8b7 c1b2 c7c5",
    "d2d4 e7e5 d4e5 d7d6 g1f3 b8c6 c1f4 c8g4",
    "e2e4 g7g6 h2h4 d7d6 h4h5 a7a6 f1c4 f8g7",
    "d2d4 b7b5 g1f3 c8b7 a2a4 b5b4 e2e3 a7a5",
    "b2b3 g8f6 c1b2 e7e6 g1f3 g7g6 e2e3 f8g7",
    "g2g3 g7g6 f1g2 f8g7 d2d4 e7e5 g1f3 e5d4",
    "e2e4 d7d5 e4d5 d8d5 b1c3 d5d8 g2g3 g8f6",
    "b2b3 d7d5 c1b2 c8g4 g1f3 b8d7 e2e3 e7e5",
    "d2d4 g8f6 b1c3 g7g6 c1f4 d7d6 e2e4 f8g7",
    "e2e4 d7d6 g1f3 g8f6 d2d3 g7g6 f1e2 f8g7",
    "e2e4 e7e5 c2c4 f8c5 b1c3 d7d6 d2d3 b8c6",
    "e2e4 d7d6 d2d4 g7g6 c2c3 f8g7 f1d3 g8f6",
    "e2e4 g7g6 d2d4 f7f6 c1e3 g8h6 c2c4 h6f7",
    "g2g4 d7d5 f1g2 c7c6 c2c4 e7e6 c4d5 e6d5",
    "d2d4 g8f6 b1c3 g7g6 e2e4 d7d6 c1g5 f8g7",
    "d2d4 g8f6 g1f3 d7d5 c2c4 g7g6 b1c3 c7c6",
    "b2b3 c7c5 c1b2 b8c6 g1f3 g8f6 g2g3 g7g6",
    "e2e4 c7c5 c2c3 d7d5 e4d5 d8d5 g1f3 c8g4",
    "e2e4 c7c5 g1f3 d8c7 d2d4 c5d4 b1a3 a7a6",
    "d2d4 c7c5 b1c3 c5d4 d1d4 g8f6 d4a4 b8c6",
    "e2e4 b7b6 g1f3 c8b7 b1c3 g7g6 d2d4 f8g7",
    "g2g3 d7d6 f1g2 g7g6 g1f3 f8g7 e1g1 g8f6",
    "e2e4 e7e6 f2f4 d7d5 b1c3 g8f6 e4e5 f6d7",
    "d2d4 d7d5 g1f3 g8f6 c2c4 e7e6 c1g5 d5c4",
    "d2d4 d7d5 c1g5 g7g6 e2e3 h7h6 g5h4 g8f6",
    "d2d3 c7c5 e2e4 b8c6 g1f3 g7g6 c2c3 f8g7",
    "d2d4 b7b6 c2c4 c8b7 d4d5 a7a6 e2e4 d7d6",
    "e2e4 c7c6 d2d4 f7f5 b1d2 d7d6 f1d3 g8f6",
    "e2e4 e7e5 f2f4 d7d5 e4d5 e5e4 d2d3 g8f6",
    "g1f3 g8f6 g2g3 g7g6 e2e4 f8g7 e4e5 f6d5",
    "e2e4 c7c6 g1f3 d7d5 b1c3 d5d4 c3e2 c6c5",
    "d2d4 g7g6 c2c4 f8g7 e2e4 c7c5 d4d5 d7d6",
    "e2e4 g7g6 d2d4 d7d6 b1c3 a7a6 c1e3 g8f6",
    "d2d4 g7g6 c2c3 f8g7 g1f3 g8f6 c1g5 e8g8",
    "g1f3 g8f6 d2d4 g7g6 c2c4 c7c5 g2g3 c5d4",
    "c2c4 e7e5 f2f4 e5f4 g1f3 b8c6 d2d4 d7d6",
    "b2b3 e7e5 c1b2 b8c6 g1f3 d7d6 e2e3 g8f6",
    "d2d4 c7c5 g1f3 c5d4 f3d4 b8c6 g2g3 c6d4",
    "d2d4 c7c5 b1c3 c5d4 d1d4 b8c6 d4h4 d7d5",
    "b2b3 e7e5 c1b2 b8c6 g1f3 e5e4 f3d4 d8f6",
    "d2d4 c7c5 g1f3 c5d4 d1d4 g7g6 d4h8 g8f6",
    "e2e4 d7d5 g1f3 d5e4 f3g5 c8f5 b1c3 g8f6",
    "b1c3 b7b5 e2e4 b5b4 c3d5 e7e6 d5e3 g8f6",
    "d2d4 f7f5 c2c4 g8f6 b1c3 g7g6 g2g3 f8g7",
    "d2d4 e7e6 g1f3 f7f5 c2c4 g8f6 b1c3 d7d5",
    "d2d4 e7e5 g1f3 e5e4 f3d2 d7d5 c2c4 c7c6",
    "d2d4 g7g6 e2e3 f8g7 f1d3 g8f6 f2f4 e8g8",
    "e2e4 c7c5 g1f3 g7g6 h2h4 h7h5 f1c4 b8c6",
    "d2d4 e7e5 d4e5 g7g5 b1c3 b8c6 e2e4 c6e5",
    "d2d4 g8f6 c2c4 e7e6 g1f3 c7c6 e2e3 d7d5",
    "e2e4 g8f6 d2d3 d7d5 b1d2 d5e4 d3e4 e7e5",
    "g1f3 c7c5 b2b3 g8f6 c1b2 g7g6 b2f6 e7f6",
    "g2g3 d7d5 f1g2 g8f6 g1f3 b8d7 e1g1 c7c6",
    "c2c4 g8f6 g2g3 g7g6 f1g2 d7d6 b1c3 f8g7",
    "e2e3 c7c5 d2d4 c5d4 e3d4 b8c6 c2c3 d7d5",
    "b2b3 a7a5 c1b2 a5a4 b3b4 e7e6 a2a3 g8f6",
    "e2e4 c7c5 f2f4 a7a6 b1c3 b7b5 g1f3 c8b7",
    "g1f3 e7e5 d2d4 e5e4 f3d2 d7d5 e2e3 g8f6",
    "e2e4 g7g6 c2c3 g8f6 e4e5 f6d5 c3c4 d5b6",
    "f2f4 e7e5 f4e5 d7d6 g1f3 b8c6 d2d4 d6e5",
    "d2d4 c7c5 g1f3 c5d4 f3d4 d7d5 c2c4 e7e5",
    "d2d4 g8f6 c1f4 e7e6 e2e3 d7d6 h2h3 e8e7",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 d2d3 d7d5",
    "e2e4 g7g6 c2c4 f8g7 b1c3 e7e5 g2g3 d7d6",
    "e2e4 b8c6 b1c3 g7g6 d2d4 f8g7 g1f3 d7d6",
    "e2e4 c7c5 g1f3 d7d6 c2c3 e7e6 d2d4 c5d4",
    "e2e4 e7e5 b1c3 f7f5 g1f3 g8f6 d2d4 e5d4",
    "a2a4 g7g6 a1a3 f8g7 b2b4 d7d5 e2e3 g8f6",
    "e2e4 d7d5 e4d5 g8f6 g1f3 f6d5 d2d4 e7e6",
    "e2e3 c7c5 d2d4 g8f6 c2c4 g7g6 b1c3 f8g7",
    "d2d4 e7e5 d4e5 d8e7 g1f3 b8c6 b1c3 c6e5",
    "d2d4 d7d5 g1f3 e7e6 c1g5 g8f6 b1c3 f8d6",
    "e2e4 e7e5 c2c4 b8c6 d2d3 f8c5 c1e3 d7d6",
    "e2e4 e7e6 d2d3 d7d6 b1d2 c7c5 g1f3 b8c6",
    "g1f3 g7g6 g2g3 f8g7 e2e4 c7c6 f1g2 d7d5",
    "d2d4 g8f6 c2c4 e7e6 g1f3 f8b4 c1d2 d8e7",
    "f2f4 d7d5 g1f3 e7e6 e2e3 g8f6 b2b3 f8e7",
    "d2d4 g8f6 c2c4 b8c6 b1c3 e7e5 d4d5 c6e7",
    "d2d4 d7d5 g1f3 g7g6 g2g3 f8g7 f1g2 g8f6",
    "b2b3 e7e5 c1b2 b8c6 g2g3 d7d5 f1g2 g8f6",
    "e2e4 c7c5 g1f3 d7d6 c2c3 g8f6 f1e2 g7g6",
    "c2c4 e7e5 g2g3 b8c6 f1g2 f8c5 b1c3 g8e7",
    "e2e4 e7e6 c2c4 d7d5 c4d5 e6d5 e4d5 g8f6",
    "d2d4 g8f6 b1c3 e7e5 d4e5 f6g4 g1f3 b8c6",
    "e2e3 c7c6 d2d4 d7d5 g1f3 g8f6 f1e2 c8g4",
    "c2c4 e7e5 g2g3 g8f6 f1g2 c7c6 d2d4 e5e4",
    "d2d4 g8f6 c2c4 e7e6 b1c3 f8b4 d1c2 d7d5",
    "b2b3 d7d5 c1b2 c8g4 h2h3 g4h5 g1f3 c7c6",
    "g1f3 e7e6 e2e4 d7d5 e4d5 e6d5 d2d4 c7c6",
    "g1f3 d7d5 c2c4 e7e6 g2g3 g8f6 d2d4 h7h6",
    "e2e4 c7c5 f1c4 b8c6 d2d3 g7g6 g1f3 f8g7",
    "b2b3 e7e5 c1b2 b8c6 e2e3 g8f6 f1b5 d7d6",
    "d2d4 b8c6 g1f3 g8f6 g2g3 g7g6 f1g2 f8g7",
    "c2c4 c7c5 d2d3 d7d6 g2g3 g8f6 f1g2 b8c6",
    "c2c4 b7b5 b1c3 b5c4 d2d4 e7e6 e2e4 d7d5",
    "g1f3 g8f6 b1c3 e7e6 e2e4 d7d6 f1d3 f8e7",
    "g2g3 d7d5 f1g2 g8f6 d2d4 c7c5 g1f3 b8c6",
    "d2d4 g8f6 c2c4 c7c5 b1c3 c5d4 d1d4 b8c6",
    "e2e4 c7c6 f2f4 d7d5 b1c3 d5e4 g1e2 g8f6",
    "d2d4 d7d5 e2e4 c7c6 b1c3 d5e4 f2f3 b8d7",
    "d2d4 g8f6 g1f3 c7c5 b1c3 c5d4 d1d4 g7g6",
    "e2e4 e7e5 d2d4 b8c6 d4d5 c6e7 c2c4 d7d6",
    "f2f4 g7g6 g1f3 f8g7 e2e3 e7e6 d2d4 g8e7",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 d2d3 a7a6",
    "g2g3 c7c6 f1g2 d7d5 g1f3 h7h5 e1g1 g7g6",
    "c2c3 c7c5 d2d4 c5d4 g1f3 d4c3 b1c3 g7g6",
    "e2e4 e7e5 g1f3 d7d6 d2d4 e5d4 f3d4 f8e7",
    "b2b3 d7d5 c1b2 c7c6 g1f3 g8f6 e2e3 c8g4",
    "d2d4 g8f6 g1f3 e7e6 c1g5 h7h6 g5h4 b7b6",
    "d2d4 g8f6 e2e3 e7e6 g1f3 d7d5 f1e2 f8e7",
    "d2d4 g8f6 g1f3 e7e6 c1g5 h7h6 g5h4 g7g5",
    "e2e4 g7g6 d2d4 f8g7 c1e3 e7e6 b1c3 g8e7",
    "e2e3 e7e6 c2c4 c7c5 b1c3 b8c6 g1f3 g8f6",
    "c2c4 c7c6 b1c3 d7d5 e2e3 e7e6 g1f3 f7f5",
    "e2e4 c7c5 b1c3 d7d6 g1f3 g8f6 f1c4 g7g6",
    "e2e4 c7c6 f2f4 d7d5 b1c3 d5e4 c3e4 g8f6",
    "e2e4 e7e5 g1f3 b8c6 f1c4 g8f6 e1g1 f6e4",
    "e2e4 b7b6 d2d3 c8b7 b1c3 g7g6 g2g3 f8g7",
    "c2c3 b8c6 d2d4 d7d5 g1f3 f7f6 g2g3 e7e5",
    "d2d4 g7g6 c1h6 g8h6 e2e3 f8g7 c2c3 e8g8",
    "e2e4 c7c5 g1f3 d8c7 d2d4 c5d4 f3d4 a7a6",
    "c2c4 g8f6 b1c3 e7e6 e2e4 d7d5 e4e5 f6e4",
    "g1f3 g7g6 g2g3 f8g7 d2d3 g8f6 h2h4 d7d6",
    "d2d4 g8f6 g1f3 d7d5 b1c3 c7c5 c1g5 c5d4",
    "d2d4 e7e6 b1c3 f7f5 e2e4 f5e4 c3e4 g8f6",
    "e2e4 e7e5 d2d4 e5d4 c2c3 d7d5 e4d5 d8d5",
    "d2d4 g8f6 g1f3 e7e6 c1g5 b7b6 e2e4 h7h6",
    "c2c4 e7e6 g1f3 d7d5 e2e3 g8f6 b2b3 b7b6",
    "e2e4 d7d5 e4d5 g8f6 f1b5 c7c6 d5c6 b8c6",
    "d2d4 g8f6 c2c3 g7g6 c1g5 f8g7 g5f6 g7f6",
    "e2e4 g8f6 b1c3 d7d6 e4e5 d6e5 g1f3 b8c6",
    "e2e4 e7e5 c2c4 b8c6 b1c3 g8f6 g2g3 f8c5",
    "e2e4 e7e6 f1c4 d7d5 e4d5 e6d5 c4b3 g8f6",
    "b2b3 c7c5 c1b2 g8f6 c2c4 g7g6 b1c3 f8g7",
    "e2e4 e7e6 b1c3 c7c5 g1f3 g8f6 e4e5 f6d5",
    "d2d4 d7d5 e2e4 c7c6 b1c3 g8f6 e4e5 f6d7",
    "b2b3 d7d6 c1b2 b8d7 g2g3 g8f6 f1g2 g7g6",
    "e2e4 e7e5 g1f3 g8f6 b1c3 f8e7 d2d4 e5d4",
    "e2e3 c7c6 d2d3 d7d5 g1f3 g8f6 g2g3 c8g4",
    "d2d4 c7c5 b1c3 c5d4 d1d4 g8f6 d4h4 e7e6",
    "e2e4 e7e6 d2d4 d7d5 b1d2 f7f5 e4f5 e6f5",
    "g1f3 h7h5 e2e4 a7a5 d2d4 e7e6 b1c3 d7d6",
    "e2e4 e7e6 g1f3 d7d5 e4d5 e6d5 f1e2 b8c6",
    "e2e4 b7b5 d2d3 c8b7 g2g3 a7a6 f1g2 e7e6",
    "b2b3 a7a5 a2a3 c7c5 c1b2 b7b6 g2g3 c8b7",
    "d2d4 c7c6 c2c4 g8f6 b1c3 d7d5 c1f4 c8f5",
    "e2e3 c7c5 c2c3 g8f6 d2d4 g7g6 g1f3 f8g7",
    "e2e4 g7g6 d2d4 f8g7 b1c3 b7b6 g1e2 c8b7",
    "e2e4 c7c5 b1c3 e7e6 g2g3 a7a6 a2a4 b8c6",
    "b2b3 d7d5 c1b2 d5d4 a2a3 c7c5 e2e3 b8c6",
    "d2d4 c7c5 g1f3 c5d4 c2c3 e7e5 c3d4 e5e4",
    "g2g3 g7g6 f1g2 f8g7 e2e4 c7c5 g1e2 b8c6",
    "g1f3 e7e5 d2d4 e5e4 f3d2 e4e3 f2e3 d7d5",
    "e2e4 c7c5 g1f3 d7d6 d2d4 c5d4 d1d4 a7a6",
    "e2e4 c7c5 g1f3 b8c6 d2d4 c5d4 c2c3 d4c3",
    "e2e4 c7c5 g1f3 b8c6 f1b5 e7e5 b5c6 d7c6",
    "d2d4 e7e6 g1f3 f7f5 c2c3 d7d5 c1f4 c7c6",
    "d2d4 d7d5 b1c3 g8f6 c1g5 b8d7 g1f3 e7e6",
    "e2e4 e7e6 d2d4 d7d5 b1c3 g8f6 c1g5 f8b4",
]


def random_agent(obs):
    """
    Selects a random legal move from the board.
    Returns:
    A string representing the chosen move in UCI notation (e.g., "e2e4").
    """
    game = Game(obs.board)
    moves = list(game.get_moves())
    return random.choice(moves) if moves else None


def king_shuffle_agent(obs):
    """Moves the king pawn and then shuffles the king."""
    game = Game(obs.board)
    moves = list(game.get_moves())

    to_move = ["e7e5", "e2e4", "e8e7", "e7e8", "e1e2", "e2e1"]
    for move in to_move:
        if move in moves:
            return move

    # If no other moves are possible, pick a random legal move (or return None)
    return random.choice(moves) if moves else None


def board_shuffle_agent(obs):
    """Moves the king panw and then shuffles pieces."""
    game = Game(obs.board)
    moves = list(game.get_moves())

    to_move = ["e7e5", "e2e4", "e8e7", "e7e6", "e1e2", "e2e3"]
    for move in to_move:
        if move in moves:
            return move

    # add shuffle moves for knights and bishop
    to_shuffle = [
        "b1c3",
        "c3b1",
        "g1f3",
        "f3g1",
        "b8c6",
        "c6b8",
        "g8f6",
        "f6g8",
        "f1e2",
        "e2f1",
        "f8e7",
        "e7f8",
    ]
    # filter to only shuffle king moves
    for move in moves:
        f1 = move[0]
        f2 = move[2]
        r1 = int(move[1])
        r2 = int(move[3])
        df = abs(ord(f1) - ord(f2))
        dr = abs(r2 - r1)
        if r1 < 3 or r1 > 6:
            continue
        if r2 < 3 or r2 > 6:
            continue
        if dr > 1 or df > 1:
            continue
        if move[2:4] == "e5":
            continue
        if move[2:4] == "e4":
            continue
        to_shuffle.append(move)
    random.shuffle(to_shuffle)
    for move in to_shuffle:
        if move in moves:
            return move

    # If no other moves are possible, pick a random legal move (or return None)
    return random.choice(moves) if moves else None


agents = {"random": random_agent, "king_shuffle": king_shuffle_agent, "board_shuffle": board_shuffle_agent}


def sufficient_material(pieces):
    """Checks if the given pieces are sufficient for checkmate."""
    if pieces["q"] > 0 or pieces["r"] > 0 or pieces["p"] > 0:
        return True
    # we only have knights and bishops left on this team
    knight_bishop_count = pieces["n"] + pieces["b"]
    if knight_bishop_count >= 3:
        return True
    if knight_bishop_count == 2 and pieces["b"] >= 1:
        return True

    return False


def is_insufficient_material(board):
    white_pieces = defaultdict(int)
    black_pieces = defaultdict(int)

    for square in range(64):
        piece = board.get_piece(square)
        if piece and piece != " ":
            if piece.isupper():
                white_pieces[piece.lower()] += 1
            else:
                black_pieces[piece.lower()] += 1

    if not sufficient_material(white_pieces) and not sufficient_material(black_pieces):
        return True

    return False


def square_str_to_int(square_str):
    """Converts a square string (e.g., "a2") to an integer index (0-63)."""
    if len(square_str) != 2 or not ("a" <= square_str[0] <= "h" and "1" <= square_str[1] <= "8"):
        raise ValueError("Invalid square string")

    col = ord(square_str[0]) - ord("a")  # Get column index (0-7)
    row = int(square_str[1]) - 1  # Get row index (0-7)
    return row * 8 + col


seen_positions = defaultdict(int)


def interpreter(state, env):
    global seen_positions
    if env.done:
        seen_positions = defaultdict(int)
        game_start_position = math.floor(random.random() * len(OPENINGS))
        if "seed" in env.configuration:
            seed = int(env.configuration["seed"])
            game_start_position = seed % len(OPENINGS)
        state[0].observation.board = OPENINGS[game_start_position]
        state[1].observation.board = OPENINGS[game_start_position]
        return state

    # Isolate the active and inactive agents.
    active = state[0] if state[0].status == ACTIVE else state[1]
    inactive = state[0] if state[0].status == INACTIVE else state[1]
    if active.status != ACTIVE or inactive.status != INACTIVE:
        active.status = DONE if active.status == ACTIVE else active.status
        inactive.status = DONE if inactive.status == INACTIVE else inactive.status
        return state

    # The board is shared, only update the first state.
    board = state[0].observation.board

    # Create a Chessnut game object from the FEN string
    game = Game(board)

    # Get the action (move) from the agent
    action = active.action

    # Check if the move is legal
    try:
        game.apply_move(action)
    except BaseException:
        active.status = ERROR
        active.reward = -1
        inactive.status = DONE
        return state
    fen = game.get_fen()
    # board, player turn, en passant, and castling status form board status
    # for 3-fold draws
    board_position = " ".join(fen.split()[:4])
    seen_positions[board_position] += 1

    # Update the board in the observation
    state[0].observation.board = fen
    state[1].observation.board = fen

    # Update the opponentRemainingOverageTime
    state[0].observation.opponentRemainingOverageTime = state[1].observation.remainingOverageTime
    state[1].observation.opponentRemainingOverageTime = state[0].observation.remainingOverageTime

    # Update last move
    state[0].observation.lastMove = action
    state[1].observation.lastMove = action

    pawn_or_capture_move_count = int(fen.split(" ")[4])  # fen keeps track of this
    # Check for game end conditions
    if (
        pawn_or_capture_move_count == 100
        or is_insufficient_material(game.board)
        or seen_positions[board_position] >= 3
        or game.status == Game.STALEMATE
    ):
        active.reward += 0.5
        inactive.reward += 0.5
        active.status = DONE
        inactive.status = DONE
    elif game.status == Game.CHECKMATE:
        active.reward += 1
        active.status = DONE
        inactive.status = DONE
    else:
        # Switch turns
        active.status = INACTIVE
        inactive.status = ACTIVE

    return state


def renderer(state, env):
    board_fen = state[0].observation.board
    game = Game(board_fen)
    return game.board


jsonpath = path.abspath(path.join(path.dirname(__file__), "chess.json"))
with open(jsonpath) as f:
    specification = json.load(f)


def html_renderer():
    jspath = path.abspath(path.join(path.dirname(__file__), "chess.js"))
    with open(jspath, encoding="utf-8") as g:
        return g.read()
