# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictStr, field_validator
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from rcabench.openapi.models.dto_execution_payload import DtoExecutionPayload
from rcabench.openapi.models.dto_generic_response_dto_list_algorithms_resp import DtoGenericResponseDtoListAlgorithmsResp
from rcabench.openapi.models.dto_generic_response_dto_submit_resp import DtoGenericResponseDtoSubmitResp

from rcabench.openapi.api_client import ApiClient, RequestSerialized
from rcabench.openapi.api_response import ApiResponse
from rcabench.openapi.rest import RESTResponseType


class AlgorithmApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://rcabench.openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_v1_algorithms_build_post(
        self,
        algorithm: Annotated[StrictStr, Field(description="算法名称，用于标识算法，将作为镜像构建的标识符")],
        image: Annotated[StrictStr, Field(description="Docker镜像名称。支持以下格式：1) image-name（自动添加默认Harbor地址和命名空间）2) namespace/image-name（自动添加默认Harbor地址）")],
        tag: Annotated[Optional[StrictStr], Field(description="Docker镜像标签，用于版本控制")] = None,
        command: Annotated[Optional[StrictStr], Field(description="Docker镜像启动命令，默认为bash /entrypoint.sh")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="构建源类型，指定算法源码来源")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="算法源码文件（支持zip或tar.gz格式），当source_type为file时必需，文件大小限制5MB")] = None,
        github_token: Annotated[Optional[StrictStr], Field(description="GitHub访问令牌，用于访问私有仓库，公开仓库可不提供")] = None,
        github_repo: Annotated[Optional[StrictStr], Field(description="GitHub仓库地址，格式：owner/repo，当source_type为github时必需")] = None,
        github_branch: Annotated[Optional[StrictStr], Field(description="GitHub分支名，指定要构建的分支")] = None,
        github_commit: Annotated[Optional[StrictStr], Field(description="GitHub commit哈希值（支持短hash），如果指定commit则忽略branch参数")] = None,
        github_path: Annotated[Optional[StrictStr], Field(description="仓库内的子目录路径，如果算法源码不在根目录")] = None,
        context_dir: Annotated[Optional[StrictStr], Field(description="Docker构建上下文路径，相对于源码根目录")] = None,
        dockerfile_path: Annotated[Optional[StrictStr], Field(description="Dockerfile路径，相对于源码根目录")] = None,
        target: Annotated[Optional[StrictStr], Field(description="Dockerfile构建目标（multi-stage build时使用）")] = None,
        force_rebuild: Annotated[Optional[StrictBool], Field(description="是否强制重新构建镜像，忽略缓存")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoSubmitResp:
        """提交算法构建任务

        通过上传文件或指定GitHub仓库来构建算法Docker镜像。支持zip和tar.gz格式的文件上传，或从GitHub仓库自动拉取代码进行构建。系统会自动验证必需文件（Dockerfile）并设置执行权限

        :param algorithm: 算法名称，用于标识算法，将作为镜像构建的标识符 (required)
        :type algorithm: str
        :param image: Docker镜像名称。支持以下格式：1) image-name（自动添加默认Harbor地址和命名空间）2) namespace/image-name（自动添加默认Harbor地址） (required)
        :type image: str
        :param tag: Docker镜像标签，用于版本控制
        :type tag: str
        :param command: Docker镜像启动命令，默认为bash /entrypoint.sh
        :type command: str
        :param source_type: 构建源类型，指定算法源码来源
        :type source_type: str
        :param file: 算法源码文件（支持zip或tar.gz格式），当source_type为file时必需，文件大小限制5MB
        :type file: bytearray
        :param github_token: GitHub访问令牌，用于访问私有仓库，公开仓库可不提供
        :type github_token: str
        :param github_repo: GitHub仓库地址，格式：owner/repo，当source_type为github时必需
        :type github_repo: str
        :param github_branch: GitHub分支名，指定要构建的分支
        :type github_branch: str
        :param github_commit: GitHub commit哈希值（支持短hash），如果指定commit则忽略branch参数
        :type github_commit: str
        :param github_path: 仓库内的子目录路径，如果算法源码不在根目录
        :type github_path: str
        :param context_dir: Docker构建上下文路径，相对于源码根目录
        :type context_dir: str
        :param dockerfile_path: Dockerfile路径，相对于源码根目录
        :type dockerfile_path: str
        :param target: Dockerfile构建目标（multi-stage build时使用）
        :type target: str
        :param force_rebuild: 是否强制重新构建镜像，忽略缓存
        :type force_rebuild: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_build_post_serialize(
            algorithm=algorithm,
            image=image,
            tag=tag,
            command=command,
            source_type=source_type,
            file=file,
            github_token=github_token,
            github_repo=github_repo,
            github_branch=github_branch,
            github_commit=github_commit,
            github_path=github_path,
            context_dir=context_dir,
            dockerfile_path=dockerfile_path,
            target=target,
            force_rebuild=force_rebuild,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_algorithms_build_post_with_http_info(
        self,
        algorithm: Annotated[StrictStr, Field(description="算法名称，用于标识算法，将作为镜像构建的标识符")],
        image: Annotated[StrictStr, Field(description="Docker镜像名称。支持以下格式：1) image-name（自动添加默认Harbor地址和命名空间）2) namespace/image-name（自动添加默认Harbor地址）")],
        tag: Annotated[Optional[StrictStr], Field(description="Docker镜像标签，用于版本控制")] = None,
        command: Annotated[Optional[StrictStr], Field(description="Docker镜像启动命令，默认为bash /entrypoint.sh")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="构建源类型，指定算法源码来源")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="算法源码文件（支持zip或tar.gz格式），当source_type为file时必需，文件大小限制5MB")] = None,
        github_token: Annotated[Optional[StrictStr], Field(description="GitHub访问令牌，用于访问私有仓库，公开仓库可不提供")] = None,
        github_repo: Annotated[Optional[StrictStr], Field(description="GitHub仓库地址，格式：owner/repo，当source_type为github时必需")] = None,
        github_branch: Annotated[Optional[StrictStr], Field(description="GitHub分支名，指定要构建的分支")] = None,
        github_commit: Annotated[Optional[StrictStr], Field(description="GitHub commit哈希值（支持短hash），如果指定commit则忽略branch参数")] = None,
        github_path: Annotated[Optional[StrictStr], Field(description="仓库内的子目录路径，如果算法源码不在根目录")] = None,
        context_dir: Annotated[Optional[StrictStr], Field(description="Docker构建上下文路径，相对于源码根目录")] = None,
        dockerfile_path: Annotated[Optional[StrictStr], Field(description="Dockerfile路径，相对于源码根目录")] = None,
        target: Annotated[Optional[StrictStr], Field(description="Dockerfile构建目标（multi-stage build时使用）")] = None,
        force_rebuild: Annotated[Optional[StrictBool], Field(description="是否强制重新构建镜像，忽略缓存")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoSubmitResp]:
        """提交算法构建任务

        通过上传文件或指定GitHub仓库来构建算法Docker镜像。支持zip和tar.gz格式的文件上传，或从GitHub仓库自动拉取代码进行构建。系统会自动验证必需文件（Dockerfile）并设置执行权限

        :param algorithm: 算法名称，用于标识算法，将作为镜像构建的标识符 (required)
        :type algorithm: str
        :param image: Docker镜像名称。支持以下格式：1) image-name（自动添加默认Harbor地址和命名空间）2) namespace/image-name（自动添加默认Harbor地址） (required)
        :type image: str
        :param tag: Docker镜像标签，用于版本控制
        :type tag: str
        :param command: Docker镜像启动命令，默认为bash /entrypoint.sh
        :type command: str
        :param source_type: 构建源类型，指定算法源码来源
        :type source_type: str
        :param file: 算法源码文件（支持zip或tar.gz格式），当source_type为file时必需，文件大小限制5MB
        :type file: bytearray
        :param github_token: GitHub访问令牌，用于访问私有仓库，公开仓库可不提供
        :type github_token: str
        :param github_repo: GitHub仓库地址，格式：owner/repo，当source_type为github时必需
        :type github_repo: str
        :param github_branch: GitHub分支名，指定要构建的分支
        :type github_branch: str
        :param github_commit: GitHub commit哈希值（支持短hash），如果指定commit则忽略branch参数
        :type github_commit: str
        :param github_path: 仓库内的子目录路径，如果算法源码不在根目录
        :type github_path: str
        :param context_dir: Docker构建上下文路径，相对于源码根目录
        :type context_dir: str
        :param dockerfile_path: Dockerfile路径，相对于源码根目录
        :type dockerfile_path: str
        :param target: Dockerfile构建目标（multi-stage build时使用）
        :type target: str
        :param force_rebuild: 是否强制重新构建镜像，忽略缓存
        :type force_rebuild: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_build_post_serialize(
            algorithm=algorithm,
            image=image,
            tag=tag,
            command=command,
            source_type=source_type,
            file=file,
            github_token=github_token,
            github_repo=github_repo,
            github_branch=github_branch,
            github_commit=github_commit,
            github_path=github_path,
            context_dir=context_dir,
            dockerfile_path=dockerfile_path,
            target=target,
            force_rebuild=force_rebuild,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_algorithms_build_post_without_preload_content(
        self,
        algorithm: Annotated[StrictStr, Field(description="算法名称，用于标识算法，将作为镜像构建的标识符")],
        image: Annotated[StrictStr, Field(description="Docker镜像名称。支持以下格式：1) image-name（自动添加默认Harbor地址和命名空间）2) namespace/image-name（自动添加默认Harbor地址）")],
        tag: Annotated[Optional[StrictStr], Field(description="Docker镜像标签，用于版本控制")] = None,
        command: Annotated[Optional[StrictStr], Field(description="Docker镜像启动命令，默认为bash /entrypoint.sh")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="构建源类型，指定算法源码来源")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="算法源码文件（支持zip或tar.gz格式），当source_type为file时必需，文件大小限制5MB")] = None,
        github_token: Annotated[Optional[StrictStr], Field(description="GitHub访问令牌，用于访问私有仓库，公开仓库可不提供")] = None,
        github_repo: Annotated[Optional[StrictStr], Field(description="GitHub仓库地址，格式：owner/repo，当source_type为github时必需")] = None,
        github_branch: Annotated[Optional[StrictStr], Field(description="GitHub分支名，指定要构建的分支")] = None,
        github_commit: Annotated[Optional[StrictStr], Field(description="GitHub commit哈希值（支持短hash），如果指定commit则忽略branch参数")] = None,
        github_path: Annotated[Optional[StrictStr], Field(description="仓库内的子目录路径，如果算法源码不在根目录")] = None,
        context_dir: Annotated[Optional[StrictStr], Field(description="Docker构建上下文路径，相对于源码根目录")] = None,
        dockerfile_path: Annotated[Optional[StrictStr], Field(description="Dockerfile路径，相对于源码根目录")] = None,
        target: Annotated[Optional[StrictStr], Field(description="Dockerfile构建目标（multi-stage build时使用）")] = None,
        force_rebuild: Annotated[Optional[StrictBool], Field(description="是否强制重新构建镜像，忽略缓存")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """提交算法构建任务

        通过上传文件或指定GitHub仓库来构建算法Docker镜像。支持zip和tar.gz格式的文件上传，或从GitHub仓库自动拉取代码进行构建。系统会自动验证必需文件（Dockerfile）并设置执行权限

        :param algorithm: 算法名称，用于标识算法，将作为镜像构建的标识符 (required)
        :type algorithm: str
        :param image: Docker镜像名称。支持以下格式：1) image-name（自动添加默认Harbor地址和命名空间）2) namespace/image-name（自动添加默认Harbor地址） (required)
        :type image: str
        :param tag: Docker镜像标签，用于版本控制
        :type tag: str
        :param command: Docker镜像启动命令，默认为bash /entrypoint.sh
        :type command: str
        :param source_type: 构建源类型，指定算法源码来源
        :type source_type: str
        :param file: 算法源码文件（支持zip或tar.gz格式），当source_type为file时必需，文件大小限制5MB
        :type file: bytearray
        :param github_token: GitHub访问令牌，用于访问私有仓库，公开仓库可不提供
        :type github_token: str
        :param github_repo: GitHub仓库地址，格式：owner/repo，当source_type为github时必需
        :type github_repo: str
        :param github_branch: GitHub分支名，指定要构建的分支
        :type github_branch: str
        :param github_commit: GitHub commit哈希值（支持短hash），如果指定commit则忽略branch参数
        :type github_commit: str
        :param github_path: 仓库内的子目录路径，如果算法源码不在根目录
        :type github_path: str
        :param context_dir: Docker构建上下文路径，相对于源码根目录
        :type context_dir: str
        :param dockerfile_path: Dockerfile路径，相对于源码根目录
        :type dockerfile_path: str
        :param target: Dockerfile构建目标（multi-stage build时使用）
        :type target: str
        :param force_rebuild: 是否强制重新构建镜像，忽略缓存
        :type force_rebuild: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_build_post_serialize(
            algorithm=algorithm,
            image=image,
            tag=tag,
            command=command,
            source_type=source_type,
            file=file,
            github_token=github_token,
            github_repo=github_repo,
            github_branch=github_branch,
            github_commit=github_commit,
            github_path=github_path,
            context_dir=context_dir,
            dockerfile_path=dockerfile_path,
            target=target,
            force_rebuild=force_rebuild,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_algorithms_build_post_serialize(
        self,
        algorithm,
        image,
        tag,
        command,
        source_type,
        file,
        github_token,
        github_repo,
        github_branch,
        github_commit,
        github_path,
        context_dir,
        dockerfile_path,
        target,
        force_rebuild,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if algorithm is not None:
            _form_params.append(('algorithm', algorithm))
        if image is not None:
            _form_params.append(('image', image))
        if tag is not None:
            _form_params.append(('tag', tag))
        if command is not None:
            _form_params.append(('command', command))
        if source_type is not None:
            _form_params.append(('source_type', source_type))
        if file is not None:
            _files['file'] = file
        if github_token is not None:
            _form_params.append(('github_token', github_token))
        if github_repo is not None:
            _form_params.append(('github_repo', github_repo))
        if github_branch is not None:
            _form_params.append(('github_branch', github_branch))
        if github_commit is not None:
            _form_params.append(('github_commit', github_commit))
        if github_path is not None:
            _form_params.append(('github_path', github_path))
        if context_dir is not None:
            _form_params.append(('context_dir', context_dir))
        if dockerfile_path is not None:
            _form_params.append(('dockerfile_path', dockerfile_path))
        if target is not None:
            _form_params.append(('target', target))
        if force_rebuild is not None:
            _form_params.append(('force_rebuild', force_rebuild))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/algorithms/build',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_algorithms_get(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoListAlgorithmsResp:
        """获取算法列表

        获取系统中所有可用的算法列表，包括算法的镜像信息、标签和更新时间。只返回状态为激活的算法容器

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListAlgorithmsResp",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_algorithms_get_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoListAlgorithmsResp]:
        """获取算法列表

        获取系统中所有可用的算法列表，包括算法的镜像信息、标签和更新时间。只返回状态为激活的算法容器

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListAlgorithmsResp",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_algorithms_get_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """获取算法列表

        获取系统中所有可用的算法列表，包括算法的镜像信息、标签和更新时间。只返回状态为激活的算法容器

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListAlgorithmsResp",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_algorithms_get_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/algorithms',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_algorithms_post(
        self,
        body: Annotated[List[DtoExecutionPayload], Field(description="算法执行请求列表，包含算法名称、数据集和环境变量")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoSubmitResp:
        """提交算法执行任务

        批量提交算法执行任务，支持多个算法和数据集的组合执行。系统将为每个执行任务分配唯一的 TraceID 用于跟踪任务状态和结果

        :param body: 算法执行请求列表，包含算法名称、数据集和环境变量 (required)
        :type body: List[DtoExecutionPayload]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_post_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_algorithms_post_with_http_info(
        self,
        body: Annotated[List[DtoExecutionPayload], Field(description="算法执行请求列表，包含算法名称、数据集和环境变量")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoSubmitResp]:
        """提交算法执行任务

        批量提交算法执行任务，支持多个算法和数据集的组合执行。系统将为每个执行任务分配唯一的 TraceID 用于跟踪任务状态和结果

        :param body: 算法执行请求列表，包含算法名称、数据集和环境变量 (required)
        :type body: List[DtoExecutionPayload]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_post_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_algorithms_post_without_preload_content(
        self,
        body: Annotated[List[DtoExecutionPayload], Field(description="算法执行请求列表，包含算法名称、数据集和环境变量")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """提交算法执行任务

        批量提交算法执行任务，支持多个算法和数据集的组合执行。系统将为每个执行任务分配唯一的 TraceID 用于跟踪任务状态和结果

        :param body: 算法执行请求列表，包含算法名称、数据集和环境变量 (required)
        :type body: List[DtoExecutionPayload]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_algorithms_post_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_algorithms_post_serialize(
        self,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/algorithms',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


