from typing import Literal

from pydantic.dataclasses import dataclass


@dataclass
class AnthropicKeys:
    """A class to hold constants for the keys used in Anthropic message create method."""

    model: Literal["model"] = "model"
    messages: Literal["messages"] = "messages"
    system: Literal["system"] = "system"
    tools: Literal["tools"] = "tools"
    name: Literal["name"] = "name"
    web_search: Literal["web_search"] = "web_search"
    web_search_20250305: Literal["web_search_20250305"] = "web_search_20250305"
    type: Literal["type"] = "type"
    text: Literal["text"] = "text"
    thinking: Literal["thinking"] = "thinking"
    enabled: Literal["enabled"] = "enabled"
    image: Literal["image"] = "image"
    document: Literal["document"] = "document"
    source: Literal["source"] = "source"
    media_type: Literal["media_type"] = "media_type"
    data: Literal["data"] = "data"
    base64: Literal["base64"] = "base64"
    jpeg: Literal["jpeg"] = "jpeg"
    png: Literal["png"] = "png"
