# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EntityPoliciesArgs', 'EntityPolicies']

@pulumi.input_type
class EntityPoliciesArgs:
    def __init__(__self__, *,
                 entity_id: pulumi.Input[str],
                 policies: pulumi.Input[Sequence[pulumi.Input[str]]],
                 exclusive: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a EntityPolicies resource.
        :param pulumi.Input[str] entity_id: Entity ID to assign policies to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: List of policies to assign to the entity
        :param pulumi.Input[bool] exclusive: Defaults to `true`.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "policies", policies)
        if exclusive is not None:
            pulumi.set(__self__, "exclusive", exclusive)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Input[str]:
        """
        Entity ID to assign policies to.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of policies to assign to the entity
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def exclusive(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "exclusive")

    @exclusive.setter
    def exclusive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclusive", value)


@pulumi.input_type
class _EntityPoliciesState:
    def __init__(__self__, *,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 entity_name: Optional[pulumi.Input[str]] = None,
                 exclusive: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering EntityPolicies resources.
        :param pulumi.Input[str] entity_id: Entity ID to assign policies to.
        :param pulumi.Input[str] entity_name: The name of the entity that are assigned the policies.
        :param pulumi.Input[bool] exclusive: Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: List of policies to assign to the entity
        """
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if entity_name is not None:
            pulumi.set(__self__, "entity_name", entity_name)
        if exclusive is not None:
            pulumi.set(__self__, "exclusive", exclusive)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Entity ID to assign policies to.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the entity that are assigned the policies.
        """
        return pulumi.get(self, "entity_name")

    @entity_name.setter
    def entity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_name", value)

    @property
    @pulumi.getter
    def exclusive(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "exclusive")

    @exclusive.setter
    def exclusive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclusive", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policies to assign to the entity
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)


class EntityPolicies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 exclusive: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages policies for an Identity Entity for Vault. The [Identity secrets engine](https://www.vaultproject.io/docs/secrets/identity/index.html) is the identity management solution for Vault.

        ## Example Usage
        ### Exclusive Policies

        ```python
        import pulumi
        import pulumi_vault as vault

        entity = vault.identity.Entity("entity", external_policies=True)
        policies = vault.identity.EntityPolicies("policies",
            policies=[
                "default",
                "test",
            ],
            exclusive=True,
            entity_id=entity.id)
        ```
        ### Non-exclusive Policies

        ```python
        import pulumi
        import pulumi_vault as vault

        entity = vault.identity.Entity("entity", external_policies=True)
        default = vault.identity.EntityPolicies("default",
            policies=[
                "default",
                "test",
            ],
            exclusive=False,
            entity_id=entity.id)
        others = vault.identity.EntityPolicies("others",
            policies=["others"],
            exclusive=False,
            entity_id=entity.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] entity_id: Entity ID to assign policies to.
        :param pulumi.Input[bool] exclusive: Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: List of policies to assign to the entity
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntityPoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages policies for an Identity Entity for Vault. The [Identity secrets engine](https://www.vaultproject.io/docs/secrets/identity/index.html) is the identity management solution for Vault.

        ## Example Usage
        ### Exclusive Policies

        ```python
        import pulumi
        import pulumi_vault as vault

        entity = vault.identity.Entity("entity", external_policies=True)
        policies = vault.identity.EntityPolicies("policies",
            policies=[
                "default",
                "test",
            ],
            exclusive=True,
            entity_id=entity.id)
        ```
        ### Non-exclusive Policies

        ```python
        import pulumi
        import pulumi_vault as vault

        entity = vault.identity.Entity("entity", external_policies=True)
        default = vault.identity.EntityPolicies("default",
            policies=[
                "default",
                "test",
            ],
            exclusive=False,
            entity_id=entity.id)
        others = vault.identity.EntityPolicies("others",
            policies=["others"],
            exclusive=False,
            entity_id=entity.id)
        ```

        :param str resource_name: The name of the resource.
        :param EntityPoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntityPoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 exclusive: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntityPoliciesArgs.__new__(EntityPoliciesArgs)

            if entity_id is None and not opts.urn:
                raise TypeError("Missing required property 'entity_id'")
            __props__.__dict__["entity_id"] = entity_id
            __props__.__dict__["exclusive"] = exclusive
            if policies is None and not opts.urn:
                raise TypeError("Missing required property 'policies'")
            __props__.__dict__["policies"] = policies
            __props__.__dict__["entity_name"] = None
        super(EntityPolicies, __self__).__init__(
            'vault:identity/entityPolicies:EntityPolicies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entity_id: Optional[pulumi.Input[str]] = None,
            entity_name: Optional[pulumi.Input[str]] = None,
            exclusive: Optional[pulumi.Input[bool]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'EntityPolicies':
        """
        Get an existing EntityPolicies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] entity_id: Entity ID to assign policies to.
        :param pulumi.Input[str] entity_name: The name of the entity that are assigned the policies.
        :param pulumi.Input[bool] exclusive: Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: List of policies to assign to the entity
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntityPoliciesState.__new__(_EntityPoliciesState)

        __props__.__dict__["entity_id"] = entity_id
        __props__.__dict__["entity_name"] = entity_name
        __props__.__dict__["exclusive"] = exclusive
        __props__.__dict__["policies"] = policies
        return EntityPolicies(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Output[str]:
        """
        Entity ID to assign policies to.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> pulumi.Output[str]:
        """
        The name of the entity that are assigned the policies.
        """
        return pulumi.get(self, "entity_name")

    @property
    @pulumi.getter
    def exclusive(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "exclusive")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence[str]]:
        """
        List of policies to assign to the entity
        """
        return pulumi.get(self, "policies")

