"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-apigateway-sagemakerendpoint-default');
stack.templateOptions.description = 'Integration Test for aws-apigateway-sagemakerendpoint';
// Definitions
const requestTemplate = `{
    "instances": [
#set( $user_id = $input.params("user_id") )
#set( $items = $input.params("items") )
#foreach( $item in $items.split(",") )
    {"in0": [$user_id], "in1": [$item]}#if( $foreach.hasNext ),#end
    $esc.newline
#end
    ]
}`;
const props = {
    endpointName: 'my-endpoint',
    resourcePath: '{user_id}',
    requestMappingTemplate: requestTemplate
};
new lib_1.ApiGatewayToSageMakerEndpoint(stack, 'test-apigateway-sagemakerendpoint-default', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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