# Generated by Django 3.2.16 on 2023-02-21 08:02

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('task_processor', '0005_update_conditional_index_conditions'),
    ]

    operations = [
        migrations.CreateModel(
            name='RecurringTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('task_identifier', models.CharField(max_length=200)),
                ('serialized_args', models.TextField(blank=True, null=True)),
                ('serialized_kwargs', models.TextField(blank=True, null=True)),
                ('run_every', models.DurationField()),
            ],
        ),
        migrations.CreateModel(
            name='RecurringTaskRun',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('started_at', models.DateTimeField()),
                ('finished_at', models.DateTimeField(blank=True, null=True)),
                ('result', models.CharField(blank=True, choices=[('SUCCESS', 'Success'), ('FAILURE', 'Failure')], db_index=True, max_length=50, null=True)),
                ('error_details', models.TextField(blank=True, null=True)),
                ('task', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='task_runs', to='task_processor.recurringtask')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddConstraint(
            model_name='recurringtask',
            constraint=models.UniqueConstraint(fields=('task_identifier', 'run_every'), name='unique_run_every_tasks'),
        ),
    ]
