# Korg nanoKONTROL Studio™ config tool

While there exists MIDI protocol specification for other Korg nano* products
like nanoKONTROL™ or nanoKONTROL2™, we have nothing for the more modern
nanoKONTROL Studio™ (and thus no tools like [Nano-Basket](https://github.com/royvegard/Nano-Basket)
for the nanoKONTROL Studio™

This project provides a CLI tool for reading and writing configuration from and
to YAML based config files plus a basis for future nanoKONTROL Studio™ based
projects which need to talk to the device using the proprietary MIDI based
protocol.


## Install and use


```
uv run nanokontrol-config e[xport] [-o|--output two-feedback.yaml]
```
```
uv run nanokontrol-config s[et] [-i|--input two.yaml]
```

## Disclaimer

I'm not affiliated in any way with Korg and this project is solely based on
reverse engineering MIDI I/O.

Of course using this tool is fully your own risk - I hereby refuse any
responsibility for any damages.


## License

See [License.md].


## Contribution

```
uv version --bump minor
uv build
```

## Future

* Graphical UI
* Support for importing/exporting the Korg proprietary configuration file format
* Support for other Korg nano* products
* Support for other MIDI controllers
* Availability for MicroPython (i.e. no dependency to `pydandtic` or `mido`)


## External sources

* [Nano-Basket: config tool for nanoKONTROL](https://github.com/royvegard/Nano-Basket)

* [nanoKONTROL2 MIDI Implementation (v1.00 / 2010.12.14)](
https://cdn.korg.com/us/support/download/files/aeb2862daf0cb7db826d8c62f51ec28d.txt?response-content-disposition=attachment%3Bfilename%2A%3DUTF-8%27%27nanoKONTROL2_MIDIimp.txt)

* [uv: Building and publishing a package](https://docs.astral.sh/uv/guides/package/#preparing-your-project-for-packaging
)
