# Mage OSS

### Build modern data pipelines locally — fast, visual, and production-ready.

<br />

Mage OSS is a self-hosted development environment designed to help teams create production-grade data pipelines with confidence.

Ideal for automating ETL tasks, architecting data flow, or orchestrating transformations — all in a fast, notebook-style interface powered by modular code.

When it’s time to scale, [Mage Pro](https://mage.ai) — our core platform — unlocks enterprise orchestration, collaboration, and AI-powered workflows.

<br />

[![GitHub Stars](https://img.shields.io/github/stars/mage-ai/mage-ai?style=for-the-badge&labelColor=000000&color=1C1C1C)](https://github.com/mage-ai/mage-ai/stargazers)
[![Docker Pulls](https://img.shields.io/docker/pulls/mageai/mageai?style=for-the-badge&labelColor=000000&color=1C1C1C)](https://hub.docker.com/r/mageai/mageai)
[![Slack Community](https://img.shields.io/badge/Join%20the%20community-black.svg?style=for-the-badge&logo=lightning&labelColor=000000&color=1C1C1C)](https://www.mage.ai/chat)
[![License](https://img.shields.io/github/license/mage-ai/mage-ai?style=for-the-badge&labelColor=000000&color=1C1C1C)](https://github.com/mage-ai/mage-ai/blob/master/LICENSE)

<br />

## What you can do with Mage OSS

- Build pipelines locally with Python, SQL, or R in a modular notebook-style UI

- Run jobs manually or on a schedule (cron supported)

- Connect to databases, APIs, and cloud storage with prebuilt connectors

- Debug visually with logs, live previews, and step-by-step execution

- Set up quickly with Docker, pip, or conda — no cloud account required

- Your go-to workspace for local pipeline development — fully in your control.
  
<img width="100%" alt="mage" src="https://github.com/user-attachments/assets/75992872-20a6-4120-8bf0-9c22a3d66450" />


<br /><br />

## Start local. Scale when you're ready.

Use Mage OSS to build and run pipelines on your machine. When you're ready for advanced tooling, performance, and AI-assisted productivity, Mage Pro is just one click away.

[**Try Mage Pro free →**](https://mage.ai)

<br />

### Quickstart

Install using Docker (recommended):

```bash
docker pull mageai/mageai:latest
```

Or with pip:

```bash
pip install mage-ai
```

Or with conda:

```bash
conda install -c conda-forge mage-ai
```

Full setup guide and docs: [docs.mage.ai](https://docs.mage.ai)

<br />

## Core Features

| Feature | Description |
| :- | :- |
| Modular pipelines | Build pipelines block-by-block using Python, SQL, or R |
| Notebook UI | Interactive editor for writing and documenting logic |
| Data integrations | Prebuilt connectors to databases, APIs, and cloud storage |
| Scheduling | Trigger pipelines manually or on a schedule |
| Visual debugging | Step-by-step logs, data previews, and error handling |
| dbt support | Build and run dbt models directly inside Mage |

<br />

## Example Use Cases

- Move data from Google Sheets to Snowflake with a Python transform
- Schedule a daily SQL pipeline to clean and aggregate product data
- Develop dbt models in a visual notebook-style interface
- Run simple ETL/ELT jobs locally with full transparency

<br />

## Documentation

Looking for how-to guides, examples, or advanced configuration?

Explore our full documentation at [docs.mage.ai](https://docs.mage.ai).


<br />

## Contributing

We welcome contributions of all kinds — bug fixes, docs, new features, or community examples.

Start with our [contributing guide](https://docs.mage.ai/contributing/overview), check out open issues, or suggest improvements.

<br />

## Ready to scale? Mage Pro has you covered.

Mage Pro is a powered-up platform built for teams.
It adds everything you need for production pipelines, at scale.

- Magical AI-assisted development and debugging
- Multi-environment orchestration
- Role-based access control
- Real-time monitoring & alerts
- Powerful CI/CD & version control
- Powerful enterprise features
- Available fully managed, hybrid, or on-premises

[**Try Mage Pro free →**](https://mage.ai)
