"""Create Tag and TagAssociation tables

Revision ID: 386bcfebd48d
Revises: 66928ca5b0d7
Create Date: 2023-08-08 08:35:27.099117

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '386bcfebd48d'
down_revision = '66928ca5b0d7'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tag',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('tag', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_tag_name'), ['name'], unique=True)

    op.create_table('tag_association',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('tag_id', sa.Integer(), nullable=True),
    sa.Column('taggable_id', sa.Integer(), nullable=True),
    sa.Column('taggable_type', sa.String(length=255), nullable=True),
    sa.ForeignKeyConstraint(['tag_id'], ['tag.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('tag_id', 'taggable_id', 'taggable_type', name='tag_id_taggable_id_taggable_type_uc')
    )
    with op.batch_alter_table('tag_association', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_tag_association_taggable_id'), ['taggable_id', 'taggable_type'], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('tag_association', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_tag_association_taggable_id'))

    op.drop_table('tag_association')
    with op.batch_alter_table('tag', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_tag_name'))

    op.drop_table('tag')
    # ### end Alembic commands ###
