"""Create GenericJob

Revision ID: 39d36f1dab73
Revises: 0227396a216c
Create Date: 2025-08-27 20:45:29.756869

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '39d36f1dab73'
down_revision = '0227396a216c'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('generic_job',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('job_type', sa.Enum('CANCEL_PIPELINE_RUN', name='jobtype'), nullable=False),
    sa.Column('status', sa.Enum('INITIAL', 'QUEUED', 'RUNNING', 'COMPLETED', 'FAILED', name='jobstatus'), nullable=True),
    sa.Column('payload', sa.JSON(), nullable=True),
    sa.Column('extra_metadata', sa.JSON(), nullable=True),
    sa.Column('started_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('completed_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('repo_path', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('generic_job', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_generic_job_job_type'), ['job_type'], unique=False)
        batch_op.create_index(batch_op.f('ix_generic_job_status'), ['status'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('generic_job', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_generic_job_status'))
        batch_op.drop_index(batch_op.f('ix_generic_job_job_type'))

    op.drop_table('generic_job')
    # ### end Alembic commands ###
