"""Add unique indexes on authentication tables

Revision ID: 643b6e65e814
Revises: 97ff9f55a3c0
Create Date: 2023-01-31 22:04:43.403008

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '643b6e65e814'
down_revision = '97ff9f55a3c0'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('oauth2_access_token', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_oauth2_access_token_token'), ['token'], unique=True)

    with op.batch_alter_table('oauth2_application', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_oauth2_application_client_id'), ['client_id'], unique=True)

    with op.batch_alter_table('user', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_user_email'), ['email'], unique=True)
        batch_op.create_index(batch_op.f('ix_user_username'), ['username'], unique=True)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('user', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_user_username'))
        batch_op.drop_index(batch_op.f('ix_user_email'))

    with op.batch_alter_table('oauth2_application', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_oauth2_application_client_id'))

    with op.batch_alter_table('oauth2_access_token', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_oauth2_access_token_token'))

    # ### end Alembic commands ###
