"""Add key uuid to secrets

Revision ID: e3593cc2191e
Revises: 90d978a8aef8
Create Date: 2023-07-14 15:53:06.580076

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'e3593cc2191e'
down_revision = '90d978a8aef8'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('secret', schema=None) as batch_op:
        batch_op.drop_constraint('name_unique', type_='unique')
        batch_op.add_column(sa.Column('key_uuid', sa.String(length=255), nullable=True))
        batch_op.create_unique_constraint('name_key_uuid_uc', ['name', 'key_uuid'])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('secret', schema=None) as batch_op:
        batch_op.drop_constraint('name_key_uuid_uc', type_='unique')
        batch_op.drop_column('key_uuid')
        batch_op.create_unique_constraint('name_unique', columns=['name'])

    # ### end Alembic commands ###
