# mypy-boto3-apigateway

[![PyPI - mypy-boto3-apigateway](https://img.shields.io/pypi/v/mypy-boto3-apigateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigateway)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-apigateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigateway)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.APIGateway 1.15.2](https://boto3.amazonaws.com/v1/documentation/api/1.15.2/reference/services/apigateway.html#APIGateway) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-apigateway](#mypy-boto3-apigateway)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `APIGateway` service.

```bash
python -m pip install boto3-stubs[apigateway]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[apigateway]` in your environment: `python -m pip install 'boto3-stubs[apigateway]'`

Both type checking and auto-complete should work for `APIGateway` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[apigateway]` in your environment: `python -m pip install 'boto3-stubs[apigateway]'`

Both type checking and auto-complete should work for `APIGateway` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[apigateway]` in your environment: `python -m pip install 'boto3-stubs[apigateway]'`
- Run `mypy` as usual

Type checking should work for `APIGateway` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[apigateway]` in your environment: `python -m pip install 'boto3-stubs[apigateway]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `APIGateway` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`APIGatewayClient` provides annotations for `boto3.client("apigateway")`.

```python
import boto3

from mypy_boto3_apigateway import APIGatewayClient

client: APIGatewayClient = boto3.client("apigateway")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: APIGatewayClient = session.client("apigateway")
```

### Paginators annotations

`mypy_boto3_apigateway.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_apigateway import APIGatewayClient
from mypy_boto3_apigateway.paginator import (
    GetApiKeysPaginator,
    GetAuthorizersPaginator,
    GetBasePathMappingsPaginator,
    GetClientCertificatesPaginator,
    GetDeploymentsPaginator,
    GetDocumentationPartsPaginator,
    GetDocumentationVersionsPaginator,
    GetDomainNamesPaginator,
    GetGatewayResponsesPaginator,
    GetModelsPaginator,
    GetRequestValidatorsPaginator,
    GetResourcesPaginator,
    GetRestApisPaginator,
    GetSdkTypesPaginator,
    GetUsagePaginator,
    GetUsagePlanKeysPaginator,
    GetUsagePlansPaginator,
    GetVpcLinksPaginator,
)

client: APIGatewayClient = boto3.client("apigateway")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_api_keys_paginator: GetApiKeysPaginator = client.get_paginator("get_api_keys")
get_authorizers_paginator: GetAuthorizersPaginator = client.get_paginator("get_authorizers")
get_base_path_mappings_paginator: GetBasePathMappingsPaginator = client.get_paginator("get_base_path_mappings")
get_client_certificates_paginator: GetClientCertificatesPaginator = client.get_paginator("get_client_certificates")
get_deployments_paginator: GetDeploymentsPaginator = client.get_paginator("get_deployments")
get_documentation_parts_paginator: GetDocumentationPartsPaginator = client.get_paginator("get_documentation_parts")
get_documentation_versions_paginator: GetDocumentationVersionsPaginator = client.get_paginator("get_documentation_versions")
get_domain_names_paginator: GetDomainNamesPaginator = client.get_paginator("get_domain_names")
get_gateway_responses_paginator: GetGatewayResponsesPaginator = client.get_paginator("get_gateway_responses")
get_models_paginator: GetModelsPaginator = client.get_paginator("get_models")
get_request_validators_paginator: GetRequestValidatorsPaginator = client.get_paginator("get_request_validators")
get_resources_paginator: GetResourcesPaginator = client.get_paginator("get_resources")
get_rest_apis_paginator: GetRestApisPaginator = client.get_paginator("get_rest_apis")
get_sdk_types_paginator: GetSdkTypesPaginator = client.get_paginator("get_sdk_types")
get_usage_paginator: GetUsagePaginator = client.get_paginator("get_usage")
get_usage_plan_keys_paginator: GetUsagePlanKeysPaginator = client.get_paginator("get_usage_plan_keys")
get_usage_plans_paginator: GetUsagePlansPaginator = client.get_paginator("get_usage_plans")
get_vpc_links_paginator: GetVpcLinksPaginator = client.get_paginator("get_vpc_links")
```







### Typed dictionations

`mypy_boto3_apigateway.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_apigateway.type_defs import (
    AccessLogSettingsTypeDef,
    AccountTypeDef,
    ApiKeyIdsTypeDef,
    ApiKeysTypeDef,
    ApiKeyTypeDef,
    ApiStageTypeDef,
    AuthorizersTypeDef,
    AuthorizerTypeDef,
    BasePathMappingsTypeDef,
    BasePathMappingTypeDef,
    CanarySettingsTypeDef,
    ClientCertificatesTypeDef,
    ClientCertificateTypeDef,
    DeploymentCanarySettingsTypeDef,
    DeploymentsTypeDef,
    DeploymentTypeDef,
    DocumentationPartIdsTypeDef,
    DocumentationPartLocationTypeDef,
    DocumentationPartsTypeDef,
    DocumentationPartTypeDef,
    DocumentationVersionsTypeDef,
    DocumentationVersionTypeDef,
    DomainNamesTypeDef,
    DomainNameTypeDef,
    EndpointConfigurationTypeDef,
    ExportResponseTypeDef,
    GatewayResponsesTypeDef,
    GatewayResponseTypeDef,
    IntegrationResponseTypeDef,
    IntegrationTypeDef,
    MethodResponseTypeDef,
    MethodSettingTypeDef,
    MethodSnapshotTypeDef,
    MethodTypeDef,
    ModelsTypeDef,
    ModelTypeDef,
    MutualTlsAuthenticationInputTypeDef,
    MutualTlsAuthenticationTypeDef,
    PaginatorConfigTypeDef,
    PatchOperationTypeDef,
    QuotaSettingsTypeDef,
    RequestValidatorsTypeDef,
    RequestValidatorTypeDef,
    ResourcesTypeDef,
    ResourceTypeDef,
    RestApisTypeDef,
    RestApiTypeDef,
    SdkConfigurationPropertyTypeDef,
    SdkResponseTypeDef,
    SdkTypesTypeDef,
    SdkTypeTypeDef,
    StageKeyTypeDef,
    StagesTypeDef,
    StageTypeDef,
    TagsTypeDef,
    TemplateTypeDef,
    TestInvokeAuthorizerResponseTypeDef,
    TestInvokeMethodResponseTypeDef,
    ThrottleSettingsTypeDef,
    TlsConfigTypeDef,
    UsagePlanKeysTypeDef,
    UsagePlanKeyTypeDef,
    UsagePlansTypeDef,
    UsagePlanTypeDef,
    UsageTypeDef,
    VpcLinksTypeDef,
    VpcLinkTypeDef,
)

def get_structure() -> AccessLogSettingsTypeDef:
    return {
      ...
    }
```
