# This file was auto-generated by Fern from our API Definition.

import os
import typing

import httpx
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .embed.client import AsyncEmbedClient, EmbedClient
from .environment import TwelveLabsEnvironment
from .indexes.client import AsyncIndexesClient, IndexesClient
from .raw_base_client import AsyncRawBaseClient, RawBaseClient
from .search.client import AsyncSearchClient, SearchClient
from .tasks.client import AsyncTasksClient, TasksClient
from .types.generate_response import GenerateResponse
from .types.gist import Gist
from .types.gist_request_types_item import GistRequestTypesItem
from .types.non_stream_analyze_response import NonStreamAnalyzeResponse
from .types.stream_analyze_response import StreamAnalyzeResponse
from .types.summarize_response import SummarizeResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BaseClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : TwelveLabsEnvironment
        The environment to use for requests from the client. from .environment import TwelveLabsEnvironment

        Defaults to TwelveLabsEnvironment.DEFAULT



    api_key : typing.Optional[str]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from twelvelabs import TwelveLabs
    client = TwelveLabs(api_key="YOUR_API_KEY", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: TwelveLabsEnvironment = TwelveLabsEnvironment.DEFAULT,
        api_key: typing.Optional[str] = os.getenv("TWELVE_LABS_API_KEY"),
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting TWELVE_LABS_API_KEY"
            )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawBaseClient(client_wrapper=self._client_wrapper)
        self.tasks = TasksClient(client_wrapper=self._client_wrapper)
        self.indexes = IndexesClient(client_wrapper=self._client_wrapper)
        self.embed = EmbedClient(client_wrapper=self._client_wrapper)
        self.search = SearchClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> RawBaseClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBaseClient
        """
        return self._raw_client

    def summarize(
        self,
        *,
        video_id: str,
        type: str,
        prompt: typing.Optional[str] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SummarizeResponse:
        """
        This endpoint analyzes videos and generates summaries, chapters, or highlights. Optionally, you can provide a prompt to customize the output.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to summarize.

        type : str
            Specifies the type of summary. Use one of the following values:
              - `summary`: A brief that encapsulates the key points of a video, presenting the most important information clearly and concisely.
              - `chapter`: A chronological list of all the chapters in a video, providing a granular breakdown of its content. For each chapter, the platform returns its starting and end times, measured in seconds from the beginning of the video clip, a descriptive headline that offers a brief of the events or activities within that part of the video, and an accompanying summary that elaborates on the headline.
              - `highlight`: A chronologically ordered list of the most important events within a video. Unlike chapters, highlights only capture the key moments, providing a snapshot of the video's main topics. For each highlight, the platform returns its starting and end times, measured in seconds from the beginning of the video, a title, and a brief description that captures the essence of this part of the video.

        prompt : typing.Optional[str]
            Use this field to provide context for the summarization task, such as the target audience, style, tone of voice, and purpose.

            <Note title="Notes">
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Example**: Generate a summary of this video for a social media post, up to two sentences.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SummarizeResponse
            The specified video has successfully been summarized.

        Examples
        --------
        from twelvelabs import TwelveLabs
        client = TwelveLabs(api_key="YOUR_API_KEY", )
        client.summarize(video_id='6298d673f1090f1100476d4c', type='summary', prompt='Generate a summary of this video for a social media post, up to two sentences.', temperature=0.2, )
        """
        _response = self._raw_client.summarize(
            video_id=video_id, type=type, prompt=prompt, temperature=temperature, request_options=request_options
        )
        return _response.data

    def gist(
        self,
        *,
        video_id: str,
        types: typing.Sequence[GistRequestTypesItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Gist:
        """
        This endpoint analyzes videos and generates titles, topics, and hashtags.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to generate a gist for.

        types : typing.Sequence[GistRequestTypesItem]
            Specifies the type of gist. Use one of the following values:
              - `title`: A title succinctly captures a video's main theme, such as "From Consumerism to Minimalism: A Journey Toward Sustainable Living," guiding viewers to its content and themes.
              - `topic`: A topic is the central theme of a video, such as "Shopping Vlog Lifestyle", summarizing its content for efficient categorization and reference.
              - `hashtag`: A hashtag, like "#BlackFriday", represents key themes in a video, enhancing its discoverability and categorization on social media platforms.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Gist
            The gist of the specified video has successfully been generated.

        Examples
        --------
        from twelvelabs import TwelveLabs
        client = TwelveLabs(api_key="YOUR_API_KEY", )
        client.gist(video_id='6298d673f1090f1100476d4c', types=["title", "topic"], )
        """
        _response = self._raw_client.gist(video_id=video_id, types=types, request_options=request_options)
        return _response.data

    def generate(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateResponse:
        """
        <Warning>This endpoint will be deprecated on **July 30, 2025**. Transition to the [`/analyze`](/v1.3/api-reference/analyze-videos/analyze) endpoint, which provides identical functionality. Ensure you've updated your API calls before the deprecation date to ensure uninterrupted service.</Warning>

        This endpoint generates open-ended texts based on your videos, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        stream : typing.Optional[bool]
            Set this parameter to `true` to enable streaming responses in the <a href="https://github.com/ndjson/ndjson-spec" target="_blank">NDJSON</a> format.

            **Default:** `true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateResponse
            The specified video has successfully been processed.

        Examples
        --------
        from twelvelabs import TwelveLabs
        client = TwelveLabs(api_key="YOUR_API_KEY", )
        client.generate(video_id='6298d673f1090f1100476d4c', prompt='I want to generate a description for my video with the following format - Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.', temperature=0.2, stream=True, )
        """
        _response = self._raw_client.generate(
            video_id=video_id, prompt=prompt, temperature=temperature, stream=stream, request_options=request_options
        )
        return _response.data

    def analyze_stream(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[StreamAnalyzeResponse]:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[StreamAnalyzeResponse]


        Examples
        --------
        from twelvelabs import TwelveLabs
        client = TwelveLabs(api_key="YOUR_API_KEY", )
        response = client.analyze_stream(video_id='6298d673f1090f1100476d4c', prompt='I want to generate a description for my video with the following format - Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.', temperature=0.2, )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.analyze_stream(
            video_id=video_id, prompt=prompt, temperature=temperature, request_options=request_options
        ) as r:
            yield from r.data

    def analyze(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonStreamAnalyzeResponse:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonStreamAnalyzeResponse


        Examples
        --------
        from twelvelabs import TwelveLabs
        client = TwelveLabs(api_key="YOUR_API_KEY", )
        client.analyze(video_id='6298d673f1090f1100476d4c', prompt='I want to generate a description for my video with the following format - Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.', temperature=0.2, )
        """
        _response = self._raw_client.analyze(
            video_id=video_id, prompt=prompt, temperature=temperature, request_options=request_options
        )
        return _response.data


class AsyncBaseClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : TwelveLabsEnvironment
        The environment to use for requests from the client. from .environment import TwelveLabsEnvironment

        Defaults to TwelveLabsEnvironment.DEFAULT



    api_key : typing.Optional[str]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from twelvelabs import AsyncTwelveLabs
    client = AsyncTwelveLabs(api_key="YOUR_API_KEY", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: TwelveLabsEnvironment = TwelveLabsEnvironment.DEFAULT,
        api_key: typing.Optional[str] = os.getenv("TWELVE_LABS_API_KEY"),
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting TWELVE_LABS_API_KEY"
            )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawBaseClient(client_wrapper=self._client_wrapper)
        self.tasks = AsyncTasksClient(client_wrapper=self._client_wrapper)
        self.indexes = AsyncIndexesClient(client_wrapper=self._client_wrapper)
        self.embed = AsyncEmbedClient(client_wrapper=self._client_wrapper)
        self.search = AsyncSearchClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBaseClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBaseClient
        """
        return self._raw_client

    async def summarize(
        self,
        *,
        video_id: str,
        type: str,
        prompt: typing.Optional[str] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SummarizeResponse:
        """
        This endpoint analyzes videos and generates summaries, chapters, or highlights. Optionally, you can provide a prompt to customize the output.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to summarize.

        type : str
            Specifies the type of summary. Use one of the following values:
              - `summary`: A brief that encapsulates the key points of a video, presenting the most important information clearly and concisely.
              - `chapter`: A chronological list of all the chapters in a video, providing a granular breakdown of its content. For each chapter, the platform returns its starting and end times, measured in seconds from the beginning of the video clip, a descriptive headline that offers a brief of the events or activities within that part of the video, and an accompanying summary that elaborates on the headline.
              - `highlight`: A chronologically ordered list of the most important events within a video. Unlike chapters, highlights only capture the key moments, providing a snapshot of the video's main topics. For each highlight, the platform returns its starting and end times, measured in seconds from the beginning of the video, a title, and a brief description that captures the essence of this part of the video.

        prompt : typing.Optional[str]
            Use this field to provide context for the summarization task, such as the target audience, style, tone of voice, and purpose.

            <Note title="Notes">
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Example**: Generate a summary of this video for a social media post, up to two sentences.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SummarizeResponse
            The specified video has successfully been summarized.

        Examples
        --------
        from twelvelabs import AsyncTwelveLabs
        import asyncio
        client = AsyncTwelveLabs(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.summarize(video_id='6298d673f1090f1100476d4c', type='summary', prompt='Generate a summary of this video for a social media post, up to two sentences.', temperature=0.2, )
        asyncio.run(main())
        """
        _response = await self._raw_client.summarize(
            video_id=video_id, type=type, prompt=prompt, temperature=temperature, request_options=request_options
        )
        return _response.data

    async def gist(
        self,
        *,
        video_id: str,
        types: typing.Sequence[GistRequestTypesItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Gist:
        """
        This endpoint analyzes videos and generates titles, topics, and hashtags.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to generate a gist for.

        types : typing.Sequence[GistRequestTypesItem]
            Specifies the type of gist. Use one of the following values:
              - `title`: A title succinctly captures a video's main theme, such as "From Consumerism to Minimalism: A Journey Toward Sustainable Living," guiding viewers to its content and themes.
              - `topic`: A topic is the central theme of a video, such as "Shopping Vlog Lifestyle", summarizing its content for efficient categorization and reference.
              - `hashtag`: A hashtag, like "#BlackFriday", represents key themes in a video, enhancing its discoverability and categorization on social media platforms.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Gist
            The gist of the specified video has successfully been generated.

        Examples
        --------
        from twelvelabs import AsyncTwelveLabs
        import asyncio
        client = AsyncTwelveLabs(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.gist(video_id='6298d673f1090f1100476d4c', types=["title", "topic"], )
        asyncio.run(main())
        """
        _response = await self._raw_client.gist(video_id=video_id, types=types, request_options=request_options)
        return _response.data

    async def generate(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateResponse:
        """
        <Warning>This endpoint will be deprecated on **July 30, 2025**. Transition to the [`/analyze`](/v1.3/api-reference/analyze-videos/analyze) endpoint, which provides identical functionality. Ensure you've updated your API calls before the deprecation date to ensure uninterrupted service.</Warning>

        This endpoint generates open-ended texts based on your videos, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        stream : typing.Optional[bool]
            Set this parameter to `true` to enable streaming responses in the <a href="https://github.com/ndjson/ndjson-spec" target="_blank">NDJSON</a> format.

            **Default:** `true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateResponse
            The specified video has successfully been processed.

        Examples
        --------
        from twelvelabs import AsyncTwelveLabs
        import asyncio
        client = AsyncTwelveLabs(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.generate(video_id='6298d673f1090f1100476d4c', prompt='I want to generate a description for my video with the following format - Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.', temperature=0.2, stream=True, )
        asyncio.run(main())
        """
        _response = await self._raw_client.generate(
            video_id=video_id, prompt=prompt, temperature=temperature, stream=stream, request_options=request_options
        )
        return _response.data

    async def analyze_stream(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[StreamAnalyzeResponse]:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[StreamAnalyzeResponse]


        Examples
        --------
        from twelvelabs import AsyncTwelveLabs
        import asyncio
        client = AsyncTwelveLabs(api_key="YOUR_API_KEY", )
        async def main() -> None:
            response = await client.analyze_stream(video_id='6298d673f1090f1100476d4c', prompt='I want to generate a description for my video with the following format - Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.', temperature=0.2, )
            async for chunk in response:
                yield chunk
        asyncio.run(main())
        """
        async with self._raw_client.analyze_stream(
            video_id=video_id, prompt=prompt, temperature=temperature, request_options=request_options
        ) as r:
            async for data in r.data:
                yield data

    async def analyze(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonStreamAnalyzeResponse:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonStreamAnalyzeResponse


        Examples
        --------
        from twelvelabs import AsyncTwelveLabs
        import asyncio
        client = AsyncTwelveLabs(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.analyze(video_id='6298d673f1090f1100476d4c', prompt='I want to generate a description for my video with the following format - Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.', temperature=0.2, )
        asyncio.run(main())
        """
        _response = await self._raw_client.analyze(
            video_id=video_id, prompt=prompt, temperature=temperature, request_options=request_options
        )
        return _response.data


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: TwelveLabsEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
