# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ....core.serialization import FieldMetadata
from ....types.hls_object import HlsObject
from ....types.transcription_data import TranscriptionData
from .videos_retrieve_response_embedding import VideosRetrieveResponseEmbedding
from .videos_retrieve_response_system_metadata import VideosRetrieveResponseSystemMetadata


class VideosRetrieveResponse(UniversalBaseModel):
    id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="_id")] = pydantic.Field(default=None)
    """
    The unique identifier of the video.
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the video indexing task was created.
    """

    updated_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the corresponding video indexing task was last updated. The platform updates this field every time the corresponding video indexing task transitions to a different state.
    """

    indexed_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the video indexing task has been completed.
    """

    system_metadata: typing.Optional[VideosRetrieveResponseSystemMetadata] = pydantic.Field(default=None)
    """
    System-generated metadata about the video.
    """

    user_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    User-generated metadata about the video.
    """

    hls: typing.Optional[HlsObject] = None
    embedding: typing.Optional[VideosRetrieveResponseEmbedding] = pydantic.Field(default=None)
    """
    Contains the embedding and the associated information. The platform returns this field when the `embedding_option` parameter is specified in the request.
    """

    transcription: typing.Optional[TranscriptionData] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
