# This file was auto-generated by Fern from our API Definition.

import contextlib
import json
import typing
from json.decoder import JSONDecodeError

from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.http_response import AsyncHttpResponse, HttpResponse
from .core.pydantic_utilities import parse_obj_as
from .core.request_options import RequestOptions
from .errors.bad_request_error import BadRequestError
from .errors.too_many_requests_error import TooManyRequestsError
from .types.generate_response import GenerateResponse
from .types.gist import Gist
from .types.gist_request_types_item import GistRequestTypesItem
from .types.non_stream_analyze_response import NonStreamAnalyzeResponse
from .types.stream_analyze_response import StreamAnalyzeResponse
from .types.summarize_response import SummarizeResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawBaseClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def summarize(
        self,
        *,
        video_id: str,
        type: str,
        prompt: typing.Optional[str] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SummarizeResponse]:
        """
        This endpoint analyzes videos and generates summaries, chapters, or highlights. Optionally, you can provide a prompt to customize the output.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to summarize.

        type : str
            Specifies the type of summary. Use one of the following values:
              - `summary`: A brief that encapsulates the key points of a video, presenting the most important information clearly and concisely.
              - `chapter`: A chronological list of all the chapters in a video, providing a granular breakdown of its content. For each chapter, the platform returns its starting and end times, measured in seconds from the beginning of the video clip, a descriptive headline that offers a brief of the events or activities within that part of the video, and an accompanying summary that elaborates on the headline.
              - `highlight`: A chronologically ordered list of the most important events within a video. Unlike chapters, highlights only capture the key moments, providing a snapshot of the video's main topics. For each highlight, the platform returns its starting and end times, measured in seconds from the beginning of the video, a title, and a brief description that captures the essence of this part of the video.

        prompt : typing.Optional[str]
            Use this field to provide context for the summarization task, such as the target audience, style, tone of voice, and purpose.

            <Note title="Notes">
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Example**: Generate a summary of this video for a social media post, up to two sentences.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SummarizeResponse]
            The specified video has successfully been summarized.
        """
        _response = self._client_wrapper.httpx_client.request(
            "summarize",
            method="POST",
            json={
                "video_id": video_id,
                "type": type,
                "prompt": prompt,
                "temperature": temperature,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SummarizeResponse,
                    parse_obj_as(
                        type_=SummarizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def gist(
        self,
        *,
        video_id: str,
        types: typing.Sequence[GistRequestTypesItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Gist]:
        """
        This endpoint analyzes videos and generates titles, topics, and hashtags.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to generate a gist for.

        types : typing.Sequence[GistRequestTypesItem]
            Specifies the type of gist. Use one of the following values:
              - `title`: A title succinctly captures a video's main theme, such as "From Consumerism to Minimalism: A Journey Toward Sustainable Living," guiding viewers to its content and themes.
              - `topic`: A topic is the central theme of a video, such as "Shopping Vlog Lifestyle", summarizing its content for efficient categorization and reference.
              - `hashtag`: A hashtag, like "#BlackFriday", represents key themes in a video, enhancing its discoverability and categorization on social media platforms.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Gist]
            The gist of the specified video has successfully been generated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "gist",
            method="POST",
            json={
                "video_id": video_id,
                "types": types,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Gist,
                    parse_obj_as(
                        type_=Gist,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def generate(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GenerateResponse]:
        """
        <Warning>This endpoint will be deprecated on **July 30, 2025**. Transition to the [`/analyze`](/v1.3/api-reference/analyze-videos/analyze) endpoint, which provides identical functionality. Ensure you've updated your API calls before the deprecation date to ensure uninterrupted service.</Warning>

        This endpoint generates open-ended texts based on your videos, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        stream : typing.Optional[bool]
            Set this parameter to `true` to enable streaming responses in the <a href="https://github.com/ndjson/ndjson-spec" target="_blank">NDJSON</a> format.

            **Default:** `true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GenerateResponse]
            The specified video has successfully been processed.
        """
        _response = self._client_wrapper.httpx_client.request(
            "generate",
            method="POST",
            json={
                "video_id": video_id,
                "prompt": prompt,
                "temperature": temperature,
                "stream": stream,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GenerateResponse,
                    parse_obj_as(
                        type_=GenerateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def analyze_stream(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[HttpResponse[typing.Iterator[StreamAnalyzeResponse]]]:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[HttpResponse[typing.Iterator[StreamAnalyzeResponse]]]

        """
        with self._client_wrapper.httpx_client.stream(
            "analyze",
            method="POST",
            json={
                "video_id": video_id,
                "prompt": prompt,
                "temperature": temperature,
                "stream": True,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[StreamAnalyzeResponse]]:
                try:
                    if 200 <= _response.status_code < 300:

                        def _iter():
                            for _text in _response.iter_lines():
                                try:
                                    if len(_text) == 0:
                                        continue
                                    yield typing.cast(
                                        StreamAnalyzeResponse,
                                        parse_obj_as(
                                            type_=StreamAnalyzeResponse,  # type: ignore
                                            object_=json.loads(_text),
                                        ),
                                    )
                                except Exception:
                                    pass
                            return

                        return HttpResponse(response=_response, data=_iter())
                    _response.read()
                    if _response.status_code == 400:
                        raise BadRequestError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    if _response.status_code == 429:
                        raise TooManyRequestsError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()

    def analyze(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[NonStreamAnalyzeResponse]:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NonStreamAnalyzeResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            "analyze",
            method="POST",
            json={
                "video_id": video_id,
                "prompt": prompt,
                "temperature": temperature,
                "stream": False,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NonStreamAnalyzeResponse,
                    parse_obj_as(
                        type_=NonStreamAnalyzeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBaseClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def summarize(
        self,
        *,
        video_id: str,
        type: str,
        prompt: typing.Optional[str] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SummarizeResponse]:
        """
        This endpoint analyzes videos and generates summaries, chapters, or highlights. Optionally, you can provide a prompt to customize the output.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to summarize.

        type : str
            Specifies the type of summary. Use one of the following values:
              - `summary`: A brief that encapsulates the key points of a video, presenting the most important information clearly and concisely.
              - `chapter`: A chronological list of all the chapters in a video, providing a granular breakdown of its content. For each chapter, the platform returns its starting and end times, measured in seconds from the beginning of the video clip, a descriptive headline that offers a brief of the events or activities within that part of the video, and an accompanying summary that elaborates on the headline.
              - `highlight`: A chronologically ordered list of the most important events within a video. Unlike chapters, highlights only capture the key moments, providing a snapshot of the video's main topics. For each highlight, the platform returns its starting and end times, measured in seconds from the beginning of the video, a title, and a brief description that captures the essence of this part of the video.

        prompt : typing.Optional[str]
            Use this field to provide context for the summarization task, such as the target audience, style, tone of voice, and purpose.

            <Note title="Notes">
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Example**: Generate a summary of this video for a social media post, up to two sentences.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SummarizeResponse]
            The specified video has successfully been summarized.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "summarize",
            method="POST",
            json={
                "video_id": video_id,
                "type": type,
                "prompt": prompt,
                "temperature": temperature,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SummarizeResponse,
                    parse_obj_as(
                        type_=SummarizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def gist(
        self,
        *,
        video_id: str,
        types: typing.Sequence[GistRequestTypesItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Gist]:
        """
        This endpoint analyzes videos and generates titles, topics, and hashtags.

        <Note title="Note">
        This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video that you want to generate a gist for.

        types : typing.Sequence[GistRequestTypesItem]
            Specifies the type of gist. Use one of the following values:
              - `title`: A title succinctly captures a video's main theme, such as "From Consumerism to Minimalism: A Journey Toward Sustainable Living," guiding viewers to its content and themes.
              - `topic`: A topic is the central theme of a video, such as "Shopping Vlog Lifestyle", summarizing its content for efficient categorization and reference.
              - `hashtag`: A hashtag, like "#BlackFriday", represents key themes in a video, enhancing its discoverability and categorization on social media platforms.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Gist]
            The gist of the specified video has successfully been generated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "gist",
            method="POST",
            json={
                "video_id": video_id,
                "types": types,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Gist,
                    parse_obj_as(
                        type_=Gist,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def generate(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GenerateResponse]:
        """
        <Warning>This endpoint will be deprecated on **July 30, 2025**. Transition to the [`/analyze`](/v1.3/api-reference/analyze-videos/analyze) endpoint, which provides identical functionality. Ensure you've updated your API calls before the deprecation date to ensure uninterrupted service.</Warning>

        This endpoint generates open-ended texts based on your videos, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        stream : typing.Optional[bool]
            Set this parameter to `true` to enable streaming responses in the <a href="https://github.com/ndjson/ndjson-spec" target="_blank">NDJSON</a> format.

            **Default:** `true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GenerateResponse]
            The specified video has successfully been processed.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "generate",
            method="POST",
            json={
                "video_id": video_id,
                "prompt": prompt,
                "temperature": temperature,
                "stream": stream,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GenerateResponse,
                    parse_obj_as(
                        type_=GenerateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def analyze_stream(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[StreamAnalyzeResponse]]]:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[StreamAnalyzeResponse]]]

        """
        async with self._client_wrapper.httpx_client.stream(
            "analyze",
            method="POST",
            json={
                "video_id": video_id,
                "prompt": prompt,
                "temperature": temperature,
                "stream": True,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[StreamAnalyzeResponse]]:
                try:
                    if 200 <= _response.status_code < 300:

                        async def _iter():
                            async for _text in _response.aiter_lines():
                                try:
                                    if len(_text) == 0:
                                        continue
                                    yield typing.cast(
                                        StreamAnalyzeResponse,
                                        parse_obj_as(
                                            type_=StreamAnalyzeResponse,  # type: ignore
                                            object_=json.loads(_text),
                                        ),
                                    )
                                except Exception:
                                    pass
                            return

                        return AsyncHttpResponse(response=_response, data=_iter())
                    await _response.aread()
                    if _response.status_code == 400:
                        raise BadRequestError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    if _response.status_code == 429:
                        raise TooManyRequestsError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()

    async def analyze(
        self,
        *,
        video_id: str,
        prompt: str,
        temperature: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[NonStreamAnalyzeResponse]:
        """
        This endpoint analyzes your videos and creates fully customizable text based on your prompts, including but not limited to tables of content, action items, memos, and detailed analyses.

        <Note title="Notes">
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        - This endpoint supports streaming responses. For details on integrating this feature into your application, refer to the [Streaming response](/v1.3/docs/guides/generate-text-from-video/open-ended-text#streaming-responses) guide.
        </Note>

        Parameters
        ----------
        video_id : str
            The unique identifier of the video for which you wish to generate a text.

        prompt : str
            A prompt that guides the model on the desired format or content.

            <Note title="Notes">
            - Even though the model behind this endpoint is trained to a high degree of accuracy, the preciseness of the generated text may vary based on the nature and quality of the video and the clarity of the prompt.
            - Your prompts can be instructive or descriptive, or you can also phrase them as questions.
            - The maximum length of a prompt is 2,000 tokens.
            </Note>

            **Examples**:

            - Based on this video, I want to generate five keywords for SEO (Search Engine Optimization).
            - I want to generate a description for my video with the following format: Title of the video, followed by a summary in 2-3 sentences, highlighting the main topic, key events, and concluding remarks.

        temperature : typing.Optional[float]
            Controls the randomness of the text output generated by the model. A higher value generates more creative text, while a lower value produces more deterministic text output.

            **Default:** 0.2
            **Min:** 0
            **Max:** 1

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NonStreamAnalyzeResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "analyze",
            method="POST",
            json={
                "video_id": video_id,
                "prompt": prompt,
                "temperature": temperature,
                "stream": False,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NonStreamAnalyzeResponse,
                    parse_obj_as(
                        type_=NonStreamAnalyzeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
