# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .. import core
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..types.video_indexing_task import VideoIndexingTask
from .types.tasks_create_response import TasksCreateResponse
from .types.tasks_list_request_status_item import TasksListRequestStatusItem
from .types.tasks_list_response import TasksListResponse
from .types.tasks_retrieve_response import TasksRetrieveResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTasksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        index_id: typing.Optional[str] = None,
        status: typing.Optional[
            typing.Union[TasksListRequestStatusItem, typing.Sequence[TasksListRequestStatusItem]]
        ] = None,
        filename: typing.Optional[str] = None,
        duration: typing.Optional[float] = None,
        width: typing.Optional[int] = None,
        height: typing.Optional[int] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[VideoIndexingTask]:
        """
        This method returns a list of the video indexing tasks in your account. The API returns your video indexing tasks sorted by creation date, with the newest at the top of the list.

        Parameters
        ----------
        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        index_id : typing.Optional[str]
            Filter by the unique identifier of an index.

        status : typing.Optional[typing.Union[TasksListRequestStatusItem, typing.Sequence[TasksListRequestStatusItem]]]
            Filter by one or more video indexing task statuses. The following options are available:
            - `ready`: The video has been successfully uploaded and indexed.
            - `uploading`: The video is being uploaded.
            - `validating`: The video is being validated against the prerequisites.
            - `pending`: The video is pending.
            - `queued`: The video is queued.
            - `indexing`: The video is being indexed.
            - `failed`: The video indexing task failed.

            To filter by multiple statuses, specify the `status` parameter for each value:
            ```
            status=ready&status=validating
            ```

        filename : typing.Optional[str]
            Filter by filename.

        duration : typing.Optional[float]
            Filter by duration. Expressed in seconds.

        width : typing.Optional[int]
            Filter by width.

        height : typing.Optional[int]
            Filter by height.

        created_at : typing.Optional[str]
            Filter video indexing tasks by the creation date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            Filter video indexing tasks by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were updated on the specified date at or after the given time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[VideoIndexingTask]
            The video indexing tasks have successfully been retrieved.
        """
        page = page if page is not None else 1

        _response = self._client_wrapper.httpx_client.request(
            "tasks",
            method="GET",
            params={
                "page": page,
                "page_limit": page_limit,
                "sort_by": sort_by,
                "sort_option": sort_option,
                "index_id": index_id,
                "status": status,
                "filename": filename,
                "duration": duration,
                "width": width,
                "height": height,
                "created_at": created_at,
                "updated_at": updated_at,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TasksListResponse,
                    parse_obj_as(
                        type_=TasksListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True
                _get_next = lambda: self.list(
                    page=page + 1,
                    page_limit=page_limit,
                    sort_by=sort_by,
                    sort_option=sort_option,
                    index_id=index_id,
                    status=status,
                    filename=filename,
                    duration=duration,
                    width=width,
                    height=height,
                    created_at=created_at,
                    updated_at=updated_at,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        index_id: str,
        video_file: typing.Optional[core.File] = OMIT,
        video_url: typing.Optional[str] = OMIT,
        enable_video_stream: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TasksCreateResponse]:
        """
        This method creates a video indexing task that uploads and indexes a video.

        Upload options:
        - **Local file**: Use the `video_file` parameter.
        - **Publicly accessible URL**: Use the `video_url` parameter.

        <Accordion title="Video requirements">
          The videos you wish to upload must meet the following requirements:
          - **Video resolution**: Must be at least 360x360 and must not exceed 3840x2160.
          - **Aspect ratio**: Must be one of 1:1, 4:3, 4:5, 5:4, 16:9, 9:16, or 17:9.
          - **Video and audio formats**: Your video files must be encoded in the video and audio formats listed on the [FFmpeg Formats Documentation](https://ffmpeg.org/ffmpeg-formats.html) page. For videos in other formats, contact us at support@twelvelabs.io.
          - **Duration**: For Marengo, it must be between 4 seconds and 2 hours (7,200s). For Pegasus, it must be between 4 seconds and 60 minutes (3600s). In a future release, the maximum duration for Pegasus will be 2 hours (7,200 seconds).
          - **File size**: Must not exceed 2 GB.
            If you require different options, contact us at support@twelvelabs.io.

          If both Marengo and Pegasus are enabled for your index, the most restrictive prerequisites will apply.
        </Accordion>

        <Note title="Notes">
        - The platform supports video URLs that can play without additional user interaction or custom video players. Ensure your URL points to the raw video file, not a web page containing the video. Links to third-party hosting sites, cloud storage services, or videos requiring extra steps to play are not supported.
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video is being uploaded.

        video_file : typing.Optional[core.File]
            See core.File for more documentation

        video_url : typing.Optional[str]
            Specify this parameter to upload a video from a publicly accessible URL.

        enable_video_stream : typing.Optional[bool]
            This parameter indicates if the platform stores the video for streaming. When set to `true`, the platform stores the video, and you can retrieve its URL by calling the [`GET`](/v1.3/api-reference/videos/retrieve) method of the `/indexes/{index-id}/videos/{video-id}` endpoint. You can then use this URL to access the stream over the <a href="https://en.wikipedia.org/wiki/HTTP_Live_Streaming" target="_blank">HLS</a> protocol.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TasksCreateResponse]
            A video indexing task has successfully been created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "tasks",
            method="POST",
            data={
                "index_id": index_id,
                "video_url": video_url,
                "enable_video_stream": enable_video_stream,
            },
            files={
                **({"video_file": video_file} if video_file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksCreateResponse,
                    parse_obj_as(
                        type_=TasksCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[TasksRetrieveResponse]:
        """
        This method retrieves a video indexing task.

        Parameters
        ----------
        task_id : str
            The unique identifier of the video indexing task to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TasksRetrieveResponse]
            The specified video indexing task has successfully been retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"tasks/{jsonable_encoder(task_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksRetrieveResponse,
                    parse_obj_as(
                        type_=TasksRetrieveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        This action cannot be undone.
        Note the following about deleting a video indexing task:
        - You can only delete video indexing tasks for which the status is `ready` or `failed`.
        - If the status of your video indexing task is `ready`, you must first delete the video vector associated with your video indexing task by calling the [`DELETE`](/v1.3/api-reference/videos/delete) method of the `/indexes/videos` endpoint.

        Parameters
        ----------
        task_id : str
            The unique identifier of the video indexing task you want to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"tasks/{jsonable_encoder(task_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTasksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        index_id: typing.Optional[str] = None,
        status: typing.Optional[
            typing.Union[TasksListRequestStatusItem, typing.Sequence[TasksListRequestStatusItem]]
        ] = None,
        filename: typing.Optional[str] = None,
        duration: typing.Optional[float] = None,
        width: typing.Optional[int] = None,
        height: typing.Optional[int] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[VideoIndexingTask]:
        """
        This method returns a list of the video indexing tasks in your account. The API returns your video indexing tasks sorted by creation date, with the newest at the top of the list.

        Parameters
        ----------
        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        index_id : typing.Optional[str]
            Filter by the unique identifier of an index.

        status : typing.Optional[typing.Union[TasksListRequestStatusItem, typing.Sequence[TasksListRequestStatusItem]]]
            Filter by one or more video indexing task statuses. The following options are available:
            - `ready`: The video has been successfully uploaded and indexed.
            - `uploading`: The video is being uploaded.
            - `validating`: The video is being validated against the prerequisites.
            - `pending`: The video is pending.
            - `queued`: The video is queued.
            - `indexing`: The video is being indexed.
            - `failed`: The video indexing task failed.

            To filter by multiple statuses, specify the `status` parameter for each value:
            ```
            status=ready&status=validating
            ```

        filename : typing.Optional[str]
            Filter by filename.

        duration : typing.Optional[float]
            Filter by duration. Expressed in seconds.

        width : typing.Optional[int]
            Filter by width.

        height : typing.Optional[int]
            Filter by height.

        created_at : typing.Optional[str]
            Filter video indexing tasks by the creation date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            Filter video indexing tasks by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were updated on the specified date at or after the given time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[VideoIndexingTask]
            The video indexing tasks have successfully been retrieved.
        """
        page = page if page is not None else 1

        _response = await self._client_wrapper.httpx_client.request(
            "tasks",
            method="GET",
            params={
                "page": page,
                "page_limit": page_limit,
                "sort_by": sort_by,
                "sort_option": sort_option,
                "index_id": index_id,
                "status": status,
                "filename": filename,
                "duration": duration,
                "width": width,
                "height": height,
                "created_at": created_at,
                "updated_at": updated_at,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TasksListResponse,
                    parse_obj_as(
                        type_=TasksListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True

                async def _get_next():
                    return await self.list(
                        page=page + 1,
                        page_limit=page_limit,
                        sort_by=sort_by,
                        sort_option=sort_option,
                        index_id=index_id,
                        status=status,
                        filename=filename,
                        duration=duration,
                        width=width,
                        height=height,
                        created_at=created_at,
                        updated_at=updated_at,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        index_id: str,
        video_file: typing.Optional[core.File] = OMIT,
        video_url: typing.Optional[str] = OMIT,
        enable_video_stream: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TasksCreateResponse]:
        """
        This method creates a video indexing task that uploads and indexes a video.

        Upload options:
        - **Local file**: Use the `video_file` parameter.
        - **Publicly accessible URL**: Use the `video_url` parameter.

        <Accordion title="Video requirements">
          The videos you wish to upload must meet the following requirements:
          - **Video resolution**: Must be at least 360x360 and must not exceed 3840x2160.
          - **Aspect ratio**: Must be one of 1:1, 4:3, 4:5, 5:4, 16:9, 9:16, or 17:9.
          - **Video and audio formats**: Your video files must be encoded in the video and audio formats listed on the [FFmpeg Formats Documentation](https://ffmpeg.org/ffmpeg-formats.html) page. For videos in other formats, contact us at support@twelvelabs.io.
          - **Duration**: For Marengo, it must be between 4 seconds and 2 hours (7,200s). For Pegasus, it must be between 4 seconds and 60 minutes (3600s). In a future release, the maximum duration for Pegasus will be 2 hours (7,200 seconds).
          - **File size**: Must not exceed 2 GB.
            If you require different options, contact us at support@twelvelabs.io.

          If both Marengo and Pegasus are enabled for your index, the most restrictive prerequisites will apply.
        </Accordion>

        <Note title="Notes">
        - The platform supports video URLs that can play without additional user interaction or custom video players. Ensure your URL points to the raw video file, not a web page containing the video. Links to third-party hosting sites, cloud storage services, or videos requiring extra steps to play are not supported.
        - This endpoint is rate-limited. For details, see the [Rate limits](/v1.3/docs/get-started/rate-limits) page.
        </Note>

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video is being uploaded.

        video_file : typing.Optional[core.File]
            See core.File for more documentation

        video_url : typing.Optional[str]
            Specify this parameter to upload a video from a publicly accessible URL.

        enable_video_stream : typing.Optional[bool]
            This parameter indicates if the platform stores the video for streaming. When set to `true`, the platform stores the video, and you can retrieve its URL by calling the [`GET`](/v1.3/api-reference/videos/retrieve) method of the `/indexes/{index-id}/videos/{video-id}` endpoint. You can then use this URL to access the stream over the <a href="https://en.wikipedia.org/wiki/HTTP_Live_Streaming" target="_blank">HLS</a> protocol.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TasksCreateResponse]
            A video indexing task has successfully been created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "tasks",
            method="POST",
            data={
                "index_id": index_id,
                "video_url": video_url,
                "enable_video_stream": enable_video_stream,
            },
            files={
                **({"video_file": video_file} if video_file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksCreateResponse,
                    parse_obj_as(
                        type_=TasksCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[TasksRetrieveResponse]:
        """
        This method retrieves a video indexing task.

        Parameters
        ----------
        task_id : str
            The unique identifier of the video indexing task to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TasksRetrieveResponse]
            The specified video indexing task has successfully been retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"tasks/{jsonable_encoder(task_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksRetrieveResponse,
                    parse_obj_as(
                        type_=TasksRetrieveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        This action cannot be undone.
        Note the following about deleting a video indexing task:
        - You can only delete video indexing tasks for which the status is `ready` or `failed`.
        - If the status of your video indexing task is `ready`, you must first delete the video vector associated with your video indexing task by calling the [`DELETE`](/v1.3/api-reference/videos/delete) method of the `/indexes/videos` endpoint.

        Parameters
        ----------
        task_id : str
            The unique identifier of the video indexing task you want to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"tasks/{jsonable_encoder(task_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
