# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .audio_segment import AudioSegment
from .base_embedding_metadata import BaseEmbeddingMetadata


class AudioEmbeddingResult(UniversalBaseModel):
    """
    An object that contains the generated embedding vector and associated information.
    """

    segments: typing.Optional[typing.List[AudioSegment]] = pydantic.Field(default=None)
    """
    An object that contains the embedding and its start time.
    """

    error_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message if the embedding generation failed.
    """

    metadata: typing.Optional[BaseEmbeddingMetadata] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
