# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .audio_embedding_result import AudioEmbeddingResult
from .image_embedding_result import ImageEmbeddingResult
from .text_embedding_result import TextEmbeddingResult


class EmbeddingResponse(UniversalBaseModel):
    """
    An object that contains the generated embedding vector and associated information.
    """

    model_name: str = pydantic.Field()
    """
    The name of the video understanding model the platform has used to create this embedding.
    """

    text_embedding: typing.Optional[TextEmbeddingResult] = pydantic.Field(default=None)
    """
    An object that contains the generated text embedding vector and associated information. Present when text was processed.
    """

    image_embedding: typing.Optional[ImageEmbeddingResult] = pydantic.Field(default=None)
    """
    An object that contains the generated image embedding vector and associated information. Present when image was processed.
    """

    audio_embedding: typing.Optional[AudioEmbeddingResult] = pydantic.Field(default=None)
    """
    An object that contains the generated audio embedding vector and associated information. Present when audio was processed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
