# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .hls_object_status import HlsObjectStatus


class HlsObject(UniversalBaseModel):
    """
    The platform returns this object only for the videos that you uploaded with the `enable_video_stream` parameter set to `true`.
    """

    video_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string representing the URL of the video. You can then use this URL to access the stream over the <a href="https://en.wikipedia.org/wiki/HTTP_Live_Streaming" target="_blank">HLS</a> protocol.
    """

    thumbnail_urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    An array containing the URL of the thumbnail.
    """

    status: typing.Optional[HlsObjectStatus] = pydantic.Field(default=None)
    """
    A string representing the encoding status of the video file from its original format to a streamable format.
    Possible values:
    - `PROCESSING`: Video is currently being encoded and is not yet ready for streaming
    - `COMPLETE`: Encoding has successfully finished and the video is ready for streaming
    - `CANCELED`: Encoding was manually canceled before completion
    - `ERROR`: An error occurred during the encoding process
    """

    updated_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the encoding status was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
