# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .base_embedding_metadata import BaseEmbeddingMetadata
from .base_segment import BaseSegment


class ImageEmbeddingResult(UniversalBaseModel):
    """
    An object containing the generated embedding vector and associated information.
    """

    error_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message if the embedding generation failed.
    """

    segments: typing.Optional[typing.List[BaseSegment]] = pydantic.Field(default=None)
    """
    An object that contains the embedding.
    """

    metadata: typing.Optional[BaseEmbeddingMetadata] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
