# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .import_log_failed_files_item import ImportLogFailedFilesItem
from .import_log_video_status import ImportLogVideoStatus


class ImportLog(UniversalBaseModel):
    """
    An object that contains information about the import process.
    """

    index_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the index associated with this import.
    """

    index_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the index associated with this import.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time, in the RFC 3339 format when the import process was initiated.
    """

    ended_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time, in the RFC 3339 format, when the platform completed importing your videos. A `null` value indicates that the import process is still ongoing.
    """

    video_status: typing.Optional[ImportLogVideoStatus] = pydantic.Field(default=None)
    """
    Counts of files in different statuses. See the [Task object](/v1.3/api-reference/tasks/the-task-object) page for details on each status.
    """

    failed_files: typing.Optional[typing.List[ImportLogFailedFilesItem]] = pydantic.Field(default=None)
    """
    An array containing the video files that failed to import, along with details about the error.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
