# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .confidence import Confidence
from .end_time import EndTime
from .score_search_terms import ScoreSearchTerms
from .search_item_clips_item import SearchItemClipsItem
from .start_time import StartTime
from .thumbnail_url import ThumbnailUrl
from .user_metadata import UserMetadata


class SearchItem(UniversalBaseModel):
    """
    An object that contains the search results.
    """

    score: typing.Optional[ScoreSearchTerms] = None
    start: typing.Optional[StartTime] = None
    end: typing.Optional[EndTime] = None
    video_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string representing the unique identifier of the video. Once the platform indexes a video, it assigns a unique identifier. Note that this is different from the identifier of the video indexing task.
    """

    confidence: typing.Optional[Confidence] = None
    thumbnail_url: typing.Optional[ThumbnailUrl] = None
    transcription: typing.Optional[str] = pydantic.Field(default=None)
    """
    A transcription of the spoken words that are captured in the video. Note that the official SDKs will support this feature in a future release.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string representing the unique identifier of the video. It only appears when the `group_by=video` parameter is used in the request.
    """

    user_metadata: typing.Optional[UserMetadata] = None
    clips: typing.Optional[typing.List[SearchItemClipsItem]] = pydantic.Field(default=None)
    """
    An array that contains detailed information about the clips that match your query. The platform returns this array only when the `group_by` parameter is set to `video` in the request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
