# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .confidence import Confidence
from .end_time import EndTime
from .score_search_terms import ScoreSearchTerms
from .start_time import StartTime
from .thumbnail_url import ThumbnailUrl
from .user_metadata import UserMetadata


class SearchItemClipsItem(UniversalBaseModel):
    score: typing.Optional[ScoreSearchTerms] = None
    start: typing.Optional[StartTime] = None
    end: typing.Optional[EndTime] = None
    confidence: typing.Optional[Confidence] = None
    thumbnail_url: typing.Optional[ThumbnailUrl] = None
    transcription: typing.Optional[str] = pydantic.Field(default=None)
    """
    A transcription of the spoken words that are captured in the clip. Note that the official SDKs will support this feature in a future release.
    """

    video_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string representing the unique identifier of the video for the corresponding clip.
    """

    user_metadata: typing.Optional[UserMetadata] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
