# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .next_page_token import NextPageToken
from .total_inner_matches import TotalInnerMatches


class SearchResultsPageInfo(UniversalBaseModel):
    """
    An object that provides information about pagination.
    """

    limit_per_page: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of items on each page. When grouping by video, this field represents the maximum number of videos per page. Otherwise, it represents the maximum number of video clips per page.
    """

    page_expires_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string representing the date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the page expires.
    """

    total_results: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of results. When grouping by video, this field represents the total number of video clips matching your query. Otherwise , this field represents the total number of videos.
    """

    total_inner_matches: typing.Optional[TotalInnerMatches] = None
    next_page_token: typing.Optional[NextPageToken] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
