# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .video_indexing_task_system_metadata import VideoIndexingTaskSystemMetadata


class VideoIndexingTask(UniversalBaseModel):
    """
    A video indexing task that describes the status of the task and the metadata about the video.
    """

    id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="_id")] = pydantic.Field(default=None)
    """
    A string representing the unique identifier of the task. It is assigned by the platform when a new task is created.
    """

    video_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string representing the unique identifier of the video associated with the specified video indexing task.
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the date and time, in the RFC RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the task was created.
    """

    updated_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the date and time, in the RFC RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the task object was last updated. The platform updates this field every time the video indexing task transitions to a different state.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the status of the video indexing task. See the [Task object](/v1.3/api-reference/tasks/the-task-object) page for a list of possible statuses.
    """

    index_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string representing the unique identifier of the index to which the video must be uploaded.
    """

    system_metadata: typing.Optional[VideoIndexingTaskSystemMetadata] = pydantic.Field(default=None)
    """
    System-generated metadata about the video.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
