# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .audio_segment import AudioSegment


class VideoSegment(AudioSegment):
    """
    An object that contains the video embedding and its start time. Each segment is between 2 and 10 seconds.
    """

    end_offset_sec: typing.Optional[float] = pydantic.Field(default=None)
    """
    The end time, in seconds, of the video segment for this embedding.
    """

    embedding_option: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the embedding.
    """

    embedding_scope: typing.Optional[str] = pydantic.Field(default=None)
    """
    The scope of the video embedding.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
