"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import authzed.api.v1.core_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class WatchPermissionSetsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONAL_STARTING_AFTER_FIELD_NUMBER: builtins.int
    @property
    def optional_starting_after(self) -> authzed.api.v1.core_pb2.ZedToken:
        """optional_starting_after is used to specify the SpiceDB revision to start watching from.
        If not specified, the watch will start from the current SpiceDB revision time of the request ("head revision").
        """

    def __init__(
        self,
        *,
        optional_starting_after: authzed.api.v1.core_pb2.ZedToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["optional_starting_after", b"optional_starting_after"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["optional_starting_after", b"optional_starting_after"]) -> None: ...

global___WatchPermissionSetsRequest = WatchPermissionSetsRequest

@typing.final
class WatchPermissionSetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANGE_FIELD_NUMBER: builtins.int
    COMPLETED_REVISION_FIELD_NUMBER: builtins.int
    LOOKUP_PERMISSION_SETS_REQUIRED_FIELD_NUMBER: builtins.int
    BREAKING_SCHEMA_CHANGE_FIELD_NUMBER: builtins.int
    @property
    def change(self) -> global___PermissionSetChange:
        """change is the permission set delta that has occurred as result of a mutation in origin SpiceDB.
        The consumer should apply this change to the current state of the permission sets in their target system.
        Once an event arrives with completed_revision instead, the consumer shall consider the set of
        changes originating from that revision completed.

        The consumer should keep track of the revision in order to resume streaming in the event of consumer restarts.
        """

    @property
    def completed_revision(self) -> authzed.api.v1.core_pb2.ZedToken:
        """completed_revision is the revision token that indicates the completion of a set of changes. It may also be
        received without accompanying set of changes, indicating that a mutation in the origin SpiceDB cluster did
        not yield any effective changes in the permission sets
        """

    @property
    def lookup_permission_sets_required(self) -> global___LookupPermissionSetsRequired:
        """lookup_permission_sets_required is a signal that the consumer should perform a LookupPermissionSets call because
        the permission set snapshot needs to be rebuilt from scratch. This typically happens when the origin SpiceDB
        cluster has seen its schema changed.
        """

    @property
    def breaking_schema_change(self) -> global___BreakingSchemaChange:
        """breaking_schema_change is a signal that a breaking schema change has been written to the origin SpiceDB cluster,
        and that the consumer should expect delays in the ingestion of new changes,
        because the permission set snapshot needs to be rebuilt from scratch. Once the snapshot is ready, the consumer
        will receive a LookupPermissionSetsRequired event.
        """

    def __init__(
        self,
        *,
        change: global___PermissionSetChange | None = ...,
        completed_revision: authzed.api.v1.core_pb2.ZedToken | None = ...,
        lookup_permission_sets_required: global___LookupPermissionSetsRequired | None = ...,
        breaking_schema_change: global___BreakingSchemaChange | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["breaking_schema_change", b"breaking_schema_change", "change", b"change", "completed_revision", b"completed_revision", "lookup_permission_sets_required", b"lookup_permission_sets_required", "response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["breaking_schema_change", b"breaking_schema_change", "change", b"change", "completed_revision", b"completed_revision", "lookup_permission_sets_required", b"lookup_permission_sets_required", "response", b"response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["response", b"response"]) -> typing.Literal["change", "completed_revision", "lookup_permission_sets_required", "breaking_schema_change"] | None: ...

global___WatchPermissionSetsResponse = WatchPermissionSetsResponse

@typing.final
class Cursor(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    STARTING_INDEX_FIELD_NUMBER: builtins.int
    COMPLETED_MEMBERS_FIELD_NUMBER: builtins.int
    STARTING_KEY_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """limit is the number of permission sets to stream over a single LookupPermissionSets call that was requested."""
    starting_index: builtins.int
    """starting_index is an offset of the permission set represented by this cursor"""
    completed_members: builtins.bool
    """completed_members is a boolean flag that indicates that the cursor has reached the end of the permission sets"""
    starting_key: builtins.str
    """starting_key is a string cursor used by some backends to resume the stream from a specific point."""
    cursor: builtins.str
    """cursor is a string-encoded internal materialize cursor."""
    @property
    def token(self) -> authzed.api.v1.core_pb2.ZedToken:
        """token is the snapshot revision at which the cursor was computed."""

    def __init__(
        self,
        *,
        limit: builtins.int = ...,
        token: authzed.api.v1.core_pb2.ZedToken | None = ...,
        starting_index: builtins.int = ...,
        completed_members: builtins.bool = ...,
        starting_key: builtins.str = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["token", b"token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["completed_members", b"completed_members", "cursor", b"cursor", "limit", b"limit", "starting_index", b"starting_index", "starting_key", b"starting_key", "token", b"token"]) -> None: ...

global___Cursor = Cursor

@typing.final
class LookupPermissionSetsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    OPTIONAL_AT_REVISION_FIELD_NUMBER: builtins.int
    OPTIONAL_STARTING_AFTER_CURSOR_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """limit is the number of permission sets to stream over a single LookupPermissionSets. Once the limit is reached,
    the server will close the stream. If more permission sets are available, the consume should open a new stream
    providing optional_starting_after_cursor, using the cursor from the last response.
    """
    @property
    def optional_at_revision(self) -> authzed.api.v1.core_pb2.ZedToken:
        """optional_at_revision specifies the client is requesting to lookup PermissionSets at a specific revision. It's
        optional, and if not provided, PermissionSets will be looked up at the current revision. The cursor always
        takes precedence in defining the revision when present.
        """

    @property
    def optional_starting_after_cursor(self) -> global___Cursor:
        """optional_starting_after_cursor is used to specify the offset to start streaming permission sets from."""

    def __init__(
        self,
        *,
        limit: builtins.int = ...,
        optional_at_revision: authzed.api.v1.core_pb2.ZedToken | None = ...,
        optional_starting_after_cursor: global___Cursor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["optional_at_revision", b"optional_at_revision", "optional_starting_after_cursor", b"optional_starting_after_cursor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["limit", b"limit", "optional_at_revision", b"optional_at_revision", "optional_starting_after_cursor", b"optional_starting_after_cursor"]) -> None: ...

global___LookupPermissionSetsRequest = LookupPermissionSetsRequest

@typing.final
class LookupPermissionSetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANGE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    @property
    def change(self) -> global___PermissionSetChange:
        """change represents the permission set delta necessary to transition an uninitialized target system to
        a specific snapshot revision. In practice it's not different from the WatchPermissionSetsResponse.change, except
        all changes will be of time SET_OPERATION_ADDED because it's assumed there is no known previous state.

        Applying the deltas to a previously initialized target system would yield incorrect results.
        """

    @property
    def cursor(self) -> global___Cursor:
        """cursor points to a specific permission set in a revision.
        The consumer should keep track of the cursor in order to resume streaming in the event of consumer restarts. This
        is particularly important in backfill scenarios that may take hours or event days to complete.
        """

    def __init__(
        self,
        *,
        change: global___PermissionSetChange | None = ...,
        cursor: global___Cursor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["change", b"change", "cursor", b"cursor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["change", b"change", "cursor", b"cursor"]) -> None: ...

global___LookupPermissionSetsResponse = LookupPermissionSetsResponse

@typing.final
class PermissionSetChange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SetOperation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SetOperationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PermissionSetChange._SetOperation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SET_OPERATION_UNSPECIFIED: PermissionSetChange._SetOperation.ValueType  # 0
        SET_OPERATION_ADDED: PermissionSetChange._SetOperation.ValueType  # 1
        SET_OPERATION_REMOVED: PermissionSetChange._SetOperation.ValueType  # 2

    class SetOperation(_SetOperation, metaclass=_SetOperationEnumTypeWrapper): ...
    SET_OPERATION_UNSPECIFIED: PermissionSetChange.SetOperation.ValueType  # 0
    SET_OPERATION_ADDED: PermissionSetChange.SetOperation.ValueType  # 1
    SET_OPERATION_REMOVED: PermissionSetChange.SetOperation.ValueType  # 2

    AT_REVISION_FIELD_NUMBER: builtins.int
    OPERATION_FIELD_NUMBER: builtins.int
    PARENT_SET_FIELD_NUMBER: builtins.int
    CHILD_SET_FIELD_NUMBER: builtins.int
    CHILD_MEMBER_FIELD_NUMBER: builtins.int
    operation: global___PermissionSetChange.SetOperation.ValueType
    """operation represents the type of set operation that took place as part of the change"""
    @property
    def at_revision(self) -> authzed.api.v1.core_pb2.ZedToken:
        """revision represents the revision at which the permission set change occurred."""

    @property
    def parent_set(self) -> global___SetReference:
        """parent_set represents the permission set parent of either another set or a member"""

    @property
    def child_set(self) -> global___SetReference:
        """child_set represents the scenario where another set is considered member of the parent set"""

    @property
    def child_member(self) -> global___MemberReference:
        """child_member represents the scenario where an specific object is considered member of the parent set"""

    def __init__(
        self,
        *,
        at_revision: authzed.api.v1.core_pb2.ZedToken | None = ...,
        operation: global___PermissionSetChange.SetOperation.ValueType = ...,
        parent_set: global___SetReference | None = ...,
        child_set: global___SetReference | None = ...,
        child_member: global___MemberReference | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["at_revision", b"at_revision", "child", b"child", "child_member", b"child_member", "child_set", b"child_set", "parent_set", b"parent_set"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["at_revision", b"at_revision", "child", b"child", "child_member", b"child_member", "child_set", b"child_set", "operation", b"operation", "parent_set", b"parent_set"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["child", b"child"]) -> typing.Literal["child_set", "child_member"] | None: ...

global___PermissionSetChange = PermissionSetChange

@typing.final
class SetReference(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OBJECT_TYPE_FIELD_NUMBER: builtins.int
    OBJECT_ID_FIELD_NUMBER: builtins.int
    PERMISSION_OR_RELATION_FIELD_NUMBER: builtins.int
    object_type: builtins.str
    """object_type is the type of object in a permission set"""
    object_id: builtins.str
    """object_id is the ID of a permission set"""
    permission_or_relation: builtins.str
    """permission_or_relation is the permission or relation referenced by this permission set"""
    def __init__(
        self,
        *,
        object_type: builtins.str = ...,
        object_id: builtins.str = ...,
        permission_or_relation: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["object_id", b"object_id", "object_type", b"object_type", "permission_or_relation", b"permission_or_relation"]) -> None: ...

global___SetReference = SetReference

@typing.final
class MemberReference(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OBJECT_TYPE_FIELD_NUMBER: builtins.int
    OBJECT_ID_FIELD_NUMBER: builtins.int
    OPTIONAL_PERMISSION_OR_RELATION_FIELD_NUMBER: builtins.int
    object_type: builtins.str
    """object_type is the type of object of a permission set member"""
    object_id: builtins.str
    """object_id is the ID of a permission set member"""
    optional_permission_or_relation: builtins.str
    """optional_permission_or_relation is the permission or relation referenced by this permission set member"""
    def __init__(
        self,
        *,
        object_type: builtins.str = ...,
        object_id: builtins.str = ...,
        optional_permission_or_relation: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["object_id", b"object_id", "object_type", b"object_type", "optional_permission_or_relation", b"optional_permission_or_relation"]) -> None: ...

global___MemberReference = MemberReference

@typing.final
class LookupPermissionSetsRequired(google.protobuf.message.Message):
    """LookupPermissionSetsRequired is a signal that the consumer should perform a LookupPermissionSets call because
    the permission set snapshot needs to be rebuilt from scratch. This typically happens when the origin SpiceDB
    cluster has seen its schema changed, see BreakingSchemaChange event.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUIRED_LOOKUP_AT_FIELD_NUMBER: builtins.int
    @property
    def required_lookup_at(self) -> authzed.api.v1.core_pb2.ZedToken:
        """required_lookup_at is the snapshot revision at which the permission set needs to be rebuilt to."""

    def __init__(
        self,
        *,
        required_lookup_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["required_lookup_at", b"required_lookup_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["required_lookup_at", b"required_lookup_at"]) -> None: ...

global___LookupPermissionSetsRequired = LookupPermissionSetsRequired

@typing.final
class BreakingSchemaChange(google.protobuf.message.Message):
    """BreakingSchemaChange is used to signal a breaking schema change has happened, and that the consumer should
    expect delays in the ingestion of new changes, because the permission set snapshot needs to be rebuilt from scratch.
    Once the snapshot is ready, the consumer will receive a LookupPermissionSetsRequired event.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANGE_AT_FIELD_NUMBER: builtins.int
    @property
    def change_at(self) -> authzed.api.v1.core_pb2.ZedToken:
        """change_at is the revision at which a breaking schema event has happened."""

    def __init__(
        self,
        *,
        change_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["change_at", b"change_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["change_at", b"change_at"]) -> None: ...

global___BreakingSchemaChange = BreakingSchemaChange
