"""Stub file for reflex/components/datadisplay/dataeditor.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from enum import Enum
from typing import Any, Literal, TypedDict

from reflex.base import Base
from reflex.components.component import NoSSRComponent
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventType, PointerEventInfo
from reflex.utils.imports import ImportDict
from reflex.utils.serializers import serializer
from reflex.vars.base import Var

class GridColumnIcons(Enum):
    Array = "array"
    AudioUri = "audio_uri"
    Boolean = "boolean"
    HeaderCode = "code"
    Date = "date"
    Email = "email"
    Emoji = "emoji"
    GeoDistance = "geo_distance"
    IfThenElse = "if_then_else"
    Image = "image"
    JoinStrings = "join_strings"
    Lookup = "lookup"
    Markdown = "markdown"
    Math = "math"
    Number = "number"
    Phone = "phone"
    Reference = "reference"
    Rollup = "rollup"
    RowID = "row_id"
    SingleValue = "single_value"
    SplitString = "split_string"
    String = "string"
    TextTemplate = "text_template"
    Time = "time"
    Uri = "uri"
    VideoUri = "video_uri"

class DataEditorTheme(Base):
    accent_color: str | None
    accent_fg: str | None
    accent_light: str | None
    base_font_style: str | None
    bg_bubble: str | None
    bg_bubble_selected: str | None
    bg_cell: str | None
    bg_cell_medium: str | None
    bg_header: str | None
    bg_header_has_focus: str | None
    bg_header_hovered: str | None
    bg_icon_header: str | None
    bg_search_result: str | None
    border_color: str | None
    cell_horizontal_padding: int | None
    cell_vertical_padding: int | None
    drilldown_border: str | None
    editor_font_size: str | None
    fg_icon_header: str | None
    font_family: str | None
    header_bottom_border_color: str | None
    header_font_style: str | None
    horizontal_border_color: str | None
    line_height: int | None
    link_color: str | None
    text_bubble: str | None
    text_dark: str | None
    text_group_header: str | None
    text_header: str | None
    text_header_selected: str | None
    text_light: str | None
    text_medium: str | None

class Bounds(TypedDict):
    x: int
    y: int
    width: int
    height: int

class CompatSelection(TypedDict):
    items: list

class Rectangle(TypedDict):
    x: int
    y: int
    width: int
    height: int

class GridSelectionCurrent(TypedDict):
    cell: tuple[int, int]
    range: Rectangle
    rangeStack: list[Rectangle]

class GridSelection(TypedDict):
    current: GridSelectionCurrent | None
    columns: CompatSelection
    rows: CompatSelection

class GroupHeaderClickedEventArgs(TypedDict):
    kind: str
    group: str
    location: tuple[int, int]
    bounds: Bounds
    isEdge: bool
    shiftKey: bool
    ctrlKey: bool
    metaKey: bool
    isTouch: bool
    localEventX: int
    localEventY: int
    button: int
    buttons: int
    scrollEdge: tuple[int, int]

class GridCell(TypedDict):
    span: list[int] | None

class GridColumn(TypedDict):
    title: str
    group: str | None

class DataEditor(NoSSRComponent):
    def add_imports(self) -> ImportDict: ...
    def add_hooks(self) -> list[str]: ...
    @classmethod
    def create(
        cls,
        *children,
        rows: Var[int] | int | None = None,
        columns: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        data: Sequence[Sequence[Any]] | Var[Sequence[Sequence[Any]]] | None = None,
        get_cell_content: Var[str] | str | None = None,
        get_cells_for_selection: Var[bool] | bool | None = None,
        on_paste: Var[bool] | bool | None = None,
        draw_focus_ring: Var[bool] | bool | None = None,
        fixed_shadow_x: Var[bool] | bool | None = None,
        fixed_shadow_y: Var[bool] | bool | None = None,
        fill_handle: Var[bool] | bool | None = None,
        freeze_columns: Var[int] | int | None = None,
        group_header_height: Var[int] | int | None = None,
        header_height: Var[int] | int | None = None,
        max_column_auto_width: Var[int] | int | None = None,
        max_column_width: Var[int] | int | None = None,
        min_column_width: Var[int] | int | None = None,
        row_height: Var[int] | int | None = None,
        row_markers: Literal["both", "checkbox", "clickable-number", "none", "number"]
        | Var[Literal["both", "checkbox", "clickable-number", "none", "number"]]
        | None = None,
        row_marker_start_index: Var[int] | int | None = None,
        row_marker_width: Var[int] | int | None = None,
        smooth_scroll_x: Var[bool] | bool | None = None,
        smooth_scroll_y: Var[bool] | bool | None = None,
        vertical_border: Var[bool] | bool | None = None,
        column_select: Literal["multi", "none", "single"]
        | Var[Literal["multi", "none", "single"]]
        | None = None,
        prevent_diagonal_scrolling: Var[bool] | bool | None = None,
        overscroll_x: Var[int] | int | None = None,
        overscroll_y: Var[int] | int | None = None,
        scroll_offset_x: Var[int] | int | None = None,
        scroll_offset_y: Var[int] | int | None = None,
        theme: DataEditorTheme | Var[DataEditorTheme | dict] | dict | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_cell_activated: EventType[()] | EventType[tuple[int, int]] | None = None,
        on_cell_clicked: EventType[()] | EventType[tuple[int, int]] | None = None,
        on_cell_context_menu: EventType[()] | EventType[tuple[int, int]] | None = None,
        on_cell_edited: EventType[()]
        | EventType[tuple[int, int]]
        | EventType[tuple[int, int], GridCell]
        | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_column_resize: EventType[()]
        | EventType[GridColumn]
        | EventType[GridColumn, int]
        | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_delete: EventType[()] | EventType[GridSelection] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_finished_editing: EventType[()]
        | EventType[GridCell | None]
        | EventType[GridCell | None, tuple[int, int]]
        | None = None,
        on_focus: EventType[()] | None = None,
        on_group_header_clicked: EventType[()]
        | EventType[tuple[int, int]]
        | EventType[tuple[int, int], GridCell]
        | None = None,
        on_group_header_context_menu: EventType[()]
        | EventType[int]
        | EventType[int, GroupHeaderClickedEventArgs]
        | None = None,
        on_group_header_renamed: EventType[()]
        | EventType[str]
        | EventType[str, str]
        | None = None,
        on_header_clicked: EventType[()] | EventType[tuple[int, int]] | None = None,
        on_header_context_menu: EventType[()]
        | EventType[tuple[int, int]]
        | None = None,
        on_header_menu_click: EventType[()]
        | EventType[int]
        | EventType[int, Rectangle]
        | None = None,
        on_item_hovered: EventType[()] | EventType[tuple[int, int]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_row_appended: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selection_cleared: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> DataEditor:
        """Create the DataEditor component.

        Args:
            *children: The children of the data editor.
            rows: Number of rows.
            columns: Headers of the columns for the data grid.
            data: The data.
            get_cell_content: The name of the callback used to find the data to display.
            get_cells_for_selection: Allow selection for copying.
            on_paste: Allow paste.
            draw_focus_ring: Controls the drawing of the focus ring.
            fixed_shadow_x: Enables or disables the overlay shadow when scrolling horizontally.
            fixed_shadow_y: Enables or disables the overlay shadow when scrolling vertically.
            fill_handle: Controls the presence of the fill indicator
            freeze_columns: The number of columns which should remain in place when scrolling horizontally. Doesn't include rowMarkers.
            group_header_height: Controls the header of the group header row.
            header_height: Controls the height of the header row.
            max_column_auto_width: The maximum width a column can be automatically sized to.
            max_column_width: The maximum width a column can be resized to.
            min_column_width: The minimum width a column can be resized to.
            row_height: Determines the height of each row.
            row_markers: Kind of row markers.
            row_marker_start_index: Changes the starting index for row markers.
            row_marker_width: Sets the width of row markers in pixels, if unset row markers will automatically size.
            smooth_scroll_x: Enable horizontal smooth scrolling.
            smooth_scroll_y: Enable vertical smooth scrolling.
            vertical_border: Controls the drawing of the left hand vertical border of a column. If set to a boolean value it controls all borders.
            column_select: Allow columns selections. ("none", "single", "multi")
            prevent_diagonal_scrolling: Prevent diagonal scrolling.
            overscroll_x: Allow to scroll past the limit of the actual content on the horizontal axis.
            overscroll_y: Allow to scroll past the limit of the actual content on the vertical axis.
            scroll_offset_x: Initial scroll offset on the horizontal axis.
            scroll_offset_y: Initial scroll offset on the vertical axis.
            theme: global theme
            on_cell_activated: Fired when a cell is activated.
            on_cell_clicked: Fired when a cell is clicked.
            on_cell_context_menu: Fired when a cell is right-clicked.
            on_cell_edited: Fired when a cell is edited.
            on_group_header_clicked: Fired when a group header is clicked.
            on_group_header_context_menu: Fired when a group header is right-clicked.
            on_group_header_renamed: Fired when a group header is renamed.
            on_header_clicked: Fired when a header is clicked.
            on_header_context_menu: Fired when a header is right-clicked.
            on_header_menu_click: Fired when a header menu item is clicked.
            on_item_hovered: Fired when an item is hovered.
            on_delete: Fired when a selection is deleted.
            on_finished_editing: Fired when editing is finished.
            on_row_appended: Fired when a row is appended.
            on_selection_cleared: Fired when the selection is cleared.
            on_column_resize: Fired when a column is resized.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the data editor.

        Raises:
            ValueError: invalid input.

        Returns:
            The DataEditor component.&
        """

@serializer
def serialize_dataeditortheme(theme: DataEditorTheme): ...

data_editor = DataEditor.create
data_editor_theme = DataEditorTheme
