"""Stub file for reflex/components/radix/themes/components/radio_cards.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from types import SimpleNamespace
from typing import Any, Literal

from reflex.components.core.breakpoints import Breakpoints
from reflex.components.radix.themes.base import RadixThemesComponent
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

class RadioCardsRoot(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        as_child: Var[bool] | bool | None = None,
        size: Breakpoints[str, Literal["1", "2", "3"]]
        | Literal["1", "2", "3"]
        | Var[Breakpoints[str, Literal["1", "2", "3"]] | Literal["1", "2", "3"]]
        | None = None,
        variant: Literal["classic", "surface"]
        | Var[Literal["classic", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        columns: Breakpoints[
            str, Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"] | str
        ]
        | Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"]
        | Var[
            Breakpoints[str, Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"] | str]
            | Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"]
            | str
        ]
        | str
        | None = None,
        gap: Breakpoints[
            str, Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"] | str
        ]
        | Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"]
        | Var[
            Breakpoints[str, Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"] | str]
            | Literal["1", "2", "3", "4", "5", "6", "7", "8", "9"]
            | str
        ]
        | str
        | None = None,
        default_value: Var[str] | str | None = None,
        value: Var[str] | str | None = None,
        name: Var[str] | str | None = None,
        disabled: Var[bool] | bool | None = None,
        required: Var[bool] | bool | None = None,
        orientation: Literal["horizontal", "undefined", "vertical"]
        | Var[Literal["horizontal", "undefined", "vertical"]]
        | None = None,
        dir: Literal["ltr", "rtl"] | Var[Literal["ltr", "rtl"]] | None = None,
        loop: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        on_value_change: EventType[()] | EventType[str] | None = None,
        **props,
    ) -> RadioCardsRoot:
        """Create a new component instance.

        Will prepend "RadixThemes" to the component tag to avoid conflicts with
        other UI libraries for common names, like Text and Button.

        Args:
            *children: Child components.
            as_child: Change the default rendered element for the one passed as a child, merging their props and behavior.
            size: The size of the checkbox cards: "1" | "2" | "3"
            variant: Variant of button: "classic" | "surface" | "soft"
            color_scheme: Override theme color for button
            high_contrast: Uses a higher contrast color for the component.
            columns: The number of columns:
            gap: The gap between the checkbox cards:
            value: The controlled value of the radio item to check. Should be used in conjunction with onValueChange.
            name: The name of the group. Submitted with its owning form as part of a name/value pair.
            disabled: When true, prevents the user from interacting with radio items.
            required: When true, indicates that the user must check a radio item before the owning form can be submitted.
            orientation: The orientation of the component.
            dir: The reading direction of the radio group. If omitted,  inherits globally from DirectionProvider or assumes LTR (left-to-right) reading mode.
            loop: When true, keyboard navigation will loop from last item to first, and vice versa.
            on_value_change: Event handler called when the value changes.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: Component properties.

        Returns:
            A new component instance.
        """

class RadioCardsItem(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        as_child: Var[bool] | bool | None = None,
        value: Var[str] | str | None = None,
        disabled: Var[bool] | bool | None = None,
        required: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> RadioCardsItem:
        """Create a new component instance.

        Will prepend "RadixThemes" to the component tag to avoid conflicts with
        other UI libraries for common names, like Text and Button.

        Args:
            *children: Child components.
            as_child: Change the default rendered element for the one passed as a child, merging their props and behavior.
            value: The value given as data when submitted with a name.
            disabled: When true, prevents the user from interacting with the radio item.
            required: When true, indicates that the user must check the radio item before the owning form can be submitted.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: Component properties.

        Returns:
            A new component instance.
        """

class RadioCards(SimpleNamespace):
    root = staticmethod(RadioCardsRoot.create)
    item = staticmethod(RadioCardsItem.create)

radio_cards = RadioCards()
