from morphr.constraints.point_coupling import PointCoupling
import pytest
import eqlib as eq
from numpy.testing import assert_almost_equal

if __name__ == '__main__':
    import sys
    pytest.main(sys.argv)


DATA = {
    "ref_locations_a": [[-6.7369613697638036, 2.6325435700231465, -0.14110785709398277], [-7.1222051089564005, 2.410122844140494, -0.32993574021563665], [-7.358307868100445, 2.2738087610573885, -0.5016014873370465], [-7.469651096411474, 2.209524675052946, -0.597791357063161], [-6.611442414432476, 2.4151393082075923, -0.14110773606036797], [-6.996686011778227, 2.192718664148025, -0.3299354581589417], [-7.232788705532096, 2.0564046187740783, -0.5016010647020163], [-7.34413191054661, 1.992120546199293, -0.5977908586541971], [-6.360404503858186, 1.9803307846612714, -0.14110749399761124], [-6.745647817517658, 1.7579103042698372, -0.32993489405600696], [-6.981750380494455, 1.6215963343283635, -0.5016002194478121], [-7.093093538917164, 1.557312288619758, -0.5977898618551368], [-5.9838476379206, 1.3281179990290706, -0.14110713091549562], [-6.369090526070127, 1.1056977641978338, -0.32993404792968783], [-6.605192892890002, 0.9693839074423594, -0.5015989516090873], [-6.7165359814282315, 0.9050999020510813, -0.5977883667071976]],
    "act_locations_a": [[-6.711022354939664, 2.469132745936724, -1.1401352442088788], [-7.08560527702184, 2.188667573982846, -1.3005042357410113], [-7.317743973819396, 2.027631221942351, -1.4333290145696758], [-7.378337590659896, 1.9833303887097782, -1.4991393073411778], [-6.55636240841509, 2.2769722543396016, -1.0601387134380749], [-6.92408137699767, 2.009467283940116, -1.167316228872909], [-7.153705036180528, 1.850496415082969, -1.2577317149353604], [-7.265393589537658, 1.7771503548920295, -1.2996427164355104], [-6.305684302307734, 1.8285004705746841, -0.9599110900403799], [-6.700224907403363, 1.5546552920049321, -1.0212167954498284], [-6.9557722151941785, 1.3890719789593913, -1.0828128629750118], [-7.080292664698634, 1.3099312804790286, -1.1222623336365598], [-5.987039515181131, 1.13894710512742, -0.7131222126712982], [-6.404909087627447, 0.8530698813355098, -0.7643638110347886], [-6.673456421463042, 0.682869664838386, -0.8190969553510615], [-6.801271968722462, 0.6023424075431929, -0.853623412962136]],
    "ref_locations_b": [[-7.349517886409734, -0.0986620277906453, -1.394989211344196], [-6.62503375541969, 0.49413842654350865, -0.6883511723852459], [-6.137407946159692, 0.8970494013862456, -0.22773654806278656], [-5.892505400454348, 1.1003453463013342, 0.0], [-7.676770820555811, 0.46815950093325, -1.3949892113441966], [-6.965598665845105, 1.0840141294570615, -0.6883511723852458], [-6.487189978720082, 1.5028877509808458, -0.2277365480627867], [-6.246978340311884, 1.7143076519600084, 0.0], [-7.894939443319853, 0.8460405200825142, -1.3949892113441962], [-7.192641939462045, 1.4772645980661014, -0.6883511723852459], [-6.7203780004270115, 1.9067799840439081, -0.2277365480627866], [-6.483293633550243, 2.1236158557324596, 0.0], [-8.00402375470188, 1.034981029657147, -1.3949892113441962], [-7.3061635762705155, 1.6738898323706168, -0.6883511723852462], [-6.836972011280475, 2.108726100575444, -0.22773654806278662], [-6.601451280169422, 2.328269957618684, 0.0]],
    "act_locations_b": [[-7.667564471461738, -0.48762221960571334, -0.9288453306325286], [-6.774991858068435, 0.13233751580874098, -0.697231979532194], [-6.198790601648391, 0.6566395682705028, -0.5667346838296227], [-5.967689825635275, 0.9033332907832338, -0.3808021755509196], [-7.9278584842439335, 0.11140788476038671, -1.0998242028753853], [-7.015301332829905, 0.7643623059636866, -1.0018517389160426], [-6.462353886257032, 1.300765553865271, -0.88547421851169], [-6.249471976233697, 1.5437300760985297, -0.7351424444995099], [-8.082830625936179, 0.5240866356400729, -1.2218222849382363], [-7.163982298406642, 1.200191553383816, -1.1782449394558807], [-6.664889412160233, 1.7277655174598872, -1.0069790430383205], [-6.460647502870035, 1.9637438926732216, -0.8961156218770688], [-8.146676189038454, 0.7374367270866864, -1.2826367290515774], [-7.2423679041745395, 1.415847344167247, -1.252725922502769], [-6.766499319474197, 1.932526058652877, -1.1174829267993682], [-6.611316367195651, 2.144924707557423, -0.9123873256670663]],
    "shape_functions_a": [[1.7380685408631123e-46, 1.601092806744978e-31, 3.2775822581100916e-17, 0.0011182513815379198, 5.190808817047495e-44, 4.7817254974513175e-29, 9.788625985686166e-15, 0.3339700934970055, 8.469896855526275e-44, 7.80239133867568e-29, 1.5972203057026488e-14, 0.544942482847798, 1.8646491088203605e-44, 1.7176976655668289e-29, 3.5162829848099428e-15, 0.1199691722736291]],
    "shape_functions_b": [[0.00022476560078253386, 0.0010984712915976093, 0.0007450541028361326, 4.938074461949584e-06, 0.007494297066640858, 0.03662602350959424, 0.02484213223880236, 0.00016464884673722137, 0.05152778074853202, 0.2518258473491324, 0.1708045373628088, 0.0011320594312892568, 0.04916645450168299, 0.2402856068353306, 0.16297720167521085, 0.0010801813645597389]],
    "weight": 7.723727773252236,
    "exp_f": 8.216678476111157e-06,
    "exp_g": [-3.395623908743124e-49, -5.534450058415952e-49, -1.8473506551963e-48, -3.1280176166125476e-34, -5.098284658796431e-34, -1.7017624886654963e-33, -6.403335896629316e-20, -1.0436651313447329e-19, -3.4836622317395236e-19, -2.18470160287784e-06, -3.5607953762300377e-06, -1.188562115814133e-05, -1.014116193376823e-46, -1.6528848825759363e-46, -5.517184071699194e-46, -9.341945408049993e-32, -1.5226224016203957e-31, -5.082379390112476e-31, -1.9123809935731408e-17, -3.1169462184379656e-17, -1.0404091785211744e-16, -0.0006524695704580522, -0.0010634452899917343, -0.0035496866581066185, -1.654743963833033e-46, -2.697029492494357e-46, -9.002446760661937e-46, -1.524334970231996e-31, -2.4844788444691535e-31, -8.292971429333098e-31, -3.1204520017838974e-17, -5.085953635527757e-17, -1.6976465017699265e-16, -0.0010646413994288841, -0.0017352347649837946, -0.0057920607218013296, -3.642921407565852e-47, -5.9375146184461485e-47, -1.9818900531850695e-46, -3.355825805520029e-32, -5.469584036551524e-32, -1.8256989487527652e-31, -6.869679930572802e-18, -1.1196734831311293e-17, -3.737371411497085e-17, -0.0002343809695112257, -0.000382012203136811, -0.0012751230678911495, 4.3911930394941445e-07, 7.157105506109974e-07, 2.3889787434102473e-06, 2.1460577032045543e-06, 3.497810564439324e-06, 1.167538340714373e-05, 1.4555947969929819e-06, 2.372440801970212e-06, 7.918998317221268e-06, 9.647400727834966e-09, 1.5724078683817355e-08, 5.248558890641094e-08, 1.464143311981929e-05, 2.386373831820229e-05, 7.96550554296298e-05, 7.15554065834513e-05, 0.00011662652719757305, 0.0003892890696593818, 4.8533493467608475e-05, 7.910363543657558e-05, 0.0002640409637990166, 3.216706058382792e-07, 5.242835929763842e-07, 1.7500124290051034e-06, 0.00010066862161103307, 0.0001640774931880075, 0.0005476762123508738, 0.0004919862755663081, 0.0008018772233688449, 0.002676595503332469, 0.00033369683482271874, 0.0005438848696472425, 0.0018154397631004408, 2.211678067134808e-06, 3.6047637008134564e-06, 1.2032383550736323e-05, 9.605535368078132e-05, 0.00015655843287619553, 0.0005225782516738884, 0.00046944037724295904, 0.000765130177274778, 0.002553937101934168, 0.00031840475192858433, 0.0005189606520833279, 0.0017322449214071162, 2.1103250999850528e-06, 3.4395708084209e-06, 1.1480984234139173e-05],
    "exp_h": [[2.3332472155197488e-91, 0.0, 0.0, 2.1493659457591212e-76, 0.0, 0.0, 4.399947123819785e-62, 0.0, 0.0, 1.501181835400332e-48, 0.0, 0.0, 6.968332913187057e-89, 0.0, 0.0, 6.419164400022805e-74, 0.0, 0.0, 1.3140611999987457e-59, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 1.137030145202577e-88, 0.0, 0.0, 1.04742174645886e-73, 0.0, 0.0, 2.144167357750834e-59, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 2.5031736314126986e-89, 0.0, 0.0, 2.3059006023423706e-74, 0.0, 0.0, 4.720387769755642e-60, 0.0, 0.0, 1.6105103485542004e-46, 0.0, 0.0, -3.0173361972827643e-49, 0.0, 0.0, -1.4746283142411255e-48, 0.0, 0.0, -1.0001880650752106e-48, 0.0, 0.0, -6.629053007686009e-51, 0.0, 0.0, -1.0060620367902269e-47, 0.0, 0.0, -4.916812275244567e-47, 0.0, 0.0, -3.3348993155917235e-47, 0.0, 0.0, -2.2103067523297175e-49, 0.0, 0.0, -6.917279044341978e-47, 0.0, 0.0, -3.3806029124230076e-46, 0.0, 0.0, -2.292943010187652e-46, 0.0, 0.0, -1.5197182698829827e-48, 0.0, 0.0, -6.600285913124139e-47, 0.0, 0.0, -3.2256824739466007e-46, 0.0, 0.0, -2.1878659734158057e-46, 0.0, 0.0, -1.4500752426390248e-48, 0.0, 0.0], [0.0, 2.3332472155197488e-91, 0.0, 0.0, 2.1493659457591212e-76, 0.0, 0.0, 4.399947123819785e-62, 0.0, 0.0, 1.501181835400332e-48, 0.0, 0.0, 6.968332913187057e-89, 0.0, 0.0, 6.419164400022805e-74, 0.0, 0.0, 1.3140611999987457e-59, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 1.137030145202577e-88, 0.0, 0.0, 1.04742174645886e-73, 0.0, 0.0, 2.144167357750834e-59, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 2.5031736314126986e-89, 0.0, 0.0, 2.3059006023423706e-74, 0.0, 0.0, 4.720387769755642e-60, 0.0, 0.0, 1.6105103485542004e-46, 0.0, 0.0, -3.0173361972827643e-49, 0.0, 0.0, -1.4746283142411255e-48, 0.0, 0.0, -1.0001880650752106e-48, 0.0, 0.0, -6.629053007686009e-51, 0.0, 0.0, -1.0060620367902269e-47, 0.0, 0.0, -4.916812275244567e-47, 0.0, 0.0, -3.3348993155917235e-47, 0.0, 0.0, -2.2103067523297175e-49, 0.0, 0.0, -6.917279044341978e-47, 0.0, 0.0, -3.3806029124230076e-46, 0.0, 0.0, -2.292943010187652e-46, 0.0, 0.0, -1.5197182698829827e-48, 0.0, 0.0, -6.600285913124139e-47, 0.0, 0.0, -3.2256824739466007e-46, 0.0, 0.0, -2.1878659734158057e-46, 0.0, 0.0, -1.4500752426390248e-48, 0.0], [0.0, 0.0, 2.3332472155197488e-91, 0.0, 0.0, 2.1493659457591212e-76, 0.0, 0.0, 4.399947123819785e-62, 0.0, 0.0, 1.501181835400332e-48, 0.0, 0.0, 6.968332913187057e-89, 0.0, 0.0, 6.419164400022805e-74, 0.0, 0.0, 1.3140611999987457e-59, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 1.137030145202577e-88, 0.0, 0.0, 1.04742174645886e-73, 0.0, 0.0, 2.144167357750834e-59, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 2.5031736314126986e-89, 0.0, 0.0, 2.3059006023423706e-74, 0.0, 0.0, 4.720387769755642e-60, 0.0, 0.0, 1.6105103485542004e-46, 0.0, 0.0, -3.0173361972827643e-49, 0.0, 0.0, -1.4746283142411255e-48, 0.0, 0.0, -1.0001880650752106e-48, 0.0, 0.0, -6.629053007686009e-51, 0.0, 0.0, -1.0060620367902269e-47, 0.0, 0.0, -4.916812275244567e-47, 0.0, 0.0, -3.3348993155917235e-47, 0.0, 0.0, -2.2103067523297175e-49, 0.0, 0.0, -6.917279044341978e-47, 0.0, 0.0, -3.3806029124230076e-46, 0.0, 0.0, -2.292943010187652e-46, 0.0, 0.0, -1.5197182698829827e-48, 0.0, 0.0, -6.600285913124139e-47, 0.0, 0.0, -3.2256824739466007e-46, 0.0, 0.0, -2.1878659734158057e-46, 0.0, 0.0, -1.4500752426390248e-48], [2.1493659457591212e-76, 0.0, 0.0, 1.979976205718909e-61, 0.0, 0.0, 4.0531909555809315e-47, 0.0, 0.0, 1.3828749452435968e-33, 0.0, 0.0, 6.419164400022806e-74, 0.0, 0.0, 5.913275399994372e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 1.0474217464588602e-73, 0.0, 0.0, 9.64875310987878e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 2.305900602342371e-74, 0.0, 0.0, 2.124174496390045e-59, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 1.4835873693323828e-31, 0.0, 0.0, -2.7795424446274265e-34, 0.0, 0.0, -1.3584140849712838e-33, 0.0, 0.0, -9.213640766944996e-34, 0.0, 0.0, -6.106622861297822e-36, 0.0, 0.0, -9.267751255909176e-33, 0.0, 0.0, -4.529322394904041e-32, 0.0, 0.0, -3.0720786780716427e-32, 0.0, 0.0, -2.036114318079521e-34, 0.0, 0.0, -6.37213404406011e-32, 0.0, 0.0, -3.114180412501864e-31, 0.0, 0.0, -2.112238081281034e-31, 0.0, 0.0, -1.399950538763133e-33, 0.0, 0.0, -6.080122877499087e-32, 0.0, 0.0, -2.9714691247530063e-31, 0.0, 0.0, -2.015442078261536e-31, 0.0, 0.0, -1.3357960204925978e-33, 0.0, 0.0], [0.0, 2.1493659457591212e-76, 0.0, 0.0, 1.979976205718909e-61, 0.0, 0.0, 4.0531909555809315e-47, 0.0, 0.0, 1.3828749452435968e-33, 0.0, 0.0, 6.419164400022806e-74, 0.0, 0.0, 5.913275399994372e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 1.0474217464588602e-73, 0.0, 0.0, 9.64875310987878e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 2.305900602342371e-74, 0.0, 0.0, 2.124174496390045e-59, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 1.4835873693323828e-31, 0.0, 0.0, -2.7795424446274265e-34, 0.0, 0.0, -1.3584140849712838e-33, 0.0, 0.0, -9.213640766944996e-34, 0.0, 0.0, -6.106622861297822e-36, 0.0, 0.0, -9.267751255909176e-33, 0.0, 0.0, -4.529322394904041e-32, 0.0, 0.0, -3.0720786780716427e-32, 0.0, 0.0, -2.036114318079521e-34, 0.0, 0.0, -6.37213404406011e-32, 0.0, 0.0, -3.114180412501864e-31, 0.0, 0.0, -2.112238081281034e-31, 0.0, 0.0, -1.399950538763133e-33, 0.0, 0.0, -6.080122877499087e-32, 0.0, 0.0, -2.9714691247530063e-31, 0.0, 0.0, -2.015442078261536e-31, 0.0, 0.0, -1.3357960204925978e-33, 0.0], [0.0, 0.0, 2.1493659457591212e-76, 0.0, 0.0, 1.979976205718909e-61, 0.0, 0.0, 4.0531909555809315e-47, 0.0, 0.0, 1.3828749452435968e-33, 0.0, 0.0, 6.419164400022806e-74, 0.0, 0.0, 5.913275399994372e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 1.0474217464588602e-73, 0.0, 0.0, 9.64875310987878e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 2.305900602342371e-74, 0.0, 0.0, 2.124174496390045e-59, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 1.4835873693323828e-31, 0.0, 0.0, -2.7795424446274265e-34, 0.0, 0.0, -1.3584140849712838e-33, 0.0, 0.0, -9.213640766944996e-34, 0.0, 0.0, -6.106622861297822e-36, 0.0, 0.0, -9.267751255909176e-33, 0.0, 0.0, -4.529322394904041e-32, 0.0, 0.0, -3.0720786780716427e-32, 0.0, 0.0, -2.036114318079521e-34, 0.0, 0.0, -6.37213404406011e-32, 0.0, 0.0, -3.114180412501864e-31, 0.0, 0.0, -2.112238081281034e-31, 0.0, 0.0, -1.399950538763133e-33, 0.0, 0.0, -6.080122877499087e-32, 0.0, 0.0, -2.9714691247530063e-31, 0.0, 0.0, -2.015442078261536e-31, 0.0, 0.0, -1.3357960204925978e-33], [4.399947123819785e-62, 0.0, 0.0, 4.0531909555809315e-47, 0.0, 0.0, 8.297249671461632e-33, 0.0, 0.0, 2.830870494590457e-19, 0.0, 0.0, 1.314061199998746e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 2.4780056562372097e-30, 0.0, 0.0, 8.454504053069482e-17, 0.0, 0.0, 2.1441673577508345e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 4.0433876598980554e-30, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 4.7203877697556426e-60, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 8.901524215994349e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, -5.689975599038385e-20, 0.0, 0.0, -2.7807968940415695e-19, 0.0, 0.0, -1.886115869306306e-19, 0.0, 0.0, -1.2500811110287632e-21, 0.0, 0.0, -1.8971927773943022e-18, 0.0, 0.0, -9.271933931786593e-18, 0.0, 0.0, -6.288823813552807e-18, 0.0, 0.0, -4.168110765539356e-20, 0.0, 0.0, -1.3044336593810779e-17, 0.0, 0.0, -6.375009884230805e-17, 0.0, 0.0, -4.3239430162613425e-17, 0.0, 0.0, -2.8658257839594164e-19, 0.0, 0.0, -1.2446563238850672e-17, 0.0, 0.0, -6.08286692862748e-17, 0.0, 0.0, -4.125792814838814e-17, 0.0, 0.0, -2.734495663697001e-19, 0.0, 0.0], [0.0, 4.399947123819785e-62, 0.0, 0.0, 4.0531909555809315e-47, 0.0, 0.0, 8.297249671461632e-33, 0.0, 0.0, 2.830870494590457e-19, 0.0, 0.0, 1.314061199998746e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 2.4780056562372097e-30, 0.0, 0.0, 8.454504053069482e-17, 0.0, 0.0, 2.1441673577508345e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 4.0433876598980554e-30, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 4.7203877697556426e-60, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 8.901524215994349e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, -5.689975599038385e-20, 0.0, 0.0, -2.7807968940415695e-19, 0.0, 0.0, -1.886115869306306e-19, 0.0, 0.0, -1.2500811110287632e-21, 0.0, 0.0, -1.8971927773943022e-18, 0.0, 0.0, -9.271933931786593e-18, 0.0, 0.0, -6.288823813552807e-18, 0.0, 0.0, -4.168110765539356e-20, 0.0, 0.0, -1.3044336593810779e-17, 0.0, 0.0, -6.375009884230805e-17, 0.0, 0.0, -4.3239430162613425e-17, 0.0, 0.0, -2.8658257839594164e-19, 0.0, 0.0, -1.2446563238850672e-17, 0.0, 0.0, -6.08286692862748e-17, 0.0, 0.0, -4.125792814838814e-17, 0.0, 0.0, -2.734495663697001e-19, 0.0], [0.0, 0.0, 4.399947123819785e-62, 0.0, 0.0, 4.0531909555809315e-47, 0.0, 0.0, 8.297249671461632e-33, 0.0, 0.0, 2.830870494590457e-19, 0.0, 0.0, 1.314061199998746e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 2.4780056562372097e-30, 0.0, 0.0, 8.454504053069482e-17, 0.0, 0.0, 2.1441673577508345e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 4.0433876598980554e-30, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 4.7203877697556426e-60, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 8.901524215994349e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, -5.689975599038385e-20, 0.0, 0.0, -2.7807968940415695e-19, 0.0, 0.0, -1.886115869306306e-19, 0.0, 0.0, -1.2500811110287632e-21, 0.0, 0.0, -1.8971927773943022e-18, 0.0, 0.0, -9.271933931786593e-18, 0.0, 0.0, -6.288823813552807e-18, 0.0, 0.0, -4.168110765539356e-20, 0.0, 0.0, -1.3044336593810779e-17, 0.0, 0.0, -6.375009884230805e-17, 0.0, 0.0, -4.3239430162613425e-17, 0.0, 0.0, -2.8658257839594164e-19, 0.0, 0.0, -1.2446563238850672e-17, 0.0, 0.0, -6.08286692862748e-17, 0.0, 0.0, -4.125792814838814e-17, 0.0, 0.0, -2.734495663697001e-19], [1.501181835400332e-48, 0.0, 0.0, 1.3828749452435968e-33, 0.0, 0.0, 2.830870494590457e-19, 0.0, 0.0, 9.658414624675396e-06, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 8.45450405306948e-17, 0.0, 0.0, 0.0028845228259852655, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 0.0047067059632920445, 0.0, 0.0, 1.6105103485542006e-46, 0.0, 0.0, 1.4835873693323826e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 0.0010361820491598737, 0.0, 0.0, -1.9413160596648568e-06, 0.0, 0.0, -9.487572618029139e-06, 0.0, 0.0, -6.4350838834737384e-06, 0.0, 0.0, -4.2650491104635994e-08, 0.0, 0.0, -6.472876276759734e-05, 0.0, 0.0, -0.00031634150151664656, 0.0, 0.0, -0.00021456321654026293, 0.0, 0.0, -1.422083491706191e-06, 0.0, 0.0, -0.0004450490107816718, 0.0, 0.0, -0.0021750372832655043, 0.0, 0.0, -0.0014752506179398148, 0.0, 0.0, -9.777675706627422e-06, 0.0, 0.0, -0.0004246540724585635, 0.0, 0.0, -0.0020753634267508055, 0.0, 0.0, -0.0014076453775390668, 0.0, 0.0, -9.329601251569599e-06, 0.0, 0.0], [0.0, 1.501181835400332e-48, 0.0, 0.0, 1.3828749452435968e-33, 0.0, 0.0, 2.830870494590457e-19, 0.0, 0.0, 9.658414624675396e-06, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 8.45450405306948e-17, 0.0, 0.0, 0.0028845228259852655, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 0.0047067059632920445, 0.0, 0.0, 1.6105103485542006e-46, 0.0, 0.0, 1.4835873693323826e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 0.0010361820491598737, 0.0, 0.0, -1.9413160596648568e-06, 0.0, 0.0, -9.487572618029139e-06, 0.0, 0.0, -6.4350838834737384e-06, 0.0, 0.0, -4.2650491104635994e-08, 0.0, 0.0, -6.472876276759734e-05, 0.0, 0.0, -0.00031634150151664656, 0.0, 0.0, -0.00021456321654026293, 0.0, 0.0, -1.422083491706191e-06, 0.0, 0.0, -0.0004450490107816718, 0.0, 0.0, -0.0021750372832655043, 0.0, 0.0, -0.0014752506179398148, 0.0, 0.0, -9.777675706627422e-06, 0.0, 0.0, -0.0004246540724585635, 0.0, 0.0, -0.0020753634267508055, 0.0, 0.0, -0.0014076453775390668, 0.0, 0.0, -9.329601251569599e-06, 0.0], [0.0, 0.0, 1.501181835400332e-48, 0.0, 0.0, 1.3828749452435968e-33, 0.0, 0.0, 2.830870494590457e-19, 0.0, 0.0, 9.658414624675396e-06, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 8.45450405306948e-17, 0.0, 0.0, 0.0028845228259852655, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 0.0047067059632920445, 0.0, 0.0, 1.6105103485542006e-46, 0.0, 0.0, 1.4835873693323826e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 0.0010361820491598737, 0.0, 0.0, -1.9413160596648568e-06, 0.0, 0.0, -9.487572618029139e-06, 0.0, 0.0, -6.4350838834737384e-06, 0.0, 0.0, -4.2650491104635994e-08, 0.0, 0.0, -6.472876276759734e-05, 0.0, 0.0, -0.00031634150151664656, 0.0, 0.0, -0.00021456321654026293, 0.0, 0.0, -1.422083491706191e-06, 0.0, 0.0, -0.0004450490107816718, 0.0, 0.0, -0.0021750372832655043, 0.0, 0.0, -0.0014752506179398148, 0.0, 0.0, -9.777675706627422e-06, 0.0, 0.0, -0.0004246540724585635, 0.0, 0.0, -0.0020753634267508055, 0.0, 0.0, -0.0014076453775390668, 0.0, 0.0, -9.329601251569599e-06], [6.968332913187057e-89, 0.0, 0.0, 6.419164400022806e-74, 0.0, 0.0, 1.314061199998746e-59, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 2.0811195344420212e-86, 0.0, 0.0, 1.9171082372372367e-71, 0.0, 0.0, 3.924494519477478e-57, 0.0, 0.0, 1.3389660648133384e-43, 0.0, 0.0, 3.395784437842357e-86, 0.0, 0.0, 3.1281654945471705e-71, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 2.184804885275958e-43, 0.0, 0.0, 7.475824716374738e-87, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, -9.011391074988384e-47, 0.0, 0.0, -4.40403440685345e-46, 0.0, 0.0, -2.9871002810509842e-46, 0.0, 0.0, -1.9797922804519503e-48, 0.0, 0.0, -3.004643124415638e-45, 0.0, 0.0, -1.46842497347272e-44, 0.0, 0.0, -9.959805591293163e-45, 0.0, 0.0, -6.601166472223911e-47, 0.0, 0.0, -2.06587209935446e-44, 0.0, 0.0, -1.009630114818576e-43, 0.0, 0.0, -6.847962847517468e-44, 0.0, 0.0, -4.53869730063657e-46, 0.0, 0.0, -1.971200876569889e-44, 0.0, 0.0, -9.633625276045034e-44, 0.0, 0.0, -6.534146219392052e-44, 0.0, 0.0, -4.330705710336976e-46, 0.0, 0.0], [0.0, 6.968332913187057e-89, 0.0, 0.0, 6.419164400022806e-74, 0.0, 0.0, 1.314061199998746e-59, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 2.0811195344420212e-86, 0.0, 0.0, 1.9171082372372367e-71, 0.0, 0.0, 3.924494519477478e-57, 0.0, 0.0, 1.3389660648133384e-43, 0.0, 0.0, 3.395784437842357e-86, 0.0, 0.0, 3.1281654945471705e-71, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 2.184804885275958e-43, 0.0, 0.0, 7.475824716374738e-87, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, -9.011391074988384e-47, 0.0, 0.0, -4.40403440685345e-46, 0.0, 0.0, -2.9871002810509842e-46, 0.0, 0.0, -1.9797922804519503e-48, 0.0, 0.0, -3.004643124415638e-45, 0.0, 0.0, -1.46842497347272e-44, 0.0, 0.0, -9.959805591293163e-45, 0.0, 0.0, -6.601166472223911e-47, 0.0, 0.0, -2.06587209935446e-44, 0.0, 0.0, -1.009630114818576e-43, 0.0, 0.0, -6.847962847517468e-44, 0.0, 0.0, -4.53869730063657e-46, 0.0, 0.0, -1.971200876569889e-44, 0.0, 0.0, -9.633625276045034e-44, 0.0, 0.0, -6.534146219392052e-44, 0.0, 0.0, -4.330705710336976e-46, 0.0], [0.0, 0.0, 6.968332913187057e-89, 0.0, 0.0, 6.419164400022806e-74, 0.0, 0.0, 1.314061199998746e-59, 0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 2.0811195344420212e-86, 0.0, 0.0, 1.9171082372372367e-71, 0.0, 0.0, 3.924494519477478e-57, 0.0, 0.0, 1.3389660648133384e-43, 0.0, 0.0, 3.395784437842357e-86, 0.0, 0.0, 3.1281654945471705e-71, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 2.184804885275958e-43, 0.0, 0.0, 7.475824716374738e-87, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, -9.011391074988384e-47, 0.0, 0.0, -4.40403440685345e-46, 0.0, 0.0, -2.9871002810509842e-46, 0.0, 0.0, -1.9797922804519503e-48, 0.0, 0.0, -3.004643124415638e-45, 0.0, 0.0, -1.46842497347272e-44, 0.0, 0.0, -9.959805591293163e-45, 0.0, 0.0, -6.601166472223911e-47, 0.0, 0.0, -2.06587209935446e-44, 0.0, 0.0, -1.009630114818576e-43, 0.0, 0.0, -6.847962847517468e-44, 0.0, 0.0, -4.53869730063657e-46, 0.0, 0.0, -1.971200876569889e-44, 0.0, 0.0, -9.633625276045034e-44, 0.0, 0.0, -6.534146219392052e-44, 0.0, 0.0, -4.330705710336976e-46], [6.419164400022805e-74, 0.0, 0.0, 5.913275399994372e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 1.9171082372372367e-71, 0.0, 0.0, 1.76602253376487e-56, 0.0, 0.0, 3.6152083749960443e-42, 0.0, 0.0, 1.2334432644317154e-28, 0.0, 0.0, 3.12816549454717e-71, 0.0, 0.0, 2.881637377280958e-56, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 6.343929163652742e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, -8.301210849696938e-32, 0.0, 0.0, -4.056956123242893e-31, 0.0, 0.0, -2.751689395771248e-31, 0.0, 0.0, -1.8237664997415684e-33, 0.0, 0.0, -2.7678497022612632e-30, 0.0, 0.0, -1.3526996243222522e-29, 0.0, 0.0, -9.174881607878905e-30, 0.0, 0.0, -6.080934040469598e-32, 0.0, 0.0, -1.9030624398097764e-29, 0.0, 0.0, -9.300620063616017e-29, 0.0, 0.0, -6.308280598975872e-29, 0.0, 0.0, -4.181006346523816e-31, 0.0, 0.0, -1.8158521772439193e-29, 0.0, 0.0, -8.87440729160928e-29, 0.0, 0.0, -6.019195597944178e-29, 0.0, 0.0, -3.98940640022552e-31, 0.0, 0.0], [0.0, 6.419164400022805e-74, 0.0, 0.0, 5.913275399994372e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 1.9171082372372367e-71, 0.0, 0.0, 1.76602253376487e-56, 0.0, 0.0, 3.6152083749960443e-42, 0.0, 0.0, 1.2334432644317154e-28, 0.0, 0.0, 3.12816549454717e-71, 0.0, 0.0, 2.881637377280958e-56, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 6.343929163652742e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, -8.301210849696938e-32, 0.0, 0.0, -4.056956123242893e-31, 0.0, 0.0, -2.751689395771248e-31, 0.0, 0.0, -1.8237664997415684e-33, 0.0, 0.0, -2.7678497022612632e-30, 0.0, 0.0, -1.3526996243222522e-29, 0.0, 0.0, -9.174881607878905e-30, 0.0, 0.0, -6.080934040469598e-32, 0.0, 0.0, -1.9030624398097764e-29, 0.0, 0.0, -9.300620063616017e-29, 0.0, 0.0, -6.308280598975872e-29, 0.0, 0.0, -4.181006346523816e-31, 0.0, 0.0, -1.8158521772439193e-29, 0.0, 0.0, -8.87440729160928e-29, 0.0, 0.0, -6.019195597944178e-29, 0.0, 0.0, -3.98940640022552e-31, 0.0], [0.0, 0.0, 6.419164400022805e-74, 0.0, 0.0, 5.913275399994372e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 1.9171082372372367e-71, 0.0, 0.0, 1.76602253376487e-56, 0.0, 0.0, 3.6152083749960443e-42, 0.0, 0.0, 1.2334432644317154e-28, 0.0, 0.0, 3.12816549454717e-71, 0.0, 0.0, 2.881637377280958e-56, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 6.343929163652742e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, -8.301210849696938e-32, 0.0, 0.0, -4.056956123242893e-31, 0.0, 0.0, -2.751689395771248e-31, 0.0, 0.0, -1.8237664997415684e-33, 0.0, 0.0, -2.7678497022612632e-30, 0.0, 0.0, -1.3526996243222522e-29, 0.0, 0.0, -9.174881607878905e-30, 0.0, 0.0, -6.080934040469598e-32, 0.0, 0.0, -1.9030624398097764e-29, 0.0, 0.0, -9.300620063616017e-29, 0.0, 0.0, -6.308280598975872e-29, 0.0, 0.0, -4.181006346523816e-31, 0.0, 0.0, -1.8158521772439193e-29, 0.0, 0.0, -8.87440729160928e-29, 0.0, 0.0, -6.019195597944178e-29, 0.0, 0.0, -3.98940640022552e-31], [1.3140611999987457e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 2.4780056562372097e-30, 0.0, 0.0, 8.45450405306948e-17, 0.0, 0.0, 3.924494519477478e-57, 0.0, 0.0, 3.6152083749960443e-42, 0.0, 0.0, 7.400659586590336e-28, 0.0, 0.0, 2.524970284580579e-14, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 1.2075733391571053e-27, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 2.6584745825155794e-28, 0.0, 0.0, 9.070231166053729e-15, 0.0, 0.0, -1.699333185882669e-17, 0.0, 0.0, -8.304957311315902e-17, 0.0, 0.0, -5.632957880652106e-17, 0.0, 0.0, -3.7334155130212956e-19, 0.0, 0.0, -5.666039494418751e-16, 0.0, 0.0, -2.7690988745644776e-15, 0.0, 0.0, -1.878181517745977e-15, 0.0, 0.0, -1.2448223763056004e-17, 0.0, 0.0, -3.895741497631827e-15, 0.0, 0.0, -1.9039213205825135e-14, 0.0, 0.0, -1.2913622797680007e-14, 0.0, 0.0, -8.558899374653714e-17, 0.0, 0.0, -3.7172141767252494e-15, 0.0, 0.0, -1.816671698710237e-14, 0.0, 0.0, -1.232183956907786e-14, 0.0, 0.0, -8.166676898856804e-17, 0.0, 0.0], [0.0, 1.3140611999987457e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 2.4780056562372097e-30, 0.0, 0.0, 8.45450405306948e-17, 0.0, 0.0, 3.924494519477478e-57, 0.0, 0.0, 3.6152083749960443e-42, 0.0, 0.0, 7.400659586590336e-28, 0.0, 0.0, 2.524970284580579e-14, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 1.2075733391571053e-27, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 2.6584745825155794e-28, 0.0, 0.0, 9.070231166053729e-15, 0.0, 0.0, -1.699333185882669e-17, 0.0, 0.0, -8.304957311315902e-17, 0.0, 0.0, -5.632957880652106e-17, 0.0, 0.0, -3.7334155130212956e-19, 0.0, 0.0, -5.666039494418751e-16, 0.0, 0.0, -2.7690988745644776e-15, 0.0, 0.0, -1.878181517745977e-15, 0.0, 0.0, -1.2448223763056004e-17, 0.0, 0.0, -3.895741497631827e-15, 0.0, 0.0, -1.9039213205825135e-14, 0.0, 0.0, -1.2913622797680007e-14, 0.0, 0.0, -8.558899374653714e-17, 0.0, 0.0, -3.7172141767252494e-15, 0.0, 0.0, -1.816671698710237e-14, 0.0, 0.0, -1.232183956907786e-14, 0.0, 0.0, -8.166676898856804e-17, 0.0], [0.0, 0.0, 1.3140611999987457e-59, 0.0, 0.0, 1.2105011312706157e-44, 0.0, 0.0, 2.4780056562372097e-30, 0.0, 0.0, 8.45450405306948e-17, 0.0, 0.0, 3.924494519477478e-57, 0.0, 0.0, 3.6152083749960443e-42, 0.0, 0.0, 7.400659586590336e-28, 0.0, 0.0, 2.524970284580579e-14, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 1.2075733391571053e-27, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 2.6584745825155794e-28, 0.0, 0.0, 9.070231166053729e-15, 0.0, 0.0, -1.699333185882669e-17, 0.0, 0.0, -8.304957311315902e-17, 0.0, 0.0, -5.632957880652106e-17, 0.0, 0.0, -3.7334155130212956e-19, 0.0, 0.0, -5.666039494418751e-16, 0.0, 0.0, -2.7690988745644776e-15, 0.0, 0.0, -1.878181517745977e-15, 0.0, 0.0, -1.2448223763056004e-17, 0.0, 0.0, -3.895741497631827e-15, 0.0, 0.0, -1.9039213205825135e-14, 0.0, 0.0, -1.2913622797680007e-14, 0.0, 0.0, -8.558899374653714e-17, 0.0, 0.0, -3.7172141767252494e-15, 0.0, 0.0, -1.816671698710237e-14, 0.0, 0.0, -1.232183956907786e-14, 0.0, 0.0, -8.166676898856804e-17], [4.483337523224464e-46, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 8.454504053069482e-17, 0.0, 0.0, 0.0028845228259852655, 0.0, 0.0, 1.3389660648133384e-43, 0.0, 0.0, 1.2334432644317154e-28, 0.0, 0.0, 2.524970284580579e-14, 0.0, 0.0, 0.8614738812695837, 0.0, 0.0, 2.1848048852759578e-43, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.405675912031283, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 9.07023116605373e-15, 0.0, 0.0, 0.3094597704515397, 0.0, 0.0, -0.0005797815380848027, 0.0, 0.0, -0.0028335002009522445, 0.0, 0.0, -0.0019218626524468293, 0.0, 0.0, -1.27377338736831e-05, 0.0, 0.0, -0.01933149496646245, 0.0, 0.0, -0.09447661105788227, 0.0, 0.0, -0.064080133207991, 0.0, 0.0, -0.00042471072652062693, 0.0, 0.0, -0.13291560573535016, 0.0, 0.0, -0.6495832840846989, 0.0, 0.0, -0.44058929408813613, 0.0, 0.0, -0.0029201406086660207, 0.0, 0.0, -0.12682457864512056, 0.0, 0.0, -0.6198153019216538, 0.0, 0.0, -0.4203987279683127, 0.0, 0.0, -0.0027863214423141064, 0.0, 0.0], [0.0, 4.483337523224464e-46, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 8.454504053069482e-17, 0.0, 0.0, 0.0028845228259852655, 0.0, 0.0, 1.3389660648133384e-43, 0.0, 0.0, 1.2334432644317154e-28, 0.0, 0.0, 2.524970284580579e-14, 0.0, 0.0, 0.8614738812695837, 0.0, 0.0, 2.1848048852759578e-43, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.405675912031283, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 9.07023116605373e-15, 0.0, 0.0, 0.3094597704515397, 0.0, 0.0, -0.0005797815380848027, 0.0, 0.0, -0.0028335002009522445, 0.0, 0.0, -0.0019218626524468293, 0.0, 0.0, -1.27377338736831e-05, 0.0, 0.0, -0.01933149496646245, 0.0, 0.0, -0.09447661105788227, 0.0, 0.0, -0.064080133207991, 0.0, 0.0, -0.00042471072652062693, 0.0, 0.0, -0.13291560573535016, 0.0, 0.0, -0.6495832840846989, 0.0, 0.0, -0.44058929408813613, 0.0, 0.0, -0.0029201406086660207, 0.0, 0.0, -0.12682457864512056, 0.0, 0.0, -0.6198153019216538, 0.0, 0.0, -0.4203987279683127, 0.0, 0.0, -0.0027863214423141064, 0.0], [0.0, 0.0, 4.483337523224464e-46, 0.0, 0.0, 4.130009427061992e-31, 0.0, 0.0, 8.454504053069482e-17, 0.0, 0.0, 0.0028845228259852655, 0.0, 0.0, 1.3389660648133384e-43, 0.0, 0.0, 1.2334432644317154e-28, 0.0, 0.0, 2.524970284580579e-14, 0.0, 0.0, 0.8614738812695837, 0.0, 0.0, 2.1848048852759578e-43, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.405675912031283, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 9.07023116605373e-15, 0.0, 0.0, 0.3094597704515397, 0.0, 0.0, -0.0005797815380848027, 0.0, 0.0, -0.0028335002009522445, 0.0, 0.0, -0.0019218626524468293, 0.0, 0.0, -1.27377338736831e-05, 0.0, 0.0, -0.01933149496646245, 0.0, 0.0, -0.09447661105788227, 0.0, 0.0, -0.064080133207991, 0.0, 0.0, -0.00042471072652062693, 0.0, 0.0, -0.13291560573535016, 0.0, 0.0, -0.6495832840846989, 0.0, 0.0, -0.44058929408813613, 0.0, 0.0, -0.0029201406086660207, 0.0, 0.0, -0.12682457864512056, 0.0, 0.0, -0.6198153019216538, 0.0, 0.0, -0.4203987279683127, 0.0, 0.0, -0.0027863214423141064], [1.137030145202577e-88, 0.0, 0.0, 1.0474217464588602e-73, 0.0, 0.0, 2.1441673577508345e-59, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 3.395784437842357e-86, 0.0, 0.0, 3.12816549454717e-71, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 2.1848048852759578e-43, 0.0, 0.0, 5.540936864726543e-86, 0.0, 0.0, 5.104260245304359e-71, 0.0, 0.0, 1.0448883881252068e-56, 0.0, 0.0, 3.5649689056093708e-43, 0.0, 0.0, 1.2198381117358082e-86, 0.0, 0.0, 1.1237036861179803e-71, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, -1.4703980751380325e-46, 0.0, 0.0, -7.186108849112763e-46, 0.0, 0.0, -4.874082665985401e-46, 0.0, 0.0, -3.2304477012761726e-48, 0.0, 0.0, -4.902707506369291e-45, 0.0, 0.0, -2.396044336009119e-44, 0.0, 0.0, -1.6251518603863676e-44, 0.0, 0.0, -1.0771192142980286e-46, 0.0, 0.0, -3.3709050390714297e-44, 0.0, 0.0, -1.6474239826868668e-43, 0.0, 0.0, -1.117389236114073e-43, 0.0, 0.0, -7.405839696618428e-46, 0.0, 0.0, -3.2164290180054186e-44, 0.0, 0.0, -1.5719286783384859e-43, 0.0, 0.0, -1.0661834497818542e-43, 0.0, 0.0, -7.066457650631908e-46, 0.0, 0.0], [0.0, 1.137030145202577e-88, 0.0, 0.0, 1.0474217464588602e-73, 0.0, 0.0, 2.1441673577508345e-59, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 3.395784437842357e-86, 0.0, 0.0, 3.12816549454717e-71, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 2.1848048852759578e-43, 0.0, 0.0, 5.540936864726543e-86, 0.0, 0.0, 5.104260245304359e-71, 0.0, 0.0, 1.0448883881252068e-56, 0.0, 0.0, 3.5649689056093708e-43, 0.0, 0.0, 1.2198381117358082e-86, 0.0, 0.0, 1.1237036861179803e-71, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, -1.4703980751380325e-46, 0.0, 0.0, -7.186108849112763e-46, 0.0, 0.0, -4.874082665985401e-46, 0.0, 0.0, -3.2304477012761726e-48, 0.0, 0.0, -4.902707506369291e-45, 0.0, 0.0, -2.396044336009119e-44, 0.0, 0.0, -1.6251518603863676e-44, 0.0, 0.0, -1.0771192142980286e-46, 0.0, 0.0, -3.3709050390714297e-44, 0.0, 0.0, -1.6474239826868668e-43, 0.0, 0.0, -1.117389236114073e-43, 0.0, 0.0, -7.405839696618428e-46, 0.0, 0.0, -3.2164290180054186e-44, 0.0, 0.0, -1.5719286783384859e-43, 0.0, 0.0, -1.0661834497818542e-43, 0.0, 0.0, -7.066457650631908e-46, 0.0], [0.0, 0.0, 1.137030145202577e-88, 0.0, 0.0, 1.0474217464588602e-73, 0.0, 0.0, 2.1441673577508345e-59, 0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 3.395784437842357e-86, 0.0, 0.0, 3.12816549454717e-71, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 2.1848048852759578e-43, 0.0, 0.0, 5.540936864726543e-86, 0.0, 0.0, 5.104260245304359e-71, 0.0, 0.0, 1.0448883881252068e-56, 0.0, 0.0, 3.5649689056093708e-43, 0.0, 0.0, 1.2198381117358082e-86, 0.0, 0.0, 1.1237036861179803e-71, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, -1.4703980751380325e-46, 0.0, 0.0, -7.186108849112763e-46, 0.0, 0.0, -4.874082665985401e-46, 0.0, 0.0, -3.2304477012761726e-48, 0.0, 0.0, -4.902707506369291e-45, 0.0, 0.0, -2.396044336009119e-44, 0.0, 0.0, -1.6251518603863676e-44, 0.0, 0.0, -1.0771192142980286e-46, 0.0, 0.0, -3.3709050390714297e-44, 0.0, 0.0, -1.6474239826868668e-43, 0.0, 0.0, -1.117389236114073e-43, 0.0, 0.0, -7.405839696618428e-46, 0.0, 0.0, -3.2164290180054186e-44, 0.0, 0.0, -1.5719286783384859e-43, 0.0, 0.0, -1.0661834497818542e-43, 0.0, 0.0, -7.066457650631908e-46], [1.04742174645886e-73, 0.0, 0.0, 9.64875310987878e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 3.1281654945471705e-71, 0.0, 0.0, 2.881637377280958e-56, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 5.104260245304359e-71, 0.0, 0.0, 4.701997746563443e-56, 0.0, 0.0, 9.625416045145385e-42, 0.0, 0.0, 3.284016675318342e-28, 0.0, 0.0, 1.1237036861179805e-71, 0.0, 0.0, 1.0351455345154963e-56, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, -1.354517227488661e-31, 0.0, 0.0, -6.619777595817519e-31, 0.0, 0.0, -4.489960270562329e-31, 0.0, 0.0, -2.9758588084855554e-33, 0.0, 0.0, -4.51632921111637e-30, 0.0, 0.0, -2.207214077484639e-29, 0.0, 0.0, -1.4970749958115508e-29, 0.0, 0.0, -9.922323461208083e-32, 0.0, 0.0, -3.105246820472044e-29, 0.0, 0.0, -1.5175918707033575e-28, 0.0, 0.0, -1.029328721057273e-28, 0.0, 0.0, -6.822191638238763e-31, 0.0, 0.0, -2.962944925967611e-29, 0.0, 0.0, -1.4480462884128052e-28, 0.0, 0.0, -9.821584200980699e-29, 0.0, 0.0, -6.509556008634898e-31, 0.0, 0.0], [0.0, 1.04742174645886e-73, 0.0, 0.0, 9.64875310987878e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 3.1281654945471705e-71, 0.0, 0.0, 2.881637377280958e-56, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 5.104260245304359e-71, 0.0, 0.0, 4.701997746563443e-56, 0.0, 0.0, 9.625416045145385e-42, 0.0, 0.0, 3.284016675318342e-28, 0.0, 0.0, 1.1237036861179805e-71, 0.0, 0.0, 1.0351455345154963e-56, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, -1.354517227488661e-31, 0.0, 0.0, -6.619777595817519e-31, 0.0, 0.0, -4.489960270562329e-31, 0.0, 0.0, -2.9758588084855554e-33, 0.0, 0.0, -4.51632921111637e-30, 0.0, 0.0, -2.207214077484639e-29, 0.0, 0.0, -1.4970749958115508e-29, 0.0, 0.0, -9.922323461208083e-32, 0.0, 0.0, -3.105246820472044e-29, 0.0, 0.0, -1.5175918707033575e-28, 0.0, 0.0, -1.029328721057273e-28, 0.0, 0.0, -6.822191638238763e-31, 0.0, 0.0, -2.962944925967611e-29, 0.0, 0.0, -1.4480462884128052e-28, 0.0, 0.0, -9.821584200980699e-29, 0.0, 0.0, -6.509556008634898e-31, 0.0], [0.0, 0.0, 1.04742174645886e-73, 0.0, 0.0, 9.64875310987878e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 3.1281654945471705e-71, 0.0, 0.0, 2.881637377280958e-56, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 5.104260245304359e-71, 0.0, 0.0, 4.701997746563443e-56, 0.0, 0.0, 9.625416045145385e-42, 0.0, 0.0, 3.284016675318342e-28, 0.0, 0.0, 1.1237036861179805e-71, 0.0, 0.0, 1.0351455345154963e-56, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, -1.354517227488661e-31, 0.0, 0.0, -6.619777595817519e-31, 0.0, 0.0, -4.489960270562329e-31, 0.0, 0.0, -2.9758588084855554e-33, 0.0, 0.0, -4.51632921111637e-30, 0.0, 0.0, -2.207214077484639e-29, 0.0, 0.0, -1.4970749958115508e-29, 0.0, 0.0, -9.922323461208083e-32, 0.0, 0.0, -3.105246820472044e-29, 0.0, 0.0, -1.5175918707033575e-28, 0.0, 0.0, -1.029328721057273e-28, 0.0, 0.0, -6.822191638238763e-31, 0.0, 0.0, -2.962944925967611e-29, 0.0, 0.0, -1.4480462884128052e-28, 0.0, 0.0, -9.821584200980699e-29, 0.0, 0.0, -6.509556008634898e-31], [2.144167357750834e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 4.0433876598980554e-30, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 1.2075733391571053e-27, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.0448883881252068e-56, 0.0, 0.0, 9.625416045145385e-42, 0.0, 0.0, 1.9704100051910166e-27, 0.0, 0.0, 6.722680125110023e-14, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 4.337860688106173e-28, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, -2.7728196731749085e-17, 0.0, 0.0, -1.3551285415363216e-16, 0.0, 0.0, -9.191356091551209e-17, 0.0, 0.0, -6.091853009546654e-19, 0.0, 0.0, -9.245335705575452e-16, 0.0, 0.0, -4.518367498584839e-15, 0.0, 0.0, -3.0646483605829675e-15, 0.0, 0.0, -2.0311896473884482e-17, 0.0, 0.0, -6.356722010714178e-15, 0.0, 0.0, -3.106648265181852e-14, 0.0, 0.0, -2.107129292997838e-14, 0.0, 0.0, -1.396564532719179e-16, 0.0, 0.0, -6.065417120230418e-15, 0.0, 0.0, -2.9642821476868554e-14, 0.0, 0.0, -2.010567406714738e-14, 0.0, 0.0, -1.3325651824925112e-16, 0.0, 0.0], [0.0, 2.144167357750834e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 4.0433876598980554e-30, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 1.2075733391571053e-27, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.0448883881252068e-56, 0.0, 0.0, 9.625416045145385e-42, 0.0, 0.0, 1.9704100051910166e-27, 0.0, 0.0, 6.722680125110023e-14, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 4.337860688106173e-28, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, -2.7728196731749085e-17, 0.0, 0.0, -1.3551285415363216e-16, 0.0, 0.0, -9.191356091551209e-17, 0.0, 0.0, -6.091853009546654e-19, 0.0, 0.0, -9.245335705575452e-16, 0.0, 0.0, -4.518367498584839e-15, 0.0, 0.0, -3.0646483605829675e-15, 0.0, 0.0, -2.0311896473884482e-17, 0.0, 0.0, -6.356722010714178e-15, 0.0, 0.0, -3.106648265181852e-14, 0.0, 0.0, -2.107129292997838e-14, 0.0, 0.0, -1.396564532719179e-16, 0.0, 0.0, -6.065417120230418e-15, 0.0, 0.0, -2.9642821476868554e-14, 0.0, 0.0, -2.010567406714738e-14, 0.0, 0.0, -1.3325651824925112e-16, 0.0], [0.0, 0.0, 2.144167357750834e-59, 0.0, 0.0, 1.9751873141018005e-44, 0.0, 0.0, 4.0433876598980554e-30, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 6.403638616179889e-57, 0.0, 0.0, 5.898973190245137e-42, 0.0, 0.0, 1.2075733391571053e-27, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.0448883881252068e-56, 0.0, 0.0, 9.625416045145385e-42, 0.0, 0.0, 1.9704100051910166e-27, 0.0, 0.0, 6.722680125110023e-14, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 4.337860688106173e-28, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, -2.7728196731749085e-17, 0.0, 0.0, -1.3551285415363216e-16, 0.0, 0.0, -9.191356091551209e-17, 0.0, 0.0, -6.091853009546654e-19, 0.0, 0.0, -9.245335705575452e-16, 0.0, 0.0, -4.518367498584839e-15, 0.0, 0.0, -3.0646483605829675e-15, 0.0, 0.0, -2.0311896473884482e-17, 0.0, 0.0, -6.356722010714178e-15, 0.0, 0.0, -3.106648265181852e-14, 0.0, 0.0, -2.107129292997838e-14, 0.0, 0.0, -1.396564532719179e-16, 0.0, 0.0, -6.065417120230418e-15, 0.0, 0.0, -2.9642821476868554e-14, 0.0, 0.0, -2.010567406714738e-14, 0.0, 0.0, -1.3325651824925112e-16], [7.315508570747347e-46, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 0.0047067059632920445, 0.0, 0.0, 2.184804885275958e-43, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.405675912031283, 0.0, 0.0, 3.5649689056093708e-43, 0.0, 0.0, 3.284016675318342e-28, 0.0, 0.0, 6.722680125110023e-14, 0.0, 0.0, 2.2936560383618256, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 0.5049487332400431, 0.0, 0.0, -0.0009460355793087815, 0.0, 0.0, -0.004623451814168191, 0.0, 0.0, -0.0031359233234044665, 0.0, 0.0, -2.0784293139234654e-05, 0.0, 0.0, -0.03154340184738192, 0.0, 0.0, -0.15415847108294958, 0.0, 0.0, -0.10456022132380947, 0.0, 0.0, -0.0006930049196285827, 0.0, 0.0, -0.21687977938446806, 0.0, 0.0, -1.0599318158669684, 0.0, 0.0, -0.7189141438459379, 0.0, 0.0, -0.004764823870570344, 0.0, 0.0, -0.2069409869887571, 0.0, 0.0, -1.0113590890714652, 0.0, 0.0, -0.6859689866426991, 0.0, 0.0, -0.004546469741909154, 0.0, 0.0], [0.0, 7.315508570747347e-46, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 0.0047067059632920445, 0.0, 0.0, 2.184804885275958e-43, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.405675912031283, 0.0, 0.0, 3.5649689056093708e-43, 0.0, 0.0, 3.284016675318342e-28, 0.0, 0.0, 6.722680125110023e-14, 0.0, 0.0, 2.2936560383618256, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 0.5049487332400431, 0.0, 0.0, -0.0009460355793087815, 0.0, 0.0, -0.004623451814168191, 0.0, 0.0, -0.0031359233234044665, 0.0, 0.0, -2.0784293139234654e-05, 0.0, 0.0, -0.03154340184738192, 0.0, 0.0, -0.15415847108294958, 0.0, 0.0, -0.10456022132380947, 0.0, 0.0, -0.0006930049196285827, 0.0, 0.0, -0.21687977938446806, 0.0, 0.0, -1.0599318158669684, 0.0, 0.0, -0.7189141438459379, 0.0, 0.0, -0.004764823870570344, 0.0, 0.0, -0.2069409869887571, 0.0, 0.0, -1.0113590890714652, 0.0, 0.0, -0.6859689866426991, 0.0, 0.0, -0.004546469741909154, 0.0], [0.0, 0.0, 7.315508570747347e-46, 0.0, 0.0, 6.738979433163386e-31, 0.0, 0.0, 1.3795302392750818e-16, 0.0, 0.0, 0.0047067059632920445, 0.0, 0.0, 2.184804885275958e-43, 0.0, 0.0, 2.012622231928497e-28, 0.0, 0.0, 4.1200203335230347e-14, 0.0, 0.0, 1.405675912031283, 0.0, 0.0, 3.5649689056093708e-43, 0.0, 0.0, 3.284016675318342e-28, 0.0, 0.0, 6.722680125110023e-14, 0.0, 0.0, 2.2936560383618256, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 0.5049487332400431, 0.0, 0.0, -0.0009460355793087815, 0.0, 0.0, -0.004623451814168191, 0.0, 0.0, -0.0031359233234044665, 0.0, 0.0, -2.0784293139234654e-05, 0.0, 0.0, -0.03154340184738192, 0.0, 0.0, -0.15415847108294958, 0.0, 0.0, -0.10456022132380947, 0.0, 0.0, -0.0006930049196285827, 0.0, 0.0, -0.21687977938446806, 0.0, 0.0, -1.0599318158669684, 0.0, 0.0, -0.7189141438459379, 0.0, 0.0, -0.004764823870570344, 0.0, 0.0, -0.2069409869887571, 0.0, 0.0, -1.0113590890714652, 0.0, 0.0, -0.6859689866426991, 0.0, 0.0, -0.004546469741909154], [2.5031736314126986e-89, 0.0, 0.0, 2.305900602342371e-74, 0.0, 0.0, 4.7203877697556426e-60, 0.0, 0.0, 1.6105103485542006e-46, 0.0, 0.0, 7.475824716374738e-87, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 1.2198381117358082e-86, 0.0, 0.0, 1.1237036861179805e-71, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 2.6854754984049406e-87, 0.0, 0.0, 2.4738354110309347e-72, 0.0, 0.0, 5.064165561497617e-58, 0.0, 0.0, 1.7278010708865783e-44, 0.0, 0.0, -3.237083647162013e-47, 0.0, 0.0, -1.5820229797298566e-46, 0.0, 0.0, -1.0730300562652764e-46, 0.0, 0.0, -7.111835633919439e-49, 0.0, 0.0, -1.0793318193235974e-45, 0.0, 0.0, -5.2748953287647463e-45, 0.0, 0.0, -3.5777743458469804e-45, 0.0, 0.0, -2.371279623935056e-47, 0.0, 0.0, -7.421052681322235e-45, 0.0, 0.0, -3.626806457698575e-44, 0.0, 0.0, -2.459934139535764e-44, 0.0, 0.0, -1.630396759950622e-46, 0.0, 0.0, -7.080973480916252e-45, 0.0, 0.0, -3.4606034278689006e-44, 0.0, 0.0, -2.3472045213604017e-44, 0.0, 0.0, -1.5556817497925587e-46, 0.0, 0.0], [0.0, 2.5031736314126986e-89, 0.0, 0.0, 2.305900602342371e-74, 0.0, 0.0, 4.7203877697556426e-60, 0.0, 0.0, 1.6105103485542006e-46, 0.0, 0.0, 7.475824716374738e-87, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 1.2198381117358082e-86, 0.0, 0.0, 1.1237036861179805e-71, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 2.6854754984049406e-87, 0.0, 0.0, 2.4738354110309347e-72, 0.0, 0.0, 5.064165561497617e-58, 0.0, 0.0, 1.7278010708865783e-44, 0.0, 0.0, -3.237083647162013e-47, 0.0, 0.0, -1.5820229797298566e-46, 0.0, 0.0, -1.0730300562652764e-46, 0.0, 0.0, -7.111835633919439e-49, 0.0, 0.0, -1.0793318193235974e-45, 0.0, 0.0, -5.2748953287647463e-45, 0.0, 0.0, -3.5777743458469804e-45, 0.0, 0.0, -2.371279623935056e-47, 0.0, 0.0, -7.421052681322235e-45, 0.0, 0.0, -3.626806457698575e-44, 0.0, 0.0, -2.459934139535764e-44, 0.0, 0.0, -1.630396759950622e-46, 0.0, 0.0, -7.080973480916252e-45, 0.0, 0.0, -3.4606034278689006e-44, 0.0, 0.0, -2.3472045213604017e-44, 0.0, 0.0, -1.5556817497925587e-46, 0.0], [0.0, 0.0, 2.5031736314126986e-89, 0.0, 0.0, 2.305900602342371e-74, 0.0, 0.0, 4.7203877697556426e-60, 0.0, 0.0, 1.6105103485542006e-46, 0.0, 0.0, 7.475824716374738e-87, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 1.2198381117358082e-86, 0.0, 0.0, 1.1237036861179805e-71, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 2.6854754984049406e-87, 0.0, 0.0, 2.4738354110309347e-72, 0.0, 0.0, 5.064165561497617e-58, 0.0, 0.0, 1.7278010708865783e-44, 0.0, 0.0, -3.237083647162013e-47, 0.0, 0.0, -1.5820229797298566e-46, 0.0, 0.0, -1.0730300562652764e-46, 0.0, 0.0, -7.111835633919439e-49, 0.0, 0.0, -1.0793318193235974e-45, 0.0, 0.0, -5.2748953287647463e-45, 0.0, 0.0, -3.5777743458469804e-45, 0.0, 0.0, -2.371279623935056e-47, 0.0, 0.0, -7.421052681322235e-45, 0.0, 0.0, -3.626806457698575e-44, 0.0, 0.0, -2.459934139535764e-44, 0.0, 0.0, -1.630396759950622e-46, 0.0, 0.0, -7.080973480916252e-45, 0.0, 0.0, -3.4606034278689006e-44, 0.0, 0.0, -2.3472045213604017e-44, 0.0, 0.0, -1.5556817497925587e-46], [2.3059006023423706e-74, 0.0, 0.0, 2.124174496390045e-59, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 1.4835873693323826e-31, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 6.343929163652742e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 1.1237036861179803e-71, 0.0, 0.0, 1.0351455345154963e-56, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 2.4738354110309347e-72, 0.0, 0.0, 2.278874502673934e-57, 0.0, 0.0, 4.665062891393802e-43, 0.0, 0.0, 1.591634507525814e-29, 0.0, 0.0, -2.981971781003021e-32, 0.0, 0.0, -1.4573450663187752e-31, 0.0, 0.0, -9.884654512268752e-32, 0.0, 0.0, -6.551357790853557e-34, 0.0, 0.0, -9.942705775871271e-31, 0.0, 0.0, -4.859185221213369e-30, 0.0, 0.0, -3.295812929476108e-30, 0.0, 0.0, -2.184401051743317e-32, 0.0, 0.0, -6.836205700288521e-30, 0.0, 0.0, -3.340980861430114e-29, 0.0, 0.0, -2.2660687788073284e-29, 0.0, 0.0, -1.501906549209472e-31, 0.0, 0.0, -6.522927858424352e-30, 0.0, 0.0, -3.187876153955594e-29, 0.0, 0.0, -2.1622232879511105e-29, 0.0, 0.0, -1.433079766773983e-31, 0.0, 0.0], [0.0, 2.3059006023423706e-74, 0.0, 0.0, 2.124174496390045e-59, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 1.4835873693323826e-31, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 6.343929163652742e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 1.1237036861179803e-71, 0.0, 0.0, 1.0351455345154963e-56, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 2.4738354110309347e-72, 0.0, 0.0, 2.278874502673934e-57, 0.0, 0.0, 4.665062891393802e-43, 0.0, 0.0, 1.591634507525814e-29, 0.0, 0.0, -2.981971781003021e-32, 0.0, 0.0, -1.4573450663187752e-31, 0.0, 0.0, -9.884654512268752e-32, 0.0, 0.0, -6.551357790853557e-34, 0.0, 0.0, -9.942705775871271e-31, 0.0, 0.0, -4.859185221213369e-30, 0.0, 0.0, -3.295812929476108e-30, 0.0, 0.0, -2.184401051743317e-32, 0.0, 0.0, -6.836205700288521e-30, 0.0, 0.0, -3.340980861430114e-29, 0.0, 0.0, -2.2660687788073284e-29, 0.0, 0.0, -1.501906549209472e-31, 0.0, 0.0, -6.522927858424352e-30, 0.0, 0.0, -3.187876153955594e-29, 0.0, 0.0, -2.1622232879511105e-29, 0.0, 0.0, -1.433079766773983e-31, 0.0], [0.0, 0.0, 2.3059006023423706e-74, 0.0, 0.0, 2.124174496390045e-59, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 1.4835873693323826e-31, 0.0, 0.0, 6.886661196876589e-72, 0.0, 0.0, 6.343929163652742e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 1.1237036861179803e-71, 0.0, 0.0, 1.0351455345154963e-56, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 2.4738354110309347e-72, 0.0, 0.0, 2.278874502673934e-57, 0.0, 0.0, 4.665062891393802e-43, 0.0, 0.0, 1.591634507525814e-29, 0.0, 0.0, -2.981971781003021e-32, 0.0, 0.0, -1.4573450663187752e-31, 0.0, 0.0, -9.884654512268752e-32, 0.0, 0.0, -6.551357790853557e-34, 0.0, 0.0, -9.942705775871271e-31, 0.0, 0.0, -4.859185221213369e-30, 0.0, 0.0, -3.295812929476108e-30, 0.0, 0.0, -2.184401051743317e-32, 0.0, 0.0, -6.836205700288521e-30, 0.0, 0.0, -3.340980861430114e-29, 0.0, 0.0, -2.2660687788073284e-29, 0.0, 0.0, -1.501906549209472e-31, 0.0, 0.0, -6.522927858424352e-30, 0.0, 0.0, -3.187876153955594e-29, 0.0, 0.0, -2.1622232879511105e-29, 0.0, 0.0, -1.433079766773983e-31], [4.720387769755642e-60, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 8.901524215994349e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 2.6584745825155794e-28, 0.0, 0.0, 9.07023116605373e-15, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 4.337860688106173e-28, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 5.064165561497617e-58, 0.0, 0.0, 4.665062891393802e-43, 0.0, 0.0, 9.549807045154941e-29, 0.0, 0.0, 3.258220261365099e-15, 0.0, 0.0, -6.1043668189792834e-18, 0.0, 0.0, -2.9833175898288224e-17, 0.0, 0.0, -2.0234784717336028e-17, 0.0, 0.0, -1.3411223866208464e-19, 0.0, 0.0, -2.035362092148543e-16, 0.0, 0.0, -9.947193068900256e-16, 0.0, 0.0, -6.746828127759698e-16, 0.0, 0.0, -4.471667164844925e-18, 0.0, 0.0, -1.3994333383839628e-15, 0.0, 0.0, -6.839290982994769e-15, 0.0, 0.0, -4.63884841265114e-15, 0.0, 0.0, -3.074538988802285e-17, 0.0, 0.0, -1.3353025214801945e-15, 0.0, 0.0, -6.52587175411708e-15, 0.0, 0.0, -4.4262672699583384e-15, 0.0, 0.0, -2.933644319834296e-17, 0.0, 0.0], [0.0, 4.720387769755642e-60, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 8.901524215994349e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 2.6584745825155794e-28, 0.0, 0.0, 9.07023116605373e-15, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 4.337860688106173e-28, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 5.064165561497617e-58, 0.0, 0.0, 4.665062891393802e-43, 0.0, 0.0, 9.549807045154941e-29, 0.0, 0.0, 3.258220261365099e-15, 0.0, 0.0, -6.1043668189792834e-18, 0.0, 0.0, -2.9833175898288224e-17, 0.0, 0.0, -2.0234784717336028e-17, 0.0, 0.0, -1.3411223866208464e-19, 0.0, 0.0, -2.035362092148543e-16, 0.0, 0.0, -9.947193068900256e-16, 0.0, 0.0, -6.746828127759698e-16, 0.0, 0.0, -4.471667164844925e-18, 0.0, 0.0, -1.3994333383839628e-15, 0.0, 0.0, -6.839290982994769e-15, 0.0, 0.0, -4.63884841265114e-15, 0.0, 0.0, -3.074538988802285e-17, 0.0, 0.0, -1.3353025214801945e-15, 0.0, 0.0, -6.52587175411708e-15, 0.0, 0.0, -4.4262672699583384e-15, 0.0, 0.0, -2.933644319834296e-17, 0.0], [0.0, 0.0, 4.720387769755642e-60, 0.0, 0.0, 4.3483779410963796e-45, 0.0, 0.0, 8.901524215994349e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 1.4097620363672723e-57, 0.0, 0.0, 1.298659864431412e-42, 0.0, 0.0, 2.6584745825155794e-28, 0.0, 0.0, 9.07023116605373e-15, 0.0, 0.0, 2.3003234100344297e-57, 0.0, 0.0, 2.1190368379628095e-42, 0.0, 0.0, 4.337860688106173e-28, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 5.064165561497617e-58, 0.0, 0.0, 4.665062891393802e-43, 0.0, 0.0, 9.549807045154941e-29, 0.0, 0.0, 3.258220261365099e-15, 0.0, 0.0, -6.1043668189792834e-18, 0.0, 0.0, -2.9833175898288224e-17, 0.0, 0.0, -2.0234784717336028e-17, 0.0, 0.0, -1.3411223866208464e-19, 0.0, 0.0, -2.035362092148543e-16, 0.0, 0.0, -9.947193068900256e-16, 0.0, 0.0, -6.746828127759698e-16, 0.0, 0.0, -4.471667164844925e-18, 0.0, 0.0, -1.3994333383839628e-15, 0.0, 0.0, -6.839290982994769e-15, 0.0, 0.0, -4.63884841265114e-15, 0.0, 0.0, -3.074538988802285e-17, 0.0, 0.0, -1.3353025214801945e-15, 0.0, 0.0, -6.52587175411708e-15, 0.0, 0.0, -4.4262672699583384e-15, 0.0, 0.0, -2.933644319834296e-17], [1.6105103485542004e-46, 0.0, 0.0, 1.4835873693323828e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 0.0010361820491598737, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 9.070231166053729e-15, 0.0, 0.0, 0.3094597704515397, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 0.5049487332400431, 0.0, 0.0, 1.7278010708865783e-44, 0.0, 0.0, 1.591634507525814e-29, 0.0, 0.0, 3.258220261365099e-15, 0.0, 0.0, 0.11116454208314124, 0.0, 0.0, -0.00020826987978248118, 0.0, 0.0, -0.0010178536352939951, 0.0, 0.0, -0.0006903740069160257, 0.0, 0.0, -4.57566536412408e-06, 0.0, 0.0, -0.006944284818003088, 0.0, 0.0, -0.03393801136248554, 0.0, 0.0, -0.023018948971296145, 0.0, 0.0, -0.0001525651407372742, 0.0, 0.0, -0.04774611713087706, 0.0, 0.0, -0.2333441539582817, 0.0, 0.0, -0.15826906047457265, 0.0, 0.0, -0.0010489767154777143, 0.0, 0.0, -0.04555809044064394, 0.0, 0.0, -0.2226508606068856, 0.0, 0.0, -0.15101617899716896, 0.0, 0.0, -0.0010009060201244784, 0.0, 0.0], [0.0, 1.6105103485542004e-46, 0.0, 0.0, 1.4835873693323828e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 0.0010361820491598737, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 9.070231166053729e-15, 0.0, 0.0, 0.3094597704515397, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 0.5049487332400431, 0.0, 0.0, 1.7278010708865783e-44, 0.0, 0.0, 1.591634507525814e-29, 0.0, 0.0, 3.258220261365099e-15, 0.0, 0.0, 0.11116454208314124, 0.0, 0.0, -0.00020826987978248118, 0.0, 0.0, -0.0010178536352939951, 0.0, 0.0, -0.0006903740069160257, 0.0, 0.0, -4.57566536412408e-06, 0.0, 0.0, -0.006944284818003088, 0.0, 0.0, -0.03393801136248554, 0.0, 0.0, -0.023018948971296145, 0.0, 0.0, -0.0001525651407372742, 0.0, 0.0, -0.04774611713087706, 0.0, 0.0, -0.2333441539582817, 0.0, 0.0, -0.15826906047457265, 0.0, 0.0, -0.0010489767154777143, 0.0, 0.0, -0.04555809044064394, 0.0, 0.0, -0.2226508606068856, 0.0, 0.0, -0.15101617899716896, 0.0, 0.0, -0.0010009060201244784, 0.0], [0.0, 0.0, 1.6105103485542004e-46, 0.0, 0.0, 1.4835873693323828e-31, 0.0, 0.0, 3.037037965316743e-17, 0.0, 0.0, 0.0010361820491598737, 0.0, 0.0, 4.80985134974593e-44, 0.0, 0.0, 4.430790970859273e-29, 0.0, 0.0, 9.070231166053729e-15, 0.0, 0.0, 0.3094597704515397, 0.0, 0.0, 7.848284585047375e-44, 0.0, 0.0, 7.229767813510246e-29, 0.0, 0.0, 1.4799990741318028e-14, 0.0, 0.0, 0.5049487332400431, 0.0, 0.0, 1.7278010708865783e-44, 0.0, 0.0, 1.591634507525814e-29, 0.0, 0.0, 3.258220261365099e-15, 0.0, 0.0, 0.11116454208314124, 0.0, 0.0, -0.00020826987978248118, 0.0, 0.0, -0.0010178536352939951, 0.0, 0.0, -0.0006903740069160257, 0.0, 0.0, -4.57566536412408e-06, 0.0, 0.0, -0.006944284818003088, 0.0, 0.0, -0.03393801136248554, 0.0, 0.0, -0.023018948971296145, 0.0, 0.0, -0.0001525651407372742, 0.0, 0.0, -0.04774611713087706, 0.0, 0.0, -0.2333441539582817, 0.0, 0.0, -0.15826906047457265, 0.0, 0.0, -0.0010489767154777143, 0.0, 0.0, -0.04555809044064394, 0.0, 0.0, -0.2226508606068856, 0.0, 0.0, -0.15101617899716896, 0.0, 0.0, -0.0010009060201244784], [-3.0173361972827643e-49, 0.0, 0.0, -2.7795424446274265e-34, 0.0, 0.0, -5.689975599038385e-20, 0.0, 0.0, -1.9413160596648568e-06, 0.0, 0.0, -9.011391074988384e-47, 0.0, 0.0, -8.301210849696938e-32, 0.0, 0.0, -1.699333185882669e-17, 0.0, 0.0, -0.0005797815380848027, 0.0, 0.0, -1.4703980751380325e-46, 0.0, 0.0, -1.354517227488661e-31, 0.0, 0.0, -2.7728196731749085e-17, 0.0, 0.0, -0.0009460355793087815, 0.0, 0.0, -3.237083647162013e-47, 0.0, 0.0, -2.981971781003021e-32, 0.0, 0.0, -6.1043668189792834e-18, 0.0, 0.0, -0.00020826987978248118, 0.0, 0.0, 3.901994467999293e-07, 0.0, 0.0, 1.9069772634901277e-06, 0.0, 0.0, 1.2934350174160095e-06, 0.0, 0.0, 8.572637078811024e-09, 0.0, 0.0, 1.3010311895488392e-05, 0.0, 0.0, 6.358381381389497e-05, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 8.945368629765721e-05, 0.0, 0.0, 0.0004371768010026856, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 1.9652872249837465e-06, 0.0, 0.0, 8.535435707634051e-05, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0], [0.0, -3.0173361972827643e-49, 0.0, 0.0, -2.7795424446274265e-34, 0.0, 0.0, -5.689975599038385e-20, 0.0, 0.0, -1.9413160596648568e-06, 0.0, 0.0, -9.011391074988384e-47, 0.0, 0.0, -8.301210849696938e-32, 0.0, 0.0, -1.699333185882669e-17, 0.0, 0.0, -0.0005797815380848027, 0.0, 0.0, -1.4703980751380325e-46, 0.0, 0.0, -1.354517227488661e-31, 0.0, 0.0, -2.7728196731749085e-17, 0.0, 0.0, -0.0009460355793087815, 0.0, 0.0, -3.237083647162013e-47, 0.0, 0.0, -2.981971781003021e-32, 0.0, 0.0, -6.1043668189792834e-18, 0.0, 0.0, -0.00020826987978248118, 0.0, 0.0, 3.901994467999293e-07, 0.0, 0.0, 1.9069772634901277e-06, 0.0, 0.0, 1.2934350174160095e-06, 0.0, 0.0, 8.572637078811024e-09, 0.0, 0.0, 1.3010311895488392e-05, 0.0, 0.0, 6.358381381389497e-05, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 8.945368629765721e-05, 0.0, 0.0, 0.0004371768010026856, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 1.9652872249837465e-06, 0.0, 0.0, 8.535435707634051e-05, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 1.875225432305368e-06, 0.0], [0.0, 0.0, -3.0173361972827643e-49, 0.0, 0.0, -2.7795424446274265e-34, 0.0, 0.0, -5.689975599038385e-20, 0.0, 0.0, -1.9413160596648568e-06, 0.0, 0.0, -9.011391074988384e-47, 0.0, 0.0, -8.301210849696938e-32, 0.0, 0.0, -1.699333185882669e-17, 0.0, 0.0, -0.0005797815380848027, 0.0, 0.0, -1.4703980751380325e-46, 0.0, 0.0, -1.354517227488661e-31, 0.0, 0.0, -2.7728196731749085e-17, 0.0, 0.0, -0.0009460355793087815, 0.0, 0.0, -3.237083647162013e-47, 0.0, 0.0, -2.981971781003021e-32, 0.0, 0.0, -6.1043668189792834e-18, 0.0, 0.0, -0.00020826987978248118, 0.0, 0.0, 3.901994467999293e-07, 0.0, 0.0, 1.9069772634901277e-06, 0.0, 0.0, 1.2934350174160095e-06, 0.0, 0.0, 8.572637078811024e-09, 0.0, 0.0, 1.3010311895488392e-05, 0.0, 0.0, 6.358381381389497e-05, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 8.945368629765721e-05, 0.0, 0.0, 0.0004371768010026856, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 1.9652872249837465e-06, 0.0, 0.0, 8.535435707634051e-05, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 1.875225432305368e-06], [-1.4746283142411255e-48, 0.0, 0.0, -1.3584140849712838e-33, 0.0, 0.0, -2.7807968940415695e-19, 0.0, 0.0, -9.487572618029139e-06, 0.0, 0.0, -4.40403440685345e-46, 0.0, 0.0, -4.056956123242893e-31, 0.0, 0.0, -8.304957311315902e-17, 0.0, 0.0, -0.0028335002009522445, 0.0, 0.0, -7.186108849112763e-46, 0.0, 0.0, -6.619777595817519e-31, 0.0, 0.0, -1.3551285415363216e-16, 0.0, 0.0, -0.004623451814168191, 0.0, 0.0, -1.5820229797298566e-46, 0.0, 0.0, -1.4573450663187752e-31, 0.0, 0.0, -2.9833175898288224e-17, 0.0, 0.0, -0.0010178536352939951, 0.0, 0.0, 1.9069772634901277e-06, 0.0, 0.0, 9.319752534997584e-06, 0.0, 0.0, 6.321257475485316e-06, 0.0, 0.0, 4.189607169234975e-08, 0.0, 0.0, 6.358381381389495e-05, 0.0, 0.0, 0.0003107459230490871, 0.0, 0.0, 0.00021076793419935326, 0.0, 0.0, 1.3969290945527585e-06, 0.0, 0.0, 0.00043717680100268557, 0.0, 0.0, 0.0021365643300487137, 0.0, 0.0, 0.001449155778810516, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0020386535456652977, 0.0, 0.0, 0.0013827463676818266, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0], [0.0, -1.4746283142411255e-48, 0.0, 0.0, -1.3584140849712838e-33, 0.0, 0.0, -2.7807968940415695e-19, 0.0, 0.0, -9.487572618029139e-06, 0.0, 0.0, -4.40403440685345e-46, 0.0, 0.0, -4.056956123242893e-31, 0.0, 0.0, -8.304957311315902e-17, 0.0, 0.0, -0.0028335002009522445, 0.0, 0.0, -7.186108849112763e-46, 0.0, 0.0, -6.619777595817519e-31, 0.0, 0.0, -1.3551285415363216e-16, 0.0, 0.0, -0.004623451814168191, 0.0, 0.0, -1.5820229797298566e-46, 0.0, 0.0, -1.4573450663187752e-31, 0.0, 0.0, -2.9833175898288224e-17, 0.0, 0.0, -0.0010178536352939951, 0.0, 0.0, 1.9069772634901277e-06, 0.0, 0.0, 9.319752534997584e-06, 0.0, 0.0, 6.321257475485316e-06, 0.0, 0.0, 4.189607169234975e-08, 0.0, 0.0, 6.358381381389495e-05, 0.0, 0.0, 0.0003107459230490871, 0.0, 0.0, 0.00021076793419935326, 0.0, 0.0, 1.3969290945527585e-06, 0.0, 0.0, 0.00043717680100268557, 0.0, 0.0, 0.0021365643300487137, 0.0, 0.0, 0.001449155778810516, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0020386535456652977, 0.0, 0.0, 0.0013827463676818266, 0.0, 0.0, 9.164575430980418e-06, 0.0], [0.0, 0.0, -1.4746283142411255e-48, 0.0, 0.0, -1.3584140849712838e-33, 0.0, 0.0, -2.7807968940415695e-19, 0.0, 0.0, -9.487572618029139e-06, 0.0, 0.0, -4.40403440685345e-46, 0.0, 0.0, -4.056956123242893e-31, 0.0, 0.0, -8.304957311315902e-17, 0.0, 0.0, -0.0028335002009522445, 0.0, 0.0, -7.186108849112763e-46, 0.0, 0.0, -6.619777595817519e-31, 0.0, 0.0, -1.3551285415363216e-16, 0.0, 0.0, -0.004623451814168191, 0.0, 0.0, -1.5820229797298566e-46, 0.0, 0.0, -1.4573450663187752e-31, 0.0, 0.0, -2.9833175898288224e-17, 0.0, 0.0, -0.0010178536352939951, 0.0, 0.0, 1.9069772634901277e-06, 0.0, 0.0, 9.319752534997584e-06, 0.0, 0.0, 6.321257475485316e-06, 0.0, 0.0, 4.189607169234975e-08, 0.0, 0.0, 6.358381381389495e-05, 0.0, 0.0, 0.0003107459230490871, 0.0, 0.0, 0.00021076793419935326, 0.0, 0.0, 1.3969290945527585e-06, 0.0, 0.0, 0.00043717680100268557, 0.0, 0.0, 0.0021365643300487137, 0.0, 0.0, 0.001449155778810516, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0020386535456652977, 0.0, 0.0, 0.0013827463676818266, 0.0, 0.0, 9.164575430980418e-06], [-1.0001880650752106e-48, 0.0, 0.0, -9.213640766944996e-34, 0.0, 0.0, -1.886115869306306e-19, 0.0, 0.0, -6.4350838834737384e-06, 0.0, 0.0, -2.9871002810509842e-46, 0.0, 0.0, -2.751689395771248e-31, 0.0, 0.0, -5.632957880652106e-17, 0.0, 0.0, -0.0019218626524468293, 0.0, 0.0, -4.874082665985401e-46, 0.0, 0.0, -4.489960270562329e-31, 0.0, 0.0, -9.191356091551209e-17, 0.0, 0.0, -0.0031359233234044665, 0.0, 0.0, -1.0730300562652764e-46, 0.0, 0.0, -9.884654512268752e-32, 0.0, 0.0, -2.0234784717336028e-17, 0.0, 0.0, -0.0006903740069160257, 0.0, 0.0, 1.2934350174160095e-06, 0.0, 0.0, 6.321257475485316e-06, 0.0, 0.0, 4.287484664568869e-06, 0.0, 0.0, 2.8416618937490193e-08, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 0.0002107679341993533, 0.0, 0.0, 0.00014295641162650295, 0.0, 0.0, 9.474874411637848e-07, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 0.0014491557788105162, 0.0, 0.0, 0.0009829109480696198, 0.0, 0.0, 6.514543618452855e-06, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 0.0013827463676818268, 0.0, 0.0, 0.0009378678007367476, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0], [0.0, -1.0001880650752106e-48, 0.0, 0.0, -9.213640766944996e-34, 0.0, 0.0, -1.886115869306306e-19, 0.0, 0.0, -6.4350838834737384e-06, 0.0, 0.0, -2.9871002810509842e-46, 0.0, 0.0, -2.751689395771248e-31, 0.0, 0.0, -5.632957880652106e-17, 0.0, 0.0, -0.0019218626524468293, 0.0, 0.0, -4.874082665985401e-46, 0.0, 0.0, -4.489960270562329e-31, 0.0, 0.0, -9.191356091551209e-17, 0.0, 0.0, -0.0031359233234044665, 0.0, 0.0, -1.0730300562652764e-46, 0.0, 0.0, -9.884654512268752e-32, 0.0, 0.0, -2.0234784717336028e-17, 0.0, 0.0, -0.0006903740069160257, 0.0, 0.0, 1.2934350174160095e-06, 0.0, 0.0, 6.321257475485316e-06, 0.0, 0.0, 4.287484664568869e-06, 0.0, 0.0, 2.8416618937490193e-08, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 0.0002107679341993533, 0.0, 0.0, 0.00014295641162650295, 0.0, 0.0, 9.474874411637848e-07, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 0.0014491557788105162, 0.0, 0.0, 0.0009829109480696198, 0.0, 0.0, 6.514543618452855e-06, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 0.0013827463676818268, 0.0, 0.0, 0.0009378678007367476, 0.0, 0.0, 6.21600635158378e-06, 0.0], [0.0, 0.0, -1.0001880650752106e-48, 0.0, 0.0, -9.213640766944996e-34, 0.0, 0.0, -1.886115869306306e-19, 0.0, 0.0, -6.4350838834737384e-06, 0.0, 0.0, -2.9871002810509842e-46, 0.0, 0.0, -2.751689395771248e-31, 0.0, 0.0, -5.632957880652106e-17, 0.0, 0.0, -0.0019218626524468293, 0.0, 0.0, -4.874082665985401e-46, 0.0, 0.0, -4.489960270562329e-31, 0.0, 0.0, -9.191356091551209e-17, 0.0, 0.0, -0.0031359233234044665, 0.0, 0.0, -1.0730300562652764e-46, 0.0, 0.0, -9.884654512268752e-32, 0.0, 0.0, -2.0234784717336028e-17, 0.0, 0.0, -0.0006903740069160257, 0.0, 0.0, 1.2934350174160095e-06, 0.0, 0.0, 6.321257475485316e-06, 0.0, 0.0, 4.287484664568869e-06, 0.0, 0.0, 2.8416618937490193e-08, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 0.0002107679341993533, 0.0, 0.0, 0.00014295641162650295, 0.0, 0.0, 9.474874411637848e-07, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 0.0014491557788105162, 0.0, 0.0, 0.0009829109480696198, 0.0, 0.0, 6.514543618452855e-06, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 0.0013827463676818268, 0.0, 0.0, 0.0009378678007367476, 0.0, 0.0, 6.21600635158378e-06], [-6.629053007686009e-51, 0.0, 0.0, -6.106622861297822e-36, 0.0, 0.0, -1.2500811110287632e-21, 0.0, 0.0, -4.2650491104635994e-08, 0.0, 0.0, -1.9797922804519503e-48, 0.0, 0.0, -1.8237664997415684e-33, 0.0, 0.0, -3.7334155130212956e-19, 0.0, 0.0, -1.27377338736831e-05, 0.0, 0.0, -3.2304477012761726e-48, 0.0, 0.0, -2.9758588084855554e-33, 0.0, 0.0, -6.091853009546654e-19, 0.0, 0.0, -2.0784293139234654e-05, 0.0, 0.0, -7.111835633919439e-49, 0.0, 0.0, -6.551357790853557e-34, 0.0, 0.0, -1.3411223866208464e-19, 0.0, 0.0, -4.57566536412408e-06, 0.0, 0.0, 8.572637078811024e-09, 0.0, 0.0, 4.189607169234975e-08, 0.0, 0.0, 2.8416618937490193e-08, 0.0, 0.0, 1.8833985308720056e-10, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 1.3969290945527587e-06, 0.0, 0.0, 9.474874411637849e-07, 0.0, 0.0, 6.279763467402707e-09, 0.0, 0.0, 1.965287224983746e-06, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 6.514543618452853e-06, 0.0, 0.0, 4.3177134856492426e-08, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 4.1198487604091976e-08, 0.0, 0.0], [0.0, -6.629053007686009e-51, 0.0, 0.0, -6.106622861297822e-36, 0.0, 0.0, -1.2500811110287632e-21, 0.0, 0.0, -4.2650491104635994e-08, 0.0, 0.0, -1.9797922804519503e-48, 0.0, 0.0, -1.8237664997415684e-33, 0.0, 0.0, -3.7334155130212956e-19, 0.0, 0.0, -1.27377338736831e-05, 0.0, 0.0, -3.2304477012761726e-48, 0.0, 0.0, -2.9758588084855554e-33, 0.0, 0.0, -6.091853009546654e-19, 0.0, 0.0, -2.0784293139234654e-05, 0.0, 0.0, -7.111835633919439e-49, 0.0, 0.0, -6.551357790853557e-34, 0.0, 0.0, -1.3411223866208464e-19, 0.0, 0.0, -4.57566536412408e-06, 0.0, 0.0, 8.572637078811024e-09, 0.0, 0.0, 4.189607169234975e-08, 0.0, 0.0, 2.8416618937490193e-08, 0.0, 0.0, 1.8833985308720056e-10, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 1.3969290945527587e-06, 0.0, 0.0, 9.474874411637849e-07, 0.0, 0.0, 6.279763467402707e-09, 0.0, 0.0, 1.965287224983746e-06, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 6.514543618452853e-06, 0.0, 0.0, 4.3177134856492426e-08, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 4.1198487604091976e-08, 0.0], [0.0, 0.0, -6.629053007686009e-51, 0.0, 0.0, -6.106622861297822e-36, 0.0, 0.0, -1.2500811110287632e-21, 0.0, 0.0, -4.2650491104635994e-08, 0.0, 0.0, -1.9797922804519503e-48, 0.0, 0.0, -1.8237664997415684e-33, 0.0, 0.0, -3.7334155130212956e-19, 0.0, 0.0, -1.27377338736831e-05, 0.0, 0.0, -3.2304477012761726e-48, 0.0, 0.0, -2.9758588084855554e-33, 0.0, 0.0, -6.091853009546654e-19, 0.0, 0.0, -2.0784293139234654e-05, 0.0, 0.0, -7.111835633919439e-49, 0.0, 0.0, -6.551357790853557e-34, 0.0, 0.0, -1.3411223866208464e-19, 0.0, 0.0, -4.57566536412408e-06, 0.0, 0.0, 8.572637078811024e-09, 0.0, 0.0, 4.189607169234975e-08, 0.0, 0.0, 2.8416618937490193e-08, 0.0, 0.0, 1.8833985308720056e-10, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 1.3969290945527587e-06, 0.0, 0.0, 9.474874411637849e-07, 0.0, 0.0, 6.279763467402707e-09, 0.0, 0.0, 1.965287224983746e-06, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 6.514543618452853e-06, 0.0, 0.0, 4.3177134856492426e-08, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 4.1198487604091976e-08], [-1.0060620367902269e-47, 0.0, 0.0, -9.267751255909176e-33, 0.0, 0.0, -1.8971927773943022e-18, 0.0, 0.0, -6.472876276759734e-05, 0.0, 0.0, -3.004643124415638e-45, 0.0, 0.0, -2.7678497022612632e-30, 0.0, 0.0, -5.666039494418751e-16, 0.0, 0.0, -0.01933149496646245, 0.0, 0.0, -4.902707506369291e-45, 0.0, 0.0, -4.51632921111637e-30, 0.0, 0.0, -9.245335705575452e-16, 0.0, 0.0, -0.03154340184738192, 0.0, 0.0, -1.0793318193235974e-45, 0.0, 0.0, -9.942705775871271e-31, 0.0, 0.0, -2.035362092148543e-16, 0.0, 0.0, -0.006944284818003088, 0.0, 0.0, 1.3010311895488392e-05, 0.0, 0.0, 6.358381381389495e-05, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 0.0004337992198760787, 0.0, 0.0, 0.00212005746294048, 0.0, 0.0, 0.001437959756522056, 0.0, 0.0, 9.53051909111431e-06, 0.0, 0.0, 0.0029826294436814857, 0.0, 0.0, 0.014576664783005617, 0.0, 0.0, 0.009886834535702793, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.00284594664679642, 0.0, 0.0, 0.013908670535172389, 0.0, 0.0, 0.009433757738133288, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0], [0.0, -1.0060620367902269e-47, 0.0, 0.0, -9.267751255909176e-33, 0.0, 0.0, -1.8971927773943022e-18, 0.0, 0.0, -6.472876276759734e-05, 0.0, 0.0, -3.004643124415638e-45, 0.0, 0.0, -2.7678497022612632e-30, 0.0, 0.0, -5.666039494418751e-16, 0.0, 0.0, -0.01933149496646245, 0.0, 0.0, -4.902707506369291e-45, 0.0, 0.0, -4.51632921111637e-30, 0.0, 0.0, -9.245335705575452e-16, 0.0, 0.0, -0.03154340184738192, 0.0, 0.0, -1.0793318193235974e-45, 0.0, 0.0, -9.942705775871271e-31, 0.0, 0.0, -2.035362092148543e-16, 0.0, 0.0, -0.006944284818003088, 0.0, 0.0, 1.3010311895488392e-05, 0.0, 0.0, 6.358381381389495e-05, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 0.0004337992198760787, 0.0, 0.0, 0.00212005746294048, 0.0, 0.0, 0.001437959756522056, 0.0, 0.0, 9.53051909111431e-06, 0.0, 0.0, 0.0029826294436814857, 0.0, 0.0, 0.014576664783005617, 0.0, 0.0, 0.009886834535702793, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.00284594664679642, 0.0, 0.0, 0.013908670535172389, 0.0, 0.0, 0.009433757738133288, 0.0, 0.0, 6.252512131611078e-05, 0.0], [0.0, 0.0, -1.0060620367902269e-47, 0.0, 0.0, -9.267751255909176e-33, 0.0, 0.0, -1.8971927773943022e-18, 0.0, 0.0, -6.472876276759734e-05, 0.0, 0.0, -3.004643124415638e-45, 0.0, 0.0, -2.7678497022612632e-30, 0.0, 0.0, -5.666039494418751e-16, 0.0, 0.0, -0.01933149496646245, 0.0, 0.0, -4.902707506369291e-45, 0.0, 0.0, -4.51632921111637e-30, 0.0, 0.0, -9.245335705575452e-16, 0.0, 0.0, -0.03154340184738192, 0.0, 0.0, -1.0793318193235974e-45, 0.0, 0.0, -9.942705775871271e-31, 0.0, 0.0, -2.035362092148543e-16, 0.0, 0.0, -0.006944284818003088, 0.0, 0.0, 1.3010311895488392e-05, 0.0, 0.0, 6.358381381389495e-05, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 0.0004337992198760787, 0.0, 0.0, 0.00212005746294048, 0.0, 0.0, 0.001437959756522056, 0.0, 0.0, 9.53051909111431e-06, 0.0, 0.0, 0.0029826294436814857, 0.0, 0.0, 0.014576664783005617, 0.0, 0.0, 0.009886834535702793, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.00284594664679642, 0.0, 0.0, 0.013908670535172389, 0.0, 0.0, 0.009433757738133288, 0.0, 0.0, 6.252512131611078e-05], [-4.916812275244567e-47, 0.0, 0.0, -4.529322394904041e-32, 0.0, 0.0, -9.271933931786593e-18, 0.0, 0.0, -0.00031634150151664656, 0.0, 0.0, -1.46842497347272e-44, 0.0, 0.0, -1.3526996243222522e-29, 0.0, 0.0, -2.7690988745644776e-15, 0.0, 0.0, -0.09447661105788227, 0.0, 0.0, -2.396044336009119e-44, 0.0, 0.0, -2.207214077484639e-29, 0.0, 0.0, -4.518367498584839e-15, 0.0, 0.0, -0.15415847108294958, 0.0, 0.0, -5.2748953287647463e-45, 0.0, 0.0, -4.859185221213369e-30, 0.0, 0.0, -9.947193068900256e-16, 0.0, 0.0, -0.03393801136248554, 0.0, 0.0, 6.358381381389497e-05, 0.0, 0.0, 0.0003107459230490871, 0.0, 0.0, 0.0002107679341993533, 0.0, 0.0, 1.3969290945527587e-06, 0.0, 0.0, 0.00212005746294048, 0.0, 0.0, 0.010361115097103189, 0.0, 0.0, 0.007027576753350379, 0.0, 0.0, 4.657741922769144e-05, 0.0, 0.0, 0.014576664783005618, 0.0, 0.0, 0.07123887167621173, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.01390867053517239, 0.0, 0.0, 0.06797425955744235, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.0003055718959230642, 0.0, 0.0], [0.0, -4.916812275244567e-47, 0.0, 0.0, -4.529322394904041e-32, 0.0, 0.0, -9.271933931786593e-18, 0.0, 0.0, -0.00031634150151664656, 0.0, 0.0, -1.46842497347272e-44, 0.0, 0.0, -1.3526996243222522e-29, 0.0, 0.0, -2.7690988745644776e-15, 0.0, 0.0, -0.09447661105788227, 0.0, 0.0, -2.396044336009119e-44, 0.0, 0.0, -2.207214077484639e-29, 0.0, 0.0, -4.518367498584839e-15, 0.0, 0.0, -0.15415847108294958, 0.0, 0.0, -5.2748953287647463e-45, 0.0, 0.0, -4.859185221213369e-30, 0.0, 0.0, -9.947193068900256e-16, 0.0, 0.0, -0.03393801136248554, 0.0, 0.0, 6.358381381389497e-05, 0.0, 0.0, 0.0003107459230490871, 0.0, 0.0, 0.0002107679341993533, 0.0, 0.0, 1.3969290945527587e-06, 0.0, 0.0, 0.00212005746294048, 0.0, 0.0, 0.010361115097103189, 0.0, 0.0, 0.007027576753350379, 0.0, 0.0, 4.657741922769144e-05, 0.0, 0.0, 0.014576664783005618, 0.0, 0.0, 0.07123887167621173, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.01390867053517239, 0.0, 0.0, 0.06797425955744235, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.0003055718959230642, 0.0], [0.0, 0.0, -4.916812275244567e-47, 0.0, 0.0, -4.529322394904041e-32, 0.0, 0.0, -9.271933931786593e-18, 0.0, 0.0, -0.00031634150151664656, 0.0, 0.0, -1.46842497347272e-44, 0.0, 0.0, -1.3526996243222522e-29, 0.0, 0.0, -2.7690988745644776e-15, 0.0, 0.0, -0.09447661105788227, 0.0, 0.0, -2.396044336009119e-44, 0.0, 0.0, -2.207214077484639e-29, 0.0, 0.0, -4.518367498584839e-15, 0.0, 0.0, -0.15415847108294958, 0.0, 0.0, -5.2748953287647463e-45, 0.0, 0.0, -4.859185221213369e-30, 0.0, 0.0, -9.947193068900256e-16, 0.0, 0.0, -0.03393801136248554, 0.0, 0.0, 6.358381381389497e-05, 0.0, 0.0, 0.0003107459230490871, 0.0, 0.0, 0.0002107679341993533, 0.0, 0.0, 1.3969290945527587e-06, 0.0, 0.0, 0.00212005746294048, 0.0, 0.0, 0.010361115097103189, 0.0, 0.0, 0.007027576753350379, 0.0, 0.0, 4.657741922769144e-05, 0.0, 0.0, 0.014576664783005618, 0.0, 0.0, 0.07123887167621173, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.01390867053517239, 0.0, 0.0, 0.06797425955744235, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.0003055718959230642], [-3.3348993155917235e-47, 0.0, 0.0, -3.0720786780716427e-32, 0.0, 0.0, -6.288823813552807e-18, 0.0, 0.0, -0.00021456321654026293, 0.0, 0.0, -9.959805591293163e-45, 0.0, 0.0, -9.174881607878905e-30, 0.0, 0.0, -1.878181517745977e-15, 0.0, 0.0, -0.064080133207991, 0.0, 0.0, -1.6251518603863676e-44, 0.0, 0.0, -1.4970749958115508e-29, 0.0, 0.0, -3.0646483605829675e-15, 0.0, 0.0, -0.10456022132380947, 0.0, 0.0, -3.5777743458469804e-45, 0.0, 0.0, -3.295812929476108e-30, 0.0, 0.0, -6.746828127759698e-16, 0.0, 0.0, -0.023018948971296145, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 0.00021076793419935326, 0.0, 0.0, 0.00014295641162650295, 0.0, 0.0, 9.474874411637849e-07, 0.0, 0.0, 0.001437959756522056, 0.0, 0.0, 0.007027576753350379, 0.0, 0.0, 0.004766555970219698, 0.0, 0.0, 3.159181087440046e-05, 0.0, 0.0, 0.009886834535702795, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.03277292703706178, 0.0, 0.0, 0.00021721262043790919, 0.0, 0.0, 0.00943375773813329, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.031271065872569705, 0.0, 0.0, 0.00020725857517657695, 0.0, 0.0], [0.0, -3.3348993155917235e-47, 0.0, 0.0, -3.0720786780716427e-32, 0.0, 0.0, -6.288823813552807e-18, 0.0, 0.0, -0.00021456321654026293, 0.0, 0.0, -9.959805591293163e-45, 0.0, 0.0, -9.174881607878905e-30, 0.0, 0.0, -1.878181517745977e-15, 0.0, 0.0, -0.064080133207991, 0.0, 0.0, -1.6251518603863676e-44, 0.0, 0.0, -1.4970749958115508e-29, 0.0, 0.0, -3.0646483605829675e-15, 0.0, 0.0, -0.10456022132380947, 0.0, 0.0, -3.5777743458469804e-45, 0.0, 0.0, -3.295812929476108e-30, 0.0, 0.0, -6.746828127759698e-16, 0.0, 0.0, -0.023018948971296145, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 0.00021076793419935326, 0.0, 0.0, 0.00014295641162650295, 0.0, 0.0, 9.474874411637849e-07, 0.0, 0.0, 0.001437959756522056, 0.0, 0.0, 0.007027576753350379, 0.0, 0.0, 0.004766555970219698, 0.0, 0.0, 3.159181087440046e-05, 0.0, 0.0, 0.009886834535702795, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.03277292703706178, 0.0, 0.0, 0.00021721262043790919, 0.0, 0.0, 0.00943375773813329, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.031271065872569705, 0.0, 0.0, 0.00020725857517657695, 0.0], [0.0, 0.0, -3.3348993155917235e-47, 0.0, 0.0, -3.0720786780716427e-32, 0.0, 0.0, -6.288823813552807e-18, 0.0, 0.0, -0.00021456321654026293, 0.0, 0.0, -9.959805591293163e-45, 0.0, 0.0, -9.174881607878905e-30, 0.0, 0.0, -1.878181517745977e-15, 0.0, 0.0, -0.064080133207991, 0.0, 0.0, -1.6251518603863676e-44, 0.0, 0.0, -1.4970749958115508e-29, 0.0, 0.0, -3.0646483605829675e-15, 0.0, 0.0, -0.10456022132380947, 0.0, 0.0, -3.5777743458469804e-45, 0.0, 0.0, -3.295812929476108e-30, 0.0, 0.0, -6.746828127759698e-16, 0.0, 0.0, -0.023018948971296145, 0.0, 0.0, 4.3126644927708284e-05, 0.0, 0.0, 0.00021076793419935326, 0.0, 0.0, 0.00014295641162650295, 0.0, 0.0, 9.474874411637849e-07, 0.0, 0.0, 0.001437959756522056, 0.0, 0.0, 0.007027576753350379, 0.0, 0.0, 0.004766555970219698, 0.0, 0.0, 3.159181087440046e-05, 0.0, 0.0, 0.009886834535702795, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.03277292703706178, 0.0, 0.0, 0.00021721262043790919, 0.0, 0.0, 0.00943375773813329, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.031271065872569705, 0.0, 0.0, 0.00020725857517657695], [-2.2103067523297175e-49, 0.0, 0.0, -2.036114318079521e-34, 0.0, 0.0, -4.168110765539356e-20, 0.0, 0.0, -1.422083491706191e-06, 0.0, 0.0, -6.601166472223911e-47, 0.0, 0.0, -6.080934040469598e-32, 0.0, 0.0, -1.2448223763056004e-17, 0.0, 0.0, -0.00042471072652062693, 0.0, 0.0, -1.0771192142980286e-46, 0.0, 0.0, -9.922323461208083e-32, 0.0, 0.0, -2.0311896473884482e-17, 0.0, 0.0, -0.0006930049196285827, 0.0, 0.0, -2.371279623935056e-47, 0.0, 0.0, -2.184401051743317e-32, 0.0, 0.0, -4.471667164844925e-18, 0.0, 0.0, -0.0001525651407372742, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 1.3969290945527585e-06, 0.0, 0.0, 9.474874411637848e-07, 0.0, 0.0, 6.279763467402707e-09, 0.0, 0.0, 9.53051909111431e-06, 0.0, 0.0, 4.657741922769144e-05, 0.0, 0.0, 3.159181087440046e-05, 0.0, 0.0, 2.0938441100018926e-07, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.00021721262043790913, 0.0, 0.0, 1.4396432282092917e-06, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.0003055718959230641, 0.0, 0.0, 0.0002072585751765769, 0.0, 0.0, 1.3736697418396906e-06, 0.0, 0.0], [0.0, -2.2103067523297175e-49, 0.0, 0.0, -2.036114318079521e-34, 0.0, 0.0, -4.168110765539356e-20, 0.0, 0.0, -1.422083491706191e-06, 0.0, 0.0, -6.601166472223911e-47, 0.0, 0.0, -6.080934040469598e-32, 0.0, 0.0, -1.2448223763056004e-17, 0.0, 0.0, -0.00042471072652062693, 0.0, 0.0, -1.0771192142980286e-46, 0.0, 0.0, -9.922323461208083e-32, 0.0, 0.0, -2.0311896473884482e-17, 0.0, 0.0, -0.0006930049196285827, 0.0, 0.0, -2.371279623935056e-47, 0.0, 0.0, -2.184401051743317e-32, 0.0, 0.0, -4.471667164844925e-18, 0.0, 0.0, -0.0001525651407372742, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 1.3969290945527585e-06, 0.0, 0.0, 9.474874411637848e-07, 0.0, 0.0, 6.279763467402707e-09, 0.0, 0.0, 9.53051909111431e-06, 0.0, 0.0, 4.657741922769144e-05, 0.0, 0.0, 3.159181087440046e-05, 0.0, 0.0, 2.0938441100018926e-07, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.00021721262043790913, 0.0, 0.0, 1.4396432282092917e-06, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.0003055718959230641, 0.0, 0.0, 0.0002072585751765769, 0.0, 0.0, 1.3736697418396906e-06, 0.0], [0.0, 0.0, -2.2103067523297175e-49, 0.0, 0.0, -2.036114318079521e-34, 0.0, 0.0, -4.168110765539356e-20, 0.0, 0.0, -1.422083491706191e-06, 0.0, 0.0, -6.601166472223911e-47, 0.0, 0.0, -6.080934040469598e-32, 0.0, 0.0, -1.2448223763056004e-17, 0.0, 0.0, -0.00042471072652062693, 0.0, 0.0, -1.0771192142980286e-46, 0.0, 0.0, -9.922323461208083e-32, 0.0, 0.0, -2.0311896473884482e-17, 0.0, 0.0, -0.0006930049196285827, 0.0, 0.0, -2.371279623935056e-47, 0.0, 0.0, -2.184401051743317e-32, 0.0, 0.0, -4.471667164844925e-18, 0.0, 0.0, -0.0001525651407372742, 0.0, 0.0, 2.858350596774351e-07, 0.0, 0.0, 1.3969290945527585e-06, 0.0, 0.0, 9.474874411637848e-07, 0.0, 0.0, 6.279763467402707e-09, 0.0, 0.0, 9.53051909111431e-06, 0.0, 0.0, 4.657741922769144e-05, 0.0, 0.0, 3.159181087440046e-05, 0.0, 0.0, 2.0938441100018926e-07, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.00021721262043790913, 0.0, 0.0, 1.4396432282092917e-06, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.0003055718959230641, 0.0, 0.0, 0.0002072585751765769, 0.0, 0.0, 1.3736697418396906e-06], [-6.917279044341978e-47, 0.0, 0.0, -6.37213404406011e-32, 0.0, 0.0, -1.3044336593810779e-17, 0.0, 0.0, -0.0004450490107816718, 0.0, 0.0, -2.06587209935446e-44, 0.0, 0.0, -1.9030624398097764e-29, 0.0, 0.0, -3.895741497631827e-15, 0.0, 0.0, -0.13291560573535016, 0.0, 0.0, -3.3709050390714297e-44, 0.0, 0.0, -3.105246820472044e-29, 0.0, 0.0, -6.356722010714178e-15, 0.0, 0.0, -0.21687977938446806, 0.0, 0.0, -7.421052681322235e-45, 0.0, 0.0, -6.836205700288521e-30, 0.0, 0.0, -1.3994333383839628e-15, 0.0, 0.0, -0.04774611713087706, 0.0, 0.0, 8.945368629765721e-05, 0.0, 0.0, 0.00043717680100268557, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 1.965287224983746e-06, 0.0, 0.0, 0.0029826294436814857, 0.0, 0.0, 0.014576664783005618, 0.0, 0.0, 0.009886834535702795, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.020507363754266386, 0.0, 0.0, 0.10022330050498329, 0.0, 0.0, 0.06797790876483835, 0.0, 0.0, 0.0004505444288818535, 0.0, 0.0, 0.019567587664879708, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.00042989765601805926, 0.0, 0.0], [0.0, -6.917279044341978e-47, 0.0, 0.0, -6.37213404406011e-32, 0.0, 0.0, -1.3044336593810779e-17, 0.0, 0.0, -0.0004450490107816718, 0.0, 0.0, -2.06587209935446e-44, 0.0, 0.0, -1.9030624398097764e-29, 0.0, 0.0, -3.895741497631827e-15, 0.0, 0.0, -0.13291560573535016, 0.0, 0.0, -3.3709050390714297e-44, 0.0, 0.0, -3.105246820472044e-29, 0.0, 0.0, -6.356722010714178e-15, 0.0, 0.0, -0.21687977938446806, 0.0, 0.0, -7.421052681322235e-45, 0.0, 0.0, -6.836205700288521e-30, 0.0, 0.0, -1.3994333383839628e-15, 0.0, 0.0, -0.04774611713087706, 0.0, 0.0, 8.945368629765721e-05, 0.0, 0.0, 0.00043717680100268557, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 1.965287224983746e-06, 0.0, 0.0, 0.0029826294436814857, 0.0, 0.0, 0.014576664783005618, 0.0, 0.0, 0.009886834535702795, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.020507363754266386, 0.0, 0.0, 0.10022330050498329, 0.0, 0.0, 0.06797790876483835, 0.0, 0.0, 0.0004505444288818535, 0.0, 0.0, 0.019567587664879708, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.00042989765601805926, 0.0], [0.0, 0.0, -6.917279044341978e-47, 0.0, 0.0, -6.37213404406011e-32, 0.0, 0.0, -1.3044336593810779e-17, 0.0, 0.0, -0.0004450490107816718, 0.0, 0.0, -2.06587209935446e-44, 0.0, 0.0, -1.9030624398097764e-29, 0.0, 0.0, -3.895741497631827e-15, 0.0, 0.0, -0.13291560573535016, 0.0, 0.0, -3.3709050390714297e-44, 0.0, 0.0, -3.105246820472044e-29, 0.0, 0.0, -6.356722010714178e-15, 0.0, 0.0, -0.21687977938446806, 0.0, 0.0, -7.421052681322235e-45, 0.0, 0.0, -6.836205700288521e-30, 0.0, 0.0, -1.3994333383839628e-15, 0.0, 0.0, -0.04774611713087706, 0.0, 0.0, 8.945368629765721e-05, 0.0, 0.0, 0.00043717680100268557, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 1.965287224983746e-06, 0.0, 0.0, 0.0029826294436814857, 0.0, 0.0, 0.014576664783005618, 0.0, 0.0, 0.009886834535702795, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.020507363754266386, 0.0, 0.0, 0.10022330050498329, 0.0, 0.0, 0.06797790876483835, 0.0, 0.0, 0.0004505444288818535, 0.0, 0.0, 0.019567587664879708, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.00042989765601805926], [-3.3806029124230076e-46, 0.0, 0.0, -3.114180412501864e-31, 0.0, 0.0, -6.375009884230805e-17, 0.0, 0.0, -0.0021750372832655043, 0.0, 0.0, -1.009630114818576e-43, 0.0, 0.0, -9.300620063616017e-29, 0.0, 0.0, -1.9039213205825135e-14, 0.0, 0.0, -0.6495832840846989, 0.0, 0.0, -1.6474239826868668e-43, 0.0, 0.0, -1.5175918707033575e-28, 0.0, 0.0, -3.106648265181852e-14, 0.0, 0.0, -1.0599318158669684, 0.0, 0.0, -3.626806457698575e-44, 0.0, 0.0, -3.340980861430114e-29, 0.0, 0.0, -6.839290982994769e-15, 0.0, 0.0, -0.2333441539582817, 0.0, 0.0, 0.0004371768010026856, 0.0, 0.0, 0.0021365643300487137, 0.0, 0.0, 0.0014491557788105162, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 0.014576664783005617, 0.0, 0.0, 0.07123887167621173, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.10022330050498329, 0.0, 0.0, 0.4898099085028647, 0.0, 0.0, 0.3322206822620655, 0.0, 0.0, 0.002201894413526358, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.4673637449749024, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0], [0.0, -3.3806029124230076e-46, 0.0, 0.0, -3.114180412501864e-31, 0.0, 0.0, -6.375009884230805e-17, 0.0, 0.0, -0.0021750372832655043, 0.0, 0.0, -1.009630114818576e-43, 0.0, 0.0, -9.300620063616017e-29, 0.0, 0.0, -1.9039213205825135e-14, 0.0, 0.0, -0.6495832840846989, 0.0, 0.0, -1.6474239826868668e-43, 0.0, 0.0, -1.5175918707033575e-28, 0.0, 0.0, -3.106648265181852e-14, 0.0, 0.0, -1.0599318158669684, 0.0, 0.0, -3.626806457698575e-44, 0.0, 0.0, -3.340980861430114e-29, 0.0, 0.0, -6.839290982994769e-15, 0.0, 0.0, -0.2333441539582817, 0.0, 0.0, 0.0004371768010026856, 0.0, 0.0, 0.0021365643300487137, 0.0, 0.0, 0.0014491557788105162, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 0.014576664783005617, 0.0, 0.0, 0.07123887167621173, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.10022330050498329, 0.0, 0.0, 0.4898099085028647, 0.0, 0.0, 0.3322206822620655, 0.0, 0.0, 0.002201894413526358, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.4673637449749024, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.0021009897947766327, 0.0], [0.0, 0.0, -3.3806029124230076e-46, 0.0, 0.0, -3.114180412501864e-31, 0.0, 0.0, -6.375009884230805e-17, 0.0, 0.0, -0.0021750372832655043, 0.0, 0.0, -1.009630114818576e-43, 0.0, 0.0, -9.300620063616017e-29, 0.0, 0.0, -1.9039213205825135e-14, 0.0, 0.0, -0.6495832840846989, 0.0, 0.0, -1.6474239826868668e-43, 0.0, 0.0, -1.5175918707033575e-28, 0.0, 0.0, -3.106648265181852e-14, 0.0, 0.0, -1.0599318158669684, 0.0, 0.0, -3.626806457698575e-44, 0.0, 0.0, -3.340980861430114e-29, 0.0, 0.0, -6.839290982994769e-15, 0.0, 0.0, -0.2333441539582817, 0.0, 0.0, 0.0004371768010026856, 0.0, 0.0, 0.0021365643300487137, 0.0, 0.0, 0.0014491557788105162, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 0.014576664783005617, 0.0, 0.0, 0.07123887167621173, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.10022330050498329, 0.0, 0.0, 0.4898099085028647, 0.0, 0.0, 0.3322206822620655, 0.0, 0.0, 0.002201894413526358, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.4673637449749024, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.0021009897947766327], [-2.292943010187652e-46, 0.0, 0.0, -2.112238081281034e-31, 0.0, 0.0, -4.3239430162613425e-17, 0.0, 0.0, -0.0014752506179398148, 0.0, 0.0, -6.847962847517468e-44, 0.0, 0.0, -6.308280598975872e-29, 0.0, 0.0, -1.2913622797680007e-14, 0.0, 0.0, -0.44058929408813613, 0.0, 0.0, -1.117389236114073e-43, 0.0, 0.0, -1.029328721057273e-28, 0.0, 0.0, -2.107129292997838e-14, 0.0, 0.0, -0.7189141438459379, 0.0, 0.0, -2.459934139535764e-44, 0.0, 0.0, -2.2660687788073284e-29, 0.0, 0.0, -4.63884841265114e-15, 0.0, 0.0, -0.15826906047457265, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 0.001449155778810516, 0.0, 0.0, 0.0009829109480696198, 0.0, 0.0, 6.514543618452853e-06, 0.0, 0.0, 0.009886834535702793, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.03277292703706178, 0.0, 0.0, 0.00021721262043790913, 0.0, 0.0, 0.06797790876483835, 0.0, 0.0, 0.3322206822620655, 0.0, 0.0, 0.22533350143941963, 0.0, 0.0, 0.001493466856492714, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.21500730645268026, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0], [0.0, -2.292943010187652e-46, 0.0, 0.0, -2.112238081281034e-31, 0.0, 0.0, -4.3239430162613425e-17, 0.0, 0.0, -0.0014752506179398148, 0.0, 0.0, -6.847962847517468e-44, 0.0, 0.0, -6.308280598975872e-29, 0.0, 0.0, -1.2913622797680007e-14, 0.0, 0.0, -0.44058929408813613, 0.0, 0.0, -1.117389236114073e-43, 0.0, 0.0, -1.029328721057273e-28, 0.0, 0.0, -2.107129292997838e-14, 0.0, 0.0, -0.7189141438459379, 0.0, 0.0, -2.459934139535764e-44, 0.0, 0.0, -2.2660687788073284e-29, 0.0, 0.0, -4.63884841265114e-15, 0.0, 0.0, -0.15826906047457265, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 0.001449155778810516, 0.0, 0.0, 0.0009829109480696198, 0.0, 0.0, 6.514543618452853e-06, 0.0, 0.0, 0.009886834535702793, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.03277292703706178, 0.0, 0.0, 0.00021721262043790913, 0.0, 0.0, 0.06797790876483835, 0.0, 0.0, 0.3322206822620655, 0.0, 0.0, 0.22533350143941963, 0.0, 0.0, 0.001493466856492714, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.21500730645268026, 0.0, 0.0, 0.0014250268337359442, 0.0], [0.0, 0.0, -2.292943010187652e-46, 0.0, 0.0, -2.112238081281034e-31, 0.0, 0.0, -4.3239430162613425e-17, 0.0, 0.0, -0.0014752506179398148, 0.0, 0.0, -6.847962847517468e-44, 0.0, 0.0, -6.308280598975872e-29, 0.0, 0.0, -1.2913622797680007e-14, 0.0, 0.0, -0.44058929408813613, 0.0, 0.0, -1.117389236114073e-43, 0.0, 0.0, -1.029328721057273e-28, 0.0, 0.0, -2.107129292997838e-14, 0.0, 0.0, -0.7189141438459379, 0.0, 0.0, -2.459934139535764e-44, 0.0, 0.0, -2.2660687788073284e-29, 0.0, 0.0, -4.63884841265114e-15, 0.0, 0.0, -0.15826906047457265, 0.0, 0.0, 0.0002965215128909749, 0.0, 0.0, 0.001449155778810516, 0.0, 0.0, 0.0009829109480696198, 0.0, 0.0, 6.514543618452853e-06, 0.0, 0.0, 0.009886834535702793, 0.0, 0.0, 0.04831879907082847, 0.0, 0.0, 0.03277292703706178, 0.0, 0.0, 0.00021721262043790913, 0.0, 0.0, 0.06797790876483835, 0.0, 0.0, 0.3322206822620655, 0.0, 0.0, 0.22533350143941963, 0.0, 0.0, 0.001493466856492714, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.21500730645268026, 0.0, 0.0, 0.0014250268337359442], [-1.5197182698829827e-48, 0.0, 0.0, -1.399950538763133e-33, 0.0, 0.0, -2.8658257839594164e-19, 0.0, 0.0, -9.777675706627422e-06, 0.0, 0.0, -4.53869730063657e-46, 0.0, 0.0, -4.181006346523816e-31, 0.0, 0.0, -8.558899374653714e-17, 0.0, 0.0, -0.0029201406086660207, 0.0, 0.0, -7.405839696618428e-46, 0.0, 0.0, -6.822191638238763e-31, 0.0, 0.0, -1.396564532719179e-16, 0.0, 0.0, -0.004764823870570344, 0.0, 0.0, -1.630396759950622e-46, 0.0, 0.0, -1.501906549209472e-31, 0.0, 0.0, -3.074538988802285e-17, 0.0, 0.0, -0.0010489767154777143, 0.0, 0.0, 1.9652872249837465e-06, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 6.514543618452855e-06, 0.0, 0.0, 4.3177134856492426e-08, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.00021721262043790919, 0.0, 0.0, 1.4396432282092917e-06, 0.0, 0.0, 0.0004505444288818535, 0.0, 0.0, 0.002201894413526358, 0.0, 0.0, 0.001493466856492714, 0.0, 0.0, 9.898409411801899e-06, 0.0, 0.0, 0.0004298976560180593, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 9.444802180778056e-06, 0.0, 0.0], [0.0, -1.5197182698829827e-48, 0.0, 0.0, -1.399950538763133e-33, 0.0, 0.0, -2.8658257839594164e-19, 0.0, 0.0, -9.777675706627422e-06, 0.0, 0.0, -4.53869730063657e-46, 0.0, 0.0, -4.181006346523816e-31, 0.0, 0.0, -8.558899374653714e-17, 0.0, 0.0, -0.0029201406086660207, 0.0, 0.0, -7.405839696618428e-46, 0.0, 0.0, -6.822191638238763e-31, 0.0, 0.0, -1.396564532719179e-16, 0.0, 0.0, -0.004764823870570344, 0.0, 0.0, -1.630396759950622e-46, 0.0, 0.0, -1.501906549209472e-31, 0.0, 0.0, -3.074538988802285e-17, 0.0, 0.0, -0.0010489767154777143, 0.0, 0.0, 1.9652872249837465e-06, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 6.514543618452855e-06, 0.0, 0.0, 4.3177134856492426e-08, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.00021721262043790919, 0.0, 0.0, 1.4396432282092917e-06, 0.0, 0.0, 0.0004505444288818535, 0.0, 0.0, 0.002201894413526358, 0.0, 0.0, 0.001493466856492714, 0.0, 0.0, 9.898409411801899e-06, 0.0, 0.0, 0.0004298976560180593, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 9.444802180778056e-06, 0.0], [0.0, 0.0, -1.5197182698829827e-48, 0.0, 0.0, -1.399950538763133e-33, 0.0, 0.0, -2.8658257839594164e-19, 0.0, 0.0, -9.777675706627422e-06, 0.0, 0.0, -4.53869730063657e-46, 0.0, 0.0, -4.181006346523816e-31, 0.0, 0.0, -8.558899374653714e-17, 0.0, 0.0, -0.0029201406086660207, 0.0, 0.0, -7.405839696618428e-46, 0.0, 0.0, -6.822191638238763e-31, 0.0, 0.0, -1.396564532719179e-16, 0.0, 0.0, -0.004764823870570344, 0.0, 0.0, -1.630396759950622e-46, 0.0, 0.0, -1.501906549209472e-31, 0.0, 0.0, -3.074538988802285e-17, 0.0, 0.0, -0.0010489767154777143, 0.0, 0.0, 1.9652872249837465e-06, 0.0, 0.0, 9.604724160957706e-06, 0.0, 0.0, 6.514543618452855e-06, 0.0, 0.0, 4.3177134856492426e-08, 0.0, 0.0, 6.552802668212815e-05, 0.0, 0.0, 0.000320247652909321, 0.0, 0.0, 0.00021721262043790919, 0.0, 0.0, 1.4396432282092917e-06, 0.0, 0.0, 0.0004505444288818535, 0.0, 0.0, 0.002201894413526358, 0.0, 0.0, 0.001493466856492714, 0.0, 0.0, 9.898409411801899e-06, 0.0, 0.0, 0.0004298976560180593, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 9.444802180778056e-06], [-6.600285913124139e-47, 0.0, 0.0, -6.080122877499087e-32, 0.0, 0.0, -1.2446563238850672e-17, 0.0, 0.0, -0.0004246540724585635, 0.0, 0.0, -1.971200876569889e-44, 0.0, 0.0, -1.8158521772439193e-29, 0.0, 0.0, -3.7172141767252494e-15, 0.0, 0.0, -0.12682457864512056, 0.0, 0.0, -3.2164290180054186e-44, 0.0, 0.0, -2.962944925967611e-29, 0.0, 0.0, -6.065417120230418e-15, 0.0, 0.0, -0.2069409869887571, 0.0, 0.0, -7.080973480916252e-45, 0.0, 0.0, -6.522927858424352e-30, 0.0, 0.0, -1.3353025214801945e-15, 0.0, 0.0, -0.04555809044064394, 0.0, 0.0, 8.535435707634051e-05, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 0.00284594664679642, 0.0, 0.0, 0.01390867053517239, 0.0, 0.0, 0.00943375773813329, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.019567587664879708, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.0004298976560180593, 0.0, 0.0, 0.01867087801293305, 0.0, 0.0, 0.09124805314836114, 0.0, 0.0, 0.06189031692864673, 0.0, 0.0, 0.00041019704784383204, 0.0, 0.0], [0.0, -6.600285913124139e-47, 0.0, 0.0, -6.080122877499087e-32, 0.0, 0.0, -1.2446563238850672e-17, 0.0, 0.0, -0.0004246540724585635, 0.0, 0.0, -1.971200876569889e-44, 0.0, 0.0, -1.8158521772439193e-29, 0.0, 0.0, -3.7172141767252494e-15, 0.0, 0.0, -0.12682457864512056, 0.0, 0.0, -3.2164290180054186e-44, 0.0, 0.0, -2.962944925967611e-29, 0.0, 0.0, -6.065417120230418e-15, 0.0, 0.0, -0.2069409869887571, 0.0, 0.0, -7.080973480916252e-45, 0.0, 0.0, -6.522927858424352e-30, 0.0, 0.0, -1.3353025214801945e-15, 0.0, 0.0, -0.04555809044064394, 0.0, 0.0, 8.535435707634051e-05, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 0.00284594664679642, 0.0, 0.0, 0.01390867053517239, 0.0, 0.0, 0.00943375773813329, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.019567587664879708, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.0004298976560180593, 0.0, 0.0, 0.01867087801293305, 0.0, 0.0, 0.09124805314836114, 0.0, 0.0, 0.06189031692864673, 0.0, 0.0, 0.00041019704784383204, 0.0], [0.0, 0.0, -6.600285913124139e-47, 0.0, 0.0, -6.080122877499087e-32, 0.0, 0.0, -1.2446563238850672e-17, 0.0, 0.0, -0.0004246540724585635, 0.0, 0.0, -1.971200876569889e-44, 0.0, 0.0, -1.8158521772439193e-29, 0.0, 0.0, -3.7172141767252494e-15, 0.0, 0.0, -0.12682457864512056, 0.0, 0.0, -3.2164290180054186e-44, 0.0, 0.0, -2.962944925967611e-29, 0.0, 0.0, -6.065417120230418e-15, 0.0, 0.0, -0.2069409869887571, 0.0, 0.0, -7.080973480916252e-45, 0.0, 0.0, -6.522927858424352e-30, 0.0, 0.0, -1.3353025214801945e-15, 0.0, 0.0, -0.04555809044064394, 0.0, 0.0, 8.535435707634051e-05, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 0.00284594664679642, 0.0, 0.0, 0.01390867053517239, 0.0, 0.0, 0.00943375773813329, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.019567587664879708, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.0004298976560180593, 0.0, 0.0, 0.01867087801293305, 0.0, 0.0, 0.09124805314836114, 0.0, 0.0, 0.06189031692864673, 0.0, 0.0, 0.00041019704784383204], [-3.2256824739466007e-46, 0.0, 0.0, -2.9714691247530063e-31, 0.0, 0.0, -6.08286692862748e-17, 0.0, 0.0, -0.0020753634267508055, 0.0, 0.0, -9.633625276045034e-44, 0.0, 0.0, -8.87440729160928e-29, 0.0, 0.0, -1.816671698710237e-14, 0.0, 0.0, -0.6198153019216538, 0.0, 0.0, -1.5719286783384859e-43, 0.0, 0.0, -1.4480462884128052e-28, 0.0, 0.0, -2.9642821476868554e-14, 0.0, 0.0, -1.0113590890714652, 0.0, 0.0, -3.4606034278689006e-44, 0.0, 0.0, -3.187876153955594e-29, 0.0, 0.0, -6.52587175411708e-15, 0.0, 0.0, -0.2226508606068856, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0020386535456652977, 0.0, 0.0, 0.0013827463676818268, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 0.013908670535172389, 0.0, 0.0, 0.06797425955744235, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.0003055718959230641, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.4673637449749024, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.09124805314836114, 0.0, 0.0, 0.44594620550778036, 0.0, 0.0, 0.3024694888243723, 0.0, 0.0, 0.0020047092588269186, 0.0, 0.0], [0.0, -3.2256824739466007e-46, 0.0, 0.0, -2.9714691247530063e-31, 0.0, 0.0, -6.08286692862748e-17, 0.0, 0.0, -0.0020753634267508055, 0.0, 0.0, -9.633625276045034e-44, 0.0, 0.0, -8.87440729160928e-29, 0.0, 0.0, -1.816671698710237e-14, 0.0, 0.0, -0.6198153019216538, 0.0, 0.0, -1.5719286783384859e-43, 0.0, 0.0, -1.4480462884128052e-28, 0.0, 0.0, -2.9642821476868554e-14, 0.0, 0.0, -1.0113590890714652, 0.0, 0.0, -3.4606034278689006e-44, 0.0, 0.0, -3.187876153955594e-29, 0.0, 0.0, -6.52587175411708e-15, 0.0, 0.0, -0.2226508606068856, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0020386535456652977, 0.0, 0.0, 0.0013827463676818268, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 0.013908670535172389, 0.0, 0.0, 0.06797425955744235, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.0003055718959230641, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.4673637449749024, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.09124805314836114, 0.0, 0.0, 0.44594620550778036, 0.0, 0.0, 0.3024694888243723, 0.0, 0.0, 0.0020047092588269186, 0.0], [0.0, 0.0, -3.2256824739466007e-46, 0.0, 0.0, -2.9714691247530063e-31, 0.0, 0.0, -6.08286692862748e-17, 0.0, 0.0, -0.0020753634267508055, 0.0, 0.0, -9.633625276045034e-44, 0.0, 0.0, -8.87440729160928e-29, 0.0, 0.0, -1.816671698710237e-14, 0.0, 0.0, -0.6198153019216538, 0.0, 0.0, -1.5719286783384859e-43, 0.0, 0.0, -1.4480462884128052e-28, 0.0, 0.0, -2.9642821476868554e-14, 0.0, 0.0, -1.0113590890714652, 0.0, 0.0, -3.4606034278689006e-44, 0.0, 0.0, -3.187876153955594e-29, 0.0, 0.0, -6.52587175411708e-15, 0.0, 0.0, -0.2226508606068856, 0.0, 0.0, 0.0004171426167291751, 0.0, 0.0, 0.0020386535456652977, 0.0, 0.0, 0.0013827463676818268, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 0.013908670535172389, 0.0, 0.0, 0.06797425955744235, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.0003055718959230641, 0.0, 0.0, 0.09563043998216722, 0.0, 0.0, 0.4673637449749024, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.09124805314836114, 0.0, 0.0, 0.44594620550778036, 0.0, 0.0, 0.3024694888243723, 0.0, 0.0, 0.0020047092588269186], [-2.1878659734158057e-46, 0.0, 0.0, -2.015442078261536e-31, 0.0, 0.0, -4.125792814838814e-17, 0.0, 0.0, -0.0014076453775390668, 0.0, 0.0, -6.534146219392052e-44, 0.0, 0.0, -6.019195597944178e-29, 0.0, 0.0, -1.232183956907786e-14, 0.0, 0.0, -0.4203987279683127, 0.0, 0.0, -1.0661834497818542e-43, 0.0, 0.0, -9.821584200980699e-29, 0.0, 0.0, -2.010567406714738e-14, 0.0, 0.0, -0.6859689866426991, 0.0, 0.0, -2.3472045213604017e-44, 0.0, 0.0, -2.1622232879511105e-29, 0.0, 0.0, -4.4262672699583384e-15, 0.0, 0.0, -0.15101617899716896, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 0.0013827463676818266, 0.0, 0.0, 0.0009378678007367476, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 0.009433757738133288, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.031271065872569705, 0.0, 0.0, 0.0002072585751765769, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.21500730645268026, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 0.06189031692864673, 0.0, 0.0, 0.3024694888243723, 0.0, 0.0, 0.20515432251633073, 0.0, 0.0, 0.0013597231622778886, 0.0, 0.0], [0.0, -2.1878659734158057e-46, 0.0, 0.0, -2.015442078261536e-31, 0.0, 0.0, -4.125792814838814e-17, 0.0, 0.0, -0.0014076453775390668, 0.0, 0.0, -6.534146219392052e-44, 0.0, 0.0, -6.019195597944178e-29, 0.0, 0.0, -1.232183956907786e-14, 0.0, 0.0, -0.4203987279683127, 0.0, 0.0, -1.0661834497818542e-43, 0.0, 0.0, -9.821584200980699e-29, 0.0, 0.0, -2.010567406714738e-14, 0.0, 0.0, -0.6859689866426991, 0.0, 0.0, -2.3472045213604017e-44, 0.0, 0.0, -2.1622232879511105e-29, 0.0, 0.0, -4.4262672699583384e-15, 0.0, 0.0, -0.15101617899716896, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 0.0013827463676818266, 0.0, 0.0, 0.0009378678007367476, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 0.009433757738133288, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.031271065872569705, 0.0, 0.0, 0.0002072585751765769, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.21500730645268026, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 0.06189031692864673, 0.0, 0.0, 0.3024694888243723, 0.0, 0.0, 0.20515432251633073, 0.0, 0.0, 0.0013597231622778886, 0.0], [0.0, 0.0, -2.1878659734158057e-46, 0.0, 0.0, -2.015442078261536e-31, 0.0, 0.0, -4.125792814838814e-17, 0.0, 0.0, -0.0014076453775390668, 0.0, 0.0, -6.534146219392052e-44, 0.0, 0.0, -6.019195597944178e-29, 0.0, 0.0, -1.232183956907786e-14, 0.0, 0.0, -0.4203987279683127, 0.0, 0.0, -1.0661834497818542e-43, 0.0, 0.0, -9.821584200980699e-29, 0.0, 0.0, -2.010567406714738e-14, 0.0, 0.0, -0.6859689866426991, 0.0, 0.0, -2.3472045213604017e-44, 0.0, 0.0, -2.1622232879511105e-29, 0.0, 0.0, -4.4262672699583384e-15, 0.0, 0.0, -0.15101617899716896, 0.0, 0.0, 0.0002829330365201041, 0.0, 0.0, 0.0013827463676818266, 0.0, 0.0, 0.0009378678007367476, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 0.009433757738133288, 0.0, 0.0, 0.046104528500570646, 0.0, 0.0, 0.031271065872569705, 0.0, 0.0, 0.0002072585751765769, 0.0, 0.0, 0.06486273442896529, 0.0, 0.0, 0.3169962459410066, 0.0, 0.0, 0.21500730645268026, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 0.06189031692864673, 0.0, 0.0, 0.3024694888243723, 0.0, 0.0, 0.20515432251633073, 0.0, 0.0, 0.0013597231622778886], [-1.4500752426390248e-48, 0.0, 0.0, -1.3357960204925978e-33, 0.0, 0.0, -2.734495663697001e-19, 0.0, 0.0, -9.329601251569599e-06, 0.0, 0.0, -4.330705710336976e-46, 0.0, 0.0, -3.98940640022552e-31, 0.0, 0.0, -8.166676898856804e-17, 0.0, 0.0, -0.0027863214423141064, 0.0, 0.0, -7.066457650631908e-46, 0.0, 0.0, -6.509556008634898e-31, 0.0, 0.0, -1.3325651824925112e-16, 0.0, 0.0, -0.004546469741909154, 0.0, 0.0, -1.5556817497925587e-46, 0.0, 0.0, -1.433079766773983e-31, 0.0, 0.0, -2.933644319834296e-17, 0.0, 0.0, -0.0010009060201244784, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 4.1198487604091976e-08, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.0003055718959230642, 0.0, 0.0, 0.00020725857517657695, 0.0, 0.0, 1.3736697418396906e-06, 0.0, 0.0, 0.00042989765601805926, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 9.444802180778056e-06, 0.0, 0.0, 0.00041019704784383204, 0.0, 0.0, 0.0020047092588269186, 0.0, 0.0, 0.0013597231622778886, 0.0, 0.0, 9.011982079431004e-06, 0.0, 0.0], [0.0, -1.4500752426390248e-48, 0.0, 0.0, -1.3357960204925978e-33, 0.0, 0.0, -2.734495663697001e-19, 0.0, 0.0, -9.329601251569599e-06, 0.0, 0.0, -4.330705710336976e-46, 0.0, 0.0, -3.98940640022552e-31, 0.0, 0.0, -8.166676898856804e-17, 0.0, 0.0, -0.0027863214423141064, 0.0, 0.0, -7.066457650631908e-46, 0.0, 0.0, -6.509556008634898e-31, 0.0, 0.0, -1.3325651824925112e-16, 0.0, 0.0, -0.004546469741909154, 0.0, 0.0, -1.5556817497925587e-46, 0.0, 0.0, -1.433079766773983e-31, 0.0, 0.0, -2.933644319834296e-17, 0.0, 0.0, -0.0010009060201244784, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 4.1198487604091976e-08, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.0003055718959230642, 0.0, 0.0, 0.00020725857517657695, 0.0, 0.0, 1.3736697418396906e-06, 0.0, 0.0, 0.00042989765601805926, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 9.444802180778056e-06, 0.0, 0.0, 0.00041019704784383204, 0.0, 0.0, 0.0020047092588269186, 0.0, 0.0, 0.0013597231622778886, 0.0, 0.0, 9.011982079431004e-06, 0.0], [0.0, 0.0, -1.4500752426390248e-48, 0.0, 0.0, -1.3357960204925978e-33, 0.0, 0.0, -2.734495663697001e-19, 0.0, 0.0, -9.329601251569599e-06, 0.0, 0.0, -4.330705710336976e-46, 0.0, 0.0, -3.98940640022552e-31, 0.0, 0.0, -8.166676898856804e-17, 0.0, 0.0, -0.0027863214423141064, 0.0, 0.0, -7.066457650631908e-46, 0.0, 0.0, -6.509556008634898e-31, 0.0, 0.0, -1.3325651824925112e-16, 0.0, 0.0, -0.004546469741909154, 0.0, 0.0, -1.5556817497925587e-46, 0.0, 0.0, -1.433079766773983e-31, 0.0, 0.0, -2.933644319834296e-17, 0.0, 0.0, -0.0010009060201244784, 0.0, 0.0, 1.875225432305368e-06, 0.0, 0.0, 9.164575430980418e-06, 0.0, 0.0, 6.21600635158378e-06, 0.0, 0.0, 4.1198487604091976e-08, 0.0, 0.0, 6.252512131611078e-05, 0.0, 0.0, 0.0003055718959230642, 0.0, 0.0, 0.00020725857517657695, 0.0, 0.0, 1.3736697418396906e-06, 0.0, 0.0, 0.00042989765601805926, 0.0, 0.0, 0.0021009897947766327, 0.0, 0.0, 0.0014250268337359442, 0.0, 0.0, 9.444802180778056e-06, 0.0, 0.0, 0.00041019704784383204, 0.0, 0.0, 0.0020047092588269186, 0.0, 0.0, 0.0013597231622778886, 0.0, 0.0, 9.011982079431004e-06]]
}


@pytest.fixture
def element():
    nodes_a = []
    for ref_location, act_location in zip(DATA['ref_locations_a'], DATA['act_locations_a']):
        node = eq.Node()
        node.ref_location = ref_location
        node.act_location = act_location
        nodes_a.append(node)

    nodes_b = []
    for ref_location, act_location in zip(DATA['ref_locations_b'], DATA['act_locations_b']):
        node = eq.Node()
        node.ref_location = ref_location
        node.act_location = act_location
        nodes_b.append(node)

    shape_functions_a = DATA['shape_functions_a']
    shape_functions_b = DATA['shape_functions_b']

    weight = DATA['weight']

    return PointCoupling(nodes_a, nodes_b, shape_functions_a, shape_functions_b, weight)


def test_element(element):
    f, g, h = element.compute_all()

    assert_almost_equal(f, DATA['exp_f'])
    assert_almost_equal(g, DATA['exp_g'])
    assert_almost_equal(h, DATA['exp_h'])
