from morphr.constraints.rotation_coupling import RotationCoupling
import pytest
import eqlib as eq
from numpy.testing import assert_almost_equal

if __name__ == '__main__':
    import sys
    pytest.main(sys.argv)


DATA = {
    "ref_locations_a": [[-6.7369613697638036, 2.6325435700231465, -0.14110785709398277], [-7.1222051089564005, 2.410122844140494, -0.32993574021563665], [-7.358307868100445, 2.2738087610573885, -0.5016014873370465], [-7.469651096411474, 2.209524675052946, -0.597791357063161], [-6.611442414432476, 2.4151393082075923, -0.14110773606036797], [-6.996686011778227, 2.192718664148025, -0.3299354581589417], [-7.232788705532096, 2.0564046187740783, -0.5016010647020163], [-7.34413191054661, 1.992120546199293, -0.5977908586541971], [-6.360404503858186, 1.9803307846612714, -0.14110749399761124], [-6.745647817517658, 1.7579103042698372, -0.32993489405600696], [-6.981750380494455, 1.6215963343283635, -0.5016002194478121], [-7.093093538917164, 1.557312288619758, -0.5977898618551368], [-5.9838476379206, 1.3281179990290706, -0.14110713091549562], [-6.369090526070127, 1.1056977641978338, -0.32993404792968783], [-6.605192892890002, 0.9693839074423594, -0.5015989516090873], [-6.7165359814282315, 0.9050999020510813, -0.5977883667071976]],
    "act_locations_a": [[-6.711022354939664, 2.469132745936724, -1.1401352442088788], [-7.08560527702184, 2.188667573982846, -1.3005042357410113], [-7.317743973819396, 2.027631221942351, -1.4333290145696758], [-7.378337590659896, 1.9833303887097782, -1.4991393073411778], [-6.55636240841509, 2.2769722543396016, -1.0601387134380749], [-6.92408137699767, 2.009467283940116, -1.167316228872909], [-7.153705036180528, 1.850496415082969, -1.2577317149353604], [-7.265393589537658, 1.7771503548920295, -1.2996427164355104], [-6.305684302307734, 1.8285004705746841, -0.9599110900403799], [-6.700224907403363, 1.5546552920049321, -1.0212167954498284], [-6.9557722151941785, 1.3890719789593913, -1.0828128629750118], [-7.080292664698634, 1.3099312804790286, -1.1222623336365598], [-5.987039515181131, 1.13894710512742, -0.7131222126712982], [-6.404909087627447, 0.8530698813355098, -0.7643638110347886], [-6.673456421463042, 0.682869664838386, -0.8190969553510615], [-6.801271968722462, 0.6023424075431929, -0.853623412962136]],
    "ref_locations_b": [[-7.349517886409734, -0.0986620277906453, -1.394989211344196], [-6.62503375541969, 0.49413842654350865, -0.6883511723852459], [-6.137407946159692, 0.8970494013862456, -0.22773654806278656], [-5.892505400454348, 1.1003453463013342, 0.0], [-7.676770820555811, 0.46815950093325, -1.3949892113441966], [-6.965598665845105, 1.0840141294570615, -0.6883511723852458], [-6.487189978720082, 1.5028877509808458, -0.2277365480627867], [-6.246978340311884, 1.7143076519600084, 0.0], [-7.894939443319853, 0.8460405200825142, -1.3949892113441962], [-7.192641939462045, 1.4772645980661014, -0.6883511723852459], [-6.7203780004270115, 1.9067799840439081, -0.2277365480627866], [-6.483293633550243, 2.1236158557324596, 0.0], [-8.00402375470188, 1.034981029657147, -1.3949892113441962], [-7.3061635762705155, 1.6738898323706168, -0.6883511723852462], [-6.836972011280475, 2.108726100575444, -0.22773654806278662], [-6.601451280169422, 2.328269957618684, 0.0]],
    "act_locations_b": [[-7.667564471461738, -0.48762221960571334, -0.9288453306325286], [-6.774991858068435, 0.13233751580874098, -0.697231979532194], [-6.198790601648391, 0.6566395682705028, -0.5667346838296227], [-5.967689825635275, 0.9033332907832338, -0.3808021755509196], [-7.9278584842439335, 0.11140788476038671, -1.0998242028753853], [-7.015301332829905, 0.7643623059636866, -1.0018517389160426], [-6.462353886257032, 1.300765553865271, -0.88547421851169], [-6.249471976233697, 1.5437300760985297, -0.7351424444995099], [-8.082830625936179, 0.5240866356400729, -1.2218222849382363], [-7.163982298406642, 1.200191553383816, -1.1782449394558807], [-6.664889412160233, 1.7277655174598872, -1.0069790430383205], [-6.460647502870035, 1.9637438926732216, -0.8961156218770688], [-8.146676189038454, 0.7374367270866864, -1.2826367290515774], [-7.2423679041745395, 1.415847344167247, -1.252725922502769], [-6.766499319474197, 1.932526058652877, -1.1174829267993682], [-6.611316367195651, 2.144924707557423, -0.9123873256670663]],
    "shape_functions_a": [
        [0] * 16,
        [-3.3738690088876406e-46, -2.972847758717572e-31, -5.82109393843024e-17, -0.0018997011950726578, -1.840006395356265e-43, -1.62130150105156e-28, -3.1746490591265074e-14, -1.0360397333126097, 7.152080289351449e-44, 6.301977285530905e-29, 1.2339818502093071e-14, 0.4027072609264134, 1.1281722354300077e-43, 9.940766202571872e-29, 1.9464883028556305e-14, 0.635232173581269],
        [-2.1730058481920835e-33, -1.2764802167206542e-18, -0.00012497295279062666, 0.00012497295279062797, -5.565167891605247e-29, -3.2691245273331393e-14, -3.2006147832880356, 3.200614783288068, -1.2045313164335004e-28, -7.075730592842549e-14, -6.927447317673706, 6.927447317673777, -3.254672586570693e-29, -1.9118794236642527e-14, -1.8718129260851009, 1.87181292608512],
    ],
    "shape_functions_b": [
        [0] * 16,
        [-0.00791889752313056, -0.03870114160139637, -0.026249626879836323, -0.000173978063346298, -0.10408591476512762, -0.5086874421937967, -0.3450248494882562, -0.0022867660327173783, -0.09899487053962873, -0.48380655152757773, -0.32814901406321834, -0.00217491586516874, 0.21099968282788686, 1.0311951353227706, 0.6994234904313108, 0.004635659961232416],
        [-0.0026561232065900925, -0.003784423241809084, 0.006061942493821491, 0.00037860395457768494, -0.059672426587779784, -0.08502079930390471, 0.13618751477507418, 0.008505711116610326, -0.2666780511302304, -0.37996076848905896, 0.6086265148788802, 0.03801230474040914, -0.1491413982683874, -0.21249547932205307, 0.3403782541065747, 0.021258623483865757],
    ],
    "axis": [-0.5000025499899519, 0.8660239315397725, -1.9853299552541596e-06],
    "weight": 4.119843789445992,
    "exp_f": 0.0036945581774914583,
    "exp_g": [-8.550917040463348e-35, 3.803625064316818e-35, 1.8910894769356967e-34, -5.0230313213615834e-20, 2.2343484029104865e-20, 1.110875199606729e-19, -4.917765649380929e-06, 2.1875240510353496e-06, 1.0875950293485934e-05, 2.7683464118091363e-05, -1.2314178407814597e-05, -6.122373475396597e-05, -2.1899291710126355e-30, 9.74125867965485e-31, 4.843167102358069e-30, -1.286421417200894e-15, 5.722268994758185e-16, 2.8450024640181678e-15, -0.12594623945972264, 0.05602349676631765, 0.2785380877569581, 0.1383619647492455, -0.06154626861399569, -0.3059962508199796, -4.739907795477316e-30, 2.1084091926181606e-30, 1.0482606381580475e-29, -2.784345258454168e-15, 1.2385344592460332e-15, 6.1577559383422136e-15, -0.27259948409662466, 0.12125789845969215, 0.6028710293338233, 0.26777350825516877, -0.11911120441699626, -0.5921980780158103, -1.28073448604808e-30, 5.696972346726717e-31, 2.8324254554841675e-30, -7.523367853208643e-16, 3.3465498962423795e-16, 1.663840464244316e-15, -0.07365703621800206, 0.0327641757949862, 0.16289720206031535, 0.06604452107147127, -0.02937797133564944, -0.14606164253085707, 6.862206980195987e-05, -3.712523530279606e-05, -0.00016878836930498298, 0.0007701584616174436, -0.00041666353391121857, -0.0018943437762515584, 0.0009303184200619722, -0.0005033116947798564, -0.002288286108387884, 2.216593264544018e-05, -1.1991994230759698e-05, -5.452111304927563e-05, -0.0002686393465714076, 0.00014533660937123138, 0.0006607669714685442, 0.008455083773941822, -0.004574286020785062, -0.020796804973374664, 0.014899717180898948, -0.008060898015498016, -0.03664854431420176, 0.00045820722670993156, -0.0002478947539492886, -0.0011270433961454072, -0.010180187218390877, 0.005507584469544554, 0.025040008335081618, -0.006099086754004265, 0.0032996677530718714, 0.01500180496491817, 0.036821581050068795, -0.019920848564461878, -0.0905693261454914, 0.0018504609545378708, -0.001001118132316853, -0.004551542789081966, -0.012225416038228173, 0.006614073991117548, 0.030070617851118576, -0.03533446401551771, 0.019116303175641076, 0.08691149332360276, -0.0010598940341883293, 0.0005734134153754013, 0.002607000724155027, 0.000891372336616568, -0.0004822414688859757, -0.002192491185055832],
    "exp_h": [[1.1654011081542796e-66, -4.3301589923453007e-67, -2.3526179548206297e-66, 6.845869560548591e-52, -2.543648142310511e-52, -1.3819890449576012e-51, 6.702403391719684e-38, -2.4903419186674127e-38, -1.353027249543593e-37, -4.158988855602979e-37, 1.5735922984936656e-37, 8.47027361635478e-37, 2.984645822899049e-62, -1.1089736279263314e-62, -6.025162755210923e-62, 1.7532586716314254e-47, -6.514399848903498e-48, -3.5393374877235947e-47, 1.716516326139826e-33, -6.377880159144244e-34, -3.4651649980108786e-33, -1.9067821475191736e-33, 7.100254199391374e-34, 3.853318147933483e-33, 6.460001624690165e-62, -2.4002752297035125e-62, -1.3040931318905686e-61, 3.794773162143543e-47, -1.4099841691407743e-47, -7.660582621093998e-47, 3.715247608474969e-33, -1.3804356910305565e-33, -7.500042834304155e-33, -3.641291537764673e-33, 1.35235710854396e-33, 7.349168223225865e-33, 1.7455079756111926e-62, -6.485601398452305e-63, -3.5236910064460587e-62, 1.0253568350262688e-47, -3.8098111358273623e-48, -2.0699078482955347e-47, 1.0038688391621753e-33, -3.7299704373182037e-34, -2.026529611798881e-33, -8.872102136415473e-34, 3.28705766383066e-34, 1.788539348318021e-33, -7.941160997224554e-37, 4.296248589559858e-37, 1.9532719123426722e-36, -8.912515105897072e-36, 4.8217610078077526e-36, 2.1921939916295428e-35, -1.0765936343390073e-35, 5.8244806832081764e-36, 2.6480764055737694e-35, -2.5651111996340394e-37, 1.3877511584695885e-37, 6.309354085670741e-37, 3.108778717210631e-36, -1.6818807959866004e-36, -7.646602495703691e-36, -9.784487947924787e-35, 5.293507153491658e-35, 2.4066714542138705e-34, -1.7242419718335576e-34, 9.328323833427919e-35, 4.241084414283912e-34, -5.302517641768094e-36, 2.868715789482708e-36, 1.3042499425445475e-35, 1.1780831723152231e-34, -6.373549370441427e-35, -2.8977082465537746e-34, 7.058054353266433e-35, -3.818478944181533e-35, -1.7360558901704154e-34, -4.2611087677014045e-34, 2.3053030330950946e-34, 1.0480966289812276e-33, -2.1414114149386047e-35, 1.1585252804108553e-35, 5.267187972931716e-35, 1.4147634616356087e-34, -7.65401372511791e-35, -3.4798661470121845e-34, 4.089014923444495e-34, -2.2121985190424137e-34, -1.0057670411046459e-33, 1.226542596248964e-35, -6.635719765675748e-36, -3.016902948299702e-35, -1.0315240059025793e-35, 5.580649425197336e-36, 2.537219517827303e-35], [-4.3301589923453007e-67, 1.5463624691195243e-67, 8.576728954204552e-67, -2.5436481423104466e-52, 9.08373579092078e-53, 5.0381939115927194e-52, -2.490341918667163e-38, 8.893371548503208e-39, 4.932610483231525e-38, 2.793046877470305e-37, -1.1194512845593304e-37, -5.8533513558046015e-37, -1.108973627926385e-62, 3.960305384860465e-63, 2.1965397208045715e-62, -6.51439984890381e-48, 2.3263865028953172e-48, 1.2903046262765032e-47, -6.377880159144544e-34, 2.2776333451214868e-34, 1.2632642248028568e-33, 7.765307945773876e-34, -2.8396465449904814e-34, -1.5555873831552647e-33, -2.4002752297036326e-62, 8.571730362170069e-63, 4.754215745207361e-62, -1.4099841691408453e-47, 5.035257608476844e-48, 2.792750120681037e-47, -1.3804356910306256e-33, 4.9297357150544145e-34, 2.7342235658342974e-33, 1.3265065582260317e-33, -4.711281934715297e-34, -2.620597944518574e-33, -6.485601398452635e-63, 2.3161021592891782e-63, 1.2846005284764585e-62, -3.8098111358275586e-48, 1.3605387158513038e-48, 7.546077993086703e-48, -3.7299704373184034e-34, 1.3320264464632512e-34, 7.387937834298561e-34, 2.879289966049653e-34, -9.874365093643877e-35, -5.595602373624726e-34, 3.5323929428722097e-37, -1.911060385740822e-37, -8.688558160552623e-37, 3.964471375698837e-36, -2.14481919736287e-36, -9.751333071002447e-36, 4.788911542795052e-36, -2.590849684126897e-36, -1.1779192501580615e-35, 1.1410146076167668e-37, -6.173004678225251e-38, -2.8065314195360914e-37, -1.3828491835720463e-36, 7.481354246024948e-37, 3.4013672184977804e-36, 4.352342962061517e-35, -2.3546616569759416e-35, -1.0705373261728723e-34, 7.66978553291846e-35, -4.149431712761389e-35, -1.8865222176427035e-34, 2.3586697088477826e-36, -1.2760642195034762e-36, -5.80157396934282e-36, -5.240358035125131e-35, 2.835086812251198e-35, 1.2889606650975343e-34, -3.139568810731897e-35, 1.6985385486640023e-35, 7.722336289382623e-35, 1.8954294649233281e-34, -1.0254465522274494e-34, -4.66215095872681e-34, 9.525441648341918e-36, -5.153360479774482e-36, -2.3429543401611067e-35, -6.293160999332105e-35, 3.404663886892987e-35, 1.5479165608330956e-34, -1.818878557420342e-34, 9.840317353632426e-35, 4.473860181670174e-34, -5.455915592992331e-36, 2.951705635906758e-36, 1.3419809380050128e-35, 4.588432497624764e-36, -2.4823884886732125e-36, -1.1286078096670229e-35], [-2.3526179548206297e-66, 8.576728954204552e-67, 4.7059359586255274e-66, -1.3819890449576077e-51, 5.03819391159289e-52, 2.7643893169166987e-51, -1.35302724954362e-37, 4.932610483232202e-38, 2.7064571081678165e-37, 7.106157854717558e-37, -2.5496633435186205e-37, -1.4106598677486024e-36, -6.025162755210862e-62, 2.1965397208044256e-62, 1.2052118368058544e-61, -3.539337487723559e-47, 1.290304626276418e-47, 7.079728146706047e-47, -3.465164998010846e-33, 1.2632642248027762e-33, 6.931361096388922e-33, 3.7789233887176387e-33, -1.375414203495422e-33, -7.553090432657096e-33, -1.3040931318905548e-61, 4.754215745207034e-62, 2.6085743119427324e-61, -7.66058262109392e-47, 2.792750120680845e-47, 1.5323444738130556e-46, -7.500042834304074e-33, 2.7342235658341086e-33, 1.500231739405994e-32, 7.378085366794486e-33, -2.6906310188689148e-33, -1.4760652031240872e-32, -3.5236910064460216e-62, 1.2846005284763687e-62, 7.048430528357495e-62, -2.0699078482955126e-47, 7.546077993086172e-48, 4.1404316218770466e-47, -2.0265296117988587e-33, 7.387937834298023e-34, 4.0536622411821995e-33, 1.834153375541272e-33, -6.700307114728798e-34, -3.6724582535764316e-33, 1.7562380649280383e-36, -9.501425940130778e-37, -4.319784581637265e-36, 1.9710591799729477e-35, -1.0663629946373568e-35, -4.848175896637691e-35, 2.380955028800201e-35, -1.288120803477398e-35, -5.856388737027094e-35, 5.672905927917855e-37, -3.069099606473267e-37, -1.395353628296533e-36, -6.875261086523316e-36, 3.719585934116545e-36, 1.691094586172236e-35, 2.163901498279777e-34, -1.1706926434535342e-34, -5.322506393137413e-34, 3.813270358249914e-34, -2.063017914378936e-34, -9.379426871639613e-34, 1.1726853700208706e-35, -6.34434671291825e-36, -2.884431377323164e-35, -2.605405571797736e-34, 1.409550822226057e-34, 6.4084653685175945e-34, -1.5609334357872661e-34, 8.444808100782299e-35, 3.8393975871102695e-34, 9.423711997844285e-34, -5.0983237077433375e-34, -2.3179320960536133e-33, 4.7358670110088464e-35, -2.5621520547815174e-35, -1.1648719899302975e-34, -3.12883902626103e-34, 1.6927336265102569e-34, 7.695944447383997e-34, -9.043115558445294e-34, 4.8924171763770875e-34, 2.224317530717951e-33, -2.7125766579231337e-35, 1.4675314660851436e-35, 6.67207200288391e-35, 2.2812806901740453e-35, -1.234195976000963e-35, -5.611221706554038e-35], [6.845869560548591e-52, -2.5436481423104466e-52, -1.3819890449576077e-51, 4.021442035032069e-37, -1.4942051512005079e-37, -8.118163497262127e-37, 3.9371662718392717e-23, -1.462891687426303e-23, -7.948034369825816e-23, -2.4430983469996725e-22, 9.243690898863507e-23, 4.975659274218266e-22, 1.7532586716313797e-47, -6.514399848903161e-48, -3.539337487723519e-47, 1.0299097956838817e-32, -3.8267280954863984e-33, -2.0790989988065094e-32, 1.008326385231967e-18, -3.74653287497399e-19, -2.0355281470198157e-18, -1.1200934829187496e-18, 4.1708741956451465e-19, 2.2635394141529526e-18, 3.7947731621434395e-47, -1.4099841691407002e-47, -7.660582621093831e-47, 2.2291485650849478e-32, -8.282614146182995e-33, -4.500025700582446e-32, 2.1824331841456162e-18, -8.109038691826646e-19, -4.405720449630507e-18, -2.1389894625161386e-18, 7.944097787100055e-19, 4.317092774556789e-18, 1.0253568350262406e-47, -3.8098111358271593e-48, -2.0699078482954878e-47, 6.0232130349729504e-33, -2.2379822623908276e-33, -1.215917767079314e-32, 5.896986952147121e-19, -2.1910817571662856e-19, -1.1904362614633602e-18, -5.211703809854648e-19, 1.9309032613007208e-19, 1.0506345838202958e-18, -4.664844744520229e-22, 2.523728288743324e-22, 1.147402781292968e-21, -5.235443440415299e-21, 2.8324279666998075e-21, 1.287751831803433e-20, -6.324191335354485e-21, 3.421451613198537e-21, 1.5555490321813348e-20, -1.5068131099350469e-22, 8.152011652390962e-23, 3.706278875109693e-22, 1.8261775659660856e-21, -9.879805729678166e-22, -4.4918134109087346e-21, -5.747662992558745e-20, 3.1095439361670375e-20, 1.4137414779652742e-19, -1.0128646306755547e-19, 5.479700313941203e-20, 2.4913234158019835e-19, -3.1148369315988876e-21, 1.6851583513755328e-21, 7.661503767706199e-21, 6.920367307630582e-20, -3.7439888569234575e-20, -1.7021892755748988e-19, 4.146084907217002e-20, -2.2430739587135825e-20, -1.019804433921597e-19, -2.5030862424005944e-19, 1.354195027933408e-19, 6.156792505732137e-19, -1.2579208239605354e-20, 6.80547915803146e-21, 3.0940833641980224e-20, 8.310688954746922e-20, -4.496166960042853e-20, -2.0441639847368807e-19, 2.4019938372438797e-19, -1.2995030120906927e-19, -5.908137484617728e-19, 7.205030581853073e-21, -3.897994573569304e-21, -1.7722073470141347e-20, -6.059440602530115e-21, 3.2782187832786858e-21, 1.490428809788323e-20], [-2.543648142310511e-52, 9.08373579092078e-53, 5.03819391159289e-52, -1.4942051512005079e-37, 5.336022929102615e-38, 2.9595662899393787e-37, -1.462891687426193e-23, 5.2241980163352605e-24, 2.897543834901471e-23, 1.6407084621656206e-22, -6.57594833217463e-23, -3.4384109980264196e-22, -6.514399848903638e-48, 2.326386502895182e-48, 1.2903046262764767e-47, -3.826728095486677e-33, 1.366580007072832e-33, 7.579585348817093e-33, -3.746532874974259e-19, 1.3379411327445698e-19, 7.420742989685802e-19, 4.561544083174315e-19, -1.668082320245505e-19, -9.137925337982697e-19, -1.409984169140806e-47, 5.035257608476544e-48, 2.792750120680976e-47, -8.282614146183619e-33, 2.9578414290325055e-33, 1.640534139500561e-32, -8.109038691827255e-19, 2.895855121219899e-19, 1.6061541172485112e-18, 7.79224492347529e-19, -2.767529682472133e-19, -1.5394074686636573e-18, -3.8098111358274486e-48, 1.3605387158512205e-48, 7.546077993086532e-48, -2.237982262390999e-33, 7.992158678779096e-34, 4.432762700579077e-33, -2.1910817571664575e-19, 7.824670184268432e-20, 4.339867053597698e-19, 1.6913698980250902e-19, -5.800459168206717e-20, -3.2870025345350935e-19, 2.075019592336294e-22, -1.1226066314484254e-22, -5.103885299250048e-22, 2.3288337143892636e-21, -1.2599226440895894e-21, -5.7281869545561844e-21, 2.8131313356053926e-21, -1.5219325659138875e-21, -6.919404386196786e-21, 6.70261690654825e-23, -3.626183682862258e-23, -1.6486296332903357e-22, -8.123216175449289e-22, 4.39474228625524e-22, 1.9980516701447366e-21, 2.5566795837558516e-20, -1.383189568818273e-20, -6.288615004223733e-20, 4.505431730616789e-20, -2.4374842324422894e-20, -1.1081922725741162e-19, 1.38554400285086e-21, -7.495933491464983e-22, -3.407995613020933e-21, -3.078322760123053e-20, 1.6654038145065752e-20, 7.571690570906462e-20, -1.8442644686237912e-20, 9.977657706309612e-21, 4.536301413298967e-20, 1.113424621556801e-19, -6.023740057173582e-20, -2.738668867886917e-19, 5.595492451044865e-21, -3.0272181308370544e-21, -1.3763123860819947e-20, -3.696766634553087e-20, 1.999988218999895e-20, 9.092864930306499e-20, -1.0684566252300215e-19, 5.780458639177166e-20, 2.6280619626621943e-19, -3.204946882377955e-21, 1.7339087480839075e-21, 7.883145459570628e-21, 2.6953647243282876e-21, -1.4582196355535369e-21, -6.629736144865652e-21], [-1.3819890449576012e-51, 5.0381939115927194e-52, 2.7643893169166987e-51, -8.118163497262127e-37, 2.9595662899393787e-37, 1.623874264900779e-36, -7.948034369825941e-23, 2.897543834901771e-23, 1.5898433770224038e-22, 4.1743421565052795e-22, -1.4977386370160567e-22, -8.286583375746343e-22, -3.5393374877234663e-47, 1.2903046262763471e-47, 7.0797281467059e-47, -2.079098998806479e-32, 7.579585348816337e-33, 4.1588166578333193e-32, -2.035528147019787e-18, 7.420742989685077e-19, 4.071661989243461e-18, 2.21983799547258e-18, -8.079541166532597e-19, -4.436881990175096e-18, -7.660582621093711e-47, 2.7927501206806903e-47, 1.5323444738130227e-46, -4.500025700582377e-32, 1.6405341395003928e-32, 9.001390436435876e-32, -4.405720449630439e-18, 1.6061541172483466e-18, 8.812751872901762e-18, 4.33407945764376e-18, -1.580546720082882e-18, -8.670791346213901e-18, -2.0699078482954557e-47, 7.546077993085748e-48, 4.140431621876956e-47, -1.2159177670792952e-32, 4.432762700578614e-33, 2.4321973447092926e-32, -1.1904362614633414e-18, 4.339867053597236e-19, 2.3812267511574043e-18, 1.0774294511253553e-18, -3.935934864151121e-19, -2.1572976029139175e-18, 1.0316599688848087e-21, -5.581384998712164e-22, -2.5375539433280553e-21, 1.1578514854501395e-20, -6.264093893856949e-21, -2.8479447601987045e-20, 1.3986349800639313e-20, -7.566757005063653e-21, -3.440195234844928e-20, 3.3324126551840723e-22, -1.8028690231402807e-22, -8.19667053971234e-22, -4.038707382696555e-21, 2.1849816295903373e-21, 9.933929932347775e-21, 1.2711320845198617e-19, -6.876953416725056e-20, -3.126578844627384e-19, 2.240014299714353e-19, -1.2118704404941728e-19, -5.509719569225684e-19, 6.888659211454762e-21, -3.72683445550525e-21, -1.6943900968810356e-20, -1.5304830733430752e-19, 8.280068553569788e-20, 3.7644994233484713e-19, -9.169329443167104e-20, 4.960700167290946e-20, 2.255362114256925e-19, 5.535733805470043e-19, -2.994888097879083e-19, -1.3616136683552376e-18, 2.781971596441951e-20, -1.5050748311974188e-20, -6.842761382327274e-20, -1.837961513839692e-19, 9.943558082072411e-20, 4.520798158108886e-19, -5.312161546862767e-19, 2.8739332398876704e-19, 1.3066220351080037e-18, -1.5934381598916688e-20, 8.620661952802581e-21, 3.919348824257753e-20, 1.3400836781993476e-20, -7.249988527330328e-21, -3.2961777373994566e-20], [6.702403391719684e-38, -2.490341918667163e-38, -1.35302724954362e-37, 3.9371662718392717e-23, -1.462891687426193e-23, -7.948034369825941e-23, 3.854656642336791e-09, -1.4322344474728972e-09, -7.781470570928774e-09, -2.391899305473016e-08, 9.04997454079168e-09, 4.871386359410758e-08, 1.716516326139647e-33, -6.37788015914293e-34, -3.4651649980105864e-33, 1.0083263852318883e-18, -3.746532874973411e-19, -2.0355281470196867e-18, 9.871952897387104e-05, -3.668018273839386e-05, -0.00019928703922651757, -0.0001096620128759235, 4.083466842024636e-05, 0.00022161033178514703, 3.715247608474572e-33, -1.380435691030267e-33, -7.500042834303499e-33, 2.182433184145442e-18, -8.1090386918253735e-19, -4.4057204496302185e-18, 0.00021366967988865678, -7.939100789312378e-05, -0.00043133915163593074, -0.00020941635100730723, 7.777616485602663e-05, 0.000422662117626438, 1.003868839162066e-33, -3.729970437317416e-34, -2.0265296117987e-33, 5.896986952146643e-19, -2.1910817571659395e-19, -1.1904362614632807e-18, 5.773406139194735e-05, -2.1451641271979615e-05, -0.00011654887616378811, -5.102484203483586e-05, 1.890438088713234e-05, 0.00010286168522163585, -4.567085446339258e-08, 2.47083951755821e-08, 1.1233571170161751e-07, -5.125726332037277e-07, 2.7730698989960545e-07, 1.2607649282293652e-06, -6.191657769852078e-07, 3.349749610927325e-07, 1.5229500090625543e-06, -1.475235426178224e-08, 7.981173182614021e-09, 3.6286078610594834e-08, 1.7879070881731448e-07, -9.672758565797258e-08, -4.397680261648807e-07, -5.627211502507906e-06, 3.044378459176688e-06, 1.3841142594265299e-05, -9.916384289753834e-06, 5.364864411296809e-06, 2.4391137406661242e-05, -3.0495605314059384e-07, 1.6498431572422674e-07, 7.500944676812198e-07, 6.775339919110692e-06, -3.6655275697648304e-06, -1.6665171711287964e-05, 4.059197052866784e-06, -2.196066748831744e-06, -9.984327975216655e-06, -2.4506300583805427e-05, 1.3258157006928943e-05, 6.027767051002209e-05, -1.2315590769673334e-06, 6.6628594348229e-07, 3.029241888272648e-06, 8.136525147779757e-06, -4.401942575183187e-06, -2.001325252161817e-05, 2.3516562065992974e-05, -1.2722698436995528e-05, -5.7843229943860016e-05, 7.054037618179031e-07, -3.816305849786374e-07, -1.7350679016598648e-06, -5.932455312962124e-07, 3.209518454524237e-07, 1.4591944853009402e-06], [-2.4903419186674127e-38, 8.893371548503208e-39, 4.932610483232202e-38, -1.4628916874263037e-23, 5.2241980163352605e-24, 2.897543834901771e-23, -1.4322344474728972e-09, 5.114716573841849e-10, 2.8368211598154e-09, 1.6063247867025852e-08, -6.438138795301025e-09, -3.366353584664524e-08, -6.377880159143879e-34, 2.2776333451209603e-34, 1.2632642248027559e-33, -3.746532874973968e-19, 1.3379411327443385e-19, 7.420742989685359e-19, -3.668018273839926e-05, 1.3099024319284587e-05, 7.265229426773561e-05, 4.465949615916478e-05, -1.633124981712946e-05, -8.946425466755363e-05, -1.3804356910304746e-33, 4.929735715053242e-34, 2.7342235658340627e-33, -8.109038691826595e-19, 2.895855121219384e-19, 1.606154117248409e-18, -7.939100789313573e-05, 2.835167835835281e-05, 0.00015724945834650814, 7.628945942117257e-05, -2.7095316623295186e-05, -0.0001507146717879223, -3.729970437317981e-34, 1.3320264464629294e-34, 7.387937834297898e-34, -2.191081757166272e-19, 7.82467018426702e-20, 4.339867053597409e-19, -2.145164127198291e-05, 7.660691679600295e-06, 4.248918183786617e-05, 1.6559245309762417e-05, -5.678901249675638e-06, -3.2181181281949917e-05, 2.0315342310502952e-08, -1.0990806102335463e-08, -4.996925202574384e-08, 2.2800292713761684e-07, -1.233518945747175e-07, -5.608143616096828e-07, 2.754177659733816e-07, -1.4900380297243866e-07, -6.774397177238863e-07, 6.562152826681549e-09, -3.5501911919378135e-09, -1.6140799569907898e-08, -7.952981161043489e-08, 4.3026434179927497e-08, 1.956179295028263e-07, 2.5031002653712073e-06, -1.3542026145026434e-06, -6.156826997759981e-06, 4.411013187640678e-06, -2.38640284368425e-06, -1.084968327351999e-05, 1.3565077075965193e-07, -7.338844191076657e-08, -3.33657560279999e-07, -3.0138115729163104e-06, 1.6305026083548973e-06, 7.413013659499112e-06, -1.8056149507969546e-06, 9.768559897426567e-07, 4.441235946646003e-06, 1.0900910240756272e-05, -5.8975029297524336e-06, -2.6812756723707757e-05, 5.478229938582125e-07, -2.963777923044722e-07, -1.347469554152979e-06, -3.619294964749443e-06, 1.9580752603983664e-06, 8.902309372142359e-06, -1.0460654041841351e-05, 5.659319863788362e-06, 2.5729867121197718e-05, -3.137782083743102e-07, 1.6975719112531334e-07, 7.717941511788359e-07, 2.6388790365459445e-07, -1.4276603059353584e-07, -6.490799398169331e-07], [-1.353027249543593e-37, 4.932610483231525e-38, 2.7064571081678165e-37, -7.948034369825816e-23, 2.897543834901471e-23, 1.5898433770224038e-22, -7.781470570928774e-09, 2.8368211598154e-09, 1.556525660942377e-08, 4.086862126206893e-08, -1.4663511233831228e-08, -8.112924739822064e-08, -3.4651649980104804e-33, 1.2632642248024988e-33, 6.931361096388339e-33, -2.0355281470196255e-18, 7.420742989683853e-19, 4.071661989243205e-18, -0.00019928703922651166, 7.265229426772101e-05, 0.00039863337864204113, 0.0002173317732441768, -7.910221431937787e-05, -0.00043439000168777513, -7.500042834303265e-33, 2.7342235658335003e-33, 1.5002317394058643e-32, -4.405720449630083e-18, 1.606154117248078e-18, 8.812751872901192e-18, -0.00043133915163591735, 0.00015724945834647575, 0.0008628066532805567, 0.0004243251876181866, -0.00015474238303490423, -0.0008489081016481068, -2.0265296117986366e-33, 7.3879378342963685e-34, 4.053662241181844e-33, -1.190436261463244e-18, 4.339867053596507e-19, 2.3812267511572475e-18, -0.00011654887616378448, 4.2489181837857244e-05, 0.0002331324328086136, 0.00010548501901316672, -3.853451040770065e-05, -0.00021120879740455615, 1.010039880748316e-07, -5.4644181305237095e-08, -2.4843754333921107e-07, 1.1335868518311181e-06, -6.132819766562034e-07, -2.7882615132177087e-06, 1.369324342400583e-06, -7.408183484435787e-07, -3.368100429940858e-06, 3.2625766069848536e-08, -1.7650870132199197e-08, -8.024896171374743e-08, -3.954069796471522e-07, 2.1391918375725037e-07, 9.725748509052593e-07, 1.2444934743873485e-05, -6.732835835870515e-06, -3.061056373827623e-05, 2.1930712098906983e-05, -1.1864737530935594e-05, -5.394254564973573e-05, 6.744296316910248e-07, -3.6487326663224837e-07, -1.6588814367245625e-06, -1.4984093475661066e-05, 8.106546446186005e-06, 3.6856083043971874e-05, -8.977171448582801e-06, 4.856740744544827e-06, 2.2080973863808876e-05, 5.4197236312032276e-05, -2.932125417744202e-05, -0.00013330788716144906, 2.7236709228456786e-06, -1.4735335758575614e-06, -6.6993603503546715e-06, -1.7994440845323887e-05, 9.735174885468277e-06, 4.426057587016202e-05, -5.2008366876045285e-05, 2.8137053626618698e-05, 0.00012792396761795527, -1.5600451093750843e-06, 8.44000216485329e-07, 3.837212587926213e-06, 1.312000076909415e-06, -7.098053397852659e-07, -3.227101049977772e-06], [-4.158988855602979e-37, 2.793046877470305e-37, 7.106157854717558e-37, -2.4430983469996725e-22, 1.6407084621656206e-22, 4.1743421565052795e-22, -2.391899305473016e-08, 1.6063247867025852e-08, 4.086862126206893e-08, 1.790229307602277e-07, -1.1016396540339937e-07, -3.2820177603322537e-07, -1.0651361688696798e-32, 7.153121476952852e-33, 1.8199197005685924e-32, -6.256887199852539e-18, 4.201929811061796e-18, 1.0690682198249807e-17, -0.0006125764100381406, 0.0004113871637246619, 0.0010466641818341973, 0.0006971654194428563, -0.00046270685681838985, -0.001203367017950282, -2.3053929309210116e-32, 1.5482298103242819e-32, 3.939055057145521e-32, -1.3542478362571755e-17, 9.094705039382954e-18, 2.3139035070720348e-17, -0.0013258674023336934, 0.0008904110918784521, 0.0022654119504827578, 0.001292987767328849, -0.0008704631956995394, -0.0022045017673279965, -6.229227145176287e-33, 4.1833541831804933e-33, 1.0643421500608184e-32, -3.6592102238898085e-18, 2.4574111748517797e-18, 6.252222926619878e-18, -0.0003582525608865247, 0.00024059121850779027, 0.0006121197574470005, 0.00030638808254897145, -0.0002091253208754543, -0.000516039771330946, 2.570938818402338e-07, -1.390903959290853e-07, -6.323688166115572e-07, 2.8854132365980634e-06, -1.5610378069861955e-06, -7.097194771039839e-06, 3.4854555487974303e-06, -1.885666779798072e-06, -8.57310716602315e-06, 8.304508571180728e-08, -4.492823309890377e-08, -2.042643807821746e-07, -1.0064623906621735e-06, 5.445063546550212e-07, 2.475575950666111e-06, 3.167713120575377e-05, -1.713764905554569e-05, -7.791562300451724e-05, 5.58220721032453e-05, -3.020030680950742e-05, -0.00013730446412828633, 1.7166820374564088e-06, -9.287423822187307e-07, -4.222489390856985e-06, -3.8140263874140567e-05, 2.0634269338196988e-05, 9.381286461857903e-05, -2.285034382950839e-05, 1.2362267618399071e-05, 5.6204545916082975e-05, 0.00013795274953053963, -7.463383575822542e-05, -0.00033931969265277886, 6.932786949867522e-06, -3.7507080092567193e-06, -1.7052441108000308e-05, -4.580275231351541e-05, 2.4779753249389357e-05, 0.00011266013827606093, -0.00013238123744606218, 7.161959124876159e-05, 0.00032561555283280646, -3.970913036799723e-06, 2.148304201309852e-06, 9.767177499419785e-06, 3.3395433108782145e-06, -1.8067267801457491e-06, -8.214209674718956e-06], [1.5735922984936656e-37, -1.1194512845593302e-37, -2.5496633435186205e-37, 9.243690898863509e-23, -6.575948332174628e-23, -1.4977386370160567e-22, 9.04997454079168e-09, -6.438138795301025e-09, -1.4663511233831228e-08, -1.101639654033994e-07, 6.258397188195125e-08, 2.135118736827725e-07, 4.0300422299098754e-33, -2.8669662119085468e-33, -6.529805055775613e-33, 2.3673517415099083e-18, -1.6841306039523916e-18, -3.83577751512948e-18, 0.00023177400915040547, -0.00016488369479137073, -0.00037553926495245243, -0.00028691852998304486, 0.0001955039386952999, 0.0004839851641999803, 8.722669588815862e-33, -6.205294525992229e-33, -1.4133184897713523e-32, 5.1239232404174e-18, -3.645151580215111e-18, -8.302200813769614e-18, 0.0005016543216569201, -0.00035687615866011755, -0.0008128214889401541, -0.00048021972004313757, 0.00034497411074153184, 0.000770668712709239, 2.3568863013450935e-33, -1.67668550495998e-33, -3.818820550363228e-33, 1.3844963828468232e-18, -9.849287237419845e-19, -2.243274627079629e-18, 0.00013554820421488362, -9.642879637458298e-05, -0.00021962632118707268, -0.00010173717100517311, 7.765445455615944e-05, 0.00015313434980802548, -1.1436068531861603e-07, 6.18702898950066e-08, 2.812907515502864e-07, -1.283491589931413e-06, 6.943819593736951e-07, 3.156979279499902e-06, -1.5504028425528581e-06, 8.387836524023727e-07, 3.8134956919185396e-06, -3.69401747189273e-08, 1.9985008941356656e-08, 9.08610286842561e-08, 4.476953240570128e-07, -2.422077080674608e-07, -1.1011874738131395e-06, -1.4090644272386569e-05, 7.623181371387378e-06, 3.465848343042551e-05, -2.483081423773225e-05, 1.343372218291056e-05, 6.107587042765185e-05, -7.636157378481414e-07, 4.131238540362517e-07, 1.8782507659558831e-06, 1.6965579591622076e-05, -9.178550518878298e-06, -4.172990587209023e-05, 1.0164306367012271e-05, -5.498992767983512e-06, -2.500094651407993e-05, -6.13642412062681e-05, 3.319867646858946e-05, 0.00015093642958796078, -3.083847274310099e-06, 1.6683926326771683e-06, 7.58527911091298e-06, 2.037401320700244e-05, -1.1022547652018419e-05, -5.011356368778478e-05, 5.8885917196061806e-05, -3.18578780592583e-05, -0.000144840544262739, 1.7663443913116735e-06, -9.556102190223686e-07, -4.344642915914818e-06, -1.4854980560002784e-06, 8.036695050151509e-07, 3.6538506518619828e-06], [8.47027361635478e-37, -5.8533513558046015e-37, -1.4106598677486024e-36, 4.975659274218266e-22, -3.4384109980264196e-22, -8.286583375746343e-22, 4.871386359410758e-08, -3.366353584664524e-08, -8.112924739822064e-08, -3.2820177603322537e-07, 2.135118736827725e-07, 5.760746546508721e-07, 2.1692760193015616e-32, -1.4990701958170745e-32, -3.6127647831701345e-32, 1.2742892181117612e-17, -8.805928663413816e-18, -2.1222321040776654e-17, 0.001247584445184834, -0.0008621386314608855, -0.0020777573289386207, -0.0014000087227599557, 0.0009602224903602566, 0.0023476856255909605, 4.6952058772179126e-32, -3.2446047119576286e-32, -7.819509500873824e-32, 2.7580861877042815e-17, -1.9059652919656683e-17, -4.593383487959357e-17, 0.0027002860711305334, -0.0018660227344951099, -0.004497121774944157, -0.0026410389579675396, 0.00182789766951122, 0.004392201006467664, 1.268655920224089e-32, -8.766999966039992e-33, -2.1128502734389625e-32, 7.452415212498956e-18, -5.149964058288849e-18, -1.2411432657586016e-17, 0.0007296237907395623, -0.000504203830736536, -0.0012151331193877677, -0.0006361671384150436, 0.00044406518848325163, 0.0010496306458047478, -5.685794076026621e-07, 3.076072225231883e-07, 1.3985237009989704e-06, -6.3812741750630966e-06, 3.4523340080614455e-06, 1.569589587147864e-05, -7.708305763542759e-06, 4.170271547962685e-06, 1.89599696378646e-05, -1.836594682858858e-07, 9.936163387926773e-08, 4.517436190551855e-07, 2.2258553403175666e-06, -1.204210299948052e-06, -5.474893052413582e-06, -7.005598253291715e-05, 3.7900996624104e-05, 0.000172315336536989, -0.00012345404900510268, 6.67898918179591e-05, 0.00030365752119988694, -3.796551084423147e-06, 2.053972617775349e-06, 9.338302799262785e-06, 8.43496098940397e-05, -4.563399390389457e-05, -0.00020747309351954008, 5.053498303850268e-05, -2.7339938036576522e-05, -0.00012429991407342012, -0.00030509124543841114, 0.00016505745612762886, 0.0007504269975445284, -1.5332297559071148e-05, 8.294928384639644e-06, 3.771255384984731e-05, 0.00010129568852662811, -5.4801994206277735e-05, -0.0002491550332622979, 0.0002927694934862902, -0.0001583912634306531, -0.0007201194241212679, 8.781925753909342e-06, -4.7511108447541084e-06, -2.1600731829243683e-05, -7.385611605267758e-06, 3.995690737570767e-06, 1.816624509827158e-05], [2.984645822899049e-62, -1.108973627926385e-62, -6.025162755210862e-62, 1.7532586716313797e-47, -6.514399848903638e-48, -3.5393374877234663e-47, 1.716516326139647e-33, -6.377880159143879e-34, -3.4651649980104804e-33, -1.0651361688696798e-32, 4.0300422299098754e-33, 2.1692760193015616e-32, 7.643815185878009e-58, -2.8401324515108664e-58, -1.5430718851904842e-57, 4.490176072540277e-43, -1.6683677543878776e-43, -9.064406044108283e-43, 4.396077236330402e-29, -1.6334044341256573e-29, -8.874446887517389e-29, -4.8833567532683226e-29, 1.8184077472947236e-29, 9.86852495167541e-29, 1.6544361190447844e-57, -6.1472152274585056e-58, -3.3398424727198873e-57, 9.718588551180407e-43, -3.6110342879671445e-43, -1.961910432471822e-42, 9.514919951665726e-29, -3.535359276893604e-29, -1.920795454916131e-28, -9.325515054090928e-29, 3.463448736097673e-29, 1.8821557733004577e-28, 4.4703261836569684e-58, -1.660992338812612e-58, -9.024334686134352e-58, 2.6259860002098157e-43, -9.757101493228258e-44, -5.30112917344447e-43, 2.570954254788007e-29, -9.552625793286527e-30, -5.190035515253677e-29, -2.2721861508887976e-29, 8.418305815341812e-30, 4.5805315077332355e-29, -2.0337678446927722e-32, 1.1002890178535994e-32, 5.002419178571598e-32, -2.282536098191073e-31, 1.2348751644627468e-31, 5.614309609215934e-31, -2.757205799107774e-31, 1.491676283818329e-31, 6.781845432711683e-31, -6.569367725576026e-33, 3.5540945253685356e-33, 1.6158545916274505e-32, 7.961725235816223e-32, -4.307374051073037e-32, -1.9583300580790274e-31, -2.5058523523485115e-30, 1.3556915214519828e-30, 6.163596252526345e-30, -4.415862970175707e-30, 2.3890266251921517e-30, 1.0861612189216265e-29, -1.3579991489296276e-31, 7.346913039858364e-32, 3.340244072014864e-31, 3.0171251723340476e-30, -1.632295299225892e-30, -7.421164055484893e-30, 1.807600172667952e-30, -9.779300148966886e-31, -4.446118958238064e-30, -1.0912895479034333e-29, 5.903987065140905e-30, 2.6842236580997453e-29, -5.484253095337458e-31, 2.967036511898902e-31, 1.3489510582955022e-30, 3.6232742757971506e-30, -1.9602281080086978e-30, -8.912097206065734e-30, 1.0472155231050952e-29, -5.6655421237245704e-30, -2.5758156372416153e-29, 3.14123198518323e-31, -1.6994383428997715e-31, -7.726427167205378e-31, -2.641780408389346e-31, 1.4292299775103786e-31, 6.497935846014878e-31], [-1.1089736279263314e-62, 3.960305384860465e-63, 2.1965397208044256e-62, -6.514399848903161e-48, 2.326386502895182e-48, 1.2903046262763471e-47, -6.37788015914293e-34, 2.2776333451209603e-34, 1.2632642248024988e-33, 7.153121476952852e-33, -2.8669662119085468e-33, -1.4990701958170745e-32, -2.8401324515108657e-58, 1.0142524184698451e-58, 5.6254392214489426e-58, -1.6683677543878764e-43, 5.957982800713526e-44, 3.304529475849463e-43, -1.6334044341256548e-29, 5.833123721994041e-30, 3.235277764363064e-29, 1.988731069647366e-29, -7.272465368116035e-30, -3.983930813865461e-29, -6.147215227458514e-58, 2.1952595584011286e-58, 1.21757651213898e-57, -3.61103428796715e-43, 1.2895526255474024e-43, 7.1523614691706e-43, -3.535359276893611e-29, 1.2625279834543062e-29, 7.002472271168511e-29, 3.397244288130023e-29, -1.2065809658632296e-29, -6.711471830495008e-29, -1.6609923388126164e-58, 5.931644123866086e-59, 3.289921019110244e-58, -9.757101493228288e-44, 3.484402208600542e-44, 1.9325852707491046e-43, -9.552625793286575e-30, 3.411380975709143e-30, 1.892084848958092e-29, 7.373993992244927e-30, -2.528870302620741e-30, -1.4330594963559874e-29, 9.046620745435103e-33, -4.8943135180664915e-33, -2.2251796947386888e-32, 1.0153193478786266e-31, -5.492980582815177e-32, -2.4973612359232235e-31, 1.2264622654317946e-31, -6.635285167812741e-32, -3.0167053601524497e-31, 2.922190873735919e-33, -1.580934881448742e-33, -7.187656009199865e-33, -3.541540342264081e-32, 1.9160092215280693e-32, 8.711057840774909e-32, 1.114655044572107e-30, -6.0303967703996675e-31, -2.7416953154264345e-30, 1.9642673405048842e-30, -1.0626885406443726e-30, -4.831470141307021e-30, 6.040661575532895e-32, -3.2680591393326277e-32, -1.4858097690727879e-31, -1.3420797878597051e-30, 7.260787682914648e-31, 3.3010875294750665e-30, -8.040580081046693e-31, 4.350035321600088e-31, 1.9777258308627112e-30, 4.854282011146196e-30, -2.626215770087204e-30, -1.193998297009222e-29, 2.439509403935501e-31, -1.319799313921339e-31, -6.0004137937367285e-31, -1.611707467760631e-30, 8.719500760115203e-31, 3.964285485195478e-30, -4.658231617235235e-30, 2.520150519852759e-30, 1.1457761632476925e-29, -1.397285069558947e-31, 7.559453852407329e-32, 3.4368748862529386e-31, 1.1751186601649399e-31, -6.357511059231217e-32, -2.890416493724472e-31], [-6.025162755210923e-62, 2.1965397208045715e-62, 1.2052118368058544e-61, -3.539337487723519e-47, 1.2903046262764767e-47, 7.0797281467059e-47, -3.4651649980105864e-33, 1.2632642248027559e-33, 6.931361096388339e-33, 1.8199197005685924e-32, -6.529805055775613e-33, -3.6127647831701345e-32, -1.5430718851904842e-57, 5.6254392214489426e-58, 3.0866029294652515e-57, -9.064406044108284e-43, 3.3045294758494653e-43, 1.8131509308235106e-42, -8.874446887517398e-29, 3.2352777643630735e-29, 1.7751534470484878e-28, 9.677996552667197e-29, -3.522499016429139e-29, -1.9343811887661463e-28, -3.3398424727198873e-57, 1.2175765121389777e-57, 6.680678754624e-57, -1.9619104324718218e-42, 7.152361469170585e-43, 3.924404654335611e-42, -1.9207954549161304e-28, 7.002472271168494e-29, 3.8421624649818547e-28, 1.8895615867288636e-28, -6.890829754013805e-29, -3.7802708543912588e-28, -9.024334686134347e-58, 3.2899210191102324e-58, 1.805135466858607e-57, -5.301129173444469e-43, 1.932585270749097e-43, 1.0603835759866454e-42, -5.190035515253675e-29, 1.8920848489580798e-29, 1.038161538626773e-28, 4.697351128776115e-29, -1.715979459963732e-29, -9.405334446324252e-29, 4.4978064357648007e-32, -2.4333588706388694e-32, -1.1063166936426568e-31, 5.047973188827835e-31, -2.731004660429027e-31, -1.2416401389472384e-30, 6.097735304605709e-31, -3.2989366052492226e-31, -1.4998480831139641e-30, 1.4528572920507058e-32, -7.860105208780054e-33, -3.5735648001554233e-32, -1.7607859765751611e-31, 9.526030603109113e-32, 4.330970991386729e-31, 5.541851232863853e-30, -2.9981976881041856e-30, -1.3631183600632e-29, 9.765960720906244e-30, -5.2834837358862644e-30, -2.402114348248941e-29, 3.003301152468314e-31, -1.6248163643609566e-31, -7.38716138291744e-31, -6.672563465414638e-30, 3.6099244665931456e-30, 1.641237446876278e-29, -3.997622300466483e-30, 2.162754183673482e-30, 9.832873755342508e-30, 2.4134559726921057e-29, -1.305704143546157e-29, -5.936330676059526e-29, 1.2128773169436232e-30, -6.561789219547814e-31, -2.983290726798662e-30, -8.013100609663399e-30, 4.335168649055155e-30, 1.970966758777687e-29, -2.3159834745870097e-29, 1.2529705341090405e-29, 5.696579469855418e-29, -6.947033544687445e-31, 3.7584155614549756e-31, 1.7087483179956607e-30, 5.842464740377451e-31, -3.160832642629011e-31, -1.4370596793365843e-30], [1.7532586716314254e-47, -6.51439984890381e-48, -3.539337487723559e-47, 1.0299097956838817e-32, -3.826728095486677e-33, -2.079098998806479e-32, 1.0083263852318883e-18, -3.746532874973968e-19, -2.0355281470196255e-18, -6.256887199852539e-18, 2.367351741509909e-18, 1.2742892181117612e-17, 4.490176072540277e-43, -1.6683677543878764e-43, -9.064406044108284e-43, 2.637646341798274e-28, -9.800426604754066e-29, -5.324668132510502e-28, 2.5823702352299114e-14, -9.59504295766115e-15, -5.213081177705501e-14, -2.8686109114351556e-14, 1.0681800591031372e-14, 5.797028516747134e-14, 9.7185885511804e-43, -3.61103428796714e-43, -1.961910432471821e-42, 5.708951970999497e-28, -2.1212155661361834e-28, -1.1524772729496912e-27, 5.589311732449751e-14, -2.07676209417896e-14, -1.1283252645671929e-13, -5.478050363822795e-14, 2.0345199700834084e-14, 1.1056273094724891e-13, 2.6259860002098117e-43, -9.757101493228242e-44, -5.301129173444465e-43, 1.5425725528728193e-28, -5.73157547597197e-29, -3.114021309152237e-28, 1.5102454726760535e-14, -5.61146112561581e-15, -3.048762001635114e-14, -1.3347413090164028e-14, 4.94513203474746e-15, 2.6907234771373057e-14, -1.1946881879369183e-17, 6.463384188006874e-18, 2.9385512802477185e-17, -1.3408211375573373e-16, 7.253978257204501e-17, 3.2979916518270295e-16, -1.6196544794928807e-16, 8.762494899080304e-17, 3.983832595257956e-16, -3.859017657516999e-18, 2.0877676669681428e-18, 9.491950613136807e-18, 4.6769247137279814e-17, -2.530263674524915e-17, -1.1503740678043125e-16, -1.472002920036799e-15, 7.963684996748387e-16, 3.620656928626899e-15, -2.5939928904785594e-15, 1.4033764459556687e-15, 6.380393818434354e-15, -7.977240601420252e-17, 4.315768021125552e-17, 1.9621463423546738e-16, 1.7723378871982989e-15, -9.588527610459476e-16, -4.359385001078707e-15, 1.0618314083559329e-15, -5.744615544369269e-16, -2.6117660456824753e-15, -6.410518958205873e-15, 3.4681557321611143e-15, 1.5767828695300385e-14, -3.2215930691174373e-16, 1.7429145038324892e-16, 7.924089761061651e-16, 2.1284056536966505e-15, -1.1514890317550941e-15, -5.2351979551730705e-15, 6.151616660390425e-15, -3.3280869648596827e-15, -1.5131011753116938e-14, 1.84524146060287e-16, -9.982943331942349e-17, -4.538704501451879e-16, -1.5518505994978456e-16, 8.395669035837937e-17, 3.817056711494309e-16], [-6.514399848903498e-48, 2.3263865028953172e-48, 1.290304626276418e-47, -3.8267280954863984e-33, 1.366580007072832e-33, 7.579585348816337e-33, -3.746532874973411e-19, 1.3379411327443385e-19, 7.420742989683853e-19, 4.201929811061796e-18, -1.6841306039523916e-18, -8.805928663413816e-18, -1.6683677543878776e-43, 5.957982800713526e-44, 3.3045294758494653e-43, -9.800426604754066e-29, 3.499874233196475e-29, 1.941166658617867e-28, -9.595042957661139e-15, 3.4265287592319227e-15, 1.9004864000902696e-14, 1.168232413591815e-14, -4.272035520249372e-15, -2.340264695060106e-14, -3.611034287967147e-43, 1.2895526255474e-43, 7.1523614691705956e-43, -2.121215566136188e-28, 7.575167900725906e-29, 4.2014833627011515e-28, -2.0767620941789646e-14, 7.416418116299445e-15, 4.113434544926925e-14, 1.995629753492447e-14, -7.087770767287716e-15, -3.942493308903208e-14, -9.757101493228268e-44, 3.4844022086005323e-44, 1.932585270749101e-43, -5.73157547597199e-29, 2.0468285854254996e-29, 1.1352509093748637e-28, -5.6114611256158405e-15, 2.0039340118724776e-15, 1.1114599070505571e-14, 4.331676077700809e-15, -1.4855242633762116e-15, -8.418164626680664e-15, 5.314220584969998e-18, -2.875047200373706e-18, -1.307128492703146e-17, 5.964250221871555e-17, -3.226719822511246e-17, -1.4670150171539004e-16, 7.204558697716369e-17, -3.897739279468453e-17, -1.7720912785916106e-16, 1.716571008269011e-18, -9.286823143029788e-19, -4.222216294526021e-18, -2.080393012922339e-17, 1.1255137064494123e-17, 5.117102197267347e-17, 6.547773969628087e-16, -3.542412084530597e-16, -1.6105432175110174e-15, 1.1538617820983144e-15, -6.242509194335015e-16, -2.838131364527186e-15, 3.548441898344472e-17, -1.9197430333203938e-17, -8.728033463921195e-17, -7.88372612935615e-16, 4.265175743894396e-16, 1.9391447696949322e-15, -4.723246103066629e-16, 2.555324015661712e-16, 1.16176764977142e-15, 2.851531650854229e-15, -1.542707525681626e-15, -7.013856894119588e-15, 1.4330313446779086e-16, -7.752844823973806e-17, -3.5247993033314663e-16, -9.467589327700372e-16, 5.122061787927547e-16, 2.3287245174673617e-15, -2.7363665446416333e-15, 1.4804020359295217e-15, 6.730587524155113e-15, -8.208016328603437e-17, 4.4406200286294475e-17, 2.0189097987453383e-16, 6.902952991349851e-17, -3.734567535307465e-17, -1.6979059100977744e-16], [-3.5393374877235947e-47, 1.2903046262765032e-47, 7.079728146706047e-47, -2.0790989988065094e-32, 7.579585348817093e-33, 4.1588166578333193e-32, -2.0355281470196867e-18, 7.420742989685359e-19, 4.071661989243205e-18, 1.0690682198249807e-17, -3.835777515129482e-18, -2.1222321040776654e-17, -9.064406044108283e-43, 3.304529475849463e-43, 1.8131509308235106e-42, -5.324668132510502e-28, 1.941166658617867e-28, 1.0650920682291059e-27, -5.2130811777055047e-14, 1.9004864000902737e-14, 1.0427713568677747e-13, 5.685107174124062e-14, -2.069207642322135e-14, -1.1363058783808206e-13, -1.96191043247182e-42, 7.152361469170576e-43, 3.924404654335608e-42, -1.1524772729496908e-27, 4.201483362701138e-28, 2.3052974789891376e-27, -1.1283252645671921e-13, 4.1134345449269113e-14, 2.25698627551161e-13, 1.1099776771155166e-13, -4.0478528233630126e-14, -2.2206295318951108e-13, -5.3011291734444615e-43, 1.932585270749093e-43, 1.0603835759866443e-42, -3.114021309152235e-28, 1.1352509093748583e-28, 6.228969231760698e-28, -3.0487620016351115e-14, 1.1114599070505492e-14, 6.098431198056348e-14, 2.759346364328384e-14, -1.0080110160610441e-14, -5.5249383531861346e-14, 2.6421286158384482e-17, -1.429418361269712e-17, -6.498792325099275e-17, 2.9653108920236165e-16, -1.6042632483984952e-16, -7.293717478814317e-16, 3.581968492907727e-16, -1.9378812607981483e-16, -8.810498175944781e-16, 8.534462033611307e-18, -4.617230463828834e-18, -2.0992050133518416e-17, -1.0343315306064795e-16, 5.595838418410658e-17, 2.544125131690631e-16, 3.255427714861059e-15, -1.7612193901211684e-15, -8.007312180577105e-15, 5.736779616989716e-15, -3.103655919672419e-15, -1.4110645152619752e-14, 1.7642172979744618e-16, -9.544594399671408e-17, -4.3394109458390043e-16, -3.919637522145266e-15, 2.1205636281631776e-15, 9.641056114145784e-15, -2.3483074307933024e-15, 1.2704581220459706e-15, 5.776086075722765e-15, 1.417726880777107e-14, -7.670046123039817e-15, -3.48715521138906e-14, 7.124757173000052e-16, -3.854565845744214e-16, -1.7524626528975879e-15, -4.707103946055914e-15, 2.5465909451051552e-15, 1.1577971948335742e-14, -1.3604689973668926e-14, 7.360275170242993e-15, 3.346319110138307e-14, -4.080868393458834e-16, 2.2077911637485124e-16, 1.003763254981975e-15, 3.432015916655072e-16, -1.8567553971553524e-16, -8.441662743090444e-16], [1.716516326139826e-33, -6.377880159144544e-34, -3.465164998010846e-33, 1.0083263852319667e-18, -3.746532874974259e-19, -2.035528147019787e-18, 9.871952897387104e-05, -3.668018273839926e-05, -0.00019928703922651166, -0.0006125764100381404, 0.00023177400915040536, 0.001247584445184834, 4.396077236330402e-29, -1.6334044341256548e-29, -8.874446887517398e-29, 2.5823702352299114e-14, -9.595042957661139e-15, -5.2130811777055047e-14, 2.528252528068223, -0.9393963454070783, -5.103832706383939, -2.8084945721326116, 1.0457946339437754, 5.675542493016947, 9.514919951665698e-29, -3.5353592768935873e-29, -1.9207954549161273e-28, 5.589311732449742e-14, -2.0767620941789523e-14, -1.1283252645671911e-13, 5.472178746851667, -2.033240215974198, -11.046794002298721, -5.363249038527955, 1.9918833432924452, 10.824571171632249, 2.570954254787996e-29, -9.552625793286466e-30, -5.190035515253658e-29, 1.5102454726760487e-14, -5.6114611256157845e-15, -3.048762001635106e-14, 1.4785958582568912, -0.549386396398408, -2.984870307501069, -1.306769665635249, 0.4841498867170877, 2.634335054128772, -0.001169651582177504, 0.0006327933613186838, 0.002876969228420092, -0.013127220816246898, 0.007101959516543291, 0.032288769509214964, -0.015857120239810712, 0.008578862774420225, 0.03900344998154297, -0.0003778145757480289, 0.0002044015149346454, 0.0009293031574856764, 0.004578912260431463, -0.0024772379438563596, -0.011262661354565363, -0.14411547396012742, 0.07796793213880704, 0.3544780259695683, -0.25396316119479767, 0.1373966443275291, 0.6246682439821158, -0.007810064739130486, 0.004225324185164805, 0.019210264209292813, 0.17351957061653678, -0.09387584646412182, -0.42680271013961196, 0.10395790293482524, -0.056242279184799175, -0.2557032302198749, -0.6276176259005832, 0.33954749702224546, 1.5437388573172834, -0.03154079422960074, 0.017063889369561863, 0.07758027759818872, 0.2083801501930712, -0.1127357733550726, -0.5125485991332107, 0.6022699673795616, -0.3258341568434421, -1.481391715066837, 0.01806571468343367, -0.009773734754303333, -0.04443588674235438, -0.015193290829637005, 0.00821972433507063, 0.03737064170334225], [-6.377880159144244e-34, 2.2776333451214868e-34, 1.2632642248027762e-33, -3.74653287497399e-19, 1.3379411327445698e-19, 7.420742989685077e-19, -3.668018273839386e-05, 1.3099024319284587e-05, 7.265229426772101e-05, 0.0004113871637246619, -0.00016488369479137073, -0.0008621386314608855, -1.6334044341256573e-29, 5.833123721994041e-30, 3.2352777643630735e-29, -9.595042957661147e-15, 3.4265287592319227e-15, 1.9004864000902737e-14, -0.9393963454070783, 0.33547203572284323, 1.8606586615802256, 1.1437502309856762, -0.4182508168936548, -2.291220697526257, -3.5353592768935974e-29, 1.262527983454298e-29, 7.00247227116849e-29, -2.0767620941789596e-14, 7.416418116299412e-15, 4.113434544926916e-14, -2.0332402159742036, 0.7260995188041118, 4.027230931249001, 1.953808133521272, -0.693923517096601, -3.8598720428014683, -9.552625793286505e-30, 3.4113809757091076e-30, 1.892084848958079e-29, -5.6114611256158105e-15, 2.0039340118724622e-15, 1.1114599070505518e-14, -0.5493863963984117, 0.1961938362857332, 1.0881674833108743, 0.4240898862917957, -0.1454392721519732, -0.8241748494752538, 0.0005202852575268468, -0.000281479597832072, -0.0012797355201441547, 0.005839259799296634, -0.0031590987370196323, -0.014362713662176254, 0.007053575623131209, -0.0038160559057828407, -0.017349542656372827, 0.00016805975115641604, -9.092202879652976e-05, -0.00041337329849357803, -0.002036795042995873, 0.0011019267628186616, 0.005009865119310748, 0.0641055487167883, -0.03468175161713994, -0.1576791703097072, 0.11296807591075883, -0.061116874090137885, -0.2778653772981057, 0.003474078611115142, -0.0018795117411975289, -0.008545123533867787, -0.07718510012708389, 0.04175792150189574, 0.18985068830902924, -0.046242629108151155, 0.02501773105379283, 0.11374209466525098, 0.2791773234830867, -0.151037761691332, -0.686687028147527, 0.014029998760655481, -0.0075903715348497654, -0.03450931484573699, -0.09269180819201589, 0.05014720773799702, 0.2279922362850937, -0.2679021597999319, 0.14493778385588185, 0.6589537275167127, -0.00803600419107577, 0.004347559718745453, 0.019766003081139003, 0.006758290547738811, -0.0036563036870435363, -0.016623235704405052], [-3.4651649980108786e-33, 1.2632642248028568e-33, 6.931361096388922e-33, -2.0355281470198157e-18, 7.420742989685802e-19, 4.071661989243461e-18, -0.00019928703922651757, 7.265229426773561e-05, 0.00039863337864204113, 0.0010466641818341973, -0.00037553926495245243, -0.0020777573289386207, -8.874446887517389e-29, 3.235277764363064e-29, 1.7751534470484878e-28, -5.213081177705501e-14, 1.9004864000902696e-14, 1.0427713568677747e-13, -5.103832706383939, 1.8606586615802256, 10.209184117874415, 5.565966641509972, -2.025844079763895, -11.124927674901418, -1.9207954549161246e-28, 7.002472271168455e-29, 3.842162464981845e-28, -1.12832526456719e-13, 4.113434544926895e-14, 2.2569862755116064e-13, -11.046794002298707, 4.0272309312489805, 22.096875107335176, 10.867163158797597, -3.963023579771266, -21.740926809501115, -5.190035515253651e-29, 1.8920848489580675e-29, 1.0381615386267686e-28, -3.0487620016351014e-14, 1.111459907050544e-14, 6.098431198056333e-14, -2.984870307501065, 1.0881674833108643, 5.970628798067513, 2.7015198387337307, -0.9868865296342962, -5.409154414924669, 0.002586758576033628, -0.0013994626085153637, -0.0063625997160162324, 0.029031680496423753, -0.01570643340802496, -0.0714086593907241, 0.03506902602154724, -0.01897269853047524, -0.08625860065680968, 0.0008355608703125793, -0.0004520468999213644, -0.0020552128078055254, -0.010126554556123456, 0.005478568655647645, 0.024908089119707776, 0.3187205009473808, -0.17243102150146097, -0.7839506120149013, 0.5616556205517598, -0.3038613835504918, -1.3814933967672642, 0.01727245296903954, -0.009344572126469936, -0.042484716344972924, -0.38374952356870506, 0.20761238186110645, 0.9439012331113915, -0.2299094884841705, 0.12438336358773747, 0.5655038934409644, 1.38801614173495, -0.7509308013399097, -3.4140762849118467, 0.06975446467266865, -0.03773787240558324, -0.1715736989254371, -0.4608459038576332, 0.24932230503131292, 1.1335336989615155, -1.3319581890414152, 0.7206028807402155, 3.2761916298872404, -0.03995347255680178, 0.021615233613846624, 0.09827277871967208, 0.033600925224732694, -0.01817844111901481, -0.08264754170471447], [-1.9067821475191736e-33, 7.765307945773876e-34, 3.7789233887176387e-33, -1.1200934829187496e-18, 4.561544083174315e-19, 2.21983799547258e-18, -0.0001096620128759235, 4.465949615916478e-05, 0.0002173317732441768, 0.0006971654194428563, -0.00028691852998304475, -0.0014000087227599557, -4.8833567532683226e-29, 1.988731069647366e-29, 9.677996552667197e-29, -2.8686109114351556e-14, 1.168232413591815e-14, 5.685107174124062e-14, -2.8084945721326116, 1.1437502309856766, 5.565966641509972, 3.128901209891571, -1.275871001055458, -6.210962978065177, -1.0569593322605122e-28, 4.3044323190464974e-29, 2.0947166653512363e-28, -6.208854332496741e-14, 2.528535624534671e-14, 1.2304911121985877e-13, -6.078737838745526, 2.4755461079232894, 12.04704198778294, 5.954196206484072, -2.4241909410165725, -11.79633277302043, -2.855929536156876e-29, 1.1630679649766497e-29, 5.659974808739511e-29, -1.6776473732390073e-14, 6.8321640700113346e-15, 3.3248165790737516e-14, -1.6424895836908993, 0.6688985121703593, 3.2551397188242395, 1.4460370747869362, -0.5878906499735146, -2.859669920082246, 0.0012849553244017073, -0.0006951738545582544, -0.003160579598683648, 0.014421296512104016, -0.007802067584501229, -0.035471782308031705, 0.017420308228789008, -0.009424563320626515, -0.042848393049250415, 0.0004150593716465621, -0.00022455132702174977, -0.001020913456955699, -0.005030299431610368, 0.0027214429786366076, 0.012372929592879282, 0.1583223144528167, -0.08565397684312044, -0.3894223149812142, 0.2789987387283515, -0.15094114552892005, -0.6862477667026085, 0.00857997751072573, -0.004641854798283746, -0.02110400366657933, -0.19062505411785124, 0.10313008641618249, 0.4688767349350241, -0.11420602761127847, 0.06178661850775631, 0.28091034299809226, 0.6894878974027041, -0.3730199410099158, -1.6959199597736436, 0.034650071951968335, -0.018746040132396204, -0.08522810748716346, -0.22892217440661725, 0.12384921666455793, 0.5630754162233138, -0.6616414777731361, 0.3579547457444328, 1.6274266634650139, -0.019846624948246638, 0.01073722525852676, 0.048816357053783226, 0.016691038805231984, -0.009030021170749313, -0.04105462324397622], [7.100254199391374e-34, -2.8396465449904814e-34, -1.375414203495422e-33, 4.1708741956451465e-19, -1.668082320245505e-19, -8.079541166532597e-19, 4.083466842024636e-05, -1.633124981712946e-05, -7.910221431937787e-05, -0.00046270685681838985, 0.0001955039386952999, 0.0009602224903602566, 1.8184077472947236e-29, -7.272465368116035e-30, -3.522499016429139e-29, 1.0681800591031372e-14, -4.272035520249372e-15, -2.069207642322135e-14, 1.0457946339437754, -0.4182508168936548, -2.025844079763895, -1.275871001055458, 0.5159661972301666, 2.5063805021094363, 3.9357825681517836e-29, -1.5740607389020054e-29, -7.624137240846565e-29, 2.3119811618268926e-14, -9.246442639796781e-15, -4.4786167352475396e-14, 2.263529891063257, -0.9052668614584917, -4.384760143477318, -2.1740995143853583, 0.8672850235999482, 4.197976277766538, 1.0634579156642156e-29, -4.253149973443974e-30, -2.0600602188997564e-29, 6.247028703534166e-15, -2.4984110394199515e-15, -1.2101330131562155e-14, 0.6116112204654078, -0.24460528317717017, -1.184772736330211, -0.4705433578432664, 0.18469256801033979, 0.8901390594194883, -0.0005715747510230603, 0.00030922773367384127, 0.0014058912889032189, -0.00641489148050619, 0.003470521311044621, 0.015778583703287604, -0.007748914028004176, 0.004192241030633773, 0.019059852995485977, -0.00018462700803946827, 9.988508269275038e-05, 0.000454123457753089, 0.0022375814089356503, -0.0012105542219235836, -0.005503735435135594, -0.07042504571658796, 0.03810066354722246, 0.17322311406573565, -0.12410441950474514, 0.06714174885029439, 0.30525722485784307, -0.003816551763587524, 0.002064793187926266, 0.00938749808047319, 0.0847939735935176, -0.04587439916929603, -0.20856608626122888, 0.050801207293057635, -0.02748396805668795, -0.1249547406900676, -0.30669850212485744, 0.16592699828583707, 0.7543803355295632, -0.015413069912060135, 0.008338627046299524, 0.03791122803419184, 0.10182932616824136, -0.055090697579237714, -0.25046761138166385, 0.29431183772929576, -0.15922568729901998, -0.7239130982327474, 0.008828189975183745, -0.004776140257388697, -0.021714527033739953, -0.007424519878820491, 0.004016740507929479, 0.018261947021346633], [3.853318147933483e-33, -1.5555873831552647e-33, -7.553090432657096e-33, 2.2635394141529526e-18, -9.137925337982697e-19, -4.436881990175096e-18, 0.00022161033178514703, -8.946425466755363e-05, -0.00043439000168777513, -0.001203367017950282, 0.0004839851641999804, 0.0023476856255909605, 9.86852495167541e-29, -3.983930813865461e-29, -1.9343811887661463e-28, 5.797028516747134e-14, -2.340264695060106e-14, -1.1363058783808206e-13, 5.675542493016947, -2.291220697526257, -11.124927674901418, -6.210962978065177, 2.5063805021094363, 12.16838139966535, 2.135954850388117e-28, -8.622865511468282e-29, -4.186796813989028e-28, 1.2547154958636575e-13, -5.065295726649665e-14, -2.459433465829146e-13, 12.284209216581383, -4.95914433631746, -24.078920957066163, -12.076091988984233, 4.875512007576505, 23.673331887562743, 5.771401376507686e-29, -2.329918999612087e-29, -1.1312825685909774e-28, 3.390271446345046e-14, -1.3686550876247405e-14, -6.645448375248282e-14, 3.319222874444365, -1.3399727266576937, -6.506182353582052, -2.990937860307336, 1.2080507299060264, 5.866404402698079, -0.002841760106909997, 0.0015374210213653361, 0.00698982201769136, -0.03189361088261896, 0.01725476675492561, 0.07844809385174167, -0.03852611529330675, 0.020843018866880735, 0.09476193584337633, -0.0009179300960471301, 0.0004966094859221873, 0.002257814788957831, 0.01112482588234597, -0.006018643561417777, -0.027363517668617686, -0.35013982875642824, 0.18942919630634353, 0.8612321210229021, -0.6170233863699464, 0.3338159060550224, 1.5176804125696497, -0.018975163840437813, 0.010265755966242195, 0.04667284113063733, 0.4215793840318119, -0.22807871980774566, -1.0369506045021168, 0.2525738654653273, -0.13664502125625455, -0.6212510203201596, -1.52484616688799, 0.8249572318301923, 3.7506344342680737, -0.07663082934071057, 0.041458055388487056, 0.18848735924513868, 0.5062758918242692, -0.2739003889907737, -1.2452769560297323, 1.463262045696518, -0.7916395980609461, -3.5991571701606557, 0.043892068435135885, -0.023746053904866157, -0.10796046633349494, -0.03691328976101165, 0.01997046390662359, 0.09079490027660957], [6.460001624690165e-62, -2.4002752297036326e-62, -1.3040931318905548e-61, 3.7947731621434395e-47, -1.409984169140806e-47, -7.660582621093711e-47, 3.715247608474572e-33, -1.3804356910304746e-33, -7.500042834303265e-33, -2.3053929309210116e-32, 8.722669588815862e-33, 4.6952058772179126e-32, 1.6544361190447844e-57, -6.147215227458514e-58, -3.3398424727198873e-57, 9.718588551180397e-43, -3.611034287967147e-43, -1.96191043247182e-42, 9.514919951665698e-29, -3.5353592768935974e-29, -1.9207954549161246e-28, -1.0569593322605122e-28, 3.9357825681517836e-29, 2.135954850388117e-28, 3.5808804967666985e-57, -1.3305103088623748e-57, -7.228793324302402e-57, 2.103502444029996e-42, -7.815763997224095e-43, -4.2463814245651716e-42, 2.059420178936134e-28, -7.651972135981185e-29, -4.157391695944414e-28, -2.0184251658370926e-28, 7.496328137349936e-29, 4.073759526224421e-28, 9.675625224191222e-58, -3.5950708539699086e-58, -1.953237341828063e-57, 5.6837141940317966e-43, -2.1118382293446874e-43, -1.1473824736725554e-42, 5.564602853548152e-29, -2.067581274509417e-29, -1.1233372349745777e-28, -4.9179457454294404e-29, 1.822067758492839e-29, 9.91415489063274e-29, -4.401910431099851e-32, 2.3814781601319032e-32, 1.0827293400449406e-31, -4.940347289986311e-31, 2.6727779582806126e-31, 1.2151676061121461e-30, -5.967727830614296e-31, 3.228601244089431e-31, 1.4678703978068916e-30, -1.421881479363847e-32, 7.692522922496097e-33, 3.497374196660069e-32, 1.7232449345950123e-31, -9.322929760909604e-32, -4.238632021196438e-31, -5.4236955498061394e-30, 2.9342742659669697e-30, 1.334055836701571e-29, -9.55774442075537e-30, 5.170836607064771e-30, 2.350899790211551e-29, -2.9392689213262065e-31, 1.5901742782948514e-31, 7.229662550418987e-31, 6.530300300837664e-30, -3.5329586526052725e-30, -1.606245253212618e-29, 3.912390529769117e-30, -2.1166429318335776e-30, -9.623230828067037e-30, -2.361999604233115e-29, 1.2778657266581134e-29, 5.809764448202883e-29, -1.1870180251966986e-30, 6.421887830149501e-31, 2.919685130261838e-30, 7.842256367160036e-30, -4.242740182216865e-30, -1.9289445330119693e-29, 2.2666052798481384e-29, -1.2262564302675456e-29, -5.575124885444733e-29, 6.798918508897641e-31, -3.6782838258275345e-31, -1.672316750960946e-30, -5.717899792107779e-31, 3.0934417430490605e-31, 1.4064206814869492e-30], [-2.4002752297035125e-62, 8.571730362170071e-63, 4.754215745207034e-62, -1.4099841691407002e-47, 5.035257608476544e-48, 2.7927501206806903e-47, -1.380435691030267e-33, 4.929735715053242e-34, 2.7342235658335003e-33, 1.5482298103242819e-32, -6.205294525992229e-33, -3.2446047119576286e-32, -6.147215227458504e-58, 2.1952595584011286e-58, 1.2175765121389777e-57, -3.61103428796714e-43, 1.2895526255474e-43, 7.152361469170576e-43, -3.5353592768935873e-29, 1.262527983454298e-29, 7.002472271168455e-29, 4.3044323190464974e-29, -1.5740607389020054e-29, -8.622865511468282e-29, -1.3305103088623748e-57, 4.751444947030015e-58, 2.6353365569394173e-57, -7.8157639972241e-43, 2.7911224816846435e-43, 1.5480653133688822e-42, -7.651972135981188e-29, 2.7326300366217656e-29, 1.5156231235724224e-28, 7.353034471431024e-29, -2.611537670565458e-29, -1.4526386546912725e-28, -3.5950708539699135e-58, 1.2838518521450342e-58, 7.120742757983629e-58, -2.1118382293446914e-43, 7.541680073372939e-44, 4.182909708450778e-43, -2.067581274509424e-29, 7.383632080041143e-30, 4.095250131370222e-29, 1.5960357106655923e-29, -5.4735158651731534e-30, -3.1017303975267903e-29, 1.9580609620441116e-32, -1.0593308269904548e-32, -4.816204433019486e-32, 2.197568832641062e-31, -1.1889070125885346e-31, -5.405317280102594e-31, 2.654568983201781e-31, -1.4361487261064091e-31, -6.529391654540546e-31, 6.324823416954991e-33, -3.421793575751068e-33, -1.555704504062211e-32, -7.665350504707287e-32, 4.1470323175465474e-32, 1.8854313423867601e-31, 2.412572153003646e-30, -1.3052259881364759e-30, -5.934156761976121e-30, 4.2514827433233346e-30, -2.300095256339051e-30, -1.0457289345028274e-29, 1.3074477143235172e-31, -7.073424654844343e-32, -3.2159036923408437e-31, -2.9048128737822336e-30, 1.5715332073337747e-30, 7.144911680991321e-30, -1.740312367668486e-30, 9.4152663037589e-31, 4.280612454095177e-30, 1.0506663617544182e-29, -5.684211510587698e-30, -2.58430359789385e-29, 5.2801021119360136e-31, -2.8565887606441097e-31, -1.2987364383054847e-30, -3.4883981142345094e-30, 1.887258737524802e-30, 8.580344936949195e-30, -1.0082329898122897e-29, 5.454642667416835e-30, 2.4799310589294356e-29, -3.0242998181735723e-31, 1.6361768553458745e-31, 7.438811392195715e-31, 2.543440295537539e-31, -1.3760269797013183e-31, -6.256050584707145e-31], [-1.3040931318905686e-61, 4.754215745207361e-62, 2.6085743119427324e-61, -7.660582621093831e-47, 2.792750120680976e-47, 1.5323444738130227e-46, -7.500042834303499e-33, 2.7342235658340627e-33, 1.5002317394058643e-32, 3.939055057145521e-32, -1.4133184897713523e-32, -7.819509500873824e-32, -3.3398424727198873e-57, 1.21757651213898e-57, 6.680678754624e-57, -1.961910432471821e-42, 7.1523614691705956e-43, 3.924404654335608e-42, -1.9207954549161273e-28, 7.00247227116849e-29, 3.842162464981845e-28, 2.0947166653512363e-28, -7.624137240846565e-29, -4.186796813989028e-28, -7.228793324302402e-57, 2.6353365569394173e-57, 1.445973766059271e-56, -4.246381424565173e-42, 1.5480653133688812e-42, 8.494026409580851e-42, -4.157391695944414e-28, 1.5156231235724218e-28, 8.316020472404928e-28, 4.089788753683373e-28, -1.491459089211277e-28, -8.182061561132306e-28, -1.9532373418280634e-57, 7.120742757983618e-58, 3.907055892268548e-57, -1.1473824736725556e-42, 4.1829097084507695e-43, 2.2951063644177617e-42, -1.1233372349745777e-28, 4.095250131370205e-29, 2.2470087320798434e-28, 1.0167000617232116e-28, -3.71408560917066e-29, -2.0357013665692854e-28, 9.735103796791523e-32, -5.266789827180446e-32, -2.394524530690067e-31, 1.092589102232087e-30, -5.911017785779218e-31, -2.6874201465850044e-30, 1.319800817653526e-30, -7.1402561959461856e-31, -3.2462883801380116e-30, 3.14458097342157e-32, -1.7012501794814204e-32, -7.734664608384403e-32, -3.8110653472306255e-31, 2.0618249810679304e-31, 9.374003248957876e-31, 1.1994846320933998e-29, -6.48933343705165e-30, -2.9503490005725565e-29, 2.1137557307364483e-29, -1.1435632749448598e-29, -5.199163824841061e-29, 6.500379433809749e-31, -3.5167711602710885e-31, -1.5988856757932717e-30, -1.4442172835622495e-29, 7.813361887123068e-30, 3.5523131394614735e-29, -8.652499521979158e-30, 4.681089941440836e-30, 2.128238464595682e-29, 5.223711766766814e-29, -2.826081012346017e-29, -1.2848662148728157e-28, 2.6251655650033445e-30, -1.4202411788337353e-30, -6.457068639160374e-30, -1.73436467938937e-29, 9.38308870732278e-30, 4.2659830410118386e-29, -5.0127411747821635e-29, 2.711943783725483e-29, 1.2329741890345339e-28, -1.5036239020771708e-30, 8.134757714627888e-31, 3.698434442622278e-30, 1.2645497641784987e-30, -6.84134239650711e-31, -3.1103884394141925e-30], [3.794773162143543e-47, -1.4099841691408453e-47, -7.66058262109392e-47, 2.2291485650849478e-32, -8.282614146183619e-33, -4.500025700582377e-32, 2.182433184145442e-18, -8.109038691826595e-19, -4.405720449630083e-18, -1.3542478362571755e-17, 5.1239232404174e-18, 2.7580861877042815e-17, 9.718588551180407e-43, -3.611034287967151e-43, -1.9619104324718218e-42, 5.708951970999497e-28, -2.121215566136188e-28, -1.1524772729496908e-27, 5.589311732449742e-14, -2.0767620941789596e-14, -1.12832526456719e-13, -6.208854332496741e-14, 2.3119811618268926e-14, 1.2547154958636575e-13, 2.103502444029996e-42, -7.8157639972241e-43, -4.246381424565173e-42, 1.2356521073616951e-27, -4.591183281588765e-28, -2.4944350175666776e-27, 1.209757037015996e-13, -4.494967677424432e-14, -2.4421601338289067e-13, -1.1856754988790102e-13, 4.403538339915109e-14, 2.393032419691454e-13, 5.6837141940317934e-43, -2.1118382293446866e-43, -1.1473824736725552e-42, 3.338761712128926e-28, -1.2405487647056635e-28, -6.740023409847536e-28, 3.268792609265743e-14, -1.2145510770572272e-14, -6.598775416751564e-14, -2.888929386070974e-14, 1.0703300449815743e-14, 5.823832731019121e-14, -2.5857968057242705e-17, 1.3989422810296847e-17, 6.360234068307982e-17, -2.9020886366429987e-16, 1.5700593674291128e-16, 7.138210927929534e-16, -3.505598717504718e-16, 1.8965644382359499e-16, 8.622652925988571e-16, -8.352502044297355e-18, 4.51878826529897e-18, 2.0544486689808696e-17, 1.0122789450404506e-16, -5.476531695291315e-17, -2.489882816246186e-16, -3.186019990053616e-15, 1.72366910749716e-15, 7.836591350948578e-15, -5.614467940671643e-15, 3.0374840630570102e-15, 1.3809797503280898e-14, -1.7266030981077731e-16, 9.341097765890577e-17, 4.2468920306192717e-16, 3.836068434974306e-15, -2.075351904963695e-15, -9.435502857174664e-15, 2.2982400693907683e-15, -1.2433711720541752e-15, -5.652936361484685e-15, -1.3875000701052286e-14, 7.50651601357429e-15, 3.412806913569994e-14, -6.972852959945041e-16, 3.7723841268099327e-16, 1.7150990693069052e-15, 4.606745589506806e-15, -2.49229605699933e-15, -1.1331122452292585e-14, 1.3314629600504325e-14, -7.20334956836549e-15, -3.2749735247781724e-14, 3.9938617647643707e-16, -2.160719695742564e-16, -9.823624038877939e-16, -3.358843222575417e-16, 1.817168227994082e-16, 8.261681291831382e-16], [-1.4099841691407748e-47, 5.035257608476844e-48, 2.792750120680845e-47, -8.282614146182995e-33, 2.9578414290325055e-33, 1.6405341395003928e-32, -8.1090386918253735e-19, 2.895855121219384e-19, 1.606154117248078e-18, 9.094705039382954e-18, -3.645151580215113e-18, -1.9059652919656683e-17, -3.6110342879671445e-43, 1.2895526255474024e-43, 7.152361469170585e-43, -2.1212155661361834e-28, 7.575167900725906e-29, 4.201483362701138e-28, -2.0767620941789523e-14, 7.416418116299409e-15, 4.113434544926895e-14, 2.528535624534671e-14, -9.246442639796781e-15, -5.065295726649665e-14, -7.815763997224095e-43, 2.7911224816846435e-43, 1.5480653133688812e-42, -4.591183281588765e-28, 1.6395780219730773e-28, 9.093738741434637e-28, -4.494967677424431e-14, 1.6052180366962297e-14, 8.903164871158441e-14, 4.3193639094233314e-14, -1.5340852278290215e-14, -8.533177700832434e-14, -2.1118382293446894e-43, 7.541680073372929e-44, 4.182909708450773e-43, -1.240548764705665e-28, 4.4301792480247236e-29, 2.4571500788221534e-28, -1.2145510770572312e-14, 4.337337741432238e-15, 2.405656560734052e-14, 9.375529345856739e-15, -3.215285740539141e-15, -1.822037199457208e-14, 1.1502159937865859e-17, -6.222785110038584e-18, -2.829163889985194e-17, 1.290909153365636e-16, -6.983949363745882e-17, -3.175224115889885e-16, 1.559362941336092e-16, -8.436311566619187e-17, -3.835534672479724e-16, 3.715365963102056e-18, -2.0100506442640594e-18, -9.138613336686665e-18, -4.502826479564825e-17, 2.436074765216851e-17, 1.107551464044207e-16, 1.4172077020788982e-15, -7.667237313659562e-16, -3.4858781976513285e-15, 2.497431665035159e-15, -1.3511358442650128e-15, -6.142884051857525e-15, 7.680288311783145e-17, -4.1551138225812994e-17, -1.8891055657154986e-16, -1.7063627186017256e-15, 9.23159526123741e-16, 4.1971071631444325e-15, -1.0223047996356502e-15, 5.530772584852457e-16, 2.5145432156322214e-15, 6.17188778515809e-15, -3.3390538488231657e-15, -1.5180872244113303e-14, 3.101669465712127e-16, -1.6780346188679268e-16, -7.629116008180449e-16, -2.049175884441695e-15, 1.1086249235306519e-15, 5.040318034011438e-15, -5.9226231094189915e-15, 3.2041991327501e-15, 1.456776077334655e-14, -1.7765524609803953e-16, 9.611328881801533e-17, 4.3697515061702234e-16, 1.4940830565941554e-16, -8.083140773523324e-17, -3.67496701070841e-16], [-7.660582621093998e-47, 2.792750120681037e-47, 1.5323444738130556e-46, -4.500025700582446e-32, 1.640534139500561e-32, 9.001390436435876e-32, -4.4057204496302185e-18, 1.606154117248409e-18, 8.812751872901192e-18, 2.3139035070720348e-17, -8.302200813769614e-18, -4.593383487959357e-17, -1.961910432471822e-42, 7.1523614691706e-43, 3.924404654335611e-42, -1.1524772729496912e-27, 4.2014833627011515e-28, 2.3052974789891376e-27, -1.1283252645671911e-13, 4.113434544926916e-14, 2.2569862755116064e-13, 1.2304911121985877e-13, -4.4786167352475396e-14, -2.459433465829146e-13, -4.2463814245651716e-42, 1.5480653133688822e-42, 8.494026409580851e-42, -2.4944350175666776e-27, 9.093738741434637e-28, 4.989612283443014e-27, -2.442160133828907e-13, 8.903164871158441e-14, 4.88504696096451e-13, 2.4024484052755194e-13, -8.761219041404592e-14, -4.806356008413596e-13, -1.1473824736725549e-42, 4.182909708450768e-43, 2.295106364417761e-42, -6.740023409847537e-28, 2.4571500788221494e-28, 1.3482052392479204e-27, -6.59877541675156e-14, 2.405656560734042e-14, 1.319951437629514e-13, 5.972360894509793e-14, -2.181750595497776e-14, -1.1958239890329076e-13, 5.71865345630126e-17, -3.0938494830167415e-17, -1.4066060588015473e-16, 6.418152878714929e-16, -3.472285760532445e-16, -1.578660570097575e-15, 7.752853657288225e-16, -4.194372410007759e-16, -1.906954322494772e-15, 1.8472087434962093e-17, -9.99358653179536e-18, -4.543543388889839e-17, -2.238719018826821e-16, 1.2111696804052992e-16, 5.506533592040364e-16, 7.0460850549553325e-15, -3.812003432476753e-15, -1.7331118251640903e-14, 1.2416751549517604e-14, -6.7175884420646184e-15, -3.054124208372889e-14, 3.818492138592019e-16, -2.0658429504709607e-16, -9.392270783100696e-16, -8.48370837403424e-15, 4.58977221956843e-15, 2.0867212345019816e-14, -5.08270351604457e-15, 2.749794119473113e-15, 1.2501826899272062e-14, 3.0685443086480454e-14, -1.660113573146118e-14, -7.547638704159257e-14, 1.542090607869758e-15, -8.34286649187624e-16, -3.793050250073232e-15, -1.0188109726724925e-14, 5.511870626854276e-15, 2.505949517461251e-14, -2.9446146895895847e-14, 1.593066393109005e-14, 7.242811432556496e-14, -8.832678319695723e-16, 4.778568497262664e-16, 2.1725566927366624e-15, 7.428294582711759e-16, -4.0187826609943185e-16, -1.8271231587030166e-15], [3.715247608474969e-33, -1.3804356910306253e-33, -7.500042834304074e-33, 2.1824331841456162e-18, -8.109038691827255e-19, -4.405720449630439e-18, 0.00021366967988865678, -7.939100789313573e-05, -0.00043133915163591735, -0.0013258674023336934, 0.00050165432165692, 0.0027002860711305334, 9.514919951665726e-29, -3.535359276893611e-29, -1.9207954549161304e-28, 5.589311732449751e-14, -2.0767620941789646e-14, -1.1283252645671921e-13, 5.472178746851667, -2.033240215974204, -11.046794002298707, -6.078737838745526, 2.263529891063257, 12.284209216581383, 2.059420178936134e-28, -7.651972135981186e-29, -4.157391695944414e-28, 1.209757037015996e-13, -4.494967677424431e-14, -2.442160133828906e-13, 11.844046393726003, -4.400768425454495, -23.909807540631988, -11.608277684638535, 4.311255136250644, 23.428825899147217, 5.564602853548141e-29, -2.0675812745094136e-29, -1.1233372349745757e-28, 3.268792609265738e-14, -1.214551077057226e-14, -6.598775416751554e-14, 3.200289821095722, -1.1890982126211411, -6.460487501735503, -2.8283872405670967, 1.047899563422253, 5.701784982018532, -0.0025316072892859563, 0.0013696252033821709, 0.006226945169569643, -0.028412707179524526, 0.015371562569789478, 0.06988618277198863, -0.0343213327779661, 0.018568188907224736, 0.08441951414005745, -0.0008177461977023494, 0.00044240898147317783, 0.0020113944043638828, 0.009910650173215381, -0.005361762196129599, -0.024377033311831057, -0.31192518347826337, 0.16875468587465395, 0.7672363019127418, -0.5496807766411277, 0.297382871620154, 1.3520391063007946, -0.01690419362881467, 0.009145340090803323, 0.041578916014302775, 0.3755677472677748, -0.20318595795341193, -0.9237766772092211, 0.22500767652426065, -0.12173143363361481, -0.553447001981109, -1.3584227823265898, 0.7349204939474591, 3.3412860748349895, -0.06826725650460236, 0.036933277712607016, 0.1679156419442152, 0.4510203852237628, -0.24400659986084566, -1.1093660620398536, 1.3035600197262214, -0.7052391833023818, -3.206341205617153, 0.039101639903395026, -0.021154383514343688, -0.09617754252373391, -0.0328845327947527, 0.017790865553181476, 0.08088544518988006], [-1.3804356910305565e-33, 4.9297357150544145e-34, 2.7342235658341086e-33, -8.109038691826646e-19, 2.895855121219899e-19, 1.6061541172483466e-18, -7.939100789312375e-05, 2.835167835835281e-05, 0.00015724945834647575, 0.0008904110918784521, -0.00035687615866011755, -0.0018660227344951099, -3.535359276893604e-29, 1.2625279834543062e-29, 7.002472271168494e-29, -2.07676209417896e-14, 7.416418116299445e-15, 4.1134345449269113e-14, -2.033240215974198, 0.7260995188041118, 4.0272309312489805, 2.4755461079232894, -0.9052668614584917, -4.95914433631746, -7.651972135981185e-29, 2.7326300366217656e-29, 1.5156231235724218e-28, -4.494967677424432e-14, 1.6052180366962297e-14, 8.903164871158441e-14, -4.400768425454495, 1.5715781199811723, 8.716584781775305, 4.228844715860018, -1.5019360131315704, -8.35435128559878, -2.0675812745094153e-29, 7.383632080041116e-30, 4.0952501313702043e-29, -1.2145510770572275e-14, 4.337337741432227e-15, 2.4056565607340452e-14, -1.1890982126211451, 0.42464418774117013, 2.3552421718484875, 0.9179050101826234, -0.31479042745611846, -1.783853489680542, 0.0011261113741332055, -0.0006092376674516491, -0.002769874226240678, 0.012638560830579395, -0.006837589511334722, -0.03108682205465044, 0.015266839916383565, -0.008259515136479737, -0.037551548960317274, 0.0003637504514558933, -0.00019679268114137515, -0.0008947099047344404, -0.0044084625338003764, 0.0023850229141037073, 0.010843409479919642, 0.13875078432584764, -0.0750655806712123, -0.3412826033043725, 0.2445093981746823, -0.13228206271214582, -0.6014150071070682, 0.007519335560661702, -0.004068036752838859, -0.018495163308303638, -0.16706031529681475, 0.0903813238663982, 0.41091500556458505, -0.1000880764064802, 0.05414866380915645, 0.24618469323756623, 0.6042545984654328, -0.32690786237673297, -1.486273273516225, 0.030366690108711503, -0.016428687139670068, -0.07469235654697184, -0.20062321194756594, 0.10853919114143883, 0.4934690091261355, -0.5798505049703196, 0.3137050004407374, 1.4262469997927107, -0.01739321956798974, 0.009409908080568645, 0.042781763597585815, 0.014627721515082327, -0.00791374560339612, -0.03597952186961939], [-7.500042834304155e-33, 2.7342235658342974e-33, 1.500231739405994e-32, -4.405720449630507e-18, 1.6061541172485112e-18, 8.812751872901762e-18, -0.00043133915163593074, 0.00015724945834650814, 0.0008628066532805567, 0.0022654119504827578, -0.0008128214889401541, -0.004497121774944157, -1.920795454916131e-28, 7.002472271168511e-29, 3.8421624649818547e-28, -1.1283252645671929e-13, 4.113434544926925e-14, 2.25698627551161e-13, -11.046794002298721, 4.027230931249001, 22.096875107335176, 12.04704198778294, -4.384760143477318, -24.078920957066163, -4.157391695944414e-28, 1.5156231235724224e-28, 8.316020472404928e-28, -2.4421601338289067e-13, 8.903164871158441e-14, 4.88504696096451e-13, -23.909807540631988, 8.716584781775305, 47.82672972410147, 23.521012484294445, -8.577613654386997, -47.05631114891512, -1.123337234974576e-28, 4.0952501313702004e-29, 2.2470087320798407e-28, -6.598775416751555e-14, 2.4056565607340414e-14, 1.3199514376295122e-13, -6.4604875017355, 2.355242171848478, 12.922897397076747, 5.847200499790404, -2.1360285149780305, -11.70763580741128, 0.005598809907578004, -0.0030290129084465886, -0.013771283744077389, 0.06283650198475398, -0.03399518447229885, -0.15455772076599533, 0.07590380183047936, -0.041064726136442686, -0.18669910383043115, 0.0018084975236706251, -0.0009784154908845095, -0.0044483261550316375, -0.021918030736903266, 0.011857876785555724, 0.05391135355046866, 0.6898423049547172, -0.3732116790877608, -1.6967916891304855, 1.215653861990399, -0.6576810609676071, -2.9901201406024054, 0.03738469515756484, -0.02022549900423215, -0.0919544069542048, -0.8305918667830382, 0.4493586186470304, 2.042990646549789, -0.49761873175853377, 0.2692167776479224, 1.22398310793502, 3.004238044564545, -1.6253232324811746, -7.3894658381691425, 0.15097736276029647, -0.08168028353046707, -0.3713560802788481, -0.9974601558453726, 0.5396360543742343, 2.453433328923376, -2.8829055693011014, 1.5596811335613099, 7.0910267106033755, -0.08647575388970496, 0.046784259355730586, 0.21270272851847621, 0.07272622764064837, -0.039345626292470966, -0.17888328644988558], [-3.641291537764673e-33, 1.3265065582260313e-33, 7.378085366794486e-33, -2.1389894625161386e-18, 7.79224492347529e-19, 4.33407945764376e-18, -0.00020941635100730723, 7.628945942117255e-05, 0.0004243251876181866, 0.0012929877673288493, -0.00048021972004313757, -0.0026410389579675396, -9.325515054090928e-29, 3.397244288130023e-29, 1.8895615867288636e-28, -5.478050363822795e-14, 1.995629753492447e-14, 1.1099776771155166e-13, -5.363249038527955, 1.953808133521272, 10.867163158797597, 5.954196206484072, -2.1740995143853583, -12.076091988984233, -2.0184251658370926e-28, 7.353034471431024e-29, 4.089788753683373e-28, -1.1856754988790102e-13, 4.31936390942333e-14, 2.4024484052755194e-13, -11.608277684638535, 4.228844715860018, 23.521012484294445, 11.378577309539239, -4.1432177502708, -23.05110346227025, -5.453833342204413e-29, 1.986807598588254e-29, 1.1050707573872597e-28, -3.2037237140468297e-14, 1.1671025166076764e-14, 6.491473371113804e-14, -3.1365845488650095, 1.1426440128037814, 6.355434142441967, 2.774254184592075, -1.0075756672683664, -5.614197620509599, 0.002486788878647229, -0.0013453779889559376, -0.006116706197350012, 0.02790970168450993, -0.015099431498620842, -0.0686489499473306, 0.03371372369395799, -0.018239466234169, -0.08292498990374982, 0.0008032691952691565, -0.0004345767764207432, -0.0019757856032861115, -0.009735196582510475, 0.005266840025194818, 0.023945473530127423, 0.30640300354899314, -0.1657671305611784, -0.7536535034346404, 0.539949481083567, -0.29211814208899706, -1.3281032280457994, 0.016604929562551666, -0.008983435197672744, -0.04084282201594501, -0.36891886867157814, 0.19958884724113096, 0.9074225599522276, -0.2210242441467316, 0.11957635634207678, 0.5436490309029969, 1.3343738904084095, -0.7219097996648386, -3.2821334835159575, 0.06705868440570248, -0.03627942795725075, -0.16494294067843396, -0.4430357278414968, 0.23968681928610752, 1.0897263557048347, -1.280482392914365, 0.6927539532868363, 3.1495776161736453, -0.038409402461492145, 0.020779876041890334, 0.09447485956287544, 0.03230236015656536, -0.017475904255133637, -0.07945348648421573], [1.3523571085439597e-33, -4.711281934715297e-34, -2.6906310188689148e-33, 7.944097787100055e-19, -2.767529682472133e-19, -1.580546720082882e-18, 7.777616485602663e-05, -2.7095316623295186e-05, -0.00015474238303490423, -0.0008704631956995394, 0.00034497411074153184, 0.00182789766951122, 3.463448736097673e-29, -1.2065809658632296e-29, -6.890829754013805e-29, 2.0345199700834084e-14, -7.087770767287716e-15, -4.0478528233630126e-14, 1.9918833432924452, -0.6939235170966013, -3.963023579771266, -2.4241909410165725, 0.8672850235999482, 4.875512007576505, 7.496328137349936e-29, -2.611537670565458e-29, -1.491459089211277e-28, 4.403538339915109e-14, -1.5340852278290215e-14, -8.761219041404592e-14, 4.311255136250644, -1.5019360131315704, -8.577613654386997, -4.1432177502708, 1.4345506270414066, 8.222930620934736, 2.0255258917478217e-29, -7.056437594626334e-30, -4.029958329369545e-29, 1.1898466501701792e-14, -4.145135181094181e-15, -2.3673024561478906e-14, 1.1649115065944253, -0.40582672297773403, -2.317691838995807, -0.8998486078193759, 0.29953272377045936, 1.7582132893565074, -0.0011061752164975246, 0.0005984520041017341, 0.0027208376473784415, -0.012414813564727898, 0.00671653997265035, 0.03053647526026617, -0.014996562806887175, 0.008113292480766044, 0.03688675361526259, -0.000357310780827527, 0.00019330875406018156, 0.0008788703722435083, 0.004330417141467413, -0.002342799565798676, -0.01065144274761813, -0.1362944042803804, 0.07373665416922476, 0.3352406931220615, -0.24018071628993706, 0.12994020193782205, 0.5907678325366313, -0.007386216703596325, 0.003996018101899678, 0.018167733446851596, 0.16410275634045712, -0.08878125449376711, -0.40364035537103027, 0.09831616315302641, -0.05319004077927029, -0.24182635269984304, -0.5935571530761041, 0.3211204359938829, 1.4599609753269571, -0.029829092198960225, 0.016137841221506907, 0.07337003743315675, 0.19707147091143448, -0.10661766324113622, -0.4847328608372201, 0.5695850984237287, -0.30815131145087005, -1.400997379134922, 0.017085298011503946, -0.009243319397476902, -0.04202437493905244, -0.014368759063699584, 0.007773644292405082, 0.03534255696887741], [7.349168223225865e-33, -2.620597944518574e-33, -1.4760652031240872e-32, 4.317092774556789e-18, -1.5394074686636573e-18, -8.670791346213901e-18, 0.000422662117626438, -0.0001507146717879223, -0.0008489081016481068, -0.0022045017673279965, 0.000770668712709239, 0.004392201006467664, 1.8821557733004577e-28, -6.711471830495008e-29, -3.7802708543912588e-28, 1.1056273094724891e-13, -3.942493308903208e-14, -2.2206295318951108e-13, 10.824571171632249, -3.8598720428014683, -21.740926809501115, -11.79633277302043, 4.197976277766538, 23.673331887562743, 4.073759526224421e-28, -1.4526386546912725e-28, -8.182061561132306e-28, 2.393032419691454e-13, -8.533177700832434e-14, -4.806356008413596e-13, 23.428825899147217, -8.35435128559878, -47.05631114891512, -23.05110346227025, 8.222930620934736, 46.3051878753919, 1.100739621576774e-28, -3.925064581646048e-29, -2.210812712076244e-28, 6.466031151606599e-14, -2.3056851374747105e-14, -1.2986889529946655e-13, 6.3305251054219385, -2.257365809992302, -12.71472844516704, -5.734704101261441, 2.0500622856505024, 11.529903347724662, -0.005499691153027102, 0.0029753886575861572, 0.013527483272939313, -0.061724073465144094, 0.033393349367831074, 0.1518215019906773, -0.07456003584675977, 0.04033773511910007, 0.18339386879782274, -0.0017764807156143273, 0.0009610940732099213, 0.004369575035489935, 0.02153000400538131, -0.011647950390838963, -0.05295693175221414, -0.6776296541892237, 0.366604511238579, 1.6667524697722256, -1.194132485348839, 0.646037778068041, 2.937184429409044, -0.03672285371546345, 0.01986743607575934, 0.09032648844237406, 0.8158874505348257, -0.441403380415648, -2.0068224801380175, 0.4888091186894517, -0.2644506876850266, -1.2023142741556032, -2.951052396495187, 1.5965492577962812, 7.258646134916777, -0.14830452899576277, 0.08023425337253182, 0.36478176309720495, 0.979801580184905, -0.5300825859580375, -2.409998874110504, 2.83186793554786, -1.5320692563932903, -6.965490436351437, 0.08494482693096031, -0.04595601235387222, -0.2089371372788461, -0.07143871596836071, 0.03864906942779578, 0.17571641905206836], [1.745507975611193e-62, -6.485601398452635e-63, -3.5236910064460216e-62, 1.0253568350262406e-47, -3.8098111358274486e-48, -2.0699078482954557e-47, 1.003868839162066e-33, -3.729970437317981e-34, -2.0265296117986366e-33, -6.229227145176287e-33, 2.3568863013450935e-33, 1.268655920224089e-32, 4.4703261836569684e-58, -1.6609923388126164e-58, -9.024334686134347e-58, 2.6259860002098117e-43, -9.757101493228268e-44, -5.3011291734444615e-43, 2.570954254787996e-29, -9.552625793286505e-30, -5.190035515253651e-29, -2.855929536156876e-29, 1.0634579156642156e-29, 5.771401376507686e-29, 9.675625224191222e-58, -3.5950708539699135e-58, -1.9532373418280634e-57, 5.683714194031795e-43, -2.1118382293446894e-43, -1.1473824736725549e-42, 5.564602853548141e-29, -2.0675812745094153e-29, -1.123337234974576e-28, -5.453833342204413e-29, 2.0255258917478217e-29, 1.100739621576774e-28, 2.6143772059284334e-58, -9.713967910639336e-59, -5.27769427393296e-58, 1.5357532448380574e-43, -5.706237686431813e-44, -3.1002550389729992e-43, 1.503569074170776e-29, -5.586654330065497e-30, -3.03528422571131e-29, -1.3288407683151228e-29, 4.923270905068543e-30, 2.678828495476447e-29, -1.189406785293094e-32, 6.434811264391097e-33, 2.9255607169716944e-32, -1.3348937195311997e-31, 7.221910324891549e-32, 3.2834120970903672e-31, -1.6124944125093378e-31, 8.723758210968892e-32, 3.966221117875324e-31, -3.841957954186232e-33, 2.0785381945523675e-33, 9.449989192935741e-33, 4.656249258159357e-32, -2.5190780434998977e-32, -1.145288566244629e-31, -1.465495581810726e-30, 7.928479637374202e-31, 3.604650955463095e-30, -2.582525529330967e-30, 1.397172487343882e-30, 6.352187773441551e-30, -7.941975316278764e-32, 4.2966891444219443e-32, 1.953472208815296e-31, 1.764502846978002e-30, -9.546139248723253e-31, -4.340113305164557e-30, 1.0571373306342213e-30, -5.719220108112232e-31, -2.6002201140845926e-30, -6.382179737883774e-30, 3.45282392672604e-30, 1.569812326672112e-29, -3.2073512524456367e-31, 1.7352095366607649e-31, 7.889059441823086e-31, 2.118996531416823e-30, -1.1463986012326763e-30, -5.212054520257938e-30, 6.1244219791154014e-30, -3.3133743666499015e-30, -1.506412152495234e-29, 1.8370841328357378e-31, -9.938811361911308e-32, -4.518640081132381e-31, -1.5449902756562231e-31, 8.358553988505696e-32, 3.8001825064831033e-31], [-6.485601398452303e-63, 2.3161021592891782e-63, 1.2846005284763687e-62, -3.8098111358271593e-48, 1.3605387158512205e-48, 7.546077993085748e-48, -3.729970437317416e-34, 1.3320264464629294e-34, 7.3879378342963685e-34, 4.1833541831804933e-33, -1.67668550495998e-33, -8.766999966039992e-33, -1.660992338812612e-58, 5.931644123866086e-59, 3.2899210191102324e-58, -9.757101493228242e-44, 3.4844022086005323e-44, 1.932585270749093e-43, -9.552625793286466e-30, 3.4113809757091076e-30, 1.8920848489580675e-29, 1.1630679649766497e-29, -4.253149973443974e-30, -2.329918999612087e-29, -3.5950708539699086e-58, 1.2838518521450342e-58, 7.120742757983618e-58, -2.1118382293446866e-43, 7.541680073372929e-44, 4.182909708450768e-43, -2.0675812745094136e-29, 7.383632080041116e-30, 4.0952501313702004e-29, 1.986807598588254e-29, -7.056437594626334e-30, -3.925064581646048e-29, -9.713967910639336e-59, 3.46899858176095e-59, 1.9240418189418323e-58, -5.706237686431815e-44, 2.0377800939348616e-44, 1.1302322633258635e-43, -5.586654330065512e-30, 1.9950751460234553e-30, 1.106546434773126e-29, 4.312526875658002e-30, -1.478957150843191e-30, -8.380950132250713e-30, 5.290727811767146e-33, -2.8623373719527885e-33, -1.30135002100912e-32, 5.937883838401555e-32, -3.2124553418094474e-32, -1.4605297291361903e-31, 7.172709236293788e-32, -3.8805083980188985e-32, -1.7642573285631812e-31, 1.7089824987709464e-33, -9.245768537488714e-34, -4.2035509854304164e-33, -2.0711961419148368e-32, 1.12053810601666e-32, 5.094480832675102e-32, 6.518827980956282e-31, -3.526752011268247e-31, -1.6034234290232402e-30, 1.1487608622699314e-30, -6.214912701044163e-31, -2.825584731319051e-30, 3.5327551688592345e-32, -1.911256353671245e-32, -8.689449120761876e-32, -7.848874247130149e-31, 4.246320522358238e-31, 1.930572320065953e-30, -4.702365872803996e-31, 2.5440275994516794e-31, 1.1566317801788625e-30, 2.8389257785003903e-30, -1.5358876209675322e-30, -6.982850475274869e-30, 1.4266962895489753e-31, -7.718571533617429e-32, -3.50921709154806e-31, -9.425735602342702e-31, 5.099418498287838e-31, 2.318429838112969e-30, -2.7242697869694067e-30, 1.4738575674184674e-30, 6.700833364782404e-30, -8.171730844595008e-32, 4.420989213998289e-32, 2.009984728876563e-31, 6.872436849525707e-32, -3.7180579932749323e-32, -1.6903999140955527e-31], [-3.5236910064460587e-62, 1.2846005284764585e-62, 7.048430528357495e-62, -2.0699078482954878e-47, 7.546077993086532e-48, 4.140431621876956e-47, -2.0265296117987e-33, 7.387937834297898e-34, 4.053662241181844e-33, 1.0643421500608184e-32, -3.818820550363228e-33, -2.1128502734389625e-32, -9.024334686134352e-58, 3.289921019110244e-58, 1.805135466858607e-57, -5.301129173444465e-43, 1.932585270749101e-43, 1.0603835759866443e-42, -5.190035515253658e-29, 1.892084848958079e-29, 1.0381615386267686e-28, 5.659974808739511e-29, -2.0600602188997564e-29, -1.1312825685909774e-28, -1.953237341828063e-57, 7.120742757983629e-58, 3.907055892268548e-57, -1.1473824736725552e-42, 4.182909708450773e-43, 2.295106364417761e-42, -1.1233372349745757e-28, 4.0952501313702043e-29, 2.2470087320798407e-28, 1.1050707573872597e-28, -4.029958329369545e-29, -2.210812712076244e-28, -5.27769427393296e-58, 1.9240418189418323e-58, 1.055695898751503e-57, -3.1002550389729996e-43, 1.1302322633258625e-43, 6.201432595087549e-43, -3.03528422571131e-29, 1.1065464347731228e-29, 6.071471635738907e-29, 2.7471480189099385e-29, -1.0035548641554843e-29, -5.500514052083874e-29, 2.63044845929391e-32, -1.423099278191325e-32, -6.470062871410847e-32, 2.9522020315334665e-31, -1.5971712220044675e-31, -7.261473869841806e-31, 3.5661335511550955e-31, -1.9293143968100886e-31, -8.77154927795643e-31, 8.496733418895722e-33, -4.596818900857811e-33, -2.0899249794322036e-32, -1.0297590226203e-31, 5.571100686744922e-32, 2.532878222804778e-31, 3.241036324108517e-30, -1.7534335018557093e-30, -7.971913956883727e-30, 5.711418821309188e-30, -3.0899354721571678e-30, -1.4048265697153797e-29, 1.75641815674591e-31, -9.502400255119175e-32, -4.320227549976045e-31, -3.902309834317332e-30, 2.111189173418196e-30, 9.598435537693583e-30, -2.337926180523371e-30, 1.2648417604276068e-30, 5.750551516513672e-30, 1.4114594826627194e-29, -7.636138863989712e-30, -3.47173941424733e-29, 7.093260493155022e-31, -3.8375258227038397e-31, -1.7447154758670693e-30, -4.686295076029011e-30, 2.5353331355059466e-30, 1.1526788775792905e-29, -1.354454721313873e-29, 7.32773732720085e-30, 3.331525912403688e-29, -4.062827946302885e-31, 2.198031098982685e-31, 9.993258813122896e-31, 3.4168438758507086e-31, -1.848547169299341e-31, -8.404344369660617e-31], [1.0253568350262688e-47, -3.8098111358275586e-48, -2.0699078482955126e-47, 6.0232130349729504e-33, -2.237982262390999e-33, -1.2159177670792952e-32, 5.896986952146643e-19, -2.191081757166272e-19, -1.190436261463244e-18, -3.659210223889808e-18, 1.3844963828468224e-18, 7.452415212498956e-18, 2.6259860002098157e-43, -9.757101493228288e-44, -5.301129173444469e-43, 1.5425725528728193e-28, -5.73157547597199e-29, -3.114021309152235e-28, 1.5102454726760487e-14, -5.6114611256158105e-15, -3.0487620016351014e-14, -1.6776473732390073e-14, 6.247028703534166e-15, 3.390271446345046e-14, 5.6837141940317966e-43, -2.1118382293446914e-43, -1.1473824736725556e-42, 3.338761712128926e-28, -1.240548764705665e-28, -6.740023409847537e-28, 3.268792609265738e-14, -1.2145510770572275e-14, -6.598775416751555e-14, -3.2037237140468297e-14, 1.1898466501701792e-14, 6.466031151606599e-14, 1.5357532448380574e-43, -5.706237686431815e-44, -3.1002550389729996e-43, 9.021414445024756e-29, -3.351992598039337e-29, -1.821170535426806e-28, 8.832356246297283e-15, -3.2817462207561567e-15, -1.7830049879839412e-14, -7.805956681328684e-15, 2.892057523501373e-15, 1.5736136105239677e-14, -6.986885158745049e-18, 3.779975688588386e-18, 1.718550541930874e-17, -7.841513292860705e-17, 4.2423381714892743e-17, 1.9287617604730208e-16, -9.472212046061735e-17, 5.124562725416017e-17, 2.3298615585041924e-16, -2.25686614054514e-18, 1.2209874571906049e-18, 5.551169714081771e-18, 2.7352020553031012e-17, -1.4797720353943355e-17, -6.727723252396898e-17, -8.608702638464134e-16, 4.657395383542528e-16, 2.1174658304118466e-15, -1.5170427406395177e-15, 8.207354991357602e-16, 3.731440498625027e-15, -4.665323096736314e-17, 2.5239870821406983e-17, 1.1475204406564055e-16, 1.0365149170622921e-15, -5.607650760440417e-16, -2.549495564854521e-15, 6.209899941291753e-16, -3.359618810575288e-16, -1.5274370004616355e-15, -3.749058559479736e-15, 2.0282786804059815e-15, 9.221486360141834e-15, -1.8840816398296093e-16, 1.0193072638324023e-16, 4.634238934238848e-16, 1.2447537377332296e-15, -6.734243886951513e-16, -3.0616965385132377e-15, 3.5976449403917686e-15, -1.946362377780433e-15, -8.849057228665909e-15, 1.0791510542722445e-16, -5.838316584262048e-17, -2.654366841601174e-16, -9.07567516922132e-17, 4.910032255824795e-17, 2.232326154800482e-16], [-3.8098111358273623e-48, 1.3605387158513038e-48, 7.546077993086172e-48, -2.2379822623908276e-33, 7.992158678779096e-34, 4.432762700578614e-33, -2.1910817571659395e-19, 7.82467018426702e-20, 4.339867053596507e-19, 2.4574111748517797e-18, -9.849287237419845e-19, -5.149964058288849e-18, -9.757101493228258e-44, 3.484402208600542e-44, 1.932585270749097e-43, -5.73157547597197e-29, 2.0468285854254996e-29, 1.1352509093748583e-28, -5.6114611256157845e-15, 2.0039340118724622e-15, 1.111459907050544e-14, 6.8321640700113346e-15, -2.4984110394199515e-15, -1.3686550876247405e-14, -2.1118382293446874e-43, 7.541680073372939e-44, 4.1829097084507695e-43, -1.2405487647056635e-28, 4.4301792480247236e-29, 2.4571500788221494e-28, -1.214551077057226e-14, 4.337337741432227e-15, 2.4056565607340414e-14, 1.1671025166076764e-14, -4.145135181094181e-15, -2.3056851374747105e-14, -5.706237686431813e-44, 2.037780093934861e-44, 1.1302322633258625e-43, -3.351992598039337e-29, 1.1970450876140853e-29, 6.639278608638815e-29, -3.281746220756163e-15, 1.1719590892444308e-15, 6.500141884320467e-15, 2.53329057785719e-15, -8.687779400131659e-16, -4.923188333819306e-15, 3.1079112784686563e-18, -1.6814115028350143e-18, -7.644468873515489e-18, 3.488067579390561e-17, -1.8870799148239905e-17, -8.57953192682768e-17, 4.213436170931653e-17, -2.2795116750425005e-17, -1.0363706931525313e-16, 1.0039008188670608e-18, -5.431205183502739e-19, -2.4692753023848444e-18, -1.2166745442963636e-17, 6.582332604405688e-18, 2.992630693001938e-17, 3.8293292955556726e-16, -2.0717059622316112e-16, -9.418926727129728e-16, 6.74812042337821e-16, -3.650801546682054e-16, -1.6598220447485388e-15, 2.0752323733128917e-17, -1.1227217481134658e-17, -5.104408672476225e-17, -4.610633104519946e-16, 2.4943992420245327e-16, 1.1340684497296625e-15, -2.7622921555460387e-16, 1.4944280542057489e-16, 6.794356244632635e-16, 1.6676589232417491e-15, -9.022203805398621e-16, -4.101908191099763e-15, 8.38078549302206e-17, -4.534089897734565e-17, -2.0614054938075502e-16, -5.536922523443874e-16, 2.995531206351538e-16, 1.3619060550013192e-15, -1.6003070083633062e-15, 8.65782311924731e-16, 3.936243997135508e-15, -4.8002874765247497e-17, 2.5970041795788916e-17, 1.1807173664333216e-16, 4.037048352345779e-17, -2.184084077354965e-17, -9.929849247688413e-17], [-2.0699078482955347e-47, 7.546077993086703e-48, 4.1404316218770466e-47, -1.215917767079314e-32, 4.432762700579077e-33, 2.4321973447092926e-32, -1.1904362614632807e-18, 4.339867053597409e-19, 2.3812267511572475e-18, 6.252222926619878e-18, -2.24327462707963e-18, -1.2411432657586016e-17, -5.30112917344447e-43, 1.9325852707491046e-43, 1.0603835759866454e-42, -3.114021309152237e-28, 1.1352509093748637e-28, 6.228969231760698e-28, -3.048762001635106e-14, 1.1114599070505518e-14, 6.098431198056333e-14, 3.3248165790737516e-14, -1.2101330131562155e-14, -6.645448375248282e-14, -1.1473824736725554e-42, 4.182909708450778e-43, 2.2951063644177617e-42, -6.740023409847536e-28, 2.4571500788221534e-28, 1.3482052392479204e-27, -6.598775416751554e-14, 2.4056565607340452e-14, 1.3199514376295122e-13, 6.491473371113804e-14, -2.3673024561478906e-14, -1.2986889529946655e-13, -3.1002550389729992e-43, 1.1302322633258635e-43, 6.201432595087549e-43, -1.821170535426806e-28, 6.639278608638815e-29, 3.6428829814433846e-28, -1.783004987983941e-14, 6.50014188432045e-15, 3.5665405299527e-14, 1.6137462775166463e-14, -5.895142581204066e-15, -3.231145178518811e-14, 1.5451939175339014e-17, -8.359655711704718e-18, -3.800683400445563e-17, 1.7342003438004031e-16, -9.382199635129743e-17, -4.2655788279625904e-16, 2.0948397041915696e-16, -1.133329512854918e-16, -5.152636442565153e-16, 4.991202451200635e-18, -2.70029111595557e-18, -1.2276763511221407e-17, -6.049072631157585e-17, 3.272609605678398e-17, 1.4878786200519574e-16, 1.9038691280281606e-15, -1.0300124955099452e-15, -4.6829098337805514e-15, 3.355036131574522e-15, -1.8151085531746665e-15, -8.25231706420474e-15, 1.0317657595079456e-16, -5.581957336706041e-17, -2.5378141544644823e-16, -2.2923184063976872e-15, 1.2401674923540951e-15, 5.638370962290803e-15, -1.3733587141858288e-15, 7.430009844710036e-16, 3.3780236956885546e-15, 8.291280521958679e-15, -4.485666801184321e-15, -2.039390130304122e-14, 4.166765910497548e-16, -2.25426259110698e-16, -1.0248913000411828e-15, -2.752851751063338e-15, 1.4893206996945065e-15, 6.771135865492028e-15, -7.956419710694757e-15, 4.304503708206565e-15, 1.9570250683925565e-14, -2.3866109250052106e-16, 1.2911807006513602e-16, 5.87030043482567e-16, 2.0071430616605578e-16, -1.0858847403695508e-16, -4.936930718021289e-16], [1.0038688391621753e-33, -3.7299704373184034e-34, -2.0265296117988587e-33, 5.896986952147121e-19, -2.1910817571664575e-19, -1.1904362614633414e-18, 5.773406139194735e-05, -2.145164127198291e-05, -0.00011654887616378448, -0.0003582525608865247, 0.00013554820421488362, 0.0007296237907395623, 2.570954254788007e-29, -9.552625793286575e-30, -5.190035515253675e-29, 1.5102454726760535e-14, -5.6114611256158405e-15, -3.0487620016351115e-14, 1.4785958582568912, -0.5493863963984117, -2.984870307501065, -1.6424895836908993, 0.6116112204654078, 3.319222874444365, 5.564602853548153e-29, -2.067581274509424e-29, -1.1233372349745777e-28, 3.268792609265743e-14, -1.2145510770572312e-14, -6.59877541675156e-14, 3.200289821095722, -1.1890982126211451, -6.4604875017355, -3.1365845488650095, 1.1649115065944253, 6.3305251054219385, 1.503569074170776e-29, -5.586654330065512e-30, -3.03528422571131e-29, 8.832356246297283e-15, -3.281746220756163e-15, -1.783004987983941e-14, 0.8647260065136336, -0.3212971968896021, -1.7456392607574032, -0.7642370348109002, 0.28314498228640406, 1.5406360152132048, -0.0006840463782044355, 0.0003700760239694751, 0.0016825355609254556, -0.007677181813858167, 0.004153433175717033, 0.018883414664679538, -0.009273706661090677, 0.0050171693001347505, 0.022810355753704603, -0.00022095698933878225, 0.00011953997080929455, 0.0005434836055610556, 0.002677881512401265, -0.0014487610406945823, -0.006586733028814325, -0.08428293477115156, 0.045597921986606046, 0.20730909401766007, -0.1485250678575894, 0.08035356713211902, 0.3653242182426634, -0.004567553773918309, 0.0024710928875253417, 0.011234723106391552, 0.10147930857055669, -0.054901334511180094, -0.24960667991002888, 0.06079761535132403, -0.03289212613785539, -0.14954271100240857, -0.3670491028578864, 0.19857728498434174, 0.9028235333768708, -0.0184459768936349, 0.00997946046428599, 0.0453712102986598, 0.12186679281354988, -0.06593117013020931, -0.2997533780428148, 0.3522250524556391, -0.19055732346303778, -0.8663611051651999, 0.01056535714325405, -0.005715965302902833, -0.025987403301607415, -0.008885479850052174, 0.004807134660371571, 0.02185544182375797], [-3.7299704373182037e-34, 1.3320264464632512e-34, 7.387937834298023e-34, -2.1910817571662856e-19, 7.824670184268432e-20, 4.339867053597236e-19, -2.1451641271979615e-05, 7.660691679600295e-06, 4.2489181837857244e-05, 0.00024059121850779027, -9.642879637458298e-05, -0.000504203830736536, -9.552625793286527e-30, 3.411380975709143e-30, 1.8920848489580798e-29, -5.61146112561581e-15, 2.0039340118724776e-15, 1.1114599070505492e-14, -0.549386396398408, 0.1961938362857332, 1.0881674833108643, 0.6688985121703593, -0.24460528317717017, -1.3399727266576937, -2.067581274509417e-29, 7.383632080041143e-30, 4.095250131370205e-29, -1.2145510770572269e-14, 4.337337741432239e-15, 2.405656560734042e-14, -1.1890982126211411, 0.42464418774117013, 2.3552421718484773, 1.1426440128037814, -0.4058267229777339, -2.257365809992302, -5.586654330065497e-30, 1.9950751460234553e-30, 1.1065464347731228e-29, -3.2817462207561567e-15, 1.1719590892444308e-15, 6.50014188432045e-15, -0.3212971968896021, 0.11473988081770849, 0.6363920993060961, 0.2480201413577958, -0.08505713058502028, -0.482001503166586, 0.0003042780016437331, -0.00016461748299182794, -0.0007484266776132396, 0.003414969532779592, -0.0018475331306998918, -0.008399734084494268, 0.0041251368629036484, -0.00223174085441476, -0.010146518842389892, 9.828624682101175e-05, -5.317385574042425e-05, -0.00024175276808033333, -0.0011911771792009046, 0.0006444389274875985, 0.0029299153204045145, 0.03749079562726763, -0.02028290043375507, -0.09221538021419695, 0.06606702744386247, -0.03574293148965348, -0.1625037813528414, 0.0020317425528606397, -0.0010991933144444469, -0.0049974376076761294, -0.04514009898142975, 0.024421251080205892, 0.11103022277424003, -0.02704403896175073, 0.01463109919141933, 0.06651969619902028, 0.16327104576722767, -0.08833129064359366, -0.40159461306401106, 0.008205152700749011, -0.004439070776935067, -0.020182054377763024, -0.05420887437687097, 0.029327550488480892, 0.13333651308298786, -0.15667700101180948, 0.08476384559495885, 0.3853753695377929, -0.004699689758814715, 0.002542579794658888, 0.011559735416301899, 0.003952445533761035, -0.0021383130949829254, -0.009721753341681271], [-2.026529611798881e-33, 7.387937834298561e-34, 4.0536622411821995e-33, -1.1904362614633602e-18, 4.339867053597698e-19, 2.3812267511574043e-18, -0.00011654887616378811, 4.248918183786617e-05, 0.0002331324328086136, 0.0006121197574470005, -0.00021962632118707268, -0.0012151331193877677, -5.190035515253677e-29, 1.892084848958092e-29, 1.038161538626773e-28, -3.048762001635114e-14, 1.1114599070505571e-14, 6.098431198056348e-14, -2.984870307501069, 1.0881674833108743, 5.970628798067513, 3.2551397188242395, -1.184772736330211, -6.506182353582052, -1.1233372349745777e-28, 4.095250131370222e-29, 2.2470087320798434e-28, -6.598775416751564e-14, 2.405656560734052e-14, 1.319951437629514e-13, -6.460487501735503, 2.3552421718484875, 12.922897397076747, 6.355434142441967, -2.317691838995807, -12.71472844516704, -3.03528422571131e-29, 1.106546434773126e-29, 6.071471635738907e-29, -1.7830049879839412e-14, 6.500141884320467e-15, 3.5665405299527e-14, -1.7456392607574032, 0.6363920993060961, 3.4917979568905286, 1.5799276378465983, -0.5771600420001327, -3.1634313525993485, 0.0015128119024392823, -0.0008184465727864837, -0.003721033988260767, 0.01697857396114158, -0.009185580604496755, -0.04176186786985091, 0.02050938980695193, -0.011095787764741941, -0.05044654687546, 0.0004886603804208139, -0.0002643702187741114, -0.001201948425531551, -0.005922304619047353, 0.00320402682623088, 0.014566977388779111, 0.18639704990325312, -0.10084269328185765, -0.4584771952700718, 0.3284725972168102, -0.17770700442857099, -0.8079376533759763, 0.010101434543594629, -0.005464978474258007, -0.024846301913873013, -0.22442792001884673, 0.12141777948788683, 0.5520209861901952, -0.13445777811854784, 0.0727430207999882, 0.33072317950329083, 0.811752344980796, -0.4391662463982937, -1.996651441500115, 0.04079444652577493, -0.022070209055009657, -0.10034130602088354, -0.2695161330498874, 0.14581095974302635, 0.6629235861022673, -0.7789680183540753, 0.4214295933976873, 1.9160124714711442, -0.02336595667941654, 0.01264121939635071, 0.05747278880615918, 0.01965080161863823, -0.010631282852381565, -0.04833469422181346], [-8.872102136415473e-34, 2.879289966049653e-34, 1.834153375541272e-33, -5.211703809854648e-19, 1.6913698980250902e-19, 1.0774294511253553e-18, -5.102484203483586e-05, 1.6559245309762417e-05, 0.00010548501901316672, 0.00030638808254897145, -0.00010173717100517308, -0.0006361671384150436, -2.2721861508887976e-29, 7.373993992244927e-30, 4.697351128776115e-29, -1.3347413090164028e-14, 4.331676077700809e-15, 2.759346364328384e-14, -1.306769665635249, 0.4240898862917957, 2.7015198387337307, 1.4460370747869362, -0.4705433578432664, -2.990937860307336, -4.9179457454294404e-29, 1.5960357106655923e-29, 1.0167000617232116e-28, -2.888929386070974e-14, 9.375529345856739e-15, 5.972360894509793e-14, -2.8283872405670967, 0.9179050101826234, 5.847200499790404, 2.774254184592074, -0.8998486078193759, -5.734704101261441, -1.3288407683151228e-29, 4.312526875658002e-30, 2.7471480189099385e-29, -7.805956681328684e-15, 2.53329057785719e-15, 1.6137462775166463e-14, -0.7642370348109002, 0.2480201413577958, 1.5799276378465983, 0.678847318393771, -0.2195378942438939, -1.402475332682657, 0.0006133496235916276, -0.000331828363155409, -0.0015086441297767323, 0.006883738772412759, -0.003724172448110919, -0.01693179826067927, 0.00831526146634929, -0.0044986407351658205, -0.020452886765149333, 0.00019812090314200653, -0.00010718541671471646, -0.0004873141288666683, -0.0024011202602456, 0.0012990303980802143, 0.005905988764279975, 0.07557222428803484, -0.04088533932517482, -0.185883529003719, 0.13317488019379253, -0.07204896001949214, -0.3275676604504683, 0.004095493342602053, -0.0022157034094706482, -0.010073605252540372, -0.09099133874149057, 0.04922723652963563, 0.22380962467871943, -0.054514131905627206, 0.02949269790556888, 0.13408734908437248, 0.3291142768250233, -0.1780541596005538, -0.80951598021746, 0.01653957004229551, -0.008948075034742802, -0.040682058476249554, -0.10927175975511216, 0.05911712958479226, 0.2687736204019963, -0.31582230419856444, 0.17086306768479337, 0.7768219738877, -0.009473418811069681, 0.00512521559751681, 0.02330158384144102, 0.007967158214865546, -0.004310313347806351, -0.019596663973600353], [3.28705766383066e-34, -9.874365093643877e-35, -6.700307114728798e-34, 1.9309032613007208e-19, -5.800459168206717e-20, -3.935934864151121e-19, 1.890438088713234e-05, -5.678901249675638e-06, -3.853451040770065e-05, -0.0002091253208754543, 7.765445455615944e-05, 0.00044406518848325163, 8.418305815341812e-30, -2.5288703026207402e-30, -1.715979459963732e-29, 4.94513203474746e-15, -1.4855242633762116e-15, -1.0080110160610441e-14, 0.4841498867170877, -0.1454392721519732, -0.9868865296342962, -0.5878906499735146, 0.18469256801033979, 1.2080507299060264, 1.822067758492839e-29, -5.4735158651731534e-30, -3.71408560917066e-29, 1.0703300449815743e-14, -3.215285740539141e-15, -2.1817505954977755e-14, 1.047899563422253, -0.31479042745611846, -2.1360285149780305, -1.007575667268367, 0.29953272377045936, 2.0500622856505024, 4.9232709050685445e-30, -1.4789571508431902e-30, -1.0035548641554843e-29, 2.892057523501373e-15, -8.687779400131659e-16, -5.895142581204066e-15, 0.28314498228640406, -0.08505713058502022, -0.5771600420001327, -0.2195378942438939, 0.06098956285901187, 0.4415565403778925, -0.0002728306204402127, 0.00014760413101619173, 0.0006710761662169369, -0.0030620296287589637, 0.0016565890652945985, 0.007531614672849858, -0.003698800582450766, 0.0020010886054282395, 0.009097867792357899, -8.812828254444011e-05, 4.76782941076513e-05, 0.000216767421082656, 0.0010680680400817228, -0.0005778356354138623, -0.0026271061673370636, -0.03361609112893064, 0.018186646026904552, 0.08268484498405293, -0.05923894593357568, 0.03204887018448388, 0.14570888217639752, -0.001821760292486681, 0.0009855907832428375, 0.004480948329317426, 0.04047483270333797, -0.021897294737527787, -0.09955515812338993, 0.024249015338883614, -0.0131189630816331, -0.059644831001363814, -0.14639684918383108, 0.07920217925840571, 0.36008948019840503, -0.007357143434815726, 0.003980289168808387, 0.018096222493567845, 0.048606342718538316, -0.026296524075153108, -0.1195560750210263, 0.14048430436589274, -0.07600343258349818, -0.3455465088024308, 0.004213972965009911, -0.0022798020860796604, -0.010365027273470344, -0.0035439570439100144, 0.001917316681613742, 0.008717002154770266], [1.788539348318021e-33, -5.595602373624726e-34, -3.6724582535764316e-33, 1.0506345838202958e-18, -3.2870025345350935e-19, -2.1572976029139175e-18, 0.00010286168522163585, -3.2181181281949917e-05, -0.00021120879740455615, -0.000516039771330946, 0.00015313434980802548, 0.0010496306458047478, 4.5805315077332355e-29, -1.4330594963559874e-29, -9.405334446324252e-29, 2.6907234771373057e-14, -8.418164626680664e-15, -5.5249383531861346e-14, 2.634335054128772, -0.8241748494752538, -5.409154414924669, -2.859669920082246, 0.8901390594194883, 5.866404402698079, 9.91415489063274e-29, -3.1017303975267903e-29, -2.0357013665692854e-28, 5.823832731019121e-14, -1.822037199457208e-14, -1.1958239890329076e-13, 5.701784982018532, -1.783853489680542, -11.70763580741128, -5.614197620509599, 1.7582132893565074, 11.529903347724662, 2.678828495476447e-29, -8.380950132250713e-30, -5.500514052083874e-29, 1.5736136105239677e-14, -4.923188333819306e-15, -3.231145178518811e-14, 1.5406360152132048, -0.482001503166586, -3.1634313525993485, -1.402475332682657, 0.4415565403778925, 2.8830754026643666, -0.0013564615506943874, 0.0007338594477557785, 0.003336462071566298, -0.015223824407234137, 0.00823624331003308, 0.037445744549795865, -0.018389727537492222, 0.009949028992480277, 0.045232854852297145, -0.00043815692904037706, 0.00023704733968414726, 0.0010777260692636848, 0.005310229575986516, -0.002872888024061531, -0.013061468319923171, -0.16713276181192246, 0.0904205181653753, 0.4110932008475625, -0.2945246847032988, 0.15934083966933132, 0.7244366337914553, -0.00905744299284568, 0.004900168463607781, 0.022278416218678453, 0.2012331102875489, -0.10886915232518037, -0.4949691642008023, 0.12056145639489205, -0.06522496989707971, -0.29654266746332497, -0.7278570738880404, 0.39377805439098346, 1.7902958762860024, -0.03657830699563317, 0.019789234835233767, 0.08997094968933228, 0.24166141949605544, -0.13074127738045127, -0.5944098893895745, 0.6984610343256549, -0.3778744990352003, -1.7179910099932902, 0.0209510658791841, -0.011334738996562111, -0.0515329289127289, -0.017619875143119867, 0.009532531044050892, 0.04333926390369049], [-7.941160997224554e-37, 3.5323929428722097e-37, 1.7562380649280383e-36, -4.664844744520229e-22, 2.075019592336294e-22, 1.0316599688848087e-21, -4.567085446339258e-08, 2.0315342310502952e-08, 1.010039880748316e-07, 2.570938818402338e-07, -1.1436068531861603e-07, -5.685794076026621e-07, -2.0337678446927722e-32, 9.046620745435103e-33, 4.4978064357648007e-32, -1.1946881879369183e-17, 5.314220584969998e-18, 2.6421286158384482e-17, -0.001169651582177504, 0.0005202852575268468, 0.002586758576033628, 0.0012849553244017073, -0.0005715747510230603, -0.002841760106909997, -4.401910431099851e-32, 1.9580609620441116e-32, 9.735103796791523e-32, -2.5857968057242705e-17, 1.1502159937865859e-17, 5.71865345630126e-17, -0.0025316072892859563, 0.0011261113741332055, 0.005598809907578004, 0.002486788878647229, -0.0011061752164975246, -0.005499691153027102, -1.189406785293094e-32, 5.290727811767146e-33, 2.63044845929391e-32, -6.986885158745049e-18, 3.1079112784686563e-18, 1.5451939175339014e-17, -0.0006840463782044355, 0.0003042780016437331, 0.0015128119024392823, 0.0006133496235916276, -0.0002728306204402127, -0.0013564615506943874, -3.13015198141528e-07, 5.124373955290457e-07, 9.048316558192547e-08, 8.726446452299272e-07, 3.378488006402625e-06, -9.771845784468495e-06, 2.845975803791774e-06, 3.1116551505250363e-06, -1.6211370368004214e-05, 1.0726955639321305e-07, 5.279014218863327e-08, -4.833160358697402e-07, -1.0582403411031615e-05, 4.382058688368897e-06, 2.8689157683221805e-05, 2.2542862674948536e-06, 4.1053689621374974e-05, -8.925948466781884e-05, 5.2169392341383606e-05, 4.627064907347151e-05, -0.00027584368263544693, 2.3319183183477712e-06, 1.0293288481450725e-06, -1.0272531328973868e-05, -6.490318852821619e-05, -1.578507960032333e-05, 0.00026043619801446877, -7.598927908364779e-05, 1.0617078336083461e-05, 0.00024729704054509343, 0.00017477271349153334, 8.954478693019223e-05, -0.0007944593309471981, 1.0034527073532422e-05, 3.823056103106435e-06, -4.300333658000154e-05, -4.910767858158167e-05, -3.455623762682382e-05, 0.0002418343121570425, -0.00010510313533907046, -0.00011980152565305675, 0.0006083703258791711, 5.5279538444549544e-05, -3.520599282040819e-05, -0.000125475883983173, 5.330434199432387e-06, 1.5728174052242023e-06, -2.1936735113625108e-05], [4.296248589559858e-37, -1.911060385740822e-37, -9.501425940130778e-37, 2.523728288743324e-22, -1.1226066314484254e-22, -5.581384998712164e-22, 2.47083951755821e-08, -1.0990806102335463e-08, -5.4644181305237095e-08, -1.390903959290853e-07, 6.18702898950066e-08, 3.076072225231883e-07, 1.1002890178535994e-32, -4.8943135180664915e-33, -2.4333588706388694e-32, 6.463384188006874e-18, -2.875047200373706e-18, -1.429418361269712e-17, 0.0006327933613186838, -0.000281479597832072, -0.0013994626085153637, -0.0006951738545582544, 0.00030922773367384127, 0.0015374210213653361, 2.3814781601319032e-32, -1.0593308269904548e-32, -5.266789827180446e-32, 1.3989422810296847e-17, -6.222785110038584e-18, -3.0938494830167415e-17, 0.0013696252033821709, -0.0006092376674516491, -0.0030290129084465886, -0.0013453779889559376, 0.0005984520041017341, 0.0029753886575861572, 6.434811264391097e-33, -2.8623373719527885e-33, -1.423099278191325e-32, 3.779975688588386e-18, -1.6814115028350143e-18, -8.359655711704718e-18, 0.0003700760239694751, -0.00016461748299182794, -0.0008184465727864837, -0.000331828363155409, 0.00014760413101619173, 0.0007338594477557785, 5.12437395529046e-07, -4.628506158350032e-07, -8.928514848591167e-07, 7.829114640908239e-07, -2.5067753704143496e-06, 2.1997167384870052e-06, -1.084167101409229e-06, -1.929885840967173e-06, 7.650045961590148e-06, -7.05344010015026e-08, -2.1797113594554845e-08, 2.922260706995136e-07, 1.1370269211403911e-05, -5.4247845858768e-06, -2.9406222677459665e-05, 1.6894202727397296e-05, -3.2010208591150964e-05, 3.736138320866507e-06, -2.4828056674411244e-05, -2.687022188972302e-05, 0.00014088087427761286, -1.587747720498882e-06, -3.804234896148387e-07, 6.3597838085914156e-06, 5.010904312548252e-05, 4.270297496313244e-07, -0.00017778340252578027, 7.205495838530406e-05, -2.2484958244685156e-05, -0.00020990253088580852, -0.00011329456842426954, -3.8305696786001666e-05, 0.00047590683054438794, -7.111187462301038e-06, -1.1581130743252826e-06, 2.7403423746238333e-05, 2.75109124862631e-05, 1.8185015352095483e-05, -0.00013315468789913237, 3.7790609452328043e-05, 7.513158033615577e-05, -0.0002822253251428149, -6.506083742921955e-05, 3.806549460549308e-05, 0.00015435144971366182, -3.988245034687656e-06, -2.5340444118678945e-07, 1.4584531433719626e-05], [1.9532719123426722e-36, -8.688558160552623e-37, -4.319784581637265e-36, 1.147402781292968e-21, -5.103885299250048e-22, -2.5375539433280553e-21, 1.1233571170161751e-07, -4.996925202574384e-08, -2.4843754333921107e-07, -6.323688166115572e-07, 2.812907515502864e-07, 1.3985237009989704e-06, 5.002419178571598e-32, -2.2251796947386888e-32, -1.1063166936426568e-31, 2.9385512802477185e-17, -1.307128492703146e-17, -6.498792325099275e-17, 0.002876969228420092, -0.0012797355201441547, -0.0063625997160162324, -0.003160579598683648, 0.0014058912889032189, 0.00698982201769136, 1.0827293400449406e-31, -4.816204433019486e-32, -2.394524530690067e-31, 6.360234068307982e-17, -2.829163889985194e-17, -1.4066060588015473e-16, 0.006226945169569643, -0.002769874226240678, -0.013771283744077389, -0.006116706197350012, 0.0027208376473784415, 0.013527483272939313, 2.9255607169716944e-32, -1.30135002100912e-32, -6.470062871410847e-32, 1.718550541930874e-17, -7.644468873515489e-18, -3.800683400445563e-17, 0.0016825355609254556, -0.0007484266776132396, -0.003721033988260767, -0.0015086441297767323, 0.0006710761662169369, 0.003336462071566298, 9.048316558192591e-08, -8.928514848591158e-07, 1.4486314544008538e-06, -6.5718682194610914e-06, -5.915792654552891e-06, 3.4920790365453306e-05, -1.1038516917498838e-05, -5.468902504005786e-06, 4.9807783074284974e-05, -3.3127437383817897e-07, -9.336898779199162e-08, 1.3546483189302544e-06, 2.0073685733647405e-05, -7.55639963594067e-06, -5.591717630523806e-05, -5.947426555270035e-05, -7.180258674576908e-05, 0.00035219901440613295, -0.0001881890673368948, -8.14212635803608e-05, 0.0008257460206868797, -7.0460472823473e-06, -1.8229490559218818e-06, 2.8489998799986706e-05, 0.0001791980950531066, 2.8245725573482337e-05, -0.0006886937834951469, 0.00017155285246423806, -1.7806599789198087e-05, -0.0005704996373277224, -0.000544387188649008, -0.00015830474704642936, 0.002235754854517296, -2.952296583028501e-05, -6.784339517261772e-06, 0.00011768236117867467, 0.00016531432338070496, 6.090876256391465e-05, -0.0007043527266951224, 0.0004140815855788417, 0.0002105131596863958, -0.001879028117336647, -8.866909697550146e-05, 6.100522474171162e-05, 0.00019228546748688348, -1.5080734238585018e-05, -2.8030715634122613e-06, 5.8801870870954386e-05], [-8.912515105897072e-36, 3.964471375698837e-36, 1.9710591799729477e-35, -5.235443440415299e-21, 2.3288337143892636e-21, 1.1578514854501395e-20, -5.125726332037277e-07, 2.2800292713761684e-07, 1.1335868518311181e-06, 2.8854132365980634e-06, -1.283491589931413e-06, -6.3812741750630966e-06, -2.282536098191073e-31, 1.0153193478786266e-31, 5.047973188827835e-31, -1.3408211375573373e-16, 5.964250221871555e-17, 2.9653108920236165e-16, -0.013127220816246898, 0.005839259799296634, 0.029031680496423753, 0.014421296512104016, -0.00641489148050619, -0.03189361088261896, -4.940347289986311e-31, 2.197568832641062e-31, 1.092589102232087e-30, -2.9020886366429987e-16, 1.290909153365636e-16, 6.418152878714929e-16, -0.028412707179524526, 0.012638560830579395, 0.06283650198475398, 0.02790970168450993, -0.012414813564727898, -0.061724073465144094, -1.3348937195311997e-31, 5.937883838401555e-32, 2.9522020315334665e-31, -7.841513292860705e-17, 3.488067579390561e-17, 1.7342003438004031e-16, -0.007677181813858167, 0.003414969532779592, 0.01697857396114158, 0.006883738772412759, -0.0030620296287589637, -0.015223824407234137, 8.726446452299237e-07, 7.829114640908239e-07, -6.5718682194610914e-06, 3.650144454479426e-05, -5.662312842526524e-06, -0.00013944945547242826, 5.500412412656699e-05, -1.274330316316675e-05, -0.00019528886107039582, 1.5508440668058231e-06, -4.3363219227439173e-07, -5.2440632157242695e-06, -7.532247920485627e-05, 3.583711090480251e-05, 0.00020259380257620465, 0.0003561133628483366, -3.802689396413774e-05, -0.001421193938528537, 0.0009210560760021356, -0.00022580147628541627, -0.003226387306804498, 3.275568955144584e-05, -9.341061317703698e-06, -0.00011011834200295961, -0.0008074859745332378, 0.00025067383543703474, 0.002642678384083315, -0.0007097347387335536, 0.0002724281983340457, 0.0021390511718534567, 0.002555395235793208, -0.0007090691056482008, -0.008660081768221434, 0.00013604131350611852, -3.9756864083530066e-05, -0.00045395450254940976, -0.0007941162570801412, 0.00020603573051012817, 0.002741690072871397, -0.0020709057362829565, 0.00047415308639402784, 0.007372488115399004, 0.0002937177399997472, -0.0001782885532587732, -0.0006540991812518365, 6.855671075035344e-05, -2.078767028840253e-05, -0.00022611225944669532], [4.8217610078077526e-36, -2.14481919736287e-36, -1.0663629946373568e-35, 2.8324279666998075e-21, -1.2599226440895894e-21, -6.264093893856949e-21, 2.7730698989960545e-07, -1.233518945747175e-07, -6.132819766562034e-07, -1.5610378069861955e-06, 6.943819593736951e-07, 3.4523340080614455e-06, 1.2348751644627468e-31, -5.492980582815177e-32, -2.731004660429027e-31, 7.253978257204501e-17, -3.226719822511246e-17, -1.6042632483984952e-16, 0.007101959516543291, -0.0031590987370196323, -0.01570643340802496, -0.007802067584501229, 0.003470521311044621, 0.01725476675492561, 2.6727779582806126e-31, -1.1889070125885346e-31, -5.911017785779218e-31, 1.5700593674291128e-16, -6.983949363745882e-17, -3.472285760532445e-16, 0.015371562569789478, -0.006837589511334722, -0.03399518447229885, -0.015099431498620842, 0.00671653997265035, 0.033393349367831074, 7.221910324891549e-32, -3.2124553418094474e-32, -1.5971712220044675e-31, 4.2423381714892743e-17, -1.8870799148239905e-17, -9.382199635129743e-17, 0.004153433175717033, -0.0018475331306998918, -0.009185580604496755, -0.003724172448110919, 0.0016565890652945985, 0.00823624331003308, 3.378488006402632e-06, -2.5067753704143496e-06, -5.915792654552891e-06, -5.662312842526524e-06, -4.556942323949786e-06, 4.079813560353849e-05, -2.4645237120180186e-05, 4.128313970115434e-06, 9.307800973784927e-05, -9.793176511666752e-07, 3.1050058619412136e-07, 3.1821729512050244e-06, 0.00010410604381657181, -5.366438053972472e-05, -0.000265440375641868, 1.0633600492363457e-05, -8.941147124142174e-05, 0.0002688407047007036, -0.00046018545051377434, 0.00010154016578534782, 0.0016517569647954587, -2.1381673576418157e-05, 7.03398377068178e-06, 6.857883302114476e-05, 0.0006051583492085069, -0.000226669228195001, -0.0018436806463443497, 0.0007312639164403989, -0.00033527395056138864, -0.0020114713810797393, -0.0015928258041257258, 0.0004974048196069856, 0.005202539278122639, -9.248169689116546e-05, 3.1724202182253446e-05, 0.00029203759472429817, 0.0004402102141073481, -0.00011719415691467504, -0.001509318501275173, 0.0009063407264276696, -0.00014072367163757822, -0.003462120117781785, -0.0005534447874341826, 0.000309906330945278, 0.001324317906709048, -4.9485058344120806e-05, 1.795225993729841e-05, 0.00015281721441158384], [2.1921939916295428e-35, -9.751333071002447e-36, -4.848175896637691e-35, 1.287751831803433e-20, -5.7281869545561844e-21, -2.8479447601987045e-20, 1.2607649282293652e-06, -5.608143616096828e-07, -2.7882615132177087e-06, -7.097194771039839e-06, 3.156979279499902e-06, 1.569589587147864e-05, 5.614309609215934e-31, -2.4973612359232235e-31, -1.2416401389472384e-30, 3.2979916518270295e-16, -1.4670150171539004e-16, -7.293717478814317e-16, 0.032288769509214964, -0.014362713662176254, -0.0714086593907241, -0.035471782308031705, 0.015778583703287604, 0.07844809385174167, 1.2151676061121461e-30, -5.405317280102594e-31, -2.6874201465850044e-30, 7.138210927929534e-16, -3.175224115889885e-16, -1.578660570097575e-15, 0.06988618277198863, -0.03108682205465044, -0.15455772076599533, -0.0686489499473306, 0.03053647526026617, 0.1518215019906773, 3.2834120970903672e-31, -1.4605297291361903e-31, -7.261473869841806e-31, 1.9287617604730208e-16, -8.57953192682768e-17, -4.2655788279625904e-16, 0.018883414664679538, -0.008399734084494268, -0.04176186786985091, -0.01693179826067927, 0.007531614672849858, 0.037445744549795865, -9.771845784468495e-06, 2.199716738487007e-06, 3.4920790365453306e-05, -0.00013944945547242826, 4.079813560353849e-05, 0.00046516744866200756, -0.0001806154653828541, 5.5864598671399874e-05, 0.0005918280452430853, -4.571310477540402e-06, 1.4759949999505951e-06, 1.4760033069025567e-05, 0.00011842789564052162, -5.1986001530130725e-05, -0.00033390768906247026, -0.001481185423281394, 0.0004209859770107916, 0.0049844300850116945, -0.0029374251256083328, 0.0009189157969776643, 0.009588594102756124, -9.527397564783679e-05, 3.093182077140552e-05, 0.00030702663583219436, 0.002205649279867053, -0.0007353248131400414, -0.007040024156134454, 0.001573371840102118, -0.000576843844787656, -0.0048374593408603145, -0.007570535163853415, 0.0024393243735572477, 0.024461918953979703, -0.00038895226533820125, 0.0001271844806197478, 0.0012502275683036732, 0.002452986163896757, -0.000777132341374516, -0.007972818168081467, 0.006839662082555699, -0.0021108123081015526, -0.02242831081689673, -0.00019158477908947874, 0.00015132844071692354, 0.0003031117272497457, -0.00019073245212619192, 6.308997326674728e-05, 0.0006105347805627315], [-1.0765936343390073e-35, 4.788911542795052e-36, 2.380955028800201e-35, -6.324191335354485e-21, 2.8131313356053926e-21, 1.3986349800639313e-20, -6.191657769852078e-07, 2.754177659733816e-07, 1.369324342400583e-06, 3.4854555487974303e-06, -1.5504028425528581e-06, -7.708305763542759e-06, -2.757205799107774e-31, 1.2264622654317946e-31, 6.097735304605709e-31, -1.6196544794928807e-16, 7.204558697716369e-17, 3.581968492907727e-16, -0.015857120239810712, 0.007053575623131209, 0.03506902602154724, 0.017420308228789008, -0.007748914028004176, -0.03852611529330675, -5.967727830614296e-31, 2.654568983201781e-31, 1.319800817653526e-30, -3.505598717504718e-16, 1.559362941336092e-16, 7.752853657288225e-16, -0.0343213327779661, 0.015266839916383565, 0.07590380183047936, 0.03371372369395799, -0.014996562806887175, -0.07456003584675977, -1.6124944125093378e-31, 7.172709236293788e-32, 3.5661335511550955e-31, -9.472212046061735e-17, 4.213436170931653e-17, 2.0948397041915696e-16, -0.009273706661090677, 0.0041251368629036484, 0.02050938980695193, 0.00831526146634929, -0.003698800582450766, -0.018389727537492222, 2.845975803791774e-06, -1.0841671014092327e-06, -1.1038516917498838e-05, 5.500412412656702e-05, -2.46452371201802e-05, -0.0001806154653828541, 7.58655769492467e-05, -3.486830289855372e-05, -0.00024135319423230434, 2.0151017639939908e-06, -9.430461200077909e-07, -6.260944852477573e-06, -7.323562403777661e-05, 3.783790332270796e-05, 0.0001959453387847998, 0.0005653302770517913, -0.00024972193262877103, -0.0018881033096692123, 0.0012496918753377617, -0.000577187011716561, -0.003950673075866571, 4.2257552991132634e-05, -1.9820042316438402e-05, -0.00013090502042012586, -0.0010077122034241087, 0.00047760326517265277, 0.003077741769365593, -0.0007988596733146411, 0.0003917035444257413, 0.002323863450847764, 0.003329453305841109, -0.0015568348711753758, -0.0103562968997498, 0.0001739015916171996, -8.179858801344717e-05, -0.0005366397440221724, -0.0010585294904739205, 0.0004915190671545163, 0.0033230952981821256, -0.002865730088563931, 0.001315827856089947, 0.009128170894004467, 0.00022132039035378256, -0.00012677248088228824, -0.00048200397673055543, 8.638130797799811e-05, -4.0815956192535566e-05, -0.00026492660334118085], [5.8244806832081764e-36, -2.590849684126897e-36, -1.288120803477398e-35, 3.421451613198537e-21, -1.5219325659138875e-21, -7.566757005063653e-21, 3.349749610927325e-07, -1.4900380297243866e-07, -7.408183484435787e-07, -1.885666779798072e-06, 8.387836524023727e-07, 4.170271547962685e-06, 1.491676283818329e-31, -6.635285167812741e-32, -3.2989366052492226e-31, 8.762494899080304e-17, -3.897739279468453e-17, -1.9378812607981483e-16, 0.008578862774420225, -0.0038160559057828407, -0.01897269853047524, -0.009424563320626515, 0.004192241030633773, 0.020843018866880735, 3.228601244089431e-31, -1.4361487261064091e-31, -7.1402561959461856e-31, 1.8965644382359499e-16, -8.436311566619187e-17, -4.194372410007759e-16, 0.018568188907224736, -0.008259515136479737, -0.041064726136442686, -0.018239466234169, 0.008113292480766044, 0.04033773511910007, 8.723758210968892e-32, -3.8805083980188985e-32, -1.9293143968100886e-31, 5.124562725416017e-17, -2.2795116750425005e-17, -1.133329512854918e-16, 0.0050171693001347505, -0.00223174085441476, -0.011095787764741941, -0.0044986407351658205, 0.0020010886054282395, 0.009949028992480277, 3.1116551505250363e-06, -1.929885840967168e-06, -5.468902504005786e-06, -1.274330316316675e-05, 4.128313970115441e-06, 5.586459867139991e-05, -3.486830289855372e-05, 1.5522965624686156e-05, 0.00011538416908102921, -1.2596611799965075e-06, 6.018828764172757e-07, 3.8040784092585137e-06, 0.00011615232957464669, -6.18747979551674e-05, -0.0002942505073525334, -6.0278317746888454e-05, 2.245646735568894e-06, 0.000417456592705451, -0.0006300544159663627, 0.00028735507554892865, 0.0020241066601481834, -2.728350796493161e-05, 1.3115051827192107e-05, 8.169701924575005e-05, 0.0007484820092779388, -0.00036837529380487143, -0.002165141298769716, 0.0008517028955312603, -0.00043887567776766, -0.002289098480817095, -0.0020553389177189376, 0.000979718394814044, 0.006227794919305534, -0.00011689113121284144, 5.6593553059198283e-05, 0.000346429428708317, 0.0005854617359957351, -0.00027283445183105386, -0.0018292790730938307, 0.0012918375533229726, -0.0005719972406421381, -0.0043024789545467075, -0.0005963246079748526, 0.0003264241538433871, 0.0014330233457999551, -6.17060130265454e-05, 3.018230954232156e-05, 0.00018015640500901136], [2.6480764055737694e-35, -1.1779192501580615e-35, -5.856388737027094e-35, 1.5555490321813348e-20, -6.919404386196786e-21, -3.440195234844928e-20, 1.5229500090625543e-06, -6.774397177238863e-07, -3.368100429940858e-06, -8.57310716602315e-06, 3.8134956919185396e-06, 1.89599696378646e-05, 6.781845432711683e-31, -3.0167053601524497e-31, -1.4998480831139641e-30, 3.983832595257956e-16, -1.7720912785916106e-16, -8.810498175944781e-16, 0.03900344998154297, -0.017349542656372827, -0.08625860065680968, -0.042848393049250415, 0.019059852995485977, 0.09476193584337633, 1.4678703978068916e-30, -6.529391654540546e-31, -3.2462883801380116e-30, 8.622652925988571e-16, -3.835534672479724e-16, -1.906954322494772e-15, 0.08441951414005745, -0.037551548960317274, -0.18669910383043115, -0.08292498990374982, 0.03688675361526259, 0.18339386879782274, 3.966221117875324e-31, -1.7642573285631812e-31, -8.77154927795643e-31, 2.3298615585041924e-16, -1.0363706931525313e-16, -5.152636442565153e-16, 0.022810355753704603, -0.010146518842389892, -0.05044654687546, -0.020452886765149333, 0.009097867792357899, 0.045232854852297145, -1.6211370368004214e-05, 7.650045961590148e-06, 4.9807783074284974e-05, -0.00019528886107039582, 9.307800973784927e-05, 0.0005918280452430853, -0.00024135319423230434, 0.00011538416908102921, 0.0007283146175957421, -5.870603411109413e-06, 2.814127833180433e-06, 1.7648310352896154e-05, 9.939476401368369e-05, -4.938719798849443e-05, -0.00028336470160789616, -0.002121660404816939, 0.0010097841203136337, 0.006442473563049647, -0.0038854950682980214, 0.0018588077722977165, 0.011713798996868663, -0.00012170362633944504, 5.836123061166512e-05, 0.00036567717843644456, 0.002743786715509906, -0.00131819305573955, -0.008222412913968658, 0.0017567495247276842, -0.0008508326489938119, -0.005203880648113704, -0.009741712147961268, 0.004669137639798232, 0.029291394805821235, -0.0004933756178804337, 0.00023670665254750097, 0.001481399179617919, 0.0032072773179421467, -0.001535551418000637, -0.009658496999038877, 0.00915774753309817, -0.004377488696803752, -0.027639769382036144, 9.688716664502811e-05, -3.511085707257213e-05, -0.00039173031052284487, -0.00023917212755869343, 0.00011484010641642745, 0.0007173124752282169], [-2.5651111996340394e-37, 1.1410146076167668e-37, 5.672905927917855e-37, -1.5068131099350469e-22, 6.70261690654825e-23, 3.3324126551840723e-22, -1.475235426178224e-08, 6.562152826681549e-09, 3.2625766069848536e-08, 8.304508571180728e-08, -3.69401747189273e-08, -1.836594682858858e-07, -6.569367725576026e-33, 2.922190873735919e-33, 1.4528572920507058e-32, -3.859017657516999e-18, 1.716571008269011e-18, 8.534462033611307e-18, -0.0003778145757480289, 0.00016805975115641604, 0.0008355608703125793, 0.0004150593716465621, -0.00018462700803946827, -0.0009179300960471301, -1.421881479363847e-32, 6.324823416954991e-33, 3.14458097342157e-32, -8.352502044297355e-18, 3.715365963102056e-18, 1.8472087434962093e-17, -0.0008177461977023494, 0.0003637504514558933, 0.0018084975236706251, 0.0008032691952691565, -0.000357310780827527, -0.0017764807156143273, -3.841957954186232e-33, 1.7089824987709464e-33, 8.496733418895722e-33, -2.25686614054514e-18, 1.0039008188670608e-18, 4.991202451200635e-18, -0.00022095698933878225, 9.828624682101175e-05, 0.0004886603804208139, 0.00019812090314200653, -8.812828254444011e-05, -0.00043815692904037706, 1.0726955639321305e-07, -7.05344010015026e-08, -3.3127437383817897e-07, 1.5508440668058231e-06, -9.793176511666756e-07, -4.571310477540402e-06, 2.01510176399399e-06, -1.2596611799965075e-06, -5.870603411109413e-06, 5.113380277128973e-08, -3.170174473709852e-08, -1.4755225340983317e-07, -1.354013885186799e-06, 7.814717047515315e-07, 3.594396785521655e-06, 1.644620602203516e-05, -1.0437777636562564e-05, -4.876006865490089e-05, 3.2794540880581424e-05, -2.045637391997973e-05, -9.530401057035707e-05, 1.0660778012342742e-06, -6.602278441157614e-07, -3.0724284651728233e-06, -2.4721333268411355e-05, 1.5228957422746155e-05, 7.080926156241808e-05, -1.7746141199059348e-05, 1.0711877455547135e-05, 4.964257746829336e-05, 8.46717552645258e-05, -5.251585128378054e-05, -0.00024444500600658144, 4.354152978349291e-06, -2.6927286141764767e-06, -1.2528020526603838e-05, -2.7406889129528102e-05, 1.7054437814253428e-05, 7.942443801594275e-05, -7.62991374170842e-05, 4.771528069575328e-05, 0.00022238985410090806, 2.3337265189818247e-06, -1.0694949632396363e-06, -4.698808607196381e-06, 2.1367062435976395e-06, -1.3183558542951521e-06, -6.131444586373636e-06], [1.3877511584695885e-37, -6.173004678225251e-38, -3.069099606473267e-37, 8.152011652390962e-23, -3.626183682862258e-23, -1.8028690231402807e-22, 7.981173182614021e-09, -3.5501911919378135e-09, -1.7650870132199197e-08, -4.492823309890377e-08, 1.9985008941356656e-08, 9.936163387926773e-08, 3.5540945253685356e-33, -1.580934881448742e-33, -7.860105208780054e-33, 2.0877676669681428e-18, -9.286823143029788e-19, -4.617230463828834e-18, 0.0002044015149346454, -9.092202879652976e-05, -0.0004520468999213644, -0.00022455132702174977, 9.988508269275038e-05, 0.0004966094859221873, 7.692522922496097e-33, -3.421793575751068e-33, -1.7012501794814204e-32, 4.51878826529897e-18, -2.0100506442640594e-18, -9.99358653179536e-18, 0.00044240898147317783, -0.00019679268114137515, -0.0009784154908845095, -0.0004345767764207432, 0.00019330875406018156, 0.0009610940732099213, 2.0785381945523675e-33, -9.245768537488714e-34, -4.596818900857811e-33, 1.2209874571906049e-18, -5.431205183502739e-19, -2.70029111595557e-18, 0.00011953997080929455, -5.317385574042425e-05, -0.0002643702187741114, -0.00010718541671471646, 4.76782941076513e-05, 0.00023704733968414726, 5.279014218863327e-08, -2.1797113594554845e-08, -9.336898779199162e-08, -4.3363219227439173e-07, 3.1050058619412136e-07, 1.4759949999505951e-06, -9.430461200077909e-07, 6.018828764172757e-07, 2.814127833180433e-06, -3.170174473709852e-08, 1.9335477135392616e-08, 8.975905902659568e-08, 2.55597922716172e-06, -1.4092857944575186e-06, -6.429694783475312e-06, -3.0465435003850694e-06, 2.4814820185410246e-06, 1.1988049759575744e-05, -1.664518470686203e-05, 1.0473620592651357e-05, 4.886218015448694e-05, -6.82112145076579e-07, 4.141871311845486e-07, 1.9213502770974197e-06, 1.8218341863706422e-05, -1.0859592267000604e-05, -5.0222851756894644e-05, 1.959620322704491e-05, -1.1202825871092119e-05, -5.144253237998935e-05, -5.186181718022874e-05, 3.1686633989305574e-05, 0.00014713699883705763, -2.89908284585384e-06, 1.7508010773447469e-06, 8.114479676555863e-06, 1.5132059493351047e-05, -9.391444989603605e-06, -4.371877919162221e-05, 3.511831322042574e-05, -2.248166927946097e-05, -0.00010516281122271228, -1.2617841211352723e-05, 6.72192459724478e-06, 3.047244337679012e-05, -1.5127255271001867e-06, 9.062469691905872e-07, 4.194654348764508e-06], [6.309354085670741e-37, -2.8065314195360914e-37, -1.395353628296533e-36, 3.706278875109693e-22, -1.6486296332903357e-22, -8.19667053971234e-22, 3.6286078610594834e-08, -1.6140799569907898e-08, -8.024896171374743e-08, -2.042643807821746e-07, 9.08610286842561e-08, 4.517436190551855e-07, 1.6158545916274505e-32, -7.187656009199865e-33, -3.5735648001554233e-32, 9.491950613136807e-18, -4.222216294526021e-18, -2.0992050133518416e-17, 0.0009293031574856764, -0.00041337329849357803, -0.0020552128078055254, -0.001020913456955699, 0.000454123457753089, 0.002257814788957831, 3.497374196660069e-32, -1.555704504062211e-32, -7.734664608384403e-32, 2.0544486689808696e-17, -9.138613336686665e-18, -4.543543388889839e-17, 0.0020113944043638828, -0.0008947099047344404, -0.0044483261550316375, -0.0019757856032861115, 0.0008788703722435083, 0.004369575035489935, 9.449989192935741e-33, -4.2035509854304164e-33, -2.0899249794322036e-32, 5.551169714081771e-18, -2.4692753023848444e-18, -1.2276763511221407e-17, 0.0005434836055610556, -0.00024175276808033333, -0.001201948425531551, -0.0004873141288666683, 0.000216767421082656, 0.0010777260692636848, -4.833160358697402e-07, 2.922260706995136e-07, 1.3546483189302544e-06, -5.2440632157242695e-06, 3.1821729512050244e-06, 1.4760033069025567e-05, -6.260944852477573e-06, 3.8040784092585137e-06, 1.7648310352896154e-05, -1.4755225340983317e-07, 8.975905902659568e-08, 4.165018555734384e-07, 1.406680812564103e-06, -8.813966572666266e-07, -4.109230853087713e-06, -5.787241153052992e-05, 3.509799434432671e-05, 0.00016278182346466085, -0.00010000266606333374, 6.077850832031351e-05, 0.0002819841293060605, -3.045448227464976e-06, 1.8529253059542295e-06, 8.598221311678483e-06, 6.712377473961956e-05, -4.087603531186225e-05, -0.0001897064377771824, 3.8689464475644485e-05, -2.3664184073143283e-05, -0.00010990394710738003, -0.00024525133724898475, 0.00014918194716519103, 0.000692230045042495, -1.2273615040559573e-05, 7.469278243205106e-06, 3.4661351347135236e-05, 8.179445770061181e-05, -4.972942039828226e-05, -0.00023073452385826695, 0.00023792012749144855, -0.0001445493622272088, -0.000670603558463935, 9.538663609279032e-06, -5.635415868680091e-06, -2.6023608691226578e-05, -5.891814360813049e-06, 3.5869246672632258e-06, 1.6646242682623444e-05], [3.108778717210631e-36, -1.3828491835720463e-36, -6.875261086523316e-36, 1.8261775659660856e-21, -8.123216175449289e-22, -4.038707382696555e-21, 1.7879070881731448e-07, -7.952981161043489e-08, -3.954069796471522e-07, -1.0064623906621735e-06, 4.476953240570128e-07, 2.2258553403175666e-06, 7.961725235816223e-32, -3.541540342264081e-32, -1.7607859765751611e-31, 4.6769247137279814e-17, -2.080393012922339e-17, -1.0343315306064795e-16, 0.004578912260431463, -0.002036795042995873, -0.010126554556123456, -0.005030299431610368, 0.0022375814089356503, 0.01112482588234597, 1.7232449345950123e-31, -7.665350504707287e-32, -3.8110653472306255e-31, 1.0122789450404506e-16, -4.502826479564825e-17, -2.238719018826821e-16, 0.009910650173215381, -0.0044084625338003764, -0.021918030736903266, -0.009735196582510475, 0.004330417141467413, 0.02153000400538131, 4.656249258159357e-32, -2.0711961419148368e-32, -1.0297590226203e-31, 2.7352020553031012e-17, -1.2166745442963636e-17, -6.049072631157585e-17, 0.002677881512401265, -0.0011911771792009046, -0.005922304619047353, -0.0024011202602456, 0.0010680680400817228, 0.005310229575986516, -1.0582403411031615e-05, 1.1370269211403896e-05, 2.0073685733647405e-05, -7.532247920485624e-05, 0.00010410604381657176, 0.00011842789564052162, -7.32356240377766e-05, 0.00011615232957464669, 9.939476401368369e-05, -1.3540138851867987e-06, 2.55597922716172e-06, 1.406680812564103e-06, -7.554392772323808e-05, 1.877085660058561e-05, 0.00020912888880667262, -0.0008994908813635497, 0.0011821772438919554, 0.0014786513144219957, -0.0011076479425496338, 0.001824949491127899, 0.00143132741580184, -2.685572089489849e-05, 5.2222881069085375e-05, 2.6289112696213637e-05, 0.00046695234807605954, -0.0010900823107192923, -0.0002650245721474347, -8.781525887537185e-05, -0.0004542223951038987, 0.0007453315786527892, -0.002283151018094823, 0.004264274644479403, 0.0024201111680067556, -0.00010234292023229876, 0.0002075936840191911, 9.113109472081487e-05, 0.000846410319206056, -0.0014636203041491795, -0.0010208664404739247, 0.0028111852007753142, -0.004427611252476746, -0.0038479720798869784, 0.0006631720051157155, -0.00044597321599232885, -0.0015392040492865564, -4.43776829004794e-05, 9.733605542354338e-05, 3.17935424873999e-05], [-1.6818807959866004e-36, 7.481354246024948e-37, 3.719585934116545e-36, -9.879805729678166e-22, 4.39474228625524e-22, 2.1849816295903373e-21, -9.672758565797258e-08, 4.3026434179927497e-08, 2.1391918375725037e-07, 5.445063546550212e-07, -2.422077080674608e-07, -1.204210299948052e-06, -4.307374051073037e-32, 1.9160092215280693e-32, 9.526030603109113e-32, -2.530263674524915e-17, 1.1255137064494123e-17, 5.595838418410658e-17, -0.0024772379438563596, 0.0011019267628186616, 0.005478568655647645, 0.0027214429786366076, -0.0012105542219235836, -0.006018643561417777, -9.322929760909604e-32, 4.1470323175465474e-32, 2.0618249810679304e-31, -5.476531695291315e-17, 2.436074765216851e-17, 1.2111696804052992e-16, -0.005361762196129599, 0.0023850229141037073, 0.011857876785555724, 0.005266840025194818, -0.002342799565798676, -0.011647950390838963, -2.5190780434998977e-32, 1.12053810601666e-32, 5.571100686744922e-32, -1.4797720353943355e-17, 6.582332604405688e-18, 3.272609605678398e-17, -0.0014487610406945823, 0.0006444389274875985, 0.00320402682623088, 0.0012990303980802143, -0.0005778356354138623, -0.002872888024061531, 4.382058688368904e-06, -5.424784585876815e-06, -7.55639963594067e-06, 3.583711090480248e-05, -5.366438053972474e-05, -5.198600153013067e-05, 3.783790332270803e-05, -6.18747979551674e-05, -4.938719798849443e-05, 7.814717047515319e-07, -1.4092857944575186e-06, -8.813966572666266e-07, 1.8770856600585774e-05, 1.8006534462174917e-06, -5.8783940434783436e-05, 0.0004157224170222199, -0.0006012061571498908, -0.0006255462856769227, 0.0005859537746624792, -0.0009801234481414678, -0.0007416612135643968, 1.5806042706308326e-05, -2.8943883515297948e-05, -1.7363259252451338e-05, -0.0003113308459457436, 0.0006215055209324149, 0.00028777626159917516, -7.36295281231512e-05, 0.0003112760615268407, -0.00010526999398957946, 0.001308573528601722, -0.0023467073843959512, -0.001489760821982162, 6.195478537993947e-05, -0.00011587350339990113, -6.550286324363812e-05, -0.0004616088149105671, 0.0007938309659039659, 0.0005613808548490564, -0.0014462201978208, 0.002354991024482688, 0.0018981534046877543, -0.00022116290882379894, 0.0001668222868215211, 0.0004942240819782985, 2.8332346030180803e-05, -5.499888763591136e-05, -2.7835229158521596e-05], [-7.646602495703691e-36, 3.4013672184977804e-36, 1.691094586172236e-35, -4.4918134109087346e-21, 1.9980516701447366e-21, 9.933929932347775e-21, -4.397680261648807e-07, 1.956179295028263e-07, 9.725748509052593e-07, 2.475575950666111e-06, -1.1011874738131395e-06, -5.474893052413582e-06, -1.9583300580790274e-31, 8.711057840774909e-32, 4.330970991386729e-31, -1.1503740678043125e-16, 5.117102197267347e-17, 2.544125131690631e-16, -0.011262661354565363, 0.005009865119310748, 0.024908089119707776, 0.012372929592879282, -0.005503735435135594, -0.027363517668617686, -4.238632021196438e-31, 1.8854313423867601e-31, 9.374003248957876e-31, -2.489882816246186e-16, 1.107551464044207e-16, 5.506533592040364e-16, -0.024377033311831057, 0.010843409479919642, 0.05391135355046866, 0.023945473530127423, -0.01065144274761813, -0.05295693175221414, -1.145288566244629e-31, 5.094480832675102e-32, 2.532878222804778e-31, -6.727723252396898e-17, 2.992630693001938e-17, 1.4878786200519574e-16, -0.006586733028814325, 0.0029299153204045145, 0.014566977388779111, 0.005905988764279975, -0.0026271061673370636, -0.013061468319923171, 2.8689157683221805e-05, -2.9406222677459665e-05, -5.591717630523806e-05, 0.0002025938025762047, -0.000265440375641868, -0.00033390768906247026, 0.0001959453387847998, -0.0002942505073525334, -0.00028336470160789616, 3.594396785521655e-06, -6.429694783475312e-06, -4.109230853087713e-06, 0.00020912888880667257, -5.8783940434783436e-05, -0.000571737610961562, 0.002423581356203885, -0.0030219970338648274, -0.004156300424767606, 0.002958833321021003, -0.004615591036475933, -0.0040970914739763085, 7.118590685724997e-05, -0.00013122666839495434, -7.727953592277365e-05, -0.0012251146235748784, 0.0027226745295517315, 0.0008401914382360075, 0.00027611457969829115, 0.001084718024685921, -0.001981146428369627, 0.006064071230633844, -0.010731260649823587, -0.007055249952797017, 0.00027068319061967133, -0.0005208675310280503, -0.00027076998784118686, -0.0022562044215250865, 0.003694339378818092, 0.002939740998223201, -0.0075236041916317735, 0.011219977174459987, 0.01096269469187375, -0.0018163632574989175, 0.0011971315592717244, 0.0042414141668667355, 0.00011686532456028816, -0.0002435870063099873, -9.716708273492239e-05], [-9.784487947924787e-35, 4.352342962061517e-35, 2.163901498279777e-34, -5.747662992558745e-20, 2.5566795837558516e-20, 1.2711320845198617e-19, -5.627211502507906e-06, 2.5031002653712073e-06, 1.2444934743873485e-05, 3.167713120575377e-05, -1.4090644272386569e-05, -7.005598253291715e-05, -2.5058523523485115e-30, 1.114655044572107e-30, 5.541851232863853e-30, -1.472002920036799e-15, 6.547773969628087e-16, 3.255427714861059e-15, -0.14411547396012742, 0.0641055487167883, 0.3187205009473808, 0.1583223144528167, -0.07042504571658796, -0.35013982875642824, -5.4236955498061394e-30, 2.412572153003646e-30, 1.1994846320933998e-29, -3.186019990053616e-15, 1.4172077020788982e-15, 7.0460850549553325e-15, -0.31192518347826337, 0.13875078432584764, 0.6898423049547172, 0.30640300354899314, -0.1362944042803804, -0.6776296541892237, -1.465495581810726e-30, 6.518827980956282e-31, 3.241036324108517e-30, -8.608702638464134e-16, 3.8293292955556726e-16, 1.9038691280281606e-15, -0.08428293477115156, 0.03749079562726763, 0.18639704990325312, 0.07557222428803484, -0.03361609112893064, -0.16713276181192246, 2.2542862674948396e-06, 1.6894202727397245e-05, -5.947426555270035e-05, 0.0003561133628483366, 1.0633600492363624e-05, -0.001481185423281394, 0.0005653302770517913, -6.027831774688857e-05, -0.002121660404816939, 1.644620602203516e-05, -3.0465435003850694e-06, -5.787241153052992e-05, -0.0008994908813635497, 0.0004157224170222199, 0.002423581356203885, 0.0033569461986148476, 0.00041570054756835873, -0.014901786312223036, 0.009551184570938728, -0.0012342903751805555, -0.03520241085319764, 0.00034860576680139976, -6.764878434886445e-05, -0.0012175595836522951, -0.008732806640410045, 0.002037328268812, 0.02948042822380469, -0.008030779548374157, 0.002734790383949247, 0.024546367245925467, 0.027062027730270406, -0.00492123886488429, -0.09550167826251485, 0.001454387230809058, -0.0002983821219811863, -0.005031587881602137, -0.008312236173700626, 0.0012699274584047065, 0.030053285394356925, -0.021246297163635828, 0.00216741587460328, 0.08002812765634039, 0.003770260442936321, -0.0023195235764122087, -0.008440675432476341, 0.0007380543349237424, -0.00016400416952521874, -0.0025158990457835404], [5.293507153491658e-35, -2.3546616569759416e-35, -1.1706926434535342e-34, 3.1095439361670375e-20, -1.383189568818273e-20, -6.876953416725056e-20, 3.044378459176688e-06, -1.3542026145026434e-06, -6.732835835870515e-06, -1.713764905554569e-05, 7.623181371387378e-06, 3.7900996624104e-05, 1.3556915214519828e-30, -6.0303967703996675e-31, -2.9981976881041856e-30, 7.963684996748387e-16, -3.542412084530597e-16, -1.7612193901211684e-15, 0.07796793213880704, -0.03468175161713994, -0.17243102150146097, -0.08565397684312044, 0.03810066354722246, 0.18942919630634353, 2.9342742659669697e-30, -1.3052259881364759e-30, -6.48933343705165e-30, 1.72366910749716e-15, -7.667237313659562e-16, -3.812003432476753e-15, 0.16875468587465395, -0.0750655806712123, -0.3732116790877608, -0.1657671305611784, 0.07373665416922476, 0.366604511238579, 7.928479637374202e-31, -3.526752011268247e-31, -1.7534335018557093e-30, 4.657395383542528e-16, -2.0717059622316112e-16, -1.0300124955099452e-15, 0.045597921986606046, -0.02028290043375507, -0.10084269328185765, -0.04088533932517482, 0.018186646026904552, 0.0904205181653753, 4.1053689621375e-05, -3.2010208591150964e-05, -7.180258674576908e-05, -3.802689396413841e-05, -8.941147124142174e-05, 0.0004209859770107916, -0.00024972193262877125, 2.245646735568894e-06, 0.0010097841203136337, -1.0437777636562564e-05, 2.4814820185410263e-06, 3.5097994344326725e-05, 0.0011821772438919554, -0.0006012061571498908, -0.0030219970338648274, 0.00041570054756835873, -0.0014323476055220702, 0.0025723979666917025, -0.004748844687769907, 0.0004413817132794647, 0.018015625038426495, -0.000228785721404129, 5.833996460680003e-05, 0.0007575579491829637, 0.006572199179500431, -0.0021018192606338817, -0.020493869403567063, 0.008157413415939483, -0.0035422479940857917, -0.022657808949452598, -0.01694992351053566, 0.0039116823983720754, 0.0573470050943476, -0.000994131438622545, 0.00027357547752314957, 0.003232015105249658, 0.004613213021330446, -0.0007499138736880146, -0.016544969028160383, 0.009144649081405875, 9.867871113797311e-05, -0.03751623883678321, -0.006371160448571246, 0.003598223199285556, 0.015220379106429779, -0.0005353737681249094, 0.0001623479779530983, 0.0016958374865769022], [2.4066714542138705e-34, -1.0705373261728723e-34, -5.322506393137413e-34, 1.4137414779652742e-19, -6.288615004223733e-20, -3.126578844627384e-19, 1.3841142594265299e-05, -6.156826997759981e-06, -3.061056373827623e-05, -7.791562300451724e-05, 3.465848343042551e-05, 0.000172315336536989, 6.163596252526345e-30, -2.7416953154264345e-30, -1.3631183600632e-29, 3.620656928626899e-15, -1.6105432175110174e-15, -8.007312180577105e-15, 0.3544780259695683, -0.1576791703097072, -0.7839506120149013, -0.3894223149812142, 0.17322311406573565, 0.8612321210229021, 1.334055836701571e-29, -5.934156761976121e-30, -2.9503490005725565e-29, 7.836591350948578e-15, -3.4858781976513285e-15, -1.7331118251640903e-14, 0.7672363019127418, -0.3412826033043725, -1.6967916891304855, -0.7536535034346404, 0.3352406931220615, 1.6667524697722256, 3.604650955463095e-30, -1.6034234290232402e-30, -7.971913956883727e-30, 2.1174658304118466e-15, -9.418926727129728e-16, -4.6829098337805514e-15, 0.20730909401766007, -0.09221538021419695, -0.4584771952700718, -0.185883529003719, 0.08268484498405293, 0.4110932008475625, -8.925948466781889e-05, 3.736138320866437e-06, 0.00035219901440613295, -0.001421193938528537, 0.0002688407047007036, 0.0049844300850116945, -0.0018881033096692123, 0.000417456592705451, 0.006442473563049647, -4.876006865490089e-05, 1.1988049759575744e-05, 0.00016278182346466085, 0.0014786513144219957, -0.0006255462856769227, -0.004156300424767606, -0.014901786312223036, 0.0025723979666917025, 0.05299764782831746, -0.030869464100154093, 0.007026776098235493, 0.1047307674375895, -0.0010189006055542746, 0.0002537360410557863, 0.003391902827616491, 0.02388957588797542, -0.0063148279181882245, -0.07843943264569368, 0.01786104251633532, -0.005703060193773401, -0.05572223651569434, -0.08067201696177344, 0.019737286545746413, 0.2696049743350192, -0.004173827700837592, 0.0010566371025747764, 0.013843297567592472, 0.02593148870665582, -0.006091620823151431, -0.08741539472787563, 0.07142618918000218, -0.015700738232511696, -0.24398853518613275, -0.0034455820953643627, 0.002552250635863741, 0.006426213773590527, -0.0020580530279634053, 0.0005346875776472705, 0.006785211244506301], [-1.7242419718335576e-34, 7.66978553291846e-35, 3.813270358249914e-34, -1.0128646306755547e-19, 4.505431730616789e-20, 2.240014299714353e-19, -9.916384289753834e-06, 4.411013187640678e-06, 2.1930712098906983e-05, 5.58220721032453e-05, -2.483081423773225e-05, -0.00012345404900510268, -4.415862970175707e-30, 1.9642673405048842e-30, 9.765960720906244e-30, -2.5939928904785594e-15, 1.1538617820983144e-15, 5.736779616989716e-15, -0.25396316119479767, 0.11296807591075883, 0.5616556205517598, 0.2789987387283515, -0.12410441950474514, -0.6170233863699464, -9.55774442075537e-30, 4.2514827433233346e-30, 2.1137557307364483e-29, -5.614467940671643e-15, 2.497431665035159e-15, 1.2416751549517604e-14, -0.5496807766411277, 0.2445093981746823, 1.215653861990399, 0.539949481083567, -0.24018071628993706, -1.194132485348839, -2.582525529330967e-30, 1.1487608622699314e-30, 5.711418821309188e-30, -1.5170427406395177e-15, 6.74812042337821e-16, 3.355036131574522e-15, -0.1485250678575894, 0.06606702744386247, 0.3284725972168102, 0.13317488019379253, -0.05923894593357568, -0.2945246847032988, 5.2169392341383606e-05, -2.4828056674411244e-05, -0.0001881890673368947, 0.0009210560760021356, -0.00046018545051377434, -0.0029374251256083328, 0.0012496918753377617, -0.0006300544159663627, -0.0038854950682980214, 3.2794540880581424e-05, -1.664518470686203e-05, -0.00010000266606333374, -0.0011076479425496338, 0.0005859537746624788, 0.002958833321021003, 0.009551184570938728, -0.004748844687769909, -0.030869464100154093, 0.020518842171183993, -0.010363513038941969, -0.06346899059527901, 0.0006866770526325992, -0.0003488225222632334, -0.0020887670961974797, -0.01625802196299706, 0.00829193614744889, 0.048871200530921054, -0.012579306210254623, 0.006503687724284125, 0.03626219652361747, 0.05421584317411287, -0.027509016808238806, -0.16547848350433111, 0.002820347951291894, -0.0014342573233312617, -0.008551581625567038, -0.017318150510265758, 0.008764257850081706, 0.053263129135730135, -0.047235835665918, 0.02380635957478945, 0.1470124660721777, 0.003053777504081075, -0.001704578848026661, -0.006586617108480977, 0.0013965779831820139, -0.0007114487348334518, -0.004212809626151143], [9.328323833427919e-35, -4.149431712761389e-35, -2.063017914378936e-34, 5.479700313941203e-20, -2.4374842324422894e-20, -1.2118704404941728e-19, 5.364864411296809e-06, -2.38640284368425e-06, -1.1864737530935594e-05, -3.020030680950742e-05, 1.343372218291056e-05, 6.67898918179591e-05, 2.3890266251921517e-30, -1.0626885406443726e-30, -5.2834837358862644e-30, 1.4033764459556687e-15, -6.242509194335015e-16, -3.103655919672419e-15, 0.1373966443275291, -0.061116874090137885, -0.3038613835504918, -0.15094114552892005, 0.06714174885029439, 0.3338159060550224, 5.170836607064771e-30, -2.300095256339051e-30, -1.1435632749448598e-29, 3.0374840630570102e-15, -1.3511358442650128e-15, -6.7175884420646184e-15, 0.297382871620154, -0.13228206271214582, -0.6576810609676071, -0.29211814208899706, 0.12994020193782205, 0.646037778068041, 1.397172487343882e-30, -6.214912701044163e-31, -3.0899354721571678e-30, 8.207354991357602e-16, -3.650801546682054e-16, -1.8151085531746665e-15, 0.08035356713211902, -0.03574293148965348, -0.17770700442857099, -0.07204896001949214, 0.03204887018448388, 0.15934083966933132, 4.627064907347151e-05, -2.6870221889723008e-05, -8.14212635803608e-05, -0.00022580147628541627, 0.00010154016578534782, 0.0009189157969776638, -0.000577187011716561, 0.00028735507554892865, 0.0018588077722977165, -2.0456373919979722e-05, 1.0473620592651357e-05, 6.077850832031351e-05, 0.001824949491127899, -0.0009801234481414671, -0.004615591036475933, -0.0012342903751805555, 0.0004413817132794647, 0.007026776098235493, -0.010363513038941969, 0.005207830916685412, 0.03252362695721832, -0.000442316640826913, 0.00022702944880523005, 0.0013042323391463575, 0.012051741961290052, -0.006247543627792752, -0.03444850339571674, 0.013524313360671747, -0.007153489708151275, -0.03614427119552817, -0.03340044900859967, 0.017084096589812105, 0.09953429257822033, -0.001891133047095941, 0.0009735767062981097, 0.005525004335546386, 0.009574080776180289, -0.0048523435322226655, -0.02931960041420411, 0.02141417849852717, -0.010639219788206108, -0.06934997417676055, -0.009285023983431319, 0.00505167037570862, 0.022337920692687824, -0.0009953637808722687, 0.0005146357138881462, 0.0028690064036154786], [4.241084414283912e-34, -1.8865222176427035e-34, -9.379426871639613e-34, 2.4913234158019835e-19, -1.1081922725741162e-19, -5.509719569225684e-19, 2.4391137406661242e-05, -1.084968327351999e-05, -5.394254564973573e-05, -0.00013730446412828633, 6.107587042765185e-05, 0.00030365752119988694, 1.0861612189216265e-29, -4.831470141307021e-30, -2.402114348248941e-29, 6.380393818434354e-15, -2.838131364527186e-15, -1.4110645152619752e-14, 0.6246682439821158, -0.2778653772981057, -1.3814933967672642, -0.6862477667026085, 0.30525722485784307, 1.5176804125696497, 2.350899790211551e-29, -1.0457289345028274e-29, -5.199163824841061e-29, 1.3809797503280898e-14, -6.142884051857525e-15, -3.054124208372889e-14, 1.3520391063007946, -0.6014150071070682, -2.9901201406024054, -1.3281032280457994, 0.5907678325366313, 2.937184429409044, 6.352187773441551e-30, -2.825584731319051e-30, -1.4048265697153797e-29, 3.731440498625027e-15, -1.6598220447485388e-15, -8.25231706420474e-15, 0.3653242182426634, -0.1625037813528414, -0.8079376533759763, -0.3275676604504683, 0.14570888217639752, 0.7244366337914553, -0.00027584368263544693, 0.00014088087427761286, 0.0008257460206868797, -0.003226387306804498, 0.0016517569647954587, 0.009588594102756124, -0.003950673075866571, 0.0020241066601481834, 0.011713798996868663, -9.530401057035707e-05, 4.886218015448694e-05, 0.0002819841293060605, 0.0014313274158018396, -0.0007416612135643968, -0.0040970914739763085, -0.03520241085319764, 0.018015625038426495, 0.1047307674375895, -0.06346899059527901, 0.03252362695721832, 0.18808730494269185, -0.001973502114800535, 0.0010119071524185839, 0.005837468880728286, 0.04423589347796079, -0.022692834125005463, -0.13065221325778756, 0.02760676133897578, -0.014193096815452458, -0.08099207344632098, -0.15821518359404374, 0.08111373260586763, 0.4681756248471558, -0.007988318688716271, 0.004096505053316878, 0.023619685833835922, 0.052264732381521545, -0.026787551963188893, -0.1547895255728313, 0.1499616858893119, -0.07682953321799289, -0.44468339675176033, 0.0027589960802017074, -0.0013636241074538578, -0.009060715478082064, -0.0038627826618593993, 0.001981297956034439, 0.011414040789139556], [-5.302517641768094e-36, 2.3586697088477826e-36, 1.1726853700208706e-35, -3.1148369315988876e-21, 1.38554400285086e-21, 6.888659211454762e-21, -3.0495605314059384e-07, 1.3565077075965193e-07, 6.744296316910248e-07, 1.7166820374564088e-06, -7.636157378481414e-07, -3.796551084423147e-06, -1.3579991489296276e-31, 6.040661575532895e-32, 3.003301152468314e-31, -7.977240601420252e-17, 3.548441898344472e-17, 1.7642172979744618e-16, -0.007810064739130486, 0.003474078611115142, 0.01727245296903954, 0.00857997751072573, -0.003816551763587524, -0.018975163840437813, -2.9392689213262065e-31, 1.3074477143235172e-31, 6.500379433809749e-31, -1.7266030981077731e-16, 7.680288311783145e-17, 3.818492138592019e-16, -0.01690419362881467, 0.007519335560661702, 0.03738469515756484, 0.016604929562551666, -0.007386216703596325, -0.03672285371546345, -7.941975316278764e-32, 3.5327551688592345e-32, 1.75641815674591e-31, -4.665323096736314e-17, 2.0752323733128917e-17, 1.0317657595079456e-16, -0.004567553773918309, 0.0020317425528606397, 0.010101434543594629, 0.004095493342602053, -0.001821760292486681, -0.00905744299284568, 2.3319183183477704e-06, -1.587747720498882e-06, -7.0460472823473e-06, 3.275568955144584e-05, -2.138167357641815e-05, -9.527397564783679e-05, 4.2257552991132634e-05, -2.728350796493161e-05, -0.00012170362633944504, 1.0660778012342737e-06, -6.82112145076579e-07, -3.045448227464976e-06, -2.685572089489849e-05, 1.580604270630832e-05, 7.118590685724997e-05, 0.00034860576680139976, -0.000228785721404129, -0.0010189006055542746, 0.0006866770526325992, -0.0004423166408269131, -0.001973502114800535, 2.2209486942466113e-05, -1.4193386959507808e-05, -6.337727410638391e-05, -0.0005130954430844449, 0.0003259756089801986, 0.0014564318706830795, -0.0003631072688718869, 0.00022543327904003225, 0.0010095841445396357, 0.0017658098090922159, -0.0011303316058419019, -0.00504640110024795, 9.06190514585782e-05, -5.782094697269628e-05, -0.00025822670968690464, -0.0005728887236486062, 0.00036804522056407244, 0.0016425559389831451, -0.0016004971191500687, 0.0010338275936000352, 0.004611389608698357, 3.9714616470166696e-05, -1.6448402026055166e-05, -7.744760005555637e-05, 4.4397253590316615e-05, -2.825599945252006e-05, -0.0001262229678127691], [2.868715789482708e-36, -1.2760642195034762e-36, -6.34434671291825e-36, 1.6851583513755328e-21, -7.495933491464983e-22, -3.72683445550525e-21, 1.6498431572422674e-07, -7.338844191076657e-08, -3.6487326663224837e-07, -9.287423822187307e-07, 4.131238540362517e-07, 2.053972617775349e-06, 7.346913039858364e-32, -3.2680591393326277e-32, -1.6248163643609566e-31, 4.315768021125552e-17, -1.9197430333203938e-17, -9.544594399671408e-17, 0.004225324185164805, -0.0018795117411975289, -0.009344572126469936, -0.004641854798283746, 0.002064793187926266, 0.010265755966242195, 1.5901742782948514e-31, -7.073424654844343e-32, -3.5167711602710885e-31, 9.341097765890577e-17, -4.1551138225812994e-17, -2.0658429504709607e-16, 0.009145340090803323, -0.004068036752838859, -0.02022549900423215, -0.008983435197672744, 0.003996018101899678, 0.01986743607575934, 4.2966891444219443e-32, -1.911256353671245e-32, -9.502400255119175e-32, 2.5239870821406983e-17, -1.1227217481134658e-17, -5.581957336706041e-17, 0.0024710928875253417, -0.0010991933144444469, -0.005464978474258007, -0.0022157034094706482, 0.0009855907832428375, 0.004900168463607781, 1.0293288481450725e-06, -3.804234896148387e-07, -1.8229490559218818e-06, -9.341061317703698e-06, 7.03398377068178e-06, 3.093182077140552e-05, -1.9820042316438402e-05, 1.3115051827192107e-05, 5.836123061166512e-05, -6.602278441157614e-07, 4.141871311845486e-07, 1.8529253059542295e-06, 5.2222881069085375e-05, -2.8943883515297948e-05, -0.00013122666839495434, -6.764878434886445e-05, 5.833996460680003e-05, 0.0002537360410557863, -0.0003488225222632334, 0.00022702944880523005, 0.0010119071524185839, -1.4193386959507808e-05, 8.85699399277081e-06, 3.9644512284131757e-05, 0.00037772038740590755, -0.00023052775205275198, -0.0010342335739293247, 0.0004030656884593029, -0.00023374573098618295, -0.0010544168468116957, -0.0010804578769987151, 0.0006792211718996043, 0.0030379508736593577, -6.0259687387371104e-05, 3.735935160803612e-05, 0.00016733497908697753, 0.0003162363325091858, -0.0002025233285351454, -0.0009041298064723222, 0.0007385415038457088, -0.0004904169960538377, -0.0021815837969470587, -0.0002562186310742792, 0.00013589147939217547, 0.0006192671952873973, -3.1393901627105796e-05, 1.9276481599156428e-05, 8.642691113001886e-05], [1.3042499425445475e-35, -5.80157396934282e-36, -2.884431377323164e-35, 7.661503767706199e-21, -3.407995613020933e-21, -1.6943900968810356e-20, 7.500944676812198e-07, -3.33657560279999e-07, -1.6588814367245625e-06, -4.222489390856985e-06, 1.8782507659558831e-06, 9.338302799262785e-06, 3.340244072014864e-31, -1.4858097690727879e-31, -7.38716138291744e-31, 1.9621463423546738e-16, -8.728033463921195e-17, -4.3394109458390043e-16, 0.019210264209292813, -0.008545123533867787, -0.042484716344972924, -0.02110400366657933, 0.00938749808047319, 0.04667284113063733, 7.229662550418987e-31, -3.2159036923408437e-31, -1.5988856757932717e-30, 4.2468920306192717e-16, -1.8891055657154986e-16, -9.392270783100696e-16, 0.041578916014302775, -0.018495163308303638, -0.0919544069542048, -0.04084282201594501, 0.018167733446851596, 0.09032648844237406, 1.953472208815296e-31, -8.689449120761876e-32, -4.320227549976045e-31, 1.1475204406564055e-16, -5.104408672476225e-17, -2.5378141544644823e-16, 0.011234723106391552, -0.0049974376076761294, -0.024846301913873013, -0.010073605252540372, 0.004480948329317426, 0.022278416218678453, -1.0272531328973868e-05, 6.3597838085914156e-06, 2.8489998799986706e-05, -0.00011011834200295961, 6.857883302114476e-05, 0.00030702663583219436, -0.00013090502042012586, 8.169701924575005e-05, 0.00036567717843644456, -3.0724284651728233e-06, 1.9213502770974197e-06, 8.598221311678483e-06, 2.6289112696213623e-05, -1.7363259252451338e-05, -7.727953592277365e-05, -0.0012175595836522951, 0.0007575579491829637, 0.003391902827616491, -0.0020887670961974797, 0.0013042323391463575, 0.005837468880728286, -6.337727410638391e-05, 3.9644512284131757e-05, 0.00017740766965554513, 0.0013926379014553146, -0.0008724447657362195, -0.0039035594922700693, 0.0007905885897202035, -0.0004990190522752938, -0.0022310405690349165, -0.005107888330841929, 0.003193889528634372, 0.014293108681242521, -0.00025522008881226604, 0.0001597098443934532, 0.0007146672670210152, 0.001706428946286546, -0.0010661190642724013, -0.00477143992340519, 0.004975435456343059, -0.0031048457373947292, -0.01389747408372055, 0.00021815506902529225, -0.00013041500991510145, -0.0005863699771970997, -0.00012235437969903965, 7.661572885233908e-05, 0.00034281622090644176], [1.1780831723152231e-34, -5.240358035125131e-35, -2.605405571797736e-34, 6.920367307630582e-20, -3.078322760123053e-20, -1.5304830733430752e-19, 6.775339919110692e-06, -3.0138115729163104e-06, -1.4984093475661066e-05, -3.8140263874140567e-05, 1.6965579591622076e-05, 8.43496098940397e-05, 3.0171251723340476e-30, -1.3420797878597051e-30, -6.672563465414638e-30, 1.7723378871982989e-15, -7.88372612935615e-16, -3.919637522145266e-15, 0.17351957061653678, -0.07718510012708389, -0.38374952356870506, -0.19062505411785124, 0.0847939735935176, 0.4215793840318119, 6.530300300837664e-30, -2.9048128737822336e-30, -1.4442172835622495e-29, 3.836068434974306e-15, -1.7063627186017256e-15, -8.48370837403424e-15, 0.3755677472677748, -0.16706031529681475, -0.8305918667830382, -0.36891886867157814, 0.16410275634045712, 0.8158874505348257, 1.764502846978002e-30, -7.848874247130149e-31, -3.902309834317332e-30, 1.0365149170622921e-15, -4.610633104519946e-16, -2.2923184063976872e-15, 0.10147930857055669, -0.04514009898142975, -0.22442792001884673, -0.09099133874149057, 0.04047483270333797, 0.2012331102875489, -6.490318852821619e-05, 5.010904312548252e-05, 0.0001791980950531066, -0.0008074859745332378, 0.0006051583492085069, 0.002205649279867053, -0.0010077122034241087, 0.0007484820092779388, 0.002743786715509906, -2.4721333268411355e-05, 1.8218341863706422e-05, 6.712377473961956e-05, 0.00046695234807605954, -0.0003113308459457435, -0.0012251146235748788, -0.008732806640410049, 0.006572199179500431, 0.02388957588797542, -0.01625802196299706, 0.012051741961290056, 0.04423589347796079, -0.0005130954430844449, 0.00037772038740590755, 0.0013926379014553146, 0.011635721075949318, -0.008519686621803545, -0.03152146485000156, 0.007640046442784757, -0.005466156382626612, -0.020530286197099328, -0.04100488087434121, 0.030230557891578105, 0.11135289462557836, -0.0020832514353624505, 0.001531435424903199, 0.0056515061704729835, 0.013453536032906473, -0.009950080216878867, -0.036575590059504795, 0.03822005681455244, -0.028398964944497174, -0.10407929533365454, 9.303039105247139e-05, -0.00028194562010204575, -0.0005308901421708163, -0.0010124640493722908, 0.0007425420437006955, 0.0027443752773934123], [-6.373549370441427e-35, 2.835086812251198e-35, 1.409550822226057e-34, -3.7439888569234575e-20, 1.6654038145065752e-20, 8.280068553569788e-20, -3.6655275697648304e-06, 1.6305026083548973e-06, 8.106546446186005e-06, 2.0634269338196988e-05, -9.178550518878298e-06, -4.563399390389457e-05, -1.632295299225892e-30, 7.260787682914648e-31, 3.6099244665931456e-30, -9.588527610459476e-16, 4.265175743894396e-16, 2.1205636281631776e-15, -0.09387584646412182, 0.04175792150189574, 0.20761238186110645, 0.10313008641618249, -0.04587439916929603, -0.22807871980774566, -3.5329586526052725e-30, 1.5715332073337747e-30, 7.813361887123068e-30, -2.075351904963695e-15, 9.23159526123741e-16, 4.58977221956843e-15, -0.20318595795341193, 0.0903813238663982, 0.4493586186470304, 0.19958884724113096, -0.08878125449376711, -0.441403380415648, -9.546139248723253e-31, 4.246320522358238e-31, 2.111189173418196e-30, -5.607650760440417e-16, 2.4943992420245327e-16, 1.2401674923540951e-15, -0.054901334511180094, 0.024421251080205892, 0.12141777948788683, 0.04922723652963563, -0.021897294737527787, -0.10886915232518037, -1.578507960032333e-05, 4.270297496313244e-07, 2.8245725573482337e-05, 0.00025067383543703474, -0.0002266692281950012, -0.0007353248131400414, 0.00047760326517265277, -0.00036837529380487143, -0.00131819305573955, 1.5228957422746155e-05, -1.0859592267000604e-05, -4.087603531186225e-05, -0.0010900823107192923, 0.0006215055209324146, 0.0027226745295517315, 0.002037328268812002, -0.0021018192606338817, -0.0063148279181882245, 0.00829193614744889, -0.006247543627792752, -0.022692834125005463, 0.00032597560898019873, -0.00023052775205275198, -0.0008724447657362195, -0.008519686621803548, 0.005812791542865124, 0.02252534449411545, -0.00872392973110739, 0.005440800193833143, 0.022398470819926675, 0.02496427593668747, -0.017859165303661762, -0.06708149708322969, 0.0013766476914385737, -0.0009635514812415159, -0.0036714277578057913, -0.0074184186532563, 0.005458792007296237, 0.020131921716513294, -0.017848189212144514, 0.013833475541305698, 0.0493489052190551, 0.005164825311429166, -0.002668916653077619, -0.012540399999919872, 0.0007115965858026072, -0.0004903636432551185, -0.001887736950659044], [-2.8977082465537746e-34, 1.2889606650975343e-34, 6.4084653685175945e-34, -1.7021892755748988e-19, 7.571690570906462e-20, 3.7644994233484713e-19, -1.6665171711287964e-05, 7.413013659499112e-06, 3.6856083043971874e-05, 9.381286461857903e-05, -4.172990587209023e-05, -0.00020747309351954008, -7.421164055484893e-30, 3.3010875294750665e-30, 1.641237446876278e-29, -4.359385001078707e-15, 1.9391447696949322e-15, 9.641056114145784e-15, -0.42680271013961196, 0.18985068830902924, 0.9439012331113915, 0.4688767349350241, -0.20856608626122888, -1.0369506045021168, -1.606245253212618e-29, 7.144911680991321e-30, 3.5523131394614735e-29, -9.435502857174664e-15, 4.1971071631444325e-15, 2.0867212345019816e-14, -0.9237766772092211, 0.41091500556458505, 2.042990646549789, 0.9074225599522276, -0.40364035537103027, -2.0068224801380175, -4.340113305164557e-30, 1.930572320065953e-30, 9.598435537693583e-30, -2.549495564854521e-15, 1.1340684497296625e-15, 5.638370962290803e-15, -0.24960667991002888, 0.11103022277424003, 0.5520209861901952, 0.22380962467871943, -0.09955515812338993, -0.4949691642008023, 0.00026043619801446877, -0.00017778340252578027, -0.0006886937834951469, 0.002642678384083315, -0.0018436806463443497, -0.007040024156134454, 0.003077741769365593, -0.002165141298769716, -0.008222412913968658, 7.080926156241808e-05, -5.0222851756894644e-05, -0.0001897064377771824, -0.0002650245721474347, 0.00028777626159917516, 0.0008401914382360075, 0.02948042822380469, -0.020493869403567063, -0.07843943264569368, 0.048871200530921054, -0.03444850339571674, -0.13065221325778756, 0.0014564318706830795, -0.0010342335739293247, -0.0039035594922700693, -0.03152146485000156, 0.02252534449411545, 0.0846690248485255, -0.016513913935646968, 0.012212491027382096, 0.04489440054772532, 0.11784547299186439, -0.0835474189986918, -0.3156740723264141, 0.005842337481494145, -0.0041553978062254275, -0.01566745329069224, -0.0396967695253079, 0.028047590110278905, 0.10621136402566768, -0.11708690465920425, 0.08233769139582557, 0.3127657704291973, -0.007245985805314123, 0.004489851251005532, 0.018565793883104618, 0.002782526635829008, -0.0019844931626797364, -0.007468976868223477], [7.058054353266433e-35, -3.139568810731897e-35, -1.5609334357872661e-34, 4.146084907217002e-20, -1.8442644686237912e-20, -9.169329443167104e-20, 4.059197052866784e-06, -1.8056149507969546e-06, -8.977171448582801e-06, -2.285034382950839e-05, 1.0164306367012271e-05, 5.053498303850268e-05, 1.807600172667952e-30, -8.040580081046693e-31, -3.997622300466483e-30, 1.0618314083559329e-15, -4.723246103066629e-16, -2.3483074307933024e-15, 0.10395790293482524, -0.046242629108151155, -0.2299094884841705, -0.11420602761127847, 0.050801207293057635, 0.2525738654653273, 3.912390529769117e-30, -1.740312367668486e-30, -8.652499521979158e-30, 2.2982400693907683e-15, -1.0223047996356502e-15, -5.08270351604457e-15, 0.22500767652426065, -0.1000880764064802, -0.49761873175853377, -0.2210242441467316, 0.09831616315302641, 0.4888091186894517, 1.0571373306342213e-30, -4.702365872803996e-31, -2.337926180523371e-30, 6.209899941291753e-16, -2.7622921555460387e-16, -1.3733587141858288e-15, 0.06079761535132403, -0.02704403896175073, -0.13445777811854784, -0.054514131905627206, 0.024249015338883614, 0.12056145639489205, -7.598927908364779e-05, 7.205495838530406e-05, 0.00017155285246423806, -0.0007097347387335536, 0.0007312639164403989, 0.001573371840102118, -0.0007988596733146411, 0.0008517028955312603, 0.0017567495247276842, -1.7746141199059348e-05, 1.959620322704491e-05, 3.8689464475644485e-05, -8.781525887537185e-05, -7.362952812315134e-05, 0.00027611457969829115, -0.008030779548374157, 0.008157413415939483, 0.01786104251633532, -0.012579306210254623, 0.013524313360671747, 0.02760676133897578, -0.0003631072688718869, 0.0004030656884593029, 0.0007905885897202035, 0.007640046442784757, -0.00872392973110739, -0.016513913935646968, 0.0033664976416239996, -0.004571591712019195, -0.00691563274624362, -0.029591152956837896, 0.03261319706558222, 0.06454471464816224, -0.0014462645982853326, 0.0016168785896750698, 0.003143245950093768, 0.010115849774834151, -0.010985626560677602, -0.0221459104021189, 0.030439089101219174, -0.03240134826661497, -0.06696315917311232, 0.0028197324644648625, -0.002003445540275238, -0.006698454085626575, -0.0006804597510967656, 0.0007700852449057626, 0.001474239037993116], [-3.818478944181533e-35, 1.6985385486640023e-35, 8.444808100782299e-35, -2.2430739587135825e-20, 9.977657706309612e-21, 4.960700167290946e-20, -2.196066748831744e-06, 9.768559897426567e-07, 4.856740744544827e-06, 1.2362267618399071e-05, -5.498992767983512e-06, -2.7339938036576522e-05, -9.779300148966886e-31, 4.350035321600088e-31, 2.162754183673482e-30, -5.744615544369269e-16, 2.555324015661712e-16, 1.2704581220459706e-15, -0.056242279184799175, 0.02501773105379283, 0.12438336358773747, 0.06178661850775631, -0.02748396805668795, -0.13664502125625455, -2.1166429318335776e-30, 9.4152663037589e-31, 4.681089941440836e-30, -1.2433711720541752e-15, 5.530772584852457e-16, 2.749794119473113e-15, -0.12173143363361481, 0.05414866380915645, 0.2692167776479224, 0.11957635634207678, -0.05319004077927029, -0.2644506876850266, -5.719220108112232e-31, 2.5440275994516794e-31, 1.2648417604276068e-30, -3.359618810575288e-16, 1.4944280542057489e-16, 7.430009844710036e-16, -0.03289212613785539, 0.01463109919141933, 0.0727430207999882, 0.02949269790556888, -0.0131189630816331, -0.06522496989707971, 1.0617078336083448e-05, -2.248495824468508e-05, -1.7806599789198087e-05, 0.0002724281983340457, -0.00033527395056138793, -0.000576843844787656, 0.0003917035444257413, -0.0004388756777676597, -0.0008508326489938119, 1.0711877455547128e-05, -1.1202825871092119e-05, -2.3664184073143283e-05, -0.0004542223951038985, 0.0003112760615268418, 0.001084718024685921, 0.0027347903839492417, -0.003542247994085785, -0.005703060193773401, 0.006503687724284123, -0.007153489708151274, -0.014193096815452458, 0.00022543327904003225, -0.00023374573098618295, -0.0004990190522752938, -0.005466156382626614, 0.005440800193833145, 0.012212491027382099, -0.004571591712019195, 0.003961208089155379, 0.010506243409642489, 0.017674780645004624, -0.018545212884538843, -0.03901635344797291, 0.0009319750564317661, -0.0009556456270897128, -0.0020683270224713945, -0.005556604788671595, 0.005988686859915326, 0.012187350933528239, -0.014772814741999218, 0.01661242347172552, 0.03205848851926192, 0.0015989659076339393, -0.0006064854605763809, -0.004061265871940609, 0.0004662963255253429, -0.0004697298582832489, -0.001039022232970817], [-1.7360558901704154e-34, 7.722336289382623e-35, 3.8393975871102695e-34, -1.019804433921597e-19, 4.536301413298967e-20, 2.255362114256925e-19, -9.984327975216655e-06, 4.441235946646003e-06, 2.2080973863808876e-05, 5.6204545916082975e-05, -2.500094651407993e-05, -0.00012429991407342012, -4.446118958238064e-30, 1.9777258308627112e-30, 9.832873755342508e-30, -2.6117660456824753e-15, 1.16176764977142e-15, 5.776086075722765e-15, -0.2557032302198749, 0.11374209466525098, 0.5655038934409644, 0.28091034299809226, -0.1249547406900676, -0.6212510203201596, -9.623230828067037e-30, 4.280612454095177e-30, 2.128238464595682e-29, -5.652936361484685e-15, 2.5145432156322214e-15, 1.2501826899272062e-14, -0.553447001981109, 0.24618469323756623, 1.22398310793502, 0.5436490309029969, -0.24182635269984304, -1.2023142741556032, -2.6002201140845926e-30, 1.1566317801788625e-30, 5.750551516513672e-30, -1.5274370004616355e-15, 6.794356244632635e-16, 3.3780236956885546e-15, -0.14954271100240857, 0.06651969619902028, 0.33072317950329083, 0.13408734908437248, -0.059644831001363814, -0.29654266746332497, 0.0002472970405450934, -0.00020990253088580858, -0.0005704996373277224, 0.0021390511718534576, -0.0020114713810797393, -0.0048374593408603145, 0.002323863450847764, -0.002289098480817095, -0.005203880648113704, 4.964257746829336e-05, -5.144253237998935e-05, -0.00010990394710738003, 0.0007453315786527888, -0.00010526999398957946, -0.001981146428369627, 0.024546367245925467, -0.022657808949452598, -0.05572223651569434, 0.03626219652361747, -0.03614427119552818, -0.08099207344632098, 0.0010095841445396357, -0.0010544168468116957, -0.0022310405690349165, -0.020530286197099328, 0.022398470819926675, 0.04489440054772532, -0.00691563274624362, 0.010506243409642489, 0.013653088389569995, 0.0829616623371755, -0.08572384089904993, -0.1837912504253332, 0.003987634818942463, -0.004209793847568979, -0.008789746826530137, -0.028839123870168897, 0.02916210643293281, 0.06420571861197337, -0.08869663952445955, 0.08717708243177832, 0.1987160254020301, -0.01113971621961394, 0.007202283272736989, 0.026816738971405168, 0.0018487676680173913, -0.0019888697094537756, -0.004056734138011761], [-4.2611087677014045e-34, 1.8954294649233281e-34, 9.423711997844285e-34, -2.5030862424005944e-19, 1.113424621556801e-19, 5.535733805470043e-19, -2.4506300583805427e-05, 1.0900910240756272e-05, 5.4197236312032276e-05, 0.00013795274953053963, -6.13642412062681e-05, -0.00030509124543841114, -1.0912895479034333e-29, 4.854282011146196e-30, 2.4134559726921057e-29, -6.410518958205873e-15, 2.851531650854229e-15, 1.417726880777107e-14, -0.6276176259005832, 0.2791773234830867, 1.38801614173495, 0.6894878974027041, -0.30669850212485744, -1.52484616688799, -2.361999604233115e-29, 1.0506663617544182e-29, 5.223711766766814e-29, -1.3875000701052286e-14, 6.17188778515809e-15, 3.0685443086480454e-14, -1.3584227823265898, 0.6042545984654328, 3.004238044564545, 1.3343738904084095, -0.5935571530761041, -2.951052396495187, -6.382179737883774e-30, 2.8389257785003903e-30, 1.4114594826627194e-29, -3.749058559479736e-15, 1.6676589232417491e-15, 8.291280521958679e-15, -0.3670491028578864, 0.16327104576722767, 0.811752344980796, 0.3291142768250233, -0.14639684918383108, -0.7278570738880404, 0.00017477271349153334, -0.00011329456842426965, -0.000544387188649008, 0.002555395235793208, -0.0015928258041257254, -0.007570535163853415, 0.003329453305841109, -0.0020553389177189376, -0.009741712147961268, 8.46717552645258e-05, -5.186181718022874e-05, -0.00024525133724898475, -0.002283151018094823, 0.0013085735286017188, 0.006064071230633844, 0.027062027730270406, -0.01694992351053568, -0.08067201696177341, 0.054215843174112884, -0.03340044900859968, -0.15821518359404374, 0.0017658098090922159, -0.0010804578769987151, -0.005107888330841929, -0.04100488087434121, 0.02496427593668747, 0.11784547299186439, -0.029591152956837896, 0.017674780645004624, 0.0829616623371755, 0.14019165303475276, -0.08590111750515318, -0.4062668276587168, 0.007214756147852899, -0.004408619023502966, -0.020833657191921623, -0.04533820823664335, 0.027867204089124287, 0.13191672373780308, -0.12605121803466124, 0.07784486562944777, 0.3690044852933602, 0.004131588675497117, -0.0019457731822476964, -0.008393858913550064, 0.0035426395386097894, -0.002160038614378907, -0.010201097102276964], [2.3053030330950946e-34, -1.0254465522274494e-34, -5.0983237077433375e-34, 1.354195027933408e-19, -6.023740057173582e-20, -2.994888097879083e-19, 1.3258157006928943e-05, -5.8975029297524336e-06, -2.932125417744202e-05, -7.463383575822542e-05, 3.319867646858946e-05, 0.00016505745612762886, 5.903987065140905e-30, -2.626215770087204e-30, -1.305704143546157e-29, 3.4681557321611143e-15, -1.542707525681626e-15, -7.670046123039817e-15, 0.33954749702224546, -0.151037761691332, -0.7509308013399097, -0.3730199410099158, 0.16592699828583707, 0.8249572318301923, 1.2778657266581134e-29, -5.684211510587698e-30, -2.826081012346017e-29, 7.50651601357429e-15, -3.3390538488231657e-15, -1.660113573146118e-14, 0.7349204939474591, -0.32690786237673297, -1.6253232324811746, -0.7219097996648386, 0.3211204359938829, 1.5965492577962812, 3.45282392672604e-30, -1.5358876209675322e-30, -7.636138863989712e-30, 2.0282786804059815e-15, -9.022203805398621e-16, -4.485666801184321e-15, 0.19857728498434174, -0.08833129064359366, -0.4391662463982937, -0.1780541596005538, 0.07920217925840571, 0.39377805439098346, 8.954478693019223e-05, -3.8305696786001666e-05, -0.00015830474704642936, -0.0007090691056482008, 0.0004974048196069856, 0.0024393243735572477, -0.0015568348711753758, 0.000979718394814044, 0.004669137639798232, -5.251585128378054e-05, 3.1686633989305574e-05, 0.00014918194716519103, 0.004264274644479403, -0.0023467073843959512, -0.010731260649823587, -0.00492123886488429, 0.0039116823983720754, 0.019737286545746413, -0.027509016808238806, 0.017084096589812105, 0.08111373260586763, -0.0011303316058419019, 0.0006792211718996043, 0.003193889528634372, 0.030230557891578105, -0.017859165303661762, -0.0835474189986918, 0.03261319706558222, -0.018545212884538843, -0.08572384089904993, -0.08590111750515318, 0.05191377980467757, 0.24452904920713545, -0.004806010542244387, 0.0028735068241020852, 0.013491706981215702, 0.025034516146900092, -0.015350237498188599, -0.07261309438819634, 0.057961636647803974, -0.03657851528539292, -0.17446439505585987, -0.021098369525265854, 0.011257831959259503, 0.05093845653240013, -0.0025092225035381146, 0.0014892154564308635, 0.0069765493771476285], [1.0480966289812276e-33, -4.66215095872681e-34, -2.3179320960536133e-33, 6.156792505732137e-19, -2.738668867886917e-19, -1.3616136683552376e-18, 6.027767051002209e-05, -2.6812756723707757e-05, -0.00013330788716144906, -0.00033931969265277886, 0.00015093642958796078, 0.0007504269975445284, 2.6842236580997453e-29, -1.193998297009222e-29, -5.936330676059526e-29, 1.5767828695300385e-14, -7.013856894119588e-15, -3.48715521138906e-14, 1.5437388573172834, -0.686687028147527, -3.4140762849118467, -1.6959199597736436, 0.7543803355295632, 3.7506344342680737, 5.809764448202883e-29, -2.58430359789385e-29, -1.2848662148728157e-28, 3.412806913569994e-14, -1.5180872244113303e-14, -7.547638704159257e-14, 3.3412860748349895, -1.486273273516225, -7.3894658381691425, -3.2821334835159575, 1.4599609753269571, 7.258646134916777, 1.569812326672112e-29, -6.982850475274869e-30, -3.47173941424733e-29, 9.221486360141834e-15, -4.101908191099763e-15, -2.039390130304122e-14, 0.9028235333768708, -0.40159461306401106, -1.996651441500115, -0.80951598021746, 0.36008948019840503, 1.7902958762860024, -0.0007944593309471981, 0.00047590683054438794, 0.002235754854517296, -0.008660081768221434, 0.005202539278122639, 0.024461918953979703, -0.0103562968997498, 0.006227794919305534, 0.029291394805821235, -0.00024444500600658144, 0.00014713699883705763, 0.0006922300450424952, 0.0024201111680067556, -0.001489760821982162, -0.007055249952797017, -0.09550167826251485, 0.057347005094347585, 0.2696049743350192, -0.16547848350433111, 0.09953429257822033, 0.4681756248471558, -0.00504640110024795, 0.0030379508736593577, 0.014293108681242521, 0.11135289462557836, -0.06708149708322969, -0.3156740723264141, 0.06454471464816224, -0.0390163534479729, -0.1837912504253332, -0.4062668276587168, 0.24452904920713545, 1.150409742825573, -0.0203437298390707, 0.012249195134430428, 0.05763373823819099, 0.13540902601285418, -0.08146997270710582, -0.38323849867216186, 0.3935176852025012, -0.23663267594992765, -1.1129474994761779, 0.01521857462875422, -0.008945377748374218, -0.041782848930783656, -0.009770602916050315, 0.005884766843989985, 0.027690932197125425], [-2.1414114149386047e-35, 9.525441648341918e-36, 4.7358670110088464e-35, -1.2579208239605354e-20, 5.595492451044865e-21, 2.781971596441951e-20, -1.2315590769673334e-06, 5.478229938582125e-07, 2.7236709228456786e-06, 6.932786949867522e-06, -3.083847274310099e-06, -1.5332297559071148e-05, -5.484253095337458e-31, 2.439509403935501e-31, 1.2128773169436232e-30, -3.2215930691174373e-16, 1.4330313446779086e-16, 7.124757173000052e-16, -0.03154079422960074, 0.014029998760655481, 0.06975446467266865, 0.034650071951968335, -0.015413069912060135, -0.07663082934071057, -1.1870180251966986e-30, 5.2801021119360136e-31, 2.6251655650033445e-30, -6.972852959945041e-16, 3.101669465712127e-16, 1.542090607869758e-15, -0.06826725650460236, 0.030366690108711503, 0.15097736276029647, 0.06705868440570248, -0.029829092198960225, -0.14830452899576277, -3.2073512524456367e-31, 1.4266962895489753e-31, 7.093260493155022e-31, -1.8840816398296093e-16, 8.38078549302206e-17, 4.166765910497548e-16, -0.0184459768936349, 0.008205152700749011, 0.04079444652577493, 0.01653957004229551, -0.007357143434815726, -0.03657830699563317, 1.0034527073532422e-05, -7.111187462301042e-06, -2.952296583028501e-05, 0.00013604131350611852, -9.248169689116546e-05, -0.00038895226533820125, 0.0001739015916171996, -0.00011689113121284144, -0.0004933756178804337, 4.354152978349291e-06, -2.89908284585384e-06, -1.2273615040559573e-05, -0.00010234292023229879, 6.195478537993944e-05, 0.00027068319061967144, 0.001454387230809058, -0.000994131438622545, -0.004173827700837592, 0.002820347951291894, -0.001891133047095941, -0.007988318688716271, 9.06190514585782e-05, -6.0259687387371104e-05, -0.00025522008881226604, -0.0020832514353624505, 0.0013766476914385737, 0.005842337481494145, -0.0014462645982853326, 0.0009319750564317661, 0.003987634818942463, 0.007214756147852899, -0.004806010542244387, -0.0203437298390707, 0.00036925903704019083, -0.00024514061472057243, -0.0010388078807092493, -0.002347789145124328, 0.0015699081284962903, 0.006637305076991413, -0.0065889956256015665, 0.004431008123472802, 0.018699643885866108, 0.00011441653968779518, -3.5915096107962474e-05, -0.00020665341614637233, 0.00018052618129035623, -0.00011952026062843605, -0.0005069223755318703], [1.1585252804108553e-35, -5.153360479774482e-36, -2.5621520547815174e-35, 6.80547915803146e-21, -3.0272181308370544e-21, -1.5050748311974188e-20, 6.6628594348229e-07, -2.963777923044722e-07, -1.4735335758575614e-06, -3.7507080092567193e-06, 1.6683926326771683e-06, 8.294928384639644e-06, 2.967036511898902e-31, -1.319799313921339e-31, -6.561789219547814e-31, 1.7429145038324892e-16, -7.752844823973806e-17, -3.854565845744214e-16, 0.017063889369561863, -0.0075903715348497654, -0.03773787240558324, -0.018746040132396204, 0.008338627046299524, 0.041458055388487056, 6.421887830149501e-31, -2.8565887606441097e-31, -1.4202411788337353e-30, 3.7723841268099327e-16, -1.6780346188679268e-16, -8.34286649187624e-16, 0.036933277712607016, -0.016428687139670068, -0.08168028353046707, -0.03627942795725075, 0.016137841221506907, 0.08023425337253182, 1.7352095366607649e-31, -7.718571533617429e-32, -3.8375258227038397e-31, 1.0193072638324023e-16, -4.534089897734565e-17, -2.25426259110698e-16, 0.00997946046428599, -0.004439070776935067, -0.022070209055009657, -0.008948075034742802, 0.003980289168808387, 0.019789234835233767, 3.823056103106435e-06, -1.1581130743252835e-06, -6.784339517261772e-06, -3.9756864083530066e-05, 3.1724202182253446e-05, 0.0001271844806197478, -8.17985880134472e-05, 5.6593553059198283e-05, 0.00023670665254750097, -2.6927286141764767e-06, 1.7508010773447469e-06, 7.469278243205106e-06, 0.00020759368401919098, -0.00011587350339990118, -0.0005208675310280503, -0.0002983821219811863, 0.00027357547752314957, 0.0010566371025747764, -0.0014342573233312617, 0.0009735767062981097, 0.00409650505331688, -5.782094697269628e-05, 3.735935160803612e-05, 0.0001597098443934532, 0.001531435424903199, -0.0009635514812415159, -0.0041553978062254275, 0.0016168785896750698, -0.0009556456270897128, -0.004209793847568979, -0.004408619023502966, 0.0028735068241020852, 0.012249195134430428, -0.00024514061472057243, 0.00015716796062264683, 0.0006735957222193128, 0.0012956109692727473, -0.0008630958531455397, -0.0036534069787970487, 0.00305043852950059, -0.002118992379243134, -0.008851744945199826, -0.0010098636227061702, 0.0005322880846242876, 0.0024434880138689504, -0.000127448419547894, 8.077399609702102e-05, 0.00034750416612234434], [5.267187972931716e-35, -2.3429543401611067e-35, -1.1648719899302975e-34, 3.0940833641980224e-20, -1.3763123860819947e-20, -6.842761382327274e-20, 3.029241888272648e-06, -1.347469554152979e-06, -6.6993603503546715e-06, -1.7052441108000308e-05, 7.58527911091298e-06, 3.771255384984731e-05, 1.3489510582955022e-30, -6.0004137937367285e-31, -2.983290726798662e-30, 7.924089761061651e-16, -3.5247993033314663e-16, -1.7524626528975879e-15, 0.07758027759818872, -0.03450931484573699, -0.1715736989254371, -0.08522810748716346, 0.03791122803419184, 0.18848735924513868, 2.919685130261838e-30, -1.2987364383054847e-30, -6.457068639160374e-30, 1.7150990693069052e-15, -7.629116008180449e-16, -3.793050250073232e-15, 0.1679156419442152, -0.07469235654697184, -0.3713560802788481, -0.16494294067843396, 0.07337003743315675, 0.36478176309720495, 7.889059441823086e-31, -3.50921709154806e-31, -1.7447154758670693e-30, 4.634238934238848e-16, -2.0614054938075502e-16, -1.0248913000411828e-15, 0.0453712102986598, -0.020182054377763024, -0.10034130602088354, -0.040682058476249554, 0.018096222493567845, 0.08997094968933228, -4.300333658000154e-05, 2.7403423746238326e-05, 0.00011768236117867467, -0.00045395450254940976, 0.00029203759472429817, 0.0012502275683036732, -0.0005366397440221724, 0.000346429428708317, 0.001481399179617919, -1.2528020526603838e-05, 8.114479676555863e-06, 3.4661351347135236e-05, 9.113109472081487e-05, -6.550286324363812e-05, -0.00027076998784118686, -0.005031587881602137, 0.003232015105249658, 0.013843297567592472, -0.008551581625567038, 0.005525004335546386, 0.023619685833835922, -0.00025822670968690464, 0.00016733497908697753, 0.0007146672670210152, 0.0056515061704729835, -0.003671427757805792, -0.01566745329069224, 0.003143245950093768, -0.0020683270224713945, -0.008789746826530137, -0.020833657191921623, 0.013491706981215702, 0.05763373823819099, -0.0010388078807092493, 0.0006735957222193128, 0.0028762434105744916, 0.006975474551615665, -0.004511043475303577, -0.01927889822711099, 0.0204016902927533, -0.013168329459269927, -0.056313180336807024, 0.0009940869140965677, -0.0006017269074005933, -0.0026290581533866034, -0.000497148080587949, 0.00032271543532149234, 0.0013775040447058964], [1.4147634616356087e-34, -6.293160999332105e-35, -3.12883902626103e-34, 8.310688954746922e-20, -3.696766634553087e-20, -1.837961513839692e-19, 8.136525147779757e-06, -3.619294964749443e-06, -1.7994440845323887e-05, -4.580275231351541e-05, 2.037401320700244e-05, 0.00010129568852662811, 3.6232742757971506e-30, -1.611707467760631e-30, -8.013100609663399e-30, 2.1284056536966505e-15, -9.467589327700372e-16, -4.707103946055914e-15, 0.2083801501930712, -0.09269180819201589, -0.4608459038576332, -0.22892217440661725, 0.10182932616824136, 0.5062758918242692, 7.842256367160036e-30, -3.4883981142345094e-30, -1.73436467938937e-29, 4.606745589506806e-15, -2.049175884441695e-15, -1.0188109726724925e-14, 0.4510203852237628, -0.20062321194756594, -0.9974601558453726, -0.4430357278414968, 0.19707147091143448, 0.979801580184905, 2.118996531416823e-30, -9.425735602342702e-31, -4.686295076029011e-30, 1.2447537377332296e-15, -5.536922523443874e-16, -2.752851751063338e-15, 0.12186679281354988, -0.05420887437687097, -0.2695161330498874, -0.10927175975511216, 0.048606342718538316, 0.24166141949605544, -4.9107678581581614e-05, 2.75109124862631e-05, 0.0001653143233807049, -0.0007941162570801417, 0.00044021021410734873, 0.002452986163896757, -0.0010585294904739205, 0.0005854617359957351, 0.0032072773179421467, -2.7406889129528102e-05, 1.5132059493351047e-05, 8.179445770061181e-05, 0.000846410319206056, -0.0004616088149105673, -0.0022562044215250865, -0.008312236173700626, 0.004613213021330446, 0.02593148870665582, -0.017318150510265758, 0.009574080776180289, 0.052264732381521545, -0.0005728887236486062, 0.0003162363325091858, 0.001706428946286546, 0.013453536032906473, -0.0074184186532563, -0.0396967695253079, 0.010115849774834151, -0.005556604788671595, -0.028839123870168897, -0.04533820823664335, 0.0250345161469001, 0.13540902601285418, -0.002347789145124328, 0.0012956109692727473, 0.006975474551615665, 0.014558910918989233, -0.008044547858703684, -0.04374267616468753, 0.04003840498145758, -0.02214682952195515, -0.12140829389146775, -0.00203622031735135, 0.0010870483548898566, 0.004320743986209707, -0.0011584586053942723, 0.0006389891143319989, 0.0034278010250935248], [-7.65401372511791e-35, 3.404663886892987e-35, 1.6927336265102569e-34, -4.496166960042853e-20, 1.999988218999895e-20, 9.943558082072411e-20, -4.401942575183187e-06, 1.9580752603983664e-06, 9.735174885468277e-06, 2.4779753249389357e-05, -1.1022547652018419e-05, -5.4801994206277735e-05, -1.9602281080086978e-30, 8.719500760115203e-31, 4.335168649055155e-30, -1.1514890317550941e-15, 5.122061787927547e-16, 2.5465909451051552e-15, -0.1127357733550726, 0.05014720773799702, 0.24932230503131292, 0.12384921666455793, -0.055090697579237714, -0.2739003889907737, -4.242740182216865e-30, 1.887258737524802e-30, 9.38308870732278e-30, -2.49229605699933e-15, 1.1086249235306519e-15, 5.511870626854276e-15, -0.24400659986084566, 0.10853919114143883, 0.5396360543742343, 0.23968681928610752, -0.10661766324113622, -0.5300825859580375, -1.1463986012326763e-30, 5.099418498287838e-31, 2.5353331355059466e-30, -6.734243886951513e-16, 2.995531206351538e-16, 1.4893206996945065e-15, -0.06593117013020931, 0.029327550488480892, 0.14581095974302635, 0.05911712958479226, -0.026296524075153108, -0.13074127738045127, -3.455623762682382e-05, 1.8185015352095462e-05, 6.090876256391465e-05, 0.00020603573051012806, -0.00011719415691467504, -0.000777132341374516, 0.0004915190671545163, -0.00027283445183105376, -0.001535551418000637, 1.7054437814253428e-05, -9.391444989603605e-06, -4.972942039828226e-05, -0.0014636203041491795, 0.0007938309659039659, 0.003694339378818092, 0.0012699274584047065, -0.0007499138736880137, -0.006091620823151431, 0.008764257850081706, -0.0048523435322226655, -0.026787551963188893, 0.00036804522056407244, -0.0002025233285351454, -0.0010661190642724013, -0.009950080216878864, 0.005458792007296237, 0.028047590110278905, -0.010985626560677602, 0.005988686859915326, 0.02916210643293281, 0.02786720408912428, -0.015350237498188599, -0.08146997270710582, 0.0015699081284962903, -0.0008630958531455397, -0.004511043475303577, -0.008044547858703684, 0.004443087584160677, 0.024078530026362573, -0.018263529776411682, 0.010143494460620664, 0.057325976275774744, 0.007364511268300861, -0.003976394089488052, -0.01774228828673406, 0.0008234977039970025, -0.00045214866424564604, -0.00233844148720146], [-3.4798661470121845e-34, 1.5479165608330956e-34, 7.695944447383997e-34, -2.0441639847368807e-19, 9.092864930306499e-20, 4.520798158108886e-19, -2.001325252161817e-05, 8.902309372142359e-06, 4.426057587016202e-05, 0.00011266013827606093, -5.011356368778478e-05, -0.0002491550332622979, -8.912097206065734e-30, 3.964285485195478e-30, 1.970966758777687e-29, -5.2351979551730705e-15, 2.3287245174673617e-15, 1.1577971948335742e-14, -0.5125485991332107, 0.2279922362850937, 1.1335336989615155, 0.5630754162233138, -0.25046761138166385, -1.2452769560297323, -1.9289445330119693e-29, 8.580344936949195e-30, 4.2659830410118386e-29, -1.1331122452292585e-14, 5.040318034011438e-15, 2.505949517461251e-14, -1.1093660620398536, 0.4934690091261355, 2.453433328923376, 1.0897263557048347, -0.4847328608372201, -2.409998874110504, -5.212054520257938e-30, 2.318429838112969e-30, 1.1526788775792905e-29, -3.0616965385132377e-15, 1.3619060550013192e-15, 6.771135865492028e-15, -0.2997533780428148, 0.13333651308298786, 0.6629235861022673, 0.2687736204019963, -0.1195560750210263, -0.5944098893895745, 0.0002418343121570425, -0.00013315468789913237, -0.0007043527266951224, 0.002741690072871398, -0.001509318501275173, -0.007972818168081467, 0.0033230952981821256, -0.0018292790730938307, -0.009658496999038877, 7.942443801594275e-05, -4.371877919162221e-05, -0.00023073452385826695, -0.0010208664404739247, 0.0005613808548490564, 0.002939740998223201, 0.030053285394356925, -0.016544969028160383, -0.08741539472787563, 0.053263129135730135, -0.02931960041420411, -0.1547895255728313, 0.0016425559389831451, -0.0009041298064723222, -0.00477143992340519, -0.036575590059504795, 0.020131921716513294, 0.10621136402566768, -0.0221459104021189, 0.012187350933528239, 0.06420571861197337, 0.13191672373780308, -0.07261309438819634, -0.38323849867216186, 0.006637305076991411, -0.0036534069787970487, -0.01927889822711099, -0.04374267616468753, 0.024078530026362573, 0.12710419463287884, -0.12619585143845885, 0.06946777022683188, 0.36679361201399113, -0.0034184770156066237, 0.0018852620504528387, 0.010099902102056637, 0.0032003281157593623, -0.001761544151248035, -0.009294372843732301], [4.089014923444495e-34, -1.818878557420342e-34, -9.043115558445294e-34, 2.4019938372438797e-19, -1.0684566252300215e-19, -5.312161546862767e-19, 2.3516562065992974e-05, -1.0460654041841351e-05, -5.2008366876045285e-05, -0.00013238123744606218, 5.8885917196061806e-05, 0.0002927694934862902, 1.0472155231050952e-29, -4.658231617235235e-30, -2.3159834745870097e-29, 6.151616660390425e-15, -2.7363665446416333e-15, -1.3604689973668926e-14, 0.6022699673795616, -0.2679021597999319, -1.3319581890414152, -0.6616414777731361, 0.29431183772929576, 1.463262045696518, 2.2666052798481384e-29, -1.0082329898122897e-29, -5.0127411747821635e-29, 1.3314629600504325e-14, -5.9226231094189915e-15, -2.9446146895895847e-14, 1.3035600197262214, -0.5798505049703196, -2.8829055693011014, -1.280482392914365, 0.5695850984237287, 2.83186793554786, 6.1244219791154014e-30, -2.7242697869694067e-30, -1.354454721313873e-29, 3.5976449403917686e-15, -1.6003070083633062e-15, -7.956419710694757e-15, 0.3522250524556391, -0.15667700101180948, -0.7789680183540753, -0.31582230419856444, 0.14048430436589274, 0.6984610343256549, -0.00010510313533907046, 3.7790609452328043e-05, 0.0004140815855788417, -0.0020709057362829574, 0.0009063407264276705, 0.006839662082555699, -0.002865730088563931, 0.0012918375533229726, 0.00915774753309817, -7.62991374170842e-05, 3.511831322042574e-05, 0.00023792012749144855, 0.002811185200775315, -0.0014462201978208, -0.0075236041916317735, -0.021246297163635828, 0.009144649081405878, 0.07142618918000218, -0.047235835665918, 0.02141417849852717, 0.1499616858893119, -0.0016004971191500683, 0.0007385415038457088, 0.004975435456343059, 0.03822005681455243, -0.017848189212144514, -0.11708690465920425, 0.030439089101219174, -0.014772814741999218, -0.08869663952445955, -0.12605121803466124, 0.057961636647803974, 0.3935176852025012, -0.0065889956256015665, 0.00305043852950059, 0.0204016902927533, 0.040038404981457595, -0.018263529776411682, -0.12619585143845885, 0.1082357526279191, -0.04873658466006841, -0.3463261410645767, -0.008628708164561277, 0.004962781336178002, 0.018821159602878636, -0.0032748988547924816, 0.0015240257887600352, 0.010075883925816773], [-2.2121985190424137e-34, 9.840317353632426e-35, 4.8924171763770875e-34, -1.2995030120906927e-19, 5.780458639177166e-20, 2.8739332398876704e-19, -1.2722698436995528e-05, 5.659319863788362e-06, 2.8137053626618698e-05, 7.161959124876159e-05, -3.18578780592583e-05, -0.0001583912634306531, -5.6655421237245704e-30, 2.520150519852759e-30, 1.2529705341090405e-29, -3.3280869648596827e-15, 1.4804020359295217e-15, 7.360275170242993e-15, -0.3258341568434421, 0.14493778385588185, 0.7206028807402155, 0.3579547457444328, -0.15922568729901998, -0.7916395980609461, -1.2262564302675456e-29, 5.454642667416835e-30, 2.711943783725483e-29, -7.20334956836549e-15, 3.2041991327501e-15, 1.593066393109005e-14, -0.7052391833023818, 0.3137050004407374, 1.5596811335613099, 0.6927539532868363, -0.30815131145087005, -1.5320692563932903, -3.3133743666499015e-30, 1.4738575674184674e-30, 7.32773732720085e-30, -1.946362377780433e-15, 8.65782311924731e-16, 4.304503708206565e-15, -0.19055732346303778, 0.08476384559495885, 0.4214295933976873, 0.17086306768479337, -0.07600343258349818, -0.3778744990352003, -0.00011980152565305681, 7.513158033615577e-05, 0.0002105131596863958, 0.00047415308639402876, -0.00014072367163757822, -0.0021108123081015526, 0.001315827856089947, -0.0005719972406421381, -0.004377488696803752, 4.771528069575328e-05, -2.248166927946097e-05, -0.0001445493622272088, -0.0044276112524767475, 0.002354991024482686, 0.011219977174459987, 0.002167415874603273, 9.867871113796954e-05, -0.015700738232511696, 0.02380635957478945, -0.010639219788206112, -0.07682953321799289, 0.0010338275936000352, -0.0004904169960538377, -0.0031048457373947292, -0.028398964944497174, 0.013833475541305698, 0.08233769139582557, -0.03240134826661498, 0.016612423471725535, 0.08717708243177832, 0.07784486562944777, -0.03657851528539292, -0.23663267594992765, 0.0044310081234728, -0.002118992379243134, -0.013168329459269927, -0.02214682952195515, 0.010143494460620664, 0.06946777022683188, -0.04873658466006841, 0.021054237230100248, 0.16321175554469394, 0.022769529221786305, -0.0124779075354235, -0.05470587955097799, 0.002340437930386108, -0.0011321774538303147, -0.006849937418068725], [-1.0057670411046459e-33, 4.473860181670174e-34, 2.224317530717951e-33, -5.908137484617728e-19, 2.6280619626621943e-19, 1.3066220351080037e-18, -5.7843229943860016e-05, 2.5729867121197718e-05, 0.00012792396761795527, 0.00032561555283280646, -0.000144840544262739, -0.0007201194241212679, -2.5758156372416153e-29, 1.1457761632476925e-29, 5.696579469855418e-29, -1.5131011753116938e-14, 6.730587524155113e-15, 3.346319110138307e-14, -1.481391715066837, 0.6589537275167127, 3.2761916298872404, 1.6274266634650139, -0.7239130982327474, -3.5991571701606557, -5.575124885444733e-29, 2.4799310589294356e-29, 1.2329741890345339e-28, -3.2749735247781724e-14, 1.456776077334655e-14, 7.242811432556496e-14, -3.206341205617153, 1.4262469997927107, 7.0910267106033755, 3.1495776161736453, -1.400997379134922, -6.965490436351437, -1.506412152495234e-29, 6.700833364782404e-30, 3.331525912403688e-29, -8.849057228665909e-15, 3.936243997135508e-15, 1.9570250683925565e-14, -0.8663611051651999, 0.3853753695377929, 1.9160124714711442, 0.7768219738877, -0.3455465088024308, -1.7179910099932902, 0.0006083703258791713, -0.0002822253251428149, -0.001879028117336647, 0.007372488115399004, -0.003462120117781785, -0.02242831081689673, 0.009128170894004467, -0.0043024789545467075, -0.027639769382036144, 0.00022238985410090806, -0.00010516281122271228, -0.000670603558463935, -0.0038479720798869784, 0.0018981534046877543, 0.01096269469187375, 0.08002812765634039, -0.03751623883678321, -0.24398853518613275, 0.1470124660721777, -0.06934997417676055, -0.44468339675176033, 0.004611389608698357, -0.0021815837969470587, -0.01389747408372055, -0.10407929533365454, 0.04934890521905511, 0.3127657704291973, -0.06696315917311232, 0.03205848851926192, 0.1987160254020301, 0.36900448529336033, -0.17446439505585987, -1.1129474994761779, 0.018699643885866108, -0.008851744945199826, -0.056313180336807024, -0.12140829389146775, 0.057325976275774744, 0.36679361201399113, -0.3463261410645767, 0.16321175554469394, 1.048873965561644, -0.003132033766999199, 0.0009699317261710973, 0.013613691431222713, 0.009069363603870801, -0.004297286669400388, -0.027277961820627406], [1.226542596248964e-35, -5.455915592992331e-36, -2.7125766579231337e-35, 7.205030581853073e-21, -3.204946882377955e-21, -1.5934381598916688e-20, 7.054037618179031e-07, -3.137782083743102e-07, -1.5600451093750843e-06, -3.970913036799723e-06, 1.7663443913116735e-06, 8.781925753909342e-06, 3.14123198518323e-31, -1.397285069558947e-31, -6.947033544687445e-31, 1.84524146060287e-16, -8.208016328603437e-17, -4.080868393458834e-16, 0.01806571468343367, -0.00803600419107577, -0.03995347255680178, -0.019846624948246638, 0.008828189975183745, 0.043892068435135885, 6.798918508897641e-31, -3.0242998181735723e-31, -1.5036239020771708e-30, 3.9938617647643707e-16, -1.7765524609803953e-16, -8.832678319695723e-16, 0.039101639903395026, -0.01739321956798974, -0.08647575388970496, -0.038409402461492145, 0.017085298011503946, 0.08494482693096031, 1.8370841328357378e-31, -8.171730844595008e-32, -4.062827946302885e-31, 1.0791510542722445e-16, -4.8002874765247497e-17, -2.3866109250052106e-16, 0.01056535714325405, -0.004699689758814715, -0.02336595667941654, -0.009473418811069681, 0.004213972965009911, 0.0209510658791841, 5.5279538444549544e-05, -6.506083742921955e-05, -8.866909697550146e-05, 0.0002937177399997472, -0.0005534447874341826, -0.00019158477908947874, 0.00022132039035378256, -0.0005963246079748526, 9.688716664502811e-05, 2.3337265189818247e-06, -1.2617841211352723e-05, 9.538663609279032e-06, 0.0006631720051157155, -0.00022116290882379843, -0.0018163632574989175, 0.00377026044293632, -0.0063711604485712425, -0.003445582095364362, 0.003053777504081075, -0.009285023983431319, 0.0027589960802017074, 3.9714616470166696e-05, -0.0002562186310742792, 0.00021815506902529225, 9.30303910524705e-05, 0.005164825311429166, -0.007245985805314123, 0.0028197324644648625, 0.0015989659076339393, -0.01113971621961394, 0.004131588675497124, -0.021098369525265854, 0.01521857462875422, 0.00011441653968779497, -0.0010098636227061698, 0.0009940869140965677, -0.00203622031735135, 0.007364511268300861, -0.0034184770156066263, -0.008628708164561271, 0.022769529221786305, -0.003132033766999199, -0.004611524949523307, 0.003037849396965791, 0.010612297595893671, 1.8109396813352345e-05, -0.0004664339121937857, 0.0005698759182363894], [-6.635719765675748e-36, 2.951705635906758e-36, 1.4675314660851436e-35, -3.897994573569304e-21, 1.7339087480839075e-21, 8.620661952802581e-21, -3.816305849786374e-07, 1.6975719112531334e-07, 8.44000216485329e-07, 2.148304201309852e-06, -9.556102190223686e-07, -4.7511108447541084e-06, -1.6994383428997715e-31, 7.559453852407329e-32, 3.7584155614549756e-31, -9.982943331942349e-17, 4.4406200286294475e-17, 2.2077911637485124e-16, -0.009773734754303333, 0.004347559718745453, 0.021615233613846624, 0.01073722525852676, -0.004776140257388697, -0.023746053904866157, -3.6782838258275345e-31, 1.6361768553458745e-31, 8.134757714627888e-31, -2.160719695742564e-16, 9.611328881801533e-17, 4.778568497262664e-16, -0.021154383514343688, 0.009409908080568645, 0.046784259355730586, 0.020779876041890334, -0.009243319397476902, -0.04595601235387222, -9.938811361911308e-32, 4.420989213998289e-32, 2.198031098982685e-31, -5.838316584262048e-17, 2.5970041795788916e-17, 1.2911807006513602e-16, -0.005715965302902833, 0.002542579794658888, 0.01264121939635071, 0.00512521559751681, -0.0022798020860796604, -0.011334738996562111, -3.520599282040819e-05, 3.8065494605492944e-05, 6.10052247417117e-05, -0.000178288553258773, 0.0003099063309452773, 0.00015132844071692354, -0.00012677248088228824, 0.00032642415384338683, -3.511085707257213e-05, -1.0694949632396355e-06, 6.72192459724478e-06, -5.635415868680091e-06, -0.00044597321599232885, 0.0001668222868215201, 0.0011971315592717244, -0.0023195235764122053, 0.003598223199285556, 0.0025522506358637473, -0.001704578848026661, 0.005051670375708614, -0.0013636241074538578, -1.6448402026055166e-05, 0.00013589147939217552, -0.00013041500991510145, -0.00028194562010204575, -0.002668916653077624, 0.004489851251005532, -0.002003445540275238, -0.0006064854605763809, 0.007202283272736989, -0.0019457731822477152, 0.011257831959259503, -0.00894537774837421, -3.5915096107962474e-05, 0.0005322880846242874, -0.0006017269074005932, 0.0010870483548898562, -0.003976394089488052, 0.0018852620504528387, 0.004962781336178002, -0.0124779075354235, 0.000969931726171083, 0.003037849396965791, -0.0019372583210681925, -0.007076887542013034, 7.260915081208709e-06, 0.00024311677055070019, -0.0003502665728625164], [-3.016902948299702e-35, 1.3419809380050128e-35, 6.67207200288391e-35, -1.7722073470141347e-20, 7.883145459570628e-21, 3.919348824257753e-20, -1.7350679016598648e-06, 7.717941511788359e-07, 3.837212587926213e-06, 9.767177499419785e-06, -4.344642915914818e-06, -2.1600731829243683e-05, -7.726427167205378e-31, 3.4368748862529386e-31, 1.7087483179956607e-30, -4.538704501451879e-16, 2.0189097987453383e-16, 1.003763254981975e-15, -0.04443588674235438, 0.019766003081139003, 0.09827277871967208, 0.048816357053783226, -0.021714527033739953, -0.10796046633349494, -1.672316750960946e-30, 7.438811392195715e-31, 3.698434442622278e-30, -9.823624038877939e-16, 4.3697515061702234e-16, 2.1725566927366624e-15, -0.09617754252373391, 0.042781763597585815, 0.21270272851847621, 0.09447485956287544, -0.04202437493905244, -0.2089371372788461, -4.518640081132381e-31, 2.009984728876563e-31, 9.993258813122896e-31, -2.654366841601174e-16, 1.1807173664333216e-16, 5.87030043482567e-16, -0.025987403301607415, 0.011559735416301899, 0.05747278880615918, 0.02330158384144102, -0.010365027273470344, -0.0515329289127289, -0.00012547588398317298, 0.00015435144971366182, 0.00019228546748688348, -0.0006540991812518365, 0.001324317906709048, 0.0003031117272497461, -0.00048200397673055543, 0.0014330233457999551, -0.00039173031052284487, -4.698808607196378e-06, 3.047244337679012e-05, -2.6023608691226578e-05, -0.0015392040492865564, 0.0004942240819782985, 0.0042414141668667355, -0.008440675432476343, 0.015220379106429779, 0.006426213773590527, -0.006586617108480977, 0.022337920692687818, -0.009060715478082064, -7.744760005555637e-05, 0.0006192671952873973, -0.0005863699771970997, -0.0005308901421708172, -0.012540399999919872, 0.018565793883104618, -0.006698454085626575, -0.004061265871940616, 0.026816738971405168, -0.008393858913550056, 0.05093845653240013, -0.041782848930783656, -0.00020665341614637233, 0.0024434880138689504, -0.0026290581533866034, 0.004320743986209707, -0.01774228828673406, 0.010099902102056637, 0.01882115960287863, -0.05470587955097799, 0.013613691431222713, 0.010612297595893671, -0.007076887542013034, -0.024305867048982334, -1.4122586616008737e-05, 0.001130820483333732, -0.0014765380153372231], [-1.0315240059025793e-35, 4.588432497624764e-36, 2.2812806901740453e-35, -6.059440602530115e-21, 2.6953647243282876e-21, 1.3400836781993476e-20, -5.932455312962124e-07, 2.6388790365459445e-07, 1.312000076909415e-06, 3.3395433108782145e-06, -1.4854980560002784e-06, -7.385611605267758e-06, -2.641780408389346e-31, 1.1751186601649399e-31, 5.842464740377451e-31, -1.5518505994978456e-16, 6.902952991349851e-17, 3.432015916655072e-16, -0.015193290829637005, 0.006758290547738811, 0.033600925224732694, 0.016691038805231984, -0.007424519878820491, -0.03691328976101165, -5.717899792107779e-31, 2.543440295537539e-31, 1.2645497641784987e-30, -3.358843222575417e-16, 1.4940830565941554e-16, 7.428294582711759e-16, -0.0328845327947527, 0.014627721515082327, 0.07272622764064837, 0.03230236015656536, -0.014368759063699584, -0.07143871596836071, -1.5449902756562231e-31, 6.872436849525707e-32, 3.4168438758507086e-31, -9.07567516922132e-17, 4.037048352345779e-17, 2.0071430616605578e-16, -0.008885479850052174, 0.003952445533761035, 0.01965080161863823, 0.007967158214865546, -0.0035439570439100144, -0.017619875143119867, 5.330434199432386e-06, -3.988245034687656e-06, -1.5080734238585018e-05, 6.855671075035344e-05, -4.9485058344120806e-05, -0.00019073245212619192, 8.638130797799811e-05, -6.170601302654541e-05, -0.00023917212755869343, 2.1367062435976395e-06, -1.5127255271001867e-06, -5.891814360813049e-06, -4.43776829004794e-05, 2.8332346030180803e-05, 0.00011686532456028816, 0.0007380543349237426, -0.0005353737681249096, -0.0020580530279634053, 0.0013965779831820139, -0.0009953637808722687, -0.0038627826618593993, 4.4397253590316615e-05, -3.1393901627105796e-05, -0.00012235437969903965, -0.0010124640493722908, 0.0007115965858026072, 0.002782526635829008, -0.0006804597510967656, 0.0004662963255253429, 0.0018487676680173913, 0.0035426395386097894, -0.0025092225035381146, -0.009770602916050315, 0.00018052618129035623, -0.000127448419547894, -0.000497148080587949, -0.0011584586053942723, 0.0008234977039970027, 0.0032003281157593623, -0.0032748988547924816, 0.002340437930386108, 0.009069363603870801, 1.8109396813352375e-05, 7.260915081208653e-06, -1.4122586616008849e-05, 8.794909597533453e-05, -6.192739117970667e-05, -0.0002419105669764486], [5.580649425197336e-36, -2.4823884886732125e-36, -1.234195976000963e-35, 3.2782187832786858e-21, -1.4582196355535369e-21, -7.249988527330328e-21, 3.209518454524237e-07, -1.4276603059353584e-07, -7.098053397852659e-07, -1.8067267801457491e-06, 8.036695050151509e-07, 3.995690737570767e-06, 1.4292299775103786e-31, -6.357511059231217e-32, -3.160832642629011e-31, 8.395669035837937e-17, -3.734567535307465e-17, -1.8567553971553524e-16, 0.00821972433507063, -0.0036563036870435363, -0.01817844111901481, -0.009030021170749313, 0.004016740507929479, 0.01997046390662359, 3.0934417430490605e-31, -1.3760269797013183e-31, -6.84134239650711e-31, 1.817168227994082e-16, -8.083140773523324e-17, -4.0187826609943185e-16, 0.017790865553181476, -0.00791374560339612, -0.039345626292470966, -0.017475904255133637, 0.007773644292405082, 0.03864906942779578, 8.358553988505696e-32, -3.7180579932749323e-32, -1.848547169299341e-31, 4.910032255824795e-17, -2.184084077354965e-17, -1.0858847403695508e-16, 0.004807134660371571, -0.0021383130949829254, -0.010631282852381565, -0.004310313347806351, 0.001917316681613742, 0.009532531044050892, 1.5728174052242015e-06, -2.5340444118678945e-07, -2.8030715634122613e-06, -2.0787670288402517e-05, 1.7952259937298405e-05, 6.308997326674728e-05, -4.0815956192535566e-05, 3.018230954232156e-05, 0.00011484010641642745, -1.3183558542951521e-06, 9.062469691905872e-07, 3.5869246672632258e-06, 9.733605542354338e-05, -5.49988876359114e-05, -0.0002435870063099873, -0.00016400416952521874, 0.0001623479779530983, 0.0005346875776472705, -0.0007114487348334518, 0.0005146357138881462, 0.001981297956034439, -2.825599945252006e-05, 1.9276481599156428e-05, 7.661572885233908e-05, 0.0007425420437006955, -0.0004903636432551186, -0.0019844931626797364, 0.0007700852449057626, -0.0004697298582832489, -0.0019888697094537756, -0.002160038614378907, 0.0014892154564308628, 0.005884766843989985, -0.00011952026062843605, 8.077399609702102e-05, 0.00032271543532149234, 0.0006389891143319989, -0.00045214866424564604, -0.001761544151248035, 0.0015240257887600352, -0.0011321774538303147, -0.004297286669400388, -0.0004664339121937857, 0.00024311677055070019, 0.001130820483333732, -6.192739117970667e-05, 4.126469872363247e-05, 0.00016616274112564048], [2.537219517827303e-35, -1.1286078096670229e-35, -5.611221706554038e-35, 1.490428809788323e-20, -6.629736144865652e-21, -3.2961777373994566e-20, 1.4591944853009402e-06, -6.490799398169331e-07, -3.227101049977772e-06, -8.214209674718956e-06, 3.6538506518619828e-06, 1.816624509827158e-05, 6.497935846014878e-31, -2.890416493724472e-31, -1.4370596793365843e-30, 3.817056711494309e-16, -1.6979059100977744e-16, -8.441662743090444e-16, 0.03737064170334225, -0.016623235704405052, -0.08264754170471447, -0.04105462324397622, 0.018261947021346633, 0.09079490027660957, 1.4064206814869492e-30, -6.256050584707145e-31, -3.1103884394141925e-30, 8.261681291831382e-16, -3.67496701070841e-16, -1.8271231587030166e-15, 0.08088544518988006, -0.03597952186961939, -0.17888328644988558, -0.07945348648421573, 0.03534255696887741, 0.17571641905206836, 3.8001825064831033e-31, -1.6903999140955527e-31, -8.404344369660617e-31, 2.232326154800482e-16, -9.929849247688413e-17, -4.936930718021289e-16, 0.02185544182375797, -0.009721753341681271, -0.04833469422181346, -0.019596663973600353, 0.008717002154770266, 0.04333926390369049, -2.1936735113625108e-05, 1.4584531433719626e-05, 5.8801870870954386e-05, -0.00022611225944669532, 0.00015281721441158384, 0.0006105347805627315, -0.00026492660334118085, 0.00018015640500901136, 0.0007173124752282169, -6.131444586373636e-06, 4.194654348764508e-06, 1.6646242682623444e-05, 3.17935424873999e-05, -2.7835229158521596e-05, -9.716708273492239e-05, -0.0025158990457835404, 0.0016958374865769022, 0.006785211244506301, -0.004212809626151143, 0.0028690064036154786, 0.011414040789139556, -0.0001262229678127691, 8.642691113001886e-05, 0.00034281622090644176, 0.0027443752773934123, -0.001887736950659044, -0.007468976868223477, 0.001474239037993116, -0.001039022232970817, -0.004056734138011761, -0.010201097102276964, 0.0069765493771476285, 0.027690932197125425, -0.0005069223755318703, 0.00034750416612234434, 0.0013775040447058964, 0.0034278010250935248, -0.00233844148720146, -0.009294372843732301, 0.010075883925816773, -0.006849937418068725, -0.027277961820627406, 0.0005698759182363894, -0.0003502665728625164, -0.0014765380153372231, -0.0002419105669764486, 0.00016616274112564048, 0.0006579509029389509]]
}


@pytest.fixture
def element():
    nodes_a = []
    for ref_location, act_location in zip(DATA['ref_locations_a'], DATA['act_locations_a']):
        node = eq.Node()
        node.ref_location = ref_location
        node.act_location = act_location
        nodes_a.append(node)

    nodes_b = []
    for ref_location, act_location in zip(DATA['ref_locations_b'], DATA['act_locations_b']):
        node = eq.Node()
        node.ref_location = ref_location
        node.act_location = act_location
        nodes_b.append(node)

    shape_functions_a = DATA['shape_functions_a']
    shape_functions_b = DATA['shape_functions_b']

    axis = DATA['axis']

    weight = DATA['weight']

    return RotationCoupling(nodes_a, nodes_b, shape_functions_a, shape_functions_b, axis, weight=weight)


def test_element(element):
    f, g, h = element.compute_all()

    assert_almost_equal(f, DATA['exp_f'])
    assert_almost_equal(g, DATA['exp_g'])
    assert_almost_equal(h, DATA['exp_h'])
