from morphr.constraints.shell_3p import Shell3P
import pytest
import eqlib as eq
from numpy.testing import assert_almost_equal

if __name__ == '__main__':
    import sys
    pytest.main(sys.argv)


DATA = {
    "ref_locations": [[-5.913359216958488, 3.108050813957082, 0.0], [-6.05241561142299, 3.027766513268769, 8.213888137527034e-06], [-6.330525637306414, 2.8671995071385417, -0.02584166134527456], [-6.7369613697638036, 2.6325435700231465, -0.14110785709398277], [-5.787840608115579, 2.890646352252562, 0.0], [-5.9268969446106015, 2.8103620850064024, 8.21386002083427e-06], [-6.20500685140875, 2.6497951475771875, -0.025841639645896454], [-6.611442414432476, 2.4151393082075923, -0.14110773606036797], [-5.536803390496964, 2.4558374288844655, 0.0], [-5.675859611057076, 2.375553228529743, 8.213803787812274e-06], [-5.953969279692275, 2.214986428517099, -0.025841596247956726], [-6.360404503858186, 1.9803307846612714, -0.14110749399761124], [-5.160247563936306, 1.8036240434034463, 0.0], [-5.299303610604895, 1.7233399434048053, 8.213719439351623e-06], [-5.577412922016013, 1.5627733495555975, -0.025841531153239353], [-5.9838476379206, 1.3281179990290706, -0.14110713091549562]],
    "act_locations": [[-5.893714002015976, 3.0672770163682226, -1.0345997039865868], [-6.038328116081858, 2.9671135944731897, -1.0301056523745293], [-6.315441319551463, 2.7672811916471094, -1.0445211074708685], [-6.711022354939664, 2.469132745936724, -1.1401352442088788], [-5.761945573005222, 2.8477023374942716, -1.0026886850856505], [-5.896748485484654, 2.7584385676444394, -0.9932532278562874], [-6.167009459541683, 2.5640282347862096, -0.9978370290890177], [-6.55636240841509, 2.2769722543396016, -1.0601387134380749], [-5.505967727575608, 2.403226547865329, -0.952548449236662], [-5.641518976153392, 2.30919698947417, -0.9389890585147445], [-5.908037268537961, 2.119496685381821, -0.9300917221862073], [-6.305684302307734, 1.8285004705746841, -0.9599110900403799], [-5.158138651014222, 1.7350625616129978, -0.7036400650717224], [-5.294861415334098, 1.641716404275053, -0.6927569013850762], [-5.569378780794629, 1.4417593721067148, -0.6877700953192258], [-5.987039515181131, 1.13894710512742, -0.7131222126712982]],
    "shape_functions": [
        [0] * 16,
        [-0.0002057758855542885, -0.013456598878056817, -0.016788326275726555, -0.003042483725892914, -0.006880387540824241, -0.44993909278074795, -0.5613397829763048, -0.10172944737623972, 0.003720954800534205, 0.24332975683372143, 0.3035759174615171, 0.055015894573427565, 0.0033652086258443245, 0.22006593482508333, 0.27455219179051427, 0.04975603652870507],
        [-0.00031034739992949234, -0.0026170615346758704, 0.0018985554073798197, 0.0010288535272255433, -0.13031285915676616, -1.0988871543640675, 0.7971910944296983, 0.4320089190911354, -0.22163977154333733, -1.8690181415800353, 1.3558850077353033, 0.7347729053880694, -0.050274760177749664, -0.4239511626523524, 0.3075566858684021, 0.16666923696169994],
        [0.00595961433897457, 0.3897256445354424, 0.4862180509183496, 0.08811542513879514, 0.005819089627459984, 0.38053610966738544, 0.4747532735934729, 0.08603770769043004, -0.021617711390382457, -1.4136781385165278, -1.7636915578258217, -0.3196270297616405, 0.009839007423947894, 0.6434163843136995, 0.8027202333139984, 0.1454738969324152],
        [0.0134822708431158, 0.11369172879043458, -0.08247801727603363, -0.04469598235751677, 0.450797468717581, 3.801432573877082, -2.757761051200499, -1.494468991394164, -0.2437939716826483, -2.055837509260492, 1.491413697455982, 0.8082177834871581, -0.2204857678780485, -1.859286793407025, 1.3488253710205507, 0.7309471902645227],
        [0.013555808349572322, -0.0052192129101178665, -0.018412928515614862, 0.010076333076160411, 5.691995952327173, -2.191513629628873, -7.731469188606223, 4.230986865907925, 9.681106612676846, -3.727387944275899, -13.14989998489386, 7.196181316492914, 2.1959746205224144, -0.8454869524681178, -2.982804320264632, 1.6323166522103358],
    ],
    "weight": 1.9943651544314808,
    "Dm": [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.5]],
    "Db": [[0.08333333333333333, 0.0, 0.0], [0.0, 0.08333333333333333, 0.0], [0.0, 0.0, 0.041666666666666664]],
    "Tm": [[1.000000000451112, 7.769530180107423e-33, -1.7628987700503228e-16], [4.4288168392838355e-13, 0.26935200196719983, 6.907707816655674e-07], [1.330987128605191e-06, -9.149291794136884e-17, 1.037982662839236]],
    "exp_f": 0.04717821752006913,
    "exp_g": [-0.0001891728272670255, 0.00035538647167567276, 0.0015337546704024597, -0.0021224196562939584, 0.00884041287710583, 0.02796005370290392, -0.002355742901618423, 0.010007498164622475, 0.03349207718787988, -0.000551105194285649, 0.0018701870534105563, 0.007075775831446438, -0.0633032824300927, 0.09478174893158248, 0.45034388637355593, 0.0610166845704217, 0.2726693128760106, -0.17532464132458106, 0.1688491150086392, -0.05352241186823622, -0.5837666260444384, -0.02551622391961633, 0.01873516676534222, 0.34570362393044884, -0.1090762499604978, 0.1559961493829347, 0.761544583691326, -0.008202054421911596, 0.1464187586676697, -0.44144471497418575, 0.14166744547083726, -0.48010053065954045, -1.1291500326446076, -0.07054043834062981, -0.037735797528535266, 0.5689177451825949, -0.025171431620177775, 0.03476789690433093, 0.1734772899844543, -0.0332026687712669, -0.0032941729993496223, -0.028284520561933937, -0.007917311973066748, -0.15332732812300817, -0.15954899623278757, -0.02338514303317339, -0.016462276916015442, 0.14747074122752166],
    "exp_h": [[1.0461849846996551e-06, -9.66537405299872e-07, -6.468010357762554e-06, 1.9322854775227107e-05, -1.702829280304353e-05, -9.386986481914604e-05, 2.0643713068956186e-05, -1.986327551438799e-05, -0.00010007337573378476, 3.937870509242414e-06, -4.146831475066903e-06, -2.0646715217061623e-05, 0.0002951950422817043, -0.0002630519631320674, -0.0019185170947312409, 0.0004240904549077531, 0.0001714824549506264, 7.634781430023734e-05, -0.00041883851955820146, 0.00020493156554656416, 0.0035540206414905987, 7.382731280654077e-05, -0.0002706791427564495, -0.0009002513938781983, 0.0004903576400828009, -0.00043764317760762716, -0.003226358060446783, 0.00029115832752873636, 0.0005390778418185776, 7.682668377673815e-05, -0.0011508266761798011, 0.0005430103209508361, 0.005261933744199259, 5.913031682153688e-05, -0.0004402852215407231, -0.001768090719667271, 0.00011002588788071779, -9.846310424189067e-05, -0.0007310199566177435, 4.2365595280381546e-05, 0.00011119272201060106, -0.00033017204230360376, -0.0002745326130551155, 9.066926866225298e-05, 0.0006427548120546495, 1.3096607864821178e-05, -0.00010823662746290207, -0.0005164164620488858], [-9.66537405299872e-07, 1.4461868485940204e-06, 7.1843823817335455e-06, -1.3384108580295358e-05, 3.115847865883507e-05, 0.0001042541922858237, -1.4966168278960494e-05, 3.462242926852983e-05, 0.00011652149491372402, -3.255895545527781e-06, 6.57160643204114e-06, 2.4943786619242188e-05, -0.00028445915256699184, 0.0003812653825409476, 0.0020949763104871084, 0.0002746432772138307, 0.0006821776846774578, -0.0015849262250850892, 0.0004729578441333457, -0.00023950173162918628, -0.003308734308548034, -0.00022170594397570643, 0.00017341952725803483, 0.001585019488189624, -0.0004794036559238674, 0.0006257762410904135, 0.003523458853032203, 0.0003593863798639249, 0.00013738032892948086, -0.002401777061836908, 0.0005542597196357224, -0.0015488540573437538, -0.004416061753136097, -0.00043777007511935884, 0.00010594252915674866, 0.003027448292332853, -0.00010886297890125356, 0.0001391651932324947, 0.0007988437776384461, 8.93342168369638e-06, -7.529904675363764e-05, -9.72143390599144e-05, 1.6243583447272795e-05, -0.0004621388098736164, -0.0003051956439231579, -0.00012164970968053134, 6.8680575066160904e-06, 0.0008312587537084419], [-6.468010357762554e-06, 7.1843823817335455e-06, 4.7175158554199014e-05, -0.00010531512170733433, 0.00011461181017317969, 0.0007707863335017999, -0.00011807826701293828, 0.00012770451709894414, 0.0008635916006333871, -2.4426885548039184e-05, 2.6452447144974506e-05, 0.00017836188790320773, -0.0018390877713641215, 0.0020468443376051425, 0.013401330631936388, 0.00045026134005634965, -0.0005642656333313157, -0.00290387540638634, 0.002451786814111835, -0.002818412613891402, -0.017784641841853476, -0.0013177424400072353, 0.0014493692292742036, 0.009535343729449607, -0.003076500311938865, 0.003424258508276824, 0.022412477024723824, 0.0016753314251968787, -0.0018345751568463902, -0.01191741250327314, 0.004587258653372427, -0.005050497143838175, -0.03371786426320176, -0.0022608026548780994, 0.0025292612947524573, 0.016283780681146578, -0.0006946427351675109, 0.0007731565848536022, 0.005059454406676594, 0.00018791320195145486, -0.0001826026542450867, -0.001367342969352643, 0.0006835770014409054, -0.0007178235224024768, -0.005125541476245264, -0.0005930642381479451, 0.0006693336129937832, 0.004264377005787037], [1.9322854775227107e-05, -1.3384108580295358e-05, -0.00010531512170733433, 0.00129921564193447, -0.0011184626993230935, -0.006425449316412433, 0.0016098993258024641, -0.0014313542077864917, -0.007856123276240471, 0.0002890082051123233, -0.0002620538864387942, -0.0014009574837186352, -0.00020858229853359478, 0.0018795086684216442, -0.001564630167362593, 0.015292986881321339, 0.004676975208347545, -0.01564086748715355, 0.01854864675192262, -0.01397374713369561, 0.016463273826316918, 0.0027493726334881655, -0.004271207380275998, 0.00839764337202054, -0.0009451981784932083, 0.0034610993618721412, -0.002087660949477853, -0.009888820550604046, 0.02211961434118375, -0.009876720715917765, -0.012447849579428042, -0.0070074552829084156, 0.04279883575452529, -0.003191958864539585, -0.004348345227194121, 0.016159779004189714, -0.0002659317591376962, 0.0007759999557647077, -0.0007181686563468929, -0.005169708074364335, 0.003912673434993302, -0.021633853208403418, -0.0063453055431204825, -0.003116931234377098, -0.01547916163272831, -0.001345097446135613, -0.0012829298100031732, -0.0010306239415831845], [-1.702829280304353e-05, 3.115847865883507e-05, 0.00011461181017317969, -0.0011184626993230935, 0.001952739124729585, 0.00742040612079257, -0.0013716008905711385, 0.002370092093948389, 0.00920592358761959, -0.00024389502621755045, 0.0004182594566255418, 0.001659692112567099, 0.00018664350003398848, 0.0008195340705396117, -0.0016600566835717253, -0.006336551888520558, 0.03695192905233404, -0.013576714882634363, -0.0027333678719686084, 0.023880815256273617, -0.0017598368739391399, 0.00082916900881286, 0.0003340071156577279, 0.0009361397154524992, 0.0005337227116686296, 0.0004183070028320688, -0.0034026304818901712, 0.00016920316772500756, 0.002734019549839736, -0.03647142461895609, 0.0080741889881135, -0.03330590943795126, -0.012531145921768527, 0.003592222833805546, -0.012686052063735376, 0.0008125033869486308, 0.00010338966669746871, -2.9348421940590295e-06, -0.0004676151807754467, -0.0016400015742608026, -0.005174730199758426, 0.015624514021049475, -0.00041508284583501883, -0.014608628123709763, 0.028141187909097837, 0.00038745121264281734, -0.004132606534090268, 0.005954445979834542], [-9.386986481914604e-05, 0.0001042541922858237, 0.0007707863335017999, -0.006425449316412433, 0.00742040612079257, 0.04893149484402184, -0.007943819529215924, 0.009177421646490639, 0.06043054092879504, -0.0014205839415349635, 0.001637094949199748, 0.010858722285076923, 0.0032875933271284885, -0.005549950111340036, -0.0014107054387821481, -0.007634116128691614, 0.00785985374772355, 0.07182625277541092, -0.008918912117989508, 0.010506570605584117, 0.059648685484845095, 0.002422541007102095, -0.004493249668839802, 0.002138749403237572, 0.00639400552665396, -0.010309720686746876, -0.009181212992372057, 0.019672063492246122, -0.020711106023287542, -0.1694993624364286, 0.01978462567386013, -0.017979502332813296, -0.21807572321392107, 0.00968738680629695, -0.01325482569976985, -0.04838770329658267, 0.001252810185324742, -0.002098638356874536, -0.0007186430945330593, -0.011695299370441174, 0.014723378911837929, 0.0755656352301553, -0.01661629900938312, 0.02124146575167523, 0.10002513430072493, -0.0017526767401245902, 0.0017265469540823262, 0.017077348886850047], [2.0643713068956186e-05, -1.4966168278960494e-05, -0.00011807826701293828, 0.0016098993258024641, -0.0013716008905711385, -0.007943819529215924, 0.002042039956669493, -0.001774466985041809, -0.009874777649893307, 0.000371963870446344, -0.0003268649733840201, -0.0017787360651728222, -0.0012726051587651011, 0.0023931688737831086, -1.2720281431819376e-05, 0.014334053008821365, 0.005235993972698689, -0.017417171912083005, 0.02858540387392954, -0.01602972226664655, 0.015729170808536624, 0.005526585741637474, -0.0045930940885176965, 0.010369762482247956, -0.002826389358861328, 0.004263427150847784, -1.0377712552113768e-05, -0.021151428269846322, 0.02418963071473847, -0.01401232553396082, -0.008841511112910861, -0.007418776055381905, 0.05057401381616695, -0.001100558327155389, -0.004112618406792315, 0.022530457580892282, -0.0006936719566203669, 0.0009331600046148591, -0.0004224990762299681, -0.008602060151030634, 0.003703640695056142, -0.028222010844645165, -0.006858936913201831, -0.003780689603353154, -0.019062143802856046, -0.0011434282419838025, -0.001296221973771506, -0.00032874401278984135], [-1.986327551438799e-05, 3.462242926852983e-05, 0.00012770451709894414, -0.0014313542077864917, 0.002370092093948389, 0.009177421646490639, -0.001774466985041809, 0.0029271607940534973, 0.011572244434611455, -0.0003170714211433081, 0.0005228724342898456, 0.0021062863963347295, 0.0004692837858791249, 0.0001698999055688637, -0.0041981324793723875, -0.01125565982333732, 0.03944723192949828, -0.01800714883331821, -0.005319538318900769, 0.03200378765790105, 0.002596102763305403, 0.0014578566013421228, 0.001980274493234293, 0.0007863378209100794, 0.001014318559485508, -0.0007413085611061145, -0.007035081932079723, -0.0023612653258903256, -0.003416248401321425, -0.04128141085005005, 0.01266369945088515, -0.03444929983051458, -0.013998603260524942, 0.006516790699686837, -0.0128611072444438, -0.002678949972016737, 0.0001998222970941361, -0.0002593827882226273, -0.0010811288144496802, -0.002081388618649587, -0.007253328132601471, 0.02142466269329556, 0.0010704435418440147, -0.016046251485662487, 0.03439895818338734, 0.0011683930400471089, -0.004429015293890231, 0.006090737686377534], [-0.00010007337573378476, 0.00011652149491372402, 0.0008635916006333871, -0.007856123276240471, 0.00920592358761959, 0.06043054092879504, -0.009874777649893307, 0.011572244434611455, 0.0758120429999094, -0.001780646504209339, 0.002086039962448793, 0.013750351226320498, 0.007011857954795129, -0.008530462523441203, -0.01571020337413898, -0.007686514605683459, 0.007946350667300265, 0.0734887927994394, -0.015754764004884802, 0.01718928709349051, 0.10411616174743603, 0.0041690569184356825, -0.005449003000970708, 0.0018729394493876132, 0.012184151524214067, -0.014765580030504738, -0.029930469004891182, 0.02022367062943664, -0.022704325858272655, -0.19362703119373714, 0.019539160129032965, -0.02162697221880302, -0.2521711432741233, 0.016123810002671563, -0.01923821597363135, -0.07881715316102203, 0.0023993784979026915, -0.002912814770214253, -0.004230376911604437, -0.01655705233949666, 0.020216745314341634, 0.10564143872318568, -0.02116379937236842, 0.02581393000162349, 0.12420211288632493, -0.0008773345279784622, 0.00108033181948847, 0.014308404558084978], [3.937870509242414e-06, -3.255895545527781e-06, -2.4426885548039184e-05, 0.0002890082051123233, -0.00024389502621755045, -0.0014205839415349635, 0.000371963870446344, -0.0003170714211433081, -0.001780646504209339, 6.905417733774629e-05, -5.93835583628143e-05, -0.0003274233984677509, -8.218597818527174e-05, 0.0001068544120580768, -0.0018108852640362518, 0.0019013363188432096, 0.0009485064354821025, -0.0023885017817452314, 0.005421488005306295, -0.0021518840941333853, 0.005726979958524829, 0.0014426642852794435, -0.0009270603066213474, 0.0006735025202055231, -0.0002484225837603177, 0.0001969293740143655, -0.0031816475018091894, -0.005024095492379781, 0.003957920134725516, -0.002602985756979303, -0.001418467352252934, -0.0003400483439318873, 0.01392919001811541, 0.0004808841955312278, -0.000922760592778821, 0.0022186054129305676, -6.408919086202954e-05, 3.5256710651052405e-05, -0.0008147643826072221, -0.0018342983201926036, 0.000503136673137595, -0.005351477866204119, -0.0012435067079180507, -0.0005049582733596601, -0.002393205017233301, -6.527130281484242e-05, -0.0002782862279744053, -0.0004517296094016158], [-4.146831475066903e-06, 6.57160643204114e-06, 2.6452447144974506e-05, -0.0002620538864387942, 0.0004182594566255418, 0.001637094949199748, -0.0003268649733840201, 0.0005228724342898456, 0.002086039962448793, -5.93835583628143e-05, 9.516424381360705e-05, 0.00038809390882568447, -0.00020034856487022252, 0.00029111926441708247, 0.0012716502364908818, -0.0022581453798660683, 0.006000085671505424, -0.005056392131041539, -0.0007393852458836894, 0.005529717668008325, -0.002385995702040934, 7.585581522317003e-05, 0.0008544528107204903, 0.0018784745433733107, -0.0003106690994372129, 0.00033552462454961295, 0.002306056601411282, -0.0005131540059002918, -0.0018261988444033478, -0.008791614843523256, 0.0032910805152206878, -0.0060703866652973455, -0.007088364105082543, 0.0010060291622279215, -0.0014129970664658368, 0.0022756461567668414, -7.736185574523618e-05, 6.40380926257986e-05, 0.0006366176428350864, -0.00034483509254598416, -0.0014639199074188728, 0.0038681275241580523, 0.0005264548469611694, -0.002762590223826431, 0.0052496711181010645, 0.00019692815427645253, -0.0005817131655759338, 0.001698441690932547], [-2.0646715217061623e-05, 2.4943786619242188e-05, 0.00017836188790320773, -0.0014009574837186352, 0.001659692112567099, 0.010858722285076923, -0.0017787360651728222, 0.0021062863963347295, 0.013750351226320498, -0.0003274233984677509, 0.00038809390882568447, 0.0025452950055044957, -0.00034448610911436893, 0.0006000503769635246, 0.009925799918972036, -0.00038520153985834493, 0.0002927662987055449, 0.0055968961484866445, -0.000766193698585387, 0.00047042596898181775, 0.0030581742914384214, -0.0005840519776516751, 0.0007916979672468339, 0.011133852168727445, -0.0006372775959809321, 0.001083565013675485, 0.01699405736197247, 0.004415332161806307, -0.005258551059401091, -0.0423923314436147, 0.0074849351928617785, -0.009266100401448802, -0.07686499028407243, 0.0009257943306228899, -0.0008602522149121048, 0.00176963820787755, -0.00022616424861147315, 0.00034300592562205455, 0.0044317396116419615, -0.0029573640051397546, 0.0035505795405105607, 0.018431384141371288, -0.0028387841773392427, 0.0033444494491848753, 0.014727897525892245, -0.0005587746704335233, 0.0007293469305245457, 0.0058551519465018815], [0.0002951950422817043, -0.00028445915256699184, -0.0018390877713641215, -0.0002085822985335949, 0.00018664350003398848, 0.0032875933271284893, -0.0012726051587651011, 0.0004692837858791249, 0.007011857954795129, -8.218597818527172e-05, -0.00020034856487022252, -0.00034448610911436893, 0.12572662185021696, -0.11877190178243442, -0.7839491344544076, 0.09219775603870849, 0.05760819988983423, 0.18918056030544403, -0.29148074240357363, 0.1522718275487472, 1.3340947210461076, 0.01197130617080508, -0.09474302570181184, -0.4528829580410438, 0.2144596260853823, -0.2017459970538788, -1.3358541164540088, 0.2097147151430077, 0.10275173617865026, 0.07654705166739138, -0.426153695775899, 0.26127864869370687, 1.939098967068807, 0.033453415309474245, -0.16121198376920884, -0.8332624135227253, 0.04875959107300487, -0.045713073322038215, -0.30342984577531595, 0.05701003191605122, 0.024473612618367523, -0.023344232590322707, -0.08429804862336324, 0.060122803054841564, 0.3851321897552119, 0.009907601609387294, -0.03649196592325144, -0.1994466664065835], [-0.0002630519631320674, 0.0003812653825409476, 0.0020468443376051425, 0.0018795086684216442, 0.0008195340705396117, -0.005549950111340036, 0.0023931688737831086, 0.0001698999055688637, -0.008530462523441203, 0.0001068544120580768, 0.00029111926441708247, 0.0006000503769635246, -0.11877190178243442, 0.15487564430343984, 0.8777133074790053, 0.1702276501083635, 0.0792452607640542, -0.6363240629212978, 0.2107506008570936, -0.23686178708931324, -1.3222890649299783, -0.1019544342212138, 0.06933563627197858, 0.6808306436238656, -0.20394894623750595, 0.26224679928466144, 1.4966358078703186, 0.14822232247081776, 0.073041717490057, -0.7370089437173999, 0.17790967442383665, -0.4755731978976245, -1.7898968753296587, -0.20668922388733568, 0.10532296564478451, 1.2449326900528739, -0.046593075401096876, 0.05928745956865314, 0.34011512812377426, 0.009588513908256418, 0.006019892984344729, -0.11000244416117476, 0.009677595245572901, -0.12032919176108596, -0.33004242750866647, -0.05253525547548496, 0.02172698181298379, 0.29676975933855093], [-0.0019185170947312409, 0.0020949763104871084, 0.013401330631936388, -0.001564630167362593, -0.0016600566835717253, -0.0014107054387821481, -1.2720281431819376e-05, -0.0041981324793723875, -0.01571020337413898, -0.0018108852640362516, 0.0012716502364908818, 0.009925799918972036, -0.7839491344544076, 0.8777133074790052, 5.5572884777180755, 0.2921350997554479, -0.35262209401264905, -2.059234340738059, 1.0429527177648812, -1.1951466312453864, -7.521065834646681, -0.5884117224913245, 0.6551164465066978, 4.120346128404819, -1.3311840370106987, 1.4914775860432645, 9.440030556320853, 0.5491674899190806, -0.5972297250854987, -3.683312958313796, 1.8127871501786292, -2.0028460242165345, -12.842098587503854, -0.9972299603881553, 1.1232052775072625, 7.022221933512094, -0.30168616339097093, 0.33804746359486115, 2.13940538063807, 0.12732541201207867, -0.13788318262324695, -0.8605094653814997, 0.41033043927089935, -0.4529453233946507, -2.915488789591385, -0.22693053835789812, 0.25560446206284143, 1.596211277843376], [0.0004240904549077531, 0.0002746432772138307, 0.00045026134005634965, 0.015292986881321339, -0.006336551888520558, -0.007634116128691614, 0.014334053008821365, -0.01125565982333732, -0.007686514605683459, 0.0019013363188432096, -0.0022581453798660683, -0.00038520153985834493, 0.09219775603870849, 0.1702276501083635, 0.2921350997554479, 1.3209981594308953, 0.4149258460391668, -0.058124195881491314, -0.19394790995850533, -1.03950998194183, -0.35035495500684405, -0.3075872208434129, -0.30000893996778205, 0.22049125242631515, 0.14241044029788086, 0.30161213757712124, 0.5080313064437018, 1.4049193139679104, 1.3960742277468683, -0.06593039097289285, -1.3509897742872266, -0.9359195861905508, -0.7583573044498344, -0.7043346602786938, -0.36333292394476774, 0.31858114180236397, 0.03004786378989824, 0.07045338659363626, 0.11667336273980529, 0.18753718928448593, 0.4336470220876638, -0.034951402883715135, -0.46528573061400236, -0.07112864515613006, -0.2302388563335931, -0.1879178934918321, -0.057464479137249, 0.05730051329491392], [0.0001714824549506264, 0.0006821776846774578, -0.0005642656333313157, 0.004676975208347545, 0.03695192905233404, 0.00785985374772355, 0.005235993972698689, 0.03944723192949828, 0.007946350667300265, 0.0009485064354821024, 0.006000085671505424, 0.0002927662987055449, 0.05760819988983423, 0.0792452607640542, -0.35262209401264905, 0.4149258460391668, 2.573444931782623, -0.02967931103604187, 0.08872097395032176, 0.5941063321055683, 0.4193347727445238, -0.007617938631762326, -0.3511830220968656, -0.24168676113664053, 0.09253359070590961, 0.0929056509677731, -0.6117771957464037, 0.23162726469439496, 1.756211680468513, -0.015551493546423361, -0.4749850453861052, -2.224791101703875, 0.9967361093273777, -0.13094726177445196, -1.179055428859941, -0.32786543310241506, 0.019982191778712893, 0.014154090465145083, -0.14027861532795902, -0.03259013578325165, -0.03490570360184998, 0.03209939060845714, -0.2195745980387456, -1.039571847170271, 0.3097610418629734, -0.05071604551550229, -0.363642267458889, -0.05400511571519754], [7.634781430023734e-05, -0.0015849262250850892, -0.00290387540638634, -0.01564086748715355, -0.013576714882634363, 0.07182625277541092, -0.017417171912083005, -0.01800714883331821, 0.0734887927994394, -0.0023885017817452314, -0.005056392131041539, 0.0055968961484866445, 0.18918056030544403, -0.6363240629212978, -2.059234340738059, -0.058124195881491314, -0.02967931103604187, 1.4884565589703513, -0.29221467474699364, 0.6133006131657411, 2.756735913039788, 0.12363231605214893, -0.4959621867711639, -1.7254571269755452, 0.33577339172876847, -1.0871065456823548, -3.6007727759210892, 0.08698360142500826, 0.36359683797081055, 1.1908578921271502, -0.4784711677689585, 1.7728986597478158, 4.503369749828115, 0.18534630184320203, -0.6830193599673599, -2.771049496473017, 0.07773039405236597, -0.24783962222587474, -0.8300108261169374, 0.0027952402007855245, 0.12002302273928928, 0.23640638670470518, -0.16453092391715474, 0.4838407728685343, 1.2225681686923817, 0.027269350073556665, -0.13550363581601937, -0.5598781694547956], [-0.00041883851955820146, 0.0004729578441333457, 0.002451786814111835, 0.01854864675192262, -0.0027333678719686084, -0.008918912117989508, 0.02858540387392954, -0.005319538318900769, -0.015754764004884802, 0.005421488005306295, -0.0007393852458836894, -0.000766193698585387, -0.29148074240357363, 0.2107506008570936, 1.0429527177648812, -0.19394790995850533, 0.08872097395032176, -0.29221467474699364, 1.920806086020599, -0.56215296099372, -1.5563068078254338, 0.4329772431200583, 0.009549902700044117, 0.6947507921980807, -0.5199799080078712, 0.3604487215115822, 1.7670368990831087, -1.995643571033247, 0.36716425675879544, -0.44582403260261627, 1.164856766268676, -0.6613135237365348, -2.437431042625932, 0.3522935929132994, 0.0729860749627031, 1.2389586058083006, -0.12198592103288014, 0.08207174120895255, 0.3992838840454274, -0.7301387814510569, 0.11760167377441355, -0.11993983881088874, -0.08584458959619139, -0.10310532528100871, -0.5525350487023832, 0.015951035049092167, 0.02559719787997702, 0.2842566294217974], [0.00020493156554656416, -0.00023950173162918628, -0.002818412613891402, -0.01397374713369561, 0.023880815256273617, 0.010506570605584117, -0.01602972226664655, 0.03200378765790105, 0.01718928709349051, -0.0021518840941333853, 0.005529717668008325, 0.00047042596898181775, 0.1522718275487472, -0.23686178708931324, -1.1951466312453864, -1.03950998194183, 0.5941063321055683, 0.6133006131657411, -0.56215296099372, 1.5173327623879582, 1.5931739773931741, 0.23362133408012098, 0.1413698179551342, -0.9392401353077691, 0.2739519266507254, -0.42887109187318717, -2.023861977468104, -0.6930145381797929, -0.791332487873797, 1.0355121075141995, 0.41322860747716633, 0.30333438215106484, 2.5284421616567703, 0.6492493973466128, -0.1761850678058798, -1.6531189560799366, 0.06468000319620922, -0.10151431602043005, -0.4571335030586385, 0.024623525714865677, -0.4728124454028749, 0.26568289452951993, 0.32517689156584406, -0.3019475907980721, 0.583870045801683, 0.1898243894639806, -0.10779332658672498, -0.3768284679554181], [0.0035540206414905987, -0.003308734308548034, -0.017784641841853476, 0.016463273826316918, -0.0017598368739391399, 0.05964868548484509, 0.015729170808536624, 0.002596102763305403, 0.10411616174743603, 0.005726979958524829, -0.002385995702040934, 0.0030581742914384214, 1.3340947210461076, -1.3222890649299783, -7.521065834646681, -0.35035495500684405, 0.4193347727445238, 2.756735913039788, -1.5563068078254338, 1.5931739773931741, 10.41936468577307, 1.0451907564076708, -1.0356142306020257, -5.47854213179251, 2.251522526525549, -2.233356510584812, -12.733290726337987, -1.145142112189626, 1.1098628357179494, 4.885073403567656, -3.157581960554056, 3.021875664302625, 16.901667780859157, 1.7083247707097209, -1.7290584174816865, -9.607858471940835, 0.508424829115905, -0.5039238441675532, -2.8756638792805864, -0.31176827837366633, 0.3241482463868545, 1.3387882856691018, -0.7525784122501401, 0.7459129259507988, 3.9475802113901204, 0.38470147715994457, -0.3852078906086473, -2.1818276159821592], [7.382731280654077e-05, -0.00022170594397570643, -0.0013177424400072353, 0.0027493726334881655, 0.00082916900881286, 0.0024225410071020944, 0.005526585741637474, 0.0014578566013421228, 0.0041690569184356825, 0.0014426642852794435, 7.585581522317003e-05, -0.0005840519776516751, 0.01197130617080508, -0.1019544342212138, -0.5884117224913245, -0.3075872208434129, -0.007617938631762326, 0.12363231605214893, 0.43297724312005836, 0.23362133408012098, 1.0451907564076708, 0.25525041101477336, -0.028080932970832247, -0.318770478752165, 0.01573344199934323, -0.1754760737843626, -1.0091019203745553, -0.8679976628129248, -0.10487618594593677, -0.061589324106791944, 0.293862957612142, 0.2953454710504784, 1.517922696885554, 0.35229874575612524, -0.06456593813118855, -0.5787189900817369, 0.002771175366606368, -0.04015703351997365, -0.2303209565248962, -0.25595243241265947, -0.03982195028775898, -0.06274262754876636, -0.00904594429844617, 0.0490628232571547, 0.2964450264006203, 0.06592552935437829, -0.01762031637612752, -0.13822457937363686], [-0.0002706791427564495, 0.00017341952725803483, 0.0014493692292742036, -0.004271207380275998, 0.0003340071156577279, -0.004493249668839802, -0.0045930940885176965, 0.001980274493234293, -0.005449003000970708, -0.0009270603066213474, 0.0008544528107204903, 0.0007916979672468339, -0.09474302570181184, 0.06933563627197858, 0.6551164465066978, -0.30000893996778205, -0.3511830220968656, -0.4959621867711639, 0.009549902700044117, 0.1413698179551342, -1.0356142306020257, -0.028080932970832247, 0.22349307690361933, 0.4953834243624852, -0.15636859876429463, 0.11766576731828572, 1.1250425769300807, -0.14836678635333048, -0.6655980375438475, -0.45763500612309294, 0.482278994094943, 0.14030039352789306, -1.3735539832791004, 0.03862500987668744, 0.35999305051041813, 0.9004355712413108, -0.03464046340583311, 0.026665527056707432, 0.2570383326753649, 0.028678610798248523, -0.1609550724450424, -0.0356165685269085, 0.18953792948921475, 0.016935319707925462, -0.24179461920130177, 0.02360034112291783, 0.07863538888692286, 0.21486142826094337], [-0.0009002513938781983, 0.001585019488189624, 0.009535343729449607, 0.00839764337202054, 0.0009361397154524992, 0.002138749403237572, 0.010369762482247956, 0.0007863378209100794, 0.0018729394493876132, 0.0006735025202055231, 0.0018784745433733107, 0.011133852168727445, -0.4528829580410438, 0.6808306436238656, 4.120346128404819, 0.22049125242631515, -0.24168676113664053, -1.7254571269755452, 0.6947507921980807, -0.9392401353077691, -5.47854213179251, -0.318770478752165, 0.4953834243624852, 3.1428709627453286, -0.7779490114995132, 1.163502315476168, 7.041611702619995, 0.18175369539231395, -0.36671943906365684, -2.7233249358652323, 1.0306488885174008, -1.6347651852078988, -9.634613178373769, -0.5575889742150179, 0.8235246085221587, 5.21116045480623, -0.17741621157189, 0.2649342548078495, 1.6032337578043412, 0.029316893782750455, -0.06857464873793644, -0.5515304045192153, 0.23365382474077073, -0.36772785405949493, -2.1976874859415707, -0.12454836995859789, 0.18535280515294386, 1.1672513723363274], [0.0004903576400828009, -0.0004794036559238674, -0.003076500311938865, -0.0009451981784932083, 0.0005337227116686296, 0.0063940055266539595, -0.002826389358861328, 0.001014318559485508, 0.012184151524214067, -0.0002484225837603177, -0.0003106690994372129, -0.0006372775959809321, 0.2144596260853823, -0.20394894623750595, -1.3311840370106987, 0.14241044029788086, 0.09253359070590961, 0.33577339172876847, -0.5199799080078712, 0.2739519266507254, 2.251522526525549, 0.01573344199934323, -0.15636859876429463, -0.7779490114995132, 0.36684153632852623, -0.34712045302444317, -2.2714821411024944, 0.37441139639799154, 0.1498942975304658, 0.13322711723434288, -0.7206367428556286, 0.4589666645763314, 3.295995811796222, 0.05628272637241789, -0.26690710673417717, -1.418133688675216, 0.0835699938495361, -0.07876450976320826, -0.5164347868897287, 0.10775055449583212, 0.03356870403585283, -0.04057721819401432, -0.1351803031010901, 0.10395557489355026, 0.6614035374485748, 0.017866890618711644, -0.06051911238499913, -0.3370258805047406], [-0.00043764317760762716, 0.0006257762410904135, 0.003424258508276824, 0.0034610993618721412, 0.0004183070028320684, -0.010309720686746876, 0.004263427150847784, -0.0007413085611061145, -0.014765580030504738, 0.0001969293740143655, 0.00033552462454961295, 0.001083565013675485, -0.2017459970538788, 0.26224679928466144, 1.4914775860432645, 0.30161213757712124, 0.0929056509677731, -1.0871065456823548, 0.3604487215115822, -0.42887109187318717, -2.233356510584812, -0.1754760737843626, 0.11766576731828572, 1.163502315476168, -0.34712045302444317, 0.44561231798525325, 2.54683348705968, 0.25708840627950413, 0.12071702255403885, -1.2411192621846328, 0.2951754248831397, -0.7787587723208473, -3.05530518009641, -0.3558815162605277, 0.19082089398198898, 2.1116095893161657, -0.07941097072867861, 0.10099500794117885, 0.5793354220764666, 0.0150545127661359, 0.020351184505580905, -0.1830777023662162, 0.013207557256884581, -0.18587439957890017, -0.5726871860932807, -0.09043556213160371, 0.04155131992680754, 0.5004614642312606], [-0.003226358060446783, 0.003523458853032203, 0.022412477024723824, -0.002087660949477853, -0.0034026304818901712, -0.009181212992372057, -1.0377712552113768e-05, -0.007035081932079723, -0.029930469004891182, -0.0031816475018091894, 0.002306056601411282, 0.01699405736197247, -1.3358541164540088, 1.4966358078703186, 9.440030556320853, 0.5080313064437018, -0.6117771957464037, -3.6007727759210892, 1.7670368990831087, -2.023861977468104, -12.733290726337987, -1.009101920374555, 1.1250425769300807, 7.041611702619995, -2.2714821411024944, 2.54683348705968, 16.059547892685245, 0.9309261023992248, -1.0138193453895625, -6.20444567943398, 3.097353578076094, -3.426203554624842, -21.850812583782577, -1.69851884843018, 1.9141183651533433, 11.929048579245926, -0.5152838290538061, 0.5778268033504859, 3.643316854195908, 0.21322721579757206, -0.23138918550469056, -1.4261524350904407, 0.7065444239534983, -0.7817703154879563, -4.9951988323512, -0.3843726261138704, 0.4329727308171767, 2.6968225954599134], [0.00029115832752873636, 0.0003593863798639249, 0.0016753314251968787, -0.009888820550604046, 0.00016920316772500756, 0.019672063492246122, -0.021151428269846322, -0.0023612653258903256, 0.02022367062943664, -0.005024095492379781, -0.0005131540059002918, 0.004415332161806307, 0.2097147151430077, 0.14822232247081776, 0.5491674899190806, 1.4049193139679104, 0.23162726469439496, 0.08698360142500826, -1.995643571033247, -0.6930145381797929, -1.145142112189626, -0.8679976628129248, -0.14836678635333048, 0.18175369539231395, 0.37441139639799154, 0.25708840627950413, 0.9309261023992248, 3.5170399762348956, 0.7852828588997052, 0.31608973303265325, -1.9967583957511068, -0.6714541178143034, -1.629329685770964, -1.2242717987130027, -0.15789651189695453, 0.3812271382210498, 0.08785856130505271, 0.05937297854479671, 0.2118321875247337, 0.9842682888898993, 0.2579233601520345, 0.17623704799574222, -0.22175929542244907, -0.04964172185390252, -0.22141199302051442, -0.2360083422207263, -0.016797685158768096, 0.11568039736261158], [0.0005390778418185776, 0.00013738032892948086, -0.0018345751568463902, 0.02211961434118375, 0.0027340195498397352, -0.020711106023287542, 0.02418963071473847, -0.003416248401321425, -0.022704325858272655, 0.003957920134725516, -0.0018261988444033478, -0.005258551059401091, 0.10275173617865026, 0.073041717490057, -0.5972297250854987, 1.3960742277468683, 1.756211680468513, 0.36359683797081055, 0.36716425675879544, -0.791332487873797, 1.1098628357179494, -0.10487618594593677, -0.6655980375438475, -0.36671943906365684, 0.1498942975304658, 0.12071702255403888, -1.0138193453895625, 0.7852828588997052, 2.6803859995416057, 0.3087444653671283, -1.3473567699845668, -1.750901647513327, 1.373342467266894, -0.53428906004499, -1.2084362662550803, -0.73391442895758, 0.029896093680779556, 0.026522541536330418, -0.23103324140458356, -0.08422877105211628, 0.539212034411133, -0.07141853520935139, -0.6311637717062699, -0.48663835398476135, 0.11411954489074543, -0.17995515509385057, -0.2908131554639107, -0.20502287800548652], [7.682668377673815e-05, -0.002401777061836908, -0.01191741250327314, -0.009876720715917765, -0.03647142461895609, -0.1694993624364286, -0.01401232553396082, -0.04128141085005005, -0.19362703119373714, -0.002602985756979303, -0.008791614843523256, -0.04239233144361469, 0.07654705166739138, -0.7370089437173999, -3.683312958313796, -0.06593039097289285, -0.015551493546423361, 1.1908578921271502, -0.44582403260261627, 1.0355121075141995, 4.885073403567656, -0.061589324106791944, -0.45763500612309294, -2.7233249358652323, 0.13322711723434288, -1.2411192621846328, -6.20444567943398, 0.31608973303265325, 0.3087444653671282, 3.2481733550703247, -0.15688608497166076, 2.040347740637126, 9.040696825468299, 0.013136751537196324, -0.7462174561028684, -4.604469723069415, 0.030471788435086706, -0.28126497577709025, -1.40612353248594, 0.12573260283017193, 0.0091619139000821, 0.3736267064532889, 0.04279925036615316, 0.36413951114715043, 1.4679355677431578, 0.018640742874047173, -0.1901623737398128, -1.1672507836844594], [-0.0011508266761798011, 0.0005542597196357224, 0.004587258653372427, -0.012447849579428042, 0.0080741889881135, 0.01978462567386013, -0.008841511112910861, 0.01266369945088515, 0.019539160129032965, -0.001418467352252934, 0.0032910805152206878, 0.0074849351928617785, -0.426153695775899, 0.17790967442383665, 1.8127871501786292, -1.3509897742872266, -0.4749850453861052, -0.4784711677689585, 1.164856766268676, 0.41322860747716633, -3.157581960554056, 0.293862957612142, 0.482278994094943, 1.0306488885174008, -0.7206367428556286, 0.2951754248831397, 3.097353578076094, -1.9967583957511068, -1.3473567699845668, -0.15688608497166076, 2.364937737427763, 0.013888508217531525, -4.628668766039353, 0.5704291429789325, 0.6933131732544189, 1.8770893293869169, -0.1630826999633707, 0.06588351686596562, 0.7064694451721565, -0.42352107719233056, -0.3845738385824087, 0.17554989720292538, 0.5744574623334876, -0.09794496751174692, -0.799218082409425, 0.13645697392533152, 0.1385994935739713, 0.46953179356020375], [0.0005430103209508361, -0.0015488540573437538, -0.005050497143838175, -0.0070074552829084156, -0.03330590943795126, -0.017979502332813296, -0.007418776055381905, -0.03444929983051458, -0.02162697221880302, -0.00034004834393188706, -0.0060703866652973455, -0.009266100401448802, 0.26127864869370687, -0.4755731978976245, -2.0028460242165345, -0.9359195861905508, -2.224791101703875, 1.7728986597478158, -0.6613135237365348, 0.30333438215106484, 3.021875664302625, 0.29534547105047837, 0.14030039352789303, -1.6347651852078988, 0.4589666645763314, -0.7787587723208473, -3.426203554624842, -0.6714541178143034, -1.750901647513327, 2.040347740637126, 0.013888508217531525, 3.0710990447029634, 4.0148491961485, 0.7074162122734922, 0.7041749226502182, -2.9721549274743713, 0.10684762286329523, -0.17189122407041887, -0.7822606980900981, 0.021490741454473553, -0.07570702580086915, 0.1811194777308354, 0.21841002671486656, 1.1007206227091302, 0.5742291598424911, 0.1992666012584846, 0.233368053556799, -0.7331664366987459], [0.005261933744199259, -0.004416061753136097, -0.03371786426320176, 0.0427988357545253, -0.012531145921768527, -0.21807572321392107, 0.050574013816166954, -0.013998603260524942, -0.2521711432741233, 0.01392919001811541, -0.007088364105082543, -0.07686499028407243, 1.939098967068807, -1.7898968753296587, -12.842098587503854, -0.7583573044498344, 0.9967361093273777, 4.503369749828115, -2.437431042625932, 2.5284421616567703, 16.901667780859157, 1.517922696885554, -1.3735539832791004, -9.634613178373769, 3.295995811796222, -3.05530518009641, -21.850812583782577, -1.629329685770964, 1.373342467266894, 9.040696825468299, -4.628668766039353, 4.0148491961485, 31.037972232709613, 2.4863036318993172, -2.3725468737072886, -15.896289422682703, 0.7495071259536499, -0.6958676824166897, -4.969441628348622, -0.28036192623977874, 0.19140041604876026, 1.5183445647320104, -0.9483356358237565, 0.7798057894062153, 6.4690342142483415, 0.5810921540130622, -0.5593713699848575, -3.6970002461186917], [5.913031682153688e-05, -0.00043777007511935884, -0.0022608026548780994, -0.003191958864539585, 0.003592222833805546, 0.00968738680629695, -0.001100558327155389, 0.006516790699686837, 0.016123810002671563, 0.0004808841955312278, 0.0010060291622279215, 0.0009257943306228899, 0.033453415309474245, -0.20668922388733568, -0.9972299603881553, -0.7043346602786938, -0.13094726177445193, 0.18534630184320203, 0.3522935929132994, 0.6492493973466128, 1.7083247707097209, 0.35229874575612524, 0.03862500987668744, -0.5575889742150179, 0.05628272637241789, -0.3558815162605277, -1.69851884843018, -1.2242717987130027, -0.53428906004499, 0.013136751537196324, 0.5704291429789325, 0.7074162122734922, 2.4863036318993172, 0.5945275749334006, -0.0073028812822061645, -1.0299620471018907, 0.012565430133282795, -0.08142988949901182, -0.3853663217130855, -0.2885821365908365, -0.17184456619521907, -0.02659031013219311, 0.11648397485291262, 0.09594233655771915, 0.5201549242798567, 0.13260649501203028, -0.013525829731370351, -0.24248610677348378], [-0.0004402852215407231, 0.00010594252915674866, 0.0025292612947524573, -0.004348345227194121, -0.012686052063735376, -0.01325482569976985, -0.004112618406792315, -0.0128611072444438, -0.01923821597363135, -0.000922760592778821, -0.0014129970664658368, -0.0008602522149121048, -0.16121198376920884, 0.10532296564478448, 1.1232052775072625, -0.36333292394476774, -1.1790554288599409, -0.6830193599673599, 0.07298607496270307, -0.1761850678058798, -1.7290584174816865, -0.06456593813118855, 0.35999305051041813, 0.8235246085221587, -0.26690710673417717, 0.19082089398198898, 1.9141183651533433, -0.15789651189695453, -1.2084362662550803, -0.7462174561028684, 0.6933131732544189, 0.7041749226502182, -2.3725468737072886, -0.0073028812822061645, 0.795479024104949, 1.510283924942032, -0.05923309750038561, 0.04518907792387757, 0.43443536355664225, 0.04714303011121927, -0.1441691748822912, -0.12470520731616756, 0.2599784353669056, 0.3234098044421903, -0.47441192659003406, 0.016853739011947602, 0.21031041239025347, 0.35521573407752743], [-0.001768090719667271, 0.003027448292332853, 0.016283780681146578, 0.016159779004189714, 0.0008125033869486308, -0.04838770329658267, 0.022530457580892282, -0.002678949972016737, -0.07881715316102203, 0.0022186054129305676, 0.0022756461567668414, 0.00176963820787755, -0.8332624135227253, 1.2449326900528739, 7.022221933512094, 0.31858114180236397, -0.32786543310241506, -2.771049496473017, 1.2389586058083006, -1.6531189560799366, -9.607858471940835, -0.578718990081737, 0.9004355712413108, 5.21116045480623, -1.418133688675216, 2.1116095893161653, 11.929048579245926, 0.3812271382210498, -0.73391442895758, -4.604469723069415, 1.8770893293869169, -2.9721549274743713, -15.896289422682703, -1.0299620471018907, 1.510283924942032, 8.984987395645343, -0.3210884149582487, 0.47799792299584215, 2.7012860449320537, 0.10827719149047303, -0.19733307827829133, -1.1714648277123842, 0.44811649075307786, -0.7029606447337627, -3.713653180594948, -0.2302250944007096, 0.33865112221410154, 2.0252321519002345], [0.00011002588788071779, -0.00010886297890125356, -0.0006946427351675109, -0.0002659317591376962, 0.00010338966669746871, 0.001252810185324742, -0.0006936719566203669, 0.0001998222970941361, 0.0023993784979026915, -6.408919086202954e-05, -7.736185574523618e-05, -0.00022616424861147315, 0.04875959107300487, -0.046593075401096876, -0.30168616339097093, 0.03004786378989824, 0.019982191778712893, 0.07773039405236597, -0.12198592103288014, 0.06468000319620922, 0.508424829115905, 0.0027711753666063645, -0.03464046340583311, -0.17741621157189, 0.0835699938495361, -0.07941097072867861, -0.5152838290538061, 0.08785856130505271, 0.029896093680779556, 0.030471788435086706, -0.1630826999633707, 0.10684762286329523, 0.7495071259536498, 0.012565430133282795, -0.05923309750038561, -0.3210884149582487, 0.019066831512446675, -0.01803939525330742, -0.1172465730424581, 0.026344077845707654, 0.006132710773204457, -0.01036785322419879, -0.029227108190280533, 0.023744374654884513, 0.1503636557766155, 0.004225871329735366, -0.013482981786929334, -0.076140129791499], [-9.846310424189067e-05, 0.0001391651932324947, 0.0007731565848536022, 0.0007759999557647077, -2.9348421940590295e-06, -0.002098638356874536, 0.0009331600046148591, -0.0002593827882226273, -0.002912814770214253, 3.5256710651052405e-05, 6.403809262579859e-05, 0.00034300592562205455, -0.045713073322038215, 0.05928745956865314, 0.33804746359486115, 0.07045338659363626, 0.014154090465145083, -0.24783962222587474, 0.08207174120895255, -0.10151431602043005, -0.5039238441675532, -0.04015703351997365, 0.026665527056707432, 0.2649342548078495, -0.07876450976320826, 0.10099500794117885, 0.5778268033504859, 0.05937297854479671, 0.026522541536330418, -0.28126497577709025, 0.06588351686596562, -0.17189122407041887, -0.6958676824166897, -0.08142988949901182, 0.04518907792387757, 0.47799792299584215, -0.01803939525330742, 0.022934135887773138, 0.13154923794503556, 0.003105000658167236, 0.006392915345796769, -0.04010473448674716, 0.0022969500850659303, -0.03889419057298364, -0.1305348037258818, -0.020725626165833688, 0.010218089282928541, 0.1130752707223757], [-0.0007310199566177435, 0.0007988437776384461, 0.005059454406676594, -0.0007181686563468929, -0.0004676151807754467, -0.0007186430945330593, -0.0004224990762299681, -0.0010811288144496802, -0.004230376911604437, -0.0008147643826072221, 0.0006366176428350864, 0.0044317396116419615, -0.30342984577531595, 0.34011512812377426, 2.13940538063807, 0.11667336273980529, -0.14027861532795902, -0.8300108261169374, 0.3992838840454274, -0.4571335030586385, -2.8756638792805864, -0.2303209565248962, 0.2570383326753649, 1.6032337578043412, -0.5164347868897287, 0.5793354220764666, 3.643316854195908, 0.2118321875247337, -0.23103324140458356, -1.40612353248594, 0.7064694451721565, -0.7822606980900981, -4.969441628348622, -0.3853663217130855, 0.43443536355664225, 2.7012860449320537, -0.1172465730424581, 0.13154923794503556, 0.8272343929426819, 0.047262839314568324, -0.051316066186994316, -0.3132920195873148, 0.1610078528366795, -0.1784001666960685, -1.1341207222457752, -0.08704463561608476, 0.09806208896180987, 0.6096340035399405], [4.236559528038156e-05, 8.93342168369638e-06, 0.00018791320195145486, -0.005169708074364335, -0.0016400015742608026, -0.011695299370441174, -0.008602060151030634, -0.002081388618649587, -0.01655705233949666, -0.0018342983201926036, -0.00034483509254598416, -0.0029573640051397546, 0.05701003191605122, 0.009588513908256418, 0.12732541201207867, 0.18753718928448593, -0.03259013578325165, 0.0027952402007855245, -0.7301387814510569, 0.02462352571486568, -0.31176827837366633, -0.25595243241265947, 0.028678610798248523, 0.029316893782750455, 0.10775055449583212, 0.0150545127661359, 0.21322721579757206, 0.9842682888898993, -0.08422877105211628, 0.12573260283017193, -0.42352107719233056, 0.021490741454473553, -0.28036192623977874, -0.2885821365908364, 0.04714303011121927, 0.10827719149047303, 0.026344077845707654, 0.003105000658167236, 0.047262839314568324, 0.341153677202981, -0.030670467047857752, 0.011732512285852025, 0.049099302814613686, -0.007013220692150733, -0.06836040479141399, -0.03940499385238031, 0.0088759510277825, 0.025842504203733244], [0.00011119272201060106, -7.529904675363764e-05, -0.0001826026542450867, 0.003912673434993302, -0.005174730199758426, 0.014723378911837929, 0.003703640695056142, -0.007253328132601471, 0.020216745314341634, 0.000503136673137595, -0.0014639199074188728, 0.0035505795405105615, 0.024473612618367523, 0.006019892984344729, -0.13788318262324695, 0.4336470220876638, -0.03490570360184998, 0.12002302273928928, 0.11760167377441355, -0.4728124454028749, 0.3241482463868545, -0.03982195028775898, -0.1609550724450424, -0.06857464873793644, 0.03356870403585283, 0.020351184505580905, -0.23138918550469056, 0.2579233601520345, 0.539212034411133, 0.0091619139000821, -0.3845738385824087, -0.07570702580086915, 0.19140041604876026, -0.17184456619521907, -0.1441691748822912, -0.19733307827829133, 0.006132710773204457, 0.006392915345796769, -0.051316066186994316, -0.030670467047857752, 0.22824074831278596, 0.013307918095101377, -0.19623273485313178, 0.11199118746024696, 0.03835424759117168, -0.05843417000035797, -0.00969126360042812, -0.04820770454254474], [-0.00033017204230360376, -9.72143390599144e-05, -0.001367342969352643, -0.021633853208403418, 0.015624514021049479, 0.07556563523015532, -0.028222010844645165, 0.02142466269329556, 0.10564143872318568, -0.005351477866204119, 0.0038681275241580523, 0.018431384141371288, -0.023344232590322707, -0.11000244416117476, -0.8605094653814997, -0.034951402883715135, 0.03209939060845714, 0.23640638670470518, -0.11993983881088874, 0.26568289452951993, 1.3387882856691018, -0.06274262754876636, -0.0356165685269085, -0.5515304045192153, -0.04057721819401432, -0.1830777023662162, -1.4261524350904407, 0.17623704799574222, -0.07141853520935139, 0.3736267064532889, 0.17554989720292538, 0.1811194777308354, 1.5183445647320104, -0.02659031013219311, -0.12470520731616756, -1.1714648277123842, -0.010367853224198793, -0.04010473448674716, -0.3132920195873148, 0.011732512285852025, 0.013307918095101377, 0.3472728344102068, 0.01856185761418214, 0.05933611661688867, 0.5537104639248283, -0.00803031775304622, -0.02744069541368014, -0.24347120472864633], [-0.0002745326130551155, 1.6243583447272795e-05, 0.0006835770014409054, -0.0063453055431204825, -0.00041508284583501883, -0.01661629900938312, -0.006858936913201831, 0.0010704435418440147, -0.02116379937236842, -0.0012435067079180507, 0.0005264548469611694, -0.0028387841773392427, -0.08429804862336324, 0.009677595245572901, 0.41033043927089935, -0.46528573061400236, -0.2195745980387456, -0.16453092391715474, -0.08584458959619139, 0.32517689156584406, -0.7525784122501401, -0.00904594429844617, 0.18953792948921475, 0.23365382474077073, -0.1351803031010901, 0.013207557256884581, 0.7065444239534983, -0.22175929542244907, -0.6311637717062699, 0.04279925036615316, 0.5744574623334876, 0.21841002671486656, -0.9483356358237565, 0.11648397485291262, 0.2599784353669056, 0.44811649075307786, -0.029227108190280533, 0.0022969500850659303, 0.1610078528366795, 0.049099302814613686, -0.19623273485313178, 0.018561857614182137, 0.25592227797457145, -0.018811047007192667, -0.21564755975887998, 0.049400283647532774, 0.04629870675456822, 0.10001369777232025], [9.066926866225298e-05, -0.0004621388098736164, -0.0007178235224024768, -0.003116931234377098, -0.014608628123709763, 0.02124146575167523, -0.003780689603353154, -0.016046251485662487, 0.02581393000162349, -0.0005049582733596601, -0.002762590223826431, 0.0033444494491848753, 0.060122803054841564, -0.12032919176108596, -0.4529453233946507, -0.07112864515613006, -1.039571847170271, 0.4838407728685343, -0.10310532528100871, -0.3019475907980721, 0.7459129259507988, 0.04906282325715469, 0.016935319707925462, -0.36772785405949493, 0.10395557489355026, -0.18587439957890017, -0.7817703154879563, -0.04964172185390252, -0.48663835398476135, 0.36413951114715043, -0.09794496751174692, 1.1007206227091302, 0.7798057894062153, 0.09594233655771915, 0.3234098044421903, -0.7029606447337627, 0.023744374654884513, -0.03889419057298364, -0.1784001666960685, -0.007013220692150733, 0.11199118746024696, 0.05933611661688867, -0.018811047007192667, 0.5296453612686733, 0.16151509467573155, 0.022128924926409044, 0.12443288692098045, -0.16042792797346675], [0.0006427548120546495, -0.0003051956439231579, -0.005125541476245264, -0.01547916163272831, 0.028141187909097837, 0.10002513430072493, -0.019062143802856046, 0.03439895818338734, 0.12420211288632493, -0.002393205017233301, 0.0052496711181010645, 0.014727897525892245, 0.3851321897552119, -0.33004242750866647, -2.915488789591385, -0.2302388563335931, 0.3097610418629734, 1.2225681686923817, -0.5525350487023832, 0.583870045801683, 3.9475802113901204, 0.2964450264006203, -0.24179461920130177, -2.1976874859415707, 0.6614035374485748, -0.5726871860932807, -4.9951988323512, -0.22141199302051442, 0.11411954489074543, 1.4679355677431578, -0.799218082409425, 0.5742291598424911, 6.4690342142483415, 0.5201549242798567, -0.47441192659003406, -3.713653180594948, 0.1503636557766155, -0.1305348037258818, -1.1341207222457752, -0.06836040479141399, 0.03835424759117168, 0.5537104639248283, -0.21564755975887998, 0.16151509467573155, 1.8273945219640377, 0.11020436699609383, -0.09986279311229405, -0.7659037404746869], [1.3096607864821178e-05, -0.00012164970968053134, -0.0005930642381479451, -0.001345097446135613, 0.00038745121264281734, -0.0017526767401245902, -0.0011434282419838023, 0.0011683930400471089, -0.0008773345279784622, -6.527130281484242e-05, 0.00019692815427645253, -0.0005587746704335233, 0.009907601609387294, -0.05253525547548496, -0.22693053835789812, -0.1879178934918321, -0.05071604551550229, 0.027269350073556665, 0.015951035049092167, 0.1898243894639806, 0.38470147715994457, 0.06592552935437829, 0.02360034112291783, -0.12454836995859789, 0.017866890618711644, -0.09043556213160371, -0.3843726261138704, -0.2360083422207263, -0.17995515509385057, 0.018640742874047173, 0.13645697392533152, 0.1992666012584846, 0.5810921540130622, 0.13260649501203028, 0.016853739011947602, -0.2302250944007096, 0.004225871329735366, -0.020725626165833688, -0.08704463561608476, -0.03940499385238031, -0.05843417000035797, -0.00803031775304622, 0.049400283647532774, 0.022128924926409044, 0.11020436699609383, 0.0335312494018089, -0.0005033040983922654, -0.05697465873981299], [-0.00010823662746290207, 6.8680575066160904e-06, 0.0006693336129937832, -0.0012829298100031732, -0.004132606534090268, 0.0017265469540823262, -0.001296221973771506, -0.004429015293890231, 0.00108033181948847, -0.0002782862279744053, -0.0005817131655759338, 0.0007293469305245457, -0.03649196592325144, 0.02172698181298379, 0.25560446206284143, -0.057464479137249, -0.363642267458889, -0.13550363581601937, 0.02559719787997702, -0.10779332658672498, -0.3852078906086473, -0.01762031637612752, 0.07863538888692286, 0.18535280515294386, -0.06051911238499912, 0.04155131992680754, 0.4329727308171767, -0.016797685158768096, -0.2908131554639107, -0.1901623737398128, 0.1385994935739713, 0.233368053556799, -0.5593713699848575, -0.013525829731370351, 0.21031041239025347, 0.33865112221410154, -0.013482981786929334, 0.010218089282928541, 0.09806208896180987, 0.0088759510277825, -0.00969126360042812, -0.02744069541368014, 0.04629870675456822, 0.12443288692098045, -0.09986279311229405, -0.0005033040983922654, 0.06083334726832687, 0.08269999014934859], [-0.0005164164620488858, 0.0008312587537084419, 0.004264377005787037, -0.0010306239415831845, 0.005954445979834542, 0.017077348886850047, -0.00032874401278984135, 0.006090737686377534, 0.014308404558084978, -0.0004517296094016158, 0.001698441690932547, 0.0058551519465018815, -0.1994466664065835, 0.29676975933855093, 1.596211277843376, 0.05730051329491392, -0.05400511571519754, -0.5598781694547956, 0.2842566294217974, -0.3768284679554181, -2.1818276159821592, -0.13822457937363686, 0.21486142826094337, 1.1672513723363274, -0.3370258805047406, 0.5004614642312606, 2.6968225954599134, 0.11568039736261158, -0.20502287800548652, -1.1672507836844594, 0.46953179356020375, -0.7331664366987459, -3.6970002461186917, -0.24248610677348378, 0.35521573407752743, 2.0252321519002345, -0.076140129791499, 0.1130752707223757, 0.6096340035399405, 0.025842504203733244, -0.04820770454254474, -0.24347120472864633, 0.10001369777232025, -0.16042792797346675, -0.7659037404746869, -0.05697465873981299, 0.08269999014934859, 0.47867507696642303]]}


@pytest.fixture
def element():
    nodes = []
    for ref_location, act_location in zip(DATA['ref_locations'], DATA['act_locations']):
        node = eq.Node()
        node.ref_location = ref_location
        node.act_location = act_location
        nodes.append(node)

    shape_functions = DATA['shape_functions']

    weight = DATA['weight']

    return Shell3P(nodes, shape_functions, 1, 1, 0.0, weight)


def test_element(element):
    f, g, h = element.compute_all()

    assert_almost_equal(element.dm, DATA['Dm'])
    assert_almost_equal(element.db, DATA['Db'])
    assert_almost_equal(element.tm, DATA['Tm'])

    assert_almost_equal(f, DATA['exp_f'])
    assert_almost_equal(g, DATA['exp_g'])
    assert_almost_equal(h, DATA['exp_h'])
