from unittest import TestCase, skip

from bitcoinlib.transactions import Transaction

from bitcoin.tx_extractors.bitcoin_rpc import BitcoinRPCAddressDataExtractor


class TestBitcoinRPCAddressDataExtractor(TestCase):
    @skip("This test is being ignored.")
    def test_extract(self):
        hex = "02000000000101f2a69b3ac92464aa2783b27b4e680339aaf568a2f2dfb57b35514ead52a68c200000000000fdffffff0188a6a30000000000160014e19cffc3dac9b6db7dbcbfb33b0dbdbe3bb1282b02473044022079d28834e1b49fe68d49abc61ed9e42cb3975e90e20224c9b81eba7836c9d1d302205e42205de0380a16aae83a9d73f8950e7cbbc051d345d1a2d281680831b2a0aa0121025165993582dc7d93ac11fd5bb3eabd721acdddf94c94f58008f157c3b7bbaa6400000000"
        tx = Transaction.parse_hex(hex, strict=False)
        tx_id = tx.txid
        print(tx_id)
        for intput in tx.inputs:
            prev_tx = intput.prev_txid;
            prev_tx_id_hex = prev_tx.hex();
            print(prev_tx_id_hex);
            print(intput.output_n_int);
        bitcoin_rpc_address_data_extractor = BitcoinRPCAddressDataExtractor()
        address_tx_data = bitcoin_rpc_address_data_extractor.extract(tx)
        self.assertEqual(len(address_tx_data), 2)

    @skip("This test is being ignored.")
    def test_extract_marketplace_tx(self):
        hex = "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"
        tx = Transaction.parse_hex(hex, strict=False)
        tx_id = tx.txid;
        print(tx_id);
        bitcoinrpc_address_data_extractor = BitcoinRPCAddressDataExtractor()
        address_tx_data = bitcoinrpc_address_data_extractor.extract(tx)
        self.assertEqual(len(address_tx_data), 16)

