FUNC_DESC = dict()

FUNC_DESC['资产'] = '''
函数功能: 根据资产标签，筛选相应资产明细。并根据需要提取的字段，提取资产类指标。
参数列表:
    1. 资产标签列表([list]): 资产标签列表
    2. 资产指标列表([list]): 资产和持仓相关指标列表
    3. 穿透(string)：表示需要穿透至资管计划持仓, 该参数为可选参数，当不指定该参数时为不穿透情况
返回数据: 包含基本字段及所选字段的二维表格数据
示例程序:
    >>> 所有资产 = 资产([], ['全价市值', '剩余期限（天）'])
    >>> 回购持仓_明细 = 资产(['质押式回购', '买断式回购'], ['剩余期限（天）'], '穿透')
    >>> 逆回购持仓 = 资产(['逆回购'], ['全价市值'])
'''

FUNC_DESC['产品'] = '''
函数功能: 根据产品标签，筛选相应产品明细。并根据需要提取的字段，提取产品类指标。
参数列表:
    1. 产品标签列表([list]): 产品标签列表
    2. 产品指标列表([list]): 产品相关指标列表
返回数据: 包含基本字段及所选字段的二维表格数据
示例程序:
    >>> 所有产品 = 产品([], ['当日净资产', '上一日净资产'])
    >>> 公募产品 = 产品(['公募产品'], ['上一日净资产'])
'''

FUNC_DESC['指标'] = '''
函数功能: 根据金融指标库、指标库下相关指标列表和参数条件提取的指标数据。
参数列表:
    1. 金融指标库名称(string): 金融指标库名称
    2. 指标列表([list]): 所选金融指标库下的指标列表
    3. 参数列表([list]): 查询是需要代入的参数
返回数据: 包含基本字段及所选字段的二维表格数据
示例程序:
    >>> 产品指标 = 指标(['估值汇总指标库'], ['产品代码', '日期', '总资产', '净资产'], {'port_tags': ['公募产品'], 'start_date': '2024-11-24'})
    >>> 资产指标 = 指标(['估值明细指标库'], ['产品代码', '资产代码', '资产简称', '持仓市值'], {'port_tags': ['公募产品'], 'asset_tags': ['债券']})
'''

FUNC_DESC['agg'] = '''
函数功能: 将一个表格数据按照某几个字段进行分组后，将指定字段进行聚合计算。
参数列表:
    1. 表格变量: 需要分组聚合的目标表格变量
    2. 分组字段列表([list]): 分组字段列表
    3. 聚合计算方式({dict}): 需要进行聚合字段的计算方式，计算方式可以选择sum, count, mean, max, min
    4. 分组后重命名列表: 重命名列表 
返回数据: 分组聚合后的二维表格数据
示例程序:
    >>> 公募产品聚合 = agg(公募产品, ['产品代码', '产品简称'], {'当日净资产': 'sum', '上一日净资产': 'mean'})
    >>> 债券类资产聚合 = agg(债券明细, ['产品代码', '产品简称', '资产代码'], {'全价市值': 'sum', '当日净资产': 'first'}, {'全价市值': '聚合后市值'})
'''

FUNC_DESC['select'] = '''
函数功能: 从一个表格数据中提取相应字段数据。
参数列表:
    1. 表格变量: 目标表格变量
    2. 提取字段列表([list]): 提取字段列表 
返回数据: 提取后字段后的表格数据，注意：除了包含指定提取的字段外，也包括产品代码、产品名称、资产代码、资产名称、日期等基础字段
示例程序:
    >>> 选择后公募产品 = select(公募产品, ['当日净资产', '总资产'])
    >>> 选择后债券类资产 = select(债券类资产, ['估值类型', '全价市值'])
'''

FUNC_DESC['merge'] = '''
函数功能: 将两个表格数据进行关联处理
参数列表:
    1. 表格变量1: 第一个表格变量 
    2. 表格变量2: 第二个表格变量
    3. 关联列表([list]): 关联字段列表，注意列表中的字段必须同时存在于两个表格变量中
    4. 关联方式(string): left - 左关联; right - 右关联; inner - 内关联; outer - 全关联  
返回数据: 返回关联后的表格数据
示例程序:
    >>> 选择后公募产品 = merge(债券明细, 现金类产品, ['产品代码', '产品简称'], 'left')
'''

FUNC_DESC['filter'] = '''
函数功能: 根据相应的筛选条件，选择表格数据中符合筛选条件的行生成新的表格数据
参数列表:
    1. 表格变量: 目标表格数据变量 
    2. 筛选条件(string): 注意 筛选条件中指明的字段必须在目标表格变量中
    3. 关联列表([list]): 关联字段列表，注意列表中的字段必须同时存在于两个表格变量中
    4. 关联方式(string): left - 左关联; right - 右关联; inner - 内关联; outer - 全关联  
返回数据: 返回关联后的表格数据
示例程序:
    >>> 选择后债券明细 = filter(债券明细, '全价市值 > 3000000')
    >>> 选择后债券明细 = filter(债券明细, '(全价市值 > 3000000) & (全价市值 > 5000000)')
    >>> 选择后债券明细 = filter(债券明细, '(剩余期限 > 100) ｜ (信用债 == "是")')
'''

FUNC_DESC['alias'] = '''
函数功能: 将表格数据中的某一列进行重新命名
参数列表:
    1. 表格变量: 目标表格数据变量 
    2. 新字段名: 改变后的字段名称
    3. 旧字段名: 改变前的字段名称，注意：当不提供旧字段名，语言会根据表格中通过四则运算后的字段进行命名
返回数据: 返回关联后的表格数据
示例程序:
    >>> 命名后债券明细 = alias(债券明细, '市值', '全价市值')
    >>> 四则运算后明细 = alias(债券明细.数量 * 债券明细.价格, '计算后市值')
'''