---
title: 2 - Creating a Basic Star Chart | Tutorial 
---

<div class="flex-space-between tutorial-top-nav" markdown>
  [:octicons-arrow-left-24: Previous](01.md){ .text-right }

  [Tutorial Home](/tutorial)

  [Next :octicons-arrow-right-24:](03.md){ .text-right }
  <br/>
</div>

# 2 - Creating a Basic Star Chart

<figure markdown="span">
  ![Tutorial - Basic Star Chart](/images/tutorial/tutorial_02.png){ width="600" }
</figure>

Let's begin our starplotting journey by creating a basic star chart that shows the entire sky at a specific time and place, like the chart above. Starplot calls these "Zenith" plots because the zenith is in the center of the chart.

Here's a look at the code to create the zenith chart above, which shows the sky as seen from [Palomar Mountain](https://en.wikipedia.org/wiki/Palomar_Mountain) in California on July 13, 2023 at 10pm PT:

<div class="tutorial">
```python  linenums="1"
--8<-- "tutorial/tutorial_02.py"
```
</div>

In the first few lines, we just import all the stuff we need.

Next, we create a `datetime` for our plot, which includes the timezone. **All `datetime` values in Starplot need to be timezone-aware.** An exception will be raised if you try to pass a naive datetime.

On line 9, we create an `Observer` which represents a specific time and place on Earth.

Once we have an observer defined, we create the [`ZenithPlot`][starplot.ZenithPlot] instance with a few parameters:

- `observer`: Observer instance that specifies time and location
- `resolution`: Resolution (in pixels) of the widest dimension of the plot
- `scale`: This controls the sizing of all text and markers. At scale `1.0` everything is optimized for a basic map of 1-3 constellations, so if you're plotting a larger area (or just want everything smaller), then it's a good idea to decrease the scale so the plot isn't too crowded.

When you create a plot instance, initially it'll be empty (i.e. it won't have any stars or constellations). In Starplot, you have to explicitly plot all objects.

So, on line 20 we start by plotting the constellation lines. We plot these _first_, because Starplot can use the constellation lines to automatically find good places to plot object labels.

Next, we plot stars with a limiting magnitude of 4.6 by passing the `where` argument (you'll learn more about this feature later in the tutorial). Notice how none of the star names in the plot cross over a constellation line? That's because we plotted the constellation lines _before_ plotting the stars.

After the stars, we plot the horizon, which is the border around the plot with the cardinal direction labels.

Lastly, we plot the constellation labels. As mentioned earlier, it's good to plot these last because they're area-based labels (vs point-based, like for star names), and area-based labels have more freedom to move around. If you plot area-based labels first, then it would limit the available space for point-based labels.

Once we're done plotting, we export the plot to a PNG file. Starplot also supports exporting to SVG and JPEG.

*In the [next section](03.md), we'll learn how to add some styles and other objects to the plot...*

---
<div class="flex-space-between" markdown>

[:octicons-arrow-left-24: Previous](01.md){ .md-button .text-right }

[Tutorial Home](/tutorial)

[Next :octicons-arrow-right-24:](03.md){ .md-button .text-right }

</div>
