---
title: 7 - Object Lookup | Tutorial 
---

<div class="flex-space-between tutorial-top-nav" markdown>
  [:octicons-arrow-left-24: Previous](06.md){ .text-right }

  [Tutorial Home](/tutorial)

  [Next :octicons-arrow-right-24:](08.md){ .text-right }
  <br/>
</div>

# 7 - Object Lookup

<figure markdown="span">
  ![Tutorial - Object Lookup](/images/tutorial/tutorial_07.png){ width="600" }
</figure>

Starplot has [models](/reference-models/) for most objects you can plot, including stars, DSOs, planets, moons, and the Sun. These models also have properties relevant to each object (e.g. magnitude, ra, dec, etc). Sometimes you may want to create a plot directly from an object, so Starplot has a way to lookup objects by using each model's `get()` or `find()` functions.

For example, here's a way to get Jupiter's position for tonight's sky and then create an optic plot directly from the Planet instance:
<div class="tutorial" markdown>
```python linenums="1"
--8<-- "tutorial/tutorial_07.py"
```
</div>

### More Examples

Get all the planets:
```python
planets = Planet.all()
```

Get all the stars with limiting magnitude 6:
```python
stars = Star.find(where=[_.magnitude <= 6])
```

Get the Hercules Globular Cluster (M13):
```python
m13 = DSO.get(m="13")
```

*In the [next section](08.md), we'll learn how to use callables to dynamically define the style of stars...*

---
<div class="flex-space-between" markdown>

[:octicons-arrow-left-24: Previous](06.md){ .md-button .text-right }

[Tutorial Home](/tutorial)

[Next :octicons-arrow-right-24:](08.md){ .md-button .text-right }

</div>
