"""Linear operators (such as FourierOp), functionals/loss functions, and qMRI signal models."""

from mrpro.operators.Operator import Operator
from mrpro.operators.LinearOperator import LinearOperator
from mrpro.operators.Functional import FunctionalType, ProximableFunctional, ElementaryFunctional, ElementaryProximableFunctional, ScaledProximableFunctional
from mrpro.operators import functionals, models
from mrpro.operators.AveragingOp import AveragingOp
from mrpro.operators.CartesianSamplingOp import CartesianSamplingOp, CartesianMaskingOp
from mrpro.operators.ConjugateGradientOp import ConjugateGradientOp
from mrpro.operators.ConstraintsOp import ConstraintsOp
from mrpro.operators.DensityCompensationOp import DensityCompensationOp
from mrpro.operators.DictionaryMatchOp import DictionaryMatchOp
from mrpro.operators.EinsumOp import EinsumOp
from mrpro.operators.FastFourierOp import FastFourierOp
from mrpro.operators.FiniteDifferenceOp import FiniteDifferenceOp
from mrpro.operators.FourierOp import FourierOp
from mrpro.operators.GridSamplingOp import GridSamplingOp
from mrpro.operators.IdentityOp import IdentityOp
from mrpro.operators.Jacobian import Jacobian
from mrpro.operators.LinearOperatorMatrix import LinearOperatorMatrix
from mrpro.operators.MagnitudeOp import MagnitudeOp
from mrpro.operators.MultiIdentityOp import MultiIdentityOp
from mrpro.operators.NonUniformFastFourierOp import NonUniformFastFourierOp
from mrpro.operators.OptimizerOp import OptimizerOp
from mrpro.operators.PatchOp import PatchOp
from mrpro.operators.PCACompressionOp import PCACompressionOp
from mrpro.operators.PhaseOp import PhaseOp
from mrpro.operators.ProximableFunctionalSeparableSum import ProximableFunctionalSeparableSum
from mrpro.operators.RearrangeOp import RearrangeOp
from mrpro.operators.SensitivityOp import SensitivityOp
from mrpro.operators.SignalModel import SignalModel
from mrpro.operators.SliceProjectionOp import SliceProjectionOp
from mrpro.operators.WaveletOp import WaveletOp
from mrpro.operators.ZeroPadOp import ZeroPadOp
from mrpro.operators.ZeroOp import ZeroOp


__all__ = [
    "AveragingOp",
    "CartesianMaskingOp",
    "CartesianSamplingOp",
    "ConjugateGradientOp",
    "ConstraintsOp",
    "DensityCompensationOp",
    "DictionaryMatchOp",
    "EinsumOp",
    "ElementaryFunctional",
    "ElementaryProximableFunctional",
    "FastFourierOp",
    "FiniteDifferenceOp",
    "FourierOp",
    "FunctionalType",
    "GridSamplingOp",
    "IdentityOp",
    "Jacobian",
    "LinearOperator",
    "LinearOperatorMatrix",
    "MagnitudeOp",
    "MultiIdentityOp",
    "NonUniformFastFourierOp",
    "Operator",
    "OptimizerOp",
    "PCACompressionOp",
    "PatchOp",
    "PhaseOp",
    "ProximableFunctional",
    "ProximableFunctionalSeparableSum",
    "RearrangeOp",
    "ScaledProximableFunctional",
    "SensitivityOp",
    "SignalModel",
    "SliceProjectionOp",
    "WaveletOp",
    "ZeroOp",
    "ZeroPadOp",
    "functionals",
    "models"
]