# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_all_task_defs.sql
import dataclasses
from typing import AsyncIterator, Iterator

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_ALL_TASK_DEFS = """-- name: get_all_task_defs \\:many
SELECT task_name, cron_expr, source_code, arg_schema, queue, priority, max_retries, timeout_seconds, last_updated FROM hyrex_task_def
ORDER BY task_name
"""


@dataclasses.dataclass()
class GetAllTaskDefsParams:

    pass

class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_all_task_defs(self, arg: GetAllTaskDefsParams) -> Iterator[models.HyrexTaskDef]:
        result = self._conn.execute(sqlalchemy.text(GET_ALL_TASK_DEFS))
        for row in result:
            yield models.HyrexTaskDef(
                task_name=row[0],
                cron_expr=row[1],
                source_code=row[2],
                arg_schema=row[3],
                queue=row[4],
                priority=row[5],
                max_retries=row[6],
                timeout_seconds=row[7],
                last_updated=row[8],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_all_task_defs(self, arg: GetAllTaskDefsParams) -> AsyncIterator[models.HyrexTaskDef]:
        result = await self._conn.stream(sqlalchemy.text(GET_ALL_TASK_DEFS))
        async for row in result:
            yield models.HyrexTaskDef(
                task_name=row[0],
                cron_expr=row[1],
                source_code=row[2],
                arg_schema=row[3],
                queue=row[4],
                priority=row[5],
                max_retries=row[6],
                timeout_seconds=row[7],
                last_updated=row[8],
            )
